/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDOutlineDictionary;
import org.verapdf.pd.actions.PDAction;

public class PDOutlineItem
extends PDOutlineDictionary {
    private static final Logger LOGGER = Logger.getLogger(PDOutlineItem.class.getCanonicalName());

    public PDOutlineItem(COSObject obj) {
        super(obj);
    }

    public String getTitle() {
        return this.getStringKey(ASAtom.TITLE);
    }

    public PDOutlineItem getPrev() {
        return this.getOutlineItem(ASAtom.PREV);
    }

    public PDOutlineItem getNext() {
        return this.getOutlineItem(ASAtom.NEXT);
    }

    public PDAction getAction() {
        COSObject action = this.getKey(ASAtom.A);
        if (action != null && action.getType().isDictionaryBased()) {
            return new PDAction(action);
        }
        return null;
    }

    public COSObject getDestination() {
        return this.getKey(ASAtom.DEST);
    }

    public double[] getColor() {
        COSObject arr = this.getKey(ASAtom.C);
        if (arr != null && arr.getType() == COSObjType.COS_ARRAY) {
            if (arr.size() == 3) {
                Double redValue = arr.at(0).getReal();
                Double greenValue = arr.at(1).getReal();
                Double blueValue = arr.at(2).getReal();
                if (redValue == null || greenValue == null || blueValue == null) {
                    LOGGER.log(Level.FINE, "Outline's color contains non number value");
                    return null;
                }
                float red = redValue.floatValue();
                float green = greenValue.floatValue();
                float blue = blueValue.floatValue();
                if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f) {
                    LOGGER.log(Level.FINE, "Outline's color contains wrong value");
                    return null;
                }
                return new double[]{red, green, blue};
            }
            LOGGER.log(Level.FINE, "Outline's color contains not three elements");
            return null;
        }
        return new double[]{0.0, 0.0, 0.0};
    }

    public boolean isItalic() {
        return this.isFlagBitSet(0);
    }

    public boolean isBold() {
        return this.isFlagBitSet(1);
    }

    private boolean isFlagBitSet(int bitNumber) {
        Long f = this.getIntegerKey(ASAtom.F);
        return f != null && (f.intValue() & 1 << bitNumber) != 0;
    }
}

