/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.verapdf.component.Components;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.BatchSummaryImpl;
import org.verapdf.processor.reports.FeaturesBatchSummary;
import org.verapdf.processor.reports.FixerReportImpl;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.MetadataRepairBatchSummary;
import org.verapdf.processor.reports.ValidationBatchSummary;
import org.verapdf.processor.reports.ValidationDetails;
import org.verapdf.processor.reports.ValidationDetailsImpl;
import org.verapdf.processor.reports.ValidationReport;
import org.verapdf.processor.reports.ValidationReportImpl;

public final class Reports {
    private static final String STATEMENT_PREFIX = "PDF file is ";
    private static final String NOT_INSERT = "not ";
    private static final String STATEMENT_SUFFIX = "compliant with Validation Profile requirements.";
    private static final String COMPLIANT_STATEMENT = "PDF file is compliant with Validation Profile requirements.";
    private static final String NONCOMPLIANT_STATEMENT = "PDF file is not compliant with Validation Profile requirements.";

    private Reports() {
        throw new AssertionError((Object)"Should never enter Reports().");
    }

    public static final BatchSummary createBatchSummary(Components.Timer timer, ValidationBatchSummary validationSummary, FeaturesBatchSummary featureSummary, MetadataRepairBatchSummary repairSummary, int totalJobs, int failedToParse, int encrypted, int outOfMemory, int veraExceptions) {
        if (totalJobs < 0) {
            throw new IllegalArgumentException("Argument totalJobs must be >= 0");
        }
        if (failedToParse < 0) {
            throw new IllegalArgumentException("Argument failedToParse must be >= 0");
        }
        if (encrypted < 0) {
            throw new IllegalArgumentException("Argument encrypted must be >= 0");
        }
        if (outOfMemory < 0) {
            throw new IllegalArgumentException("Argument outOfMemory must be >= 0");
        }
        if (veraExceptions < 0) {
            throw new IllegalArgumentException("Argument veraExceptions must be >= 0");
        }
        if (failedToParse + encrypted > totalJobs) {
            throw new IllegalArgumentException("Argument totalJobs must be >= arguments (failedJobs + encrypted)");
        }
        return BatchSummaryImpl.fromValues(timer.stop(), validationSummary, featureSummary, repairSummary, totalJobs, failedToParse, encrypted, outOfMemory, veraExceptions);
    }

    public static final ValidationReport createValidationReport(ValidationDetails details, String profileName, String statement, boolean isCompliant, String jobEndStatus) {
        return ValidationReportImpl.fromValues(details, profileName, statement, isCompliant, jobEndStatus);
    }

    public static final ValidationReport createValidationReport(ValidationResult validationResult, boolean logPassed) {
        ValidationDetails details = Reports.fromValues(validationResult, logPassed);
        return Reports.createValidationReport(details, validationResult.getProfileDetails().getName(), Reports.getStatement(validationResult.isCompliant()), validationResult.isCompliant(), validationResult.getJobEndStatus().getValue());
    }

    private static String getStatement(boolean status) {
        return status ? COMPLIANT_STATEMENT : NONCOMPLIANT_STATEMENT;
    }

    public static final ValidationReport validationReportFromXml(String xmlSource) throws JAXBException {
        return (ValidationReport)XmlSerialiser.typeFromXml(ValidationReportImpl.class, xmlSource);
    }

    public static final ValidationDetails fromValues(ValidationResult result, boolean logPassedChecks) {
        return ValidationDetailsImpl.fromValues(result, logPassedChecks);
    }

    public static final MetadataFixerReport fromValues(String status, int fixCount, List<String> fixes, List<String> errors) {
        return FixerReportImpl.fromValues(status, fixCount, fixes, errors);
    }

    public static final ValidationDetails fromValues(ValidationResult result, boolean logPassedChecks, int maxFailedChecks) {
        return Reports.fromValues(result, logPassedChecks);
    }

    public static final MetadataFixerReport fromValues(MetadataFixerResult fixerResult) {
        return FixerReportImpl.fromValues(fixerResult);
    }
}

