/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.impl;

class HelperScriptFactory {
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_NS = new JsHelperFunction[]{new JsHelperFunction("isPlainHostName", new String[]{"host"}, Boolean.class), new JsHelperFunction("dnsDomainIs", new String[]{"host", "domain"}, Boolean.class), new JsHelperFunction("localHostOrDomainIs", new String[]{"host", "hostdom"}, Boolean.class), new JsHelperFunction("isResolvable", new String[]{"host"}, Boolean.class), new JsHelperFunction("isInNet", new String[]{"host", "pattern", "mask"}, Boolean.class), new JsHelperFunction("dnsResolve", new String[]{"host"}, String.class), new JsHelperFunction("myIpAddress", new String[0], String.class), new JsHelperFunction("dnsDomainLevels", new String[]{"host"}, Integer.class), new JsHelperFunction("shExpMatch", new String[]{"str", "shexp"}, Boolean.class), new JsHelperFunction("weekdayRange", new String[]{"wd1", "wd2", "gmt"}, Boolean.class), new JsHelperFunction("dateRange", new String[]{"day1", "month1", "year1", "day2", "month2", "year2", "gmt"}, Boolean.class), new JsHelperFunction("timeRange", new String[]{"hour1", "min1", "sec1", "hour2", "min2", "sec2", "gmt"}, Boolean.class)};
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_MS = new JsHelperFunction[]{new JsHelperFunction("isResolvableEx", new String[]{"host"}, Boolean.class), new JsHelperFunction("isInNetEx", new String[]{"host", "ipPrefix"}, Boolean.class), new JsHelperFunction("dnsResolveEx", new String[]{"host"}, String.class), new JsHelperFunction("myIpAddressEx", new String[0], String.class), new JsHelperFunction("sortIpAddressList", new String[]{"ipAddressList"}, String.class), new JsHelperFunction("getClientVersion", new String[0], String.class)};
    private static final JsHelperFunction[] JS_HELPER_FUNCTIONS_DEBUG = new JsHelperFunction[]{new JsHelperFunction("alert", new String[]{"txt"}, Void.class)};

    private HelperScriptFactory() {
    }

    public static String getPacHelperSource() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("(function(self) {\n");
        HelperScriptFactory.addFunctionDecls(sb, JS_HELPER_FUNCTIONS_NS);
        HelperScriptFactory.addFunctionDecls(sb, JS_HELPER_FUNCTIONS_MS);
        HelperScriptFactory.addFunctionDecls(sb, JS_HELPER_FUNCTIONS_DEBUG);
        sb.append("})\n");
        return sb.toString();
    }

    private static void addFunctionDecls(StringBuilder sb, JsHelperFunction[] jsHelperFunctions) {
        for (JsHelperFunction f : jsHelperFunctions) {
            sb.append("this['");
            sb.append(f.functionName);
            sb.append("'] = function(");
            HelperScriptFactory.addArgList(sb, f.argList);
            sb.append(") {\n");
            sb.append("    return ");
            boolean encloseReturnValue = false;
            if (Number.class.isAssignableFrom(f.getClass())) {
                encloseReturnValue = true;
                sb.append("Number(");
            }
            if (f.returnType == String.class) {
                encloseReturnValue = true;
                sb.append("String(");
            }
            sb.append("self.");
            sb.append(f.functionName);
            sb.append('(');
            HelperScriptFactory.addArgList(sb, f.argList);
            sb.append(')');
            if (encloseReturnValue) {
                sb.append(')');
            }
            sb.append(";\n");
            sb.append("}\n\n");
        }
    }

    private static void addArgList(StringBuilder sb, String[] argList) {
        if (argList != null && argList.length > 0) {
            for (int i = 0; i < argList.length; ++i) {
                sb.append(argList[i]);
                if (i >= argList.length - 1) continue;
                sb.append(", ");
            }
        }
    }

    private static class JsHelperFunction {
        String functionName;
        String[] argList;
        Class returnType;

        public JsHelperFunction(String functionName, String[] argList, Class returnType) {
            this.functionName = functionName;
            this.argList = argList;
            this.returnType = returnType;
        }
    }
}

