/*!
 * ${copyright}
 */

sap.ui.define([
	"sap/ui/test/Opa5",
	"test-resources/sap/ui/mdc/testutils/opa/link/waitForLink",
	"sap/ui/mdc/qunit/link/opa/test/Assertion"
], function(Opa5, waitForLink, LinkAssertion) {
	"use strict";

	var iShouldSeeAPopover = function(oLinkIdentifier, bOpen) {
		return waitForLink.call(this, oLinkIdentifier, {
			success: function(oLink) {
				var oField = oLink.getParent();
				var oFieldInfo = oField.getFieldInfo();
				var aDependents = oFieldInfo.getDependents();
				var bPopoverFound = aDependents.some(function(oDependent) {
					return oDependent.isA("sap.m.ResponsivePopover");
				});

				Opa5.assert.equal(bPopoverFound, bOpen, "Found " + bOpen ? "" : "no" + " open Popover for given Link");
			}
		});
	};

	Opa5.createPageObjects({
		onAppUnderTestPageObject: {
			viewName: "sap.ui.mdc.LinkIntegrationTesting.appUnderTestPageObject.view.App",
			actions: {},
			assertions: {
				iShouldSeeAnOpenPopover: function(oLinkIdentifier) {
					return iShouldSeeAPopover.call(this, oLinkIdentifier, true);
				},
				iShouldNotSeeAnOpenPopover: function(oLinkIdentifier) {
					return iShouldSeeAPopover.call(this, oLinkIdentifier, false);
				},
				theApplicationURLContains: function(sText) {
					return new LinkAssertion().theApplicationURLContains.call(this, sText);
				}
			}
		}
	});

});
