sap.ui.define([
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/core/Core",
	"sap/ui/core/library",
	"sap/ui/unified/library"
], function(Controller, JSONModel, Core, CoreLibrary) {
	"use strict";
	var ValueState = CoreLibrary.ValueState;

	return Controller.extend("sap.ui.webc.main.sample.DatePicker.C", {

		onInit: function () {
			// create model
			var oModel = new JSONModel();
			oModel.setData({
				dateValue: new Date()
			});
			this.getView().setModel(oModel);

			this.byId("DP6").setMinDate("1/1/16");
			this.byId("DP6").setMaxDate("12/31/16");
			this.byId("DP6").setValue("5/11/16");
			this._iEvent = 0;
		},

		handleChange: function (oEvent) {
			var oText = this.byId("textResult"),
				oDP = oEvent.getSource(),
				sValue = oEvent.getParameter("value"),
				bValid = oEvent.getParameter("valid");

			this._iEvent++;
			oText.setValue("Change - Event " + this._iEvent + ": DatePicker " + oDP.getId() + ":" + sValue);

			if (bValid) {
				oDP.setValueState(ValueState.None);
			} else {
				oDP.setValueState(ValueState.Error);
			}
		}

	});
});