WPE_GeneratorsOfGroup := function(G)
    gens := GeneratorsOfGroup(G);
    if IsEmpty(gens) then
        gens := [()];
    fi;
    return gens;
end;

Generate := function(K, H, id, n)
    local G, file, stream, i, g, Cgens;
    G := WreathProduct(K, H);
    file := Concatenation("out/testCentraliser_", id, ".tst");
    stream:=OutputTextFile(file, false);
    SetPrintFormattingStatus(stream, false);
    PrintTo(stream);
    AppendTo(stream, "gap> # Generated by dev/tests/centraliser/generate.g\n");
    AppendTo(stream, "gap> ReadPackage(\"WPE\",\"tst/testCentraliser.g\");;\n");
    AppendTo(stream, "gap> K := Group(", WPE_GeneratorsOfGroup(K), ");;\n");
    AppendTo(stream, "gap> H := Group(", WPE_GeneratorsOfGroup(H), ");;\n");
    AppendTo(stream, "gap> G := WreathProduct(K, H);;\n");
    for i in [1 .. n] do
        g := PseudoRandom(G);
        Cgens := WPE_GeneratorsOfGroup(Centraliser(G, g));
        AppendTo(stream, "gap> # Element ", i, "\n");
        AppendTo(stream, "gap> g := ", g, ";;\n");
        AppendTo(stream, "gap> Cgens := ", Cgens, ";;\n");
        AppendTo(stream, "gap> TestCentraliser(G, g, Cgens);\n");
        AppendTo(stream, "true\n");
    od;
end;

K := SymmetricGroup(1);
H := SymmetricGroup(1);
id := "S1wrS1";
Generate(K, H, id, 20);

K := SymmetricGroup(1);
H := SymmetricGroup(8);
id := "S1wrS8";
Generate(K, H, id, 20);

K := SymmetricGroup(1);
H := AlternatingGroup(8);
id := "S1wrA8";
Generate(K, H, id, 20);

K := SymmetricGroup(4);
H := SymmetricGroup(1);
id := "S4wrS1";
Generate(K, H, id, 20);

K := AlternatingGroup(4);
H := SymmetricGroup(1);
id := "A4wrS1";
Generate(K, H, id, 20);

K := SymmetricGroup(4);
H := SymmetricGroup(8);
id := "S4wrS8";
Generate(K, H, id, 20);

K := SymmetricGroup(4);
H := AlternatingGroup(8);
id := "S4wrA8";
Generate(K, H, id, 20);

K := SymmetricGroup(4);
H := DihedralGroup(IsPermGroup, 16);
id := "S4wrD16";
Generate(K, H, id, 20);
