/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.ElementBuffer;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;
import jogamp.nativewindow.x11.XRenderDirectFormat;

public class XRenderPictFormat {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] XRenderPictFormat_size = new int[]{32, 32, 32, 32, 32, 32, 32, 40, 40, 40};
    private static final int[] id_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] type_offset = new int[]{4, 4, 4, 4, 4, 4, 4, 8, 8, 8};
    private static final int[] depth_offset = new int[]{8, 8, 8, 8, 8, 8, 8, 12, 12, 12};
    private static final int[] direct_offset = new int[]{12, 12, 12, 12, 12, 12, 12, 16, 16, 16};
    private static final int[] direct_size = new int[]{16, 16, 16, 16, 16, 16, 16, 16, 16, 16};
    private static final int[] colormap_offset = new int[]{28, 28, 28, 28, 28, 28, 28, 32, 32, 32};

    public static boolean usesNativeCode() {
        return false;
    }

    public static int size() {
        return XRenderPictFormat_size[mdIdx];
    }

    public static XRenderPictFormat create() {
        return XRenderPictFormat.create(Buffers.newDirectByteBuffer((int)XRenderPictFormat.size()));
    }

    public static XRenderPictFormat create(ByteBuffer byteBuffer) {
        return new XRenderPictFormat(byteBuffer);
    }

    public static XRenderPictFormat derefPointer(long l) {
        return XRenderPictFormat.create(ElementBuffer.derefPointer((int)XRenderPictFormat.size(), (long)l, (int)1).getByteBuffer());
    }

    XRenderPictFormat(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[XRenderPictFormat.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public final ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public final long getDirectBufferAddress() {
        return this.accessor.getDirectBufferAddress();
    }

    public final long getId() {
        return PointerBuffer.wrap((ByteBuffer)this.getBuffer(), (int)id_offset[mdIdx], (int)1).get(0);
    }

    public final int getType() {
        return this.accessor.getIntAt(type_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final int getDepth() {
        return this.accessor.getIntAt(depth_offset[mdIdx], this.md.intSizeInBytes());
    }

    public final XRenderDirectFormat getDirect() {
        return XRenderDirectFormat.create(this.accessor.slice(direct_offset[mdIdx], direct_size[mdIdx]));
    }

    public final long getColormap() {
        return PointerBuffer.wrap((ByteBuffer)this.getBuffer(), (int)colormap_offset[mdIdx], (int)1).get(0);
    }
}

