/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.tasks.GTreeCollapseAllTask;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.nodes.MoreNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class OrganizationNode
extends SymbolTreeNode {
    public static final int MAX_SAME_NAME = 10;
    static final Comparator<GTreeNode> COMPARATOR = new OrganizationNodeComparator();
    private static Icon OPEN_FOLDER_GROUP_ICON = new GIcon("icon.plugin.symboltree.node.organization.open");
    private static Icon CLOSED_FOLDER_GROUP_ICON = new GIcon("icon.plugin.symboltree.node.organization.closed");
    private String baseName;
    private int totalCount;
    private MoreNode moreNode;

    private OrganizationNode(List<GTreeNode> list, int maxGroupSize, TaskMonitor monitor) throws CancelledException {
        this.totalCount = list.size();
        List<GTreeNode> children = OrganizationNode.organize(list, maxGroupSize, monitor);
        if (children.size() > 10 && OrganizationNode.hasSameName(children)) {
            this.baseName = children.get(0).getName();
            children = new ArrayList<GTreeNode>(children.subList(0, 10));
            this.moreNode = new MoreNode(this.baseName, this.totalCount - 10);
            children.add((GTreeNode)this.moreNode);
        } else {
            this.baseName = this.getCommonPrefix(children);
        }
        this.doSetChildren(children);
    }

    public static List<GTreeNode> organize(List<GTreeNode> list, int maxGroupSize, TaskMonitor monitor) throws CancelledException {
        Map<String, List<GTreeNode>> prefixMap = OrganizationNode.partition(list, maxGroupSize, monitor);
        if (prefixMap == null) {
            return new ArrayList<GTreeNode>(list);
        }
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        for (String prefix : prefixMap.keySet()) {
            monitor.checkCancelled();
            List<GTreeNode> nodesSamePrefix = prefixMap.get(prefix);
            if (prefix.isEmpty()) {
                children.addAll(nodesSamePrefix);
                continue;
            }
            if (nodesSamePrefix.size() == 1) {
                children.addAll(nodesSamePrefix);
                continue;
            }
            children.add((GTreeNode)new OrganizationNode(nodesSamePrefix, maxGroupSize, monitor));
        }
        return children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OrganizationNode node = (OrganizationNode)((Object)o);
        return this.baseName.equals(node.baseName);
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new UnsupportedOperationException("Cannot cut an organization node");
    }

    public Icon getIcon(boolean expanded) {
        if (expanded) {
            return OPEN_FOLDER_GROUP_ICON;
        }
        return CLOSED_FOLDER_GROUP_ICON;
    }

    public String getName() {
        return this.baseName;
    }

    public String getToolTip() {
        return "Contains labels that start with \"" + this.getName() + "\" (" + this.totalCount + ")";
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        return false;
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    public void insertNode(GTreeNode newNode) {
        if (this.moreNode != null) {
            this.moreNode.incrementCount();
            return;
        }
        int index = Collections.binarySearch(this.getChildren(), newNode, this.getChildrenComparator());
        if (index >= 0) {
            GTreeNode matchingNode = this.getChild(index);
            if (matchingNode instanceof OrganizationNode) {
                OrganizationNode orgNode = (OrganizationNode)matchingNode;
                orgNode.insertNode(newNode);
                return;
            }
        } else {
            index = -index - 1;
        }
        this.addNode(index, newNode);
        this.checkForTooManyNodes();
    }

    private void checkForTooManyNodes() {
        SymbolTreeRootNode root = (SymbolTreeRootNode)this.getRoot();
        if (root == null) {
            return;
        }
        int reOrgLimit = root.getReorganizeLimit();
        if (this.getChildCount() < reOrgLimit) {
            return;
        }
        for (GTreeNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof SymbolCategoryNode)) continue;
            GTree tree = this.getTree();
            tree.clearSelectionPaths();
            tree.runTask((GTreeTask)new GTreeCollapseAllTask(tree, parent));
            return;
        }
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor taskMonitor) {
        String symbolName = key.getName();
        if (!symbolName.startsWith(this.baseName)) {
            return null;
        }
        if (this.moreNode != null) {
            if (!symbolName.equals(this.baseName)) {
                return null;
            }
            for (GTreeNode child : this.children()) {
                SymbolTreeNode symbolTreeNode = (SymbolTreeNode)child;
                if (symbolTreeNode.getSymbol() != key.getSymbol()) continue;
                return child;
            }
            return this.moreNode;
        }
        return super.findSymbolTreeNode(key, loadChildren, taskMonitor);
    }

    public int compareTo(GTreeNode node) {
        String nodeName;
        if (!(node instanceof OrganizationNode) && (nodeName = node.getName()).regionMatches(false, 0, this.baseName, 0, this.baseName.length())) {
            return 0;
        }
        return super.compareTo(node);
    }

    @Override
    public Comparator<GTreeNode> getChildrenComparator() {
        return COMPARATOR;
    }

    public void removeNode(GTreeNode node) {
        if (node == this.moreNode) {
            this.moreNode.decrementCount();
            if (!this.moreNode.isEmpty()) {
                return;
            }
            this.moreNode = null;
        }
        super.removeNode(node);
        if (this.getChildCount() == 0) {
            this.getParent().removeNode((GTreeNode)this);
        }
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        return null;
    }

    private String getCommonPrefix(List<GTreeNode> children) {
        int commonPrefixSize = OrganizationNode.getCommonPrefixSize(children);
        return children.get(0).getName().substring(0, commonPrefixSize);
    }

    private static Map<String, List<GTreeNode>> partition(List<GTreeNode> nodeList, int maxGroupSize, TaskMonitor monitor) throws CancelledException {
        if (nodeList.size() <= maxGroupSize) {
            return null;
        }
        int commonPrefixSize = OrganizationNode.getCommonPrefixSize(nodeList);
        int uniquePrefixSize = commonPrefixSize + 1;
        LinkedHashMap<String, List<GTreeNode>> map = new LinkedHashMap<String, List<GTreeNode>>();
        for (GTreeNode node : nodeList) {
            monitor.checkCancelled();
            String prefix = OrganizationNode.getPrefix(node, uniquePrefixSize);
            List list = map.computeIfAbsent(prefix, k -> new ArrayList());
            list.add(node);
        }
        if (map.size() == 1) {
            return null;
        }
        if (map.size() >= nodeList.size()) {
            return null;
        }
        return map;
    }

    private static String getPrefix(GTreeNode gTreeNode, int uniquePrefixSize) {
        String name = gTreeNode.getName();
        if (name.length() <= uniquePrefixSize) {
            return name;
        }
        return name.substring(0, uniquePrefixSize);
    }

    private static int getCommonPrefixSize(List<GTreeNode> list) {
        GTreeNode node = list.get(0);
        String first = node.getName();
        int inCommonSize = first.length();
        for (int i = 1; i < list.size(); ++i) {
            String next = list.get(i).getName();
            inCommonSize = Math.min(inCommonSize, OrganizationNode.getCommonPrefixSize(first, next, inCommonSize));
        }
        return inCommonSize;
    }

    private static int getCommonPrefixSize(String base, String candidate, int max) {
        int maxCompareLength = Math.min(max, candidate.length());
        for (int i = 0; i < maxCompareLength; ++i) {
            if (base.charAt(i) == candidate.charAt(i)) continue;
            return i;
        }
        return maxCompareLength;
    }

    private static boolean hasSameName(List<GTreeNode> list) {
        if (list.size() < 2) {
            return false;
        }
        String name = list.get(0).getName();
        for (GTreeNode node : list) {
            if (name.equals(node.getName())) continue;
            return false;
        }
        return true;
    }

    static class OrganizationNodeComparator
    implements Comparator<GTreeNode> {
        OrganizationNodeComparator() {
        }

        @Override
        public int compare(GTreeNode g1, GTreeNode g2) {
            if (!(g1 instanceof OrganizationNode) && g2 instanceof OrganizationNode) {
                int result = -g2.compareTo(g1);
                return result;
            }
            int result = g1.compareTo(g2);
            return result;
        }
    }
}

