/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AddressMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.NameMsSymbol;

public class PeCoffGroupMsSymbol
extends AbstractMsSymbol
implements AddressMsSymbol,
NameMsSymbol {
    public static final int PDB_ID = 4407;
    private int length;
    private int characteristics;
    private long offset;
    private int segment;
    private String name;

    public PeCoffGroupMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.length = reader.parseInt();
        this.characteristics = reader.parseInt();
        this.offset = reader.parseUnsignedIntVal();
        this.segment = pdb.parseSegment(reader);
        this.name = reader.parseString(pdb, StringParseType.StringUtf8Nt);
        reader.align4();
    }

    @Override
    public int getPdbId() {
        return 4407;
    }

    public int getLength() {
        return this.length;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Length = %08X, Characteristics = %08X, %s", this.getSymbolTypeName(), this.segment, this.offset, this.length, this.characteristics, this.name));
    }

    @Override
    protected String getSymbolTypeName() {
        return "COFFGROUP";
    }
}

