/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryOperations;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.stack.TraceStackFrame;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.exception.DuplicateNameException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public interface TraceMemoryManager
extends TraceMemoryOperations {
    public AddressSpace createOverlayAddressSpace(String var1, AddressSpace var2) throws DuplicateNameException;

    public AddressSpace getOrCreateOverlayAddressSpace(String var1, AddressSpace var2);

    public void deleteOverlayAddressSpace(String var1);

    public TraceMemoryRegion addRegion(String var1, Lifespan var2, AddressRange var3, Collection<TraceMemoryFlag> var4) throws TraceOverlappedRegionException;

    default public TraceMemoryRegion addRegion(String path, Lifespan lifespan, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException {
        return this.addRegion(path, lifespan, range, Arrays.asList(flags));
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, Lifespan.nowOn(snap), range, flags);
    }

    default public TraceMemoryRegion createRegion(String path, long snap, AddressRange range, TraceMemoryFlag ... flags) throws TraceOverlappedRegionException, DuplicateNameException {
        return this.addRegion(path, Lifespan.nowOn(snap), range, flags);
    }

    public Collection<? extends TraceMemoryRegion> getAllRegions();

    public TraceMemoryRegion getLiveRegionByPath(long var1, String var3);

    public TraceMemoryRegion getRegionContaining(long var1, Address var3);

    public Collection<? extends TraceMemoryRegion> getRegionsIntersecting(Lifespan var1, AddressRange var2);

    public Collection<? extends TraceMemoryRegion> getRegionsAtSnap(long var1);

    public AddressSetView getRegionsAddressSet(long var1);

    public AddressSetView getRegionsAddressSetWith(long var1, Predicate<TraceMemoryRegion> var3);

    public TraceMemorySpace getMemorySpace(AddressSpace var1, boolean var2);

    public TraceMemorySpace getMemoryRegisterSpace(TraceThread var1, int var2, boolean var3);

    public TraceMemorySpace getMemoryRegisterSpace(TraceThread var1, boolean var2);

    public TraceMemorySpace getMemoryRegisterSpace(TraceStackFrame var1, boolean var2);

    public Collection<Map.Entry<TraceAddressSnapRange, TraceMemoryState>> getStateChanges(long var1, long var3);
}

