/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitCheckoutNewBranchOperation
extends GitBranchOperation {
    @NotNull
    private final String myNewBranchName;

    GitCheckoutNewBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String newBranchName) {
        if (project == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(3);
        }
        if (newBranchName == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myNewBranchName = newBranchName;
    }

    @Override
    protected void execute() {
        boolean fatalErrorHappened = false;
        this.notifyBranchWillChange();
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            GitSimpleEventDetector unmergedDetector;
            GitRepository repository2 = this.next();
            GitCommandResult result2 = this.myGit.checkoutNewBranch(repository2, this.myNewBranchName, unmergedDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_CHECKOUT));
            if (result2.success()) {
                GitCheckoutNewBranchOperation.refresh(repository2);
                this.markSuccessful(repository2);
                continue;
            }
            if (unmergedDetector.isDetected()) {
                this.fatalUnmergedFilesError();
                fatalErrorHappened = true;
                continue;
            }
            this.fatalError(GitBundle.message("checkout.new.branch.operation.could.not.create.new.branch", this.myNewBranchName), result2);
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.notifyBranchHasChanged(this.myNewBranchName);
            this.updateRecentBranch();
        }
    }

    private static void refresh(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(5);
        }
        repository2.update();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        String string = GitBundle.message("checkout.new.branch.operation.branch.was.created", GitUIUtil.code(this.myNewBranchName));
        if (string == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = new HtmlBuilder().append(GitBundle.message("checkout.new.branch.operation.however.checkout.has.succeeded.for.the.following", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("checkout.new.branch.operation.you.may.rollback.not.to.let.branches.diverge", this.myNewBranchName)).toString();
        if (string == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        String string = GitBundle.message("checkout.operation.name", new Object[0]);
        if (string == null) {
            GitCheckoutNewBranchOperation.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected void rollback() {
        GitCompoundResult checkoutResult = new GitCompoundResult(this.myProject);
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        Collection<GitRepository> repositories = this.getSuccessfulRepositories();
        for (GitRepository repository2 : repositories) {
            GitCommandResult result2 = this.myGit.checkout(repository2, (String)this.myCurrentHeads.get(repository2), null, true, false, new GitLineHandlerListener[0]);
            checkoutResult.append(repository2, result2);
            if (result2.success()) {
                deleteResult.append(repository2, this.myGit.branchDelete(repository2, this.myNewBranchName, false, new GitLineHandlerListener[0]));
            }
            GitCheckoutNewBranchOperation.refresh(repository2);
        }
        if (checkoutResult.totalSuccess() && deleteResult.totalSuccess()) {
            message = GitBundle.message("checkout.new.branch.operation.checked.out.0.and.deleted.1.on.2.3", GitCheckoutNewBranchOperation.stringifyBranchesByRepos(this.myCurrentHeads), GitUIUtil.code(this.myNewBranchName), repositories.size(), this.successfulRepositoriesJoined());
            VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.checkout.new.branch.operation.rollback.successful", GitBundle.message("checkout.new.branch.operation.rollback.successful", new Object[0]), (String)message);
        } else {
            message = new StringBuilder();
            if (!checkoutResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.new.branch.operation.errors.during.checkout", new Object[0]));
                message.append(checkoutResult.getErrorOutputWithReposIndication());
            }
            if (!deleteResult.totalSuccess()) {
                message.append(GitBundle.message("checkout.new.branch.operation.errors.during.deleting", GitUIUtil.code(this.myNewBranchName)));
                message.append(deleteResult.getErrorOutputWithReposIndication());
            }
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.checkout.new.branch.operation.rollback.error", GitBundle.message("checkout.new.branch.operation.error.during.rollback", new Object[0]), message.toString(), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitCheckoutNewBranchOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitCheckoutNewBranchOperation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

