/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend.hyperlinks;

import com.intellij.execution.impl.HypertextInput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.backend.hyperlinks.BackendTerminalHyperlinkHighlighter;
import com.intellij.terminal.backend.hyperlinks.HighlightTask;
import com.intellij.terminal.backend.hyperlinks.HypertextFromFrozenTerminalOutputModelAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.TerminalOutputModelSnapshot;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\bH\u0002\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\bH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\u00052\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0018\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u0019\u001a\u00020\bH\u0002\"\u000e\u0010\u0013\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000*\f\b\u0002\u0010\t\"\u00020\n2\u00020\n\u00a8\u0006\u001a"}, d2={"newHighlightTask", "Lcom/intellij/terminal/backend/hyperlinks/HighlightTask;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "startLine", "Lorg/jetbrains/plugins/terminal/view/TerminalLineIndex;", "describe", "", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModelSnapshot;", "TaskResult", "Lorg/jetbrains/plugins/terminal/session/impl/dto/TerminalFilterResultInfoDto;", "relativeOffset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "offset", "", "asHypertext", "Lcom/intellij/execution/impl/HypertextInput;", "getLineText", "line", "BATCH_SIZE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "relativeLine", "lineIndex", "toRelative", "model", "intellij.terminal.backend"})
@SourceDebugExtension(value={"SMAP\nBackendTerminalHyperlinkHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkHighlighterKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,531:1\n13#2:532\n*S KotlinDebug\n*F\n+ 1 BackendTerminalHyperlinkHighlighter.kt\ncom/intellij/terminal/backend/hyperlinks/BackendTerminalHyperlinkHighlighterKt\n*L\n526#1:532\n*E\n"})
public final class BackendTerminalHyperlinkHighlighterKt {
    private static final int BATCH_SIZE = 200;
    @NotNull
    private static final Logger LOG;

    private static final HighlightTask newHighlightTask(TerminalOutputModel outputModel, TerminalLineIndex startLine) {
        TerminalLineIndex endLineInclusive = outputModel.getLastLineIndex();
        TerminalOffset startOffset = outputModel.getStartOfLine(startLine);
        return new HighlightTask(startLine.toAbsolute(), startOffset.toAbsolute(), endLineInclusive.toAbsolute());
    }

    private static final String describe(TerminalOutputModelSnapshot outputModel) {
        StringBuilder stringBuilder;
        StringBuilder $this$describe_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$describe_u24lambda_u240.append("OutputModel(trimmedChars=");
        $this$describe_u24lambda_u240.append(outputModel.getStartOffset());
        $this$describe_u24lambda_u240.append(",trimmedLines=");
        $this$describe_u24lambda_u240.append(outputModel.getFirstLineIndex().toAbsolute());
        $this$describe_u24lambda_u240.append(",lengthChars=");
        $this$describe_u24lambda_u240.append(outputModel.getTextLength());
        $this$describe_u24lambda_u240.append(",lengthLines=");
        $this$describe_u24lambda_u240.append(outputModel.getLineCount());
        $this$describe_u24lambda_u240.append(",modificationStamp=");
        $this$describe_u24lambda_u240.append(outputModel.getModificationStamp());
        $this$describe_u24lambda_u240.append(")");
        return stringBuilder.toString();
    }

    private static final TerminalOffset relativeOffset(TerminalOutputModelSnapshot $this$relativeOffset, int offset) {
        return $this$relativeOffset.getStartOffset().plus(offset);
    }

    private static final HypertextInput asHypertext(TerminalOutputModelSnapshot $this$asHypertext) {
        return new HypertextFromFrozenTerminalOutputModelAdapter($this$asHypertext);
    }

    private static final String getLineText(TerminalOutputModelSnapshot $this$getLineText, TerminalLineIndex line) {
        return ((Object)$this$getLineText.getText($this$getLineText.getStartOfLine(line), $this$getLineText.getEndOfLine(line, true))).toString();
    }

    private static final TerminalLineIndex relativeLine(TerminalOutputModelSnapshot $this$relativeLine, int lineIndex) {
        return $this$relativeLine.getFirstLineIndex().plus(lineIndex);
    }

    private static final int toRelative(TerminalLineIndex $this$toRelative, TerminalOutputModelSnapshot model) {
        return (int)$this$toRelative.minus(model.getFirstLineIndex());
    }

    private static final int toRelative(TerminalOffset $this$toRelative, TerminalOutputModelSnapshot model) {
        return (int)$this$toRelative.minus(model.getStartOffset());
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ HighlightTask access$newHighlightTask(TerminalOutputModel outputModel, TerminalLineIndex startLine) {
        return BackendTerminalHyperlinkHighlighterKt.newHighlightTask(outputModel, startLine);
    }

    public static final /* synthetic */ String access$describe(TerminalOutputModelSnapshot outputModel) {
        return BackendTerminalHyperlinkHighlighterKt.describe(outputModel);
    }

    public static final /* synthetic */ TerminalOffset access$relativeOffset(TerminalOutputModelSnapshot $receiver, int offset) {
        return BackendTerminalHyperlinkHighlighterKt.relativeOffset($receiver, offset);
    }

    public static final /* synthetic */ HypertextInput access$asHypertext(TerminalOutputModelSnapshot $receiver) {
        return BackendTerminalHyperlinkHighlighterKt.asHypertext($receiver);
    }

    public static final /* synthetic */ int access$toRelative(TerminalLineIndex $receiver, TerminalOutputModelSnapshot model) {
        return BackendTerminalHyperlinkHighlighterKt.toRelative($receiver, model);
    }

    public static final /* synthetic */ int access$toRelative(TerminalOffset $receiver, TerminalOutputModelSnapshot model) {
        return BackendTerminalHyperlinkHighlighterKt.toRelative($receiver, model);
    }

    public static final /* synthetic */ TerminalLineIndex access$relativeLine(TerminalOutputModelSnapshot $receiver, int lineIndex) {
        return BackendTerminalHyperlinkHighlighterKt.relativeLine($receiver, lineIndex);
    }

    public static final /* synthetic */ String access$getLineText(TerminalOutputModelSnapshot $receiver, TerminalLineIndex line) {
        return BackendTerminalHyperlinkHighlighterKt.getLineText($receiver, line);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendTerminalHyperlinkHighlighter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

