/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Erosion of an object in an image.


Erosion of an image using binary morphology. Pixel values matching the
object value are considered the "object" and all other pixels are
"background". This is useful in processing mask images containing
only one object.

If the pixel covered by the center of the kernel has the pixel value
ObjectValue and the pixel is adjacent to a non-object valued pixel,
then the kernel is centered on the object-value pixel and neighboring
pixels covered by the kernel are assigned the background value. The
structuring element is assumed to be composed of binary values (zero
or one).


See:
 ObjectMorphologyImageFilter , BinaryFunctionErodeImageFilter

 BinaryErodeImageFilter

 itk::simple::ErodeObjectMorphology for the procedural interface

 itk::ErodeObjectMorphologyImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkErodeObjectMorphologyImageFilter.h
*/
public class ErodeObjectMorphologyImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ErodeObjectMorphologyImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ErodeObjectMorphologyImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ErodeObjectMorphologyImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ErodeObjectMorphologyImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ErodeObjectMorphologyImageFilter::~ErodeObjectMorphologyImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ErodeObjectMorphologyImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ErodeObjectMorphologyImageFilter::ErodeObjectMorphologyImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ErodeObjectMorphologyImageFilter() {
    this(SimpleITKJNI.new_ErodeObjectMorphologyImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(VectorUInt32 KernelRadius) {
    SimpleITKJNI.ErodeObjectMorphologyImageFilter_setKernelRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(KernelRadius), KernelRadius);
  }

  /**
Self&amp; itk::simple::ErodeObjectMorphologyImageFilter::SetKernelRadius(unsigned int value)

Set the values of the KernelRadius vector all to value

*/
public  void setKernelRadius(long value) {
    SimpleITKJNI.ErodeObjectMorphologyImageFilter_setKernelRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::ErodeObjectMorphologyImageFilter::GetKernelRadius() const

Get the radius of the kernel structuring element.

*/
public  VectorUInt32 getKernelRadius() {
    return new VectorUInt32(SimpleITKJNI.ErodeObjectMorphologyImageFilter_getKernelRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ErodeObjectMorphologyImageFilter::SetKernelType(KernelEnum KernelType)

Set the kernel or structuring element used for the morphology.

*/
public  void setKernelType(KernelEnum KernelType) {
    SimpleITKJNI.ErodeObjectMorphologyImageFilter_setKernelType(swigCPtr, this, KernelType.swigValue());
  }

  /**
KernelEnum itk::simple::ErodeObjectMorphologyImageFilter::GetKernelType() const

Get the kernel or structuring element used for the morphology.

*/
public  KernelEnum getKernelType() {
    return KernelEnum.swigToEnum(SimpleITKJNI.ErodeObjectMorphologyImageFilter_getKernelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ErodeObjectMorphologyImageFilter::SetObjectValue(double ObjectValue)
*/
public  void setObjectValue(double ObjectValue) {
    SimpleITKJNI.ErodeObjectMorphologyImageFilter_setObjectValue(swigCPtr, this, ObjectValue);
  }

  /**
double itk::simple::ErodeObjectMorphologyImageFilter::GetObjectValue() const
*/
public  double getObjectValue() {
    return SimpleITKJNI.ErodeObjectMorphologyImageFilter_getObjectValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ErodeObjectMorphologyImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value to be assigned to eroded pixels

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.ErodeObjectMorphologyImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::ErodeObjectMorphologyImageFilter::GetBackgroundValue() const

Get the value to be assigned to eroded pixels

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.ErodeObjectMorphologyImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::ErodeObjectMorphologyImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ErodeObjectMorphologyImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ErodeObjectMorphologyImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ErodeObjectMorphologyImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ErodeObjectMorphologyImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ErodeObjectMorphologyImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
