;english.lex
;main lexicon file for Englex
;last modified 28-Nov-95

;Use this lexicon file (english.lex) in conjunction with the grammar
;file english.grm. This file is exactly the same as english2.lex except
;for the gloss field.

;Englex 2.0b5
;Copyright (C) 1991-1995, Summer Institute of Linguistics, Inc.

;Evan Antworth                    |  e-mail: evan.antworth@sil.org
;Academic Computing Department    |  phone:  214-709-3346, -2418
;Summer Institute of LInguistics  |  fax:    214-709-3363
;7500 W. Camp Wisdom Road
;Dallas, TX 75236

; Conversion to initial Python by Beracah Yankama


;no affixes
Begin:		PREFIX AUX AUX-V PP CJ PP-CJ DT PR DT-PR IJ   
Particle:    AUX AUX-V PP CJ PP-CJ DT PR DT-PR IJ   
Prefix:      PREFIX
Root:        N AJ V AV N-V N-AJ AJ-V AJ-AV CD OD
Suffix:      SUFFIX

;inflection
Infl:        INFL

;proper nouns
PN_Suffix:   PN_SUFF        

;-y suffix
Y_Suffix:    Y_SUFF         

;-ic suffix
IC_Suffix:   IC_SUFF        

;participles
PT_Suffix:   PT_SUFF        

;genitive and contractions
Clitic:      GEN CNTR END   

;contractions
Contraction: CNTR END       

;cardinals and ordinals
Cd:          CD OD ORDR     

;compounds
Compound:    INITIAL        
; End:         END



IJ:
au-contraire	End	"IJ(au-contraire ,)"
bon-appetit	End	"IJ(bon-appetit ,)"
c'est-la-vie	End	"IJ(c'est-la-vie ,)"
que-sera-sera	End	"IJ(que-sera-sera ,)"
semper-fidelis	End	"IJ(semper-fidelis ,)"
adi`os	End	"IJ(adi`os ,)"
ah	End	"IJ(ah ,)"
a`ha	End	"IJ(a`ha ,)"
a`hem	End	"IJ(a`hem ,)"
a`hoy	End	"IJ(a`hoy ,)"
a`las	End	"IJ(a`las ,)"
alle`luia	Infl	"IJ(alle`luia ,)"
a`loha	End	"IJ(a`loha ,)"
a`men	Infl	"IJ(a`men ,)"
bah	End	"IJ(bah ,)"
boo	End	"IJ(boo ,)"
damn	End	"IJ(damn ,)"
dang	End	"IJ(dang ,)"
`dear	End	"IJ(`dear ,)"
drat	End	"IJ(drat ,)"
eh	End	"IJ(eh ,)"
eu`reka	End	"IJ(eu`reka ,)"
gee	End	"IJ(gee ,)"
`golly	End	"IJ(`golly ,)"
good-`bye	End	"IJ(good-`bye ,)"
good-`by	End	"IJ(good-`by ,)"
good`bye	End	"IJ(good`bye ,)"
gosh	End	"IJ(gosh ,)"
ha	End	"IJ(ha ,)"
hah	End	"IJ(hah ,)"
halle`lujah	Infl	"IJ(halle`lujah ,)"
hal`lo	End	"IJ(hal`lo ,)"
hal`loa	End	"IJ(hal`loa ,)"
heck	End	"IJ(heck ,)"
hel`lo	End	"IJ(hel`lo ,)"
hey	End	"IJ(hey ,)"
hi	End	"IJ(hi ,)"
hm	End	"IJ(hm ,)"
hmm	End	"IJ(hmm ,)"
ho	End	"IJ(ho ,)"
`howdy	End	"IJ(`howdy ,)"
ho`sanna	Infl	"IJ(ho`sanna ,)"
ho`sannah	Infl	"IJ(ho`sannah ,)"
huh	End	"IJ(huh ,)"
hul`lo	End	"IJ(hul`lo ,)"
humph	End	"IJ(humph ,)"
hur`rah	End	"IJ(hur`rah ,)"
hur`ray	End	"IJ(hur`ray ,)"
lo	End	"IJ(lo ,)"
o	End	"IJ(o ,)"
oh	End	"IJ(oh ,)"
OK	End	"IJ(OK ,)"
ouch	End	"IJ(ouch ,)"
ow	End	"IJ(ow ,)"
pooh	End	"IJ(pooh ,)"
sh	End	"IJ(sh ,)"
sha`lom	End	"IJ(sha`lom ,)"
shh	End	"IJ(shh ,)"
tut	End	"IJ(tut ,)"
ugh	End	"IJ(ugh ,)"
`well	End	"IJ(`well ,)"
whee	End	"IJ(whee ,)"
whew	End	"IJ(whew ,)"
whoa	End	"IJ(whoa ,)"
wow	End	"IJ(wow ,)"
yah	End	"IJ(yah ,)"
yeah	End	"IJ(yeah ,)"
yuh	End	"IJ(yuh ,)"
zounds	End	"IJ(zounds ,)"

IC_SUFF:
''	Clitic	"IC_SUFF('' ,)"
+al	Suffix	"IC_SUFF(+AJR17a - ,aj/aj)"
+ity	Suffix	"IC_SUFF(+NR21 - ,aj/n)"
+ism	Suffix	"IC_SUFF(+NR8 - ,aj/n)"
+ist	Suffix	"IC_SUFF(+NR31 - ,aj/n nr31)"
+ian	Suffix	"IC_SUFF(+NR29b - ,aj/n)"
+ize	Suffix	"IC_SUFF(+VR6a - ,aj/v)"
+ise	Suffix	"IC_SUFF(+VR6b - ,aj/v)"
+s	Clitic	"IC_SUFF(+PL - ,n-aj/n reg)"

N:
ABC	Infl	"N(ABC - american broadcasting company,)"
AC	Infl	"N(AC - alternating current,)"
AD	Infl	"N(AD - anno domini,)"
AFL-CIO	Infl	"N(AFL-CIO - [labor union],)"
AI	Infl	"N(AI - artificial intelligence,)"
AM	Infl	"N(AM - ante meridiem, amplitude modulation,)"
AMA	Infl	"N(AMA - american medical association,)"
ANC	Infl	"N(ANC - african national congress,)"
ASCII	Infl	"N(ASCII - american standard code for inf. interchange,)"
AV	Infl	"N(AV - authorized version,)"
BBC	Infl	"N(BBC - British Broadcasting Corp,)"
BC	Infl	"N(BC - before Christ,)"
BCE	Infl	"N(BCE - before common era,)"
CAD	Infl	"N(CAD - computer-aided design,)"
CAM	Infl	"N(CAM - computer-aided manufacturing,)"
CBS	Infl	"N(CBS - columbia broadcasting system,)"
CD	Infl	"N(CD - compact disc, certificate of deposit,)"
CE	Infl	"N(CE - common era,)"
CEO	Infl	"N(CEO - chief executive officer,)"
CIA	Infl	"N(CIA - central intelligence agency,)"
CPU	Infl	"N(CPU - central processing unit,)"
DC	Infl	"N(DC - district of columbia, direct current,)"
DDT	Infl	"N(DDT - [pesticide],)"
DNA	Infl	"N(DNA - deoxyribonucleic acid,)"
DOD	Infl	"N(DOD - department of defense,)"
DOS	Infl	"N(DOS - disk operating system,)"
DOT	Infl	"N(DOT - department of transportation,)"
EC	Infl	"N(EC - european community,)"
EPA	Infl	"N(EPA - environmental protection agency,)"
FAA	Infl	"N(FAA - federal aeronautics administration,)"
FCC	Infl	"N(FCC - federal communications commission,)"
FBI	Infl	"N(FBI - federal bureau of investigation,)"
FDA	Infl	"N(FDA - food and drug administration,)"
FDIC	Infl	"N(FDIC - federal depositors' insurance corp,)"
FHA	Infl	"N(FHA - federal housing administration,)"
FTC	Infl	"N(FTC - federal trade commission,)"
FM	Infl	"N(FM - frequency modulation, foreign minister,)"
GAO	Infl	"N(GAO - general accounting office,)"
GNP	Infl	"N(GNP - gross national product,)"
GOP	Infl	"N(GOP - grand old party,)"
HUD	Infl	"N(HUD - housing and urban development,)"
HIV	Infl	"N(HIV - human immunodeficiency virus,)"
IMF	Infl	"N(IMF - international monetary fund,)"
IPA	Infl	"N(IPA - international phonetic alphabet,)"
IQ	Infl	"N(IQ - intelligence quotient,)"
IRA	Infl	"N(IRA - irish repub. army, individual retirement account,)"
IRS	Infl	"N(IRS - internal revenue service,)"
KGB	Infl	"N(KGB - [soviet intelligence agency],)"
KJV	Infl	"N(KJV - king james version,)"
KKK	Infl	"N(KKK - ku klux klan,)"
MP	Infl	"N(MP - member of parliament,)"
MPH	Infl	"N(MPH - miles per hour,)"
MX	Infl	"N(MX - missile,)"
NAACP	Infl	"N(NAACP - nat. assoc. for the advancement of colored people,)"
NASA	Infl	"N(NASA - national aeronautical and space administration,)"
NATO	Infl	"N(NATO - north atlantic treaty organization,)"
NBC	Infl	"N(NBC - national broadcasting company,)"
NCC	Infl	"N(NCC - national council of churches,)"
NLP	Infl	"N(NLP - natural language processing,)"
NRA	Infl	"N(NRA - national rifle assoc.,)"
NRC	Infl	"N(NRC - nuclear regulatory commission,)"
OAS	Infl	"N(OAS - organization of american states,)"
OEM	Infl	"N(OEM - original equipment manufacturer,)"
OPEC	Infl	"N(OPEC - org. of petroleum exporting countries,)"
PBS	Infl	"N(PBS - public broadcasting system,)"
PC	Infl	"N(PC - personal computer, politically correct,)"
PLO	Infl	"N(PLO - palestine liberation organization,)"
PM	Infl	"N(PM - post meridiem, prime minister,)"
POW	Infl	"N(POW - prisoner of war,)"
PR	Infl	"N(PR - public relations,)"
RAF	Infl	"N(RAF - royal air force,)"
RAM	Infl	"N(RAM - random access memory,)"
RISC	Infl	"N(RISC - reduced instruction set computer,)"
ROM	Infl	"N(ROM - read only memory,)"
SGML	Infl	"N(SGML - structured generalized markup language,)"
SIL	Infl	"N(SIL - summer institute of linguistics,)"
TASS	Infl	"N(TASS - [soviet news agency],)"
TV	Infl	"N(TV - television,)"
UAW	Infl	"N(UAW - united auto workers,)"
UFO	Infl	"N(UFO - unidentified flying object,)"
UK	Infl	"N(UK - united kingdom,)"
UN	Infl	"N(UN - united nations,)"
UNESCO	Infl	"N(UNESCO - u.n. educational, scientific & cultural org.,)"
UNICEF	Infl	"N(UNICEF - u.n. int'l children's education func,)"
UPI	Infl	"N(UPI - united press international,)"
US	Infl	"N(US - united states,)"
U.S.	Infl	"N(U.S. ,)"
USA	Infl	"N(USA - united states of america,)"
U.S.A.	Infl	"N(U.S.A. ,)"
USS	Infl	"N(USS - united states ship,)"
USSR	Infl	"N(USSR - united soviet socialist republics,)"
VA	Infl	"N(VA - veterans' administration,)"
VIP	Infl	"N(VIP - very important person,)"
VLSI	Infl	"N(VLSI - very large-scale integration,)"
WCC	Infl	"N(WCC - world council of churches,)"
YMCA	Infl	"N(YMCA - young men's christian association,)"
YWCA	Infl	"N(YWCA - young women's christian association,)"
Capt.	End	"N(Capt. - captain,)"
Co.	End	"N(Co. - company,)"
cf.	End	"N(cf. - compare,)"
Corp.	End	"N(Corp. - corporation,)"
Doc.	End	"N(Doc. - doctor,)"
Dr.	End	"N(Dr. - doctor,)"
Dr	End	"N(Dr ,)"
Ed.	End	"N(Ed. - edition, editor,)"
Eds.	End	"N(Eds. - editors,)"
Esq.	End	"N(Esq. - esquire,)"
Gen.	End	"N(Gen. - general,)"
Gov.	End	"N(Gov. - governor,)"
Inc.	Infl	"N(Inc. - incorporated,)"
Int'l.	Infl	"N(Int'l. - international,)"
Jr.	Infl	"N(Jr. - junior,)"
lbs	End	"N(lbs - pounds,)"
lb	End	"N(lb - pound,)"
Ltd.	Infl	"N(Ltd. - limited,)"
MD	End	"N(MD - doctor of medicine,)"
Mr.	End	"N(Mr. - mister,)"
Mr	End	"N(Mr ,)"
Mrs.	End	"N(Mrs. - missus,)"
Mrs	End	"N(Mrs ,)"
oz	End	"N(oz - ounces,)"
Ph.D.	End	"N(Ph.D. - doctor of philosophy,)"
PhD	End	"N(PhD ,)"
Pres.	End	"N(Pres. - president,)"
St.	End	"N(St. - saint,)"
St.	End	"N(St. - saint,)"
alma-mater	End	"N(alma-mater ,)"
bete-noir	End	"N(bete-noir ,)"
bona-fides	End	"N(bona-fides ,)"
carte-blanche	End	"N(carte-blanche ,)"
cartes-blanches	End	"N(cartes-blanches ,pl)"
cause-celebre	End	"N(cause-celebre ,)"
corpus-delicti	End	"N(corpus-delicti ,)"
corpora-delicti	End	"N(corpora-delicti ,pl)"
coup-d'etat	End	"N(coup-d'etat ,)"
coup-de-grace	End	"N(coup-de-grace ,)"
creme-de-la-creme	End	"N(creme-de-la-creme ,)"
deja-vu	End	"N(deja-vu ,)"
eminence-grise	End	"N(eminence-grise ,)"
eminences-grises	End	"N(eminences-grises ,pl)"
enfant-terrible	End	"N(enfant-terrible ,)"
esprit-de-corps	End	"N(esprit-de-corps ,)"
fait-accompli	End	"N(fait-accompli ,)"
faux-pas	End	"N(faux-pas ,)"
habeas-corpus	End	"N(habeas-corpus ,)"
hoi-polloi	End	"N(hoi-polloi ,pl)"
hors-d'oeuvre	End	"N(hors-d'oeuvre ,)"
hors-d'oeuvres	End	"N(hors-d'oeuvres ,pl)"
joi-de-vivre	End	"N(joi-de-vivre ,)"
lingua-franca	Infl	"N(lingua-franca ,)"
linguae-francae	End	"N(linguae-francae ,pl)"
maitre-d'	End	"N(maitre-d' ,)"
maitre-d'hotel	End	"N(maitre-d'hotel ,)"
mea-culpa	End	"N(mea-culpa ,)"
modus-operandi	End	"N(modus-operandi ,)"
nobless-oblige	End	"N(nobless-oblige ,)"
non-sequitur	End	"N(non-sequitur ,)"
nouveau-riche	End	"N(nouveau-riche ,)"
objet-d'art	End	"N(objet-d'art ,)"
persona-non-grata	End	"N(persona-non-grata ,)"
prima-donna	End	"N(prima-donna ,)"
quid-pro-quo	End	"N(quid-pro-quo ,)"
raison-d'etre	End	"N(raison-d'etre ,)"
rigor-mortis	End	"N(rigor-mortis ,)"
savoir-faire	End	"N(savoir-faire ,)"
status-quo	End	"N(status-quo ,)"
terra-firma	End	"N(terra-firma ,)"
tour-de-force	End	"N(tour-de-force ,)"
`aardvark	Suffix	"N(`aardvark ,)"
`abalone	Suffix	"N(`abalone ,)"
`absinthe	Suffix	"N(`absinthe ,)"
ac`cipiter	Suffix	"N(ac`cipiter ,)"
a`gave	Suffix	"N(a`gave ,)"
a`gouti	Suffix	"N(a`gouti ,)"
`albacore	Suffix	"N(`albacore ,)"
`albatross	Suffix	"N(`albatross ,)"
`alligator	Suffix	"N(`alligator ,)"
`aloe	Suffix	"N(`aloe ,)"
a`lyssum	Suffix	"N(a`lyssum ,)"
ama`nita	Suffix	"N(ama`nita ,)"
`amaranth	Suffix	"N(`amaranth ,)"
`ambergris	Suffix	"N(`ambergris ,)"
a`nemone	Suffix	"N(a`nemone ,)"
`angiosperm	Suffix	"N(`angiosperm ,)"
a`ni	Suffix	"N(a`ni ,)"
`anteater	Suffix	"N(`anteater ,)"
`anther	Suffix	"N(`anther ,)"
`anthracite	Suffix	"N(`anthracite ,)"
`antimony	Suffix	"N(`antimony ,)"
a`rachnid	Suffix	"N(a`rachnid ,)"
`argon	Suffix	"N(`argon ,)"
arma`dillo	Suffix	"N(arma`dillo ,)"
arte`misia	Suffix	"N(arte`misia ,)"
a`zalea	Suffix	"N(a`zalea ,)"
ba`leen	Suffix	"N(ba`leen ,)"
`balsa	Suffix	"N(`balsa ,)"
`balsam	Suffix	"N(`balsam ,)"
bam`boo	Suffix	"N(bam`boo ,)"
barra`cuda	Suffix	"N(barra`cuda ,)"
`bayberry	Suffix	"N(`bayberry ,)"
`beaver	Suffix	"N(`beaver ,)"
`beech	Suffix	"N(`beech ,)"
be`gonia	Suffix	"N(be`gonia ,)"
bella`donna	Suffix	"N(bella`donna ,)"
`bergamot	Suffix	"N(`bergamot ,)"
`beryl	Suffix	"N(`beryl ,)"
`bittern	Suffix	"N(`bittern ,)"
`bladdernut	Suffix	"N(`bladdernut ,)"
`bloodroot	Suffix	"N(`bloodroot ,)"
`bloodstone	Suffix	"N(`bloodstone ,)"
`blowfish	Suffix	"N(`blowfish ,)"
`bluebonnet	Suffix	"N(`bluebonnet ,)"
`bluefish	Suffix	"N(`bluefish ,)"
`bluegill	Suffix	"N(`bluegill ,)"
`bluet	Suffix	"N(`bluet ,)"
`boa	Suffix	"N(`boa ,)"
`bobcat	Suffix	"N(`bobcat ,)"
`bobolink	Suffix	"N(`bobolink ,)"
bo`letus	Suffix	"N(bo`letus ,)"
bo`nito	Suffix	"N(bo`nito ,)"
`brant	Suffix	"N(`brant ,)"
`breccia	Suffix	"N(`breccia ,)"
`broomcorn	Suffix	"N(`broomcorn ,)"
`bufflehead	Suffix	"N(`bufflehead ,)"
`bullfrog	Suffix	"N(`bullfrog ,)"
`bullhead	Suffix	"N(`bullhead ,)"
`bumblebee	Suffix	"N(`bumblebee ,)"
`burdock	Suffix	"N(`burdock ,)"
`burro	Suffix	"N(`burro ,)"
`bustard	Suffix	"N(`bustard ,)"
`butternut	Suffix	"N(`butternut ,)"
`caddis	Suffix	"N(`caddis ,)"
`caiman	Suffix	"N(`caiman ,)"
cal`dera	Suffix	"N(cal`dera ,)"
`camomile	Suffix	"N(`camomile ,)"
`campion	Suffix	"N(`campion ,)"
`cankerworm	Suffix	"N(`cankerworm ,)"
`cannabis	Suffix	"N(`cannabis ,)"
`canvasback	Suffix	"N(`canvasback ,)"
`cardamom	Suffix	"N(`cardamom ,)"
carra`geenan	Suffix	"N(carra`geenan ,)"
ca`talpa	Suffix	"N(ca`talpa ,)"
`catbird	Suffix	"N(`catbird ,)"
`catkin	Suffix	"N(`catkin ,)"
`catnip	Suffix	"N(`catnip ,)"
`cattail	Suffix	"N(`cattail ,)"
`centipede	Suffix	"N(`centipede ,)"
`chalcedony	Suffix	"N(`chalcedony ,)"
cha`meleon	Suffix	"N(cha`meleon ,)"
`chamomile	Suffix	"N(`chamomile ,)"
`chimp	Suffix	"N(`chimp ,)"
chimpan`zee	Suffix	"N(chimpan`zee ,)"
`chinch	Suffix	"N(`chinch ,)"
chin`chilla	Suffix	"N(chin`chilla ,)"
`chinquapin	Suffix	"N(`chinquapin ,)"
ci`cada	Suffix	"N(ci`cada ,)"
`cinquefoil	Suffix	"N(`cinquefoil ,)"
`citron	Suffix	"N(`citron ,)"
`coca	Suffix	"N(`coca ,)"
`cockatoo	Suffix	"N(`cockatoo ,)"
`cockle	Suffix	"N(`cockle ,)"
`cockleshell	Suffix	"N(`cockleshell ,)"
`cockroach	Suffix	"N(`cockroach ,)"
`codfish	Suffix	"N(`codfish ,)"
`coleus	Suffix	"N(`coleus ,)"
`collard	Suffix	"N(`collard ,)"
`columbine	Suffix	"N(`columbine ,)"
`coon	Suffix	"N(`coon ,)"
`copperhead	Suffix	"N(`copperhead ,)"
`copra	Suffix	"N(`copra ,)"
co`quina	Suffix	"N(co`quina ,)"
`coral	Suffix	"N(`coral ,)"
cori`ander	Suffix	"N(cori`ander ,)"
`cormorant	Suffix	"N(`cormorant ,)"
`cornflower	Suffix	"N(`cornflower ,)"
`cotoneaster	Suffix	"N(`cotoneaster ,)"
`cottonmouth	Suffix	"N(`cottonmouth ,)"
`cottonseed	Suffix	"N(`cottonseed ,)"
`cottonwood	Suffix	"N(`cottonwood ,)"
`cougar	Suffix	"N(`cougar ,)"
`cowpea	Suffix	"N(`cowpea ,)"
`cowslip	Suffix	"N(`cowslip ,)"
`coxcomb	Suffix	"N(`coxcomb ,)"
co`yote	Suffix	"N(co`yote ,)"
`crabapple	Suffix	"N(`crabapple ,)"
`cranberry	Suffix	"N(`cranberry ,)"
`crayfish	Suffix	"N(`crayfish ,)"
`cricket	Suffix	"N(`cricket ,)"
`crocodile	Suffix	"N(`crocodile ,)"
`crossbill	Suffix	"N(`crossbill ,)"
`curlew	Suffix	"N(`curlew ,)"
`cuttlefish	Suffix	"N(`cuttlefish ,)"
`cutworm	Suffix	"N(`cutworm ,)"
`cygnet	Suffix	"N(`cygnet ,)"
`cypress	Suffix	"N(`cypress ,)"
`dahlia	Suffix	"N(`dahlia ,)"
`dickcissel	Suffix	"N(`dickcissel ,)"
digi`talis	Suffix	"N(digi`talis ,)"
`dogfish	Suffix	"N(`dogfish ,)"
`dogwood	Suffix	"N(`dogwood ,)"
`dolphin	Suffix	"N(`dolphin ,)"
`dragonfly	Suffix	"N(`dragonfly ,)"
dro`sophila	Suffix	"N(dro`sophila ,)"
`earthworm	Suffix	"N(`earthworm ,)"
`earwig	Suffix	"N(`earwig ,)"
`edelweiss	Suffix	"N(`edelweiss ,)"
`eel	Suffix	"N(`eel ,)"
`egret	Suffix	"N(`egret ,)"
`eider	Suffix	"N(`eider ,)"
`endosperm	Suffix	"N(`endosperm ,)"
euca`lyptus	Suffix	"N(euca`lyptus ,)"
fa`rina	Suffix	"N(fa`rina ,)"
`feldspar	Suffix	"N(`feldspar ,)"
`fennel	Suffix	"N(`fennel ,)"
`fenugreek	Suffix	"N(`fenugreek ,)"
`fescue	Suffix	"N(`fescue ,)"
`fir	Suffix	"N(`fir ,)"
`flatworm	Suffix	"N(`flatworm ,)"
`fleabane	Suffix	"N(`fleabane ,)"
`foxglove	Suffix	"N(`foxglove ,)"
fram`besia	Suffix	"N(fram`besia ,)"
fri`tillary	Suffix	"N(fri`tillary ,)"
`furze	Suffix	"N(`furze ,)"
gail`lardia	Suffix	"N(gail`lardia ,)"
`gannet	Suffix	"N(`gannet ,)"
gar`denia	Suffix	"N(gar`denia ,)"
ge`ranium	Suffix	"N(ge`ranium ,)"
`gerbil	Suffix	"N(`gerbil ,)"
`gibbon	Suffix	"N(`gibbon ,)"
`ginseng	Suffix	"N(`ginseng ,)"
gi`raffe	Suffix	"N(gi`raffe ,)"
gladi`olus	Suffix	"N(gladi`olus ,)"
`gneiss	Suffix	"N(`gneiss ,)"
`godwit	Suffix	"N(`godwit ,)"
`goldenrod	Suffix	"N(`goldenrod ,)"
`goldfinch	Suffix	"N(`goldfinch ,)"
`goldfish	Suffix	"N(`goldfish ,)"
`gooseberry	Suffix	"N(`gooseberry ,)"
`gopher	Suffix	"N(`gopher ,)"
go`rilla	Suffix	"N(go`rilla ,)"
`gorse	Suffix	"N(`gorse ,)"
`goshawk	Suffix	"N(`goshawk ,)"
`grackle	Suffix	"N(`grackle ,)"
`grebe	Suffix	"N(`grebe ,)"
`grosbeak	Suffix	"N(`grosbeak ,)"
`guernsey	Suffix	"N(`guernsey ,)"
`guillemot	Suffix	"N(`guillemot ,)"
`gymnosperm	Suffix	"N(`gymnosperm ,)"
`halibut	Suffix	"N(`halibut ,)"
`hammerhead	Suffix	"N(`hammerhead ,)"
`hamster	Suffix	"N(`hamster ,)"
`hawthorn	Suffix	"N(`hawthorn ,)"
`hazel	Suffix	"N(`hazel ,)"
`hazelnut	Suffix	"N(`hazelnut ,)"
`hedgehog	Suffix	"N(`hedgehog ,)"
`heliotrope	Suffix	"N(`heliotrope ,)"
`hellbender	Suffix	"N(`hellbender ,)"
`hellebore	Suffix	"N(`hellebore ,)"
`hellgrammite	Suffix	"N(`hellgrammite ,)"
`hematite	Suffix	"N(`hematite ,)"
`henbane	Suffix	"N(`henbane ,)"
he`patica	Suffix	"N(he`patica ,)"
`hemlock	Suffix	"N(`hemlock ,)"
`heron	Suffix	"N(`heron ,)"
`hickory	Suffix	"N(`hickory ,)"
`holly	Suffix	"N(`holly ,)"
`hollyhock	Suffix	"N(`hollyhock ,)"
`honeybee	Suffix	"N(`honeybee ,)"
`honeydew	Suffix	"N(`honeydew ,)"
`honeysuckle	Suffix	"N(`honeysuckle ,)"
`hookworm	Suffix	"N(`hookworm ,)"
`horehound	Suffix	"N(`horehound ,)"
`hornbeam	Suffix	"N(`hornbeam ,)"
`hornblende	Suffix	"N(`hornblende ,)"
`horntail	Suffix	"N(`horntail ,)"
`horsefly	Suffix	"N(`horsefly ,)"
`housefly	Suffix	"N(`housefly ,)"
`huckleberry	Suffix	"N(`huckleberry ,)"
`hummingbird	Suffix	"N(`hummingbird ,)"
`hyacinth	Suffix	"N(`hyacinth ,)"
`ibex	Suffix	"N(`ibex ,)"
`ibis	Suffix	"N(`ibis ,)"
`iris	Suffix	"N(`iris ,)"
`ironwood	Suffix	"N(`ironwood ,)"
`jackdaw	Suffix	"N(`jackdaw ,)"
`jaguar	Suffix	"N(`jaguar ,)"
`jasper	Suffix	"N(`jasper ,)"
`jellyfish	Suffix	"N(`jellyfish ,)"
`jenny	Suffix	"N(`jenny ,)"
`joey	Suffix	"N(`joey ,)"
`jujube	Suffix	"N(`jujube ,)"
`julep	Suffix	"N(`julep ,)"
`jute	Suffix	"N(`jute ,)"
`kale	Suffix	"N(`kale ,)"
kanga`roo	Suffix	"N(kanga`roo ,)"
`kapok	Suffix	"N(`kapok ,)"
`kava	Suffix	"N(`kava ,)"
`kestrel	Suffix	"N(`kestrel ,)"
`kingbird	Suffix	"N(`kingbird ,)"
`kingfisher	Suffix	"N(`kingfisher ,)"
ko`ala	Suffix	"N(ko`ala ,)"
kohl`rabi	Suffix	"N(kohl`rabi ,)"
`kudzu	Suffix	"N(`kudzu ,)"
`kumquat	Suffix	"N(`kumquat ,)"
`lacewing	Suffix	"N(`lacewing ,)"
`larkspur	Suffix	"N(`larkspur ,)"
`laudanum	Suffix	"N(`laudanum ,)"
`laurel	Suffix	"N(`laurel ,)"
`leech	Suffix	"N(`leech ,)"
`leek	Suffix	"N(`leek ,)"
`leghorn	Suffix	"N(`leghorn ,)"
`lemming	Suffix	"N(`lemming ,)"
`leopard	Suffix	"N(`leopard ,)"
`lichen	Suffix	"N(`lichen ,)"
`lignite	Suffix	"N(`lignite ,)"
`limpet	Suffix	"N(`limpet ,)"
`limpkin	Suffix	"N(`limpkin ,)"
`linden	Suffix	"N(`linden ,)"
`linseed	Suffix	"N(`linseed ,)"
`lion	Suffix	"N(`lion ,)"
`lizard	Suffix	"N(`lizard ,)"
`lobo	Suffix	"N(`lobo ,)"
`lobster	Suffix	"N(`lobster ,)"
`locust	Suffix	"N(`locust ,)"
`lotus	Suffix	"N(`lotus ,)"
`lynx	Suffix	"N(`lynx ,)"
ma`caque	Suffix	"N(ma`caque ,)"
ma`caw	Suffix	"N(ma`caw ,)"
`mace	Suffix	"N(`mace ,)"
mag`nolia	Suffix	"N(mag`nolia ,)"
`magpie	Suffix	"N(`magpie ,)"
ma`hogany	Suffix	"N(ma`hogany ,)"
`mallard	Suffix	"N(`mallard ,)"
`manatee	Suffix	"N(`manatee ,)"
`mandrake	Suffix	"N(`mandrake ,)"
`mandrill	Suffix	"N(`mandrill ,)"
`mangrove	Suffix	"N(`mangrove ,)"
`marigold	Suffix	"N(`marigold ,)"
`marjoram	Suffix	"N(`marjoram ,)"
`marmot	Suffix	"N(`marmot ,)"
`marten	Suffix	"N(`marten ,)"
`martin	Suffix	"N(`martin ,)"
`mastodon	Suffix	"N(`mastodon ,)"
`mescal	Suffix	"N(`mescal ,)"
mes`quite	Suffix	"N(mes`quite ,)"
`midge	Suffix	"N(`midge ,)"
`milkweed	Suffix	"N(`milkweed ,)"
`millet	Suffix	"N(`millet ,)"
`millipede	Suffix	"N(`millipede ,)"
`minnow	Suffix	"N(`minnow ,)"
`mistletoe	Suffix	"N(`mistletoe ,)"
`mockingbird	Suffix	"N(`mockingbird ,)"
`mollusk	Suffix	"N(`mollusk ,)"
mo`rel	Suffix	"N(mo`rel ,)"
`mulberry	Suffix	"N(`mulberry ,)"
`murre	Suffix	"N(`murre ,)"
`muskmelon	Suffix	"N(`muskmelon ,)"
`muskrat	Suffix	"N(`muskrat ,)"
`mynah	Suffix	"N(`mynah ,)"
nas`turtium	Suffix	"N(nas`turtium ,)"
`newt	Suffix	"N(`newt ,)"
`nuthatch	Suffix	"N(`nuthatch ,)"
`nutria	Suffix	"N(`nutria ,)"
`octopus	Suffix	"N(`octopus ,)"
ole`ander	Suffix	"N(ole`ander ,)"
o`possum	Suffix	"N(o`possum ,)"
or`angutan	Suffix	"N(or`angutan ,)"
`orchid	Suffix	"N(`orchid ,)"
`oriole	Suffix	"N(`oriole ,)"
`ostrich	Suffix	"N(`ostrich ,)"
`otter	Suffix	"N(`otter ,)"
`owl	Suffix	"N(`owl ,)"
`owlet	Suffix	"N(`owl ,)"
`pampa	Suffix	"N(`pampa ,)"
`panther	Suffix	"N(`panther ,)"
`papaw	Suffix	"N(`papaw ,)"
`partridge	Suffix	"N(`partridge ,)"
`peccary	Suffix	"N(`peccary ,)"
`pelican	Suffix	"N(`pelican ,)"
`peony	Suffix	"N(`peony ,)"
`perch	Suffix	"N(`perch ,)"
`peregrine	Suffix	"N(`peregrine ,)"
`periwinkle	Suffix	"N(`periwinkle ,)"
per`simmon	Suffix	"N(per`simmon ,)"
pe`tunia	Suffix	"N(pe`tunia ,)"
`pheasant	Suffix	"N(`pheasant ,)"
`phlox	Suffix	"N(`phlox ,)"
`phoebe	Suffix	"N(`phoebe ,)"
`pickerel	Suffix	"N(`pickerel ,)"
`pistil	Suffix	"N(`pistil ,)"
`pitchblende	Suffix	"N(`pitchblende ,)"
`plover	Suffix	"N(`plover ,)"
plum`bago	Suffix	"N(plum`bago ,)"
poin`settia	Suffix	"N(poin`settia ,)"
`polecat	Suffix	"N(`polecat ,)"
`polliwog	Suffix	"N(`polliwog ,)"
`pollock	Suffix	"N(`pollock ,)"
`pompano	Suffix	"N(`pompano ,)"
`poppy	Suffix	"N(`poppy ,)"
`porcupine	Suffix	"N(`porcupine ,)"
`porpoise	Suffix	"N(`porpoise ,)"
portu`laca	Suffix	"N(portu`laca ,)"
`puffin	Suffix	"N(`puffin ,)"
`puma	Suffix	"N(`puma ,)"
`purslane	Suffix	"N(`purslane ,)"
`quahog	Suffix	"N(`quahog ,)"
rac`coon	Suffix	"N(rac`coon ,)"
ra`coon	Suffix	"N(ra`coon ,)"
`ragweed	Suffix	"N(`ragweed ,)"
`railbird	Suffix	"N(`railbird ,)"
`rattlesnake	Suffix	"N(`rattlesnake ,)"
`raven	Suffix	"N(`raven ,)"
`razorback	Suffix	"N(`razorback ,)"
`redbird	Suffix	"N(`redbird ,)"
`redbud	Suffix	"N(`redbud ,)"
`redwood	Suffix	"N(`redwood ,)"
`rhino	Suffix	"N(`rhino ,)"
rhodo`dendron	Suffix	"N(rhodo`dendron ,)"
`robin	Suffix	"N(`robin ,)"
`rodent	Suffix	"N(`rodent ,)"
`roebuck	Suffix	"N(`roebuck ,)"
`rosemary	Suffix	"N(`rosemary ,)"
`russet	Suffix	"N(`russet ,)"
`safflower	Suffix	"N(`safflower ,)"
`sagebrush	Suffix	"N(`sagebrush ,)"
`sago	Suffix	"N(`sago ,)"
sa`guaro	Suffix	"N(sa`guaro ,)"
`sailfish	Suffix	"N(`sailfish ,)"
`salamander	Suffix	"N(`salamander ,)"
`salmon	Suffix	"N(`salmon ,)"
`salsify	Suffix	"N(`salsify ,)"
`saltbush	Suffix	"N(`saltbush ,)"
`sandalwood	Suffix	"N(`sandalwood ,)"
`sanderling	Suffix	"N(`sanderling ,)"
`sandpiper	Suffix	"N(`sandpiper ,)"
`sandstone	Suffix	"N(`sandstone ,)"
`sapsucker	Suffix	"N(`sapsucker ,)"
`sawfish	Suffix	"N(`sawfish ,)"
`sawfly	Suffix	"N(`sawfly ,)"
`scaup	Suffix	"N(`scaup ,)"
`scorpion	Suffix	"N(`scorpion ,)"
`seagull	Suffix	"N(`seagull ,)"
`seahorse	Suffix	"N(`seahorse ,)"
`seal	Suffix	"N(`seal ,)"
`sepal	Suffix	"N(`sepal ,)"
`serviceberry	Suffix	"N(`serviceberry ,)"
`shadbush	Suffix	"N(`shadbush ,)"
`shagbark	Suffix	"N(`shagbark ,)"
`shoat	Suffix	"N(`shoat ,)"
`shrew	Suffix	"N(`shrew ,)"
`signet	Suffix	"N(`signet ,)"
`silkworm	Suffix	"N(`silkworm ,)"
`siskin	Suffix	"N(`siskin ,)"
`snapdragon	Suffix	"N(`snapdragon ,)"
`snowdrop	Suffix	"N(`snowdrop ,)"
`soybean	Suffix	"N(`soybean ,)"
`sphagnum	Suffix	"N(`sphagnum ,)"
`spruce	Suffix	"N(`spruce ,)"
`squid	Suffix	"N(`squid ,)"
`stamen	Suffix	"N(`stamen ,)"
`starling	Suffix	"N(`starling ,)"
`stickleback	Suffix	"N(`stickleback ,)"
`sturgeon	Suffix	"N(`sturgeon ,)"
`sugarcane	Suffix	"N(`sugarcane ,)"
`sunfish	Suffix	"N(`sunfish ,)"
`sunflower	Suffix	"N(`sunflower ,)"
`swallowtail	Suffix	"N(`swallowtail ,)"
`swordfish	Suffix	"N(`swordfish ,)"
`sycamore	Suffix	"N(`sycamore ,)"
`tamarack	Suffix	"N(`tamarack ,)"
`tanager	Suffix	"N(`tanager ,)"
`tansy	Suffix	"N(`tansy ,)"
`tapir	Suffix	"N(`tapir ,)"
`tarpon	Suffix	"N(`tarpon ,)"
`tapeworm	Suffix	"N(`tapeworm ,)"
ta`rantula	Suffix	"N(ta`rantula ,)"
`taro	Suffix	"N(`taro ,)"
`teasel	Suffix	"N(`teasel ,)"
`terrapin	Suffix	"N(`terrapin ,)"
`thrush	Suffix	"N(`thrush ,)"
`tiger	Suffix	"N(`tiger ,)"
`tigress	Suffix	"N(`tiger ,)"
`titmouse	Suffix	"N(`titmouse ,)"
`toad	Suffix	"N(`toad ,)"
`toadstool	Suffix	"N(`toadstool ,)"
`trilobite	Suffix	"N(`trilobite ,)"
`wallaby	Suffix	"N(`wallaby ,)"
`walrus	Suffix	"N(`walrus ,)"
`warthog	Suffix	"N(`warthog ,)"
`wasp	Suffix	"N(`wasp ,)"
`waterfowl	Suffix	"N(`waterfowl ,)"
`whelk	Suffix	"N(`whelk ,)"
`whitetail	Suffix	"N(`whitetail ,)"
`willow	Suffix	"N(`willow ,)"
`woodchuck	Suffix	"N(`woodchuck ,)"
`woodpecker	Suffix	"N(`woodpecker ,)"
`wren	Suffix	"N(`wren ,)"
`yak	Suffix	"N(`yak ,)"
`yam	Suffix	"N(`yam ,)"
`yucca	Suffix	"N(`yucca ,)"
`zebra	Suffix	"N(`zebra ,)"
`zebra	Suffix	"N(`zebra ,)"
archi`pelago	Suffix	"N(archi`pelago ,)"
avo`cado	Suffix	"N(avo`cado ,)"
`banjo	Suffix	"N(`banjo ,)"
`bongo	Suffix	"N(`bongo ,)"
`buffalo	Suffix	"N(`buffalo ,)"
`calico	Suffix	"N(`calico ,)"
ca`lypso	Suffix	"N(ca`lypso ,)"
`cameo	Suffix	"N(`cameo ,)"
`cargo	Suffix	"N(`cargo ,)"
com`mando	Suffix	"N(com`mando ,)"
cres`cendo	Suffix	"N(cres`cendo ,)"
despe`rado	Suffix	"N(despe`rado ,)"
`dingo	Suffix	"N(`dingo ,)"
`dodo	Suffix	"N(`dodo ,)"
`domino	Suffix	"N(`domino ,)"
fi`asco	Suffix	"N(fi`asco ,)"
fla`mingo	Suffix	"N(fla`mingo ,)"
far`rago	Suffix	"N(far`rago ,)"
`fresco	Suffix	"N(`fresco ,)"
`gecko	Suffix	"N(`gecko ,)"
`ghetto	Suffix	"N(`ghetto ,)"
`gingko	Suffix	"N(`gingko ,)"
`ginkgo	Suffix	"N(`ginkgo ,)"
`grotto	Suffix	"N(`grotto ,)"
`halo	Suffix	"N(`halo ,)"
`hero	Suffix	"N(`hero ,)"
`hobo	Suffix	"N(`hobo ,)"
innu`endo	Suffix	"N(innu`endo ,)"
`junco	Suffix	"N(`junco ,)"
`lingo	Suffix	"N(`lingo ,)"
`mango	Suffix	"N(`mango ,)"
mani`festo	Suffix	"N(mani`festo ,)"
me`mento	Suffix	"N(me`mento ,)"
mos`quito	Suffix	"N(mos`quito ,)"
`motto	Suffix	"N(`motto ,)"
mu`latto	Suffix	"N(mu`latto ,)"
`nacho	Suffix	"N(`nacho ,)"
`negro	Suffix	"N(`negro ,)"
pal`metto	Suffix	"N(pal`metto ,)"
po`litico	Suffix	"N(po`litico ,)"
`portico	Suffix	"N(`portico ,)"
po`tato	Suffix	"N(po`tato ,)"
pro`viso	Suffix	"N(pro`viso ,)"
`quarto	Suffix	"N(`quarto ,)"
`ratio	Suffix	"N(`ratio ,)"
`salvo	Suffix	"N(`salvo ,)"
sti`letto	Suffix	"N(sti`letto ,)"
to`mato	Suffix	"N(to`mato ,)"
tor`nado	Suffix	"N(tor`nado ,)"
tuxedo	Suffix	"N(tuxedo ,)"
vi`rago	Suffix	"N(vi`rago ,)"
vol`cano	Suffix	"N(vol`cano ,)"
`fez	Suffix	"N(`fez ,irreg)"
`fezzes	Clitic	"N(`fez ,pl)"
`quizzes	Clitic	"N(`quiz ,pl)"
`quizzer	Suffix	"N(`quiz ,)"
`colloquy	Suffix	"N(`colloquy ,irreg)"
`colloquies	Clitic	"N(`colloquy ,pl)"
`obloquy	Suffix	"N(`obloquy ,irreg)"
`obloquies	Clitic	"N(`obloquy ,pl)"
`obsequy	Suffix	"N(`obsequy ,irreg)"
`obsequies	Clitic	"N(`obsequy ,pl)"
so`liloquy	Suffix	"N(so`liloquy ,irreg)"
so`liloquies	Clitic	"N(so`liloquy ,pl)"
`alewife	Suffix	"N(`alewife ,irreg)"
`alewives	Clitic	"N(`alewife ,pl irreg)"
`bookshelf	Suffix	"N(`bookshelf ,irreg)"
`bookshelves	Clitic	"N(`bookshelf ,pl irreg)"
`calf	Suffix	"N(`calf ,)"
`calves	Clitic	"N(`calf ,pl irreg)"
`dwarves	Clitic	"N(`dwarf ,pl irreg)"
`elf	Suffix	"N(`elf ,)"
`elves	Clitic	"N(`elf ,pl irreg)"
`half	Suffix	"N(`half ,)"
`halves	Clitic	"N(`half ,pl irreg)"
`halflife	Suffix	"N(`halflife ,)"
`halflives	Clitic	"N(`halflife ,pl irreg)"
`hoof	Suffix	"N(`hoof ,)"
`hooves	Clitic	"N(`hoof ,pl irreg)"
`housewife	Suffix	"N(`housewife ,irreg)"
`housewives	Clitic	"N(`housewife ,pl irreg)"
`knife	Suffix	"N(`knife ,irreg)"
`knives	Clitic	"N(`knife ,pl irreg)"
`leaf	Suffix	"N(`leaf ,)"
`leaves	Clitic	"N(`leaf ,pl irreg)"
`life	Suffix	"N(`life ,irreg)"
`lives	Clitic	"N(`life ,pl irreg)"
`loaf	Suffix	"N(`loaf ,)"
`loaves	Clitic	"N(`loaf ,pl irreg)"
`midwife	Suffix	"N(`midwife ,irreg)"
`midwives	Clitic	"N(`midwife ,pl irreg)"
`scarf	Suffix	"N(`scarf ,)"
`scarves	Clitic	"N(`scarf ,pl irreg)"
`self	Suffix	"N(`self ,irreg)"
`selves	Clitic	"N(`self ,pl irreg)"
`sheaf	Suffix	"N(`sheaf ,)"
`sheaves	Clitic	"N(`sheaf ,pl irreg)"
`shelf	Suffix	"N(`shelf ,irreg)"
`shelves	Clitic	"N(`shelf ,pl irreg)"
`staff	Suffix	"N(`staff ,)"
`staves	Clitic	"N(`staff ,pl irreg)"
`thief	Suffix	"N(`thief ,)"
`thieves	Clitic	"N(`thief ,pl irreg)"
`turf	Suffix	"N(`turf ,)"
`turves	Clitic	"N(`turf ,pl irreg)"
`werewolf	Suffix	"N(`werewolf ,irreg)"
`werewolves	Clitic	"N(`werewolf ,pl irreg)"
`wharf	Suffix	"N(`wharf ,)"
`wharves	Clitic	"N(`wharf ,pl irreg)"
`wife	Suffix	"N(`wife ,irreg)"
`wives	Clitic	"N(`wife ,pl irreg)"
`wolf	Suffix	"N(`wolf ,irreg)"
`wolves	Clitic	"N(`wolf ,pl irreg)"
`dormouse	Suffix	"N(`dormouse ,irreg)"
`dormice	Clitic	"N(`dormouse ,pl irreg)"
`foot	Suffix	"N(`foot ,irreg)"
`feet	Clitic	"N(`foot ,pl irreg)"
`goose	Suffix	"N(`goose ,irreg)"
`geese	Clitic	"N(`goose ,pl irreg)"
`louse	Suffix	"N(`louse ,irreg)"
`lice	Clitic	"N(`louse ,pl irreg)"
`man	Suffix	"N(`man ,irreg ajr13)"
`men	Clitic	"N(`man ,pl irreg)"
`mongoose	Suffix	"N(`mongoose ,irreg)"
`mongeese	Clitic	"N(`mongoose ,pl irreg)"
`mouse	Suffix	"N(`mouse ,irreg)"
`mice	Clitic	"N(`mouse ,pl irreg)"
`tooth	Suffix	"N(`tooth ,irreg)"
`teeth	Clitic	"N(`tooth ,pl irreg)"
`woman	Suffix	"N(`woman ,irreg ajr13)"
`women	Clitic	"N(`woman ,pl irreg)"
`alderman	Suffix	"N(`alderman ,irreg)"
`aldermen	Clitic	"N(`alderman ,pl irreg)"
`bogeyman	Suffix	"N(`bogeyman ,irreg)"
`bogeymen	Clitic	"N(`bogeyman ,pl irreg)"
`bondsman	Suffix	"N(`bondsman ,irreg)"
`bondsmen	Clitic	"N(`bondsman ,pl irreg)"
`brakeman	Suffix	"N(`brakeman ,irreg)"
`brakemen	Clitic	"N(`brakeman ,pl irreg)"
`craftsman	Suffix	"N(`craftsman ,irreg)"
`craftsmen	Clitic	"N(`craftsman ,pl irreg)"
`draftsman	Suffix	"N(`draftsman ,irreg)"
`draftsmen	Clitic	"N(`draftsman ,pl irreg)"
`fisherman	Suffix	"N(`fisherman ,irreg)"
`fishermen	Clitic	"N(`fisherman ,pl irreg)"
`footman	Suffix	"N(`footman ,irreg)"
`footmen	Clitic	"N(`footman ,pl irreg)"
`freedmen	Clitic	"N(`freedman ,pl irreg)"
`freeman	Suffix	"N(`freeman ,irreg)"
`freemen	Clitic	"N(`freeman ,pl irreg)"
`freewoman	Suffix	"N(`freewoman ,irreg)"
`freewomen	Clitic	"N(`freewoman ,pl irreg)"
`freshman	Suffix	"N(`freshman ,irreg)"
`freshmen	Clitic	"N(`freshman ,pl irreg)"
fron`tiersman	Suffix	"N(fron`tiersman ,irreg)"
fron`tiersmen	Clitic	"N(fron`tiersman ,pl irreg)"
`gamesman	Suffix	"N(`gamesman ,irreg)"
`gamesmen	Clitic	"N(`gamesman ,pl irreg)"
`gentleman	Suffix	"N(`gentleman ,irreg)"
`gentlemen	Clitic	"N(`gentleman ,pl irreg)"
`guardsman	Suffix	"N(`guardsman ,irreg)"
`guardsmen	Clitic	"N(`guardsman ,pl irreg)"
`handyman	Suffix	"N(`handyman ,irreg)"
`handymen	Clitic	"N(`handyman ,pl irreg)"
`hangman	Suffix	"N(`hangman ,irreg)"
`hangmen	Clitic	"N(`hangman ,pl irreg)"
`headsman	Suffix	"N(`headsman ,irreg)"
`headsmen	Clitic	"N(`headsman ,pl irreg)"
`helmsman	Suffix	"N(`helmsman ,irreg)"
`helmsmen	Clitic	"N(`helmsman ,pl irreg)"
`henchman	Suffix	"N(`henchman ,irreg)"
`henchmen	Clitic	"N(`henchman ,pl irreg)"
`herdsman	Suffix	"N(`herdsman ,irreg)"
`herdsmen	Clitic	"N(`herdsman ,pl irreg)"
`husbandman	Suffix	"N(`husbandman ,irreg)"
`husbandmen	Clitic	"N(`husbandman ,pl irreg)"
`journeyman	Suffix	"N(`journeyman ,irreg)"
`journeymen	Clitic	"N(`journeyman ,pl irreg)"
`klansman	Suffix	"N(`klansman ,irreg)"
`klansmen	Clitic	"N(`klansman ,pl irreg)"
`kinsman	Suffix	"N(`kinsman ,irreg)"
`kinsmen	Clitic	"N(`kinsman ,pl irreg)"
`landsman	Suffix	"N(`landsman ,irreg)"
`landsmen	Clitic	"N(`landsman ,pl irreg)"
`layman	Suffix	"N(`layman ,irreg)"
`laymen	Clitic	"N(`layman ,pl irreg)"
`leadsman	Suffix	"N(`leadsman ,irreg)"
`leadsmen	Clitic	"N(`leadsman ,pl irreg)"
`madman	Suffix	"N(`madman ,irreg)"
`madmen	Clitic	"N(`madman ,pl irreg)"
`marksman	Suffix	"N(`marksman ,irreg)"
`marksmen	Clitic	"N(`marksman ,pl irreg)"
`merman	Suffix	"N(`merman ,irreg)"
`mermen	Clitic	"N(`merman ,pl irreg)"
`middleman	Suffix	"N(`middleman ,irreg)"
`middlemen	Clitic	"N(`middleman ,pl irreg)"
`nobleman	Suffix	"N(`nobleman ,irreg)"
`noblemen	Clitic	"N(`nobleman ,pl irreg)"
`oarsman	Suffix	"N(`oarsman ,irreg)"
`oarsmen	Clitic	"N(`oarsman ,pl irreg)"
`ombudsman	Suffix	"N(`ombudsman ,irreg)"
`ombudsmen	Clitic	"N(`ombudsman ,pl irreg)"
re`pairman	Suffix	"N(re`pairman ,irreg)"
re`pairmen	Clitic	"N(re`pairman ,pl irreg)"
`salesman	Suffix	"N(`salesman ,irreg)"
`salesmen	Clitic	"N(`salesman ,pl irreg)"
`selectman	Suffix	"N(`selectman ,irreg)"
`selectmen	Clitic	"N(`selectman ,pl irreg)"
`swordsman	Suffix	"N(`swordsman ,irreg)"
`swordsmen	Clitic	"N(`swordsman ,pl irreg)"
`spokesman	Suffix	"N(`spokesman ,irreg)"
`spokesmen	Clitic	"N(`spokesman ,pl irreg)"
`spokeswoman	Suffix	"N(`spokeswoman ,irreg)"
`spokeswomen	Clitic	"N(`spokeswoman ,pl irreg)"
`statesman	Suffix	"N(`statesman ,irreg)"
`statesmen	Clitic	"N(`statesman ,pl irreg)"
`strongman	Suffix	"N(`strongman ,irreg)"
`strongmen	Clitic	"N(`strongman ,pl irreg)"
`swordsman	Suffix	"N(`swordsman ,irreg)"
`swordsmen	Clitic	"N(`swordsman ,pl irreg)"
`tradesman	Suffix	"N(`tradesman ,irreg)"
`tradesmen	Clitic	"N(`tradesman ,pl irreg)"
`tribesman	Suffix	"N(`tribesman ,irreg)"
`tribesmen	Clitic	"N(`tribesman ,pl irreg)"
under`classman	Suffix	"N(under`classman ,irreg)"
under`classmen	Clitic	"N(under`classman ,pl irreg)"
upper`classman	Suffix	"N(upper`classman ,irreg)"
upper`classmen	Clitic	"N(upper`classman ,pl irreg)"
`watchman	Suffix	"N(`watchman ,irreg)"
`watchmen	Clitic	"N(`watchman ,pl irreg)"
`yachtsman	Suffix	"N(`yachtsman ,irreg)"
`yachtsmen	Clitic	"N(`yachtsman ,pl irreg)"
`brother	Suffix	"N(`brother ,)"
`brethren	Clitic	"N(`brother ,pl irreg)"
`brainchild	Suffix	"N(`brainchild ,irreg)"
`brainchildren	Clitic	"N(`brainchild ,pl irreg)"
`child	Suffix	"N(`child ,irreg)"
`children	Clitic	"N(`child ,pl irreg)"
`godchild	Suffix	"N(`godchild ,irreg)"
`godchildren	Clitic	"N(`godchild ,pl irreg)"
`grandchild	Suffix	"N(`grandchild ,irreg)"
`grandchildren	Clitic	"N(`grandchild ,pl irreg)"
`ox	Suffix	"N(`ox ,irreg)"
`oxen	Clitic	"N(`ox ,pl irreg)"
`muskox	Suffix	"N(`muskox ,irreg)"
`muskoxen	Clitic	"N(`muskox ,pl irreg)"
abc	Suffix	"N(abc ,irreg)"
abc's	Suffix	"N(abc ,pl irreg)"
`die	Suffix	"N(`die ,)"
`dice	Clitic	"N(`dice ,irreg)"
`dice	Clitic	"N(`die ,pl irreg)"
passer`by	Suffix	"N(passer`by ,irreg)"
passers`by	Clitic	"N(passer`by ,pl)"
`penny	Suffix	"N(`penny ,)"
`pence	Clitic	"N(`penny ,pl irreg)"
`chili	Suffix	"N(`chili ,)"
`chilies	Clitic	"N(`chili ,pl irreg)"
`abacus	Suffix	"N(`abacus ,)"
`abaci	Clitic	"N(`abacus ,pl irreg)"
ab`scissa	Suffix	"N(ab`scissa ,)"
ab`scissae	Clitic	"N(ab`scissa ,pl irreg)"
ad`dendum	Suffix	"N(ad`dendum ,)"
ad`denda	Clitic	"N(ad`dendum ,pl irreg)"
a`dieu	Suffix	"N(a`dieu ,)"
a`dieux	Clitic	"N(a`dieu ,pl irreg)"
`alga	Suffix	"N(`alga ,irreg)"
`algae	Clitic	"N(`alga ,pl irreg)"
al`luvium	Suffix	"N(al`luvium ,)"
al`luvia	Clitic	"N(al`luvium ,pl irreg)"
a`lumna	Suffix	"N(a`lumna ,irreg)"
a`lumnae	Clitic	"N(a`lumna ,pl irreg)"
a`lumnus	Suffix	"N(a`lumnus ,irreg)"
a`lumni	Clitic	"N(a`lumnus ,pl irreg)"
alve`olus	Suffix	"N(alve`olus ,)"
alve`oli	Clitic	"N(alve`olus ,pl irreg)"
amanu`ensis	Suffix	"N(amanu`ensis ,irreg)"
amanu`enses	Clitic	"N(amanu`ensis ,pl irreg)"
a`moeba	Suffix	"N(a`moeba ,)"
a`moebae	Clitic	"N(a`moeba ,pl irreg)"
a`nalysis	Suffix	"N(`analyze ,irreg deverb)"
a`nalyses	Clitic	"N(`analyze ,pl irreg deverb)"
`annulus	Suffix	"N(`annulus ,irreg)"
`annuli	Clitic	"N(`annulus ,pl irreg)"
an`tenna	Suffix	"N(an`tenna ,)"
an`tennae	Clitic	"N(an`tenna ,pl irreg)"
an`tithesis	Suffix	"N(an`tithesis ,irreg)"
an`titheses	Clitic	"N(an`tithesis ,pl irreg)"
apothe`osis	Suffix	"N(apothe`osis ,irreg)"
apothe`oses	Clitic	"N(apothe`osis ,pl irreg)"
appa`ratchik	Suffix	"N(appa`ratchik ,)"
appa`ratchiki	Suffix	"N(appa`ratchik ,pl irreg)"
ap`pendix	Suffix	"N(ap`pendix ,)"
ap`pendices	Clitic	"N(ap`pendix ,pl irreg)"
`apex	Suffix	"N(`apex ,)"
`apices	Clitic	"N(`apex ,pl irreg)"
a`quarium	Suffix	"N(a`quarium ,)"
a`quaria	Clitic	"N(a`quarium ,pl irreg)"
`atrium	Suffix	"N(`atrium ,)"
`atria	Clitic	"N(`atrium ,pl irreg)"
au`tomaton	Suffix	"N(au`tomaton ,)"
au`tomata	Clitic	"N(au`tomaton ,pl irreg)"
`axis	Suffix	"N(`axis ,irreg)"
`axes	Clitic	"N(`axis ,pl irreg)"
baccha`nalia	Suffix	"N(baccha`nalia ,)"
baccha`nalia	Clitic	"N(baccha`nalia ,pl irreg)"
ba`cillus	Suffix	"N(ba`cillus ,irreg)"
ba`cilli	Clitic	"N(ba`cillus ,pl irreg)"
bac`terium	Suffix	"N(bac`terium ,irreg)"
bac`teria	Clitic	"N(bac`terium ,pl irreg)"
`basis	Suffix	"N(`basis ,irreg)"
`bases	Clitic	"N(`basis ,pl irreg)"
`basso	Suffix	"N(`basso ,)"
`bassi	Clitic	"N(`basso ,pl irreg)"
ba`teau	Suffix	"N(ba`teau ,)"
ba`teaux	Clitic	"N(ba`teau ,pl irreg)"
`beau	Suffix	"N(`beau ,)"
`beaux	Clitic	"N(`beau ,pl irreg)"
bi`ennium	Suffix	"N(bi`ennium ,)"
bi`ennia	Suffix	"N(bi`ennium ,pl irreg)"
`bronchus	Suffix	"N(`bronchus ,irreg)"
`bronchi	Clitic	"N(`bronchus ,pl irreg)"
`bursa	Suffix	"N(`bursa ,)"
`bursae	Clitic	"N(`bursa ,pl irreg)"
`cactus	Suffix	"N(`cactus ,)"
`cacti	Clitic	"N(`cactus ,pl irreg)"
`calculus	Suffix	"N(`calculus ,)"
`calculi	Clitic	"N(`calculus ,pl irreg)"
cande`labrum	Suffix	"N(cande`labrum ,)"
cande`labra	Clitic	"N(cande`labrum ,pl irreg)"
ca`talysis	Suffix	"N(ca`talysis ,irreg)"
ca`talyses	Clitic	"N(ca`talysis ,pl irreg)"
ca`tharsis	Suffix	"N(ca`tharsis ,irreg)"
ca`tharses	Clitic	"N(ca`tharsis ,pl irreg)"
`cervix	Suffix	"N(`cervix ,)"
`cervices	Clitic	"N(`cervix ,pl irreg)"
cha`teau	Suffix	"N(cha`teau ,)"
cha`teaux	Clitic	"N(cha`teau ,pl irreg)"
`cherub	Suffix	"N(`cherub ,)"
`cherubim	Clitic	"N(`cherub ,pl irreg)"
`cicatrix	Suffix	"N(`cicatrix ,)"
cica`trices	Clitic	"N(`cicatrix ,pl irreg)"
`cilium	Suffix	"N(`cilium ,irreg)"
`cilia	Clitic	"N(`cilium ,pl irreg)"
`codex	Suffix	"N(`codex ,)"
`codices	Clitic	"N(`codex ,pl irreg)"
col`loquium	Suffix	"N(col`loquium ,)"
col`loquia	Clitic	"N(col`loquium ,pl irreg)"
`colossus	Suffix	"N(`colossus ,)"
`colossi	Clitic	"N(`colossus ,pl irreg)"
com`pendium	Suffix	"N(com`pendium ,)"
com`pendia	Clitic	"N(com`pendium ,pl irreg)"
con`certo	Suffix	"N(con`certo ,)"
con`certi	Clitic	"N(con`certo ,pl irreg)"
con`tinuum	Suffix	"N(con`tinuum ,)"
con`tinua	Clitic	"N(con`tinuum ,pl irreg)"
`corpus	Suffix	"N(`corpus ,)"
`corpora	Clitic	"N(`corpus ,pl irreg)"
corri`gendum	Suffix	"N(corri`gendum ,)"
corri`genda	Clitic	"N(corri`gendum ,pl irreg)"
`cortex	Suffix	"N(`cortex ,)"
`cortices	Clitic	"N(`cortex ,pl irreg)"
`cranium	Suffix	"N(`cranium ,)"
`crania	Clitic	"N(`cranium ,pl irreg)"
`crisis	Suffix	"N(`crisis ,irreg)"
`crises	Clitic	"N(`crisis ,pl irreg)"
cri`terion	Suffix	"N(cri`terion ,irreg)"
cri`teria	Clitic	"N(cri`terion ,pl irreg)"
`crocus	Suffix	"N(`crocus ,)"
`croci	Clitic	"N(`crocus ,pl irreg)"
cur`riculum	Suffix	"N(cur`riculum ,)"
cur`ricula	Clitic	"N(cur`riculum ,pl irreg)"
`datum	Suffix	"N(`datum ,irreg)"
`data	Clitic	"N(`datum ,)"
`data	Clitic	"N(`datum ,pl irreg)"
deside`ratum	Suffix	"N(deside`ratum ,irreg)"
deside`rata	Clitic	"N(deside`ratum ,pl irreg)"
di`aeresis	Suffix	"N(di`aeresis ,irreg)"
di`aereses	Clitic	"N(di`aeresis ,pl irreg)"
di`eresis	Suffix	"N(di`eresis ,irreg)"
di`ereses	Clitic	"N(di`eresis ,pl irreg)"
diag`nosis	Suffix	"N(diag`nose ,irreg deverb)"
diag`noses	Clitic	"N(diag`nose ,pl irreg deverb)"
`dictum	Suffix	"N(`dictum ,)"
`dicta	Clitic	"N(`dictum ,pl irreg)"
di`rectrix	Suffix	"N(di`rectrix ,)"
di`rectrices	Clitic	"N(di`rectrix ,pl irreg)"
dodeca`hedron	Suffix	"N(dodeca`hedron ,)"
dodeca`hedra	Clitic	"N(dodeca`hedron ,pl irreg)"
ef`fluvium	Suffix	"N(ef`fluvium ,irreg)"
ef`fluvia	Clitic	"N(ef`fluvium ,pl irreg)"
el`lipsis	Suffix	"N(el`lipsis ,irreg)"
el`lipses	Clitic	"N(el`lipsis ,pl irreg)"
`emphasis	Suffix	"N(`emphasize ,irreg deverb)"
`emphases	Clitic	"N(`emphasize ,pl irreg deverb)"
en`comium	Suffix	"N(en`comium ,)"
en`comia	Clitic	"N(en`comium ,pl irreg)"
e`phemeris	Suffix	"N(e`phemeris ,)"
e`phemerides	Clitic	"N(e`phemeris ,pl irreg)"
equi`librium	Suffix	"N(equi`librium ,)"
equi`libria	Clitic	"N(equi`librium ,pl irreg)"
er`ratum	Suffix	"N(er`ratum ,irreg)"
er`rata	Clitic	"N(er`ratum ,pl irreg)"
e`sophagus	Suffix	"N(e`sophagus ,)"
e`sophagi	Clitic	"N(e`sophagus ,pl irreg)"
ex`tremum	Suffix	"N(ex`tremum ,)"
ex`trema	Clitic	"N(ex`tremum ,pl irreg)"
fas`ciculus	Suffix	"N(fas`ciculus ,)"
fas`ciculi	Clitic	"N(fas`ciculus ,pl irreg)"
`foci	Clitic	"N(`focus ,pl irreg)"
`formula	Suffix	"N(`formula ,)"
`formulae	Clitic	"N(`formula ,pl irreg)"
`forum	Suffix	"N(`forum ,)"
`fora	Clitic	"N(`forum ,pl irreg)"
`fovea	Suffix	"N(`fovea ,)"
`foveae	Clitic	"N(`fovea ,pl irreg)"
`frustum	Suffix	"N(`frustum ,)"
`frusta	Clitic	"N(`frustum ,pl irreg)"
`fungus	Suffix	"N(`fungus ,)"
`fungi	Clitic	"N(`fungus ,pl irreg)"
`ganglion	Suffix	"N(`ganglion ,)"
`ganglia	Clitic	"N(`ganglion ,pl irreg)"
`genius	Suffix	"N(`genius ,)"
`genii	Clitic	"N(`genius ,pl irreg)"
`genus	Suffix	"N(`genus ,)"
`genera	Clitic	"N(`genus ,pl irreg)"
`goy	Suffix	"N(`goy ,)"
`goyim	Clitic	"N(`goy ,pl irreg)"
graf`fito	Suffix	"N(graf`fito ,irreg)"
graf`fiti	Clitic	"N(graf`fito ,pl irreg)"
hema`toma	Suffix	"N(hema`toma ,)"
hemato`mata	Clitic	"N(hema`toma ,pl irreg)"
haema`toma	Suffix	"N(haema`toma ,)"
haemato`mata	Clitic	"N(hema`toma ,pl irreg)"
`hilum	Suffix	"N(`hilum ,)"
`hila	Clitic	"N(`hilum ,pl irreg)"
hippo`potamus	Suffix	"N(hippo`potamus ,)"
hippo`potami	Clitic	"N(hippo`potamus ,pl irreg)"
hono`rarium	Suffix	"N(hono`rarium ,)"
hono`raria	Clitic	"N(hono`rarium ,pl irreg)"
hy`perbola	Suffix	"N(hy`perbola ,)"
hy`perbolae	Clitic	"N(hy`perbola ,pl irreg)"
hy`pothesis	Suffix	"N(hy`pothesis ,irreg)"
hy`potheses	Clitic	"N(hy`pothesis ,pl irreg)"
`incubus	Suffix	"N(`incubus ,)"
`incubi	Clitic	"N(`incubus ,pl irreg)"
`indices	Clitic	"N(`index ,pl irreg)"
inter`regnum	Suffix	"N(inter`regnum ,)"
inter`regnna	Clitic	"N(inter`regnum ,pl irreg)"
`isthmus	Suffix	"N(`isthmus ,)"
`isthmi	Clitic	"N(`isthmus ,pl irreg)"
kib`butz	Suffix	"N(kib`butz ,)"
kib`butzim	Clitic	"N(kib`butz ,pl irreg)"
la`cuna	Suffix	"N(la`cuna ,irreg)"
la`cunae	Clitic	"N(la`cuna ,pl irreg)"
la`mella	Suffix	"N(la`mella ,irreg)"
la`mellae	Clitic	"N(la`mella ,pl irreg)"
`lamina	Suffix	"N(`lamina ,irreg)"
`laminae	Clitic	"N(`lamina ,pl irreg)"
`larva	Suffix	"N(`larva ,irreg)"
`larvae	Clitic	"N(`larva ,pl irreg)"
`larynx	Suffix	"N(`larynx ,)"
la`rynges	Clitic	"N(`larynx ,pl irreg)"
`lexicon	Suffix	"N(`lexicon ,)"
`lexica	Clitic	"N(`lexicon ,pl irreg)"
li`bretto	Suffix	"N(li`bretto ,)"
li`bretti	Clitic	"N(li`bretto ,pl irreg)"
`lingua	Suffix	"N(`lingua ,)"
`linguae	Clitic	"N(`lingua ,pl irreg)"
`locus	Suffix	"N(`locus ,)"
`loci	Clitic	"N(`locus ,pl irreg)"
lym`phoma	Suffix	"N(lym`phoma ,)"
lympho`mata	Clitic	"N(lym`phoma ,pl irreg)"
maca`roni	Suffix	"N(maca`roni ,)"
maca`ronies	Clitic	"N(maca`roni ,pl)"
`madam	Suffix	"N(`madam ,)"
ma`dame	Suffix	"N(ma`dame ,)"
mes`dames	Clitic	"N(`madam/ma`dame ,pl irreg)"
`maestro	Suffix	"N(`maestro ,)"
`maestri	Clitic	"N(`maestro ,pl irreg)"
`magus	Suffix	"N(`magus ,)"
`magi	Clitic	"N(`magus ,pl irreg)"
`mantis	Suffix	"N(`mantis ,)"
`mantes	Clitic	"N(`mantis ,pl irreg)"
`mare	Suffix	"N(`mare - female horse,)"
`maria	Clitic	"N(`mare ,pl irreg)"
`matrix	Suffix	"N(`matrix ,)"
`matrices	Clitic	"N(`matrix ,pl irreg)"
`maximum	Suffix	"N(`maximum ,)"
`maxima	Clitic	"N(`maximum ,pl irreg)"
`medium	Suffix	"N(`medium - means of conveying,)"
`media	Clitic	"N(`medium ,)"
`media	Clitic	"N(`medium ,pl irreg)"
mela`noma	Suffix	"N(mela`noma ,)"
melano`mata	Clitic	"N(mela`noma ,pl irreg)"
`memorandum	Suffix	"N(`memorandum ,)"
`memoranda	Clitic	"N(`memorandum ,pl irreg)"
me`niscus	Suffix	"N(me`niscus ,)"
me`nisci	Clitic	"N(me`niscus ,pl irreg)"
mi`lieu	Suffix	"N(mi`lieu ,)"
mi`lieux	Clitic	"N(mi`lieu ,pl irreg)"
mil`lennium	Suffix	"N(mil`lennium ,)"
mil`lennia	Clitic	"N(mil`lenium ,pl irreg)"
`minimum	Suffix	"N(`minimum ,)"
`minima	Clitic	"N(`minimum ,pl irreg)"
mi`nutia	Suffix	"N(mi`nutia ,irreg)"
mi`nutiae	Clitic	"N(mi`nutia ,pl irreg)"
`modulus	Suffix	"N(`modulus ,)"
`moduli	Clitic	"N(`modulus ,pl irreg)"
mo`mentum	Suffix	"N(mo`mentum ,)"
mo`menta	Clitic	"N(mo`mentum ,pl irreg)"
`money	Suffix	"N(`money ,ajr8)"
`monies	Clitic	"N(`money ,pl irreg)"
mon`sieur	Suffix	"N(mon`sieur ,)"
mes`sieurs	Clitic	"N(mon`sieur ,pl irreg)"
mora`torium	Suffix	"N(mora`torium ,)"
mora`toria	Clitic	"N(mora`torium ,pl irreg)"
mu`cosa	Suffix	"N(mu`cosa ,)"
mu`cosae	Clitic	"N(mu`cosa ,pl irreg)"
`naiad	Suffix	"N(`naiad ,)"
`naiades	Clitic	"N(`naiad ,pl irreg)"
nar`cosis	Suffix	"N(nar`cosis ,irreg)"
nar`coses	Clitic	"N(nar`cosis ,pl irreg)"
`nebula	Suffix	"N(`nebula ,)"
`nebulae	Clitic	"N(`nebula ,pl irreg)"
`nemesis	Suffix	"N(`nemesis ,irreg)"
`nemeses	Clitic	"N(`nemesis ,pl irreg)"
neu`rosis	Suffix	"N(neu`rosis ,irreg)"
neu`roses	Clitic	"N(neu`rosis ,pl irreg)"
`nimbus	Suffix	"N(`nimbus ,)"
`nimbi	Clitic	"N(`nimbus ,pl irreg)"
`nova	Suffix	"N(`nova ,)"
`novae	Clitic	"N(`nova ,pl irreg)"
no`vella	Suffix	"N(no`vella ,)"
no`velle	Clitic	"N(no`vella ,pl irreg)"
nucle`olus	Suffix	"N(nucle`olus ,)"
nucle`oli	Clitic	"N(nucle`olus ,pl irreg)"
`nucleus	Suffix	"N(`nucleus ,)"
`nuclei	Clitic	"N(`nucleus ,pl irreg)"
o`asis	Suffix	"N(o`asis ,irreg)"
o`ases	Clitic	"N(o`asis ,pl irreg)"
octa`hedron	Suffix	"N(octa`hedron ,)"
octa`hedra	Clitic	"N(octa`hedron ,pl irreg)"
`octopus	Suffix	"N(`octopus ,)"
`octopi	Clitic	"N(`octopus ,pl irreg)"
`opus	Suffix	"N(`opus ,)"
`opera	Clitic	"N(`opus ,pl irreg)"
`optimum	Suffix	"N(`optimum ,)"
`optima	Clitic	"N(`optimum ,pl irreg)"
`ovum	Suffix	"N(`ovum ,irreg)"
`ova	Clitic	"N(`ovum ,pl irreg)"
pa`lazzo	Suffix	"N(pa`lazzo ,)"
pa`lazzi	Clitic	"N(pa`lazzo ,pl irreg)"
pal`ladium	Suffix	"N(pal`ladium ,)"
pal`ladia	Clitic	"N(pal`ladium ,pl irreg)"
pan`jandrum	Suffix	"N(pan`jandrum ,)"
pan`jandra	Clitic	"N(pan`jandrum ,pl irreg)"
papa`razzo	Suffix	"N(papa`razzo ,)"
papa`razzi	Clitic	"N(papa`razzo ,pl irreg)"
pa`pilla	Suffix	"N(pa`pilla ,)"
pa`pillae	Clitic	"N(pa`pilla ,pl irreg)"
papil`loma	Suffix	"N(papil`loma ,)"
papil`lomata	Clitic	"N(papil`loma ,pl irreg)"
`pappus	Suffix	"N(`pappus ,irreg)"
`pappi	Clitic	"N(`pappus ,pl irreg)"
pa`pyrus	Suffix	"N(pa`pyrus ,)"
pa`pyri	Clitic	"N(pa`pyrus ,pl irreg)"
pa`ralysis	Suffix	"N(pa`ralysis ,irreg)"
pa`ralyses	Clitic	"N(pa`ralysis ,pl irreg)"
pa`renthesis	Suffix	"N(pa`renthesis ,irreg)"
pa`rentheses	Clitic	"N(pa`renthesis ,pl irreg)"
pe`numbra	Suffix	"N(pe`numbra ,)"
pe`numbrae	Clitic	"N(pe`numbra ,pl irreg)"
peri`helion	Suffix	"N(peri`helion ,)"
peri`helia	Clitic	"N(peri`helion ,pl irreg)"
per`sona	Suffix	"N(per`sona ,)"
per`sonae	Clitic	"N(per`sona ,pl irreg)"
`phallus	Suffix	"N(`phallus ,)"
`phalli	Clitic	"N(`phallus ,pl irreg)"
phe`nomenon	Suffix	"N(phe`nomenon ,irreg)"
phe`nomena	Clitic	"N(phe`nomenon ,pl irreg)"
`phylum	Suffix	"N(`phylum ,)"
`phyla	Clitic	"N(`phylum ,pl irreg)"
pla`centa	Suffix	"N(pla`centa ,)"
pla`centae	Clitic	"N(pla`centa ,pl irreg)"
plane`tarium	Suffix	"N(plane`tarium ,)"
plane`taria	Clitic	"N(plane`tarium ,pl irreg)"
`plenum	Suffix	"N(`plenum ,irreg)"
`plena	Clitic	"N(`plenum ,pl irreg)"
`pleura	Suffix	"N(`pleura ,irreg)"
`pleurae	Clitic	"N(`pleura ,pl irreg)"
`podium	Suffix	"N(`podium ,)"
`podia	Clitic	"N(`podium ,pl irreg)"
`polis	Suffix	"N(`polis ,irreg)"
`poleis	Clitic	"N(`polis ,pl irreg)"
poly`hedron	Suffix	"N(poly`hedron ,)"
poly`hedra	Clitic	"N(poly`hedron ,pl irreg)"
portman`teau	Suffix	"N(portman`teau ,)"
portman`teaux	Clitic	"N(portman`teau ,pl irreg)"
`precis	Suffix	"N(`precis ,irreg)"
`precis	Clitic	"N(`precis ,pl irreg)"
prog`nosis	Suffix	"N(prog`nosis ,irreg)"
prog`noses	Clitic	"N(prog`nosis ,pl irreg)"
prole`gomenon	Suffix	"N(prole`gomenon ,irreg)"
prole`gomena	Clitic	"N(prole`gomenon ,pl irreg)"
pros`thesis	Suffix	"N(pros`thesis ,irreg)"
pros`theses	Clitic	"N(pros`thesis ,pl irreg)"
psy`chosis	Suffix	"N(psy`chosis ,irreg)"
psy`choses	Clitic	"N(psy`chosis ,pl irreg)"
`pupa	Suffix	"N(`pupa ,irreg)"
`pupae	Clitic	"N(`pupa ,pl irreg)"
quad`rennium	Suffix	"N(quad`rennium ,)"
quad`rennia	Clitic	"N(quad`rennium ,pl irreg)"
quad`riga	Suffix	"N(quad`riga ,)"
quad`rigae	Clitic	"N(quad`riga ,pl irreg)"
`quantum	Suffix	"N(`quantum ,)"
`quanta	Clitic	"N(`quantum ,pl irreg)"
quet`zal	Suffix	"N(quet`zal ,)"
quet`zales	Clitic	"N(quet`zal ,pl irreg)"
`radix	Suffix	"N(`radix ,)"
`radices	Clitic	"N(`radix ,pl irreg)"
`radius	Suffix	"N(`radius ,)"
`radii	Clitic	"N(`radius ,pl irreg)"
`rectum	Suffix	"N(`rectum ,)"
`recta	Clitic	"N(`rectum ,pl irreg)"
refer`endum	Suffix	"N(refer`endum ,)"
refer`enda	Clitic	"N(refer`endum ,pl irreg)"
`rendezvous	Suffix	"N(`rendezvous ,irreg)"
`rendezvous	Clitic	"N(`rendezvous ,pl irreg)"
re`siduum	Suffix	"N(re`siduum ,irreg)"
re`sidua	Clitic	"N(re`siduum ,pl irreg)"
rhi`noceros	Suffix	"N(rhi`noceros ,)"
rhi`noceri	Clitic	"N(rhi`noceros ,pl irreg)"
`rhombus	Suffix	"N(`rhombus ,)"
`rhombi	Clitic	"N(`rhombus ,pl irreg)"
`rostrum	Suffix	"N(`rostrum ,)"
`rostra	Clitic	"N(`rostrum ,pl irreg)"
sana`tarium	Suffix	"N(sana`tarium ,)"
sana`taria	Clitic	"N(sana`tarium ,pl irreg)"
sani`tarium	Suffix	"N(sani`tarium ,)"
sani`taria	Clitic	"N(sana`tarium ,pl irreg)"
sana`torium	Suffix	"N(sana`torium ,)"
sana`toria	Clitic	"N(sana`torium ,pl irreg)"
sani`torium	Suffix	"N(sani`torium ,)"
sani`toria	Clitic	"N(sana`torium ,pl irreg)"
sar`coma	Suffix	"N(sar`coma ,)"
sarco`mata	Clitic	"N(sar`coma ,pl irreg)"
`scapula	Suffix	"N(`scapula ,)"
`scapulae	Clitic	"N(`scapula ,pl irreg)"
`schema	Suffix	"N(`schema ,)"
sche`mata	Clitic	"N(`schema ,pl irreg)"
`scherzo	Suffix	"N(`scherzo ,)"
`scherzi	Clitic	"N(`scherzo ,pl irreg)"
`scoria	Suffix	"N(`scoria ,)"
`scoriae	Clitic	"N(`scoria ,pl irreg)"
scrip`torium	Suffix	"N(scrip`torium ,)"
scrip`toria	Clitic	"N(scrip`torium ,pl irreg)"
`scrotum	Suffix	"N(`scrotum ,)"
`scrota	Clitic	"N(`scrotum ,pl irreg)"
`scutum	Suffix	"N(`scutum ,)"
`scuta	Clitic	"N(`scutum ,pl irreg)"
`septum	Suffix	"N(`septum ,)"
`septa	Clitic	"N(`septum ,pl irreg)"
`seraph	Suffix	"N(`seraph ,)"
`seraphim	Clitic	"N(`seraph ,pl irreg)"
`serum	Suffix	"N(`serum ,)"
`sera	Clitic	"N(`serum ,pl irreg)"
`solidus	Suffix	"N(`solidus ,)"
`solidi	Clitic	"N(`solidus ,pl irreg)"
`soma	Suffix	"N(`soma ,)"
so`mata	Clitic	"N(`soma ,pl irreg)"
`spectrum	Suffix	"N(`spectrum ,)"
`spectra	Clitic	"N(`spectrum ,pl irreg)"
sov`khoz	Suffix	"N(sov`khoz ,)"
sov`khozy	Clitic	"N(sov`khoz ,pl irreg)"
`spectrum	Suffix	"N(`spectrum ,)"
`spectra	Clitic	"N(`spectrum ,pl irreg)"
`speculum	Suffix	"N(`speculum ,)"
`specula	Clitic	"N(`speculum ,pl irreg)"
`sputum	Suffix	"N(`sputum ,irreg)"
`sputa	Clitic	"N(`sputum ,pl irreg)"
`stadium	Suffix	"N(`stadium ,)"
`stadia	Clitic	"N(`stadium ,pl irreg)"
staphylo`coccus	Suffix	"N(staphylo`coccus ,irreg)"
staphylo`cocci	Clitic	"N(staphylo`coccus ,pl irreg)"
`stasis	Suffix	"N(`stasis ,irreg)"
`stases	Clitic	"N(`stasis ,pl irreg)"
`sternum	Suffix	"N(`sternum ,)"
`sterna	Clitic	"N(`sternum ,pl irreg)"
`stigma	Suffix	"N(`stigma ,)"
stig`mata	Clitic	"N(`stigma ,pl irreg)"
`stimulus	Suffix	"N(`stimulus ,)"
`stimuli	Clitic	"N(`stimulus ,pl irreg)"
`stratum	Suffix	"N(`stratum ,)"
`strata	Clitic	"N(`stratum ,pl irreg)"
strepto`coccus	Suffix	"N(strepto`coccus ,)"
strepto`cocci	Clitic	"N(strepto`coccus ,pl irreg)"
`stretto	Suffix	"N(`stretto ,)"
`stretti	Clitic	"N(`stretto ,pl irreg)"
`stria	Suffix	"N(`stria ,)"
`striae	Clitic	"N(`stria ,pl irreg)"
`stylus	Suffix	"N(`stylus ,)"
`styli	Clitic	"N(`stylus ,pl irreg)"
`succubus	Suffix	"N(`succubus ,)"
`succubi	Clitic	"N(`succubus ,pl irreg)"
`syllabus	Suffix	"N(`syllabus ,)"
`syllabi	Clitic	"N(`syllabus ,pl irreg)"
sym`posium	Suffix	"N(sym`posium ,)"
sym`posia	Clitic	"N(sym`posium ,pl irreg)"
syn`apsis	Suffix	"N(syn`apsis ,irreg)"
syn`apses	Clitic	"N(syn`apsis ,pl irreg)"
syn`opsis	Suffix	"N(syn`opsis ,irreg)"
syn`opses	Clitic	"N(syn`opsis ,pl irreg)"
`synthesis	Suffix	"N(`synthesis ,irreg)"
`syntheses	Clitic	"N(`synthesis ,pl irreg)"
`syrinx	Suffix	"N(`syrinx ,)"
sy`ringes	Clitic	"N(`syrinx ,pl irreg)"
tab`leau	Suffix	"N(tab`leau ,)"
tab`leaux	Clitic	"N(tab`leau ,pl irreg)"
`talus	Suffix	"N(`talus ,)"
`tali	Clitic	"N(`talus ,pl irreg)"
`tectum	Suffix	"N(`tectum ,)"
`tecta	Clitic	"N(`tectum ,pl irreg)"
`tempo	Suffix	"N(`tempo ,)"
`tempi	Clitic	"N(`tempo ,pl irreg)"
`terminus	Suffix	"N(`terminus ,)"
`termini	Clitic	"N(`terminus ,pl irreg)"
ter`rarium	Suffix	"N(ter`rarium ,)"
ter`raria	Clitic	"N(ter`rarium ,pl irreg)"
`testis	Suffix	"N(`testis ,irreg)"
`testes	Clitic	"N(`testis ,pl irreg)"
tetra`hedron	Suffix	"N(tetra`hedron ,)"
tetra`hedra	Clitic	"N(tetra`hedron ,pl irreg)"
`thalamus	Suffix	"N(`thalamus ,)"
`thalami	Clitic	"N(`thalamus ,pl irreg)"
the`saurus	Suffix	"N(the`saurus ,)"
the`sauri	Clitic	"N(the`saurus ,pl irreg)"
`thesis	Suffix	"N(`thesis ,irreg)"
`theses	Clitic	"N(`thesis ,pl irreg)"
`thorax	Suffix	"N(`thorax ,)"
`thoraces	Clitic	"N(`thorax ,pl irreg)"
throm`bosis	Suffix	"N(throm`bosis ,irreg)"
throm`boses	Clitic	"N(throm`bosis ,pl irreg)"
`tibia	Suffix	"N(`tibia ,)"
`tibiae	Clitic	"N(`tibia ,pl irreg)"
`torso	Suffix	"N(`torso ,)"
`torsi	Clitic	"N(`torso ,pl irreg)"
`torus	Suffix	"N(`torus ,)"
`tori	Clitic	"N(`torus ,pl irreg)"
`trachea	Suffix	"N(`trachea ,)"
`tracheae	Clitic	"N(`trachea ,pl irreg)"
tra`pezium	Suffix	"N(tra`pezium ,)"
tra`pezia	Clitic	"N(tra`pezium ,pl irreg)"
`trauma	Suffix	"N(`trauma ,)"
trau`mata	Clitic	"N(`trauma ,pl irreg)"
trous`seau	Suffix	"N(trous`seau ,)"
trous`seaux	Clitic	"N(trous`seau ,pl irreg)"
ultima`tum	Suffix	"N(ultima`tum ,)"
ultima`ta	Clitic	"N(ultima`tum ,pl irreg)"
umbi`licus	Suffix	"N(umbi`licus ,)"
umbi`lici	Clitic	"N(umbi`licus ,pl irreg)"
`umbra	Suffix	"N(`umbra ,)"
`umbrae	Clitic	"N(`umbra ,pl irreg)"
u`rethra	Suffix	"N(u`rethra ,)"
u`rethrae	Clitic	"N(u`rethra ,pl irreg)"
`uterus	Suffix	"N(`uterus ,)"
`uteri	Clitic	"N(`uterus ,pl irreg)"
`uvula	Suffix	"N(`uvula ,)"
`uvulae	Clitic	"N(`uvula ,pl irreg)"
va`gina	Suffix	"N(va`gina ,)"
va`ginae	Clitic	"N(va`gina ,pl irreg)"
`vas	Suffix	"N(`vas ,)"
`vasa	Clitic	"N(`vas ,pl irreg)"
`velum	Suffix	"N(`velum ,)"
`vela	Clitic	"N(`velum ,pl irreg)"
`vena	Suffix	"N(`vena ,)"
`venae	Clitic	"N(`vena ,pl irreg)"
`vertebra	Suffix	"N(`vertebra ,irreg)"
`vertebrae	Clitic	"N(`vertebra ,pl irreg)"
`vertex	Suffix	"N(`vertex ,)"
`vertices	Clitic	"N(`vertex ,pl irreg)"
virtu`osa	Suffix	"N(virtu`osa ,)"
virtu`osi	Clitic	"N(virtu`oso ,pl irreg)"
`viscus	Suffix	"N(`viscus ,irreg)"
`viscera	Clitic	"N(`viscus ,pl irreg)"
`vita	Suffix	"N(`vita ,)"
`vitae	Clitic	"N(`vita ,pl irreg)"
`vortex	Suffix	"N(`vortex ,)"
`vortices	Clitic	"N(`vortex ,pl irreg)"
ye`shiva	Suffix	"N(ye`shiva ,)"
yeshi`voth	Clitic	"N(ye`shiva ,pl irreg)"
`antelope	Suffix	"N(`antelope ,sg-pl)"
`bison	Suffix	"N(`bison ,sg-pl)"
`caribou	Suffix	"N(`caribou ,sg-pl)"
`cod	Suffix	"N(`cod ,sg-pl)"
`deer	Suffix	"N(`deer ,irreg sg-pl)"
`elk	Suffix	"N(`elk ,sg-pl)"
`fish	Clitic	"N(`fish ,pl irreg)"
`flounder	Suffix	"N(`flounder ,sg-pl)"
ga`zelle	Suffix	"N(ga`zelle ,sg-pl)"
`grouse	Suffix	"N(`grouse ,sg-pl)"
`herring	Suffix	"N(`herring ,sg-pl)"
`mackerel	Suffix	"N(`mackerel ,sg-pl)"
men`haden	Suffix	"N(men`haden ,irreg sg-pl)"
`moose	Suffix	"N(`moose ,irreg sg-pl)"
`muskellunge	Suffix	"N(`muskellunge ,sg-pl)"
`quail	Suffix	"N(`quail ,sg-pl)"
`reindeer	Suffix	"N(`reindeer ,irreg sg-pl)"
`salmon	Suffix	"N(`salmon ,sg-pl)"
`scabies	Suffix	"N(`scabies ,irreg sg-pl)"
`sheep	Suffix	"N(`sheep ,irreg sg-pl)"
`shrimp	Suffix	"N(`shrimp ,sg-pl)"
`smelt	Suffix	"N(`smelt ,sg-pl)"
`starfish	Suffix	"N(`starfish ,irreg sg-pl)"
`swine	Suffix	"N(`swine ,irreg sg-pl)"
`thrips	Suffix	"N(`thrips ,irreg sg-pl)"
`trout	Suffix	"N(`trout ,sg-pl)"
`tuna	Suffix	"N(`tuna ,sg-pl)"
`woodcock	Suffix	"N(`woodcock ,sg-pl)"
zuc`chini	Suffix	"N(zuc`chini ,sg-pl)"
`barracks	Suffix	"N(`barracks ,irreg sg-pl)"
`bellows	Suffix	"N(`bellows ,irreg sg-pl)"
`biceps	Suffix	"N(`biceps ,irreg sg-pl)"
`checkers	Suffix	"N(`checkers ,irreg sg-pl)"
`contretemps	Suffix	"N(`contretemps ,irreg sg-pl)"
`corps	Suffix	"N(`corps ,irreg sg-pl)"
`craft	Suffix	"N(`craft ,sg-pl)"
`crossroads	Suffix	"N(`crossroads ,irreg sg-pl)"
down`stairs	Suffix	"N(down`stairs ,irreg sg-pl)"
`drippings	Suffix	"N(`drip ,pl irreg)"
`fowl	Suffix	"N(`fowl ,sg-pl)"
`gallows	Suffix	"N(`gallows ,irreg sg-pl)"
`headquarters	Suffix	"N(`headquarters ,irreg sg-pl)"
`humankind	Suffix	"N(`humankind ,irreg sg-pl)"
`hustings	Suffix	"N(`hustings ,irreg sg-pl)"
in`signia	Suffix	"N(in`signia ,sg-pl)"
`kennels	Suffix	"N(`kennels ,irreg sg-pl)"
`lazybones	Suffix	"N(`lazybones ,irreg sg-pl)"
`links	Suffix	"N(`links ,irreg sg-pl)"
`mankind	Suffix	"N(`mankind ,irreg sg-pl)"
`means	Suffix	"N(`means ,irreg sg-pl)"
`measles	Suffix	"N(`measles ,irreg sg-pl)"
`military	Suffix	"N(`military ,irreg sg-pl)"
`mumps	Suffix	"N(`mumps ,irreg sg-pl)"
`oats	Suffix	"N(`oats ,irreg sg-pl)"
`offspring	Suffix	"N(`offspring ,irreg sg-pl)"
parapher`nalia	Suffix	"N(parapher`nalia ,irreg sg-pl)"
person`nel	Suffix	"N(person`nel ,irreg sg-pl)"
`poultry	Suffix	"N(`poultry ,irreg sg-pl)"
`pox	Suffix	"N(`pox ,irreg sg-pl)"
`quadriceps	Suffix	"N(`quadriceps ,irreg sg-pl)"
`rapids	Suffix	"N(`rapids ,irreg sg-pl)"
`series	Suffix	"N(`series ,irreg sg-pl)"
`sixpence	Suffix	"N(`sixpence ,irreg sg-pl)"
`species	Suffix	"N(`species ,irreg sg-pl)"
`soapsuds	Suffix	"N(`soapsuds ,irreg sg-pl)"
`works	Suffix	"N(`works ,irreg sg-pl)"
`timpani	Suffix	"N(`timpani ,irreg sg-pl)"
`triceps	Suffix	"N(`triceps ,irreg sg-pl)"
up`stairs	Suffix	"N(up`stairs ,irreg sg-pl)"
vespers	Suffix	"N(vespers ,irreg sg-pl)"
`vermin	Suffix	"N(`vermin ,irreg sg-pl)"
`womenkind	Suffix	"N(`womenkind ,irreg sg-pl)"
`bellows	Clitic	"N(`bellows ,pl)"
bi`noculars	Clitic	"N(bi`noculars ,pl)"
`bloomers	Clitic	"N(`bloomers ,pl)"
`braces	Clitic	"N(`braces - british,pl)"
`briefs	Clitic	"N(`briefs ,pl)"
`britches	Clitic	"N(`britches ,pl)"
`clippers	Clitic	"N(`clippers ,pl)"
`flannels	Clitic	"N(`flannels ,pl)"
`forceps	Clitic	"N(`forceps ,pl)"
`glasses	Clitic	"N(`glasses ,pl)"
`innards	Clitic	"N(`innards ,pl)"
`jeans	Clitic	"N(`jeans ,pl)"
`knickers	Clitic	"N(`knickers ,pl)"
`pants	Clitic	"N(`pants ,pl)"
pa`jamas	Clitic	"N(pa`jamas ,pl)"
`pincers	Clitic	"N(`pincers ,pl)"
`pliers	Clitic	"N(`pliers ,pl)"
py`jamas	Clitic	"N(py`jamas ,pl)"
`scales	Clitic	"N(`scales - a balance,pl)"
`scissors	Clitic	"N(`scissors ,pl)"
`shears	Clitic	"N(`shears ,pl)"
`shorts	Clitic	"N(`shorts ,pl)"
`slacks	Clitic	"N(`slacks ,pl)"
`spectacles	Clitic	"N(`spectacles ,pl)"
`sunglasses	Clitic	"N(`sunglasses ,pl)"
sus`penders	Clitic	"N(sus`penders ,pl)"
`tights	Clitic	"N(`tights ,pl)"
`togs	Clitic	"N(`togs ,pl)"
`tongs	Clitic	"N(`tongs ,pl)"
`trousers	Clitic	"N(`trousers ,pl)"
`trunks	Clitic	"N(`trunks ,pl)"
`tweezers	Clitic	"N(`tweezers ,pl)"
`vitals	Clitic	"N(`vitals ,)"
`alms	Clitic	"N(`alms ,pl)"
a`mends	Clitic	"N(a`mends ,pl)"
`annals	Clitic	"N(`annals ,pl)"
ar`rears	Clitic	"N(ar`rears ,pl)"
`auspices	Clitic	"N(`auspices ,pl)"
`banns	Clitic	"N(`banns ,pl)"
`clothes	Clitic	"N(`clothes ,pl)"
`confines	Clitic	"N(`confines ,pl ss)"
cre`dentials	Clitic	"N(cre`dentials ,pl)"
`doldrums	Clitic	"N(`doldrums ,pl)"
`dregs	Clitic	"N(`dregs ,pl)"
`entrails	Clitic	"N(`entrails ,pl)"
`fixings	Clitic	"N(`fixings ,pl)"
`goods	Clitic	"N(`goods ,pl)"
`housewares	Clitic	"N(`housewares ,pl)"
hu`manities	Clitic	"N(hu`manities ,pl)"
`maths	Clitic	"N(`maths - British,pl)"
`odds	Clitic	"N(`odds ,pl)"
`oodles	Clitic	"N(`oodles ,pl)"
par`ticulars	Clitic	"N(par`ticulars ,pl)"
re`gards	Clitic	"N(re`gards ,pl)"
re`mains	Clitic	"N(re`mains ,pl)"
`riches	Clitic	"N(`riches ,pl)"
smither`eens	Clitic	"N(smither`eens ,pl)"
sur`roundings	Clitic	"N(sur`roundings ,pl)"
`thanks	Clitic	"N(`thanks ,pl)"
`troops	Clitic	"N(`troops ,pl)"
`valuables	Clitic	"N(`valuables ,pl)"
an`tipodes	Clitic	"N(an`tipodes ,pl irreg)"
ar`cana	Clitic	"N(ar`cana ,pl irreg)"
at`lantes	Clitic	"N(at`lantes ,pl irreg)"
e`rotica	Clitic	"N(e`rotica ,pl irreg)"
ex`otica	Clitic	"N(ex`otica ,pl irreg)"
`flora	Clitic	"N(`flora ,pl irreg)"
`fauna	Clitic	"N(`fauna ,pl irreg)"
intelli`gentsia	Suffix	"N(intelli`gentsia ,pl irreg)"
margi`nalia	Clitic	"N(margi`nalia ,pl irreg)"
memora`bilia	Clitic	"N(memora`bilia ,pl irreg)"
miscel`lanea	Clitic	"N(miscel`lanea ,pl irreg)"
re`galia	Clitic	"N(re`galia ,pl irreg)"
`schlieren	Clitic	"N(`schlieren ,pl irreg)"
`trivia	Clitic	"N(`trivia ,)"
`cattle	Clitic	"N(`cattle ,pl irreg)"
`faculty	Suffix	"N(`faculty - teachers,sg-pl ;;;irreg)"
`folk	Suffix	"N(`folk ,)"
`folk	Suffix	"N(`folk ,pl irreg)"
`kine	Clitic	"N(`kine - archaic plural of cow,pl irreg)"
`kinfolk	Suffix	"N(`kinfolk ,)"
`kinfolk	Suffix	"N(`kinfolk ,pl irreg)"
`kinsfolk	Suffix	"N(`kinsfolk ,)"
`kinsfolk	Suffix	"N(`kinsfolk ,pl irreg)"
`livestock	Clitic	"N(`livestock ,pl irreg)"
`menfolk	Clitic	"N(`menfolk ,pl irreg)"
`peoples	Clitic	"N(`peoples ,pl)"
po`lice	Clitic	"N(po`lice ,pl irreg)"
`townspeople	Clitic	"N(`townspeople ,pl irreg)"
`womenfolk	Clitic	"N(`womenfolk ,pl irreg)"
`alchem	Y_Suffix	"N(`alchemy ,)"
amphi`bolog	Y_Suffix	"N(amphi`bology ,)"
a`natom	Y_Suffix	"N(a`natomy ,)"
ani`sotrop	Y_Suffix	"N(ani`sotropy ,)"
an`tholog	Y_Suffix	"N(an`thology ,)"
anthro`polog	Y_Suffix	"N(anthro`pology ,)"
archae`olog	Y_Suffix	"N(archae`ology ,)"
arche`olog	Y_Suffix	"N(arche`ology ,)"
assyri`olog	Y_Suffix	"N(assyri`ology ,)"
as`trolog	Y_Suffix	"N(as`trolog ,)"
as`tronom	Y_Suffix	"N(as`tronom ,)"
a`synchron	Y_Suffix	"N(a`synchrony ,)"
au`tonom	Y_Suffix	"N(au`tonomy ,)"
axi`olog	Y_Suffix	"N(axi`ology ,)"
bibli`ograph	Y_Suffix	"N(bibli`ography ,)"
`bigam	Y_Suffix	"N(`bigamy ,)"
bi`ograph	Y_Suffix	"N(bi`ography ,)"
bi`olog	Y_Suffix	"N(bi`ology ,)"
bi`ometr	Y_Suffix	"N(bi`ometry ,)"
`botan	Y_Suffix	"N(`botany ,)"
ca`cophon	Y_Suffix	"N(ca`cophony ,)"
cardi`olog	Y_Suffix	"N(cardi`ology ,)"
car`tograph	Y_Suffix	"N(car`tography ,)"
cet`olog	Y_Suffix	"N(cet`ology ,)"
chemo`therap	Y_Suffix	"N(chemo`therapy ,)"
chore`ograph	Y_Suffix	"N(chore`ography ,)"
chro`nolog	Y_Suffix	"N(chro`nology ,)"
clima`tolog	Y_Suffix	"N(clima`tology ,)"
cos`mogon	Y_Suffix	"N(cos`mogony ,)"
cos`molog	Y_Suffix	"N(cos`mology ,)"
cryp`tograph	Y_Suffix	"N(cryp`tography ,)"
cryp`tolog	Y_Suffix	"N(cryp`tology ,)"
crystal`lograph	Y_Suffix	"N(crystal`lography ,)"
cy`tolog	Y_Suffix	"N(cy`tology ,)"
de`mograph	Y_Suffix	"N(de`mography ,)"
derma`tolog	Y_Suffix	"N(derma`tology ,)"
di`achron	Y_Suffix	"N(di`achrony ,)"
dialec`tolog	Y_Suffix	"N(dialec`tology ,)"
`diatherm	Y_Suffix	"N(`diathermy ,)"
di`chotom	Y_Suffix	"N(di`chotomy ,)"
du`opol	Y_Suffix	"N(du`opoly ,)"
e`colog	Y_Suffix	"N(e`cology ,)"
e`conom	Y_Suffix	"N(e`conomy ,)"
`empath	Y_Suffix	"N(`empathy ,)"
en`dogam	Y_Suffix	"N(en`dogamy ,)"
ento`molog	Y_Suffix	"N(ento`mology ,)"
enzy`molog	Y_Suffix	"N(enzy`mology ,)"
epidemi`olog	Y_Suffix	"N(epidemi`ology ,)"
episte`molog	Y_Suffix	"N(episte`mology ,)"
eth`nograph	Y_Suffix	"N(eth`nography ,)"
eth`nolog	Y_Suffix	"N(eth`nology ,)"
e`tholog	Y_Suffix	"N(e`thology ,)"
eti`olog	Y_Suffix	"N(eti`ology ,)"
ety`molog	Y_Suffix	"N(ety`mology ,)"
ex`ogam	Y_Suffix	"N(ex`ogamy ,)"
gas`tronom	Y_Suffix	"N(gas`tronomy ,)"
gene`alog	Y_Suffix	"N(gene`alogy ,)"
ge`odes	Y_Suffix	"N(ge`odesy ,)"
ge`ograph	Y_Suffix	"N(ge`ography ,)"
ge`olog	Y_Suffix	"N(ge`ology ,)"
ge`ometr	Y_Suffix	"N(ge`ometry ,)"
geron`tolog	Y_Suffix	"N(geron`tology ,)"
gyne`colog	Y_Suffix	"N(gyne`cology ,)"
herpe`tolog	Y_Suffix	"N(herpe`tology ,)"
his`tolog	Y_Suffix	"N(his`tology ,)"
histori`ograph	Y_Suffix	"N(histori`ography ,)"
home`opath	Y_Suffix	"N(home`opathy ,)"
ho`molog	Y_Suffix	"N(ho`mology ,)"
ho`rolog	Y_Suffix	"N(ho`rology ,)"
hy`drolog	Y_Suffix	"N(hy`drology ,)"
hyste`rectom	Y_Suffix	"N(hyste`rectomy ,)"
ichthy`olog	Y_Suffix	"N(ichthy`ology ,)"
ide`olog	Y_Suffix	"N(ide`ology ,)"
immun`olog	Y_Suffix	"N(immun`ology ,)"
i`sotrop	Y_Suffix	"N(i`sotropy ,)"
lexi`cograph	Y_Suffix	"N(lexi`cography ,)"
lexi`colog	Y_Suffix	"N(lexi`cology ,)"
li`tholog	Y_Suffix	"N(li`thology ,)"
lo`botom	Y_Suffix	"N(lo`botomy ,)"
ma`jest	Y_Suffix	"N(ma`jesty ,)"
metal`lograph	Y_Suffix	"N(metal`lography ,)"
`metallurg	Y_Suffix	"N(`metallurgy ,)"
metho`dolog	Y_Suffix	"N(metho`dology ,)"
meteo`rolog	Y_Suffix	"N(meteo`rology ,)"
me`tonym	Y_Suffix	"N(me`tonymy ,)"
miner`alog	Y_Suffix	"N(miner`alogy ,)"
mi`sogam	Y_Suffix	"N(mi`sogamy ,)"
mi`sogyn	Y_Suffix	"N(mi`sogyny ,)"
mo`nogam	Y_Suffix	"N(mo`nogamy ,)"
mor`pholog	Y_Suffix	"N(mor`phology ,)"
musi`colog	Y_Suffix	"N(musi`cology ,)"
my`colog	Y_Suffix	"N(my`cology ,)"
myth`olog	Y_Suffix	"N(myth`ology ,)"
neuroa`natom	Y_Suffix	"N(neuroa`natomy ,)"
neu`rolog	Y_Suffix	"N(neu`rology ,)"
neuropa`tholog	Y_Suffix	"N(neuropa`thology ,)"
neurophysi`olog	Y_Suffix	"N(neurophysi`ology ,)"
numer`olog	Y_Suffix	"N(numer`ology ,)"
ocean`ograph	Y_Suffix	"N(ocean`ography ,)"
on`colog	Y_Suffix	"N(on`cology ,)"
on`togen	Y_Suffix	"N(on`togeny ,)"
on`tolog	Y_Suffix	"N(on`tology ,)"
ophthal`molog	Y_Suffix	"N(ophthal`mology ,)"
op`tometr	Y_Suffix	"N(op`tometry ,)"
or`thograph	Y_Suffix	"N(or`thography ,)"
oste`olog	Y_Suffix	"N(oste`ology ,)"
orni`tholog	Y_Suffix	"N(orni`thology ,)"
o`rograph	Y_Suffix	"N(o`rography ,)"
path`olog	Y_Suffix	"N(path`ology ,)"
`pedagog	Y_Suffix	"N(`pedagogy ,)"
pet`rolog	Y_Suffix	"N(pet`rology ,)"
pharma`colog	Y_Suffix	"N(pharma`cology ,)"
phenomen`olog	Y_Suffix	"N(phenomen`ology ,)"
phi`lanthrop	Y_Suffix	"N(phi`lanthropy ,)"
phi`lolog	Y_Suffix	"N(phi`lology ,)"
phi`losoph	Y_Suffix	"N(phi`losophy ,)"
pho`nolog	Y_Suffix	"N(pho`nology ,)"
phrase`olog	Y_Suffix	"N(phrase`ology ,)"
phren`olog	Y_Suffix	"N(phren`ology ,)"
phy`logen	Y_Suffix	"N(phy`logeny ,)"
physi`ognom	Y_Suffix	"N(physi`ognomy ,)"
physi`olog	Y_Suffix	"N(physi`ology ,)"
physio`therap	Y_Suffix	"N(physio`therapy ,)"
po`lygyn	Y_Suffix	"N(po`lygyny ,)"
po`lyphon	Y_Suffix	"N(po`lyphony ,)"
por`nograph	Y_Suffix	"N(por`nography ,)"
psy`chiatr	Y_Suffix	"N(psy`chiatry ,)"
psy`cholog	Y_Suffix	"N(psy`chology ,)"
psy`chometr	Y_Suffix	"N(psy`chometry ,)"
radioas`tronom	Y_Suffix	"N(radioas`tronomy ,)"
radi`ograph	Y_Suffix	"N(radi`ography ,)"
radi`olog	Y_Suffix	"N(radi`ology ,)"
radio`therap	Y_Suffix	"N(radio`therapy ,)"
rhe`olog	Y_Suffix	"N(rhe`ology ,)"
seis`molog	Y_Suffix	"N(seis`mology ,)"
se`rolog	Y_Suffix	"N(se`rology ,)"
soci`olog	Y_Suffix	"N(soci`ology ,)"
soci`ometr	Y_Suffix	"N(soci`ometry ,)"
sten`ograph	Y_Suffix	"N(sten`ography ,)"
stere`ograph	Y_Suffix	"N(stere`ography ,)"
stere`oscop	Y_Suffix	"N(stere`oscopy ,)"
stoichi`ometr	Y_Suffix	"N(stoichi`ometry ,)"
`symmetr	Y_Suffix	"N(`symmetry ,)"
`sympath	Y_Suffix	"N(`sympathy ,)"
`symphon	Y_Suffix	"N(`symphony ,)"
tau`tolog	Y_Suffix	"N(tau`tology ,)"
`taxiderm	Y_Suffix	"N(`taxidermy ,)"
tax`onom	Y_Suffix	"N(tax`onomy ,)"
tech`nolog	Y_Suffix	"N(tech`nology ,)"
tele`olog	Y_Suffix	"N(tele`ology ,)"
te`lepath	Y_Suffix	"N(te`lepathy ,)"
tera`tolog	Y_Suffix	"N(tera`tology ,)"
termi`nolog	Y_Suffix	"N(termi`nology ,)"
thana`tolog	Y_Suffix	"N(thana`tology ,)"
the`olog	Y_Suffix	"N(the`ology ,)"
the`osoph	Y_Suffix	"N(the`osophy ,)"
to`mograph	Y_Suffix	"N(to`mography ,)"
to`pograph	Y_Suffix	"N(to`pography ,)"
to`polog	Y_Suffix	"N(to`pology ,)"
toxi`colog	Y_Suffix	"N(toxi`cology ,)"
trigo`nometr	Y_Suffix	"N(trigo`nometry ,)"
ty`pograph	Y_Suffix	"N(ty`pography ,)"
ty`polog	Y_Suffix	"N(ty`pology ,)"
ur`olog	Y_Suffix	"N(ur`ology ,)"
xe`rograph	Y_Suffix	"N(xe`rography ,)"
zo`olog	Y_Suffix	"N(zo`ology ,)"
`alpha	Infl	"N(`alpha ,)"
`beta	Infl	"N(`beta ,)"
`gamma	Infl	"N(`gamma ,)"
`delta	Infl	"N(`delta ,)"
`epsilon	Infl	"N(`epsilon ,)"
`zeta	Infl	"N(`zeta ,)"
`eta	Infl	"N(`eta ,)"
`theta	Infl	"N(`theta ,)"
i`ota	Infl	"N(i`ota ,)"
`kappa	Infl	"N(`kappa ,)"
`lambda	Infl	"N(`lambda ,)"
mu	Infl	"N(mu ,)"
nu	Infl	"N(nu ,)"
xi	Infl	"N(xi ,)"
`omicron	Infl	"N(`omicron ,)"
pi	Infl	"N(pi ,)"
rho	Infl	"N(rho ,)"
`sigma	Infl	"N(`sigma ,)"
tau	Infl	"N(tau ,)"
`upsilon	Infl	"N(`upsilon ,)"
phi	Infl	"N(phi ,)"
chi	Infl	"N(chi ,)"
psi	Infl	"N(psi ,)"
o`mega	Infl	"N(o`mega ,)"
`a-bomb	Suffix	"N(`a-bomb ,)"
`aberrance	Suffix	"N(a`berrant ,deadj)"
`aberrancy	Suffix	"N(a`berrant ,deadj)"
ab`be	Suffix	"N(ab`be ,)"
`abbey	Suffix	"N(`abbey ,)"
`abbot	Suffix	"N(`abbot ,)"
a`beyance	Suffix	"N(a`beyance ,)"
`abdomen	Suffix	"N(`abdomen ,)"
a`bility	Suffix	"N(`able ,deadj)"
ab`lution	Suffix	"N(ab`lution ,)"
a`bode	Suffix	"N(a`bode ,)"
abo`lition	Suffix	"N(a`bolish ,deverb)"
abo`rigine	Suffix	"N(abo`rigine ,)"
a`bridgment	Suffix	"N(a`bridge - exception to Elision,deverb)"
a`brasion	Suffix	"N(a`brade ,deverb)"
`abscess	Suffix	"N(`abscess ,ajr8)"
`absence	Suffix	"N(`absent ,deadj)"
`absolute	Suffix	"N(`absolute ,)"
abso`lution	Suffix	"N(ab`solve ,deverb)"
ab`sorbency	Suffix	"N(ab`sorb ,deverb+deajr)"
ab`sorption	Suffix	"N(ab`sorb ,deverb)"
ab`stention	Suffix	"N(ab`stain ,deverb)"
abstinence	Suffix	"N(ab`stain ,deverb+deajr)"
`abstract	Suffix	"N(`abstract ,ss)"
a`bundance	Suffix	"N(a`bound ,deverb+deajr)"
a`buse	Suffix	"N(a`buse - [a`byus],deverb)"
a`byss	Suffix	"N(a`byss ,)"
`academe	Suffix	"N(`academe ,)"
aca`demia	Suffix	"N(`academe ,)"
aca`demic	Suffix	"N(`academe ,)"
a`cademy	Suffix	"N(`academe ,)"
a`canthus	Suffix	"N(a`canthus ,)"
`accent	Suffix	"N(`accent ,)"
ac`cessory	Suffix	"N(ac`cessory ,)"
`accident	Suffix	"N(`accident ,)"
`accidie	Suffix	"N(`accidie ,)"
accla`mation	Suffix	"N(ac`claim ,deverb)"
`accolade	Suffix	"N(`accolade ,)"
ac`companist	Suffix	"N(ac`company ,deverb)"
ac`complice	Suffix	"N(ac`complice ,)"
ac`cordion	Suffix	"N(ac`cordion ,)"
ac`count	Suffix	"N(ac`count ,)"
`accuracy	Suffix	"N(`accurate ,deadj)"
`ace	Suffix	"N(`ace ,)"
a`cedia	Suffix	"N(a`cedia ,)"
a`cerbity	Suffix	"N(a`cerbic ,deadj)"
acknowledgment	Suffix	"N(ac`knowledge ,deverb)"
`acme	Suffix	"N(`acme ,)"
`acne	Suffix	"N(`acne ,)"
`acolyte	Suffix	"N(`acolyte ,)"
`acorn	Suffix	"N(`acorn ,)"
acqui`escence	Suffix	"N(ac`quiesce ,deverb+deajr)"
acqui`sition	Suffix	"N(ac`quire ,deverb)"
`actuary	Suffix	"N(`actuary ,)"
`acre	Suffix	"N(`acre ,)"
`acreage	Suffix	"N(`acre ,)"
`acrimony	Suffix	"N(`acrimony ,)"
`acrobat	Suffix	"N(`acrobat ,)"
`acronym	Suffix	"N(`acronym ,)"
a`cropolis	Suffix	"N(a`cropolis ,)"
a`crostic	Suffix	"N(a`crostic ,)"
`actress	Suffix	"N(`act ,deverb)"
a`cuity	Suffix	"N(a`cuity ,)"
`acumen	Suffix	"N(`acumen ,)"
`acupuncture	Suffix	"N(`acupuncture ,)"
`adage	Suffix	"N(`adage ,)"
`addend	Suffix	"N(`addend ,)"
`addict	Suffix	"N(`addict ,ss)"
`address	Suffix	"N(`address ,ss)"
`adequacy	Suffix	"N(`adequate ,deadj)"
ad`hesion	Suffix	"N(ad`here ,deverb)"
ad`herent	Suffix	"N(ad`here ,deverb)"
ad`jacency	Suffix	"N(ad`jacent ,deadj)"
`adjective	Suffix	"N(`adjective ,)"
`adjunct	Suffix	"N(`adjunct ,)"
ad`jutant	Suffix	"N(ad`jutant ,)"
adminis`tratrix	Suffix	"N(ad`ministrate ,deverb)"
`admiral	Suffix	"N(`admiral ,)"
`admiralty	Suffix	"N(`admiralty ,)"
admissi`bility	Suffix	"N(ad`mit ,deverb+deajr)"
ad`mission	Suffix	"N(ad`mit ,deverb)"
ad`mixture	Suffix	"N(ad`mixture ,)"
admo`nition	Suffix	"N(ad`monish ,deverb)"
a`do	Suffix	"N(a`do ,)"
a`dobe	Suffix	"N(a`dobe ,)"
ado`lescence	Suffix	"N(ado`lescent ,deadj)"
a`drenaline	Suffix	"N(a`drenaline ,)"
ad`sorption	Suffix	"N(ad`sorb ,deverb)"
a`dulterer	Suffix	"N(a`dultery ,)"
a`dulteress	Suffix	"N(a`dultery ,)"
a`dultery	Suffix	"N(a`dultery ,)"
ad`vantage	Suffix	"N(ad`vantage ,ajr8)"
`advent	Suffix	"N(`advent ,)"
ad`venture	Suffix	"N(ad`venture ,)"
ad`venturer	Suffix	"N(ad`venture ,)"
`adverb	Suffix	"N(`adverb ,)"
`adversary	Suffix	"N(`adversary ,)"
ad`vice	Suffix	"N(ad`vice ,)"
ad`visory	Suffix	"N(ad`vise ,deverb)"
`advocacy	Suffix	"N(`advocate ,deverb)"
`advocate	Suffix	"N(`advocate - [-@t],)"
`aegis	Suffix	"N(`aegis ,)"
`aeropark	Suffix	"N(`aeropark ,)"
`aerosol	Suffix	"N(`aerosol ,)"
`aesthete	Suffix	"N(`aesthete ,)"
af`fair	Suffix	"N(af`fair ,)"
`affect	Suffix	"N(`affect ,)"
affi`davit	Suffix	"N(affi`davit ,)"
af`finity	Suffix	"N(af`finity ,)"
`affix	Suffix	"N(`affix ,ss)"
`affluence	Suffix	"N(`affluent ,deadj)"
`affricate	Suffix	"N(`affricate ,)"
aficio`nado	Suffix	"N(aficio`nado ,)"
`afro	Suffix	"N(`afro ,)"
`afterbirth	Suffix	"N(`afterbirth ,)"
`aftereffect	Suffix	"N(`aftereffect ,)"
`afterglow	Suffix	"N(`afterglow ,)"
`afterimage	Suffix	"N(`afterimage ,)"
`afterlife	Suffix	"N(`afterlife ,)"
`aftermarket	Suffix	"N(`aftermarket ,)"
`aftermath	Suffix	"N(`aftermath ,)"
after`noon	Suffix	"N(after`noon ,)"
`aftershock	Suffix	"N(`aftershock ,)"
`aftertaste	Suffix	"N(`aftertaste ,)"
`afterthought	Suffix	"N(`afterthought ,)"
`aftertime	Suffix	"N(`aftertime ,)"
`agate	Suffix	"N(`agate ,)"
`ageism	Suffix	"N(`age ,)"
a`genda	Suffix	"N(a`genda ,)"
`agent	Suffix	"N(`agent ,)"
ag`gression	Suffix	"N(ag`gression ,)"
ag`gressor	Suffix	"N(ag`gressor ,)"
ag`nostic	Suffix	"N(ag`nostic ,)"
`agony	Suffix	"N(`agony ,)"
`agribusiness	Suffix	"N(`agribusiness ,)"
`agriculture	Suffix	"N(`agriculture ,)"
`agrimony	Suffix	"N(`agrimony ,)"
a`gue	Suffix	"N(a`gue ,)"
`aide	Suffix	"N(`aide ,)"
`aileron	Suffix	"N(`aileron ,)"
`airbag	Suffix	"N(`airbag ,)"
`aircraft	Suffix	"N(`aircraft ,)"
`airfare	Suffix	"N(`airfare ,)"
`airfield	Suffix	"N(`airfield ,)"
`airflow	Suffix	"N(`airflow ,)"
`airfoil	Suffix	"N(`airfoil ,)"
`airframe	Suffix	"N(`airframe ,)"
`airlift	Suffix	"N(`airlift ,)"
`airline	Suffix	"N(`airline ,)"
`airliner	Suffix	"N(`airliner ,)"
`airlock	Suffix	"N(`airlock ,)"
`airmass	Suffix	"N(`airmass ,)"
`airpark	Suffix	"N(`airpark ,)"
`airplane	Suffix	"N(`airplane ,)"
`airport	Suffix	"N(`airport ,)"
`airspace	Suffix	"N(`airspace ,)"
`airspeed	Suffix	"N(`airspeed ,)"
`airstrip	Suffix	"N(`airstrip ,)"
`airway	Suffix	"N(`airway ,)"
`aisle	Suffix	"N(`aisle ,)"
`alabaster	Suffix	"N(`alabaster ,)"
a`lacrity	Suffix	"N(a`lacrity ,)"
`alb	Suffix	"N(`alb ,)"
`album	Suffix	"N(`album ,)"
al`bumin	Suffix	"N(al`bumin ,)"
`alcohol	Suffix	"N(`alcohol ,)"
alco`holic	Suffix	"N(`alcohol ,)"
`alcove	Suffix	"N(`alcove ,)"
`alder	Suffix	"N(`alder ,)"
`ale	Suffix	"N(`ale ,~ajr14)"
`aleph	Suffix	"N(`aleph ,)"
a`lert	Suffix	"N(a`lert ,)"
al`falfa	Suffix	"N(al`falfa ,)"
`algebra	Suffix	"N(`algebra ,)"
`algorithm	Suffix	"N(`algorithm ,)"
`alias	Suffix	"N(`alias ,)"
`alibi	Suffix	"N(`alibi ,)"
`alimony	Suffix	"N(`alimony ,)"
alle`gation	Suffix	"N(al`lege - exception to Elision,deverb)"
al`legiance	Suffix	"N(al`legiant ,deadj)"
`allegory	Suffix	"N(`allegory ,)"
`allergist	Suffix	"N(`allergy ,)"
`allergy	Suffix	"N(`allergy ,)"
`alley	Suffix	"N(`alley ,)"
`alleyway	Suffix	"N(`alleyway ,)"
`allophone	Suffix	"N(`allophone ,)"
`allomorph	Suffix	"N(`allomorph ,)"
`allspice	Suffix	"N(`allspice ,)"
al`lusion	Suffix	"N(al`lude ,deverb)"
`ally	Suffix	"N(`ally ,ss)"
`almanac	Suffix	"N(`almanac ,)"
`almond	Suffix	"N(`almond ,)"
`alphabet	Suffix	"N(`alphabet ,)"
`altar	Suffix	"N(`altar ,)"
`alternant	Suffix	"N(`alternant ,)"
al`ternative	Suffix	"N(`alternate ,deverb)"
`altitude	Suffix	"N(`altitude ,)"
`alto	Suffix	"N(`alto ,)"
`altruism	Suffix	"N(`altruism ,)"
`altruist	Suffix	"N(`altruist ,)"
`alum	Suffix	"N(`alum ,)"
alu`minium	Suffix	"N(alu`minium - ,)"
a`luminum	Suffix	"N(a`luminum ,)"
a`malgam	Suffix	"N(a`malgam ,)"
am`bassador	Suffix	"N(am`bassador ,)"
`ambiance	Suffix	"N(`ambiance ,)"
ambi`guity	Suffix	"N(ambi`guity ,)"
am`bition	Suffix	"N(am`bition ,)"
ambivalence	Suffix	"N(am`bivalent ,deadj)"
am`brosia	Suffix	"N(am`brosia ,)"
`ambulance	Suffix	"N(`ambulance ,)"
`ambuscade	Suffix	"N(`ambuscade ,)"
a`menity	Suffix	"N(a`menity ,)"
`amethyst	Suffix	"N(`amethyst ,)"
a`migo	Suffix	"N(a`migo ,)"
`amity	Suffix	"N(`amity ,)"
`ammo	Suffix	"N(`ammo ,)"
am`monia	Suffix	"N(am`monia ,)"
ammu`nition	Suffix	"N(ammu`nition ,)"
am`nesia	Suffix	"N(am`nesia ,)"
`amnesty	Suffix	"N(`amnesty ,)"
a`mour	Suffix	"N(a`mour ,)"
`amp	Suffix	"N(`amp ,)"
`ampersand	Suffix	"N(`ampersand ,)"
am`phetamine	Suffix	"N(am`phetamine ,)"
am`phibian	Suffix	"N(am`phibian ,)"
`amphitheater	Suffix	"N(`amphitheater ,)"
`amplitude	Suffix	"N(`amplitude ,)"
ampu`tee	Suffix	"N(ampu`tee ,)"
`amulet	Suffix	"N(`amulet ,)"
a`nachronism	Suffix	"N(a`nachronism ,)"
ana`conda	Suffix	"N(ana`conda ,)"
anaes`thesia	Suffix	"N(anaes`thesia ,)"
`anaglyph	Suffix	"N(`anaglyph ,)"
`anagram	Suffix	"N(`anagram ,)"
`analogue	Suffix	"N(`analogue ,)"
`analogue	Suffix	"N(`analogue ,)"
a`nalogy	Suffix	"N(a`nalogy ,)"
`analyst	Suffix	"N(`analyst ,)"
a`naphora	Suffix	"N(a`naphora ,)"
`anarch	Suffix	"N(`anarch ,)"
`anarchy	Suffix	"N(`anarchy ,)"
a`nathema	Suffix	"N(a`nathema ,)"
`ancestor	Suffix	"N(`ancestor ,)"
`ancestress	Suffix	"N(`ancestor ,)"
`ancestry	Suffix	"N(`ancestry ,)"
`anchovy	Suffix	"N(`anchovy ,)"
`andiron	Suffix	"N(`andiron ,)"
`anecdote	Suffix	"N(`anecdote ,)"
anes`thesia	Suffix	"N(anes`thesia ,)"
`angel	Suffix	"N(`angel ,)"
`angst	Suffix	"N(`angst ,)"
`angstrom	Suffix	"N(`angstrom ,)"
`anguish	Suffix	"N(`anguish ,ajr8)"
animad`version	Suffix	"N(animad`version ,)"
`animal	Suffix	"N(`animal ,)"
`animism	Suffix	"N(`animism ,)"
ani`mosity	Suffix	"N(ani`mosity ,)"
`anise	Suffix	"N(`anise ,)"
`ankle	Suffix	"N(`ankle ,)"
`annex	Suffix	"N(`annex ,)"
`anniversary	Suffix	"N(`anniversary ,)"
an`nuity	Suffix	"N(an`nuity ,)"
`annum	Suffix	"N(`annum ,)"
`anode	Suffix	"N(`anode ,)"
a`nomaly	Suffix	"N(a`nomaly ,)"
`anomie	Suffix	"N(`anomie ,)"
ano`nymity	Suffix	"N(ano`nymity ,)"
ano`rexia	Suffix	"N(ano`rexia ,)"
`ant	Suffix	"N(`ant ,)"
ant`acid	Suffix	"N(`acid ,)"
an`tagonism	Suffix	"N(an`tagonism ,)"
an`tagonist	Suffix	"N(an`tagonist ,)"
ante`cedent	Suffix	"N(ante`cedent ,)"
`anteroom	Suffix	"N(`anteroom ,)"
`anthem	Suffix	"N(`anthem ,)"
anthropo`morphism	Suffix	"N(anthropo`morphism ,)"
antibi`otic	Suffix	"N(antibi`otic ,)"
`antic	Suffix	"N(`antic ,)"
`antidote	Suffix	"N(`antidote ,)"
anti`pasto	Suffix	"N(anti`pasto ,)"
an`tipathy	Suffix	"N(an`tipathy ,)"
`antler	Suffix	"N(`antler ,ajr8)"
`antonym	Suffix	"N(`antonym ,)"
anunci`ation	Suffix	"N(an`nounce ,deverb)"
`anus	Suffix	"N(`anus ,)"
`anvil	Suffix	"N(`anvil ,)"
anx`iety	Suffix	"N(anx`iety ,)"
a`orta	Suffix	"N(a`orta ,)"
a`partheid	Suffix	"N(a`partheid ,)"
a`partment	Suffix	"N(a`partment ,)"
`apathy	Suffix	"N(`apathy ,)"
`aperture	Suffix	"N(`aperture ,)"
a`phasia	Suffix	"N(a`phasia ,)"
`aphid	Suffix	"N(`aphid ,)"
`aphorism	Suffix	"N(`aphorism ,)"
a`plomb	Suffix	"N(a`plomb ,)"
apo`logia	Suffix	"N(apo`logia ,)"
a`pocalypse	Suffix	"N(a`pocalypse ,)"
`apogee	Suffix	"N(`apogee ,)"
a`pology	Suffix	"N(a`pology ,)"
a`pologist	Suffix	"N(a`pology ,)"
`apoplexy	Suffix	"N(`apoplexy ,)"
a`postle	Suffix	"N(a`postle ,)"
a`postrophe	Suffix	"N(a`postrophe ,)"
a`pothecary	Suffix	"N(a`pothecary ,)"
`apothegm	Suffix	"N(`apothegm ,)"
`appanage	Suffix	"N(`appanage ,)"
appa`ratchik	Suffix	"N(appa`ratchik ,)"
appa`ratus	Suffix	"N(appa`ratus ,)"
appa`rition	Suffix	"N(appa`rition ,)"
appel`lation	Suffix	"N(appel`lation ,)"
appendi`citis	Suffix	"N(ap`pendix ,)"
apper`ception	Suffix	"N(apper`ception ,)"
`appetite	Suffix	"N(`appetite ,)"
`appetizer	Suffix	"N(`appetizer ,)"
ap`plause	Suffix	"N(ap`plause ,)"
`apple	Suffix	"N(`apple ,)"
`applejack	Suffix	"N(`applejack ,)"
ap`pliance	Suffix	"N(ap`pliance ,)"
`applicant	Suffix	"N(ap`ply ,deverb)"
applica`bility	Suffix	"N(ap`ply ,deverb+deajr)"
`applicator	Suffix	"N(ap`ply ,deverb)"
appo`sition	Suffix	"N(appo`sition ,)"
appre`hension	Suffix	"N(appre`hend ,deverb)"
ap`prentice	Suffix	"N(ap`prentice ,)"
ap`proximant	Suffix	"N(ap`proximant ,)"
`apricot	Suffix	"N(`apricot ,)"
`apron	Suffix	"N(`apron ,)"
`apse	Suffix	"N(`apse ,)"
`aptitude	Suffix	"N(`aptitude ,)"
`aqueduct	Suffix	"N(`aqueduct ,)"
`aquifer	Suffix	"N(`aquifer ,)"
ar`moire	Suffix	"N(ar`moire ,)"
ara`besque	Suffix	"N(ara`besque ,)"
`arbiter	Suffix	"N(`arbiter ,)"
`arbitrage	Suffix	"N(`arbitrage ,)"
`arbor	Suffix	"N(`arbor ,)"
arbo`retum	Suffix	"N(arbo`retum ,)"
ar`cade	Suffix	"N(ar`cade ,)"
ar`chaism	Suffix	"N(ar`chaism ,)"
`archery	Suffix	"N(`archery ,)"
`archetype	Suffix	"N(`type ,)"
`architect	Suffix	"N(`architect ,)"
`architecture	Suffix	"N(`architecture ,)"
`ardency	Suffix	"N(`ardent ,deadj)"
`ardor	Suffix	"N(`ardor ,)"
`ardour	Suffix	"N(`ardour - British,)"
`area	Suffix	"N(`area ,)"
`areaway	Suffix	"N(`areaway ,)"
a`rena	Suffix	"N(a`rena ,)"
`argosy	Suffix	"N(`argosy ,)"
`argot	Suffix	"N(`argot ,)"
`argument	Suffix	"N(`argue - exception to Elision,deverb)"
argumen`tation	Suffix	"N(`argue ,deverb)"
`arhat	Suffix	"N(`arhat ,)"
aris`tocracy	Suffix	"N(a`ristocrat ,)"
a`ristocrat	Suffix	"N(a`ristocrat ,)"
a`rithmetic	Suffix	"N(a`rithmetic ,)"
`ark	Suffix	"N(`ark ,)"
ar`mada	Suffix	"N(ar`mada ,)"
`armament	Suffix	"N(`armament ,)"
`armature	Suffix	"N(`armature ,)"
`armchair	Suffix	"N(`armchair ,)"
`armful	Suffix	"N(`arm ,)"
`armhole	Suffix	"N(`armhole ,)"
`armistice	Suffix	"N(`armistice ,)"
`armload	Suffix	"N(`armload ,)"
`armpit	Suffix	"N(`armpit ,)"
`army	Suffix	"N(`army ,)"
a`roma	Suffix	"N(a`roma ,)"
ar`peggio	Suffix	"N(ar`peggio ,)"
`arrack	Suffix	"N(`arrack ,)"
ar`ray	Suffix	"N(ar`ray ,)"
ar`rear	Suffix	"N(ar`rear ,)"
`arrogance	Suffix	"N(`arrogant ,deadj)"
`arrow	Suffix	"N(`arrow ,)"
`arrowhead	Suffix	"N(`arrowhead ,)"
ar`royo	Suffix	"N(ar`royo ,)"
`arsenal	Suffix	"N(`arsenal ,)"
`arsenic	Suffix	"N(`arsenic ,)"
`arson	Suffix	"N(`arson ,)"
`art	Suffix	"N(`art ,)"
`artefact	Suffix	"N(`artefact ,)"
`artery	Suffix	"N(`artery ,)"
arth`ritis	Suffix	"N(arth`ritis ,)"
`artichoke	Suffix	"N(`artichoke ,)"
`article	Suffix	"N(`article ,)"
`artifact	Suffix	"N(`artifact ,)"
`artifice	Suffix	"N(`artifice ,)"
ar`tillery	Suffix	"N(ar`tillery ,)"
`artisan	Suffix	"N(`artisan ,)"
`artistry	Suffix	"N(`art ,)"
`artwork	Suffix	"N(`artwork ,)"
`arum	Suffix	"N(`arum ,)"
as`bestos	Suffix	"N(as`bestos ,)"
as`cendancy	Suffix	"N(as`cend ,deverb)"
as`cension	Suffix	"N(as`cend ,deverb)"
as`cent	Suffix	"N(as`cent ,)"
as`cetic	Suffix	"N(as`cetic ,)"
as`cription	Suffix	"N(as`cribe ,deverb)"
`ash	Suffix	"N(`ash ,)"
`ashtray	Suffix	"N(`ashtray ,)"
as`paragus	Suffix	"N(as`paragus ,)"
`aspect	Suffix	"N(`aspect ,)"
`aspen	Suffix	"N(`aspen ,)"
as`perity	Suffix	"N(as`perity ,)"
as`persion	Suffix	"N(as`persion ,)"
`asphalt	Suffix	"N(`asphalt ,)"
`aspirant	Suffix	"N(`aspirant ,)"
`aspirate	Suffix	"N(`aspirate - [-@t],)"
`aspirin	Suffix	"N(`aspirin ,)"
`ass	Suffix	"N(`ass ,~nr12 ~nr31)"
as`sassin	Suffix	"N(as`sassin ,)"
`asset	Suffix	"N(`asset ,)"
as`sembly	Suffix	"N(as`semble ,deverb)"
assi`duity	Suffix	"N(assi`duity ,)"
`assonance	Suffix	"N(`assonant ,deadj)"
as`tringency	Suffix	"N(`astringent ,deadj)"
as`sumption	Suffix	"N(as`sume ,deverb)"
`aster	Suffix	"N(`aster ,)"
`asterisk	Suffix	"N(`asterisk ,)"
`asteroid	Suffix	"N(`asteroid ,)"
`asthma	Suffix	"N(`asthma ,)"
as`tigmatism	Suffix	"N(as`tigmatism ,)"
`astronaut	Suffix	"N(`astronaut ,)"
a`sylum	Suffix	"N(a`sylum ,)"
a`symmetry	Suffix	"N(`symmetry ,)"
`atavism	Suffix	"N(`atavism ,)"
`atheism	Suffix	"N(`atheism ,)"
`atheist	Suffix	"N(`atheist ,)"
`athlete	Suffix	"N(`athlete ,)"
`atlas	Suffix	"N(`atlas ,)"
`atmosphere	Suffix	"N(`atmosphere ,)"
`atoll	Suffix	"N(`atoll ,)"
`atom	Suffix	"N(`atom ,)"
a`trocity	Suffix	"N(a`trocity ,)"
atta`che	Suffix	"N(atta`che ,)"
at`tainder	Suffix	"N(at`tainder ,)"
at`tention	Suffix	"N(at`tend ,deverb)"
`attic	Suffix	"N(`attic ,)"
`attitude	Suffix	"N(`attitude ,)"
at`torney	Suffix	"N(at`torney ,)"
`attribute	Suffix	"N(`attribute ,ss)"
at`trition	Suffix	"N(at`trition ,)"
au`dacity	Suffix	"N(au`dacity ,)"
`audience	Suffix	"N(`audience ,)"
`audio	Suffix	"N(`audio ,)"
`audiotape	Suffix	"N(`audiotape ,)"
audi`torium	Suffix	"N(audi`torium ,)"
`auger	Suffix	"N(`auger ,)"
`aught	Suffix	"N(`aught ,)"
`aunt	Suffix	"N(`aunt ,)"
`aura	Suffix	"N(`aura ,)"
`aureole	Suffix	"N(`aureole ,)"
aure`ola	Suffix	"N(aure`ola ,)"
au`rora	Suffix	"N(au`rora ,)"
au`thority	Suffix	"N(au`thority ,)"
`autism	Suffix	"N(`autism ,)"
`auto	Suffix	"N(`auto ,)"
au`tocracy	Suffix	"N(`autocrat ,)"
`autocrat	Suffix	"N(`autocrat ,)"
`automobile	Suffix	"N(`automobile ,)"
`autumn	Suffix	"N(`autumn ,)"
aux`iliary	Suffix	"N(aux`iliary ,)"
`avalanche	Suffix	"N(`avalanche ,)"
`avarice	Suffix	"N(`avarice ,)"
`avatar	Suffix	"N(`avatar ,)"
`avenue	Suffix	"N(`avenue ,)"
a`version	Suffix	"N(a`version ,)"
`aviary	Suffix	"N(`aviary ,)"
`aviatrix	Suffix	"N(`aviatrix ,)"
avo`cation	Suffix	"N(avo`cation ,)"
`awl	Suffix	"N(`awl ,)"
`awning	Suffix	"N(`awning ,)"
`axiom	Suffix	"N(`axiom ,)"
`axle	Suffix	"N(`axle ,)"
`azimuth	Suffix	"N(`azimuth ,)"
`babe	Suffix	"N(`babe ,)"
ba`boon	Suffix	"N(ba`boon ,)"
bacca`laureate	Suffix	"N(bacca`laureate ,)"
`baccarat	Suffix	"N(`baccarat ,)"
`bachelor	Suffix	"N(`bachelor ,)"
`backing	Suffix	"N(`back ,)"
`backache	Suffix	"N(`backache ,)"
`backboard	Suffix	"N(`backboard ,)"
`backbone	Suffix	"N(`backbone ,)"
`backdrop	Suffix	"N(`backdrop ,)"
`backgammon	Suffix	"N(`backgammon ,)"
`backorder	Suffix	"N(`backorder ,)"
`backplane	Suffix	"N(`backplane ,)"
`backplate	Suffix	"N(`backplate ,)"
`backside	Suffix	"N(`backside ,)"
`backslash	Suffix	"N(`backslash ,)"
back`stage	Suffix	"N(back`stage ,)"
`backstop	Suffix	"N(`backstop ,)"
`backwater	Suffix	"N(`backwater ,)"
back`wood	Suffix	"N(back`wood ,)"
back`yard	Suffix	"N(back`yard ,)"
`bacon	Suffix	"N(`bacon ,)"
`badge	Suffix	"N(`badge ,)"
`badinage	Suffix	"N(`badinage ,)"
`badland	Suffix	"N(`badland ,)"
`badminton	Suffix	"N(`badminton ,)"
`baffle	Suffix	"N(`baffle ,)"
baga`telle	Suffix	"N(baga`telle ,)"
`bagel	Suffix	"N(`bagel ,)"
`bagful	Suffix	"N(`bag ,)"
`baggage	Suffix	"N(`bag ,)"
`bagpipe	Suffix	"N(`bagpipe ,)"
`bail	Suffix	"N(`bail ,)"
`bailiff	Suffix	"N(`bailiff ,)"
`bailout	Suffix	"N(`bailout ,)"
`bakery	Suffix	"N(`bake ,deverb)"
bak`lava	Suffix	"N(bak`lava ,)"
`balcony	Suffix	"N(`balcony ,)"
`baldpate	Suffix	"N(`baldpate ,)"
`baldy	Suffix	"N(`bald ,deadj)"
`ballad	Suffix	"N(`ballad ,)"
balle`rina	Suffix	"N(balle`rina ,)"
bal`let	Suffix	"N(bal`let ,)"
`ballfield	Suffix	"N(`ballfield ,)"
`ballroom	Suffix	"N(`ballroom ,)"
`ballyhoo	Suffix	"N(`ballyhoo ,)"
`balm	Suffix	"N(`balm ,)"
`balustrade	Suffix	"N(`balustrade ,)"
ba`nana	Suffix	"N(ba`nana ,)"
ban`dana	Suffix	"N(ban`dana ,)"
`bandit	Suffix	"N(`bandit ,)"
`bandstand	Suffix	"N(`bandstand ,)"
`bandwagon	Suffix	"N(`bandwagon ,)"
`bandwidth	Suffix	"N(`bandwidth ,)"
`bane	Suffix	"N(`bane ,)"
`bangle	Suffix	"N(`bangle ,)"
`banister	Suffix	"N(`banister ,)"
`bankruptcy	Suffix	"N(`bankrupt ,deadj)"
`banshee	Suffix	"N(`banshee ,)"
`bantam	Suffix	"N(`bantam ,)"
`baptism	Suffix	"N(`baptize ,deverb)"
`baptistery	Suffix	"N(`baptistery ,)"
`baptistry	Suffix	"N(`baptistry ,)"
`barbarism	Suffix	"N(`barbarism ,)"
`barbell	Suffix	"N(`barbell ,)"
`barber	Suffix	"N(`barber ,)"
`barbital	Suffix	"N(`barbital ,)"
`barcarole	Suffix	"N(`barcarole ,)"
`barcarolle	Suffix	"N(`barcarolle ,)"
`bard	Suffix	"N(`bard ,)"
`barfly	Suffix	"N(`barfly ,)"
`barge	Suffix	"N(`barge ,)"
`baritone	Suffix	"N(`baritone ,)"
`bark	Suffix	"N(`bark - of tree,)"
`barley	Suffix	"N(`barley ,)"
`barn	Suffix	"N(`barn ,)"
`barnacle	Suffix	"N(`barnacle ,ajr8)"
`barnyard	Suffix	"N(`barnyard ,)"
ba`rometer	Suffix	"N(ba`rometer ,)"
`baron	Suffix	"N(`baron ,)"
baro`net	Suffix	"N(baro`net ,)"
`barque	Suffix	"N(`barque ,)"
`barrack	Suffix	"N(`barrack ,)"
bar`rage	Suffix	"N(bar`rage ,)"
`barre	Suffix	"N(`barre ,~ajr14)"
`barrel	Suffix	"N(`barrel ,)"
`barrier	Suffix	"N(`barrier ,)"
`barrow	Suffix	"N(`barrow ,)"
`baseball	Suffix	"N(`baseball ,)"
`baseboard	Suffix	"N(`baseboard ,)"
`baseline	Suffix	"N(`baseline ,)"
`basil	Suffix	"N(`basil ,)"
ba`silica	Suffix	"N(ba`silica ,)"
`basilisk	Suffix	"N(`basilisk ,)"
`basin	Suffix	"N(`basin ,)"
`basket	Suffix	"N(`basket ,)"
`basketball	Suffix	"N(`basketball ,)"
`basketful	Suffix	"N(`basket ,)"
bassi`net	Suffix	"N(bassi`net ,)"
`bass	Suffix	"N(`bass ,)"
bas`soon	Suffix	"N(bas`soon ,)"
`bastard	Suffix	"N(`bastard ,)"
`bastion	Suffix	"N(`bastion ,)"
`batch	Suffix	"N(`batch ,)"
`bath	Suffix	"N(`bath ,)"
`bathos	Suffix	"N(`bathos ,)"
`bathrobe	Suffix	"N(`bathrobe ,)"
`bathroom	Suffix	"N(`bathroom ,)"
`bathtub	Suffix	"N(`bathtub ,)"
ba`tik	Suffix	"N(ba`tik ,)"
ba`ton	Suffix	"N(ba`ton ,)"
`batt	Suffix	"N(`batt ,)"
bat`talion	Suffix	"N(bat`talion ,)"
`battery	Suffix	"N(`battery ,)"
`batting	Suffix	"N(`batting ,)"
`battlefield	Suffix	"N(`battlefield ,)"
`battlefront	Suffix	"N(`battlefront ,)"
`battleground	Suffix	"N(`battleground ,)"
`bauble	Suffix	"N(`bauble ,)"
`bay	Suffix	"N(`bay ,)"
bayo`net	Suffix	"N(bayo`net ,)"
`bayou	Suffix	"N(`bayou ,)"
ba`zaar	Suffix	"N(ba`zaar ,)"
`beachhead	Suffix	"N(`beachhead ,)"
`beacon	Suffix	"N(`beacon ,)"
`beak	Suffix	"N(`beak ,ajr8)"
`beaker	Suffix	"N(`beaker ,)"
`bean	Suffix	"N(`bean ,)"
`bear	Suffix	"N(`bear ,)"
`beard	Suffix	"N(`beard ,ajr8)"
`bearing	Suffix	"N(`bearing ,)"
`bearskin	Suffix	"N(`bearskin ,)"
`beast	Suffix	"N(`beast ,)"
`beat	Suffix	"N(`beat ,)"
beatifi`cation	Suffix	"N(be`atify ,deverb)"
`beatitude	Suffix	"N(`beatitude ,)"
beau`tician	Suffix	"N(beau`tician ,)"
beautifi`cation	Suffix	"N(`beautify ,deverb)"
`beauty	Suffix	"N(`beauty ,)"
`bebop	Suffix	"N(`bebop ,)"
`beck	Suffix	"N(`beck ,)"
`bedbug	Suffix	"N(`bedbug ,)"
`bedding	Suffix	"N(`bed ,)"
`bedfellow	Suffix	"N(`bedfellow ,)"
`bedlam	Suffix	"N(`bedlam ,)"
`bedpost	Suffix	"N(`bedpost ,)"
`bedrock	Suffix	"N(`bedrock ,)"
`bedroom	Suffix	"N(`bedroom ,)"
`bedside	Suffix	"N(`bedside ,)"
`bedspread	Suffix	"N(`bedspread ,)"
`bedspring	Suffix	"N(`bedspring ,)"
`bedtime	Suffix	"N(`bedtime ,)"
`bee	Suffix	"N(`bee ,)"
`beef	Suffix	"N(`beef ,)"
`beefsteak	Suffix	"N(`beefsteak ,)"
`beehive	Suffix	"N(`beehive ,)"
`beer	Suffix	"N(`beer ,)"
`beet	Suffix	"N(`beet ,)"
`beetle	Suffix	"N(`beetle ,)"
`beggar	Suffix	"N(`beggar ,)"
`beggary	Suffix	"N(`beg ,deverb)"
be`half	Suffix	"N(be`half ,)"
be`havior	Suffix	"N(be`have ,deverb)"
be`haviour	Suffix	"N(be`have - British,deverb)"
be`hemoth	Suffix	"N(be`hemoth ,)"
be`hest	Suffix	"N(be`hest ,)"
`belfry	Suffix	"N(`belfry ,)"
be`lief	Suffix	"N(be`lief ,)"
`bell	Suffix	"N(`bell ,)"
`bellboy	Suffix	"N(`bellboy ,)"
`belle	Suffix	"N(`belle ,)"
`bellhop	Suffix	"N(`bellhop ,)"
bel`ligerence	Suffix	"N(bel`ligerent ,deadj)"
bel`ligerency	Suffix	"N(bel`ligerent ,deadj)"
`bellwether	Suffix	"N(`bellwether ,)"
`bellyache	Suffix	"N(`bellyache ,)"
`bellyful	Suffix	"N(`belly ,)"
`belvedere	Suffix	"N(`belvedere ,)"
`benchmark	Suffix	"N(`benchmark ,)"
bene`diction	Suffix	"N(bene`diction ,)"
`benefactor	Suffix	"N(`benefactor ,)"
`benefice	Suffix	"N(`benefice ,)"
bene`ficiary	Suffix	"N(`benefice ,)"
be`nevolence	Suffix	"N(be`nevolent ,deadj)"
`benzene	Suffix	"N(`benzene ,)"
be`quest	Suffix	"N(be`quest ,)"
be`ret	Suffix	"N(be`ret ,)"
`berg	Suffix	"N(`berg ,)"
beri`beri	Suffix	"N(beri`beri ,)"
`berry	Suffix	"N(`berry ,)"
`berth	Suffix	"N(`berth ,)"
best`seller	Suffix	"N(best`seller ,)"
`betel	Suffix	"N(`betel ,)"
`beth	Suffix	"N(`beth ,)"
`bethel	Suffix	"N(`bethel ,)"
`bevel	Suffix	"N(`bevel ,)"
`beverage	Suffix	"N(`beverage ,)"
`bevy	Suffix	"N(`bevy ,)"
`bezel	Suffix	"N(`bezel ,)"
`bib	Suffix	"N(`bib ,)"
`bible	Suffix	"N(`bible ,)"
`bibliophile	Suffix	"N(`bibliophile ,)"
`bicycle	Suffix	"N(`bicycle ,)"
`bid	Suffix	"N(`bid ,)"
`biddy	Suffix	"N(`biddy ,)"
`bier	Suffix	"N(`bier ,)"
`bifocal	Suffix	"N(`focal ,deadj)"
`bigot	Suffix	"N(`bigot ,)"
`bigotry	Suffix	"N(`bigot ,)"
bi`jouterie	Suffix	"N(bi`jouterie ,)"
bi`kini	Suffix	"N(bi`kini ,)"
`bile	Suffix	"N(`bile ,)"
`bilge	Suffix	"N(`bilge ,)"
`billboard	Suffix	"N(`billboard ,)"
`billfold	Suffix	"N(`billfold ,)"
`billiard	Suffix	"N(`billiard ,)"
billion`aire	Suffix	"N(billion`aire ,)"
`billy	Suffix	"N(`billy ,)"
`bin	Suffix	"N(`bin ,)"
`bindery	Suffix	"N(`bind - or binder+ry,deverb)"
`binnacle	Suffix	"N(`binnacle ,)"
`biopsy	Suffix	"N(`biopsy ,)"
`biosphere	Suffix	"N(`biosphere ,)"
bi`ota	Suffix	"N(bi`ota ,)"
`biped	Suffix	"N(`biped ,)"
`biplane	Suffix	"N(`plane ,)"
`birch	Suffix	"N(`birch ,)"
`bird	Suffix	"N(`bird ,)"
`birdbath	Suffix	"N(`birdbath ,)"
`birdseed	Suffix	"N(`birdseed ,)"
`birthday	Suffix	"N(`birthday ,)"
`birthplace	Suffix	"N(`birthplace ,)"
`birthright	Suffix	"N(`birthright ,)"
`biscuit	Suffix	"N(`biscuit ,)"
`bishop	Suffix	"N(`bishop ,)"
`bishopric	Suffix	"N(`bishopric ,)"
`bisque	Suffix	"N(`bisque ,)"
`bit	Suffix	"N(`bit ,)"
`bitch	Suffix	"N(`bitch ,)"
`bitt	Suffix	"N(`bitt ,)"
`bivalve	Suffix	"N(`bivalve ,)"
`biz	Suffix	"N(`biz ,)"
`blackberry	Suffix	"N(`blackberry ,)"
`blackbird	Suffix	"N(`blackbird ,)"
`blackboard	Suffix	"N(`blackboard ,)"
`blacking	Suffix	"N(`black ,deadj)"
`blackjack	Suffix	"N(`blackjack ,)"
`blackout	Suffix	"N(`blackout ,)"
`blacksmith	Suffix	"N(`blacksmith ,)"
`bladder	Suffix	"N(`bladder ,)"
`blade	Suffix	"N(`blade ,)"
`blasphemy	Suffix	"N(`blasphemy ,)"
`blastoff	Suffix	"N(`blastoff ,)"
`blather	Suffix	"N(`blather ,)"
`blimp	Suffix	"N(`blimp ,)"
`blind	Suffix	"N(`blind ,)"
`blip	Suffix	"N(`blip ,)"
`bliss	Suffix	"N(`bliss ,)"
`blizzard	Suffix	"N(`blizzard ,)"
`blob	Suffix	"N(`blob ,)"
`bloc	Suffix	"N(`bloc ,)"
`blockbuster	Suffix	"N(`blockbuster ,)"
`blockhead	Suffix	"N(`blockhead ,)"
`blockhouse	Suffix	"N(`blockhouse ,)"
`bloke	Suffix	"N(`bloke ,)"
`blood	Suffix	"N(`blood ,ajr8)"
`bloodbath	Suffix	"N(`bloodbath ,)"
`bloodhound	Suffix	"N(`bloodhound ,)"
`bloodshed	Suffix	"N(`bloodshed ,)"
`bloodstain	Suffix	"N(`bloodstain ,)"
`bloodstream	Suffix	"N(`bloodstream ,)"
`blotch	Suffix	"N(`blotch ,)"
`blouse	Suffix	"N(`blouse ,)"
`blowback	Suffix	"N(`blowback ,)"
`blowtorch	Suffix	"N(`blowtorch ,)"
`blowup	Suffix	"N(`blowup ,)"
`blubber	Suffix	"N(`blubber ,)"
`blueberry	Suffix	"N(`blueberry ,)"
`bluebird	Suffix	"N(`bluebird ,)"
`bluebook	Suffix	"N(`bluebook ,)"
`bluegrass	Suffix	"N(`bluegrass ,)"
`bluing	Suffix	"N(`bluing ,)"
`blueing	Suffix	"N(`blueing ,)"
`bluejacket	Suffix	"N(`bluejacket ,)"
`blueprint	Suffix	"N(`blueprint ,)"
`bluff	Suffix	"N(`bluff - cliff,)"
`blurb	Suffix	"N(`blurb ,)"
`blutwurst	Suffix	"N(`blutwurst ,)"
`boar	Suffix	"N(`boar ,)"
`board	Suffix	"N(`board ,)"
`boardinghouse	Suffix	"N(`boardinghouse ,)"
`boathouse	Suffix	"N(`boathouse ,)"
`boatload	Suffix	"N(`boatload ,)"
`boatswain	Suffix	"N(`boatswain ,)"
`bosun	Suffix	"N(`boatswain ,)"
`bo'sun	Suffix	"N(`boatswain ,)"
`bos'n	Suffix	"N(`boatswain ,)"
`boatyard	Suffix	"N(`boatyard ,)"
`bob	Suffix	"N(`bob ,)"
`bobbin	Suffix	"N(`bobbin ,)"
`bobby	Suffix	"N(`bobby ,)"
`bock	Suffix	"N(`bock ,)"
bodhi`sattva	Suffix	"N(bodhi`sattva ,)"
`bodice	Suffix	"N(`bodice ,)"
`body	Suffix	"N(`body ,ajr8 ajr13)"
`bodyguard	Suffix	"N(`bodyguard ,)"
`bogey	Suffix	"N(`bogey ,)"
`boil	Suffix	"N(`boil - abcess,)"
bo`lero	Suffix	"N(bo`lero ,)"
`bolivar	Suffix	"N(`bolivar ,)"
`bolo	Suffix	"N(`bolo ,)"
`bolshevik	Suffix	"N(`bolshevik ,)"
`bombast	Suffix	"N(`bombast ,)"
bo`nanza	Suffix	"N(bo`nanza ,)"
`bondage	Suffix	"N(`bondage ,)"
`bondholder	Suffix	"N(`bondholder ,)"
`bonfire	Suffix	"N(`bonfire ,)"
`bong	Suffix	"N(`bong ,)"
`bonnet	Suffix	"N(`bonnet ,)"
`bonus	Suffix	"N(`bonus ,)"
`bonze	Suffix	"N(`bonze ,)"
`booby	Suffix	"N(`booby ,)"
`boogie	Suffix	"N(`boogie ,)"
`bookbindery	Suffix	"N(`bind ,deverb)"
`bookcase	Suffix	"N(`bookcase ,)"
`bookend	Suffix	"N(`bookend ,)"
`bookie	Suffix	"N(`bookie ,)"
`booklist	Suffix	"N(`booklist ,)"
`bookmobile	Suffix	"N(`bookmobile ,)"
`bookplate	Suffix	"N(`bookplate ,)"
`bookstore	Suffix	"N(`bookstore ,)"
`boom	Suffix	"N(`boom - spar,)"
`boon	Suffix	"N(`boon ,)"
`boor	Suffix	"N(`boor ,)"
`booth	Suffix	"N(`booth ,)"
`booty	Suffix	"N(`booty ,)"
bor`dello	Suffix	"N(bor`dello ,)"
`borderland	Suffix	"N(`borderland ,)"
`boredom	Suffix	"N(`bore ,deverb)"
`borough	Suffix	"N(`borough ,)"
`bosom	Suffix	"N(`bosom ,)"
`boson	Suffix	"N(`boson ,)"
`botfly	Suffix	"N(`botfly ,)"
`bottleful	Suffix	"N(`bottle ,)"
`bottleneck	Suffix	"N(`bottleneck ,)"
`botulism	Suffix	"N(`botulism ,)"
bou`doir	Suffix	"N(bou`doir ,)"
`bough	Suffix	"N(`bough ,)"
`boulder	Suffix	"N(`boulder ,)"
`boulevard	Suffix	"N(`boulevard ,)"
`bound	Suffix	"N(`bound ,)"
`boundary	Suffix	"N(`bound ,deverb)"
`bounty	Suffix	"N(`bounty ,)"
`bouquet	Suffix	"N(`bouquet ,)"
`bourbon	Suffix	"N(`bourbon ,)"
bourgeoi`sie	Suffix	"N(bourgeoi`sie ,)"
`bourn	Suffix	"N(`bourn ,)"
boustro`phedon	Suffix	"N(boustro`phedon ,)"
`bout	Suffix	"N(`bout ,)"
`boutique	Suffix	"N(`boutique ,)"
bouton`niere	Suffix	"N(bouton`niere ,)"
`bow	Suffix	"N(`bow - [baw] of a ship,)"
`bowel	Suffix	"N(`bowel ,)"
`bowie	Suffix	"N(`bowie ,)"
`bowl	Suffix	"N(`bowl ,)"
`bowlful	Suffix	"N(`bowl ,)"
`bowline	Suffix	"N(`bowline ,)"
`bowstring	Suffix	"N(`bowstring ,)"
`bowsprit	Suffix	"N(`bowsprit ,)"
`boxcar	Suffix	"N(`boxcar ,)"
`boxful	Suffix	"N(`box ,)"
`boxwood	Suffix	"N(`boxwood ,)"
`boy	Suffix	"N(`boy ,)"
`boyfriend	Suffix	"N(`boyfriend ,)"
`bra	Suffix	"N(`bra ,)"
`bracken	Suffix	"N(`bracken ,)"
`bract	Suffix	"N(`bract ,)"
`brad	Suffix	"N(`brad ,)"
`braggart	Suffix	"N(`braggart ,)"
`brainstorm	Suffix	"N(`brainstorm ,)"
`bramble	Suffix	"N(`bramble ,)"
`bran	Suffix	"N(`bran ,)"
`brandy	Suffix	"N(`brandy ,)"
`bravo	Suffix	"N(`bravo ,)"
`brass	Suffix	"N(`brass ,)"
bras`siere	Suffix	"N(bras`siere ,)"
`brat	Suffix	"N(`brat ,)"
`bratwurst	Suffix	"N(`bratwurst ,)"
bra`vado	Suffix	"N(bra`vado ,)"
`bravery	Suffix	"N(`brave ,deadj)"
bra`vura	Suffix	"N(bra`vura ,)"
`brazier	Suffix	"N(`brazier ,)"
`brawn	Suffix	"N(`brawn ,)"
`bread	Suffix	"N(`bread ,)"
`breadboard	Suffix	"N(`breadboard ,)"
`breadfruit	Suffix	"N(`breadfruit ,)"
`breadth	Suffix	"N(`broad ,deadj)"
`break	Suffix	"N(`break ,)"
`breakaway	Suffix	"N(`breakaway ,)"
`breakdown	Suffix	"N(`breakdown ,)"
`breakpoint	Suffix	"N(`breakpoint ,)"
`breakthrough	Suffix	"N(`breakthrough ,)"
`breakup	Suffix	"N(`breakup ,)"
`breakwater	Suffix	"N(`breakwater ,)"
`bream	Suffix	"N(`bream ,)"
`breast	Suffix	"N(`breast ,ajr8)"
`breastplate	Suffix	"N(`breastplate ,)"
`breastwork	Suffix	"N(`breastwork ,)"
`breath	Suffix	"N(`breath ,)"
`breech	Suffix	"N(`breech ,)"
`breed	Suffix	"N(`breed ,)"
`breeze	Suffix	"N(`breeze ,)"
`breve	Suffix	"N(`breve ,)"
`brevity	Suffix	"N(`brief ,deadj)"
`brewery	Suffix	"N(`brew ,deverb)"
`briar	Suffix	"N(`briar ,)"
`bribery	Suffix	"N(`bribe ,deverb)"
`brick	Suffix	"N(`brick ,)"
`brickbat	Suffix	"N(`brickbat ,)"
`bride	Suffix	"N(`bride ,)"
`bridegroom	Suffix	"N(`bridegroom ,)"
`bridesmaid	Suffix	"N(`bridesmaid ,)"
`bridgehead	Suffix	"N(`bridgehead ,)"
`bridgework	Suffix	"N(`bridgework ,)"
`brief	Suffix	"N(`brief ,)"
`briefcase	Suffix	"N(`briefcase ,)"
`brig	Suffix	"N(`brig ,)"
bri`gade	Suffix	"N(bri`gade ,)"
briga`dier	Suffix	"N(briga`dier ,)"
`brigand	Suffix	"N(`brigand ,)"
`brigantine	Suffix	"N(`brigantine ,)"
`brilliance	Suffix	"N(`brilliant ,deadj)"
`brilliancy	Suffix	"N(`brilliant ,deadj)"
`brim	Suffix	"N(`brim ,)"
`brimstone	Suffix	"N(`brimstone ,)"
`brindle	Suffix	"N(`brindle ,)"
`brine	Suffix	"N(`brine ,)"
`brink	Suffix	"N(`brink ,)"
`brinkmanship	Suffix	"N(`brinkmanship ,)"
`brisket	Suffix	"N(`brisket ,)"
`broadloom	Suffix	"N(`broadloom ,)"
`broadside	Suffix	"N(`broadside ,)"
`broccoli	Suffix	"N(`broccoli ,)"
bro`chure	Suffix	"N(bro`chure ,)"
`bromide	Suffix	"N(`bromide ,)"
bron`chitis	Suffix	"N(bron`chitis ,)"
`bronco	Suffix	"N(`bronco ,)"
`bronze	Suffix	"N(`bronze ,)"
`brooch	Suffix	"N(`brooch ,)"
`brook	Suffix	"N(`brook ,)"
`brookside	Suffix	"N(`brookside ,)"
`broom	Suffix	"N(`broom ,)"
`broth	Suffix	"N(`broth ,)"
`brothel	Suffix	"N(`brothel ,)"
`brouhaha	Suffix	"N(`brouhaha ,)"
`brow	Suffix	"N(`brow ,)"
`brownie	Suffix	"N(`brownie ,)"
`bruit	Suffix	"N(`bruit ,)"
`brunch	Suffix	"N(`brunch ,)"
bru`nette	Suffix	"N(bru`nette ,)"
`brunt	Suffix	"N(`brunt ,)"
`brushfire	Suffix	"N(`brushfire ,)"
`brushwork	Suffix	"N(`brushwork ,)"
`brute	Suffix	"N(`brute ,)"
bucca`neer	Suffix	"N(bucca`neer ,)"
`buck	Suffix	"N(`buck - male, dollar,~nr15)"
bucka`roo	Suffix	"N(bucka`roo ,)"
`buckboard	Suffix	"N(`buckboard ,)"
`bucket	Suffix	"N(`bucket ,)"
`bucketful	Suffix	"N(`bucket ,)"
`buckeye	Suffix	"N(`buckeye ,)"
`buckshot	Suffix	"N(`buckshot ,)"
`buckskin	Suffix	"N(`buckskin ,)"
`buckwheat	Suffix	"N(`buckwheat ,)"
`buddy	Suffix	"N(`buddy ,)"
`buff	Suffix	"N(`buff ,)"
buf`fet	Suffix	"N(buf`fet ,)"
buf`foon	Suffix	"N(buf`foon ,)"
`bug	Suffix	"N(`bug - insect,)"
`bugaboo	Suffix	"N(`bugaboo ,)"
`bugbear	Suffix	"N(`bugbear ,)"
`buildup	Suffix	"N(`buildup ,)"
`bulb	Suffix	"N(`bulb ,)"
`bulk	Suffix	"N(`bulk ,)"
`bulkhead	Suffix	"N(`bulkhead ,)"
`bull	Suffix	"N(`bull ,)"
`bulldog	Suffix	"N(`bulldog ,)"
`bullet	Suffix	"N(`bullet ,)"
`bulletin	Suffix	"N(`bulletin ,)"
`bullhide	Suffix	"N(`bullhide ,)"
`bullock	Suffix	"N(`bullock ,)"
`bullseye	Suffix	"N(`bullseye ,)"
`bullyboy	Suffix	"N(`bullyboy ,)"
`bulrush	Suffix	"N(`bulrush ,)"
`bulwark	Suffix	"N(`bulwark ,)"
`bum	Suffix	"N(`bum ,)"
`bumpkin	Suffix	"N(`bumpkin ,)"
`bun	Suffix	"N(`bun ,)"
`bungalow	Suffix	"N(`bungalow ,)"
`bunkmate	Suffix	"N(`bunkmate ,)"
`bunny	Suffix	"N(`bunny ,)"
`bunting	Suffix	"N(`bunting ,)"
`buoyancy	Suffix	"N(`buoy ,deverb+deajr)"
`bureau	Suffix	"N(`bureau ,)"
bu`reaucracy	Suffix	"N(`bureaucrat ,)"
`bureaucrat	Suffix	"N(`bureaucrat ,)"
`burg	Suffix	"N(`burg ,)"
`burgess	Suffix	"N(`burgess ,)"
`burgher	Suffix	"N(`burgher ,)"
`burglar	Suffix	"N(`burglar ,)"
`burglary	Suffix	"N(`burglary ,)"
`burl	Suffix	"N(`burl ,)"
`burlap	Suffix	"N(`burlap ,)"
bur`lesque	Suffix	"N(bur`lesque ,)"
`burley	Suffix	"N(`burley ,)"
`burnout	Suffix	"N(`burnout ,)"
`burr	Suffix	"N(`burr ,)"
bur`rito	Suffix	"N(bur`rito ,)"
bur`sitis	Suffix	"N(`bursa ,)"
`busboy	Suffix	"N(`busboy ,)"
`busful	Suffix	"N(`bus ,)"
`bush	Suffix	"N(`bush ,)"
`bushel	Suffix	"N(`bushel ,)"
`bushing	Suffix	"N(`bushing ,)"
`bushmaster	Suffix	"N(`bushmaster ,)"
`business	Suffix	"N(`business ,)"
`bust	Suffix	"N(`bust - statue, chest,)"
`busybody	Suffix	"N(`busybody ,)"
`butane	Suffix	"N(`butane ,)"
`butler	Suffix	"N(`butler ,)"
`butt	Suffix	"N(`butt ,)"
`butte	Suffix	"N(`butte ,)"
`butterball	Suffix	"N(`butterball ,)"
`buttercup	Suffix	"N(`buttercup ,)"
`butterfat	Suffix	"N(`butterfat ,)"
`butterfly	Suffix	"N(`butterfly ,)"
`buttermilk	Suffix	"N(`buttermilk ,)"
`buttock	Suffix	"N(`buttock ,)"
`buyout	Suffix	"N(`buyout ,)"
`buzzard	Suffix	"N(`buzzard ,)"
`buzzsaw	Suffix	"N(`buzzsaw ,)"
`buzzword	Suffix	"N(`buzzword ,)"
`bye	Suffix	"N(`bye ,)"
`bylaw	Suffix	"N(`bylaw ,)"
`byline	Suffix	"N(`byline ,)"
`bypath	Suffix	"N(`bypath ,)"
`byproduct	Suffix	"N(`byproduct ,)"
`byroad	Suffix	"N(`byroad ,)"
`bystander	Suffix	"N(`bystander ,)"
`byway	Suffix	"N(`byway ,)"
`byword	Suffix	"N(`byword ,)"
`cab	Suffix	"N(`cab ,)"
ca`bal	Suffix	"N(ca`bal ,)"
`cabalism	Suffix	"N(ca`bal ,)"
`cabalist	Suffix	"N(ca`bal ,)"
ca`bana	Suffix	"N(ca`bana ,)"
caba`ret	Suffix	"N(caba`ret ,)"
`cabbage	Suffix	"N(`cabbage ,)"
`cabin	Suffix	"N(`cabin ,)"
`cabinet	Suffix	"N(`cabinet ,)"
`cabinetry	Suffix	"N(`cabinet ,)"
`cable	Suffix	"N(`cable ,ajr8)"
ca`cao	Suffix	"N(ca`cao ,)"
`cad	Suffix	"N(`cad ,)"
ca`daver	Suffix	"N(ca`daver ,)"
`cadence	Suffix	"N(`cadence ,)"
ca`denza	Suffix	"N(ca`denza ,)"
ca`det	Suffix	"N(ca`det ,)"
`cadre	Suffix	"N(`cadre ,)"
ca`fe	Suffix	"N(ca`fe ,)"
cafe`teria	Suffix	"N(cafe`teria ,)"
caf`feine	Suffix	"N(caf`feine ,)"
ca`hoot	Suffix	"N(ca`hoot ,)"
`cairn	Suffix	"N(`cairn ,)"
`calabash	Suffix	"N(`calabash ,)"
ca`lamity	Suffix	"N(ca`lamity ,)"
calcifi`cation	Suffix	"N(`calcify ,deverb)"
`calcium	Suffix	"N(`calcium ,)"
calcula`bility	Suffix	"N(`calculate ,deverb+deajr)"
`calendar	Suffix	"N(`calendar ,)"
`calfskin	Suffix	"N(`calfskin ,)"
`caliber	Suffix	"N(`caliber ,)"
`calibre	Suffix	"N(`calibre ,)"
`caliper	Suffix	"N(`caliper ,)"
`caliph	Suffix	"N(`caliph ,)"
`caliphate	Suffix	"N(`caliph ,)"
calis`thenic	Suffix	"N(calis`thenic ,)"
`calligraph	Suffix	"N(`calligraph ,)"
cal`ligrapher	Suffix	"N(`calligraphy ,)"
cal`ligraphy	Suffix	"N(cal`ligraphy ,)"
cal`liope	Suffix	"N(cal`liope ,)"
`callus	Suffix	"N(`callus ,ajr8)"
`calorie	Suffix	"N(`calorie ,)"
`calumny	Suffix	"N(`calumny ,)"
`calvary	Suffix	"N(`calvary ,)"
`cam	Suffix	"N(`cam ,)"
cama`raderie	Suffix	"N(cama`raderie ,)"
`camber	Suffix	"N(`camber ,)"
`cambric	Suffix	"N(`cambric ,)"
`camel	Suffix	"N(`camel ,)"
`camelback	Suffix	"N(`camelback ,)"
ca`mellia	Suffix	"N(ca`mellia ,)"
`camera	Suffix	"N(`camera ,)"
`campanile	Suffix	"N(`campanile ,)"
`campfire	Suffix	"N(`campfire ,)"
`campground	Suffix	"N(`campground ,)"
`campsite	Suffix	"N(`campsite ,)"
`campus	Suffix	"N(`campus ,)"
ca`nal	Suffix	"N(ca`nal ,)"
ca`nary	Suffix	"N(ca`nary ,)"
`cancer	Suffix	"N(`cancer ,)"
can`dela	Suffix	"N(can`dela ,)"
can`descence	Suffix	"N(can`descent ,deadj)"
`candidacy	Suffix	"N(`candidate ,)"
`candidate	Suffix	"N(`candidate ,)"
`candle	Suffix	"N(`candle ,)"
`candlelight	Suffix	"N(`candlelight ,)"
`candlestick	Suffix	"N(`candlestick ,)"
`candor	Suffix	"N(`candor ,)"
`candour	Suffix	"N(`candour - British,)"
`cane	Suffix	"N(`cane ,~ajr17)"
`canful	Suffix	"N(`can ,)"
`canine	Suffix	"N(`canine ,)"
`canister	Suffix	"N(`canister ,)"
`canker	Suffix	"N(`canker ,)"
`cannery	Suffix	"N(`can ,)"
`cannibal	Suffix	"N(`cannibal ,)"
`cannister	Suffix	"N(`cannister ,)"
`cannon	Suffix	"N(`cannon ,)"
`cannonball	Suffix	"N(`cannonball ,)"
`canon	Suffix	"N(`canon ,)"
`canopy	Suffix	"N(`canopy ,)"
`cant	Suffix	"N(`cant ,)"
`cantaloupe	Suffix	"N(`cantaloupe ,)"
can`teen	Suffix	"N(can`teen ,)"
`canticle	Suffix	"N(`canticle ,)"
`cantilever	Suffix	"N(`cantilever ,)"
`cantle	Suffix	"N(`cantle ,)"
`canto	Suffix	"N(`canto ,)"
`canton	Suffix	"N(`canton ,)"
`cantor	Suffix	"N(`cantor ,)"
`canvas	Suffix	"N(`canvas ,)"
`canyon	Suffix	"N(`canyon ,)"
capa`bility	Suffix	"N(`capable ,deadj)"
ca`pacitance	Suffix	"N(ca`pacitance ,)"
ca`pacitor	Suffix	"N(ca`pacitor ,)"
ca`pacity	Suffix	"N(ca`pacity ,)"
`cape	Suffix	"N(`cape ,)"
`capful	Suffix	"N(`cap ,)"
`capillary	Suffix	"N(`capillary ,)"
`capita	Suffix	"N(`capita ,)"
`capital	Suffix	"N(`capital ,)"
`capitol	Suffix	"N(`capitol ,)"
`capo	Suffix	"N(`capo ,)"
ca`price	Suffix	"N(ca`price ,)"
`capstan	Suffix	"N(`capstan ,)"
`capstone	Suffix	"N(`capstone ,)"
`capsule	Suffix	"N(`capsule ,)"
`captaincy	Suffix	"N(`captain ,)"
`captor	Suffix	"N(`captor ,)"
`car	Suffix	"N(`car ,~ajr14)"
`caramel	Suffix	"N(`caramel ,)"
`caravan	Suffix	"N(`caravan ,)"
`caraway	Suffix	"N(`caraway ,)"
`carbine	Suffix	"N(`carbine ,)"
carbo`hydrate	Suffix	"N(carbo`hydrate ,)"
`carbon	Suffix	"N(`carbon ,)"
`carboy	Suffix	"N(`carboy ,)"
`carbuncle	Suffix	"N(`carbuncle ,)"
`carburetor	Suffix	"N(`carburetor ,)"
`carcase	Suffix	"N(`carcase - British,)"
`carcass	Suffix	"N(`carcass ,)"
`card	Suffix	"N(`card ,)"
`cardboard	Suffix	"N(`cardboard ,)"
`cardinal	Suffix	"N(`cardinal ,)"
ca`reer	Suffix	"N(ca`reer ,)"
`caret	Suffix	"N(`caret ,)"
`caretaker	Suffix	"N(`caretaker ,)"
`carfare	Suffix	"N(`carfare ,)"
`carful	Suffix	"N(`car ,)"
`carload	Suffix	"N(`carload ,)"
`carnage	Suffix	"N(`carnage ,)"
car`nation	Suffix	"N(car`nation ,)"
`carnival	Suffix	"N(`carnival ,)"
`carnivore	Suffix	"N(`carnivore ,)"
`carob	Suffix	"N(`carob ,)"
`carp	Suffix	"N(`carp ,)"
`carpenter	Suffix	"N(`carpenter ,)"
`carpentry	Suffix	"N(`carpenter ,)"
`carport	Suffix	"N(`carport ,)"
`carrel	Suffix	"N(`carrel ,)"
`carriage	Suffix	"N(`carriage ,)"
`carrion	Suffix	"N(`carrion ,)"
`carrot	Suffix	"N(`carrot ,)"
`carryover	Suffix	"N(`carryover ,)"
car`tel	Suffix	"N(car`tel ,)"
`cartilage	Suffix	"N(`cartilage ,)"
`carton	Suffix	"N(`carton ,)"
car`toon	Suffix	"N(car`toon ,)"
`cartridge	Suffix	"N(`cartridge ,)"
`cartwheel	Suffix	"N(`cartwheel ,)"
cary`atid	Suffix	"N(cary`atid ,)"
casa`nova	Suffix	"N(casa`nova ,)"
`case	Suffix	"N(`case ,~ajr17)"
`casebook	Suffix	"N(`casebook ,)"
`casein	Suffix	"N(`casein ,)"
`casement	Suffix	"N(`casement ,)"
`casework	Suffix	"N(`casework ,)"
`cashew	Suffix	"N(`cashew ,)"
ca`shier	Suffix	"N(ca`shier ,)"
`cashmere	Suffix	"N(`cashmere ,)"
`casing	Suffix	"N(`casing ,)"
ca`sino	Suffix	"N(ca`sino ,)"
`cask	Suffix	"N(`cask ,)"
`casket	Suffix	"N(`casket ,)"
`casserole	Suffix	"N(`casserole ,)"
cas`sette	Suffix	"N(cas`sette ,)"
`cassock	Suffix	"N(`cassock ,)"
casta`net	Suffix	"N(casta`net ,)"
`castaway	Suffix	"N(`castaway ,)"
`caste	Suffix	"N(`caste ,)"
`castle	Suffix	"N(`castle ,)"
`castor	Suffix	"N(`castor ,)"
`casualty	Suffix	"N(`casualty ,)"
`cat	Suffix	"N(`cat ,)"
`cataclysm	Suffix	"N(`cataclysm ,)"
`catacomb	Suffix	"N(`catacomb ,)"
`catalyst	Suffix	"N(`catalyst ,)"
`catapult	Suffix	"N(`catapult ,)"
`cataract	Suffix	"N(`cataract ,)"
ca`tastrophe	Suffix	"N(ca`tastrophe ,)"
`catcall	Suffix	"N(`catcall ,)"
`catch	Suffix	"N(`catch ,)"
`catchup	Suffix	"N(`catchup ,)"
`catchword	Suffix	"N(`catchword ,)"
`catechism	Suffix	"N(`catechism ,)"
`catechist	Suffix	"N(`catechist ,)"
`category	Suffix	"N(`category ,)"
`caterpillar	Suffix	"N(`caterpillar ,)"
`catfish	Suffix	"N(`catfish ,)"
ca`thedra	Suffix	"N(ca`thedra ,)"
ca`thedral	Suffix	"N(ca`thedral ,)"
`cation	Suffix	"N(`cation ,)"
`catsup	Suffix	"N(`catsup ,)"
`cauldron	Suffix	"N(`cauldron ,)"
`cauliflower	Suffix	"N(`cauliflower ,)"
`caulking	Suffix	"N(`caulk ,)"
`cavalcade	Suffix	"N(`cavalcade ,)"
`cavalry	Suffix	"N(`cavalry ,)"
`caveat	Suffix	"N(`caveat ,)"
`cavern	Suffix	"N(`cavern ,)"
`caviar	Suffix	"N(`caviar ,)"
`cavity	Suffix	"N(`cavity ,)"
`cayenne	Suffix	"N(`cayenne ,)"
`ceasefire	Suffix	"N(`ceasefire ,)"
`cedar	Suffix	"N(`cedar ,)"
ce`dilla	Suffix	"N(ce`dilla ,)"
`ceiling	Suffix	"N(`ceiling ,)"
`celandine	Suffix	"N(`celandine ,)"
`celebrant	Suffix	"N(`celebrant ,)"
ce`lebrity	Suffix	"N(ce`lebrity ,)"
ce`lerity	Suffix	"N(ce`lerity ,)"
`celery	Suffix	"N(`celery ,)"
ce`lesta	Suffix	"N(ce`lesta ,)"
`celibacy	Suffix	"N(`celibate ,deadj)"
`cell	Suffix	"N(`cell ,)"
`cellar	Suffix	"N(`cellar ,)"
`cello	Suffix	"N(`cello ,)"
`cellophane	Suffix	"N(`cellophane ,)"
`cemetery	Suffix	"N(`cemetery ,)"
`census	Suffix	"N(`census ,)"
`cent	Suffix	"N(`cent ,)"
`centaur	Suffix	"N(`centaur ,)"
cen`tenary	Suffix	"N(cen`tenary ,)"
`centerline	Suffix	"N(`centerline ,)"
`centerpiece	Suffix	"N(`centerpiece ,)"
`centrepiece	Suffix	"N(`centrepiece - British,)"
`centigrade	Suffix	"N(`centigrade ,)"
`centimeter	Suffix	"N(`centimeter ,)"
`centrist	Suffix	"N(`center ,)"
`centroid	Suffix	"N(`center ,)"
cen`turion	Suffix	"N(cen`turion ,)"
`century	Suffix	"N(`century ,)"
`cereal	Suffix	"N(`cereal ,)"
`ceremony	Suffix	"N(`ceremony ,)"
`cereus	Suffix	"N(`cereus ,)"
`certainty	Suffix	"N(`certain ,deadj)"
cer`tificate	Suffix	"N(`certify ,deverb)"
certifi`cation	Suffix	"N(`certify ,deverb)"
`certitude	Suffix	"N(`certitude ,)"
ces`sation	Suffix	"N(ces`sation ,)"
`cession	Suffix	"N(`cession ,)"
`chaff	Suffix	"N(`chaff ,)"
cha`grin	Suffix	"N(cha`grin ,)"
`chairlady	Suffix	"N(`chairlady ,)"
`chairperson	Suffix	"N(`chairperson ,)"
`chaise	Suffix	"N(`chaise ,)"
cha`let	Suffix	"N(cha`let ,)"
`chalice	Suffix	"N(`chalice ,)"
`chalk	Suffix	"N(`chalk ,)"
`chalkboard	Suffix	"N(`chalkboard ,)"
`chalkline	Suffix	"N(`chalkline ,)"
`chamber	Suffix	"N(`chamber ,)"
`chamberlain	Suffix	"N(`chamberlain ,)"
`chambermaid	Suffix	"N(`chambermaid ,)"
`chamois	Suffix	"N(`chamois ,)"
`champ	Suffix	"N(`champ ,)"
cham`pagne	Suffix	"N(cham`pagne ,)"
`champion	Suffix	"N(`champion ,)"
`chancel	Suffix	"N(`chancel ,)"
`chancellor	Suffix	"N(`chancellor ,)"
`chancery	Suffix	"N(`chancery ,)"
chande`lier	Suffix	"N(chande`lier ,)"
`chandler	Suffix	"N(`chandler ,)"
`changeover	Suffix	"N(`changeover ,)"
`channel	Suffix	"N(`channel ,)"
chan`son	Suffix	"N(chan`son ,)"
chanson`nier	Suffix	"N(chanson`nier ,)"
`chantry	Suffix	"N(`chant ,deverb)"
`chaos	Suffix	"N(`chaos ,)"
`chap	Suffix	"N(`chap ,)"
chapar`ral	Suffix	"N(chapar`ral ,)"
`chapel	Suffix	"N(`chapel ,)"
`chaplain	Suffix	"N(`chaplain ,)"
`chaplaincy	Suffix	"N(`chaplain ,)"
`chapter	Suffix	"N(`chapter ,)"
`character	Suffix	"N(`character ,~nr31)"
character`istic	Suffix	"N(character`istic ,)"
`charcoal	Suffix	"N(`charcoal ,)"
`chard	Suffix	"N(`chard ,)"
`chariot	Suffix	"N(`chariot ,)"
cha`risma	Suffix	"N(cha`risma ,)"
`charity	Suffix	"N(`charity ,)"
`charlatan	Suffix	"N(`charlatan ,)"
`charnel	Suffix	"N(`charnel ,)"
`chartroom	Suffix	"N(`chartroom ,)"
`chasm	Suffix	"N(`chasm ,)"
`chassis	Suffix	"N(`chassis ,)"
`chattel	Suffix	"N(`chattel ,)"
chauf`feur	Suffix	"N(chauf`feur ,)"
`chauvinism	Suffix	"N(`chauvinism ,)"
`chauvinist	Suffix	"N(`chauvinist ,)"
`chaw	Suffix	"N(`chaw ,)"
`check	Suffix	"N(`check - bill,)"
`checkbook	Suffix	"N(`checkbook ,)"
`checkerboard	Suffix	"N(`checkerboard ,)"
`checklist	Suffix	"N(`checklist ,)"
`checkout	Suffix	"N(`checkout ,)"
`checkpoint	Suffix	"N(`checkpoint ,)"
`checkup	Suffix	"N(`checkup ,)"
`cheek	Suffix	"N(`cheek ,ajr8)"
`cheekbone	Suffix	"N(`cheekbone ,)"
`cheekful	Suffix	"N(`cheek ,)"
`cheese	Suffix	"N(`cheese ,)"
`cheesecake	Suffix	"N(`cheesecake ,)"
`cheesecloth	Suffix	"N(`cheesecloth ,)"
`cheetah	Suffix	"N(`cheetah ,)"
`chef	Suffix	"N(`chef ,)"
che`mise	Suffix	"N(che`mise ,)"
`chemist	Suffix	"N(`chemist ,)"
`chemistry	Suffix	"N(`chemistry ,)"
che`nille	Suffix	"N(che`nille ,)"
`cheque	Suffix	"N(`cheque ,)"
`cherry	Suffix	"N(`cherry ,)"
`chess	Suffix	"N(`chess ,)"
`chessboard	Suffix	"N(`chessboard ,)"
`chest	Suffix	"N(`chest ,ajr8)"
`chestful	Suffix	"N(`chest ,)"
`chestnut	Suffix	"N(`chestnut ,)"
che`valier	Suffix	"N(che`valier ,)"
`chevron	Suffix	"N(`chevron ,)"
chi`mera	Suffix	"N(chi`mera ,)"
chi`anti	Suffix	"N(chi`anti ,)"
chi`canery	Suffix	"N(chi`canery ,)"
`chick	Suffix	"N(`chick ,)"
`chickadee	Suffix	"N(`chickadee ,)"
`chicken	Suffix	"N(`chicken ,)"
`chicory	Suffix	"N(`chicory ,)"
`chieftain	Suffix	"N(`chieftain ,)"
`chieftaincy	Suffix	"N(`chieftain ,)"
`chiffon	Suffix	"N(`chiffon ,)"
`chigger	Suffix	"N(`chigger ,)"
`chignon	Suffix	"N(`chignon ,)"
`chilblain	Suffix	"N(`chilblain ,)"
`childbearing	Suffix	"N(`bear ,deverb)"
`childbirth	Suffix	"N(`childbirth ,)"
`chimney	Suffix	"N(`chimney ,)"
`chin	Suffix	"N(`chin ,)"
`china	Suffix	"N(`china ,)"
`chink	Suffix	"N(`chink ,)"
`chipboard	Suffix	"N(`chipboard ,)"
`chipmunk	Suffix	"N(`chipmunk ,)"
`chiropractor	Suffix	"N(`chiropractor ,)"
`chit	Suffix	"N(`chit ,)"
`chivalry	Suffix	"N(`chivalry ,)"
`chive	Suffix	"N(`chive ,)"
`chock	Suffix	"N(`chock ,)"
`chocolate	Suffix	"N(`chocolate ,)"
`choir	Suffix	"N(`choir ,)"
`choirmaster	Suffix	"N(`choirmaster ,)"
`cholera	Suffix	"N(`cholera ,)"
cho`lesterol	Suffix	"N(cho`lesterol ,)"
`chop	Suffix	"N(`chop - meat,)"
`chopstick	Suffix	"N(`chopstick ,)"
cho`rale	Suffix	"N(cho`rale ,)"
`chord	Suffix	"N(`chord ,)"
`chore	Suffix	"N(`chore ,)"
`chorus	Suffix	"N(`chorus ,)"
`chow	Suffix	"N(`chow ,)"
`chowder	Suffix	"N(`chowder ,)"
`chrome	Suffix	"N(`chrome ,)"
`chrysalis	Suffix	"N(`chrysalis ,)"
chry`santhemum	Suffix	"N(chry`santhemum ,)"
`chub	Suffix	"N(`chub ,)"
`chum	Suffix	"N(`chum ,)"
`chump	Suffix	"N(`chump ,)"
`chunk	Suffix	"N(`chunk ,)"
`church	Suffix	"N(`church ,ajr8)"
`churchyard	Suffix	"N(`churchyard ,)"
`chute	Suffix	"N(`chute ,)"
`chutney	Suffix	"N(`chutney ,)"
`chutzpah	Suffix	"N(`chutzpah ,)"
`cider	Suffix	"N(`cider ,)"
ci`gar	Suffix	"N(ci`gar ,)"
ci`garette	Suffix	"N(ci`garette ,)"
ci`garet	Suffix	"N(ci`garet ,)"
`cinema	Suffix	"N(`cinema ,)"
`cinnamon	Suffix	"N(`cinnamon ,)"
`circlet	Suffix	"N(`circlet ,)"
`circuit	Suffix	"N(`circuit ,)"
`circuitry	Suffix	"N(`circuit ,)"
`circulant	Suffix	"N(`circulant ,)"
cir`cumference	Suffix	"N(cir`cumference ,)"
`circumflex	Suffix	"N(`circumflex ,)"
circumlo`cution	Suffix	"N(circumlo`cution ,)"
circum`scription	Suffix	"N(`circumscribe ,deverb)"
circum`spection	Suffix	"N(`circumspect ,deadj)"
`circumstance	Suffix	"N(`circumstance ,)"
`circus	Suffix	"N(`circus ,)"
`cistern	Suffix	"N(`cistern ,)"
`citadel	Suffix	"N(`citadel ,)"
`citizen	Suffix	"N(`citizen ,)"
`citizenry	Suffix	"N(`citizen ,)"
`citrus	Suffix	"N(`citrus ,)"
`city	Suffix	"N(`city ,)"
`civet	Suffix	"N(`civet ,)"
clair`voyant	Suffix	"N(clair`voyant ,)"
`clam	Suffix	"N(`clam ,)"
`clamshell	Suffix	"N(`clamshell ,)"
`clan	Suffix	"N(`clan ,)"
`clapboard	Suffix	"N(`clapboard ,)"
`claret	Suffix	"N(`claret ,)"
clarifi`cation	Suffix	"N(`clarify ,deverb)"
clari`net	Suffix	"N(clari`net ,)"
`clarity	Suffix	"N(`clear ,deadj)"
`classmate	Suffix	"N(`classmate ,)"
`classroom	Suffix	"N(`classroom ,)"
`clause	Suffix	"N(`clause ,)"
claustro`phobia	Suffix	"N(claustro`phobia ,)"
`clay	Suffix	"N(`clay ,)"
`cleanup	Suffix	"N(`cleanup ,)"
`clearing	Suffix	"N(`clear ,deadj)"
`cleat	Suffix	"N(`cleat ,)"
`cleft	Suffix	"N(`cleft ,)"
`clemency	Suffix	"N(`clement ,deadj)"
`clergy	Suffix	"N(`clergy ,)"
`cleric	Suffix	"N(`cleric ,)"
`clerk	Suffix	"N(`clerk ,)"
cli`che	Suffix	"N(cli`che ,)"
`client	Suffix	"N(`client ,)"
clien`tele	Suffix	"N(clien`tele ,)"
`cliff	Suffix	"N(`cliff ,)"
`cliffhanger	Suffix	"N(`hang ,deverb)"
`climate	Suffix	"N(`climate ,)"
`clime	Suffix	"N(`clime ,)"
`cline	Suffix	"N(`cline ,~ajr20)"
`clinic	Suffix	"N(`clinic ,)"
`clipboard	Suffix	"N(`clipboard ,)"
`clique	Suffix	"N(`clique ,)"
`clitic	Suffix	"N(`clitic ,)"
`cloakroom	Suffix	"N(`cloakroom ,)"
`clock	Suffix	"N(`clock ,)"
`clockwork	Suffix	"N(`clockwork ,)"
`clod	Suffix	"N(`clod ,)"
`closet	Suffix	"N(`closet ,)"
`closeup	Suffix	"N(`closeup ,)"
`closure	Suffix	"N(`close ,deverb)"
`cloth	Suffix	"N(`cloth ,)"
`clotheshorse	Suffix	"N(`clotheshorse ,)"
`clothesline	Suffix	"N(`clothesline ,)"
`clothier	Suffix	"N(`clothier ,)"
`cloture	Suffix	"N(`cloture ,)"
`cloudburst	Suffix	"N(`cloudburst ,)"
`clout	Suffix	"N(`clout ,)"
`clove	Suffix	"N(`clove ,)"
`clover	Suffix	"N(`clover ,)"
`clubhouse	Suffix	"N(`clubhouse ,)"
`clubroom	Suffix	"N(`clubroom ,)"
`clue	Suffix	"N(`clue ,)"
`clutch	Suffix	"N(`clutch ,)"
`coachwork	Suffix	"N(`coachwork ,)"
coad`jutor	Suffix	"N(coad`jutor ,)"
`coal	Suffix	"N(`coal ,)"
coa`lition	Suffix	"N(coa`lition ,)"
`coast	Suffix	"N(`coast - shore,)"
`coastline	Suffix	"N(`coastline ,)"
`coattail	Suffix	"N(`coattail ,)"
`cobalt	Suffix	"N(`cobalt ,)"
`cobblestone	Suffix	"N(`cobblestone ,)"
`cobra	Suffix	"N(`cobra ,)"
`cobweb	Suffix	"N(`cobweb ,)"
co`caine	Suffix	"N(co`caine ,)"
`cochlea	Suffix	"N(`cochlea ,)"
`cock	Suffix	"N(`cock ,)"
`cockcrow	Suffix	"N(`cockcrow ,)"
`cockpit	Suffix	"N(`cockpit ,)"
`cocktail	Suffix	"N(`cocktail ,)"
`coco	Suffix	"N(`coco ,)"
`cocoa	Suffix	"N(`cocoa ,)"
`cocoanut	Suffix	"N(`cocoanut ,)"
`coconut	Suffix	"N(`coconut ,)"
co`coon	Suffix	"N(co`coon ,)"
`coda	Suffix	"N(`coda ,)"
`codeword	Suffix	"N(`codeword ,)"
`codicil	Suffix	"N(`codicil ,)"
`codpiece	Suffix	"N(`codpiece ,)"
`coed	Suffix	"N(`coed ,)"
coef`ficient	Suffix	"N(coef`ficient ,)"
`coffee	Suffix	"N(`coffee ,)"
`coffeecup	Suffix	"N(`coffeecup ,)"
`coffeepot	Suffix	"N(`coffeepot ,)"
`coffer	Suffix	"N(`coffer ,)"
`cog	Suffix	"N(`cog ,)"
`cognac	Suffix	"N(`cognac ,)"
`cognate	Suffix	"N(`cognate ,)"
cog`nition	Suffix	"N(cog`nition ,)"
`cognizance	Suffix	"N(`cognizant ,deadj)"
co`hesion	Suffix	"N(co`here ,deverb)"
`cohort	Suffix	"N(`cohort ,)"
`cohosh	Suffix	"N(`cohosh ,)"
coif`fure	Suffix	"N(coif`fure ,)"
`coke	Suffix	"N(`coke ,)"
`cola	Suffix	"N(`cola ,)"
`colander	Suffix	"N(`colander ,)"
`colic	Suffix	"N(`colic ,)"
coli`seum	Suffix	"N(coli`seum ,)"
col`lage	Suffix	"N(col`lage ,)"
`collagen	Suffix	"N(`collagen ,)"
`collarbone	Suffix	"N(`collarbone ,)"
col`lateral	Suffix	"N(col`lateral ,)"
`colleague	Suffix	"N(`colleague ,)"
`college	Suffix	"N(`college ,)"
`collet	Suffix	"N(`collet ,)"
`collie	Suffix	"N(`collie ,)"
col`lision	Suffix	"N(col`lide ,deverb)"
col`lusion	Suffix	"N(col`lude ,deverb)"
co`logne	Suffix	"N(co`logne ,)"
`colon	Suffix	"N(`colon ,~ajr17)"
`colonel	Suffix	"N(`colonel ,)"
`colonist	Suffix	"N(`colony ,)"
`colonnade	Suffix	"N(`colonnade ,)"
`colony	Suffix	"N(`colony ,)"
colora`tura	Suffix	"N(colora`tura ,)"
`colt	Suffix	"N(`colt ,)"
`column	Suffix	"N(`column ,)"
`coma	Suffix	"N(`coma ,)"
`combat	Suffix	"N(`combat ,ss)"
com`batant	Suffix	"N(`combat ,deverb)"
`comeback	Suffix	"N(`comeback ,)"
`combinator	Suffix	"N(com`bine ,deverb)"
`combine	Suffix	"N(`combine ,ss)"
comedi`enne	Suffix	"N(comedi`enne ,)"
`comedy	Suffix	"N(`comedy ,)"
`comet	Suffix	"N(`comet ,)"
`comfit	Suffix	"N(`comfit ,)"
`comma	Suffix	"N(`comma ,)"
`commentary	Suffix	"N(`comment ,)"
`commentator	Suffix	"N(`comment ,)"
`commerce	Suffix	"N(`commerce ,ss)"
com`mercial	Suffix	"N(`commerce ,)"
commis`sariat	Suffix	"N(commis`sariat ,)"
`commissary	Suffix	"N(`commissary ,)"
com`mittee	Suffix	"N(com`mittee ,)"
com`modity	Suffix	"N(com`modity ,)"
`commodore	Suffix	"N(`commodore ,)"
`common	Suffix	"N(`common ,)"
common`ality	Suffix	"N(`common ,deadj)"
`commoner	Suffix	"N(`common ,deadj)"
`commonweal	Suffix	"N(`commonweal ,)"
`commonwealth	Suffix	"N(`commonwealth ,)"
com`motion	Suffix	"N(com`motion ,)"
`commune	Suffix	"N(`commune ,)"
com`municant	Suffix	"N(com`municant ,)"
communi`que	Suffix	"N(communi`que ,)"
com`munity	Suffix	"N(com`mune ,deverb)"
`compact	Suffix	"N(`compact ,)"
com`panion	Suffix	"N(com`panion ,)"
com`panionway	Suffix	"N(com`panionway ,)"
`company	Suffix	"N(`company ,)"
com`parator	Suffix	"N(com`pare ,deverb)"
com`parison	Suffix	"N(com`pare ,deverb)"
com`partment	Suffix	"N(com`partment ,)"
`compass	Suffix	"N(`compass ,)"
com`passion	Suffix	"N(com`passion ,)"
compati`bility	Suffix	"N(com`patible ,deadj)"
com`patriot	Suffix	"N(com`patriot ,)"
`competence	Suffix	"N(`competent ,deadj)"
`competency	Suffix	"N(`competent ,deadj)"
com`petitor	Suffix	"N(com`pete ,deverb)"
com`placence	Suffix	"N(com`placent ,deadj)"
com`placency	Suffix	"N(com`placent ,deadj)"
com`plaint	Suffix	"N(com`plaint ,)"
com`plaisance	Suffix	"N(com`plaisant ,deadj)"
complemen`tarity	Suffix	"N(`complement ,)"
`complex	Suffix	"N(`complex ,)"
com`plexion	Suffix	"N(com`plexion ,ajr8)"
com`plicity	Suffix	"N(com`plicity ,)"
`compline	Suffix	"N(`compline ,)"
com`ponent	Suffix	"N(com`ponent ,)"
com`positor	Suffix	"N(com`positor ,)"
com`posure	Suffix	"N(com`pose ,deverb)"
`compote	Suffix	"N(`compote ,)"
`compound	Suffix	"N(`compound ,ss)"
comprehensi`bility	Suffix	"N(compre`hend ,deverb+deajr)"
compre`hension	Suffix	"N(compre`hend ,deverb)"
`compress	Suffix	"N(`compress ,ss)"
`comptroller	Suffix	"N(`comptroller ,)"
com`pulsion	Suffix	"N(com`pell ,deverb)"
com`punction	Suffix	"N(com`punction ,)"
`comrade	Suffix	"N(`comrade ,)"
`con	Suffix	"N(`con - pros and cons,)"
con`ceit	Suffix	"N(con`ceit ,ajr8)"
`concept	Suffix	"N(`concept ,)"
con`ception	Suffix	"N(con`ceive ,deverb)"
`concert	Suffix	"N(`concert ,ss)"
concer`tina	Suffix	"N(concer`tina ,)"
`concertmaster	Suffix	"N(`concertmaster ,)"
con`cession	Suffix	"N(con`cede ,deverb)"
concession`aire	Suffix	"N(concession`aire ,)"
`conch	Suffix	"N(`conch ,)"
`concierge	Suffix	"N(`concierge ,)"
con`cision	Suffix	"N(con`cise ,deadj)"
`conclave	Suffix	"N(`conclave ,)"
con`clusion	Suffix	"N(con`clude ,deverb)"
`concord	Suffix	"N(`concord ,)"
`concourse	Suffix	"N(`concourse ,)"
con`cretion	Suffix	"N(con`cretion ,)"
`concubine	Suffix	"N(`concubine ,)"
con`cupiscence	Suffix	"N(con`cupiscent ,deadj)"
condes`cension	Suffix	"N(condes`cend ,deverb)"
`condiment	Suffix	"N(`condiment ,)"
`condo	Suffix	"N(`condo - condominium,)"
condo`minium	Suffix	"N(condo`minium ,)"
`condor	Suffix	"N(`condor ,)"
`conduct	Suffix	"N(`conduct ,ss)"
`conduit	Suffix	"N(`conduit ,)"
`cone	Suffix	"N(`cone ,)"
`coneflower	Suffix	"N(`coneflower ,)"
`coney	Suffix	"N(`coney ,)"
con`fectionery	Suffix	"N(con`fection ,)"
con`federacy	Suffix	"N(con`federate ,)"
confer`ee	Suffix	"N(con`fer - exception to Gemination,deverb)"
`conference	Suffix	"N(con`fer ,deverb)"
`confidant	Suffix	"N(`confidant ,)"
`confidante	Suffix	"N(`confidante ,)"
confla`gration	Suffix	"N(confla`gration ,)"
`conflict	Suffix	"N(`conflict ,ss)"
con`formist	Suffix	"N(con`form ,deverb)"
con`formity	Suffix	"N(con`form ,deverb)"
`confrere	Suffix	"N(`confrere ,)"
`congener	Suffix	"N(`congener ,)"
con`glomerate	Suffix	"N(con`glomerate ,)"
`congress	Suffix	"N(`congress ,)"
con`gruence	Suffix	"N(con`gruent ,deadj)"
con`gruency	Suffix	"N(con`gruent ,deadj)"
con`gruity	Suffix	"N(con`gruity ,)"
`conifer	Suffix	"N(`conifer ,)"
con`jecture	Suffix	"N(con`jecture ,)"
`conjoint	Suffix	"N(`conjoint ,)"
`conjunct	Suffix	"N(`conjunct ,)"
con`junction	Suffix	"N(con`join ,deverb)"
con`juncture	Suffix	"N(con`juncture ,)"
con`nexion	Suffix	"N(con`nect - British,deverb)"
connois`seur	Suffix	"N(connois`seur ,)"
`conquest	Suffix	"N(`conquer ,deverb)"
con`quistador	Suffix	"N(con`quistador ,)"
`conscience	Suffix	"N(`conscience ,)"
`conscript	Suffix	"N(`conscript ,ss)"
con`sensus	Suffix	"N(con`sensus ,)"
con`servancy	Suffix	"N(con`serve ,deverb)"
con`servatism	Suffix	"N(con`servatism ,)"
con`servator	Suffix	"N(con`serve ,deverb)"
con`servatory	Suffix	"N(con`servatory ,)"
`consequence	Suffix	"N(`consequent ,deadj)"
con`sistency	Suffix	"N(con`sistent ,deadj)"
`consonant	Suffix	"N(`consonant ,)"
`consort	Suffix	"N(`consort ,ss)"
con`sortium	Suffix	"N(con`sortium ,)"
con`spiracy	Suffix	"N(con`spire ,deverb)"
con`spirator	Suffix	"N(con`spire ,deverb)"
`constable	Suffix	"N(`constable ,)"
`constancy	Suffix	"N(`constant ,deadj)"
con`stituency	Suffix	"N(con`stituent ,deadj)"
con`straint	Suffix	"N(con`straint ,)"
`construct	Suffix	"N(`construct ,ss)"
`consul	Suffix	"N(`consul ,)"
`consulate	Suffix	"N(`consulate ,)"
con`sumption	Suffix	"N(con`sume ,deverb)"
con`tagion	Suffix	"N(con`tagion ,)"
con`taminant	Suffix	"N(con`taminant ,)"
con`tempt	Suffix	"N(con`tempt ,)"
`content	Suffix	"N(`content ,)"
con`tention	Suffix	"N(con`tend ,deverb)"
`contest	Suffix	"N(`contest ,ss)"
`context	Suffix	"N(`context ,)"
conti`guity	Suffix	"N(conti`guity ,)"
`continence	Suffix	"N(`continent ,deadj)"
`continent	Suffix	"N(`continent ,)"
con`tingency	Suffix	"N(con`tingent ,deadj)"
conti`nuity	Suffix	"N(con`tinue ,deverb)"
con`tinuo	Suffix	"N(con`tinuo ,)"
`contour	Suffix	"N(`contour ,)"
`contraband	Suffix	"N(`contraband ,)"
contra`ception	Suffix	"N(contra`ception ,)"
`contract	Suffix	"N(`contract ,ss)"
con`tralto	Suffix	"N(con`tralto ,)"
con`traption	Suffix	"N(con`traption ,)"
con`trariety	Suffix	"N(con`trariety ,)"
`contrast	Suffix	"N(`contrast ,ss)"
contra`vention	Suffix	"N(contra`vention ,)"
con`trition	Suffix	"N(`contrite ,deadj)"
`controversy	Suffix	"N(`controversy ,)"
con`tumacy	Suffix	"N(con`tumacy ,)"
co`nundrum	Suffix	"N(co`nundrum ,)"
`convent	Suffix	"N(`convent ,)"
con`vention	Suffix	"N(con`vene ,deverb)"
con`version	Suffix	"N(con`vert ,deverb)"
`convert	Suffix	"N(`convert ,ss)"
`convict	Suffix	"N(`convict ,ss)"
convo`cation	Suffix	"N(con`voke ,deverb)"
`convoy	Suffix	"N(`convoy ,)"
`cony	Suffix	"N(`cony ,)"
`cookbook	Suffix	"N(`cookbook ,)"
`cookery	Suffix	"N(`cook ,deverb)"
`cookie	Suffix	"N(`cookie ,)"
`cooky	Suffix	"N(`cooky ,)"
`coolie	Suffix	"N(`coolie ,)"
`coop	Suffix	"N(`coop ,)"
co`operative	Suffix	"N(co`operate ,deverb)"
`coot	Suffix	"N(`coot ,)"
`cootie	Suffix	"N(`cootie ,)"
`cop	Suffix	"N(`cop ,)"
`copper	Suffix	"N(`copper ,)"
`copter	Suffix	"N(`copter ,)"
`copybook	Suffix	"N(`copybook ,)"
`copycat	Suffix	"N(`copycat ,)"
`copywriter	Suffix	"N(`copywriter ,)"
co`quet	Suffix	"N(co`quet ,)"
`coquetry	Suffix	"N(co`quet ,)"
co`quette	Suffix	"N(co`quette ,)"
`corbel	Suffix	"N(`corbel ,)"
`cord	Suffix	"N(`cord ,)"
`cordage	Suffix	"N(`cord ,)"
`corduroy	Suffix	"N(`corduroy ,)"
`core	Suffix	"N(`core ,)"
`corkscrew	Suffix	"N(`corkscrew ,)"
`corn	Suffix	"N(`corn ,)"
`cornbread	Suffix	"N(`cornbread ,)"
`cornea	Suffix	"N(`cornea ,)"
`cornerstone	Suffix	"N(`cornerstone ,)"
cor`net	Suffix	"N(cor`net ,)"
`cornfield	Suffix	"N(`cornfield ,)"
`cornmeal	Suffix	"N(`cornmeal ,)"
`cornstarch	Suffix	"N(`cornstarch ,)"
cornu`copia	Suffix	"N(cornu`copia ,)"
`corollary	Suffix	"N(`corollary ,)"
co`rona	Suffix	"N(co`rona ,)"
`coronary	Suffix	"N(`coronary ,)"
coro`nation	Suffix	"N(coro`nation ,)"
`coroner	Suffix	"N(`coroner ,)"
coro`net	Suffix	"N(coro`net ,)"
`corporal	Suffix	"N(`corporal ,)"
corpor`ation	Suffix	"N(corpor`ation ,)"
`corpse	Suffix	"N(`corpse ,)"
`corpulence	Suffix	"N(`corpulent ,deadj)"
`corpulency	Suffix	"N(`corpulent ,deadj)"
`correlate	Suffix	"N(`correlate ,)"
corres`pondent	Suffix	"N(corres`pond ,deverb)"
`corridor	Suffix	"N(`corridor ,)"
corrigi`bility	Suffix	"N(`corrigible ,deadj)"
corrobor`ee	Suffix	"N(corrobor`ee ,)"
cor`rosion	Suffix	"N(cor`rode ,deverb)"
cor`sage	Suffix	"N(cor`sage ,)"
cor`tege	Suffix	"N(cor`tege ,)"
co`rundum	Suffix	"N(co`rundum ,)"
cor`vette	Suffix	"N(cor`vette ,)"
`cosmos	Suffix	"N(`cosmos ,)"
`cot	Suffix	"N(`cot ,)"
`cottage	Suffix	"N(`cottage ,)"
`cotton	Suffix	"N(`cotton ,)"
`couch	Suffix	"N(`couch ,)"
`council	Suffix	"N(`council ,)"
`councilor	Suffix	"N(`council ,)"
`councillor	Suffix	"N(`council ,)"
`countdown	Suffix	"N(`countdown ,)"
`countenance	Suffix	"N(`countenance ,)"
`counter	Suffix	"N(`counter ,)"
`country	Suffix	"N(`country ,)"
`countryside	Suffix	"N(`countryside ,)"
`county	Suffix	"N(`county ,)"
`coup	Suffix	"N(`coup ,)"
`coupe	Suffix	"N(`coupe ,)"
`coupon	Suffix	"N(`coupon ,)"
`courage	Suffix	"N(`courage ,)"
`courier	Suffix	"N(`courier ,)"
`course	Suffix	"N(`course ,)"
`court	Suffix	"N(`court ,)"
`courtesan	Suffix	"N(`courtesan ,)"
`courtesy	Suffix	"N(`courtesy ,)"
`courthouse	Suffix	"N(`courthouse ,)"
`courtier	Suffix	"N(`courtier ,)"
`courtroom	Suffix	"N(`courtroom ,)"
`courtyard	Suffix	"N(`courtyard ,)"
`couscous	Suffix	"N(`couscous ,)"
`cousin	Suffix	"N(`cousin ,)"
cou`turier	Suffix	"N(cou`turier ,)"
`cove	Suffix	"N(`cove ,)"
`coven	Suffix	"N(`coven ,)"
`covenant	Suffix	"N(`covenant ,)"
`coverall	Suffix	"N(`coverall ,)"
`cow	Suffix	"N(`cow ,)"
`coward	Suffix	"N(`coward ,)"
`cowardice	Suffix	"N(`cowardice ,)"
`cowbell	Suffix	"N(`cowbell ,)"
`cowbird	Suffix	"N(`cowbird ,)"
`cowboy	Suffix	"N(`cowboy ,)"
`cowgirl	Suffix	"N(`cowgirl ,)"
`cowhand	Suffix	"N(`cowhand ,)"
`cowherd	Suffix	"N(`cowherd ,)"
`cowhide	Suffix	"N(`cowhide ,)"
`cowl	Suffix	"N(`cowl ,)"
`cowlick	Suffix	"N(`cowlick ,)"
`cowling	Suffix	"N(`cowling ,)"
`cowpoke	Suffix	"N(`cowpoke ,)"
`cowpony	Suffix	"N(`cowpony ,)"
`cowpox	Suffix	"N(`cowpox ,)"
`cowpunch	Suffix	"N(`cowpunch ,)"
`cowry	Suffix	"N(`cowry ,)"
`crab	Suffix	"N(`crab ,)"
`crabmeat	Suffix	"N(`crabmeat ,)"
`crackdown	Suffix	"N(`crackdown ,)"
`crackpot	Suffix	"N(`crackpot ,)"
`craftspeople	Suffix	"N(`craftspeople ,)"
`craftsperson	Suffix	"N(`craftsperson ,)"
`crag	Suffix	"N(`crag ,)"
`crane	Suffix	"N(`crane ,)"
`crankcase	Suffix	"N(`crankcase ,)"
`crankshaft	Suffix	"N(`crankshaft ,)"
`cranny	Suffix	"N(`cranny ,)"
cra`vat	Suffix	"N(cra`vat ,)"
`craw	Suffix	"N(`craw ,)"
`crawlspace	Suffix	"N(`crawlspace ,)"
`crayon	Suffix	"N(`crayon ,)"
`craze	Suffix	"N(`craze ,)"
`creamery	Suffix	"N(`cream ,)"
`creature	Suffix	"N(cre`ate ,deverb)"
`creche	Suffix	"N(`creche ,)"
`credence	Suffix	"N(`credence ,)"
cre`dential	Suffix	"N(cre`dential ,)"
cre`denza	Suffix	"N(cre`denza ,)"
credi`bility	Suffix	"N(`credible ,deadj)"
`credo	Suffix	"N(`credo ,)"
cre`dulity	Suffix	"N(cre`dulity ,)"
`creed	Suffix	"N(`creed ,)"
`creek	Suffix	"N(`creek ,)"
`creekside	Suffix	"N(`creekside ,)"
`creep	Suffix	"N(`creep - bad fellow,)"
`creosote	Suffix	"N(`creosote ,)"
`crepe	Suffix	"N(`crepe ,)"
`crescent	Suffix	"N(`crescent ,)"
`cress	Suffix	"N(`cress ,)"
`cretin	Suffix	"N(`cretin ,)"
`crevice	Suffix	"N(`crevice ,)"
`crew	Suffix	"N(`crew ,)"
`crewcut	Suffix	"N(`crewcut ,)"
`crewel	Suffix	"N(`crewel ,)"
`crib	Suffix	"N(`crib ,)"
`crick	Suffix	"N(`crick ,)"
`crime	Suffix	"N(`crime ,)"
`critic	Suffix	"N(`critic ,)"
`critter	Suffix	"N(`critter ,)"
`crock	Suffix	"N(`crock ,)"
`crockery	Suffix	"N(`crock ,)"
`croft	Suffix	"N(`croft ,)"
`crone	Suffix	"N(`crone ,)"
`crony	Suffix	"N(`crony ,)"
`crook	Suffix	"N(`crook ,)"
`crop	Suffix	"N(`crop - garden,)"
`cropland	Suffix	"N(`cropland ,)"
`crossarm	Suffix	"N(`crossarm ,)"
`crossbar	Suffix	"N(`crossbar ,)"
`crossbow	Suffix	"N(`crossbow ,)"
`crosscut	Suffix	"N(`crosscut ,)"
`crosslink	Suffix	"N(`crosslink ,)"
`crossover	Suffix	"N(`crossover ,)"
`crosspoint	Suffix	"N(`crosspoint ,)"
`crossroad	Suffix	"N(`crossroad ,)"
`crosstalk	Suffix	"N(`crosstalk ,)"
`crosswalk	Suffix	"N(`crosswalk ,)"
`crossway	Suffix	"N(`crossway ,)"
`crossword	Suffix	"N(`crossword ,)"
`crotch	Suffix	"N(`crotch ,)"
`crotchet	Suffix	"N(`crotchet ,)"
`croupier	Suffix	"N(`croupier ,)"
`crow	Suffix	"N(`crow ,)"
`crowbar	Suffix	"N(`crowbar ,)"
`crowfoot	Suffix	"N(`crowfoot ,)"
`crucible	Suffix	"N(`crucible ,)"
`crucifix	Suffix	"N(`crucifix ,)"
cruci`fixion	Suffix	"N(`crucify ,deverb)"
`crud	Suffix	"N(`crud ,)"
`cruet	Suffix	"N(`cruet ,)"
`cruelty	Suffix	"N(`cruel ,deadj)"
`crumb	Suffix	"N(`crumb ,)"
`crupper	Suffix	"N(`crupper ,)"
`crust	Suffix	"N(`crust ,)"
`crutch	Suffix	"N(`crutch ,)"
`crux	Suffix	"N(`crux ,)"
`crypt	Suffix	"N(`crypt ,)"
crypta`nalysis	Suffix	"N(crypta`nalysis ,)"
crypt`analyst	Suffix	"N(crypt`analyst ,)"
`cryptogram	Suffix	"N(`cryptogram ,)"
`crystal	Suffix	"N(`crystal ,)"
`cub	Suffix	"N(`cub ,)"
`cubbyhole	Suffix	"N(`cubbyhole ,)"
`cubit	Suffix	"N(`cubit ,)"
`cubicle	Suffix	"N(`cubicle ,)"
`cuckoo	Suffix	"N(`cuckoo ,)"
`cucumber	Suffix	"N(`cucumber ,)"
`cud	Suffix	"N(`cud ,)"
`cudgel	Suffix	"N(`cudgel ,)"
`cuff	Suffix	"N(`cuff - shirt cuff,)"
`cufflink	Suffix	"N(`cufflink ,)"
cui`sine	Suffix	"N(cui`sine ,)"
culpa`bility	Suffix	"N(`culpable ,deadj)"
`culprit	Suffix	"N(`culprit ,)"
`cult	Suffix	"N(`cult ,)"
`culture	Suffix	"N(`culture ,)"
`culvert	Suffix	"N(`culvert ,)"
`cumin	Suffix	"N(`cumin ,)"
`cumulus	Suffix	"N(`cumulus ,)"
`cup	Suffix	"N(`cup ,)"
`cupboard	Suffix	"N(`cupboard ,)"
`cupful	Suffix	"N(`cup ,)"
cu`pidity	Suffix	"N(`cupid ,)"
`cupola	Suffix	"N(`cupola ,)"
`cur	Suffix	"N(`cur ,)"
`curate	Suffix	"N(`curate ,)"
`curb	Suffix	"N(`curb ,)"
`curbing	Suffix	"N(`curb ,)"
`curbside	Suffix	"N(`curbside ,)"
`curd	Suffix	"N(`curd ,)"
`curfew	Suffix	"N(`curfew ,)"
`curia	Suffix	"N(`curia ,)"
`curio	Suffix	"N(`curio ,)"
curi`osity	Suffix	"N(`curious ,deadj)"
`curlicue	Suffix	"N(`curlicue ,)"
cur`mudgeon	Suffix	"N(cur`mudgeon ,)"
`currency	Suffix	"N(`current ,deadj)"
`currant	Suffix	"N(`currant ,)"
`current	Suffix	"N(`current ,)"
`curry	Suffix	"N(`curry ,)"
`cursor	Suffix	"N(`cursor ,)"
`curvature	Suffix	"N(`curve ,)"
`cusp	Suffix	"N(`cusp ,)"
`custard	Suffix	"N(`custard ,)"
`custody	Suffix	"N(`custody ,)"
`custom	Suffix	"N(`custom ,)"
`customer	Suffix	"N(`customer ,)"
`customhouse	Suffix	"N(`customhouse ,)"
`cut	Suffix	"N(`cut ,)"
`cutback	Suffix	"N(`cutback ,)"
`cutlass	Suffix	"N(`cutlass ,)"
`cutler	Suffix	"N(`cutler ,)"
`cutoff	Suffix	"N(`cutoff ,)"
`cutout	Suffix	"N(`cutout ,)"
`cutover	Suffix	"N(`cutover ,)"
`cutthroat	Suffix	"N(`cutthroat ,)"
`cyclist	Suffix	"N(`cycle - exception to Elision,deverb)"
`cycloid	Suffix	"N(`cycloid ,)"
`cyclone	Suffix	"N(`cyclone ,)"
cyclo`rama	Suffix	"N(cyclo`rama ,)"
`cylinder	Suffix	"N(`cylinder ,)"
`cymbal	Suffix	"N(`cymbal ,)"
`cynic	Suffix	"N(`cynic ,)"
`cyst	Suffix	"N(`cyst ,)"
`czar	Suffix	"N(`czar ,)"
cza`rina	Suffix	"N(cza`rina ,)"
`dachshund	Suffix	"N(`dachshund ,)"
`dad	Suffix	"N(`dad ,)"
`daddy	Suffix	"N(`daddy ,)"
`daffodil	Suffix	"N(`daffodil ,)"
`dagger	Suffix	"N(`dagger ,)"
`dainty	Suffix	"N(`dainty ,)"
`dairy	Suffix	"N(`dairy ,)"
`dais	Suffix	"N(`dais ,)"
`daisy	Suffix	"N(`daisy ,)"
`dale	Suffix	"N(`dale ,)"
`damask	Suffix	"N(`damask ,)"
`dame	Suffix	"N(`dame ,)"
`damsel	Suffix	"N(`damsel ,)"
`dandelion	Suffix	"N(`dandelion ,)"
`dandruff	Suffix	"N(`dandruff ,)"
`danger	Suffix	"N(`danger ,)"
`daredevil	Suffix	"N(`daredevil ,)"
`dash	Suffix	"N(`dash - little bit,)"
`dashboard	Suffix	"N(`dashboard ,)"
`dastard	Suffix	"N(`dastard ,)"
`database	Suffix	"N(`database ,)"
`dateline	Suffix	"N(`dateline ,)"
`daughter	Suffix	"N(`daughter ,)"
`dauphin	Suffix	"N(`dauphin ,)"
dau`phine	Suffix	"N(dau`phine ,)"
`davenport	Suffix	"N(`davenport ,)"
`davit	Suffix	"N(`davit ,)"
`day	Suffix	"N(`day ,)"
`daybed	Suffix	"N(`daybed ,)"
`daybreak	Suffix	"N(`daybreak ,)"
`daylight	Suffix	"N(`daylight ,)"
`daytime	Suffix	"N(`daytime ,)"
`deacon	Suffix	"N(`deacon ,)"
`deadhead	Suffix	"N(`deadhead ,)"
`deadline	Suffix	"N(`deadline ,)"
`deadlock	Suffix	"N(`deadlock ,ajr8)"
`deadwood	Suffix	"N(`deadwood ,)"
`dean	Suffix	"N(`dean ,)"
`dearth	Suffix	"N(`dearth ,)"
`death	Suffix	"N(`death ,)"
`deathbed	Suffix	"N(`deathbed ,)"
de`bacle	Suffix	"N(de`bacle ,)"
de`bauchery	Suffix	"N(de`bauch ,deverb)"
de`benture	Suffix	"N(de`benture ,)"
de`bility	Suffix	"N(de`bility ,)"
`debit	Suffix	"N(`debit ,)"
de`bris	Suffix	"N(de`bris ,)"
`debt	Suffix	"N(`debt ,)"
`debtor	Suffix	"N(`debtor ,)"
de`but	Suffix	"N(de`but - see verb.lex for verb forms,)"
`debutante	Suffix	"N(`debutante ,)"
`decade	Suffix	"N(`decade ,)"
`decadence	Suffix	"N(`decadent ,deadj)"
`decal	Suffix	"N(`decal ,)"
de`cathlon	Suffix	"N(de`cathlon ,)"
de`cedent	Suffix	"N(de`cedent ,)"
de`ceit	Suffix	"N(de`ceit ,)"
`decency	Suffix	"N(`decent ,deadj)"
de`ception	Suffix	"N(de`ceive ,deverb)"
`decile	Suffix	"N(`decile ,)"
de`cision	Suffix	"N(de`cide ,deverb)"
`deck	Suffix	"N(`deck ,)"
decla`mation	Suffix	"N(de`claim ,deverb)"
de`clarator	Suffix	"N(de`clare ,deverb)"
de`clension	Suffix	"N(de`cline ,deverb)"
de`clivity	Suffix	"N(de`clivity ,)"
decolle`tage	Suffix	"N(decolle`tage ,)"
de`cor	Suffix	"N(de`cor ,)"
de`corum	Suffix	"N(de`corum ,)"
`decrease	Suffix	"N(`decrease ,ss)"
`decrement	Suffix	"N(`decrement ,)"
de`crepitude	Suffix	"N(de`crepitude ,)"
`deerskin	Suffix	"N(`deerskin ,)"
`deerstalker	Suffix	"N(`deerstalker ,)"
`defect	Suffix	"N(`defect - blemish,)"
de`fense	Suffix	"N(de`fense ,)"
de`fence	Suffix	"N(de`fence ,)"
defensi`bility	Suffix	"N(de`fend ,deverb+deajr)"
`deference	Suffix	"N(de`fer ,deverb+deajr)"
`deficit	Suffix	"N(`deficit ,)"
de`ficiency	Suffix	"N(de`ficient ,deadj)"
de`foliant	Suffix	"N(de`foliate ,deverb)"
de`formity	Suffix	"N(de`form ,deverb)"
de`generacy	Suffix	"N(de`generate ,deadj)"
de`gree	Suffix	"N(de`gree ,)"
deifi`cation	Suffix	"N(`deify ,deverb)"
`deity	Suffix	"N(`deity ,)"
`delegate	Suffix	"N(`delegate - [-@t],)"
`delicacy	Suffix	"N(`delicate ,deadj)"
delica`tessen	Suffix	"N(delica`tessen ,)"
de`lineament	Suffix	"N(de`lineament ,)"
de`linquency	Suffix	"N(de`linquent ,deadj)"
de`lirium	Suffix	"N(de`lirium ,)"
de`livery	Suffix	"N(de`liver ,deverb)"
`dell	Suffix	"N(`dell ,)"
del`phinium	Suffix	"N(del`phinium ,)"
`delta	Suffix	"N(`delta - river delta,)"
de`lusion	Suffix	"N(de`lude ,deverb)"
`demagogue	Suffix	"N(`demagogue ,)"
dema`goguery	Suffix	"N(`demagogue ,)"
de`meanor	Suffix	"N(de`meanor ,)"
de`meanour	Suffix	"N(de`meanour - British,)"
de`merit	Suffix	"N(de`merit ,)"
`demigod	Suffix	"N(`demigod ,)"
`demijohn	Suffix	"N(`demijohn ,)"
`demo	Suffix	"N(`demo ,)"
de`mocracy	Suffix	"N(`democrat ,)"
`democrat	Suffix	"N(`democrat ,)"
demo`lition	Suffix	"N(de`molish ,deverb)"
`demon	Suffix	"N(`demon ,)"
de`moniac	Suffix	"N(de`moniac ,)"
de`monstrative	Suffix	"N(`demonstrate ,deverb)"
`den	Suffix	"N(`den ,)"
`denizen	Suffix	"N(`denizen ,)"
denoue`ment	Suffix	"N(denoue`ment ,)"
`dentist	Suffix	"N(`dentist ,)"
`dentistry	Suffix	"N(`dentistry ,)"
`denture	Suffix	"N(`denture ,)"
denunci`ation	Suffix	"N(de`nounce ,deverb)"
de`odorant	Suffix	"N(`odor ,)"
de`partment	Suffix	"N(de`partment ,)"
de`parture	Suffix	"N(de`part ,deverb)"
de`pendency	Suffix	"N(de`pend ,deverb+deajr)"
de`pendent	Suffix	"N(de`pend ,deverb)"
de`positary	Suffix	"N(de`posit ,deverb)"
depo`sition	Suffix	"N(depo`sition ,)"
`depot	Suffix	"N(`depot ,)"
de`pravity	Suffix	"N(de`prave ,deverb)"
`depth	Suffix	"N(`deep ,deadj)"
`deputy	Suffix	"N(`deputy ,)"
`derby	Suffix	"N(`derby ,)"
de`rision	Suffix	"N(de`ride ,deverb)"
`derivate	Suffix	"N(`derivate ,)"
`derrick	Suffix	"N(`derrick ,)"
derri`ere	Suffix	"N(derri`ere ,)"
`dervish	Suffix	"N(`dervish ,)"
`descant	Suffix	"N(`descant ,)"
des`cent	Suffix	"N(des`cent ,)"
des`cription	Suffix	"N(des`cribe ,deverb)"
des`criptor	Suffix	"N(des`cribe ,deverb)"
`desert	Suffix	"N(`desert ,)"
`desk	Suffix	"N(`desk ,)"
`desktop	Suffix	"N(`desktop ,)"
de`sorption	Suffix	"N(de`sorb ,deverb)"
desper`ation	Suffix	"N(des`pair ,deverb)"
de`spite	Suffix	"N(de`spite ,)"
des`pondence	Suffix	"N(des`pond ,deverb+deajr)"
des`pondency	Suffix	"N(des`pond ,deverb+deajr)"
`despot	Suffix	"N(`despot ,)"
des`sert	Suffix	"N(des`sert ,)"
`destiny	Suffix	"N(`destiny ,)"
desti`tution	Suffix	"N(`destitute ,deadj)"
de`suetude	Suffix	"N(de`suetude ,)"
`detail	Suffix	"N(`detail ,ss)"
de`tective	Suffix	"N(de`tect ,deverb)"
`detent	Suffix	"N(`detent ,)"
de`tente	Suffix	"N(de`tente ,)"
de`tention	Suffix	"N(de`tain ,deverb)"
de`tergent	Suffix	"N(de`tergent ,)"
de`terminacy	Suffix	"N(de`termine ,deverb)"
de`terminism	Suffix	"N(de`terminism ,)"
de`terminist	Suffix	"N(de`terminist ,)"
detoxifi`cation	Suffix	"N(`toxin ,deverb)"
`detriment	Suffix	"N(`detriment ,)"
`deuce	Suffix	"N(`deuce ,)"
`deviance	Suffix	"N(`deviate ,deverb+deajr)"
`deviancy	Suffix	"N(`deviate ,deverb+deajr)"
de`vice	Suffix	"N(de`vice ,)"
`devil	Suffix	"N(`devil ,)"
devo`lution	Suffix	"N(de`volve ,deverb)"
`dew	Suffix	"N(`dew ,)"
`dewar	Suffix	"N(`dewar ,)"
`dewdrop	Suffix	"N(`dewdrop ,)"
`dharma	Suffix	"N(`dharma ,)"
dia`betes	Suffix	"N(dia`betes ,)"
dia`critic	Suffix	"N(dia`critic ,)"
`diadem	Suffix	"N(`diadem ,)"
`dialect	Suffix	"N(`dialect ,)"
di`alysis	Suffix	"N(di`alysis ,)"
di`ameter	Suffix	"N(di`ameter ,)"
`diamond	Suffix	"N(`diamond ,)"
`diaphragm	Suffix	"N(`diaphragm ,)"
diar`rhea	Suffix	"N(diar`rhea ,)"
diar`rhoea	Suffix	"N(diar`rhoea ,)"
`diary	Suffix	"N(`diary ,)"
`diatribe	Suffix	"N(`diatribe ,)"
`dick	Suffix	"N(`dick ,)"
`dickens	Suffix	"N(`dickens ,)"
`dickey	Suffix	"N(`dickey ,)"
`dictate	Suffix	"N(`dictate ,ss)"
`diction	Suffix	"N(`diction ,)"
`dictionary	Suffix	"N(`dictionary ,)"
`diehard	Suffix	"N(`diehard ,)"
`diem	Suffix	"N(`diem ,)"
`diesel	Suffix	"N(`diesel ,)"
die`tician	Suffix	"N(dia`tetics ,)"
die`titian	Suffix	"N(dia`tetics ,)"
differ`ential	Suffix	"N(differ`ential ,)"
`difficulty	Suffix	"N(`difficult ,deadj)"
`diffidence	Suffix	"N(`diffident ,deadj)"
`digest	Suffix	"N(`digest ,ss)"
`digit	Suffix	"N(`digit ,)"
`dignitary	Suffix	"N(`dignitary ,)"
`dignity	Suffix	"N(`dignity ,)"
`digram	Suffix	"N(`digram ,)"
di`lemma	Suffix	"N(di`lemma ,)"
`dilettante	Suffix	"N(`dilettante ,)"
`diligence	Suffix	"N(`diligent ,deadj)"
`dill	Suffix	"N(`dill ,)"
`dime	Suffix	"N(`dime ,)"
di`mension	Suffix	"N(di`mension ,)"
dimi`nution	Suffix	"N(di`minish ,deverb)"
`din	Suffix	"N(`din ,)"
`dinghy	Suffix	"N(`dinghy ,)"
`dinner	Suffix	"N(`dinner ,)"
`dinnertime	Suffix	"N(`dinnertime ,)"
`dinnerware	Suffix	"N(`dinnerware ,)"
`dinosaur	Suffix	"N(`dinosaur ,)"
`dint	Suffix	"N(`dint ,)"
`diocese	Suffix	"N(`diocese ,)"
dio`rama	Suffix	"N(dio`rama ,)"
diph`theria	Suffix	"N(diph`theria ,)"
`diphthong	Suffix	"N(`diphthong ,)"
di`ploma	Suffix	"N(di`ploma ,)"
di`plomacy	Suffix	"N(`diplomat ,)"
`diplomat	Suffix	"N(`diplomat ,)"
di`rectorate	Suffix	"N(di`rectorate ,)"
di`rectory	Suffix	"N(di`rectory ,)"
`dirge	Suffix	"N(`dirge ,)"
`dirt	Suffix	"N(`dirt ,)"
disad`vantage	Suffix	"N(ad`vantage ,)"
dis`armament	Suffix	"N(`arm ,deverb)"
dis`aster	Suffix	"N(dis`aster ,)"
`disc	Suffix	"N(`disc ,)"
`discard	Suffix	"N(`discard ,ss)"
`disco	Suffix	"N(`disco ,)"
disconti`nuity	Suffix	"N(conti`nuity ,)"
dis`courtesy	Suffix	"N(`courtesy ,)"
dis`covery	Suffix	"N(dis`cover ,deverb)"
dis`crepancy	Suffix	"N(dis`crepant ,deadj)"
dis`cretion	Suffix	"N(dis`creet ,deadj)"
dis`criminant	Suffix	"N(dis`criminate ,deverb)"
`discus	Suffix	"N(`discus ,)"
dis`harmony	Suffix	"N(`harmony ,)"
`dishful	Suffix	"N(`dish ,)"
`dishwasher	Suffix	"N(`dishwasher ,)"
`dishwater	Suffix	"N(`dishwater ,)"
`disk	Suffix	"N(`disk ,)"
dis`pensary	Suffix	"N(dis`pense ,deverb)"
dis`quietude	Suffix	"N(dis`quietude ,)"
disqui`sition	Suffix	"N(disqui`sition ,)"
disre`pair	Suffix	"N(re`pair ,deverb)"
dis`sension	Suffix	"N(dis`sent ,deverb)"
`dissident	Suffix	"N(dis`sent ,deverb)"
`dissonance	Suffix	"N(`dissonant ,deadj)"
`distillate	Suffix	"N(dis`till ,deverb)"
dis`tillery	Suffix	"N(dis`till ,deverb)"
dis`tinction	Suffix	"N(dis`tinct ,deadj)"
`district	Suffix	"N(`district ,)"
`ditty	Suffix	"N(`ditty ,)"
`diva	Suffix	"N(`diva ,)"
`divan	Suffix	"N(`divan ,)"
di`version	Suffix	"N(di`vert ,deverb)"
di`vestiture	Suffix	"N(di`vest ,deverb)"
`dividend	Suffix	"N(`dividend ,)"
divisi`bility	Suffix	"N(di`vide ,deverb+deajr)"
di`vision	Suffix	"N(di`vide ,deverb)"
di`visor	Suffix	"N(di`vide ,deverb)"
`docket	Suffix	"N(`docket ,)"
`dockside	Suffix	"N(`dockside ,)"
`dockyard	Suffix	"N(`dockyard ,)"
`doctorate	Suffix	"N(`doctor ,)"
`doctrine	Suffix	"N(`doctrine ,)"
docu`mentary	Suffix	"N(`document ,)"
`doer	Suffix	"N(`do ,deverb)"
`doe	Suffix	"N(`doe ,)"
`doghouse	Suffix	"N(`doghouse ,)"
`dogleg	Suffix	"N(`dogleg ,)"
`dogma	Suffix	"N(`dogma ,)"
`dogmatism	Suffix	"N(`dogma ,)"
`dogtrot	Suffix	"N(`dogtrot ,)"
`doll	Suffix	"N(`doll ,)"
`dollar	Suffix	"N(`dollar ,)"
`dollop	Suffix	"N(`dollop ,)"
`dolly	Suffix	"N(`dolly ,)"
`dolt	Suffix	"N(`dolt ,)"
do`main	Suffix	"N(do`main ,)"
`dome	Suffix	"N(`dome ,ajr8)"
`domicile	Suffix	"N(`domicile ,)"
`dominance	Suffix	"N(`dominate ,deverb+deajr)"
do`minion	Suffix	"N(do`minion ,)"
`domino	Suffix	"N(`domino ,)"
`donkey	Suffix	"N(`donkey ,)"
`donnybrook	Suffix	"N(`donnybrook ,)"
`donor	Suffix	"N(`donor ,)"
`doodle	Suffix	"N(`doodle ,)"
`doomsday	Suffix	"N(`doomsday ,)"
`door	Suffix	"N(`door ,)"
`doorbell	Suffix	"N(`doorbell ,)"
`doorknob	Suffix	"N(`doorknob ,)"
`doorstep	Suffix	"N(`doorstep ,)"
`doorway	Suffix	"N(`doorway ,)"
`dormancy	Suffix	"N(`dormant ,deadj)"
`dormitory	Suffix	"N(`dormitory ,)"
`dossier	Suffix	"N(`dossier ,)"
`double	Suffix	"N(`double ,)"
double`header	Suffix	"N(double`header ,)"
`doublet	Suffix	"N(`doublet ,)"
`doubleton	Suffix	"N(`doubleton ,)"
doub`loon	Suffix	"N(doub`loon ,)"
`dough	Suffix	"N(`dough ,)"
`doughnut	Suffix	"N(`doughnut ,)"
`dove	Suffix	"N(`dove - bird,)"
`dowager	Suffix	"N(`dowager ,)"
`dowel	Suffix	"N(`dowel ,)"
`down	Suffix	"N(`down ,)"
`downdraft	Suffix	"N(`downdraft ,)"
`downfall	Suffix	"N(`downfall ,)"
`downpour	Suffix	"N(`downpour ,)"
`downside	Suffix	"N(`downside ,)"
`downslope	Suffix	"N(`downslope ,)"
`downspout	Suffix	"N(`downspout ,)"
`downstate	Suffix	"N(`downstate ,)"
`downtown	Suffix	"N(`downtown ,)"
`downtrend	Suffix	"N(`downtrend ,)"
`downturn	Suffix	"N(`downturn ,)"
`dowry	Suffix	"N(`dowry ,)"
dox`ology	Suffix	"N(dox`ology ,)"
`doxy	Suffix	"N(`doxy ,)"
`doyen	Suffix	"N(`doyen ,)"
`draft	Suffix	"N(`draft - breeze,)"
`draftsperson	Suffix	"N(`draftsperson ,)"
`dragnet	Suffix	"N(`dragnet ,)"
`dragon	Suffix	"N(`dragon ,)"
`drake	Suffix	"N(`drake ,)"
`dram	Suffix	"N(`dram ,)"
`drama	Suffix	"N(`drama ,)"
`dramatist	Suffix	"N(`drama ,)"
`dramaturgy	Suffix	"N(`dramaturgy ,)"
`drapery	Suffix	"N(`drape ,)"
`draught	Suffix	"N(`draught - British var. of draft,)"
`drawback	Suffix	"N(`drawback ,)"
`drawbridge	Suffix	"N(`drawbridge ,)"
`dreadnought	Suffix	"N(`dreadnought ,)"
`dreamboat	Suffix	"N(`dreamboat ,)"
`dreg	Suffix	"N(`dreg ,)"
`drib	Suffix	"N(`drib ,)"
`drink	Suffix	"N(`drink ,)"
`drive	Suffix	"N(`drive ,)"
`driveway	Suffix	"N(`driveway ,)"
`dromedary	Suffix	"N(`dromedary ,)"
`drone	Suffix	"N(`drone ,)"
`dropout	Suffix	"N(`dropout ,)"
`dropsy	Suffix	"N(`dropsy ,)"
`dross	Suffix	"N(`dross ,)"
`drought	Suffix	"N(`drought ,)"
`drove	Suffix	"N(`drove ,)"
`drudge	Suffix	"N(`drudge ,)"
`drudgery	Suffix	"N(`drudge ,)"
`drugstore	Suffix	"N(`drugstore ,)"
`druid	Suffix	"N(`druid ,)"
`drumhead	Suffix	"N(`drumhead ,)"
`drumlin	Suffix	"N(`drumlin ,)"
`drumstick	Suffix	"N(`drumstick ,)"
`drunkard	Suffix	"N(`drunkard ,)"
`dryad	Suffix	"N(`dryad ,)"
`ducat	Suffix	"N(`ducat ,)"
`duchess	Suffix	"N(`duke ,)"
`duck	Suffix	"N(`duck - bird,)"
`duct	Suffix	"N(`duct ,)"
`ducting	Suffix	"N(`duct ,)"
`ductwork	Suffix	"N(`ductwork ,)"
`dud	Suffix	"N(`dud ,)"
du`et	Suffix	"N(du`et ,)"
`duff	Suffix	"N(`duff ,)"
`duffel	Suffix	"N(`duffel ,)"
`dugout	Suffix	"N(`dugout ,)"
`duke	Suffix	"N(`duke ,)"
`dulse	Suffix	"N(`dulse ,)"
`dumbbell	Suffix	"N(`dumbbell ,)"
`dunce	Suffix	"N(`dunce ,)"
`dune	Suffix	"N(`dune ,)"
`dung	Suffix	"N(`dung ,)"
`dungeon	Suffix	"N(`dungeon ,)"
du`plicity	Suffix	"N(du`plicity ,)"
dura`bility	Suffix	"N(`durable ,deadj)"
du`ration	Suffix	"N(du`ration ,)"
du`ress	Suffix	"N(du`ress ,)"
`dusk	Suffix	"N(`dusk ,)"
`dustbin	Suffix	"N(`dustbin ,)"
`duty	Suffix	"N(`duty ,)"
`dyad	Suffix	"N(`dyad ,)"
`dynamism	Suffix	"N(`dynamism ,)"
`dynamo	Suffix	"N(`dynamo ,)"
`dynast	Suffix	"N(`dynast ,)"
`dynasty	Suffix	"N(`dynasty ,)"
`dyne	Suffix	"N(`dyne ,)"
`dysentery	Suffix	"N(`dysentery ,)"
dys`function	Suffix	"N(dys`function ,)"
`eagle	Suffix	"N(`eagle ,)"
`eaglet	Suffix	"N(`eagle ,)"
`ear	Suffix	"N(`ear ,)"
`eardrum	Suffix	"N(`eardrum ,)"
`earful	Suffix	"N(`ear ,)"
`earl	Suffix	"N(`earl ,)"
`earlobe	Suffix	"N(`earlobe ,)"
`earphone	Suffix	"N(`earphone ,)"
`earring	Suffix	"N(`earring ,)"
`earth	Suffix	"N(`earth ,)"
`earthenware	Suffix	"N(`earthenware ,)"
`earthquake	Suffix	"N(`earthquake ,)"
`easel	Suffix	"N(`easel ,)"
`easterner	Suffix	"N(`easterner ,)"
`eave	Suffix	"N(`eave ,)"
`ebony	Suffix	"N(`ebony ,)"
e`bullience	Suffix	"N(e`bullient ,deadj)"
ec`centric	Suffix	"N(ec`centric ,)"
`echelon	Suffix	"N(`echelon ,)"
e`clat	Suffix	"N(e`clat ,)"
`ecosystem	Suffix	"N(`ecosystem ,)"
`ecstasy	Suffix	"N(`ecstasy ,)"
ecu`menicist	Suffix	"N(ecu`menicist ,)"
`eczema	Suffix	"N(`eczema ,)"
`edict	Suffix	"N(`edict ,)"
edifi`cation	Suffix	"N(`edify ,deverb)"
`edifice	Suffix	"N(`edifice ,)"
edi`torial	Suffix	"N(edi`torial ,)"
ef`feminacy	Suffix	"N(ef`feminate ,deadj)"
effer`vescence	Suffix	"N(effer`vesce ,deverb+deajr)"
`efficacy	Suffix	"N(`efficacy ,)"
ef`ficiency	Suffix	"N(ef`ficient ,deadj)"
`effigy	Suffix	"N(`effigy ,)"
`efflux	Suffix	"N(`efflux ,)"
`effort	Suffix	"N(`effort ,)"
ef`fulgence	Suffix	"N(ef`fulgent ,deadj)"
`egg	Suffix	"N(`egg ,)"
`egghead	Suffix	"N(`egghead ,)"
`eggplant	Suffix	"N(`eggplant ,)"
`eggshell	Suffix	"N(`eggshell ,)"
`ego	Suffix	"N(`ego ,)"
`egotism	Suffix	"N(`egotism ,)"
`egotist	Suffix	"N(`egotist ,)"
`egress	Suffix	"N(`egress ,ss)"
e`lan	Suffix	"N(e`lan ,)"
e`lastic	Suffix	"N(e`lastic ,)"
e`lectorate	Suffix	"N(e`lect ,deverb)"
e`lectress	Suffix	"N(e`lect ,deverb)"
e`lectret	Suffix	"N(e`lectret ,)"
electrifi`cation	Suffix	"N(e`lectric ,deadj)"
`elegance	Suffix	"N(`elegant ,deadj)"
`elegy	Suffix	"N(`elegy ,)"
`element	Suffix	"N(`element ,)"
`elephant	Suffix	"N(`elephant ,)"
eligi`bility	Suffix	"N(`eligible ,deadj)"
e`lision	Suffix	"N(e`lide ,deverb)"
`ell	Suffix	"N(`ell ,)"
el`lipse	Suffix	"N(el`lipse ,)"
el`lipsoid	Suffix	"N(el`lipsoid ,)"
`elm	Suffix	"N(`elm ,)"
`eloquence	Suffix	"N(`eloquent ,deadj)"
`embassy	Suffix	"N(`embassy ,)"
`ember	Suffix	"N(`ember ,)"
`emblem	Suffix	"N(`emblem ,)"
em`bodiment	Suffix	"N(`body ,deverb)"
`embouchure	Suffix	"N(`embouchure ,)"
em`broidery	Suffix	"N(em`broider ,deverb)"
`embryo	Suffix	"N(`embryo ,)"
`emerald	Suffix	"N(`emerald ,)"
e`mergency	Suffix	"N(e`mergency ,)"
`emigrant	Suffix	"N(`emigrant ,)"
`eminence	Suffix	"N(`eminent ,deadj)"
e`mir	Suffix	"N(e`mir ,)"
`emirate	Suffix	"N(e`mir ,)"
`emissary	Suffix	"N(`emissary ,)"
e`mission	Suffix	"N(e`mit ,deverb)"
`emmy	Suffix	"N(`emmy ,)"
e`molument	Suffix	"N(e`molument ,)"
e`motion	Suffix	"N(e`motion ,)"
`emperor	Suffix	"N(`emperor ,)"
emphy`sema	Suffix	"N(emphy`sema ,)"
`empire	Suffix	"N(`empire ,)"
em`porium	Suffix	"N(em`porium ,)"
`empress	Suffix	"N(`emperor ,)"
emulsifi`cation	Suffix	"N(e`mulsify ,deverb)"
e`mulsion	Suffix	"N(e`mulsion ,)"
en`chantress	Suffix	"N(en`chant ,deverb)"
`enclave	Suffix	"N(`enclave ,)"
en`closure	Suffix	"N(en`close ,deverb)"
`encore	Suffix	"N(`encore ,)"
en`cumbrance	Suffix	"N(en`cumber ,deverb)"
encyclo`pedia	Suffix	"N(encyclo`pedia ,)"
`endgame	Suffix	"N(`endgame ,)"
`endpoint	Suffix	"N(`endpoint ,)"
`enema	Suffix	"N(`enema ,)"
`enemy	Suffix	"N(`enemy ,)"
`energy	Suffix	"N(`energy ,)"
en`fant	Suffix	"N(en`fant ,)"
`engine	Suffix	"N(`engine ,)"
e`nigma	Suffix	"N(e`nigma ,)"
en`joinder	Suffix	"N(en`joinder ,)"
`enmity	Suffix	"N(`enmity ,)"
en`nui	Suffix	"N(en`nui ,)"
e`normity	Suffix	"N(e`normity - cf. enormous,)"
`enquiry	Suffix	"N(`enquiry - cf. enquire,)"
en`semble	Suffix	"N(en`semble ,)"
`ensign	Suffix	"N(`ensign ,)"
en`tendre	Suffix	"N(en`tendre ,)"
`enterprise	Suffix	"N(`enterprise ,)"
en`thusiasm	Suffix	"N(en`thusiasm ,)"
en`thusiast	Suffix	"N(en`thusiast ,)"
en`tirety	Suffix	"N(en`tire ,deadj)"
`entity	Suffix	"N(`entity ,)"
`entourage	Suffix	"N(`entourage ,)"
`entranceway	Suffix	"N(`entranceway ,)"
`entrant	Suffix	"N(`enter ,deverb)"
en`treaty	Suffix	"N(en`treaty ,)"
entrepre`neur	Suffix	"N(entrepre`neur ,)"
`entry	Suffix	"N(`enter ,deverb)"
`envelope	Suffix	"N(`envelope ,)"
en`viron	Suffix	"N(en`viron ,)"
en`vironment	Suffix	"N(en`vironment ,)"
`envoy	Suffix	"N(`envoy ,)"
`enzyme	Suffix	"N(`enzyme ,)"
epau`let	Suffix	"N(epau`let ,)"
`epic	Suffix	"N(`epic ,)"
`epicenter	Suffix	"N(`center ,)"
`epicure	Suffix	"N(`epicure ,)"
`epicycle	Suffix	"N(`cycle ,)"
epi`demic	Suffix	"N(epi`demic ,)"
`epigram	Suffix	"N(`epigram ,)"
`epigraph	Suffix	"N(`epigraph ,)"
epi`leptic	Suffix	"N(epi`leptic ,)"
`epilog	Suffix	"N(`epilog ,)"
`epilogue	Suffix	"N(`epilogue ,)"
e`piphany	Suffix	"N(e`piphany ,)"
e`piscopal	Suffix	"N(e`piscopal ,)"
e`piscopate	Suffix	"N(e`piscopate ,)"
`episode	Suffix	"N(`episode ,)"
e`pistle	Suffix	"N(e`pistle ,)"
`epitaph	Suffix	"N(`epitaph ,)"
`epithet	Suffix	"N(`epithet ,)"
e`pitome	Suffix	"N(e`pitome ,)"
`epoch	Suffix	"N(`epoch ,)"
`epochs	Suffix	"N(`epoch ,pl irreg)"
`eponym	Suffix	"N(`eponym ,)"
e`ponymy	Suffix	"N(e`ponymy ,)"
e`poxy	Suffix	"N(e`poxy ,)"
equa`nimity	Suffix	"N(equa`nimity ,)"
e`quator	Suffix	"N(e`quator ,)"
`equinox	Suffix	"N(`equinox ,)"
equi`tation	Suffix	"N(equi`tation ,)"
`equity	Suffix	"N(`equity ,)"
e`quivalence	Suffix	"N(`e`quivalent ,deadj)"
e`quivalency	Suffix	"N(`e`quivalent ,deadj)"
`era	Suffix	"N(`era ,)"
e`rasure	Suffix	"N(e`rase ,deverb)"
`ermine	Suffix	"N(`ermine ,)"
e`rosion	Suffix	"N(e`rode ,deverb)"
`errancy	Suffix	"N(`errant ,deadj)"
`errand	Suffix	"N(`errand ,)"
`errantry	Suffix	"N(`errantry ,)"
`error	Suffix	"N(`error ,)"
eru`dition	Suffix	"N(`erudite ,deadj)"
`escapade	Suffix	"N(`escapade ,)"
`escort	Suffix	"N(`escort ,ss)"
`escritoire	Suffix	"N(`escritoire ,)"
`escrow	Suffix	"N(`escrow ,)"
es`cutcheon	Suffix	"N(es`cutcheon ,)"
`espionage	Suffix	"N(`espionage ,)"
`esplanade	Suffix	"N(`esplanade ,)"
es`prit	Suffix	"N(es`prit ,)"
`esquire	Suffix	"N(`esquire ,)"
`essay	Suffix	"N(`essay ,)"
`essence	Suffix	"N(`essence ,)"
es`tate	Suffix	"N(es`tate ,)"
es`toppal	Suffix	"N(es`toppal ,)"
`estuary	Suffix	"N(`estuary ,)"
e`ternity	Suffix	"N(e`ternity - cf. eternal,)"
`ethic	Suffix	"N(`ethic ,)"
`ethos	Suffix	"N(`ethos ,)"
`etiquette	Suffix	"N(`etiquette ,)"
`etude	Suffix	"N(`etude ,)"
evita`bility	Suffix	"N(`evitable ,deadj)"
`eucharist	Suffix	"N(`eucharist ,)"
`eulogy	Suffix	"N(`eulogy ,)"
`eunuch	Suffix	"N(`eunuch ,)"
`euphemism	Suffix	"N(`euphemism ,)"
eu`phoria	Suffix	"N(eu`phoria ,)"
eutha`nasia	Suffix	"N(eutha`nasia ,)"
evacu`ee	Suffix	"N(e`vacuate ,deverb)"
evan`escence	Suffix	"N(evan`esce ,deverb+deajr)"
e`vangel	Suffix	"N(e`vangel ,)"
evan`gelical	Suffix	"N(e`vangel ,)"
e`vasion	Suffix	"N(e`vade ,deverb)"
`eve	Suffix	"N(`eve ,)"
`evening	Suffix	"N(`evening ,)"
`evensong	Suffix	"N(`evensong ,)"
e`vent	Suffix	"N(e`vent ,)"
`eventide	Suffix	"N(`eventide ,)"
`everyman	Suffix	"N(`everyman ,)"
`evidence	Suffix	"N(`evidence ,)"
`evildoer	Suffix	"N(`evildoer ,)"
e`vocation	Suffix	"N(e`voke ,deverb)"
evo`lution	Suffix	"N(e`volve ,deverb)"
`ewe	Suffix	"N(`ewe ,)"
`ewer	Suffix	"N(`ewer ,)"
`ex	Suffix	"N(`ex ,)"
ex`actitude	Suffix	"N(ex`actitude ,)"
ex`am	Suffix	"N(ex`am - examination,)"
`excellency	Suffix	"N(`excellent ,deadj)"
ex`celsior	Suffix	"N(ex`celsior ,)"
`excess	Suffix	"N(`excess ,)"
ex`chequer	Suffix	"N(ex`chequer ,)"
excla`mation	Suffix	"N(ex`claim ,deverb)"
ex`clusion	Suffix	"N(ex`clude ,deverb)"
ex`cursion	Suffix	"N(ex`cursion ,)"
ex`cursus	Suffix	"N(ex`cursus ,)"
execu`tioner	Suffix	"N(`execute ,deverb)"
ex`ecutive	Suffix	"N(ex`ecutive ,)"
ex`ecutor	Suffix	"N(ex`ecutor ,)"
ex`ecutrix	Suffix	"N(ex`ecutrix ,)"
exe`gesis	Suffix	"N(exe`gesis ,)"
`exegete	Suffix	"N(`exegete ,)"
ex`emplar	Suffix	"N(ex`emplar ,)"
exemplifi`cation	Suffix	"N(ex`ample ,)"
ex`emption	Suffix	"N(ex`empt ,deadj)"
ex`igency	Suffix	"N(`exigent ,deadj)"
`exodus	Suffix	"N(`exodus ,)"
`exorcism	Suffix	"N(`exorcism ,)"
`exorcist	Suffix	"N(`exorcise ,deverb)"
ex`panse	Suffix	"N(ex`panse ,)"
ex`pansion	Suffix	"N(ex`pand ,deverb)"
ex`pectancy	Suffix	"N(ex`pect ,deverb+deajr)"
ex`pectorant	Suffix	"N(ex`pectorant ,)"
ex`pediency	Suffix	"N(ex`pedient ,deadj)"
expe`dition	Suffix	"N(expe`dition ,)"
ex`penditure	Suffix	"N(ex`pend ,deverb)"
ex`pense	Suffix	"N(ex`pense ,)"
`expert	Suffix	"N(`expert ,)"
exper`tise	Suffix	"N(exper`tise ,)"
expla`nation	Suffix	"N(ex`plain ,deverb)"
`expletive	Suffix	"N(`expletive ,)"
`exploit	Suffix	"N(`exploit ,ss)"
ex`plosion	Suffix	"N(ex`plode ,deverb)"
`expo	Suffix	"N(`expo - exposition,)"
`exponent	Suffix	"N(`exponent ,)"
`export	Suffix	"N(`export ,ss)"
ex`posure	Suffix	"N(ex`pose ,deverb)"
ex`pressway	Suffix	"N(ex`pressway ,)"
ex`pulsion	Suffix	"N(ex`pell ,deverb)"
extensi`bility	Suffix	"N(ex`tend ,deverb+deajr)"
ex`tension	Suffix	"N(ex`tend ,deverb)"
ex`tensor	Suffix	"N(ex`tensor ,)"
ex`tent	Suffix	"N(ex`tent ,)"
ex`terior	Suffix	"N(ex`terior ,)"
ex`tinction	Suffix	"N(ex`tinct ,deadj)"
ex`tortioner	Suffix	"N(ex`tort ,deverb)"
`extract	Suffix	"N(`extract ,ss)"
ex`travagance	Suffix	"N(ex`travagant ,deadj)"
extrava`ganza	Suffix	"N(extrava`ganza ,)"
extro`version	Suffix	"N(`extrovert ,)"
`extrovert	Suffix	"N(`extrovert ,ajr8)"
ex`trusion	Suffix	"N(ex`trude ,deverb)"
ex`uberance	Suffix	"N(ex`uberant ,deadj)"
`eyeball	Suffix	"N(`eyeball ,)"
`eyebrow	Suffix	"N(`eyebrow ,)"
`eyeful	Suffix	"N(`eye ,)"
`eyeglass	Suffix	"N(`eyeglass ,)"
`eyelash	Suffix	"N(`eyelash ,)"
`eyelid	Suffix	"N(`eyelid ,)"
`eyepiece	Suffix	"N(`eyepiece ,)"
`eyesight	Suffix	"N(`eyesight ,)"
`eyesore	Suffix	"N(`eyesore ,)"
eye`witness	Suffix	"N(eye`witness ,)"
`eyrie	Suffix	"N(`eyrie ,)"
`fable	Suffix	"N(`fable ,ajr8)"
`fabric	Suffix	"N(`fabric ,)"
fa`cade	Suffix	"N(fa`cade ,)"
`faceplate	Suffix	"N(`faceplate ,)"
`facet	Suffix	"N(`facet ,ajr8)"
fac`simile	Suffix	"N(fac`simile ,)"
`fact	Suffix	"N(`fact ,)"
`faction	Suffix	"N(`faction ,)"
`factory	Suffix	"N(`factory ,)"
`fad	Suffix	"N(`fad ,)"
`fadeout	Suffix	"N(`fadeout ,)"
`faery	Suffix	"N(`faery ,)"
`fag	Suffix	"N(`fag ,)"
fa`jita	Suffix	"N(fa`jita ,)"
`failure	Suffix	"N(`fail ,deverb)"
`fair	Suffix	"N(`fair ,)"
`fairgoer	Suffix	"N(`fairgoer ,)"
`fairway	Suffix	"N(`fairway ,)"
`fairy	Suffix	"N(`fairy ,)"
`faith	Suffix	"N(`faith ,)"
`falcon	Suffix	"N(`falcon ,)"
`falconry	Suffix	"N(`falcon ,)"
`fall	Suffix	"N(`fall - autumn,)"
`fall	Suffix	"N(`fall ,)"
`fallacy	Suffix	"N(`fallacy ,)"
`falloff	Suffix	"N(`falloff ,)"
`fallout	Suffix	"N(`fallout ,)"
`falsehood	Suffix	"N(`false ,deadj)"
`fame	Suffix	"N(`fame ,ajr8)"
`family	Suffix	"N(`family ,)"
`famine	Suffix	"N(`famine ,)"
fa`natic	Suffix	"N(fa`natic ,)"
`fanfare	Suffix	"N(`fanfare ,)"
`fang	Suffix	"N(`fang ,ajr8)"
`fanout	Suffix	"N(`fanout ,)"
fan`tasia	Suffix	"N(`fantasy ,)"
`fantasist	Suffix	"N(`fantasy ,)"
`fantasy	Suffix	"N(`fantasy ,)"
`farad	Suffix	"N(`farad ,)"
`farce	Suffix	"N(`farce ,)"
`fare	Suffix	"N(`fare ,)"
fare`well	Suffix	"N(fare`well ,)"
`farmhouse	Suffix	"N(`farmhouse ,)"
`farmland	Suffix	"N(`farmland ,)"
`farmyard	Suffix	"N(`farmyard ,)"
`faro	Suffix	"N(`faro ,)"
`farthing	Suffix	"N(`farthing ,)"
`fascicle	Suffix	"N(`fascicle ,)"
`fascism	Suffix	"N(`fascism ,)"
`fascist	Suffix	"N(`fascist ,)"
`fate	Suffix	"N(`fate ,ajr8)"
`fathom	Suffix	"N(`fathom ,)"
`faucet	Suffix	"N(`faucet ,)"
`faun	Suffix	"N(`faun ,)"
`fawn	Suffix	"N(`fawn ,)"
`fealty	Suffix	"N(`fealty ,)"
feasi`bility	Suffix	"N(`feasible ,deadj)"
`feat	Suffix	"N(`feat ,)"
`featherbrain	Suffix	"N(`featherbrain ,)"
`featherweight	Suffix	"N(`featherweight ,)"
`fee	Suffix	"N(`fee ,)"
`feedback	Suffix	"N(`feedback ,)"
fe`licity	Suffix	"N(fe`licity ,)"
`fellow	Suffix	"N(`fellow ,)"
`felon	Suffix	"N(`felon ,)"
`felony	Suffix	"N(`felony ,)"
`feminism	Suffix	"N(`feminine ,deadj)"
`feminist	Suffix	"N(`feminine ,deadj)"
`femur	Suffix	"N(`femur ,)"
`fencepost	Suffix	"N(`fencepost ,)"
`fencing	Suffix	"N(`fence ,)"
`ferment	Suffix	"N(`ferment ,ss)"
`fern	Suffix	"N(`fern ,)"
`fernery	Suffix	"N(`fern ,)"
fe`rocity	Suffix	"N(fe`rocity ,)"
`ferris	Suffix	"N(`ferris ,)"
`ferrule	Suffix	"N(`ferrule ,)"
`ferule	Suffix	"N(`ferule ,)"
`fervency	Suffix	"N(`fervent ,deadj)"
`fervor	Suffix	"N(`fervor ,)"
`fervour	Suffix	"N(`fervour - British,)"
`fest	Suffix	"N(`fest ,)"
`festival	Suffix	"N(`festival ,)"
`fete	Suffix	"N(`fete ,)"
`fetish	Suffix	"N(`fetish ,)"
`fettle	Suffix	"N(`fettle ,)"
`fetus	Suffix	"N(`fetus ,)"
fi`ance	Suffix	"N(fi`ance ,)"
fi`ancee	Suffix	"N(fi`ancee ,)"
`fiat	Suffix	"N(`fiat ,)"
`fiber	Suffix	"N(`fiber ,)"
`fiberboard	Suffix	"N(`fiberboard ,)"
`fibre	Suffix	"N(`fibre ,)"
`fiche	Suffix	"N(`fiche ,)"
`fiction	Suffix	"N(`fiction ,)"
`fiddlestick	Suffix	"N(`fiddlestick ,)"
`fide	Suffix	"N(`fide ,)"
fi`delity	Suffix	"N(fi`delity ,)"
fi`duciary	Suffix	"N(fi`duciary ,)"
`fief	Suffix	"N(`fief ,)"
`fieldstone	Suffix	"N(`fieldstone ,)"
`fieldwork	Suffix	"N(`fieldwork ,)"
`fiend	Suffix	"N(`fiend ,)"
fi`esta	Suffix	"N(fi`esta ,)"
`fife	Suffix	"N(`fife ,)"
`fig	Suffix	"N(`fig ,)"
`fight	Suffix	"N(`fight ,)"
figu`rine	Suffix	"N(figu`rine ,)"
`filament	Suffix	"N(`filament ,)"
`filbert	Suffix	"N(`filbert ,)"
`filename	Suffix	"N(`filename ,)"
fi`let	Suffix	"N(fi`let ,)"
`filigree	Suffix	"N(`filigree ,)"
`filly	Suffix	"N(`filly ,)"
`filmstrip	Suffix	"N(`filmstrip ,)"
`filth	Suffix	"N(`filth ,)"
`fin	Suffix	"N(`fin ,)"
fi`nale	Suffix	"N(fi`nale ,)"
finan`cier	Suffix	"N(`finance ,)"
`finch	Suffix	"N(`finch ,)"
`find	Suffix	"N(`find ,)"
`fingering	Suffix	"N(`finger ,)"
`fingernail	Suffix	"N(`fingernail ,)"
`fingerprint	Suffix	"N(`fingerprint ,)"
`fingertip	Suffix	"N(`fingertip ,)"
`finial	Suffix	"N(`finial ,)"
`finitude	Suffix	"N(`finitude ,)"
`firearm	Suffix	"N(`firearm ,)"
`fireboat	Suffix	"N(`fireboat ,)"
`firebreak	Suffix	"N(`firebreak ,)"
`firebug	Suffix	"N(`firebug ,)"
`firecracker	Suffix	"N(`firecracker ,)"
`firefly	Suffix	"N(`firefly ,)"
`firefight	Suffix	"N(`firefight ,)"
`firehouse	Suffix	"N(`firehouse ,)"
`firelight	Suffix	"N(`firelight ,)"
`fireplace	Suffix	"N(`fireplace ,)"
`firepower	Suffix	"N(`firepower ,)"
`fireside	Suffix	"N(`fireside ,)"
`firestorm	Suffix	"N(`firestorm ,)"
`firewall	Suffix	"N(`firewall ,)"
`firewood	Suffix	"N(`firewood ,)"
`firework	Suffix	"N(`firework ,)"
`firkin	Suffix	"N(`firkin ,)"
`firm	Suffix	"N(`firm ,)"
`firmament	Suffix	"N(`firmament ,)"
`firmware	Suffix	"N(`firmware ,)"
`firstfruit	Suffix	"N(`firstfruit ,)"
`fishery	Suffix	"N(`fish ,)"
`fishmonger	Suffix	"N(`fishmonger ,)"
`fishnet	Suffix	"N(`fishnet ,)"
`fishpond	Suffix	"N(`fishpond ,)"
`fission	Suffix	"N(`fission ,)"
`fissure	Suffix	"N(`fissure ,)"
`fist	Suffix	"N(`fist ,)"
`fistful	Suffix	"N(`fist ,)"
`fisticuff	Suffix	"N(`fisticuff ,)"
`fit	Suffix	"N(`fit ,)"
`fixture	Suffix	"N(`fixture ,)"
`fjord	Suffix	"N(`fjord ,)"
`flab	Suffix	"N(`flab ,)"
`flack	Suffix	"N(`flack ,)"
`flag	Suffix	"N(`flag ,)"
flageo`let	Suffix	"N(flageo`let ,)"
`flagpole	Suffix	"N(`flagpole ,)"
`flagrance	Suffix	"N(`flagrant ,deadj)"
`flagstone	Suffix	"N(`flagstone ,)"
`flair	Suffix	"N(`flair ,)"
`flak	Suffix	"N(`flak ,)"
`flam	Suffix	"N(`flam ,)"
flam`boyance	Suffix	"N(flam`boyant ,deadj)"
flam`boyancy	Suffix	"N(flam`boyant ,deadj)"
flamma`bility	Suffix	"N(`flame ,deverb+deajr)"
`flange	Suffix	"N(`flange ,)"
`flannel	Suffix	"N(`flannel ,)"
`flap	Suffix	"N(`flap ,)"
`flapper	Suffix	"N(`flapper ,)"
`flareup	Suffix	"N(`flareup ,)"
`flashback	Suffix	"N(`flashback ,)"
`flashlight	Suffix	"N(`flashlight ,)"
`flask	Suffix	"N(`flask ,)"
`flat	Suffix	"N(`flat ,)"
`flatbed	Suffix	"N(`flatbed ,)"
`flathead	Suffix	"N(`flathead ,)"
`flatiron	Suffix	"N(`flatiron ,)"
`flatland	Suffix	"N(`flatland ,)"
`flattery	Suffix	"N(`flatter ,deverb)"
`flatulence	Suffix	"N(`flatus ,denom+deajr)"
`flatus	Suffix	"N(`flatus ,)"
`flatware	Suffix	"N(`flatware ,)"
`flautist	Suffix	"N(`flute ,)"
`flavoring	Suffix	"N(`flavor ,)"
`flavouring	Suffix	"N(`flavor - British,)"
`flaw	Suffix	"N(`flaw ,ajr8)"
`flax	Suffix	"N(`flax ,)"
`flaxseed	Suffix	"N(`flaxseed ,)"
`flea	Suffix	"N(`flea ,)"
`fleck	Suffix	"N(`fleck ,)"
`fledgling	Suffix	"N(`fledge ,deverb)"
`fleece	Suffix	"N(`fleece ,)"
`fleet	Suffix	"N(`fleet ,)"
`flexure	Suffix	"N(`flexure ,)"
`flight	Suffix	"N(`flight ,)"
`flightpath	Suffix	"N(`flightpath ,)"
`flint	Suffix	"N(`flint ,)"
`flintlock	Suffix	"N(`flintlock ,)"
`flipper	Suffix	"N(`flipper ,)"
`floc	Suffix	"N(`floc ,)"
`flock	Suffix	"N(`flock ,)"
`floe	Suffix	"N(`floe ,)"
`floodgate	Suffix	"N(`floodgate ,)"
`floodlight	Suffix	"N(`floodlight ,)"
`floor	Suffix	"N(`floor ,)"
`floorboard	Suffix	"N(`floorboard ,)"
`flooring	Suffix	"N(`floor ,)"
`florin	Suffix	"N(`florin ,)"
`florist	Suffix	"N(`flower ,)"
flo`tation	Suffix	"N(`float ,deverb)"
flo`tilla	Suffix	"N(flo`tilla ,)"
`flour	Suffix	"N(`flour ,)"
`flowchart	Suffix	"N(`flowchart ,)"
`flowerpot	Suffix	"N(`flowerpot ,)"
`flu	Suffix	"N(`flu ,)"
`flue	Suffix	"N(`flue ,)"
`fluency	Suffix	"N(`fluent ,deadj)"
`fluff	Suffix	"N(`fluff ,)"
`fluke	Suffix	"N(`fluke ,)"
`flume	Suffix	"N(`flume ,)"
`flurry	Suffix	"N(`flurry ,)"
`flute	Suffix	"N(`flute ,)"
`flux	Suffix	"N(`flux ,)"
`fly	Suffix	"N(`fly ,)"
`flyby	Suffix	"N(`flyby ,)"
`flycatcher	Suffix	"N(`flycatcher ,)"
`flyway	Suffix	"N(`flyway ,)"
`fob	Suffix	"N(`fob ,)"
`fodder	Suffix	"N(`fodder ,)"
`foe	Suffix	"N(`foe ,)"
`foetus	Suffix	"N(`foetus - British,)"
`fogy	Suffix	"N(`fogy ,)"
`foible	Suffix	"N(`foible ,)"
`foil	Suffix	"N(`foil ,)"
`foldout	Suffix	"N(`foldout ,)"
`foliage	Suffix	"N(`foliage ,)"
`fold	Suffix	"N(`fold - of sheep,)"
`folio	Suffix	"N(`folio ,)"
`folklore	Suffix	"N(`folklore ,)"
`folksong	Suffix	"N(`folksong ,)"
`folktale	Suffix	"N(`folktale ,)"
`follicle	Suffix	"N(`follicle ,)"
`folly	Suffix	"N(`folly ,)"
`font	Suffix	"N(`font ,)"
`food	Suffix	"N(`food ,)"
`foodstuff	Suffix	"N(`foodstuff ,)"
`football	Suffix	"N(`football ,)"
`footbridge	Suffix	"N(`footbridge ,)"
`footfall	Suffix	"N(`footfall ,)"
`foothill	Suffix	"N(`foothill ,)"
`foothold	Suffix	"N(`foothold ,)"
`footing	Suffix	"N(`foot ,)"
`footnote	Suffix	"N(`footnote ,)"
`footpad	Suffix	"N(`footpad ,)"
`footpath	Suffix	"N(`footpath ,)"
`footprint	Suffix	"N(`footprint ,)"
`footstep	Suffix	"N(`footstep ,)"
`footstool	Suffix	"N(`footstool ,)"
`footwear	Suffix	"N(`footwear ,)"
`footwork	Suffix	"N(`footwork ,)"
`fop	Suffix	"N(`fop ,)"
`foray	Suffix	"N(`foray ,)"
`fore	Suffix	"N(`fore ,)"
`foreigner	Suffix	"N(`foreign ,deadj)"
`forfeiture	Suffix	"N(`forfeit ,deverb)"
`forkful	Suffix	"N(`fork ,)"
`forklift	Suffix	"N(`forklift ,)"
`formant	Suffix	"N(`formant ,)"
`fort	Suffix	"N(`fort ,)"
`forestry	Suffix	"N(`forest ,)"
`forgery	Suffix	"N(`forge ,deverb)"
`fortitude	Suffix	"N(`fortitude ,)"
`fortnight	Suffix	"N(`fortnight ,)"
`fortress	Suffix	"N(`fortress ,)"
`fortune	Suffix	"N(`fortune ,)"
`fossil	Suffix	"N(`fossil ,)"
`foundling	Suffix	"N(`foundling ,)"
`foundry	Suffix	"N(`foundry ,)"
`fount	Suffix	"N(`fount ,)"
`fountain	Suffix	"N(`fountain ,)"
`fountainhead	Suffix	"N(`fountainhead ,)"
`fox	Suffix	"N(`fox ,)"
`foxhole	Suffix	"N(`foxhole ,)"
`foxhound	Suffix	"N(`foxhound ,)"
`foxtail	Suffix	"N(`foxtail ,)"
`foyer	Suffix	"N(`foyer ,)"
`fraction	Suffix	"N(`fraction ,)"
`fracus	Suffix	"N(`fracus ,)"
`fragrance	Suffix	"N(`fragrant ,deadj)"
`fragrancy	Suffix	"N(`fragrant ,deadj)"
`frailty	Suffix	"N(`frail ,deadj)"
`framework	Suffix	"N(`framework ,)"
`franc	Suffix	"N(`franc ,)"
frangi`pani	Suffix	"N(frangi`pani ,)"
`frankfurter	Suffix	"N(`frankfurter ,)"
`frankincense	Suffix	"N(`frankincense ,)"
`frat	Suffix	"N(`frat - fraternity,)"
fra`ternity	Suffix	"N(fra`ternity ,)"
`fraud	Suffix	"N(`fraud ,)"
`fraudulence	Suffix	"N(`fraud ,denom+deajr)"
`freak	Suffix	"N(`freak ,)"
`freedom	Suffix	"N(`free ,deadj)"
`freeway	Suffix	"N(`freeway ,)"
`freeze	Suffix	"N(`freeze ,)"
`freon	Suffix	"N(`freon ,)"
`frequency	Suffix	"N(`frequent ,deadj)"
`freshet	Suffix	"N(`freshet ,)"
`fret	Suffix	"N(`fret - guitar fret,)"
`friar	Suffix	"N(`friar ,)"
`fricative	Suffix	"N(`fricative ,)"
`friction	Suffix	"N(`friction ,)"
`friend	Suffix	"N(`friend ,ajr13)"
`frieze	Suffix	"N(`frieze ,)"
`frigate	Suffix	"N(`frigate ,)"
`fright	Suffix	"N(`fright ,)"
`frill	Suffix	"N(`frill ,)"
`fritter	Suffix	"N(`fritter ,)"
fri`volity	Suffix	"N(fri`volity ,)"
`frog	Suffix	"N(`frog ,)"
`frolicker	Suffix	"N(`frolic ,deverb)"
`frontage	Suffix	"N(`front ,)"
`frontispiece	Suffix	"N(`frontispiece ,)"
fron`tier	Suffix	"N(fron`tier ,)"
`frostbite	Suffix	"N(`frostbite ,)"
`fruit	Suffix	"N(`fruit ,ajr8)"
fru`ition	Suffix	"N(fru`ition ,)"
`fuddy-duddy	Suffix	"N(`fuddy-duddy ,)"
`fugitive	Suffix	"N(`fugitive ,)"
`fugue	Suffix	"N(`fugue ,)"
`fulcrum	Suffix	"N(`fulcrum ,)"
`fullback	Suffix	"N(`fullback ,)"
`fulness	Suffix	"N(`full ,deadj)"
`fume	Suffix	"N(`fume ,)"
`fumigant	Suffix	"N(`fumigant ,)"
`fun	Suffix	"N(`fun ,)"
`functionary	Suffix	"N(`function ,)"
`functor	Suffix	"N(`functor ,)"
`funeral	Suffix	"N(`funeral ,)"
`funk	Suffix	"N(`funk ,)"
`furlong	Suffix	"N(`furlong ,)"
`furnace	Suffix	"N(`furnace ,)"
`furniture	Suffix	"N(`furniture ,)"
`furrier	Suffix	"N(`furrier ,)"
`furtherance	Suffix	"N(`furtherance ,)"
`fury	Suffix	"N(`fury ,)"
`fuse	Suffix	"N(`fuse ,)"
`fuselage	Suffix	"N(`fuselage ,)"
`fusillade	Suffix	"N(`fusillade ,)"
`fusion	Suffix	"N(`fusion ,)"
`fuzz	Suffix	"N(`fuzz ,)"
`gabardine	Suffix	"N(`gabardine ,)"
`gable	Suffix	"N(`gable ,ajr8)"
`gadfly	Suffix	"N(`gadfly ,)"
`gadget	Suffix	"N(`gadget ,)"
`gadgetry	Suffix	"N(`gadget ,)"
`gadwall	Suffix	"N(`gadwall ,)"
`gaff	Suffix	"N(`gaff ,)"
`gaffe	Suffix	"N(`gaffe ,)"
`gage	Suffix	"N(`gage ,)"
`gaggle	Suffix	"N(`gaggle ,)"
`gaiety	Suffix	"N(`gay ,deadj)"
`gait	Suffix	"N(`gait ,)"
`gal	Suffix	"N(`gal ,)"
`gala	Suffix	"N(`gala ,)"
`galaxy	Suffix	"N(`galaxy ,)"
`gale	Suffix	"N(`gale ,)"
`gall	Suffix	"N(`gall ,)"
`gallantry	Suffix	"N(`gallant ,deadj)"
`galleon	Suffix	"N(`galleon ,)"
`gallery	Suffix	"N(`gallery ,)"
`galley	Suffix	"N(`galley ,)"
`gallinule	Suffix	"N(`gallinule ,)"
`gallon	Suffix	"N(`gallon ,)"
`gallonage	Suffix	"N(`gallonage ,)"
`gallstone	Suffix	"N(`gallstone ,)"
`gam	Suffix	"N(`gam ,)"
`gambit	Suffix	"N(`gambit ,)"
`game	Suffix	"N(`game ,)"
`gamecock	Suffix	"N(`gamecock ,)"
`gamin	Suffix	"N(`gamin ,)"
`gamine	Suffix	"N(`gamine ,)"
`gamut	Suffix	"N(`gamut ,)"
`gander	Suffix	"N(`gander ,)"
`gangland	Suffix	"N(`gangland ,)"
`gangplank	Suffix	"N(`gangplank ,)"
`gangway	Suffix	"N(`gangway ,)"
`gantlet	Suffix	"N(`gantlet ,)"
`gantry	Suffix	"N(`gantry ,)"
`gaol	Suffix	"N(`gaol ,)"
`gar	Suffix	"N(`gar ,)"
`garbage	Suffix	"N(`garbage ,)"
`garland	Suffix	"N(`garland ,)"
`garlic	Suffix	"N(`garlic ,)"
`garment	Suffix	"N(`garment ,)"
`garnet	Suffix	"N(`garnet ,)"
`garter	Suffix	"N(`garter ,)"
`gasket	Suffix	"N(`gasket ,)"
`gaslight	Suffix	"N(`gaslight ,)"
`gasohol	Suffix	"N(`gasohol ,)"
gaso`line	Suffix	"N(gaso`line ,)"
`gastronome	Suffix	"N(`gastronome ,)"
`gate	Suffix	"N(`gate ,)"
`gateway	Suffix	"N(`gateway ,)"
`gator	Suffix	"N(`gator ,)"
gauche`rie	Suffix	"N(gauche`rie ,)"
`gauntlet	Suffix	"N(`gauntlet ,ajr8)"
`gauze	Suffix	"N(`gauze ,)"
`gavel	Suffix	"N(`gavel ,)"
ga`votte	Suffix	"N(ga`votte ,)"
ga`zebo	Suffix	"N(ga`zebo ,)"
ga`zette	Suffix	"N(ga`zette ,)"
`geisha	Suffix	"N(`geisha ,)"
`gelatin	Suffix	"N(`gelatin ,)"
`gem	Suffix	"N(`gem ,)"
`gemstone	Suffix	"N(`gemstone ,)"
gen`darme	Suffix	"N(gen`darme ,)"
`gender	Suffix	"N(`gender ,)"
`gene	Suffix	"N(`gene ,)"
`general	Suffix	"N(`general ,)"
gener`osity	Suffix	"N(`generous ,deadj)"
`genesis	Suffix	"N(`genesis ,)"
`genie	Suffix	"N(`genie ,)"
`genocide	Suffix	"N(`genocide ,)"
`genotype	Suffix	"N(`genotype ,)"
`genre	Suffix	"N(`genre ,)"
`gent	Suffix	"N(`gent ,)"
`gentian	Suffix	"N(`gentian ,)"
`gentile	Suffix	"N(`gentile ,)"
gen`tility	Suffix	"N(gen`tility ,)"
`gentry	Suffix	"N(`gentry ,)"
`germ	Suffix	"N(`germ ,)"
`gerund	Suffix	"N(`gerund ,)"
ge`rundive	Suffix	"N(ge`rundive ,)"
ge`stalt	Suffix	"N(ge`stalt ,)"
`getaway	Suffix	"N(`getaway ,)"
`geyser	Suffix	"N(`geyser ,)"
`gherkin	Suffix	"N(`gherkin ,)"
`ghost	Suffix	"N(`ghost ,)"
`ghoul	Suffix	"N(`ghoul ,)"
`giant	Suffix	"N(`giant ,)"
`gibberish	Suffix	"N(`gibberish ,)"
`gibbet	Suffix	"N(`gibbet ,)"
`giblet	Suffix	"N(`giblet ,)"
`gift	Suffix	"N(`gift ,ajr8)"
`gill	Suffix	"N(`gill ,)"
`gigolo	Suffix	"N(`gigolo ,)"
`gimmick	Suffix	"N(`gimmick ,)"
`gimmickry	Suffix	"N(`gimmick ,)"
`gin	Suffix	"N(`gin ,)"
`ginger	Suffix	"N(`ginger ,)"
`gingham	Suffix	"N(`gingham ,)"
`ginmill	Suffix	"N(`ginmill ,)"
`gipsy	Suffix	"N(`gipsy ,)"
`girl	Suffix	"N(`girl ,)"
`girlfriend	Suffix	"N(`girlfriend ,)"
`girth	Suffix	"N(`girth ,)"
`gist	Suffix	"N(`gist ,)"
`giveaway	Suffix	"N(`giveaway ,)"
`gizzard	Suffix	"N(`gizzard ,)"
`glacier	Suffix	"N(`glacier ,)"
`glacis	Suffix	"N(`glacis ,)"
`glade	Suffix	"N(`glade ,)"
`gladiator	Suffix	"N(`gladiator ,)"
`glamor	Suffix	"N(`glamor ,)"
`glamour	Suffix	"N(`glamour - British,)"
`gland	Suffix	"N(`gland ,)"
`glasnost	Suffix	"N(`glasnost ,)"
`glass	Suffix	"N(`glass ,)"
`glassful	Suffix	"N(`glass ,)"
glass`ine	Suffix	"N(glass`ine ,)"
`glassware	Suffix	"N(`glassware ,)"
`glee	Suffix	"N(`glee ,)"
`glen	Suffix	"N(`glen ,)"
`glitch	Suffix	"N(`glitch ,)"
`glob	Suffix	"N(`glob ,)"
`globe	Suffix	"N(`globe ,)"
`globule	Suffix	"N(`globule ,)"
`gloom	Suffix	"N(`gloom ,)"
glorifi`cation	Suffix	"N(`glory ,deverb)"
`glossary	Suffix	"N(`glossary ,)"
glosso`lalia	Suffix	"N(glosso`lalia ,)"
`glottis	Suffix	"N(`glottis ,)"
`glove	Suffix	"N(`glove ,ajr8)"
`glutton	Suffix	"N(`glutton ,)"
`glyph	Suffix	"N(`glyph ,)"
`gnat	Suffix	"N(`gnat ,)"
`gnome	Suffix	"N(`gnome ,)"
`gnostic	Suffix	"N(`gnostic ,)"
`gnu	Suffix	"N(`gnu ,)"
`goal	Suffix	"N(`goal ,)"
`goalie	Suffix	"N(`goalie ,)"
`goat	Suffix	"N(`goat ,)"
goat`ee	Suffix	"N(goat`ee ,)"
`goatherd	Suffix	"N(`goatherd ,)"
`gob	Suffix	"N(`gob ,)"
`gobbledygook	Suffix	"N(`gobbledygook ,)"
`goblet	Suffix	"N(`goblet ,)"
`goblin	Suffix	"N(`goblin ,)"
`god	Suffix	"N(`god ,)"
`goddaughter	Suffix	"N(`goddaughter ,)"
`godfather	Suffix	"N(`godfather ,)"
`godhead	Suffix	"N(`godhead ,)"
`godmother	Suffix	"N(`godmother ,)"
`godparent	Suffix	"N(`godparent ,)"
`godsend	Suffix	"N(`godsend ,)"
`godson	Suffix	"N(`godson ,)"
`goldsmith	Suffix	"N(`goldsmith ,)"
`gondola	Suffix	"N(`gondola ,)"
`gong	Suffix	"N(`gong ,)"
`goober	Suffix	"N(`goober ,)"
good-`bye	Suffix	"N(good-`bye ,)"
good-`by	Suffix	"N(good-`by ,)"
good`will	Suffix	"N(good`will ,)"
`goody	Suffix	"N(`goody ,)"
`goose	Suffix	"N(`goose ,)"
`gorge	Suffix	"N(`gorge ,)"
`gorgon	Suffix	"N(`gorgon ,)"
`gosling	Suffix	"N(`goose ,)"
`gospel	Suffix	"N(`gospel ,)"
`gossamer	Suffix	"N(`gossamer ,)"
`gourd	Suffix	"N(`gourd ,)"
`gourmand	Suffix	"N(`gourmand ,)"
gour`met	Suffix	"N(gour`met ,)"
`gout	Suffix	"N(`gout ,)"
`governess	Suffix	"N(`govern ,deverb)"
`gown	Suffix	"N(`gown ,ajr8)"
`grad	Suffix	"N(`grad - graduate,)"
`gradient	Suffix	"N(`gradient ,)"
`graham	Suffix	"N(`graham ,)"
`grail	Suffix	"N(`grail ,)"
`grain	Suffix	"N(`grain ,ajr8)"
`gram	Suffix	"N(`gram ,)"
`grammar	Suffix	"N(`grammar ,)"
`granary	Suffix	"N(`granary ,)"
grand`aunt	Suffix	"N(grand`aunt ,)"
`granddaughter	Suffix	"N(`granddaughter ,)"
`grandeur	Suffix	"N(`grandeur ,)"
`grandfather	Suffix	"N(`grandfather ,)"
gran`diloquence	Suffix	"N(gran`diloquent ,deadj)"
`grandma	Suffix	"N(`grandma ,)"
`grandmother	Suffix	"N(`grandmother ,)"
grand`nephew	Suffix	"N(grand`nephew ,)"
grand`niece	Suffix	"N(grand`niece ,)"
`grandpa	Suffix	"N(`grandpa ,)"
`grandparent	Suffix	"N(`grandparent ,)"
`grandson	Suffix	"N(`grandson ,)"
`grandstand	Suffix	"N(`grandstand ,)"
grand`uncle	Suffix	"N(grand`uncle ,)"
`granite	Suffix	"N(`granite ,)"
`granny	Suffix	"N(`granny ,)"
gra`nola	Suffix	"N(gra`nola ,)"
`granule	Suffix	"N(`granule ,)"
`grape	Suffix	"N(`grape ,)"
`grapefruit	Suffix	"N(`grapefruit ,)"
`grapevine	Suffix	"N(`grapevine ,)"
`graph	Suffix	"N(`graph ,)"
`grapheme	Suffix	"N(`grapheme ,)"
`graphic	Suffix	"N(`graphic ,)"
`grass	Suffix	"N(`grass ,)"
`grasshopper	Suffix	"N(`grasshopper ,)"
`grassland	Suffix	"N(`grassland ,)"
grati`fication	Suffix	"N(`gratify ,deverb)"
`gratitude	Suffix	"N(`gratitude ,)"
gra`tuity	Suffix	"N(gra`tuity ,)"
`grave	Suffix	"N(`grave ,)"
`gravel	Suffix	"N(`gravel ,)"
`gravestone	Suffix	"N(`gravestone ,)"
`graveyard	Suffix	"N(`graveyard ,)"
`gravity	Suffix	"N(`gravity ,)"
`gravy	Suffix	"N(`gravy ,)"
`graybeard	Suffix	"N(`graybeard ,)"
`greatcoat	Suffix	"N(`greatcoat ,)"
`greed	Suffix	"N(`greed ,)"
`greenery	Suffix	"N(`green ,deadj)"
`greengrocer	Suffix	"N(`greengrocer ,)"
`greenhorn	Suffix	"N(`greenhorn ,)"
`greenhouse	Suffix	"N(`greenhouse ,)"
`greensward	Suffix	"N(`greensward ,)"
`greenwood	Suffix	"N(`greenwood ,)"
`gremlin	Suffix	"N(`gremlin ,)"
gre`nade	Suffix	"N(gre`nade ,)"
`greyhound	Suffix	"N(`greyhound ,)"
`grid	Suffix	"N(`grid ,)"
`griddle	Suffix	"N(`griddle ,)"
`gridiron	Suffix	"N(`gridiron ,)"
`grief	Suffix	"N(`grief ,)"
`griffin	Suffix	"N(`griffin ,)"
`grille	Suffix	"N(`grille ,)"
`grillwork	Suffix	"N(`grillwork ,)"
`grime	Suffix	"N(`grime ,)"
`grindstone	Suffix	"N(`grindstone ,)"
`grippe	Suffix	"N(`grippe ,)"
`grist	Suffix	"N(`grist ,)"
`gristmill	Suffix	"N(`gristmill ,)"
`groat	Suffix	"N(`groat ,)"
`grocer	Suffix	"N(`grocer ,)"
`grocery	Suffix	"N(`grocery ,)"
`grog	Suffix	"N(`grog ,)"
`groin	Suffix	"N(`groin ,)"
`grommet	Suffix	"N(`grommet ,)"
`grouch	Suffix	"N(`grouch ,)"
`groundswell	Suffix	"N(`groundswell ,)"
`groundwork	Suffix	"N(`groundwork ,)"
`grout	Suffix	"N(`grout ,)"
`grove	Suffix	"N(`grove ,)"
`grownup	Suffix	"N(`grownup ,)"
`growth	Suffix	"N(`grow ,deverb)"
`grub	Suffix	"N(`grub ,)"
`grudge	Suffix	"N(`grudge ,)"
`gryphon	Suffix	"N(`gryphon ,)"
`guano	Suffix	"N(`guano ,)"
`guarantor	Suffix	"N(`guarantor ,)"
`guaranty	Suffix	"N(`guaranty ,)"
`guardhouse	Suffix	"N(`guardhouse ,)"
guer`rilla	Suffix	"N(guer`rilla ,)"
`guesswork	Suffix	"N(`guesswork ,)"
`guest	Suffix	"N(`guest ,)"
`guidebook	Suffix	"N(`guidebook ,)"
`guideline	Suffix	"N(`guideline ,)"
`guidepost	Suffix	"N(`guidepost ,)"
`guild	Suffix	"N(`guild ,)"
`guildhall	Suffix	"N(`guildhall ,)"
`guile	Suffix	"N(`guile ,)"
`guillotine	Suffix	"N(`guillotine ,)"
`guilt	Suffix	"N(`guilt ,)"
`guinea	Suffix	"N(`guinea ,)"
`guise	Suffix	"N(`guise ,)"
gui`tar	Suffix	"N(gui`tar ,)"
`gulch	Suffix	"N(`gulch ,)"
`gules	Suffix	"N(`gules ,)"
`gulf	Suffix	"N(`gulf ,)"
`gull	Suffix	"N(`gull ,)"
`gullet	Suffix	"N(`gullet ,)"
gulli`bility	Suffix	"N(`gullible ,deadj)"
`gully	Suffix	"N(`gully ,)"
`gumbo	Suffix	"N(`gumbo ,)"
`gumdrop	Suffix	"N(`gumdrop ,)"
`gumption	Suffix	"N(`gumption ,)"
`gumshoe	Suffix	"N(`gumshoe ,)"
`gunboat	Suffix	"N(`gunboat ,)"
`gunfight	Suffix	"N(`gunfight ,)"
`gunfire	Suffix	"N(`gunfire ,)"
`gunflint	Suffix	"N(`gunflint ,)"
`gunk	Suffix	"N(`gunk ,)"
`gunnery	Suffix	"N(`gun ,)"
`gunny	Suffix	"N(`gunny ,)"
`gunplay	Suffix	"N(`gunplay ,)"
`gunpoint	Suffix	"N(`gunpoint ,)"
`gunpowder	Suffix	"N(`gunpowder ,)"
`gunshot	Suffix	"N(`gunshot ,)"
`gunwale	Suffix	"N(`gunwale ,)"
`guru	Suffix	"N(`guru ,)"
`gusset	Suffix	"N(`gusset ,)"
`gusto	Suffix	"N(`gusto ,)"
`gutter	Suffix	"N(`gutter ,)"
`guy	Suffix	"N(`guy ,)"
`gym	Suffix	"N(`gym ,)"
gym`nasium	Suffix	"N(gym`nasium ,)"
`gymnast	Suffix	"N(`gymnast ,)"
`gypsy	Suffix	"N(`gypsy ,)"
`gyrfalcon	Suffix	"N(`gyrfalcon ,)"
`gyro	Suffix	"N(`gyro ,)"
`gyrocompass	Suffix	"N(`gyrocompass ,)"
`gyroscope	Suffix	"N(`gyroscope ,)"
`haberdashery	Suffix	"N(`haberdashery ,)"
habita`bility	Suffix	"N(`habitable ,deadj)"
`habit	Suffix	"N(`habit ,)"
`habitat	Suffix	"N(`habitat ,)"
habi`tation	Suffix	"N(habi`tation ,)"
`habitude	Suffix	"N(`habitude ,)"
haci`enda	Suffix	"N(haci`enda ,)"
`hackle	Suffix	"N(`hackle ,)"
`hackney	Suffix	"N(`hackney ,)"
`hacksaw	Suffix	"N(`hacksaw ,)"
`haddock	Suffix	"N(`haddock ,)"
`hag	Suffix	"N(`hag ,)"
`haiku	Suffix	"N(`haiku ,)"
`hailstone	Suffix	"N(`hailstone ,)"
`hailstorm	Suffix	"N(`hailstorm ,)"
`hair	Suffix	"N(`hair ,)"
`haircut	Suffix	"N(`haircut ,)"
`hairdo	Suffix	"N(`hairdo ,)"
`hairlip	Suffix	"N(`hairlip ,)"
`hairpin	Suffix	"N(`hairpin ,)"
`halfback	Suffix	"N(`halfback ,)"
`hall	Suffix	"N(`hall ,)"
`hallmark	Suffix	"N(`hallmark ,)"
`hallway	Suffix	"N(`hallway ,)"
`halogen	Suffix	"N(`halogen ,)"
hal`lucinogen	Suffix	"N(hal`lucinogen ,)"
`halyard	Suffix	"N(`halyard ,)"
`ham	Suffix	"N(`ham ,)"
`hamburger	Suffix	"N(`hamburger ,)"
`hamlet	Suffix	"N(`hamlet ,)"
`hammock	Suffix	"N(`hammock ,)"
`hamper	Suffix	"N(`hamper ,)"
`hand	Suffix	"N(`hand ,ajr8)"
`handbag	Suffix	"N(`handbag ,)"
`handbook	Suffix	"N(`handbook ,)"
`handclasp	Suffix	"N(`handclasp ,)"
`handful	Suffix	"N(`hand ,)"
`handgun	Suffix	"N(`handgun ,)"
`handhold	Suffix	"N(`handhold ,)"
`handicraft	Suffix	"N(`handicraft ,)"
`handiwork	Suffix	"N(`handiwork ,)"
`handkerchief	Suffix	"N(`handkerchief ,)"
`handlebar	Suffix	"N(`handlebar ,)"
`handline	Suffix	"N(`handline ,)"
`handmaiden	Suffix	"N(`handmaiden ,)"
`handout	Suffix	"N(`handout ,)"
`hangup	Suffix	"N(`hangup ,)"
`handset	Suffix	"N(`handset ,)"
`handshake	Suffix	"N(`handshake ,)"
`handstand	Suffix	"N(`handstand ,)"
`hangar	Suffix	"N(`hangar ,)"
`hangout	Suffix	"N(`hangout ,)"
`hangover	Suffix	"N(`hangover ,)"
`hank	Suffix	"N(`hank ,)"
`hansom	Suffix	"N(`hansom ,)"
`happenstance	Suffix	"N(`happenstance ,)"
`harbinger	Suffix	"N(`harbinger ,)"
`hardboard	Suffix	"N(`hardboard ,)"
`hardhat	Suffix	"N(`hardhat ,)"
hard`line	Suffix	"N(hard`line ,)"
hard`liner	Suffix	"N(hard`line ,)"
`hardscrabble	Suffix	"N(`hardscrabble ,)"
`hardship	Suffix	"N(`hard ,deadj)"
`hardtack	Suffix	"N(`hardtack ,)"
`hardtop	Suffix	"N(`hardtop ,)"
`hardware	Suffix	"N(`hardware ,)"
`hardwood	Suffix	"N(`hardwood ,)"
`hare	Suffix	"N(`hare ,)"
`harelip	Suffix	"N(`harelip ,)"
`harem	Suffix	"N(`harem ,)"
`harlot	Suffix	"N(`harlot ,)"
`harmony	Suffix	"N(`harmony ,)"
`harp	Suffix	"N(`harp ,)"
`harpsichord	Suffix	"N(`harpsichord ,)"
`harpstring	Suffix	"N(`harpstring ,)"
`hart	Suffix	"N(`hart ,)"
ha`shish	Suffix	"N(ha`shish ,)"
`hasp	Suffix	"N(`hasp ,)"
`haste	Suffix	"N(`haste ,)"
`hat	Suffix	"N(`hat ,)"
`hatful	Suffix	"N(`hat ,)"
`hatter	Suffix	"N(`hat ,)"
`hatchet	Suffix	"N(`hatchet ,)"
`hatchway	Suffix	"N(`hatchway ,)"
`hatred	Suffix	"N(`hatred ,)"
`haunch	Suffix	"N(`haunch ,)"
`haven	Suffix	"N(`haven ,)"
`havoc	Suffix	"N(`havoc ,)"
`hawk	Suffix	"N(`hawk ,)"
`hawser	Suffix	"N(`hawser ,)"
`hay	Suffix	"N(`hay ,)"
`hayfield	Suffix	"N(`hayfield ,)"
`haystack	Suffix	"N(`haystack ,)"
`haze	Suffix	"N(`haze ,)"
`head	Suffix	"N(`head ,ajr8)"
`headache	Suffix	"N(`headache ,)"
`headboard	Suffix	"N(`headboard ,)"
`headdress	Suffix	"N(`headdress ,)"
`header	Suffix	"N(`header ,)"
`headland	Suffix	"N(`headland ,)"
`headlight	Suffix	"N(`headlight ,)"
`headline	Suffix	"N(`headline ,)"
`headmaster	Suffix	"N(`headmaster ,)"
`headphone	Suffix	"N(`headphone ,)"
`headroom	Suffix	"N(`headroom ,)"
`headset	Suffix	"N(`headset ,)"
`headstand	Suffix	"N(`headstand ,)"
`headstone	Suffix	"N(`headstone ,)"
`headwall	Suffix	"N(`headwall ,)"
`headwater	Suffix	"N(`headwater ,)"
`headway	Suffix	"N(`headway ,)"
`headwind	Suffix	"N(`headwind ,)"
`health	Suffix	"N(`health ,)"
`hearsay	Suffix	"N(`hearsay ,)"
`hearse	Suffix	"N(`hearse ,)"
`heart	Suffix	"N(`heart ,ajr8)"
`heartbeat	Suffix	"N(`heartbeat ,)"
`heartburn	Suffix	"N(`heartburn ,)"
`hearth	Suffix	"N(`hearth ,)"
`hearthrug	Suffix	"N(`hearthrug ,)"
`hearthstone	Suffix	"N(`hearthstone ,)"
`heath	Suffix	"N(`heath ,)"
`heathen	Suffix	"N(`heathen ,)"
`heather	Suffix	"N(`heather ,)"
`heaven	Suffix	"N(`heaven ,ajr13)"
`heavyweight	Suffix	"N(`heavyweight ,)"
`hecatomb	Suffix	"N(`hecatomb ,)"
`hectare	Suffix	"N(`hectare ,)"
`hedonism	Suffix	"N(`hedonism ,)"
`hedonist	Suffix	"N(`hedonist ,)"
`heel	Suffix	"N(`heel ,)"
he`gemony	Suffix	"N(he`gemony ,)"
`heifer	Suffix	"N(`heifer ,)"
`height	Suffix	"N(`height ,)"
`heir	Suffix	"N(`heir ,)"
`heirloom	Suffix	"N(`heirloom ,)"
`helicopter	Suffix	"N(`helicopter ,)"
`helix	Suffix	"N(`helix ,)"
`hell	Suffix	"N(`hell ,)"
`hellfire	Suffix	"N(`hellfire ,)"
`helm	Suffix	"N(`helm ,)"
`helmet	Suffix	"N(`helmet ,ajr8)"
`helpmate	Suffix	"N(`helpmate ,)"
`hemline	Suffix	"N(`hemline ,)"
`hemp	Suffix	"N(`hemp ,)"
`hen	Suffix	"N(`hen ,)"
hepa`titis	Suffix	"N(hepa`titis ,)"
`herb	Suffix	"N(`herb ,)"
here`after	Suffix	"N(here`after ,)"
he`redity	Suffix	"N(he`redity ,)"
`heresy	Suffix	"N(`heresy ,)"
`heretic	Suffix	"N(`heretic ,)"
`heritage	Suffix	"N(`heritage ,)"
`hermit	Suffix	"N(`hermit ,)"
`heroin	Suffix	"N(`heroin ,)"
`heroine	Suffix	"N(`heroine ,)"
`herringbone	Suffix	"N(`herringbone ,)"
`hesitance	Suffix	"N(`hesitate ,deverb+deajr)"
`hesitancy	Suffix	"N(`hesitate ,deverb+deajr)"
`heterodoxy	Suffix	"N(`heterodoxy ,)"
heteroge`neity	Suffix	"N(heteroge`neity ,)"
heu`ristic	Suffix	"N(heu`ristic ,)"
`hexagon	Suffix	"N(`hexagon ,)"
hex`ameter	Suffix	"N(hex`ameter ,)"
`heyday	Suffix	"N(`heyday ,)"
hi`atus	Suffix	"N(hi`atus ,)"
hi`bachi	Suffix	"N(hi`bachi ,)"
`hick	Suffix	"N(`hick ,)"
`hideaway	Suffix	"N(`hideaway ,)"
`hideout	Suffix	"N(`hideout ,)"
`hierarch	Suffix	"N(`hierarch ,)"
`hierarchy	Suffix	"N(`hierarchy ,)"
`highball	Suffix	"N(`highball ,)"
`highboy	Suffix	"N(`highboy ,)"
`highland	Suffix	"N(`highland ,)"
`highlander	Suffix	"N(`highland ,)"
`highroad	Suffix	"N(`highroad ,)"
`highway	Suffix	"N(`highway ,)"
`hijinks	Suffix	"N(`hijinks ,)"
hi`larity	Suffix	"N(hi`larity ,)"
`hill	Suffix	"N(`hill ,)"
`hillbilly	Suffix	"N(`hillbilly ,)"
`hillock	Suffix	"N(`hillock ,)"
`hillside	Suffix	"N(`hillside ,)"
`hilltop	Suffix	"N(`hilltop ,)"
`hilt	Suffix	"N(`hilt ,)"
`hind	Suffix	"N(`hind ,)"
`hindrance	Suffix	"N(`hindrance ,)"
`hindsight	Suffix	"N(`hindsight ,)"
`hinterland	Suffix	"N(`hinterland ,)"
`hip	Suffix	"N(`hip ,)"
`hippo	Suffix	"N(`hippo - hippopotamus,)"
`hippodrome	Suffix	"N(`hippodrome ,)"
`hippy	Suffix	"N(`hippy ,)"
`hireling	Suffix	"N(`hireling ,)"
`history	Suffix	"N(`history ,)"
`hit	Suffix	"N(`hit ,)"
`hive	Suffix	"N(`hive ,)"
`hoagie	Suffix	"N(`hoagie ,)"
`hoagy	Suffix	"N(`hoagy ,)"
`hoarfrost	Suffix	"N(`hoarfrost ,)"
`hoax	Suffix	"N(`hoax ,)"
`hob	Suffix	"N(`hob ,)"
`hobby	Suffix	"N(`hobby ,)"
`hobbyhorse	Suffix	"N(`hobbyhorse ,)"
`hobgoblin	Suffix	"N(`hobgoblin ,)"
`hock	Suffix	"N(`hock ,)"
`hockey	Suffix	"N(`hockey ,)"
hocus-`pocus	Suffix	"N(hocus-`pocus ,)"
`hodge-podge	Suffix	"N(`hodge-podge ,)"
`hogan	Suffix	"N(`hogan ,)"
`hogshead	Suffix	"N(`hogshead ,)"
`hogwash	Suffix	"N(`hogwash ,)"
hoky-`poky	Suffix	"N(hoky-`poky ,)"
`holdout	Suffix	"N(`holdout ,)"
`holdover	Suffix	"N(`holdover ,)"
`holdup	Suffix	"N(`holdup ,)"
`hole	Suffix	"N(`hole ,)"
`holiday	Suffix	"N(`holiday ,)"
`hollowware	Suffix	"N(`hollowware ,)"
`holocaust	Suffix	"N(`holocaust ,)"
`holster	Suffix	"N(`holster ,)"
`holystone	Suffix	"N(`holystone ,)"
`homage	Suffix	"N(`homage ,)"
`home	Suffix	"N(`home ,)"
`homecoming	Suffix	"N(`come ,deverb)"
`homeland	Suffix	"N(`homeland ,)"
`homestead	Suffix	"N(`homestead ,)"
home`town	Suffix	"N(home`town ,)"
`homework	Suffix	"N(`homework ,)"
`homicide	Suffix	"N(`homicide ,)"
`homily	Suffix	"N(`homily ,)"
`homo	Suffix	"N(`homo ,)"
homoge`neity	Suffix	"N(homoge`neity ,)"
`homograph	Suffix	"N(`homograph ,)"
`homonym	Suffix	"N(`homonym ,)"
ho`monymy	Suffix	"N(ho`monymy ,)"
`homophone	Suffix	"N(`homophone ,)"
`honesty	Suffix	"N(`honest ,deadj)"
`honeycomb	Suffix	"N(`honeycomb ,)"
honor`ific	Suffix	"N(honor`ific ,)"
`hooch	Suffix	"N(`hooch ,)"
`hoodlum	Suffix	"N(`hoodlum ,)"
`hoofmark	Suffix	"N(`hoofmark ,)"
`hookah	Suffix	"N(`hookah ,)"
`hookup	Suffix	"N(`hookup ,)"
`hooligan	Suffix	"N(`hooligan ,)"
`hoop	Suffix	"N(`hoop ,)"
`hoopla	Suffix	"N(`hoopla ,)"
`hoosegow	Suffix	"N(`hoosegow ,)"
`hopeful	Suffix	"N(`hope ,)"
`hopscotch	Suffix	"N(`hopscotch ,)"
`horde	Suffix	"N(`horde ,)"
ho`rizon	Suffix	"N(ho`rizon ,)"
`hormone	Suffix	"N(`hormone ,)"
`horn	Suffix	"N(`horn ,ajr8)"
`hornet	Suffix	"N(`hornet ,)"
`hornpipe	Suffix	"N(`hornpipe ,)"
`horoscope	Suffix	"N(`horoscope ,)"
`horror	Suffix	"N(`horror ,)"
`horse	Suffix	"N(`horse ,)"
`horseflesh	Suffix	"N(`horseflesh ,)"
`horsehair	Suffix	"N(`horsehair ,)"
`horseplay	Suffix	"N(`horseplay ,)"
`horsepower	Suffix	"N(`horsepower ,)"
`horseshoe	Suffix	"N(`horseshoe ,)"
`horticulture	Suffix	"N(`horticulture ,)"
`hose	Suffix	"N(`hose ,)"
`hosiery	Suffix	"N(`hosiery ,)"
`hospice	Suffix	"N(`hospice ,)"
`hospital	Suffix	"N(`hospital ,)"
hospi`tality	Suffix	"N(hospi`tality ,)"
`hostage	Suffix	"N(`hostage ,)"
`hostel	Suffix	"N(`hostel ,)"
`hostelry	Suffix	"N(`hostel ,)"
`hostler	Suffix	"N(`hostler ,)"
`hotbed	Suffix	"N(`hotbed ,)"
`hotbox	Suffix	"N(`hotbox ,)"
ho`tel	Suffix	"N(ho`tel ,)"
`hothead	Suffix	"N(`hothead ,)"
`hothouse	Suffix	"N(`hothouse ,)"
`hotrod	Suffix	"N(`hotrod ,)"
`hotshot	Suffix	"N(`hotshot ,)"
`hotspot	Suffix	"N(`hotspot ,)"
`hour	Suffix	"N(`hour ,)"
`hourglass	Suffix	"N(`hourglass ,)"
`houseboat	Suffix	"N(`houseboat ,)"
`houseful	Suffix	"N(`house ,)"
`household	Suffix	"N(`household ,)"
`householder	Suffix	"N(`household ,)"
`housemaid	Suffix	"N(`housemaid ,)"
`housetop	Suffix	"N(`housetop ,)"
`housework	Suffix	"N(`housework ,)"
`hovel	Suffix	"N(`hovel ,)"
`hoyden	Suffix	"N(`hoyden ,)"
`hub	Suffix	"N(`hub ,)"
`hubbub	Suffix	"N(`hubbub ,)"
`hubby	Suffix	"N(`hubby ,)"
`hubris	Suffix	"N(`hubris ,)"
`huckster	Suffix	"N(`huckster ,)"
`hue	Suffix	"N(`hue ,ajr8)"
`hull	Suffix	"N(`hull ,)"
`humbug	Suffix	"N(`humbug ,)"
hu`mility	Suffix	"N(hu`mility ,)"
`hummock	Suffix	"N(`hummock ,)"
`hump	Suffix	"N(`hump ,ajr8)"
`humpback	Suffix	"N(`humpback ,ajr8)"
`humus	Suffix	"N(`humus ,)"
`hunch	Suffix	"N(`hunch ,)"
`hunchback	Suffix	"N(`hunchback ,ajr8)"
`hunk	Suffix	"N(`hunk ,)"
`hurdle	Suffix	"N(`hurdle ,)"
`hurricane	Suffix	"N(`hurricane ,)"
`hurt	Suffix	"N(`hurt ,)"
`husbandry	Suffix	"N(`husband ,deverb)"
`hussy	Suffix	"N(`hussy ,)"
`hut	Suffix	"N(`hut ,)"
`hutch	Suffix	"N(`hutch ,)"
huz`za	Suffix	"N(huz`za ,)"
huz`zah	Suffix	"N(huz`zah ,)"
hy`drangea	Suffix	"N(hy`drangea ,)"
`hydrant	Suffix	"N(`hydrant ,)"
hydro`phobia	Suffix	"N(hydro`phobia ,)"
hy`ena	Suffix	"N(hy`ena ,)"
`hygiene	Suffix	"N(`hygiene ,)"
`hymen	Suffix	"N(`hymen ,)"
`hymn	Suffix	"N(`hymn ,)"
`hymnal	Suffix	"N(`hymnal ,)"
`hymnody	Suffix	"N(`hymnody ,)"
`hype	Suffix	"N(`hype - see verb.lex for verb forms,)"
hy`perbole	Suffix	"N(hy`perbole ,)"
`hyphen	Suffix	"N(`hyphen ,)"
hyp`nosis	Suffix	"N(hyp`nosis ,)"
`hypnotism	Suffix	"N(`hypnotism ,)"
`hypnotist	Suffix	"N(`hypnotist ,)"
hypo`chondria	Suffix	"N(hypo`chondria ,)"
hy`pocrisy	Suffix	"N(hy`pocrisy ,)"
`hypocrite	Suffix	"N(`hypocrite ,)"
hys`teria	Suffix	"N(hys`teria ,)"
ich`neumon	Suffix	"N(ich`neumon ,)"
`icing	Suffix	"N(`ice ,)"
`iceberg	Suffix	"N(`iceberg ,)"
`icebox	Suffix	"N(`icebox ,)"
`icicle	Suffix	"N(`icicle ,)"
`icon	Suffix	"N(`icon ,)"
i`conoclasm	Suffix	"N(i`conoclasm ,)"
i`conoclast	Suffix	"N(i`conoclast ,)"
i`dea	Suffix	"N(i`dea ,)"
identifi`cation	Suffix	"N(i`dentify ,deverb)"
i`dentity	Suffix	"N(i`dentity ,)"
`ideologue	Suffix	"N(`ideologue ,)"
`idiocy	Suffix	"N(`idiot ,)"
`idiom	Suffix	"N(`idiom ,)"
idio`syncrasy	Suffix	"N(idio`syncrasy ,)"
`idiot	Suffix	"N(`idiot ,)"
`idol	Suffix	"N(`idol ,)"
i`dolater	Suffix	"N(i`dolater ,)"
i`dolator	Suffix	"N(i`dolator ,)"
i`dolatry	Suffix	"N(i`dolatry ,)"
`idyll	Suffix	"N(`idyll ,)"
`igloo	Suffix	"N(`igloo ,)"
`ignominy	Suffix	"N(`ignominy ,)"
igno`ramus	Suffix	"N(igno`ramus ,)"
il`lusion	Suffix	"N(il`lusion ,)"
`image	Suffix	"N(`image ,)"
`imagery	Suffix	"N(`image ,)"
`imbecile	Suffix	"N(`imbecile ,)"
imbe`cility	Suffix	"N(`imbecile ,)"
im`broglio	Suffix	"N(im`broglio ,)"
`immanence	Suffix	"N(`immanent ,deadj)"
im`mediacy	Suffix	"N(im`mediate ,deadj)"
`immigrant	Suffix	"N(`immigrate ,deverb)"
im`mortal	Suffix	"N(im`mortal ,)"
`imp	Suffix	"N(`imp ,)"
`impasse	Suffix	"N(`impasse ,)"
im`pediment	Suffix	"N(im`pede ,deverb)"
imper`fection	Suffix	"N(`perfect ,deadj)"
`impetus	Suffix	"N(`impetus ,)"
`implant	Suffix	"N(`implant ,ss)"
`implicant	Suffix	"N(`implicant ,)"
im`plosion	Suffix	"N(im`plode ,deverb)"
`import	Suffix	"N(`import ,ss)"
im`portance	Suffix	"N(im`portance ,)"
impor`tunity	Suffix	"N(impor`tunity ,)"
im`postor	Suffix	"N(im`postor ,)"
im`posture	Suffix	"N(im`posture ,)"
impre`sario	Suffix	"N(impre`sario ,)"
`impress	Suffix	"N(`impress ,ss)"
impri`matur	Suffix	"N(impri`matur ,)"
`imprint	Suffix	"N(`imprint ,ss)"
`impudence	Suffix	"N(`impudent ,deadj)"
`impulse	Suffix	"N(`impulse ,)"
im`punity	Suffix	"N(im`punity ,)"
in`action	Suffix	"N(`act ,deverb)"
`inbreed	Suffix	"N(`inbreed ,ss)"
`incense	Suffix	"N(`incense ,)"
in`centive	Suffix	"N(in`centive ,)"
in`ception	Suffix	"N(in`ception ,)"
in`ceptor	Suffix	"N(in`ceptor ,)"
`incest	Suffix	"N(`incest ,)"
`incidence	Suffix	"N(`incidence ,)"
`incident	Suffix	"N(`incident ,)"
`incline	Suffix	"N(`incline ,ss)"
in`clusion	Suffix	"N(in`clude ,deverb)"
inco`herence	Suffix	"N(co`here ,deverb+deajr)"
`income	Suffix	"N(`income ,)"
incom`pletion	Suffix	"N(com`plete ,deadj)"
incompre`hension	Suffix	"N(compre`hend ,deverb)"
in`continency	Suffix	"N(`continent ,deadj)"
`increase	Suffix	"N(`increase ,ss)"
incrus`tation	Suffix	"N(`crust ,deverb)"
in`cumbrance	Suffix	"N(in`cumber ,deverb)"
in`cursion	Suffix	"N(in`cursion ,)"
inde`cision	Suffix	"N(de`cide ,deverb+deajr)"
in`demnity	Suffix	"N(in`demnity ,)"
`indent	Suffix	"N(`indent ,ss)"
in`denture	Suffix	"N(in`denture ,)"
inde`pendence	Suffix	"N(de`pend ,deverb+deajr)"
`indicant	Suffix	"N(`indicant ,)"
in`difference	Suffix	"N(`differ ,deverb+deajr)"
`indigence	Suffix	"N(`indigent ,deadj)"
indi`gestion	Suffix	"N(di`gest ,deverb)"
`indigene	Suffix	"N(`indigene ,)"
indig`nation	Suffix	"N(indig`nation ,)"
in`dignity	Suffix	"N(`dignity ,)"
indi`rection	Suffix	"N(di`rect ,deverb)"
individu`ality	Suffix	"N(indi`vidual ,deadj)"
`indolence	Suffix	"N(`indolent ,deadj)"
`industry	Suffix	"N(`industry ,)"
in`eptitude	Suffix	"N(in`ept ,deadj)"
in`ertance	Suffix	"N(in`ert ,deadj)"
in`equity	Suffix	"N(`equity ,)"
in`ertia	Suffix	"N(in`ertia ,)"
inevita`bility	Suffix	"N(`evitable ,deadj)"
inex`perience	Suffix	"N(ex`perience ,)"
`infamy	Suffix	"N(`infamy ,)"
`infancy	Suffix	"N(`infant ,)"
`infant	Suffix	"N(`infant ,)"
`infantry	Suffix	"N(`infantry ,)"
infe`licity	Suffix	"N(fe`licity ,)"
`inference	Suffix	"N(in`fer - irregular stress,deverb)"
in`ferno	Suffix	"N(in`ferno ,)"
`infidel	Suffix	"N(`infidel ,)"
infi`delity	Suffix	"N(fi`delity ,)"
`infield	Suffix	"N(`infield ,)"
in`finitive	Suffix	"N(in`finitive ,)"
in`finitude	Suffix	"N(in`finitude ,)"
in`finity	Suffix	"N(in`finity ,)"
in`firmary	Suffix	"N(in`firm ,deadj)"
`infix	Suffix	"N(`infix ,)"
inflam`mation	Suffix	"N(in`flame ,deverb)"
`inflow	Suffix	"N(`inflow ,)"
influ`enza	Suffix	"N(influ`enza ,)"
`influx	Suffix	"N(`influx ,)"
`info	Suffix	"N(`info ,)"
`infrastructure	Suffix	"N(`infrastructure ,)"
inge`nuity	Suffix	"N(inge`nuity ,)"
`ingot	Suffix	"N(`ingot ,)"
`ingrate	Suffix	"N(`ingrate ,)"
in`gratitude	Suffix	"N(`gratitude ,)"
in`gredient	Suffix	"N(in`gredient ,)"
inhospi`tality	Suffix	"N(hospi`tality ,)"
i`niquity	Suffix	"N(i`niquity ,)"
i`nitiative	Suffix	"N(i`nitiate ,deverb)"
in`junction	Suffix	"N(in`junction ,)"
`injury	Suffix	"N(`injure ,deverb)"
in`justice	Suffix	"N(`justice ,)"
`ink	Suffix	"N(`ink ,)"
`inkblot	Suffix	"N(`inkblot ,)"
`inkling	Suffix	"N(`inkling ,)"
`inkstand	Suffix	"N(`inkstand ,)"
`inkwell	Suffix	"N(`inkwell ,)"
`inlet	Suffix	"N(`inlet ,)"
`inmate	Suffix	"N(`inmate ,)"
`inn	Suffix	"N(`inn ,)"
`inning	Suffix	"N(`inning ,)"
`innkeeper	Suffix	"N(`innkeeper ,)"
`innocence	Suffix	"N(`innocent ,deadj)"
`innocency	Suffix	"N(`innocent ,deadj)"
`inquest	Suffix	"N(`inquest ,)"
`inquiry	Suffix	"N(in`quire ,deverb)"
inqui`sition	Suffix	"N(inqui`sition ,)"
in`quisitor	Suffix	"N(in`quisitor ,)"
`inroad	Suffix	"N(`inroad ,)"
in`scription	Suffix	"N(in`scribe ,deverb)"
`insect	Suffix	"N(`insect ,)"
`insert	Suffix	"N(`insert ,ss)"
`insight	Suffix	"N(`insight ,)"
`insolence	Suffix	"N(`insolent ,deadj)"
in`somnia	Suffix	"N(in`somnia ,)"
in`somniac	Suffix	"N(in`somniac ,)"
in`stallment	Suffix	"N(in`stall ,deverb)"
`instance	Suffix	"N(`instance ,)"
`instep	Suffix	"N(`instep ,)"
`instinct	Suffix	"N(`instinct ,)"
instrumen`tation	Suffix	"N(`instrument ,)"
insubordi`nation	Suffix	"N(sub`ordinate ,deadj)"
insuf`ficiency	Suffix	"N(suf`fice ,deverb+deajr)"
`insult	Suffix	"N(`insult ,ss)"
`insulin	Suffix	"N(`insulin ,)"
in`surgency	Suffix	"N(in`surgent ,deadj)"
insur`rection	Suffix	"N(insur`rection ,)"
`intake	Suffix	"N(`intake ,)"
`integer	Suffix	"N(`integer ,)"
in`tegrity	Suffix	"N(in`tegrity ,)"
in`tegument	Suffix	"N(in`tegument ,)"
`intellect	Suffix	"N(`intellect ,)"
intel`lectual	Suffix	"N(`intellect ,)"
in`telligence	Suffix	"N(in`telligent ,deadj)"
intelligi`bility	Suffix	"N(in`telligible ,deadj)"
in`temperance	Suffix	"N(`temperate ,deadj)"
in`tent	Suffix	"N(in`tent ,)"
in`tention	Suffix	"N(in`tend ,deverb)"
`intercom	Suffix	"N(`intercom ,)"
`interim	Suffix	"N(`interim ,)"
`interlude	Suffix	"N(`interlude ,)"
inter`mediary	Suffix	"N(inter`mediary ,)"
`intern	Suffix	"N(`intern ,)"
`interval	Suffix	"N(`interval ,)"
inter`vention	Suffix	"N(inter`vene ,deverb)"
in`testine	Suffix	"N(in`testine ,)"
`intimacy	Suffix	"N(`intimate ,deadj)"
in`toxicant	Suffix	"N(in`toxicate ,deverb)"
in`transigence	Suffix	"N(in`transigent ,deadj)"
`intricacy	Suffix	"N(`intricate ,deadj)"
`intrigue	Suffix	"N(`intrigue ,ss)"
intro`duction	Suffix	"N(intro`duce ,deverb)"
`introit	Suffix	"N(`introit ,)"
intro`version	Suffix	"N(`introvert ,deverb)"
in`trusion	Suffix	"N(in`trude ,deverb)"
`invalid	Suffix	"N(`invalid ,)"
in`vasion	Suffix	"N(in`vade ,deverb)"
in`vective	Suffix	"N(in`vective ,)"
in`version	Suffix	"N(in`vert ,deverb)"
in`vestiture	Suffix	"N(in`vestiture ,)"
in`veteracy	Suffix	"N(in`veterate ,deadj)"
`invoice	Suffix	"N(`invoice ,)"
invo`lution	Suffix	"N(invo`lution ,)"
`ire	Suffix	"N(`ire ,)"
`ironside	Suffix	"N(`ironside ,)"
`ironstone	Suffix	"N(`ironstone ,)"
`irony	Suffix	"N(`irony ,)"
ir`regular	Suffix	"N(`regular ,deverb)"
ir`relevancy	Suffix	"N(`relevant ,deadj)"
irrita`bility	Suffix	"N(`irritate ,deverb)"
`irritant	Suffix	"N(`irritate ,deverb)"
`isinglass	Suffix	"N(`isinglass ,)"
`island	Suffix	"N(`island ,)"
`islander	Suffix	"N(`island ,)"
`isle	Suffix	"N(`isle ,)"
`islet	Suffix	"N(`isle ,)"
`item	Suffix	"N(`item ,)"
i`tinerary	Suffix	"N(i`tinerary ,)"
`ivory	Suffix	"N(`ivory ,)"
`ivy	Suffix	"N(`ivy ,)"
`jack	Suffix	"N(`jack ,)"
`jackanapes	Suffix	"N(`jackanapes ,)"
`jackass	Suffix	"N(`jackass ,)"
`jackboot	Suffix	"N(`jackboot ,)"
`jacket	Suffix	"N(`jacket ,)"
`jackhammer	Suffix	"N(`jackhammer ,)"
`jackknife	Suffix	"N(`jackknife ,)"
`jackpot	Suffix	"N(`jackpot ,)"
`jade	Suffix	"N(`jade ,)"
`jailhouse	Suffix	"N(`jailhouse ,)"
ja`lopy	Suffix	"N(ja`lopy ,)"
jambo`ree	Suffix	"N(jambo`ree ,)"
`janitor	Suffix	"N(`janitor ,)"
`jar	Suffix	"N(`jar ,)"
`jarful	Suffix	"N(`jar ,)"
`jargon	Suffix	"N(`jargon ,)"
`jaundice	Suffix	"N(`jaundice ,)"
`jaunt	Suffix	"N(`jaunt ,)"
`javelin	Suffix	"N(`javelin ,)"
`jawbone	Suffix	"N(`jawbone ,)"
`jay	Suffix	"N(`jay ,)"
`jealousy	Suffix	"N(`jealous ,deadj)"
`jean	Suffix	"N(`jean ,)"
`jeep	Suffix	"N(`jeep ,)"
`jeopardy	Suffix	"N(`jeopardy ,)"
`jerk	Suffix	"N(`jerk - stupid fellow,)"
`jersey	Suffix	"N(`jersey ,)"
`jess	Suffix	"N(`jess ,)"
`jetliner	Suffix	"N(`jetliner ,)"
`jewel	Suffix	"N(`jewel ,ajr8)"
`jeweler	Suffix	"N(`jewel ,)"
`jeweller	Suffix	"N(`jewel ,)"
`jewelry	Suffix	"N(`jewel ,)"
`jib	Suffix	"N(`jib ,)"
`jiffy	Suffix	"N(`jiffy ,)"
`jigsaw	Suffix	"N(`jigsaw ,)"
ji`had	Suffix	"N(ji`had ,)"
`jimmy	Suffix	"N(`jimmy ,)"
`jitter	Suffix	"N(`jitter ,)"
`job	Suffix	"N(`job ,)"
`jobholder	Suffix	"N(`jobholder ,)"
`jock	Suffix	"N(`jock ,)"
`jockey	Suffix	"N(`jockey ,)"
`jockstrap	Suffix	"N(`jockstrap ,)"
`joint	Suffix	"N(`joint ,ajr8)"
`joist	Suffix	"N(`joist ,)"
`jollity	Suffix	"N(`jolly ,deadj)"
`jonquil	Suffix	"N(`jonquil ,)"
`joss	Suffix	"N(`joss ,)"
`journal	Suffix	"N(`journal ,)"
journal`ese	Suffix	"N(`journal ,)"
`jowl	Suffix	"N(`jowl ,ajr8)"
`joy	Suffix	"N(`joy ,)"
`joyride	Suffix	"N(`joyride ,)"
`joystick	Suffix	"N(`joystick ,)"
jubi`lee	Suffix	"N(jubi`lee ,)"
`judgment	Suffix	"N(`judge - exception to Elision,deverb)"
`judicatory	Suffix	"N(`judicatory ,)"
`judicature	Suffix	"N(`judicature ,)"
ju`diciary	Suffix	"N(ju`diciary ,)"
`judo	Suffix	"N(`judo ,)"
`jug	Suffix	"N(`jug ,)"
`jugful	Suffix	"N(`jug ,)"
`juice	Suffix	"N(`juice ,)"
`juju	Suffix	"N(`juju ,)"
`junction	Suffix	"N(`junction ,)"
`juncture	Suffix	"N(`juncture ,)"
`jungle	Suffix	"N(`jungle ,)"
`juniper	Suffix	"N(`juniper ,)"
`junta	Suffix	"N(`junta ,)"
juris`diction	Suffix	"N(juris`diction ,)"
juris`prudence	Suffix	"N(juris`prudence ,)"
juris`prudent	Suffix	"N(juris`prudent ,)"
`jurist	Suffix	"N(`jurist ,)"
`juror	Suffix	"N(`juror ,)"
`jury	Suffix	"N(`jury ,)"
`justice	Suffix	"N(`justice ,)"
`kaiser	Suffix	"N(`kaiser ,)"
ka`leidoscope	Suffix	"N(ka`leidoscope ,)"
kami`kaze	Suffix	"N(kami`kaze ,)"
`kaolin	Suffix	"N(`kaolin ,)"
ka`rate	Suffix	"N(ka`rate ,)"
`kayak	Suffix	"N(`kayak ,)"
ka`zoo	Suffix	"N(ka`zoo ,)"
`keg	Suffix	"N(`keg ,)"
`kelp	Suffix	"N(`kelp ,)"
`ken	Suffix	"N(`ken ,)"
`keno	Suffix	"N(`keno ,)"
`kerb	Suffix	"N(`kerb - British,)"
`kerchief	Suffix	"N(`kerchief ,)"
`kernel	Suffix	"N(`kernel ,)"
`kerosene	Suffix	"N(`kerosene ,)"
ke`rygma	Suffix	"N(ke`rygma ,)"
`ketch	Suffix	"N(`ketch ,)"
`ketchup	Suffix	"N(`ketchup ,)"
`kettle	Suffix	"N(`kettle ,)"
`keyhole	Suffix	"N(`keyhole ,)"
`keynote	Suffix	"N(`keynote ,)"
`keypunch	Suffix	"N(`keypunch ,)"
`keystone	Suffix	"N(`keystone ,)"
`keyword	Suffix	"N(`keyword ,)"
`khaki	Suffix	"N(`khaki ,)"
`khan	Suffix	"N(`khan ,)"
`kickback	Suffix	"N(`kickback ,)"
`kickoff	Suffix	"N(`kickoff ,)"
`kid	Suffix	"N(`kid ,)"
`kiddie	Suffix	"N(`kid ,)"
`kidney	Suffix	"N(`kidney ,)"
`killdeer	Suffix	"N(`killdeer ,)"
`killjoy	Suffix	"N(`killjoy ,)"
`kiln	Suffix	"N(`kiln ,)"
`kilo	Suffix	"N(`kilo ,)"
ki`mono	Suffix	"N(ki`mono ,)"
`kin	Suffix	"N(`kin ,)"
`kind	Suffix	"N(`kind ,)"
`kindergarten	Suffix	"N(`kindergarten ,)"
`kindred	Suffix	"N(`kindred ,)"
`king	Suffix	"N(`king ,)"
`kingpin	Suffix	"N(`kingpin ,)"
`kiosk	Suffix	"N(`kiosk ,)"
`kirk	Suffix	"N(`kirk ,)"
`kit	Suffix	"N(`kit ,)"
`kitchen	Suffix	"N(`kitchen ,)"
`kite	Suffix	"N(`kite ,)"
`kith	Suffix	"N(`kith ,)"
`kitten	Suffix	"N(`kitten ,)"
`kitty	Suffix	"N(`kitty ,)"
`klaxon	Suffix	"N(`klaxon ,)"
`kleenex	Suffix	"N(`kleenex ,)"
`knack	Suffix	"N(`knack ,)"
`knapsack	Suffix	"N(`knapsack ,)"
`knave	Suffix	"N(`knave ,)"
`knee	Suffix	"N(`knee ,)"
`kneecap	Suffix	"N(`kneecap ,)"
`knell	Suffix	"N(`knell ,)"
`knick-knack	Suffix	"N(`knick-knack ,)"
`knob	Suffix	"N(`knob ,ajr8)"
`knockout	Suffix	"N(`knockout ,)"
`knoll	Suffix	"N(`knoll ,)"
`knowhow	Suffix	"N(`knowhow ,)"
`knowledge	Suffix	"N(`knowledge ,)"
`knuckle	Suffix	"N(`knuckle ,)"
`knuckleball	Suffix	"N(`knuckleball ,)"
`knurl	Suffix	"N(`knurl ,ajr8)"
`kraft	Suffix	"N(`kraft ,)"
`kraut	Suffix	"N(`kraut ,)"
`kremlin	Suffix	"N(`kremlin ,)"
`kudo	Suffix	"N(`kudo ,)"
kwashi`orkor	Suffix	"N(kwashi`orkor ,)"
`lab	Suffix	"N(`lab - laboratory,)"
`laboratory	Suffix	"N(`laboratory ,)"
`labyrinth	Suffix	"N(`labyrinth ,)"
`lackey	Suffix	"N(`lackey ,)"
la`crosse	Suffix	"N(la`crosse ,)"
`lad	Suffix	"N(`lad ,)"
`ladder	Suffix	"N(`ladder ,)"
`ladleful	Suffix	"N(`ladle ,)"
`lady	Suffix	"N(`lady ,)"
`lager	Suffix	"N(`lager ,)"
la`goon	Suffix	"N(la`goon ,)"
`lair	Suffix	"N(`lair ,)"
laissez-`faire	Suffix	"N(laissez-`faire ,)"
`laity	Suffix	"N(`laity ,)"
`lake	Suffix	"N(`lake ,)"
`lakeside	Suffix	"N(`lakeside ,)"
`lamb	Suffix	"N(`lamb ,)"
`lamp	Suffix	"N(`lamp ,)"
`lampblack	Suffix	"N(`lampblack ,)"
`lamplight	Suffix	"N(`lamplight ,)"
`lamprey	Suffix	"N(`lamprey ,)"
`landau	Suffix	"N(`landau ,)"
`landfill	Suffix	"N(`landfill ,)"
`landlady	Suffix	"N(`landlady ,)"
`landlord	Suffix	"N(`landlord ,)"
`landmark	Suffix	"N(`landmark ,)"
`landslide	Suffix	"N(`landslide ,)"
`lane	Suffix	"N(`lane ,)"
`language	Suffix	"N(`language ,)"
`languor	Suffix	"N(`languor ,)"
`lantern	Suffix	"N(`lantern ,)"
`lanyard	Suffix	"N(`lanyard ,)"
`lap	Suffix	"N(`lap ,)"
la`pel	Suffix	"N(la`pel ,ajr8)"
`lapful	Suffix	"N(`lap ,)"
`lapidary	Suffix	"N(`lapidary ,)"
`lappet	Suffix	"N(`lappet ,)"
`laptop	Suffix	"N(`laptop ,)"
`larboard	Suffix	"N(`larboard ,)"
`larceny	Suffix	"N(`larceny ,)"
`larch	Suffix	"N(`larch ,)"
`larder	Suffix	"N(`larder ,)"
`largemouth	Suffix	"N(`largemouth ,)"
lar`gesse	Suffix	"N(lar`gesse ,)"
`lariat	Suffix	"N(`lariat ,)"
`lark	Suffix	"N(`lark ,)"
laryn`gitis	Suffix	"N(`larynx ,)"
la`sagna	Suffix	"N(la`sagna ,)"
`laser	Suffix	"N(`laser ,)"
`lass	Suffix	"N(`lass ,)"
`lassitude	Suffix	"N(`lassitude ,)"
`latchet	Suffix	"N(`latchet ,)"
`latency	Suffix	"N(`latent ,deadj)"
`latex	Suffix	"N(`latex ,)"
`lath	Suffix	"N(`lath ,)"
`lathing	Suffix	"N(`lath ,)"
`latitude	Suffix	"N(`latitude ,)"
la`trine	Suffix	"N(la`trine ,)"
`lattice	Suffix	"N(`lattice ,)"
`laughingstock	Suffix	"N(`laughingstock ,)"
`laughter	Suffix	"N(`laughter ,)"
`laundromat	Suffix	"N(`laundromat ,)"
`laundry	Suffix	"N(`laundry ,)"
`laureate	Suffix	"N(`laureate ,)"
`lava	Suffix	"N(`lava ,)"
la`vabo	Suffix	"N(la`vabo ,)"
`lavatory	Suffix	"N(`lavatory ,)"
`law	Suffix	"N(`law ,)"
`lawn	Suffix	"N(`lawn ,)"
`lawsuit	Suffix	"N(`lawsuit ,)"
`lawyer	Suffix	"N(`lawyer ,)"
lay`ette	Suffix	"N(lay`ette ,)"
`layoff	Suffix	"N(`layoff ,)"
`layout	Suffix	"N(`layout ,)"
`layup	Suffix	"N(`layup ,)"
`lea	Suffix	"N(`lea ,)"
`lead	Suffix	"N(`lead ,ajr8)"
`league	Suffix	"N(`league ,)"
`leather	Suffix	"N(`leather ,)"
`leatherback	Suffix	"N(`leatherback ,)"
`leatherneck	Suffix	"N(`leatherneck ,)"
`leatherwork	Suffix	"N(`leatherwork ,)"
`lecher	Suffix	"N(`lecher ,)"
`lechery	Suffix	"N(`lechery ,)"
`lectern	Suffix	"N(`lectern ,)"
`lectionary	Suffix	"N(`lectionary ,)"
`ledge	Suffix	"N(`ledge ,)"
`ledger	Suffix	"N(`ledger ,)"
`lee	Suffix	"N(`lee ,)"
`leeway	Suffix	"N(`leeway ,)"
`lefty	Suffix	"N(`lefty ,)"
`leg	Suffix	"N(`leg ,ajr8)"
`legacy	Suffix	"N(`legate ,)"
`legate	Suffix	"N(`legate ,)"
`legend	Suffix	"N(`legend ,)"
`legerdemain	Suffix	"N(`legerdemain ,)"
`legging	Suffix	"N(`leg ,)"
legi`bility	Suffix	"N(`legible ,deadj)"
`legion	Suffix	"N(`legion ,)"
`legislature	Suffix	"N(`legislate ,deverb)"
legitimacy	Suffix	"N(le`gitimate ,deadj)"
le`gume	Suffix	"N(le`gume ,)"
`leisure	Suffix	"N(`leisure ,)"
`leitmotif	Suffix	"N(`leitmotif ,)"
`leitmotiv	Suffix	"N(`leitmotiv ,)"
`lemma	Suffix	"N(`lemma ,)"
`lemon	Suffix	"N(`lemon ,)"
lemo`nade	Suffix	"N(`lemon ,)"
`length	Suffix	"N(`long ,deadj)"
`lenience	Suffix	"N(`lenient ,deadj)"
`leniency	Suffix	"N(`lenient ,deadj)"
`lens	Suffix	"N(`lens ,)"
`lentil	Suffix	"N(`lentil ,)"
`leotard	Suffix	"N(`leotard ,)"
`leper	Suffix	"N(`leper ,)"
`leprosy	Suffix	"N(`leprosy ,)"
`lesion	Suffix	"N(`lesion ,)"
les`see	Suffix	"N(`lease ,deverb)"
`lesson	Suffix	"N(`lesson ,)"
les`sor	Suffix	"N(`lease ,deverb)"
`lethargy	Suffix	"N(`lethargy ,)"
`letterhead	Suffix	"N(`letterhead ,)"
`lettering	Suffix	"N(`letter ,)"
`lettuce	Suffix	"N(`lettuce ,)"
leu`kemia	Suffix	"N(leu`kemia ,)"
`levee	Suffix	"N(`levee ,)"
`level	Suffix	"N(`level ,)"
`lever	Suffix	"N(`lever ,)"
le`viathan	Suffix	"N(le`viathan ,)"
`levity	Suffix	"N(`levity ,)"
`lexicon	Suffix	"N(`lexicon ,)"
lia`bility	Suffix	"N(`liable ,deadj)"
li`aison	Suffix	"N(li`aison ,)"
`liar	Suffix	"N(`lie ,deverb)"
li`bation	Suffix	"N(li`bation ,)"
`libertine	Suffix	"N(`libertine ,)"
`liberty	Suffix	"N(`liberty ,)"
li`bido	Suffix	"N(li`bido ,)"
`library	Suffix	"N(`library ,)"
li`brettist	Suffix	"N(li`bretto ,)"
`licorice	Suffix	"N(`licorice ,)"
`lid	Suffix	"N(`lid ,)"
`lien	Suffix	"N(`lien ,)"
`lieu	Suffix	"N(`lieu ,)"
lieu`tenant	Suffix	"N(lieu`tenant ,)"
`lifeblood	Suffix	"N(`lifeblood ,)"
`lifeboat	Suffix	"N(`lifeboat ,)"
`lifeguard	Suffix	"N(`lifeguard ,)"
`lifespan	Suffix	"N(`lifespan ,)"
`lifestyle	Suffix	"N(`lifestyle ,)"
`lifetime	Suffix	"N(`lifetime ,)"
`liftoff	Suffix	"N(`liftoff ,)"
`ligament	Suffix	"N(`ligament ,)"
`ligature	Suffix	"N(`ligature ,)"
`lightface	Suffix	"N(`lightface ,)"
`lighthouse	Suffix	"N(`lighthouse ,)"
`lightning	Suffix	"N(`lightning ,)"
`likelihood	Suffix	"N(`likely ,deadj)"
`lilac	Suffix	"N(`lilac ,)"
`lily	Suffix	"N(`lily ,)"
`limb	Suffix	"N(`limb ,)"
`limbo	Suffix	"N(`limbo ,)"
`lime	Suffix	"N(`lime ,)"
`limelight	Suffix	"N(`limelight ,)"
`limestone	Suffix	"N(`limestone ,)"
`limousine	Suffix	"N(`limousine ,)"
`lineage	Suffix	"N(`lineage ,)"
`linebacker	Suffix	"N(`linebacker ,)"
`linen	Suffix	"N(`linen ,)"
`lineup	Suffix	"N(`lineup ,)"
linge`rie	Suffix	"N(linge`rie ,)"
`linguist	Suffix	"N(`linguist ,)"
`liniment	Suffix	"N(`liniment ,)"
li`noleum	Suffix	"N(li`noleum ,)"
`lint	Suffix	"N(`lint ,)"
`lip	Suffix	"N(`lip ,)"
`lipstick	Suffix	"N(`lipstick ,)"
lique`faction	Suffix	"N(`liquid ,deverb)"
li`queur	Suffix	"N(li`queur ,)"
`liquor	Suffix	"N(`liquor ,)"
`lisle	Suffix	"N(`lisle ,)"
`litany	Suffix	"N(`litany ,)"
`liter	Suffix	"N(`liter ,)"
`literacy	Suffix	"N(`literate ,deadj)"
`literature	Suffix	"N(`literature ,)"
`lithium	Suffix	"N(`lithium ,)"
`lithograph	Suffix	"N(`lithograph ,)"
li`thography	Suffix	"N(li`thography ,)"
`litigant	Suffix	"N(`litigate ,deverb)"
`litmus	Suffix	"N(`litmus ,)"
`litre	Suffix	"N(`litre ,)"
`litterbug	Suffix	"N(`litterbug ,)"
`littleneck	Suffix	"N(`littleneck ,)"
`liturgy	Suffix	"N(`liturgy ,)"
`livelihood	Suffix	"N(`livelihood ,)"
`livery	Suffix	"N(`livery ,)"
`loam	Suffix	"N(`loam ,)"
`loanword	Suffix	"N(`loanword ,)"
`lobby	Suffix	"N(`lobby ,)"
`lobe	Suffix	"N(`lobe ,)"
`loblolly	Suffix	"N(`loblolly ,)"
`lobule	Suffix	"N(`lobule ,)"
lo`cale	Suffix	"N(lo`cale ,)"
`locative	Suffix	"N(`locate ,deverb)"
`locket	Suffix	"N(`locket ,)"
`locknut	Suffix	"N(`locknut ,)"
`lockout	Suffix	"N(`lockout ,)"
`locksmith	Suffix	"N(`locksmith ,)"
`lockstep	Suffix	"N(`lockstep ,)"
`lockup	Suffix	"N(`lockup ,)"
loco`motive	Suffix	"N(loco`motive ,)"
lo`cution	Suffix	"N(lo`cution ,)"
`locutor	Suffix	"N(`locutor ,)"
`lodestone	Suffix	"N(`lodestone ,)"
`lodgepole	Suffix	"N(`lodgepole ,)"
`loess	Suffix	"N(`loess ,)"
`loft	Suffix	"N(`loft ,)"
`loge	Suffix	"N(`loge ,)"
`loggerhead	Suffix	"N(`loggerhead ,)"
`logic	Suffix	"N(`logic ,)"
`logjam	Suffix	"N(`logjam ,)"
`logo	Suffix	"N(`logo ,)"
`loin	Suffix	"N(`loin ,)"
`loincloth	Suffix	"N(`loincloth ,)"
`lollipop	Suffix	"N(`lollipop ,)"
`loner	Suffix	"N(`loner ,)"
lon`gevity	Suffix	"N(lon`gevity ,)"
`longhand	Suffix	"N(`longhand ,)"
`longitude	Suffix	"N(`longitude ,)"
`lookout	Suffix	"N(`lookout ,)"
`lookup	Suffix	"N(`lookup ,)"
`loom	Suffix	"N(`loom ,)"
`loon	Suffix	"N(`loon ,)"
`loophole	Suffix	"N(`loophole ,)"
`loosestrife	Suffix	"N(`loosestrife ,)"
lo`quacity	Suffix	"N(lo`quacity ,)"
`lore	Suffix	"N(`lore ,)"
`lory	Suffix	"N(`lory ,)"
`lorry	Suffix	"N(`lorry ,)"
`loss	Suffix	"N(`loss ,)"
`lot	Suffix	"N(`lot ,)"
lo`thario	Suffix	"N(lo`thario ,)"
`lotion	Suffix	"N(`lotion ,)"
`lottery	Suffix	"N(`lottery ,)"
`loudspeaker	Suffix	"N(`loudspeaker ,)"
`lout	Suffix	"N(`lout ,)"
`lovebird	Suffix	"N(`lovebird ,)"
`lowboy	Suffix	"N(`lowboy ,)"
`lowdown	Suffix	"N(`lowdown ,)"
`lowland	Suffix	"N(`lowland ,)"
`loyalty	Suffix	"N(`loyal ,deadj)"
`lozenge	Suffix	"N(`lozenge ,)"
`lubber	Suffix	"N(`lubber ,)"
`lubricant	Suffix	"N(`lubricate ,deverb)"
lu`bricity	Suffix	"N(lu`bricity ,)"
`luck	Suffix	"N(`luck ,)"
`lucre	Suffix	"N(`lucre ,)"
`luge	Suffix	"N(`luge ,)"
`lull	Suffix	"N(`lull ,)"
`lullaby	Suffix	"N(`lullaby ,)"
`lulu	Suffix	"N(`lulu ,)"
`lumber	Suffix	"N(`lumber ,)"
`lumen	Suffix	"N(`lumen ,)"
`luminance	Suffix	"N(`luminance ,)"
`luminary	Suffix	"N(`luminary ,)"
lumi`nosity	Suffix	"N(lumi`nosity ,)"
`lummox	Suffix	"N(`lummox ,)"
`lunacy	Suffix	"N(`lunacy ,)"
`lunatic	Suffix	"N(`lunatic ,)"
`luncheon	Suffix	"N(`luncheon ,)"
`lunchroom	Suffix	"N(`lunchroom ,)"
`lunchtime	Suffix	"N(`lunchtime ,)"
`lung	Suffix	"N(`lung ,)"
`lutanist	Suffix	"N(`lute ,)"
`lute	Suffix	"N(`lute ,)"
`luxury	Suffix	"N(`luxury ,)"
`lye	Suffix	"N(`lye ,)"
`lymph	Suffix	"N(`lymph ,)"
`ma	Suffix	"N(`ma ,)"
`ma'am	Suffix	"N(`ma'am ,)"
`mac	Suffix	"N(`mac ,)"
machi`nation	Suffix	"N(machi`nation ,)"
ma`chine	Suffix	"N(ma`chine ,)"
ma`chinery	Suffix	"N(ma`chine ,)"
ma`chismo	Suffix	"N(ma`chismo ,)"
`macintosh	Suffix	"N(`macintosh ,)"
`mackinaw	Suffix	"N(`mackinaw ,)"
`mackintosh	Suffix	"N(`mackintosh ,)"
`macrame	Suffix	"N(`macrame ,)"
`macro	Suffix	"N(`macro ,)"
`madhouse	Suffix	"N(`madhouse ,)"
ma`donna	Suffix	"N(ma`donna ,)"
`madrigal	Suffix	"N(`madrigal ,)"
`maelstrom	Suffix	"N(`maelstrom ,)"
`magazine	Suffix	"N(`magazine ,)"
`maggot	Suffix	"N(`maggot ,)"
`magistrate	Suffix	"N(`magistrate ,)"
`magma	Suffix	"N(`magma ,)"
magna`nimity	Suffix	"N(magna`nimity ,)"
`magnate	Suffix	"N(`magnate ,)"
`magnet	Suffix	"N(`magnet ,)"
magnifi`cation	Suffix	"N(`magnify ,deverb)"
mag`nificence	Suffix	"N(mag`nificent ,deadj)"
mag`niloquence	Suffix	"N(mag`niloquent ,deadj)"
`magnitude	Suffix	"N(`magnitude ,)"
`magnum	Suffix	"N(`magnum ,)"
maha`raja	Suffix	"N(maha`raja ,)"
`maid	Suffix	"N(`maid ,)"
`maiden	Suffix	"N(`maiden ,)"
`maidservant	Suffix	"N(`maidservant ,)"
`mailbox	Suffix	"N(`mailbox ,)"
`mainland	Suffix	"N(`mainland ,)"
`mainsail	Suffix	"N(`mainsail ,)"
`mainstay	Suffix	"N(`mainstay ,)"
`mainstream	Suffix	"N(`mainstream ,)"
`maintenance	Suffix	"N(main`tain ,deverb)"
`maize	Suffix	"N(`maize ,)"
`majesty	Suffix	"N(`majesty ,)"
`makeup	Suffix	"N(`makeup ,)"
`malady	Suffix	"N(`malady ,)"
ma`laise	Suffix	"N(ma`laise ,)"
`malaprop	Suffix	"N(`malaprop ,)"
ma`laria	Suffix	"N(ma`laria ,)"
mal`conduct	Suffix	"N(`conduct ,)"
malcon`tent	Suffix	"N(con`tent ,deadj)"
`malefactor	Suffix	"N(`malefactor ,)"
mal`feasance	Suffix	"N(mal`feasance ,)"
`malice	Suffix	"N(`malice ,)"
ma`lignancy	Suffix	"N(ma`lignant ,deadj)"
ma`lignity	Suffix	"N(ma`lign ,deverb)"
`mall	Suffix	"N(`mall ,)"
mallea`bility	Suffix	"N(`malleable ,deadj)"
`mallet	Suffix	"N(`mallet ,)"
`mallow	Suffix	"N(`mallow ,)"
malnu`trition	Suffix	"N(nu`trition ,)"
maloc`clusion	Suffix	"N(oc`clude ,deverb)"
mal`odor	Suffix	"N(`odor ,)"
malpo`sition	Suffix	"N(po`sition ,deverb)"
mal`practice	Suffix	"N(`practice ,deverb)"
`mambo	Suffix	"N(`mambo ,)"
`mammal	Suffix	"N(`mammal ,)"
`mammon	Suffix	"N(`mammon ,)"
`mandarin	Suffix	"N(`mandarin ,)"
`mandible	Suffix	"N(`mandible ,)"
`mandrel	Suffix	"N(`mandrel ,)"
`mane	Suffix	"N(`mane ,ajr8)"
`mange	Suffix	"N(`mange ,)"
`manger	Suffix	"N(`manger ,)"
`manhole	Suffix	"N(`manhole ,)"
`mania	Suffix	"N(`mania ,)"
`maniac	Suffix	"N(`maniac ,)"
`manikin	Suffix	"N(`manikin ,)"
`manna	Suffix	"N(`manna ,)"
`mannequin	Suffix	"N(`mannequin ,)"
`manner	Suffix	"N(`manner ,ajr8)"
`mannikin	Suffix	"N(`mannikin ,)"
`manor	Suffix	"N(`manor ,)"
`manpower	Suffix	"N(`manpower ,)"
`manse	Suffix	"N(`manse ,)"
`manservant	Suffix	"N(`manservant ,)"
`mansion	Suffix	"N(`mansion ,)"
`manslaughter	Suffix	"N(`manslaughter ,)"
`mantel	Suffix	"N(`mantel ,)"
`mantle	Suffix	"N(`mantle ,)"
`mantelpiece	Suffix	"N(`mantelpiece ,)"
`mantrap	Suffix	"N(`mantrap ,)"
`manual	Suffix	"N(`manual ,)"
manu`mission	Suffix	"N(manu`mit ,deverb)"
ma`nure	Suffix	"N(ma`nure ,)"
`manuscript	Suffix	"N(`manuscript ,)"
manza`nita	Suffix	"N(manza`nita ,)"
`maple	Suffix	"N(`maple ,)"
`marathon	Suffix	"N(`marathon ,)"
`marble	Suffix	"N(`marble ,)"
`margarine	Suffix	"N(`margarine ,)"
`margin	Suffix	"N(`margin ,)"
mari`juana	Suffix	"N(mari`juana ,)"
ma`rimba	Suffix	"N(ma`rimba ,)"
ma`rina	Suffix	"N(ma`rina ,)"
`marinade	Suffix	"N(`marinade ,)"
ma`rine	Suffix	"N(ma`rine ,)"
`mariner	Suffix	"N(`mariner ,)"
mario`nette	Suffix	"N(mario`nette ,)"
`marketplace	Suffix	"N(`marketplace ,)"
`marlin	Suffix	"N(`marlin ,)"
`marmalade	Suffix	"N(`marmalade ,)"
mar`quee	Suffix	"N(mar`quee ,)"
`marquess	Suffix	"N(`marquess ,)"
mar`quis	Suffix	"N(mar`quis ,)"
mar`quise	Suffix	"N(mar`quise ,)"
`marrow	Suffix	"N(`marrow ,)"
`marrowbone	Suffix	"N(`marrowbone ,)"
`marsh	Suffix	"N(`marsh ,)"
`marshal	Suffix	"N(`marshal ,)"
`marshland	Suffix	"N(`marshland ,)"
`marshmallow	Suffix	"N(`marshmallow ,)"
`mart	Suffix	"N(`mart ,)"
mar`tini	Suffix	"N(mar`tini ,)"
mas`cara	Suffix	"N(mas`cara ,)"
`masochism	Suffix	"N(`masochism ,)"
`masochist	Suffix	"N(`masochist ,)"
`mason	Suffix	"N(`mason ,)"
`masonry	Suffix	"N(`mason ,)"
`masque	Suffix	"N(`masque ,)"
mas`seur	Suffix	"N(mas`seur ,)"
`massif	Suffix	"N(`massif ,)"
`mast	Suffix	"N(`mast ,)"
`masterpiece	Suffix	"N(`masterpiece ,)"
`mastery	Suffix	"N(`mastery ,)"
`mastiff	Suffix	"N(`mastiff ,)"
`match	Suffix	"N(`match ,)"
`matchbook	Suffix	"N(`matchbook ,)"
`mater	Suffix	"N(`mater ,)"
ma`terial	Suffix	"N(ma`terial ,)"
materi`el	Suffix	"N(materi`el ,)"
ma`ternity	Suffix	"N(ma`ternity ,)"
`math	Suffix	"N(`math ,)"
mati`nee	Suffix	"N(mati`nee ,)"
`matins	Suffix	"N(`matins ,)"
`matriarch	Suffix	"N(`matriarch ,)"
`matriarchs	Suffix	"N(`matriarch - exception to Epenthesis,pl irreg)"
`matrimony	Suffix	"N(`matrimony ,)"
`matron	Suffix	"N(`matron ,)"
`matte	Suffix	"N(`matte ,)"
`matter	Suffix	"N(`matter ,)"
`mattock	Suffix	"N(`mattock ,)"
`mattress	Suffix	"N(`mattress ,)"
mauso`leum	Suffix	"N(mauso`leum ,)"
`maverick	Suffix	"N(`maverick ,)"
`maw	Suffix	"N(`maw ,)"
`maxim	Suffix	"N(`maxim ,)"
`mayhem	Suffix	"N(`mayhem ,)"
`mayonnaise	Suffix	"N(`mayonnaise ,)"
`mayor	Suffix	"N(`mayor ,)"
`maze	Suffix	"N(`maze ,)"
ma`zurka	Suffix	"N(ma`zurka ,)"
`mead	Suffix	"N(`mead ,)"
`meadow	Suffix	"N(`meadow ,)"
`meadowland	Suffix	"N(`meadowland ,)"
`meal	Suffix	"N(`meal ,)"
`mealtime	Suffix	"N(`mealtime ,)"
`meantime	Suffix	"N(`meantime ,)"
`measle	Suffix	"N(`measle ,)"
`meat	Suffix	"N(`meat ,)"
me`chanic	Suffix	"N(me`chanic ,)"
`mechanism	Suffix	"N(`mechanism ,)"
`mechanist	Suffix	"N(`mechanist ,)"
`medal	Suffix	"N(`medal ,)"
me`dallion	Suffix	"N(me`dallion ,)"
`medic	Suffix	"N(`medic ,)"
`medicine	Suffix	"N(`medicine ,)"
`medico	Suffix	"N(`medico ,)"
`medium	Suffix	"N(`medium - spirit medium,)"
`medley	Suffix	"N(`medley ,)"
`meetinghouse	Suffix	"N(`meetinghouse ,)"
megalo`mania	Suffix	"N(megalo`mania ,)"
megalo`maniac	Suffix	"N(megalo`maniac ,)"
me`lange	Suffix	"N(me`lange ,)"
`melanin	Suffix	"N(`melanin ,)"
me`lee	Suffix	"N(me`lee ,)"
`melodrama	Suffix	"N(`melodrama ,)"
`melody	Suffix	"N(`melody ,)"
`melon	Suffix	"N(`melon ,)"
`meltdown	Suffix	"N(`meltdown ,)"
`meltwater	Suffix	"N(`meltwater ,)"
`member	Suffix	"N(`member ,)"
`membrane	Suffix	"N(`membrane ,)"
`memo	Suffix	"N(`memo ,)"
`memoir	Suffix	"N(`memoir ,)"
me`morial	Suffix	"N(me`morial ,)"
`memory	Suffix	"N(`memory ,)"
me`nagerie	Suffix	"N(me`nagerie ,)"
`menarche	Suffix	"N(`menarche ,)"
men`dacity	Suffix	"N(men`dacity ,)"
men`dicament	Suffix	"N(men`dicament ,)"
`menopause	Suffix	"N(`menopause ,)"
mensu`ration	Suffix	"N(mensu`ration ,)"
`menswear	Suffix	"N(`menswear ,)"
`mentor	Suffix	"N(`mentor ,)"
`menu	Suffix	"N(`menu ,)"
`mercenary	Suffix	"N(`mercenary ,)"
`mercer	Suffix	"N(`mercer ,)"
`merchandise	Suffix	"N(`merchandise ,)"
`merchant	Suffix	"N(`merchant ,)"
`mercury	Suffix	"N(`mercury ,)"
`mercy	Suffix	"N(`mercy ,)"
mer`ganser	Suffix	"N(mer`ganser ,)"
me`ridian	Suffix	"N(me`ridian ,)"
me`ringue	Suffix	"N(me`ringue ,)"
`merlin	Suffix	"N(`merlin ,)"
`mermaid	Suffix	"N(`mermaid ,)"
`mesa	Suffix	"N(`mesa ,)"
`mesh	Suffix	"N(`mesh ,)"
`message	Suffix	"N(`message ,)"
`messenger	Suffix	"N(`messenger ,)"
`messmate	Suffix	"N(`messmate ,)"
mes`siah	Suffix	"N(mes`siah ,)"
me`tabolism	Suffix	"N(me`tabolism ,)"
`metal	Suffix	"N(`metal ,)"
`metalwork	Suffix	"N(`metalwork ,)"
meta`morphism	Suffix	"N(meta`morphism ,)"
meta`morphosis	Suffix	"N(meta`morphosis ,)"
`metaphor	Suffix	"N(`metaphor ,)"
me`tathesis	Suffix	"N(me`tathesis ,)"
`meteor	Suffix	"N(`meteor ,)"
`meteorite	Suffix	"N(`meteorite ,)"
`meter	Suffix	"N(`meter ,)"
`method	Suffix	"N(`method ,)"
`methyl	Suffix	"N(`methyl ,)"
`metier	Suffix	"N(`metier ,)"
`metre	Suffix	"N(`metre ,)"
`metronome	Suffix	"N(`metronome ,)"
met`ropolis	Suffix	"N(met`ropolis ,)"
`mettle	Suffix	"N(`mettle ,)"
`mezzanine	Suffix	"N(`mezzanine ,)"
mi`asma	Suffix	"N(mi`asma ,)"
`mica	Suffix	"N(`mica ,)"
`microbe	Suffix	"N(`microbe ,)"
`microcosm	Suffix	"N(`microcosm ,)"
`micron	Suffix	"N(`micron ,)"
`microscope	Suffix	"N(`microscope ,)"
`middleweight	Suffix	"N(`middleweight ,)"
`midriff	Suffix	"N(`midriff ,)"
`midst	Suffix	"N(`midst ,)"
mid`wifery	Suffix	"N(`midwife ,)"
`mien	Suffix	"N(`mien ,)"
`might	Suffix	"N(`might ,)"
mig`non	Suffix	"N(mig`non ,)"
`migrant	Suffix	"N(`migrate ,deverb)"
`mike	Suffix	"N(`mike - microphone,)"
`mile	Suffix	"N(`mile ,)"
`mileage	Suffix	"N(`mile ,)"
`milestone	Suffix	"N(`milestone ,)"
`militarism	Suffix	"N(`military ,)"
`militarist	Suffix	"N(`military ,)"
mi`litia	Suffix	"N(mi`litia ,)"
`milliner	Suffix	"N(`milliner ,)"
`millinery	Suffix	"N(`millinery ,)"
million`aire	Suffix	"N(million`aire ,)"
`millstone	Suffix	"N(`millstone ,)"
mi`lord	Suffix	"N(mi`lord ,)"
`milt	Suffix	"N(`milt ,)"
mi`mesis	Suffix	"N(mi`mesis ,)"
`mimicker	Suffix	"N(`mimic ,deverb)"
mina`ret	Suffix	"N(mina`ret ,)"
`mincemeat	Suffix	"N(`mincemeat ,)"
`mind	Suffix	"N(`mind ,)"
`minefield	Suffix	"N(`minefield ,)"
`mineral	Suffix	"N(`mineral ,)"
mine`strone	Suffix	"N(mine`strone ,)"
`minesweeper	Suffix	"N(`minesweeper ,)"
`minicomputer	Suffix	"N(com`pute ,deverb)"
`minim	Suffix	"N(`minim ,)"
`minimax	Suffix	"N(`minimax ,)"
`minion	Suffix	"N(`minion ,)"
minis`tration	Suffix	"N(`minister ,deverb)"
`ministry	Suffix	"N(`minister ,deverb)"
`mink	Suffix	"N(`mink ,)"
`minstrel	Suffix	"N(`minstrel ,)"
`minstrelsy	Suffix	"N(`minstrelsy ,)"
`mint	Suffix	"N(`mint ,)"
minu`et	Suffix	"N(minu`et ,)"
`minus	Suffix	"N(`minus ,)"
`minute	Suffix	"N(`minute ,)"
`miracle	Suffix	"N(`miracle ,)"
mi`rage	Suffix	"N(mi`rage ,)"
`mirth	Suffix	"N(`mirth ,)"
misad`venture	Suffix	"N(ad`venture ,)"
`misanthrope	Suffix	"N(`misanthrope ,)"
miscege`nation	Suffix	"N(miscege`nation ,)"
`miscellany	Suffix	"N(`miscellany ,)"
`mischief	Suffix	"N(`mischief ,)"
`miscreant	Suffix	"N(`miscreant ,)"
`miser	Suffix	"N(`miser ,)"
`misery	Suffix	"N(`misery ,)"
mis`fortune	Suffix	"N(`fortune ,)"
`mishap	Suffix	"N(`mishap ,)"
mis`nomer	Suffix	"N(mis`nomer ,)"
`misprint	Suffix	"N(`print ,ss)"
`miss	Suffix	"N(`miss ,)"
`missile	Suffix	"N(`missile ,)"
`mission	Suffix	"N(`mission ,)"
`missionary	Suffix	"N(`mission ,)"
`missive	Suffix	"N(`missive ,)"
`missus	Suffix	"N(`missus ,)"
`mist	Suffix	"N(`mist ,)"
`mister	Suffix	"N(`mister ,)"
`mistress	Suffix	"N(`mistress ,)"
mis`trust	Suffix	"N(`trust ,)"
`mite	Suffix	"N(`mite ,)"
`mitre	Suffix	"N(`mitre ,)"
`mitt	Suffix	"N(`mitt ,)"
`mitten	Suffix	"N(`mitten ,)"
`mixture	Suffix	"N(`mix ,deverb)"
`mixup	Suffix	"N(`mixup ,)"
`moat	Suffix	"N(`moat ,)"
`moccasin	Suffix	"N(`moccasin ,)"
`mockery	Suffix	"N(`mock ,deverb)"
`mockup	Suffix	"N(`mockup ,)"
`mode	Suffix	"N(`mode ,)"
`modem	Suffix	"N(`modem ,)"
`moderacy	Suffix	"N(`moderate ,deadj)"
moderation	Suffix	"N(`moderate ,deadj)"
`modesty	Suffix	"N(`modest ,deadj)"
`modicum	Suffix	"N(`modicum ,)"
`module	Suffix	"N(`module ,)"
`mogul	Suffix	"N(`mogul ,)"
`moisture	Suffix	"N(`moist ,deadj)"
`molar	Suffix	"N(`molar ,)"
mo`lasses	Suffix	"N(mo`lasses ,)"
`moldboard	Suffix	"N(`moldboard ,)"
`molding	Suffix	"N(`molding ,)"
`mole	Suffix	"N(`mole ,)"
`molecule	Suffix	"N(`molecule ,)"
`molehill	Suffix	"N(`molehill ,)"
`moment	Suffix	"N(`moment ,)"
mo`mento	Suffix	"N(mo`mento ,)"
`mommy	Suffix	"N(`mommy ,)"
`monad	Suffix	"N(`monad ,)"
`monarch	Suffix	"N(`monarch ,)"
`monarchs	Suffix	"N(`monarch ,pl irreg)"
`monarchy	Suffix	"N(`monarch ,)"
`monastery	Suffix	"N(`monastery ,)"
`monetarism	Suffix	"N(`monetarism ,)"
`monetarist	Suffix	"N(`monetarist ,)"
`monetary	Suffix	"N(`monetary ,)"
`mongrel	Suffix	"N(`mongrel ,)"
`moniker	Suffix	"N(`moniker ,)"
`monicker	Suffix	"N(`monicker ,)"
`monism	Suffix	"N(`monism ,)"
`monk	Suffix	"N(`monk ,)"
`monolith	Suffix	"N(`monolith ,)"
`monologue	Suffix	"N(`monologue ,)"
`monolog	Suffix	"N(`monolog ,)"
mo`nopolist	Suffix	"N(mo`nopoly ,)"
mo`nopoly	Suffix	"N(mo`nopoly ,)"
mon`soon	Suffix	"N(mon`soon ,)"
`monster	Suffix	"N(`monster ,)"
mon`strosity	Suffix	"N(`monster ,)"
mon`tage	Suffix	"N(mon`tage ,)"
`monte	Suffix	"N(`monte ,)"
`month	Suffix	"N(`month , ajr13)"
`monument	Suffix	"N(`monument ,)"
`mood	Suffix	"N(`mood ,)"
`moon	Suffix	"N(`moon ,)"
`moonlight	Suffix	"N(`moonlight ,)"
`moor	Suffix	"N(`moor ,)"
mo`raine	Suffix	"N(mo`raine ,)"
mo`rale	Suffix	"N(mo`rale ,)"
mo`rass	Suffix	"N(mo`rass ,)"
`morgen	Suffix	"N(`morgen ,)"
`morgue	Suffix	"N(`morgue ,)"
`morning	Suffix	"N(`morning ,)"
`moron	Suffix	"N(`moron ,)"
`morph	Suffix	"N(`morph ,)"
`morpheme	Suffix	"N(`morpheme ,)"
morpho`phoneme	Suffix	"N(morpho`phoneme ,)"
morpho`syntax	Suffix	"N(morpho`syntax ,)"
`morris	Suffix	"N(`morris ,)"
`morrow	Suffix	"N(`morrow ,)"
`morsel	Suffix	"N(`morsel ,)"
`mortar	Suffix	"N(`mortar ,)"
mortgag`or	Suffix	"N(mortgag`or - exception to Elision,)"
mortifi`cation	Suffix	"N(`mortify ,deverb)"
mor`tician	Suffix	"N(mor`tician ,)"
`mortise	Suffix	"N(`mortise ,)"
`mortuary	Suffix	"N(`mortuary ,)"
`mosaic	Suffix	"N(`mosaic ,)"
`mosque	Suffix	"N(`mosque ,)"
`moss	Suffix	"N(`moss ,)"
`mot	Suffix	"N(`mot ,)"
`mote	Suffix	"N(`mote ,)"
mo`tel	Suffix	"N(mo`tel ,)"
mo`tet	Suffix	"N(mo`tet ,)"
`moth	Suffix	"N(`moth ,)"
`mothball	Suffix	"N(`mothball ,)"
`motherland	Suffix	"N(`motherland ,)"
mo`tif	Suffix	"N(mo`tif ,)"
`motive	Suffix	"N(`motive ,)"
`motor	Suffix	"N(`motor ,)"
`motorcycle	Suffix	"N(`motorcycle ,)"
`moue	Suffix	"N(`moue ,)"
`mound	Suffix	"N(`mound ,)"
`mountain	Suffix	"N(`mountain ,)"
`mountainside	Suffix	"N(`mountainside ,)"
`mountaintop	Suffix	"N(`mountaintop ,)"
`mousetrap	Suffix	"N(`mousetrap ,)"
`moustache	Suffix	"N(`moustache ,)"
`mouthful	Suffix	"N(`mouth ,)"
`mouthpiece	Suffix	"N(`mouthpiece ,)"
`movie	Suffix	"N(`movie ,)"
`mucilage	Suffix	"N(`mucilage ,)"
`muck	Suffix	"N(`muck ,)"
`mucus	Suffix	"N(`mucus ,)"
`mud	Suffix	"N(`mud ,)"
`mudguard	Suffix	"N(`mudguard ,)"
`muff	Suffix	"N(`muff ,)"
`muffin	Suffix	"N(`muffin ,)"
`mug	Suffix	"N(`mug ,)"
`mule	Suffix	"N(`mule ,)"
`mullah	Suffix	"N(`mullah ,)"
`mulligan	Suffix	"N(`mulligan ,)"
mulliga`tawny	Suffix	"N(mulliga`tawny ,)"
`multiplicand	Suffix	"N(`multiplicand ,)"
multipli`cation	Suffix	"N(`multiply ,deverb)"
multi`plicity	Suffix	"N(`multiple ,deadj)"
`multitude	Suffix	"N(`multitude ,)"
`mummery	Suffix	"N(`mummery ,)"
`mummy	Suffix	"N(`mummy ,)"
mummifi`cation	Suffix	"N(`mummy ,deverb)"
`mung	Suffix	"N(`mung ,)"
mu`nition	Suffix	"N(mu`nition ,)"
`mural	Suffix	"N(`mural ,)"
`murk	Suffix	"N(`murk ,)"
`muscle	Suffix	"N(`muscle ,ajr8)"
`musculature	Suffix	"N(`muscle ,)"
mu`seum	Suffix	"N(mu`seum ,)"
`mush	Suffix	"N(`mush ,)"
`music	Suffix	"N(`music ,)"
`musical	Suffix	"N(`music ,)"
musi`cale	Suffix	"N(musi`cale ,)"
`musk	Suffix	"N(`musk ,)"
`musket	Suffix	"N(`musket ,)"
`muslin	Suffix	"N(`muslin ,)"
`mussel	Suffix	"N(`mussel ,)"
`mustache	Suffix	"N(`mustache ,ajr8)"
mus`tachio	Suffix	"N(mus`tachio ,)"
`mustang	Suffix	"N(`mustang ,)"
`mustard	Suffix	"N(`mustard ,)"
muta`bility	Suffix	"N(`mutable ,deadj)"
`mutagen	Suffix	"N(`mutagen ,)"
muti`neer	Suffix	"N(`mutiny ,)"
`mutt	Suffix	"N(`mutt ,)"
`mutton	Suffix	"N(`mutton ,)"
`mutuel	Suffix	"N(`mutuel ,)"
`mylar	Suffix	"N(`mylar ,)"
my`opia	Suffix	"N(my`opia ,)"
`myriad	Suffix	"N(`myriad ,)"
`myrrh	Suffix	"N(`myrrh ,)"
`myrtle	Suffix	"N(`myrtle ,)"
`mystery	Suffix	"N(`mystery ,)"
`mystic	Suffix	"N(`mystic ,)"
mystifi`cation	Suffix	"N(`mystify ,deverb)"
mys`tique	Suffix	"N(mys`tique ,)"
`myth	Suffix	"N(`myth ,)"
`nabob	Suffix	"N(`nabob ,)"
`nacre	Suffix	"N(`nacre ,)"
`nadir	Suffix	"N(`nadir ,)"
naive`te	Suffix	"N(naive`te ,)"
na`ivety	Suffix	"N(na`ive ,deadj)"
`nameplate	Suffix	"N(`nameplate ,)"
`namesake	Suffix	"N(`namesake ,)"
`napalm	Suffix	"N(`napalm ,)"
`nape	Suffix	"N(`nape ,)"
`napkin	Suffix	"N(`napkin ,)"
`narcissism	Suffix	"N(`narcissism ,)"
`narcissist	Suffix	"N(`narcissist ,)"
nar`cissus	Suffix	"N(nar`cissus ,)"
`narrative	Suffix	"N(`narrate ,deverb)"
`nation	Suffix	"N(`nation ,)"
`national	Suffix	"N(`nation ,)"
na`tivity	Suffix	"N(na`tivity ,)"
`nature	Suffix	"N(`nature ,ajr8)"
`naught	Suffix	"N(`naught ,)"
`nausea	Suffix	"N(`nausea ,)"
`nautilus	Suffix	"N(`nautilus ,)"
`nave	Suffix	"N(`nave ,)"
`navel	Suffix	"N(`navel ,)"
ne`cessity	Suffix	"N(ne`cessity ,)"
`neck	Suffix	"N(`neck ,)"
`necklace	Suffix	"N(`necklace ,)"
`neckline	Suffix	"N(`neckline ,)"
`necktie	Suffix	"N(`necktie ,)"
`necromancer	Suffix	"N(`necromancer ,)"
`necromancy	Suffix	"N(`necromancy ,)"
ne`crosis	Suffix	"N(ne`crosis ,)"
`nectar	Suffix	"N(`nectar ,)"
`nectary	Suffix	"N(`nectary ,)"
`needlepoint	Suffix	"N(`needlepoint ,)"
`needlework	Suffix	"N(`needlework ,)"
`negligee	Suffix	"N(`negligee ,)"
`negligence	Suffix	"N(`negligent ,deadj)"
negotia`bility	Suffix	"N(ne`gotiate ,deverb+deajr)"
ne`ologism	Suffix	"N(ne`ologism ,)"
`neon	Suffix	"N(`neon ,)"
`neonate	Suffix	"N(`neonate ,)"
`neophyte	Suffix	"N(`neophyte ,)"
ne`penthe	Suffix	"N(ne`penthe ,)"
`nephew	Suffix	"N(`nephew ,)"
`nepotism	Suffix	"N(`nepotism ,)"
`netherworld	Suffix	"N(`netherworld ,)"
neu`ralgia	Suffix	"N(neu`ralgia ,)"
neu`ritis	Suffix	"N(neu`ritis ,)"
`neuron	Suffix	"N(`neuron ,)"
neu`trino	Suffix	"N(neu`trino ,)"
`neutron	Suffix	"N(`neutron ,)"
`newcomer	Suffix	"N(come ,deverb)"
`newel	Suffix	"N(`newel ,)"
`newlywed	Suffix	"N(`newlywed ,)"
`news	Suffix	"N(`news ,)"
`newsboy	Suffix	"N(`newsboy ,)"
`newscast	Suffix	"N(`newscast ,)"
`newscaster	Suffix	"N(`newscaster ,)"
`newsletter	Suffix	"N(`newsletter ,)"
`newspaper	Suffix	"N(`newspaper ,)"
`newsreel	Suffix	"N(`newsreel ,)"
`newsstand	Suffix	"N(`newsstand ,)"
`newswire	Suffix	"N(`newswire ,)"
`nib	Suffix	"N(`nib ,)"
`nicety	Suffix	"N(`nice ,deadj)"
`niche	Suffix	"N(`niche ,)"
`nickel	Suffix	"N(`nickel ,)"
`nicotine	Suffix	"N(`nicotine ,)"
`niece	Suffix	"N(`niece ,)"
`niggard	Suffix	"N(`niggard ,)"
`nigger	Suffix	"N(`nigger ,)"
`night	Suffix	"N(`night ,)"
`nightcap	Suffix	"N(`nightcap ,)"
`nightclub	Suffix	"N(`nightclub ,)"
`nightdress	Suffix	"N(`nightdress ,)"
`nightfall	Suffix	"N(`nightfall ,)"
`nightgown	Suffix	"N(`nightgown ,)"
`nighthawk	Suffix	"N(`nighthawk ,)"
`nightingale	Suffix	"N(`nightingale ,)"
`nightmare	Suffix	"N(`nightmare ,)"
`nightshirt	Suffix	"N(`nightshirt ,)"
`nightstick	Suffix	"N(`nightstick ,)"
`nighttime	Suffix	"N(`nighttime ,)"
`nihilism	Suffix	"N(`nihilism ,)"
`nihilist	Suffix	"N(`nihilist ,)"
`nil	Suffix	"N(`nil ,)"
`nipple	Suffix	"N(`nipple ,)"
nir`vana	Suffix	"N(nir`vana ,)"
`nit	Suffix	"N(`nit ,)"
nitty-`gritty	Suffix	"N(nitty-`gritty ,)"
`nob	Suffix	"N(`nob ,)"
no`bility	Suffix	"N(`noble ,deadj)"
no`blesse	Suffix	"N(no`blesse ,)"
`nobody	Suffix	"N(`nobody ,)"
`nocturne	Suffix	"N(`nocturne ,)"
`node	Suffix	"N(`node ,)"
`nodule	Suffix	"N(`nodule ,)"
`noise	Suffix	"N(`noise ,)"
`nomad	Suffix	"N(`nomad ,)"
no`menclature	Suffix	"N(no`menclature ,)"
nomi`nee	Suffix	"N(nomi`nee ,)"
nonage`narian	Suffix	"N(nonage`narian ,)"
`nonce	Suffix	"N(`nonce ,)"
noncha`lance	Suffix	"N(noncha`lant ,deadj)"
`noodle	Suffix	"N(`noodle ,)"
`nook	Suffix	"N(`nook ,)"
`noon	Suffix	"N(`noon ,)"
`noontime	Suffix	"N(`noontime ,)"
`noose	Suffix	"N(`noose ,)"
nor'`easter	Suffix	"N(nor'`easter ,)"
`norm	Suffix	"N(`norm ,)"
`normalcy	Suffix	"N(`norm ,)"
north`easter	Suffix	"N(north`easter ,)"
`northerner	Suffix	"N(`northerner ,)"
`northland	Suffix	"N(`northland ,)"
`nose	Suffix	"N(`nose ,ajr8)"
`nosebag	Suffix	"N(`nosebag ,)"
`nosebleed	Suffix	"N(`nosebleed ,)"
`nosegay	Suffix	"N(`nosegay ,)"
nos`talgia	Suffix	"N(nos`talgia ,)"
`nostril	Suffix	"N(`nostril ,)"
`notary	Suffix	"N(`notary ,)"
`notebook	Suffix	"N(`notebook ,)"
`notion	Suffix	"N(`notion ,)"
`nothingness	Suffix	"N(`nothingness ,)"
noto`riety	Suffix	"N(noto`riety ,)"
`nought	Suffix	"N(`nought - var. of naught,)"
`noun	Suffix	"N(`noun ,)"
`novel	Suffix	"N(`novel ,)"
`novelty	Suffix	"N(`novel ,deadj)"
`novice	Suffix	"N(`novice ,)"
no`vitiate	Suffix	"N(no`vitiate ,)"
`nozzle	Suffix	"N(`nozzle ,)"
`nuance	Suffix	"N(`nuance ,ajr8)"
`nucleon	Suffix	"N(`nucleon ,)"
`nugget	Suffix	"N(`nugget ,)"
`nuisance	Suffix	"N(`nuisance ,)"
numera`bility	Suffix	"N(`numerate ,deverb+deajr)"
`numeral	Suffix	"N(`numeral ,)"
nu`mismatist	Suffix	"N(nu`mismatist ,)"
`nun	Suffix	"N(`nun ,)"
`nunnery	Suffix	"N(`nun ,)"
`nursery	Suffix	"N(`nursery ,)"
`nursemaid	Suffix	"N(`nursemaid ,)"
`nut	Suffix	"N(`nut ,)"
`nutcracker	Suffix	"N(`nutcracker ,)"
`nutmeg	Suffix	"N(`nutmeg ,)"
`nutrient	Suffix	"N(`nutrient ,)"
nu`trition	Suffix	"N(nu`trition ,)"
`nutshell	Suffix	"N(`nutshell ,)"
`nylon	Suffix	"N(`nylon ,)"
`nymph	Suffix	"N(`nymph ,)"
nympho`mania	Suffix	"N(nympho`mania ,)"
nympho`maniac	Suffix	"N(nympho`maniac ,)"
`oaf	Suffix	"N(`oaf ,)"
`oak	Suffix	"N(`oak ,)"
`oar	Suffix	"N(`oar ,)"
`oat	Suffix	"N(`oat ,)"
`oath	Suffix	"N(`oath ,)"
`oatmeal	Suffix	"N(`oatmeal ,)"
`obduracy	Suffix	"N(`obdurate ,deadj)"
o`bedience	Suffix	"N(o`bey ,deverb+deajr)"
o`beisance	Suffix	"N(o`beisance ,)"
`obelisk	Suffix	"N(`obelisk ,)"
o`bituary	Suffix	"N(o`bituary ,)"
`object	Suffix	"N(`object ,)"
objectiona`bility	Suffix	"N(ob`ject ,deverb+deajr)"
ob`jective	Suffix	"N(ob`jective ,)"
`oblate	Suffix	"N(`oblate ,)"
ob`livion	Suffix	"N(ob`livion ,)"
`oblong	Suffix	"N(`oblong ,)"
`oboe	Suffix	"N(`oboe ,)"
`oboist	Suffix	"N(`oboe ,)"
ob`servatory	Suffix	"N(ob`serve ,deverb)"
ob`sidian	Suffix	"N(ob`sidian ,)"
obso`lescence	Suffix	"N(obso`lescent ,deadj)"
`obstacle	Suffix	"N(`obstacle ,)"
`obstinacy	Suffix	"N(`obstinate ,deadj)"
ob`trusion	Suffix	"N(ob`trude ,deverb)"
`occident	Suffix	"N(`occident ,)"
occi`dental	Suffix	"N(`occident ,)"
oc`clusion	Suffix	"N(oc`clude ,deverb)"
occul`tation	Suffix	"N(oc`cult ,deadj)"
`occupancy	Suffix	"N(`occupy ,deverb)"
`occupant	Suffix	"N(`occupy ,deverb)"
occu`pation	Suffix	"N(`occupy ,deverb)"
`ocean	Suffix	"N(`ocean ,)"
`oceanfront	Suffix	"N(`oceanfront ,)"
`oceanside	Suffix	"N(`oceanside ,)"
`ocelot	Suffix	"N(`ocelot ,)"
`octagon	Suffix	"N(`octagon ,)"
`octave	Suffix	"N(`octave ,)"
oc`tavo	Suffix	"N(oc`tavo ,)"
oc`tet	Suffix	"N(oc`tet ,)"
octo`genarian	Suffix	"N(octo`genarian ,)"
`ode	Suffix	"N(`ode ,)"
`odium	Suffix	"N(`odium ,)"
o`dometer	Suffix	"N(o`dometer ,)"
`odor	Suffix	"N(`odor ,)"
`odour	Suffix	"N(`odour - British,)"
`odyssey	Suffix	"N(`odyssey ,)"
`offal	Suffix	"N(`offal ,)"
of`fence	Suffix	"N(of`fence ,)"
of`fense	Suffix	"N(of`fense ,)"
`offertory	Suffix	"N(`offertory ,)"
`office	Suffix	"N(`office ,)"
`officeholder	Suffix	"N(`officeholder ,)"
`officemate	Suffix	"N(`officemate ,)"
`officer	Suffix	"N(`officer ,)"
of`ficial	Suffix	"N(of`ficial ,)"
`offing	Suffix	"N(`offing ,)"
`offprint	Suffix	"N(`offprint ,)"
`offset	Suffix	"N(`offset ,)"
`offshoot	Suffix	"N(`offshoot ,)"
`ogre	Suffix	"N(`ogre ,)"
`oilcloth	Suffix	"N(`oilcloth ,)"
`oilfield	Suffix	"N(`oilfield ,)"
`oilseed	Suffix	"N(`oilseed ,)"
`ointment	Suffix	"N(`ointment ,)"
`oldy	Suffix	"N(`old ,deadj)"
oleo`margarine	Suffix	"N(oleo`margarine ,)"
`oligarch	Suffix	"N(`oligarch ,)"
`oligarchy	Suffix	"N(`oligarchy ,)"
oli`gopoly	Suffix	"N(oli`gopoly ,)"
`olive	Suffix	"N(`olive ,)"
o`lympiad	Suffix	"N(o`lympiad ,)"
`omelet	Suffix	"N(`omelet ,)"
`omelette	Suffix	"N(`omelette ,)"
`omen	Suffix	"N(`omen ,)"
o`mission	Suffix	"N(o`mit ,deverb)"
`omnibus	Suffix	"N(`omnibus ,)"
om`niscience	Suffix	"N(om`niscient ,deadj)"
`omnivore	Suffix	"N(`omnivore ,)"
`oneness	Suffix	"N(`one ,)"
one`upmanship	Suffix	"N(one`upmanship ,)"
`onion	Suffix	"N(`onion ,)"
`onlooker	Suffix	"N(`onlooker ,)"
onomato`poeia	Suffix	"N(onomato`poeia ,)"
`onrush	Suffix	"N(`onrush ,)"
`onset	Suffix	"N(`onset ,)"
`onslaught	Suffix	"N(`onslaught ,)"
`onus	Suffix	"N(`onus ,)"
`onyx	Suffix	"N(`onyx ,)"
o`pacity	Suffix	"N(o`paque ,deadj)"
`opal	Suffix	"N(`opal ,)"
`opera	Suffix	"N(`opera ,)"
opera`bility	Suffix	"N(`operate ,deverb+deajr)"
`operand	Suffix	"N(`operand ,)"
`operative	Suffix	"N(`operate ,deverb)"
oper`etta	Suffix	"N(oper`etta ,)"
`opiate	Suffix	"N(`opiate ,)"
`opium	Suffix	"N(`opium ,)"
op`ponent	Suffix	"N(op`ponent ,)"
op`probrium	Suffix	"N(op`probrium ,)"
`optimism	Suffix	"N(`optimism ,)"
`optimist	Suffix	"N(`optimist ,)"
`option	Suffix	"N(`option ,)"
`opulence	Suffix	"N(`opulent ,deadj)"
`oracle	Suffix	"N(`oracle ,)"
ora`torio	Suffix	"N(ora`torio ,)"
`oratory	Suffix	"N(`oratory ,)"
`orchard	Suffix	"N(`orchard ,)"
`orchestra	Suffix	"N(`orchestra ,)"
or`deal	Suffix	"N(or`deal ,)"
`ordinance	Suffix	"N(`ordinance ,)"
`ordinand	Suffix	"N(`ordinand ,)"
`ordinate	Suffix	"N(`ordinate ,)"
ordi`nation	Suffix	"N(or`dain ,deverb)"
`ordnance	Suffix	"N(`ordnance ,)"
`ore	Suffix	"N(`ore ,)"
o`regano	Suffix	"N(o`regano ,)"
`organ	Suffix	"N(`organ ,)"
`organdy	Suffix	"N(`organdy ,)"
`organism	Suffix	"N(`organism ,)"
`orgasm	Suffix	"N(`orgasm ,)"
`orgy	Suffix	"N(`orgy ,)"
`orient	Suffix	"N(`orient ,)"
`orifice	Suffix	"N(`orifice ,)"
`origin	Suffix	"N(`origin ,)"
o`riginal	Suffix	"N(`origin ,)"
`ornament	Suffix	"N(`ornament ,ajr8)"
ornamen`tation	Suffix	"N(ornamen`tation ,)"
`orphanage	Suffix	"N(`orphan ,)"
ortho`dontist	Suffix	"N(ortho`dontist ,)"
`orthodoxy	Suffix	"N(`orthodoxy ,)"
os`mosis	Suffix	"N(os`mosis ,)"
`osprey	Suffix	"N(`osprey ,)"
ossifi`cation	Suffix	"N(`ossify ,deverb)"
osten`tation	Suffix	"N(osten`tation ,)"
`ostracism	Suffix	"N(`ostracize ,deverb)"
`other	Infl	"N(`other ,)"
`otherworld	Suffix	"N(`otherworld ,)"
`ottoman	Suffix	"N(`ottoman ,)"
`ounce	Suffix	"N(`ounce ,)"
out`doors	Clitic	"N(out`doors - singular,)"
`outfit	Suffix	"N(`outfit ,)"
`outgrowth	Suffix	"N(`outgrowth ,)"
`outing	Suffix	"N(`outing ,)"
`outside	Suffix	"N(`outside ,)"
out`sider	Suffix	"N(out`side ,)"
`outskirt	Suffix	"N(`outskirt ,)"
out`spokenness	Suffix	"N(`speak ,deadj)"
`ovary	Suffix	"N(`ovary ,)"
o`vation	Suffix	"N(o`vation ,)"
`oven	Suffix	"N(`oven ,)"
`overall	Suffix	"N(`overall ,)"
`overhang	Suffix	"N(`overhang ,)"
`overnight	Suffix	"N(`overnight ,)"
`overture	Suffix	"N(`overture ,)"
`oxcart	Suffix	"N(`oxcart ,)"
oxi`dation	Suffix	"N(`oxidize ,deverb)"
`oxide	Suffix	"N(`oxide ,)"
`oxygen	Suffix	"N(`oxygen ,)"
oxy`moron	Suffix	"N(oxy`moron ,)"
`oyster	Suffix	"N(`oyster ,)"
`ozone	Suffix	"N(`ozone ,)"
`pa	Suffix	"N(`pa ,)"
`pacifism	Suffix	"N(`pacifism ,)"
`pacifist	Suffix	"N(`pacifist ,)"
`pack	Suffix	"N(`pack ,)"
`packet	Suffix	"N(`packet ,)"
`pact	Suffix	"N(`pact ,)"
`padding	Suffix	"N(`pad ,)"
`paddock	Suffix	"N(`paddock ,)"
`paddy	Suffix	"N(`paddy ,)"
`padre	Suffix	"N(`padre ,)"
`paean	Suffix	"N(`paean ,)"
`pageant	Suffix	"N(`pageant ,)"
`pageantry	Suffix	"N(`pageant ,)"
pa`goda	Suffix	"N(pa`goda ,)"
`pail	Suffix	"N(`pail ,)"
`pailful	Suffix	"N(`pail ,)"
`paintbrush	Suffix	"N(`paintbrush ,)"
`pal	Suffix	"N(`pal ,)"
`palace	Suffix	"N(`palace ,)"
palata`bility	Suffix	"N(`palatable ,deadj)"
`palate	Suffix	"N(`palate ,)"
`palette	Suffix	"N(`palette ,)"
`palimony	Suffix	"N(`palimony ,)"
`palindrome	Suffix	"N(`palindrome ,)"
`palisade	Suffix	"N(`palisade ,)"
`pall	Suffix	"N(`pall ,)"
`pallet	Suffix	"N(`pallet ,)"
palo`mino	Suffix	"N(palo`mino ,)"
palpa`bility	Suffix	"N(`palpable ,deadj)"
`pamphlet	Suffix	"N(`pamphlet ,)"
pana`cea	Suffix	"N(pana`cea ,)"
`panama	Suffix	"N(`panama ,)"
`pancake	Suffix	"N(`pancake ,)"
`pancreas	Suffix	"N(`pancreas ,)"
`panda	Suffix	"N(`panda ,)"
pande`monium	Suffix	"N(pande`monium ,)"
`pane	Suffix	"N(`pane ,)"
`paneling	Suffix	"N(`panel ,)"
`panful	Suffix	"N(`pan ,)"
`pang	Suffix	"N(`pang ,)"
`panoply	Suffix	"N(`panoply ,)"
pano`rama	Suffix	"N(pano`rama ,)"
`pansy	Suffix	"N(`pansy ,)"
panta`loon	Suffix	"N(panta`loon ,)"
`pantheism	Suffix	"N(`pantheism ,)"
`pantheist	Suffix	"N(`pantheist ,)"
`pantheon	Suffix	"N(`pantheon ,)"
`pantomime	Suffix	"N(`pantomime ,)"
`pantry	Suffix	"N(`pantry ,)"
`panty	Suffix	"N(`panty ,)"
`pap	Suffix	"N(`pap ,)"
`papa	Suffix	"N(`papa ,)"
`papacy	Suffix	"N(`pope ,)"
`papal	Suffix	"N(`pope ,)"
`paperback	Suffix	"N(`paperback ,)"
`paperweight	Suffix	"N(`paperweight ,)"
`paperwork	Suffix	"N(`paperwork ,)"
pa`poose	Suffix	"N(pa`poose ,)"
`pappy	Suffix	"N(`pappy ,)"
pap`rika	Suffix	"N(pap`rika ,)"
`par	Suffix	"N(`par ,)"
`parable	Suffix	"N(`parable ,)"
pa`rabola	Suffix	"N(pa`rabola ,)"
pa`raboloid	Suffix	"N(pa`raboloid ,)"
`paradigm	Suffix	"N(`paradigm ,)"
`paradise	Suffix	"N(`paradise ,)"
`paradox	Suffix	"N(`paradox ,)"
`paraffin	Suffix	"N(`paraffin ,)"
`paragon	Suffix	"N(`paragon ,)"
`parakeet	Suffix	"N(`parakeet ,)"
`parallax	Suffix	"N(`parallax ,)"
paral`lelogram	Suffix	"N(paral`lelogram ,)"
para`lytic	Suffix	"N(para`lytic ,)"
pa`rameter	Suffix	"N(pa`rameter ,)"
`paramour	Suffix	"N(`paramour ,)"
para`noia	Suffix	"N(para`noia ,)"
`parapet	Suffix	"N(`parapet ,)"
para`plegic	Suffix	"N(para`plegic ,)"
`parasite	Suffix	"N(`parasite ,)"
`parasol	Suffix	"N(`parasol ,)"
pare`goric	Suffix	"N(pare`goric ,)"
`parentage	Suffix	"N(`parent ,)"
pari-`mutuel	Suffix	"N(pari-`mutuel ,)"
pari`mutuel	Suffix	"N(pari`mutuel ,)"
pa`riah	Suffix	"N(pa`riah ,)"
`parish	Suffix	"N(`parish ,)"
pa`rishioner	Suffix	"N(pa`rishioner ,)"
`parity	Suffix	"N(`parity ,)"
`parkland	Suffix	"N(`parkland ,)"
`parkway	Suffix	"N(`parkway ,)"
`parlance	Suffix	"N(`parlance ,)"
`parliament	Suffix	"N(`parliament ,)"
`parlor	Suffix	"N(`parlor ,)"
`parlour	Suffix	"N(`parlour - British,)"
par`oxysm	Suffix	"N(par`oxysm ,)"
par`quet	Suffix	"N(par`quet ,)"
`parsimony	Suffix	"N(`parsimony ,)"
`parsley	Suffix	"N(`parsley ,)"
`parsnip	Suffix	"N(`parsnip ,)"
`parson	Suffix	"N(`parson ,)"
`parsonage	Suffix	"N(`parson ,)"
par`ticipant	Suffix	"N(par`ticipate ,deverb)"
`participle	Suffix	"N(`participle ,)"
`particle	Suffix	"N(`particle ,)"
`partisan	Suffix	"N(`partisan ,)"
`pasha	Suffix	"N(`pasha ,)"
`passage	Suffix	"N(`passage ,)"
`passageway	Suffix	"N(`passageway ,)"
`passband	Suffix	"N(`passband ,)"
`passenger	Suffix	"N(`passenger ,)"
`passion	Suffix	"N(`passion ,)"
`passport	Suffix	"N(`passport ,)"
`password	Suffix	"N(`password ,)"
`pasta	Suffix	"N(`pasta ,)"
`pasteboard	Suffix	"N(`pasteboard ,)"
pas`tel	Suffix	"N(pas`tel ,)"
`pasteup	Suffix	"N(`pasteup ,)"
pas`tiche	Suffix	"N(pas`tiche ,)"
`pastime	Suffix	"N(`pastime ,)"
`pastor	Suffix	"N(`pastor ,)"
`pastry	Suffix	"N(`pastry ,)"
`pasture	Suffix	"N(`pasture ,)"
`patchwork	Suffix	"N(`patchwork ,)"
`pate	Suffix	"N(`pate ,)"
`pater	Suffix	"N(`pater ,)"
pa`ternity	Suffix	"N(pa`ternity ,)"
pater`noster	Suffix	"N(pater`noster ,)"
`path	Suffix	"N(`path ,)"
`pathogen	Suffix	"N(`pathogen ,)"
patho`genesis	Suffix	"N(patho`genesis ,)"
`pathos	Suffix	"N(`pathos ,)"
`pathway	Suffix	"N(`pathway ,)"
`patience	Suffix	"N(`patient ,deadj)"
`patient	Suffix	"N(`patient ,)"
pa`tina	Suffix	"N(pa`tina ,)"
`patio	Suffix	"N(`patio ,)"
`patriarch	Suffix	"N(`patriarch ,)"
`patriarchs	Suffix	"N(`patriarch ,pl irreg)"
`patriarchy	Suffix	"N(`patriarchy ,)"
pa`trician	Suffix	"N(pa`trician ,)"
`patrimony	Suffix	"N(`patrimony ,)"
`patriot	Suffix	"N(`patriot ,)"
`patron	Suffix	"N(`patron ,)"
`patronage	Suffix	"N(`patron ,)"
`patty	Suffix	"N(`patty ,)"
`paucity	Suffix	"N(`paucity ,)"
`paunch	Suffix	"N(`paunch ,)"
`pauper	Suffix	"N(`pauper ,)"
pa`vanne	Suffix	"N(pa`vanne ,)"
`pawn	Suffix	"N(`pawn ,)"
`pawnshop	Suffix	"N(`pawnshop ,)"
`pax	Suffix	"N(`pax ,)"
`paycheck	Suffix	"N(`paycheck ,)"
`payday	Suffix	"N(`payday ,)"
`payload	Suffix	"N(`payload ,)"
`paymaster	Suffix	"N(`paymaster ,)"
`payoff	Suffix	"N(`payoff ,)"
`payroll	Suffix	"N(`payroll ,)"
`pea	Suffix	"N(`pea ,)"
`peace	Suffix	"N(`peace ,)"
`peacetime	Suffix	"N(`peacetime ,)"
`peach	Suffix	"N(`peach ,)"
`peacock	Suffix	"N(`peacock ,)"
`peafowl	Suffix	"N(`peafowl ,)"
`peanut	Suffix	"N(`peanut ,)"
`pear	Suffix	"N(`pear ,)"
`pearl	Suffix	"N(`pearl ,)"
`peasant	Suffix	"N(`peasant ,)"
`peasantry	Suffix	"N(`peasant ,)"
`peat	Suffix	"N(`peat ,)"
`pebble	Suffix	"N(`pebble ,ajr8)"
pe`can	Suffix	"N(pe`can ,)"
`peck	Suffix	"N(`peck - dry measure,)"
`pedagogue	Suffix	"N(`pedagogue ,)"
`pedant	Suffix	"N(`pedant ,)"
`pedantry	Suffix	"N(`pedant ,)"
`pedestal	Suffix	"N(`pedestal ,)"
pe`destrian	Suffix	"N(pe`destrian ,)"
`pedigree	Suffix	"N(`pedigree ,ajr8)"
`pediment	Suffix	"N(`pediment ,)"
`peephole	Suffix	"N(`peephole ,)"
`peer	Suffix	"N(`peer ,)"
`peeve	Suffix	"N(`peeve ,)"
`pegboard	Suffix	"N(`pegboard ,)"
pel`lagra	Suffix	"N(pel`lagra ,)"
`pellet	Suffix	"N(`pellet ,)"
`peltry	Suffix	"N(`peltry ,)"
`pelvis	Suffix	"N(`pelvis ,)"
`pemmican	Suffix	"N(`pemmican ,)"
`penalty	Suffix	"N(`penalty ,)"
`penance	Suffix	"N(`penance ,)"
`penchant	Suffix	"N(`penchant ,)"
`pendant	Suffix	"N(`pendant ,)"
`pendulum	Suffix	"N(`pendulum ,)"
penetra`bility	Suffix	"N(`penetrate ,deverb+deajr)"
`penguin	Suffix	"N(`penguin ,)"
peni`cillin	Suffix	"N(peni`cillin ,)"
pe`ninsula	Suffix	"N(pe`ninsula ,)"
`penis	Suffix	"N(`penis ,)"
`penitence	Suffix	"N(`penitent ,deadj)"
peni`tentiary	Suffix	"N(peni`tentiary ,)"
`pennant	Suffix	"N(`pennant ,)"
penny`royal	Suffix	"N(penny`royal ,)"
`pennyworth	Suffix	"N(`pennyworth ,)"
`pentagon	Suffix	"N(`pentagon ,)"
`pentagram	Suffix	"N(`pentagram ,)"
`penthouse	Suffix	"N(`penthouse ,)"
`penult	Suffix	"N(`penult ,)"
pe`nultima	Suffix	"N(pe`nultima ,)"
`penury	Suffix	"N(`penury ,)"
`peppermint	Suffix	"N(`peppermint ,)"
pepper`oni	Suffix	"N(pepper`oni ,)"
per`cent	Suffix	"N(per`cent ,)"
per`centage	Suffix	"N(per`cent ,)"
per`centile	Suffix	"N(per`centile ,)"
`percept	Suffix	"N(`percept ,)"
percepti`bility	Suffix	"N(per`ceive ,deverb+deajr)"
per`ception	Suffix	"N(per`ceive ,deverb)"
per`cipience	Suffix	"N(per`cipient ,deadj)"
per`dition	Suffix	"N(per`dition ,)"
peres`troika	Suffix	"N(peres`troika ,)"
`perfidy	Suffix	"N(`perfidy ,)"
per`fumery	Suffix	"N(per`fume ,)"
pe`rimeter	Suffix	"N(pe`rimeter ,)"
`period	Suffix	"N(`period ,)"
peri`odical	Suffix	"N(`period ,)"
pe`riphery	Suffix	"N(pe`riphery ,)"
`periscope	Suffix	"N(`periscope ,)"
`perjury	Suffix	"N(`perjury ,)"
`permafrost	Suffix	"N(`permafrost ,)"
`permanence	Suffix	"N(`permanent ,deadj)"
`permanency	Suffix	"N(`permanent ,deadj)"
permea`bility	Suffix	"N(`permeate ,deverb+deajr)"
permissi`bility	Suffix	"N(per`mit ,deverb+deajr)"
per`mission	Suffix	"N(per`mit ,deverb)"
`permit	Suffix	"N(`permit ,ss)"
perpe`tuity	Suffix	"N(perpe`tuity ,)"
per`plexity	Suffix	"N(per`plex ,deverb)"
`perquisite	Suffix	"N(`perquisite ,)"
`persiflage	Suffix	"N(`persiflage ,)"
`person	Suffix	"N(`person ,)"
`personage	Suffix	"N(`person ,)"
per`spective	Suffix	"N(per`spective ,)"
perspi`cacity	Suffix	"N(perspi`cacity ,)"
perspi`cuity	Suffix	"N(perspi`cuity ,)"
per`suasion	Suffix	"N(per`suade ,deverb)"
pertinacity	Suffix	"N(`pertinent ,deadj)"
`pertinence	Suffix	"N(`pertinent ,deadj)"
per`vasion	Suffix	"N(per`vade ,deverb)"
per`version	Suffix	"N(per`vert ,deverb)"
`pervert	Suffix	"N(`pervert ,ss)"
`peso	Suffix	"N(`peso ,)"
`pessimism	Suffix	"N(`pessimism ,)"
`pessimist	Suffix	"N(`pessimist ,)"
`pest	Suffix	"N(`pest ,)"
`pestilence	Suffix	"N(`pestilence ,)"
`pestle	Suffix	"N(`pestle ,)"
`pet	Suffix	"N(`pet ,)"
`petal	Suffix	"N(`petal ,ajr8)"
`petrel	Suffix	"N(`petrel ,)"
`petri	Suffix	"N(`petri ,)"
petri`faction	Suffix	"N(`petrify ,deverb)"
`petroglyph	Suffix	"N(`petroglyph ,)"
`petrol	Suffix	"N(`petrol ,)"
pet`roleum	Suffix	"N(pet`roleum ,)"
`petticoat	Suffix	"N(`petticoat ,)"
`petulance	Suffix	"N(`petulant ,deadj)"
`pew	Suffix	"N(`pew ,)"
`pewee	Suffix	"N(`pewee ,)"
`pewter	Suffix	"N(`pewter ,)"
`pfennig	Suffix	"N(`pfennig ,)"
`phalanx	Suffix	"N(`phalanx ,)"
`phalarope	Suffix	"N(`phalarope ,)"
`phantasy	Suffix	"N(`phantasy ,)"
`phantom	Suffix	"N(`phantom ,)"
`pharaoh	Suffix	"N(`pharaoh ,)"
`pharisee	Suffix	"N(`pharisee ,)"
`pharmacist	Suffix	"N(`pharmacist ,)"
`pharmacy	Suffix	"N(`pharmacy ,)"
`pharynx	Suffix	"N(`pharynx ,)"
philhar`monic	Suffix	"N(philhar`monic ,)"
philo`dendron	Suffix	"N(philo`dendron ,)"
`phlegm	Suffix	"N(`phlegm ,)"
`phobia	Suffix	"N(`phobia ,)"
`phoenix	Suffix	"N(`phoenix ,)"
`phoneme	Suffix	"N(`phoneme ,)"
`phonograph	Suffix	"N(`phonograph ,)"
`photo	Suffix	"N(`photo ,)"
pho`tography	Suffix	"N(pho`tography ,)"
`physics	Clitic	"N(`physics ,)"
`physicist	Suffix	"N(`physics ,)"
phy`sician	Suffix	"N(phy`sician ,)"
phy`sique	Suffix	"N(phy`sique ,)"
`pianist	Suffix	"N(pi`ano ,)"
pi`ano	Suffix	"N(pi`ano ,)"
pi`azza	Suffix	"N(pi`azza ,)"
`pica	Suffix	"N(`pica ,)"
`piccolo	Suffix	"N(`piccolo ,)"
`pickaxe	Suffix	"N(`pickaxe ,)"
`pickup	Suffix	"N(`pickup ,)"
`picnicker	Suffix	"N(`picnic ,)"
`pidgin	Suffix	"N(`pidgin ,)"
`pie	Suffix	"N(`pie ,~deg2)"
`piecrust	Suffix	"N(`piecrust ,)"
`pier	Suffix	"N(`pier ,)"
`pietism	Suffix	"N(`pietism ,)"
`piety	Suffix	"N(`piety ,)"
`pig	Suffix	"N(`pig ,)"
`pigeon	Suffix	"N(`pigeon ,)"
`piggery	Suffix	"N(`pig ,)"
pigmen`tation	Suffix	"N(pigmen`tation ,)"
`pigpen	Suffix	"N(`pigpen ,)"
`pigskin	Suffix	"N(`pigskin ,)"
`pigtail	Suffix	"N(`pigtail ,)"
`pike	Suffix	"N(`pike ,)"
`pilgrim	Suffix	"N(`pilgrim ,)"
`pilgrimage	Suffix	"N(`pilgrim ,)"
`piling	Suffix	"N(`piling ,)"
`pill	Suffix	"N(`pill ,)"
`pillar	Suffix	"N(`pillar ,)"
`pillow	Suffix	"N(`pillow ,)"
`pimple	Suffix	"N(`pimple ,ajr8)"
`pinafore	Suffix	"N(`pinafore ,)"
`pinball	Suffix	"N(`pinball ,)"
`pincushion	Suffix	"N(`pincushion ,)"
`pine	Suffix	"N(`pine ,)"
`pineapple	Suffix	"N(`pineapple ,)"
`pinhead	Suffix	"N(`pinhead ,)"
`pinhole	Suffix	"N(`pinhole ,)"
`pinkie	Suffix	"N(`pinkie ,)"
`pinnacle	Suffix	"N(`pinnacle ,)"
`pinochle	Suffix	"N(`pinochle ,)"
`pint	Suffix	"N(`pint ,)"
`pintail	Suffix	"N(`pintail ,)"
`pinto	Suffix	"N(`pinto ,)"
`pinwheel	Suffix	"N(`pinwheel ,)"
`pion	Suffix	"N(`pion ,)"
`pip	Suffix	"N(`pip ,)"
`pipeful	Suffix	"N(`pipe ,)"
`pipeline	Suffix	"N(`pipeline ,)"
pip`ette	Suffix	"N(pip`ette ,)"
`piracy	Suffix	"N(`pirate ,)"
pis`tachio	Suffix	"N(pis`tachio ,)"
`pistol	Suffix	"N(`pistol ,)"
`piston	Suffix	"N(`piston ,)"
`pitch	Suffix	"N(`pitch ,)"
`pitchfork	Suffix	"N(`pitchfork ,)"
`pitfall	Suffix	"N(`pitfall ,)"
`pith	Suffix	"N(`pith ,)"
`pittance	Suffix	"N(`pittance ,)"
pi`tuitary	Suffix	"N(pi`tuitary ,)"
`pixel	Suffix	"N(`pixel ,)"
`pixie	Suffix	"N(`pixie ,)"
`pizza	Suffix	"N(`pizza ,)"
`placard	Suffix	"N(`placard ,)"
pla`cebo	Suffix	"N(pla`cebo ,)"
`placeholder	Suffix	"N(`placeholder ,)"
`plagiarism	Suffix	"N(`plagiarism ,)"
`plagiarist	Suffix	"N(`plagiarist ,)"
`plaid	Suffix	"N(`plaid ,)"
`plain	Suffix	"N(`plain ,)"
`plaintiff	Suffix	"N(`plaintiff ,)"
`planeload	Suffix	"N(`planeload ,)"
`planet	Suffix	"N(`planet ,)"
`planetoid	Suffix	"N(`planet ,)"
`plank	Suffix	"N(`plank ,)"
`planking	Suffix	"N(`plank ,)"
`plankton	Suffix	"N(`plankton ,)"
`plantain	Suffix	"N(`plantain ,)"
plan`tation	Suffix	"N(plan`tation ,)"
`plaque	Suffix	"N(`plaque ,)"
`plasm	Suffix	"N(`plasm ,)"
`plasma	Suffix	"N(`plasma ,)"
`plastic	Suffix	"N(`plastic ,)"
pla`teau	Suffix	"N(pla`teau ,)"
`plateful	Suffix	"N(`plate ,)"
`platelet	Suffix	"N(`platelet ,)"
`platen	Suffix	"N(`platen ,)"
`platform	Suffix	"N(`platform ,)"
`plating	Suffix	"N(`plate ,)"
`platinum	Suffix	"N(`platinum ,)"
`platitude	Suffix	"N(`platitude ,)"
pla`toon	Suffix	"N(pla`toon ,)"
`platter	Suffix	"N(`platter ,)"
`plaudit	Suffix	"N(`plaudit ,)"
plausi`bility	Suffix	"N(`plausible ,deadj)"
`playa	Suffix	"N(`playa ,)"
`playback	Suffix	"N(`playback ,)"
`playboy	Suffix	"N(`playboy ,)"
`playground	Suffix	"N(`playground ,)"
`playhouse	Suffix	"N(`playhouse ,)"
`playmate	Suffix	"N(`playmate ,)"
`playoff	Suffix	"N(`playoff ,)"
`playroom	Suffix	"N(`playroom ,)"
`plaything	Suffix	"N(`plaything ,)"
`playtime	Suffix	"N(`playtime ,)"
`playwright	Suffix	"N(`playwright ,)"
`plaza	Suffix	"N(`plaza ,)"
`plea	Suffix	"N(`plea ,)"
`pleasantry	Suffix	"N(`please ,deverb)"
`plebe	Suffix	"N(`plebe ,)"
`plebiscite	Suffix	"N(`plebiscite ,)"
`plenitude	Suffix	"N(`plenitude ,)"
`plenty	Suffix	"N(`plenty ,)"
`plethora	Suffix	"N(`plethora ,)"
`pliancy	Suffix	"N(`pliant ,deadj)"
`plight	Suffix	"N(`plight ,)"
`plowshare	Suffix	"N(`plowshare ,)"
`ploy	Suffix	"N(`ploy ,)"
`pluck	Suffix	"N(`pluck ,)"
`plum	Suffix	"N(`plum ,)"
`plumb	Suffix	"N(`plumb ,)"
`plumbing	Suffix	"N(`plumbing ,)"
`plumage	Suffix	"N(`plume ,)"
`plus	Suffix	"N(`plus ,)"
`plywood	Suffix	"N(`plywood ,)"
pneu`monia	Suffix	"N(pneu`monia ,)"
`pocketbook	Suffix	"N(`pocketbook ,)"
`pocketful	Suffix	"N(`pocket ,)"
`pod	Suffix	"N(`pod ,)"
`poem	Suffix	"N(`poem ,)"
`poesy	Suffix	"N(`poesy ,)"
`poet	Suffix	"N(`poet ,)"
`poetry	Suffix	"N(`poet ,)"
`pogrom	Suffix	"N(`pogrom ,)"
`poi	Suffix	"N(`poi ,)"
`poignancy	Suffix	"N(`poignant ,deadj)"
`pokerface	Suffix	"N(`pokerface ,)"
po`lemic	Suffix	"N(po`lemic ,)"
`policy	Suffix	"N(`policy ,)"
`polio	Suffix	"N(`polio ,)"
poli`tician	Suffix	"N(`politics ,)"
`polity	Suffix	"N(`polity ,)"
`pollen	Suffix	"N(`pollen ,)"
`polo	Suffix	"N(`polo ,)"
polo`naise	Suffix	"N(polo`naise ,)"
`polopony	Suffix	"N(`polopony ,)"
pol`troon	Suffix	"N(pol`troon ,)"
`polyglot	Suffix	"N(`polyglot ,)"
`polygon	Suffix	"N(`polygon ,)"
po`made	Suffix	"N(po`made ,)"
`pomegranate	Suffix	"N(`pomegranate ,)"
`pomp	Suffix	"N(`pomp ,)"
`pompadour	Suffix	"N(`pompadour ,)"
`pom-pom	Suffix	"N(`pom-pom ,)"
`pompon	Suffix	"N(`pompon ,)"
pom`posity	Suffix	"N(`pomp ,)"
`poncho	Suffix	"N(`poncho ,)"
`pond	Suffix	"N(`pond ,)"
`pontiff	Suffix	"N(`pontiff ,)"
`pony	Suffix	"N(`pony ,)"
`pooch	Suffix	"N(`pooch ,)"
`poodle	Suffix	"N(`poodle ,)"
`poop	Suffix	"N(`poop ,)"
`popcorn	Suffix	"N(`popcorn ,)"
`pope	Suffix	"N(`pope ,)"
`poplar	Suffix	"N(`poplar ,)"
`poplin	Suffix	"N(`poplin ,)"
`populace	Suffix	"N(`populace ,)"
`populism	Suffix	"N(`populism ,)"
`populist	Suffix	"N(`populist ,)"
`porcelain	Suffix	"N(`porcelain ,)"
`porch	Suffix	"N(`porch ,)"
`pore	Suffix	"N(`pore ,)"
`pork	Suffix	"N(`pork ,)"
po`rosity	Suffix	"N(`pore ,)"
`porridge	Suffix	"N(`porridge ,)"
`port	Suffix	"N(`port ,)"
`portable	Suffix	"N(`port ,deverb)"
porta`bility	Suffix	"N(`port ,deverb+deajr)"
`portage	Suffix	"N(`portage ,)"
`portal	Suffix	"N(`portal ,)"
port`cullis	Suffix	"N(port`cullis ,)"
`portent	Suffix	"N(`portent ,)"
`porter	Suffix	"N(`porter ,)"
`porterhouse	Suffix	"N(`porterhouse ,)"
port`folio	Suffix	"N(port`folio ,)"
`porthole	Suffix	"N(`porthole ,)"
`portion	Suffix	"N(`portion ,)"
`portrait	Suffix	"N(`portrait ,)"
`portraiture	Suffix	"N(`portrait ,)"
po`seur	Suffix	"N(po`seur ,)"
`posey	Suffix	"N(`posey ,)"
`posse	Suffix	"N(`posse ,)"
pos`sessive	Suffix	"N(pos`sessive ,)"
possi`bility	Suffix	"N(`possible ,deadj)"
`possum	Suffix	"N(`possum ,)"
`post	Suffix	"N(`post ,)"
`postage	Suffix	"N(`postage ,)"
`postcard	Suffix	"N(`postcard ,)"
pos`terior	Suffix	"N(pos`terior ,)"
pos`terity	Suffix	"N(pos`terity ,)"
`postfix	Suffix	"N(`postfix ,)"
`postlude	Suffix	"N(`postlude ,)"
`postmark	Suffix	"N(`postmark ,)"
`postmaster	Suffix	"N(`postmaster ,)"
post`mortem	Suffix	"N(post`mortem ,)"
`postscript	Suffix	"N(`postscript ,)"
`postulant	Suffix	"N(`postulant ,)"
`posy	Suffix	"N(`posy ,)"
`potence	Suffix	"N(`potent ,deadj)"
`potbelly	Suffix	"N(`potbelly ,)"
`potboiler	Suffix	"N(`potboiler ,)"
`potency	Suffix	"N(`potent ,deadj)"
`potentate	Suffix	"N(`potentate ,)"
`potful	Suffix	"N(`pot ,)"
`pothole	Suffix	"N(`pothole ,)"
`potion	Suffix	"N(`potion ,)"
`potlatch	Suffix	"N(`potlatch ,)"
`potluck	Suffix	"N(`potluck ,)"
potpour`ri	Suffix	"N(potpour`ri ,)"
`pottery	Suffix	"N(`pot ,)"
`pouch	Suffix	"N(`pouch ,)"
`poultice	Suffix	"N(`poultice ,)"
`pound	Suffix	"N(`pound ,)"
`poverty	Suffix	"N(`poverty ,)"
`powderpuff	Suffix	"N(`powderpuff ,)"
`powerhouse	Suffix	"N(`powerhouse ,)"
practica`bility	Suffix	"N(`practicable ,deadj)"
prac`titioner	Suffix	"N(prac`titioner ,)"
`pragmatism	Suffix	"N(`pragmatism ,)"
`pragmatist	Suffix	"N(`pragmatist ,)"
`prairie	Suffix	"N(`prairie ,)"
`pram	Suffix	"N(`pram ,)"
`prank	Suffix	"N(`prank ,)"
`prayer	Suffix	"N(`prayer ,)"
`preamble	Suffix	"N(`preamble ,)"
pre`caution	Suffix	"N(pre`caution ,)"
`precedent	Suffix	"N(pre`cede ,deverb ajr8)"
`precept	Suffix	"N(`precept ,)"
`precinct	Suffix	"N(`precinct ,)"
`precipice	Suffix	"N(`precipice ,)"
pre`cipitance	Suffix	"N(pre`cipitant ,deadj)"
pre`cipitancy	Suffix	"N(pre`cipitant ,deadj)"
pre`cision	Suffix	"N(pre`cise ,deadj)"
pre`cocity	Suffix	"N(pre`cocity ,)"
pre`cursor	Suffix	"N(pre`cursor ,)"
`predecessor	Suffix	"N(`predecessor ,)"
pre`dicament	Suffix	"N(pre`dicament ,)"
predi`lection	Suffix	"N(predi`lection ,)"
`prefect	Suffix	"N(`prefect ,)"
`prefecture	Suffix	"N(`prefecture ,)"
prefera`bility	Suffix	"N(pre`fer ,deverb+deajr)"
`preference	Suffix	"N(pre`fer ,deverb)"
`prefix	Suffix	"N(`prefix ,)"
`pregnancy	Suffix	"N(`pregnant ,deadj)"
`prelude	Suffix	"N(`prelude ,)"
pre`mier	Suffix	"N(pre`mier ,)"
`premium	Suffix	"N(`premium ,)"
premo`nition	Suffix	"N(premo`nition ,)"
`prep	Suffix	"N(`prep ,)"
prepo`sition	Suffix	"N(prepo`sition ,)"
pre`requisite	Suffix	"N(pre`requisite ,)"
pre`rogative	Suffix	"N(pre`rogative ,)"
`presbyter	Suffix	"N(`presbyter ,)"
`presbytery	Suffix	"N(`presbytery ,)"
pre`schooler	Suffix	"N(`school ,)"
`prescience	Suffix	"N(`prescient ,deadj)"
pre`scription	Suffix	"N(pre`scribe ,deverb)"
`presence	Suffix	"N(`present ,deadj)"
`present	Suffix	"N(`present ,ss)"
`presidency	Suffix	"N(`president ,)"
`president	Suffix	"N(`president ,)"
`press	Suffix	"N(`press ,)"
`presstime	Suffix	"N(`presstime ,)"
pres`tige	Suffix	"N(pres`tige ,)"
pre`sumption	Suffix	"N(pre`sume ,deverb)"
`pretence	Suffix	"N(`pretence ,)"
`pretense	Suffix	"N(`pretense ,)"
pre`tension	Suffix	"N(pre`tension ,)"
`pretext	Suffix	"N(`pretext ,)"
`prevalence	Suffix	"N(`prevalent ,deadj)"
`pricetag	Suffix	"N(`pricetag ,)"
`priest	Suffix	"N(`priest ,)"
`prig	Suffix	"N(`prig ,)"
`primacy	Suffix	"N(`prime ,deadj)"
`primate	Suffix	"N(`primate ,)"
`prime	Suffix	"N(`prime ,)"
primo`genitor	Suffix	"N(primo`genitor ,)"
primo`geniture	Suffix	"N(primo`geniture ,)"
`primrose	Suffix	"N(`primrose ,)"
`prince	Suffix	"N(`prince ,)"
`principle	Suffix	"N(`principle ,ajr8)"
`printout	Suffix	"N(`printout ,)"
`priory	Suffix	"N(`priory ,)"
`prism	Suffix	"N(`prism ,)"
`prison	Suffix	"N(`prison ,)"
`prisoner	Suffix	"N(`prison ,)"
`privacy	Suffix	"N(`private ,deadj)"
`private	Suffix	"N(`private ,)"
`privation	Suffix	"N(`privation ,)"
`privet	Suffix	"N(`privet ,)"
`privy	Suffix	"N(`privy ,)"
`pro	Suffix	"N(`pro ,)"
`probabilist	Suffix	"N(`probabilist ,)"
pro`bation	Suffix	"N(pro`bation ,)"
`probity	Suffix	"N(`probity ,)"
`problem	Suffix	"N(`problem ,)"
pro`boscis	Suffix	"N(pro`boscis ,)"
pro`cedure	Suffix	"N(pro`ceed ,deverb)"
pro`cessional	Suffix	"N(pro`cess ,deverb)"
procla`mation	Suffix	"N(pro`claim ,deverb)"
pro`clivity	Suffix	"N(pro`clivity ,)"
`prodigy	Suffix	"N(`prodigy ,)"
`produce	Suffix	"N(`produce ,ss)"
`product	Suffix	"N(`product ,)"
pro`duction	Suffix	"N(pro`duce ,deverb)"
produc`tivity	Suffix	"N(pro`duce ,deverb)"
`prof	Suffix	"N(`prof - professor,)"
pro`fession	Suffix	"N(pro`fession ,)"
pro`fessional	Suffix	"N(pro`fession ,)"
pro`fessor	Suffix	"N(pro`fessor ,)"
pro`ficiency	Suffix	"N(pro`ficient ,deadj)"
profit`eering	Suffix	"N(`profit ,)"
`profligacy	Suffix	"N(`profligate ,deadj)"
pro`fundity	Suffix	"N(pro`found ,deadj)"
pro`genitor	Suffix	"N(pro`genitor ,)"
`progeny	Suffix	"N(`progeny ,)"
`progress	Suffix	"N(`progress ,ss)"
pro`gressive	Suffix	"N(pro`gress ,deverb)"
`project	Suffix	"N(`project ,)"
pro`jectile	Suffix	"N(pro`jectile ,)"
prole`tariat	Suffix	"N(prole`tariat ,)"
`prologue	Suffix	"N(`prologue ,)"
pro`lusion	Suffix	"N(pro`lusion ,)"
`prom	Suffix	"N(`prom - promenade,)"
promis`cuity	Suffix	"N(promis`cuity ,)"
`promontory	Suffix	"N(`promontory ,)"
`promptitude	Suffix	"N(`promptitude ,)"
`prong	Suffix	"N(`prong ,ajr8)"
`pronoun	Suffix	"N(`pronoun ,)"
pronunci`ation	Suffix	"N(pro`nounce ,deverb)"
`proof	Suffix	"N(`proof ,)"
propa`ganda	Suffix	"N(propa`ganda ,)"
propa`gandist	Suffix	"N(propa`gandist ,)"
`propane	Suffix	"N(`propane ,)"
pro`pensity	Suffix	"N(pro`pensity ,)"
`property	Suffix	"N(`property ,)"
`prophecy	Suffix	"N(`prophecy ,)"
`prophet	Suffix	"N(`prophet ,)"
pro`pinquity	Suffix	"N(pro`pinquity ,)"
pro`ponent	Suffix	"N(pro`ponent ,)"
pro`prietor	Suffix	"N(pro`prietor ,)"
pro`priety	Suffix	"N(pro`priety ,)"
pro`pulsion	Suffix	"N(pro`pell ,deverb)"
`propylene	Suffix	"N(`propylene ,)"
pro`scription	Suffix	"N(pro`scribe ,deverb)"
`prose	Suffix	"N(`prose ,)"
`proselyte	Suffix	"N(`proselyte ,)"
`prosody	Suffix	"N(`prosody ,)"
`prospect	Suffix	"N(`prospect ,)"
pro`spectus	Suffix	"N(pro`spectus ,)"
pros`perity	Suffix	"N(`prosper ,deverb)"
`prostate	Suffix	"N(`prostate ,)"
pro`tagonist	Suffix	"N(pro`tagonist ,)"
pro`tectorate	Suffix	"N(pro`tectorate ,)"
`protege	Suffix	"N(`protege ,)"
`protegee	Suffix	"N(`protegee - female protege,)"
`protein	Suffix	"N(`protein ,)"
`protestant	Suffix	"N(`protestant ,)"
`protocol	Suffix	"N(`protocol ,)"
`prototype	Suffix	"N(`prototype ,)"
pro`trusion	Suffix	"N(pro`trude ,deverb)"
pro`tuberance	Suffix	"N(pro`tuberant ,deadj)"
`provenance	Suffix	"N(`provenance ,)"
`proverb	Suffix	"N(`proverb ,)"
`providence	Suffix	"N(`providence ,)"
`province	Suffix	"N(`province ,)"
provoca`teur	Suffix	"N(provoca`teur ,)"
provo`cation	Suffix	"N(pro`voke ,deverb)"
`provost	Suffix	"N(`provost ,)"
`prow	Suffix	"N(`prow ,)"
`prowess	Suffix	"N(`prowess ,)"
prox`imity	Suffix	"N(prox`imity ,)"
`proxy	Suffix	"N(`proxy ,)"
`prude	Suffix	"N(`prude ,)"
`prudence	Suffix	"N(`prudent ,deadj)"
`prune	Suffix	"N(`prune ,)"
`prurience	Suffix	"N(`prurient ,deadj)"
`psalm	Suffix	"N(`psalm ,)"
`psalter	Suffix	"N(`psalter ,)"
`psaltery	Suffix	"N(`psaltery ,)"
`pseudonym	Suffix	"N(`pseudonym ,)"
`psyche	Suffix	"N(`psyche ,)"
`psycho	Suffix	"N(`psycho ,)"
psychoa`nalysis	Suffix	"N(psychoa`nalysis ,)"
psycho`analyst	Suffix	"N(psycho`analyst ,)"
`psychopath	Suffix	"N(`psychopath ,)"
psycho`therapy	Suffix	"N(psycho`therapy ,)"
psycho`therapist	Suffix	"N(psycho`therapist ,)"
psy`chotic	Suffix	"N(psy`chotic ,)"
`ptarmigan	Suffix	"N(`ptarmigan ,)"
`pub	Suffix	"N(`pub ,)"
pu`bescence	Suffix	"N(pu`bescent ,deadj)"
`puberty	Suffix	"N(`puberty ,)"
`publican	Suffix	"N(`publican ,)"
publi`cation	Suffix	"N(`publish ,deverb)"
`puck	Suffix	"N(`puck ,)"
`pudding	Suffix	"N(`pudding ,)"
`puddle	Suffix	"N(`puddle ,)"
`pudency	Suffix	"N(`pudency ,)"
`pueblo	Suffix	"N(`pueblo ,)"
`puffball	Suffix	"N(`puffball ,)"
`puffery	Suffix	"N(`puffery ,)"
`pug	Suffix	"N(`pug ,)"
`pugilist	Suffix	"N(`pugilist ,)"
puis`sance	Suffix	"N(puis`sant ,deadj)"
`pulchritude	Suffix	"N(`pulchritude ,)"
`pulley	Suffix	"N(`pulley ,)"
`pullback	Suffix	"N(`pullback ,)"
`pullet	Suffix	"N(`pullet ,)"
`pullout	Suffix	"N(`pullout ,)"
`pullover	Suffix	"N(`pullover ,)"
`pulp	Suffix	"N(`pulp ,)"
`pulpit	Suffix	"N(`pulpit ,)"
`pulsar	Suffix	"N(`pulsar ,)"
`pumice	Suffix	"N(`pumice ,)"
`pumpkin	Suffix	"N(`pumpkin ,)"
`pundit	Suffix	"N(`pundit ,)"
`punditry	Suffix	"N(`pundit ,)"
`pungency	Suffix	"N(`pungent ,deadj)"
`punk	Suffix	"N(`punk ,)"
`pup	Suffix	"N(`pup ,)"
`pupil	Suffix	"N(`pupil ,)"
`puppet	Suffix	"N(`puppet ,)"
`puppetry	Suffix	"N(`puppet ,)"
`puppy	Suffix	"N(`puppy ,)"
pur`gation	Suffix	"N(`purge ,deverb)"
`purgatory	Suffix	"N(`purge ,deverb)"
`puritan	Suffix	"N(`puritan ,)"
`purse	Suffix	"N(`purse ,)"
pur`suit	Suffix	"N(pur`suit ,)"
`purview	Suffix	"N(`purview ,)"
`pus	Suffix	"N(`pus ,)"
`pushbutton	Suffix	"N(`pushbutton ,)"
`puss	Suffix	"N(`puss ,)"
`pussy	Suffix	"N(`pussy ,)"
`pussycat	Suffix	"N(`pussycat ,)"
putre`faction	Suffix	"N(`putrid ,deverb)"
`pygmy	Suffix	"N(`pygmy ,)"
`pyramid	Suffix	"N(`pyramid ,)"
`pyre	Suffix	"N(`pyre ,)"
pyro`mania	Suffix	"N(pyro`mania ,)"
pyro`maniac	Suffix	"N(pyro`maniac ,)"
`python	Suffix	"N(`python ,)"
`quack	Suffix	"N(`quack - bad doctor,)"
`quackery	Suffix	"N(`quack ,)"
`quad	Suffix	"N(`quad ,)"
`quadrangle	Suffix	"N(`quadrangle ,)"
`quadrant	Suffix	"N(`quadrant ,)"
qua`drille	Suffix	"N(qua`drille ,)"
`quadruped	Suffix	"N(`quadruped ,)"
qua`druple	Suffix	"N(qua`druple ,)"
quad`ruplet	Suffix	"N(quad`ruplet ,)"
`quagmire	Suffix	"N(`quagmire ,)"
qualifi`cation	Suffix	"N(`qualify ,deverb)"
`quality	Suffix	"N(`quality ,)"
`qualm	Suffix	"N(`qualm ,)"
`quandary	Suffix	"N(`quandary ,)"
quantifi`cation	Suffix	"N(`quantify ,deverb)"
`quantity	Suffix	"N(`quantity ,)"
`quark	Suffix	"N(`quark ,)"
`quart	Suffix	"N(`quart ,)"
`quarterback	Suffix	"N(`quarterback ,)"
`quartermaster	Suffix	"N(`quartermaster ,)"
quar`tet	Suffix	"N(quar`tet ,)"
`quartile	Suffix	"N(`quartile ,)"
`quartz	Suffix	"N(`quartz ,)"
`quasar	Suffix	"N(`quasar ,)"
`quatrain	Suffix	"N(`quatrain ,)"
`quay	Suffix	"N(`quay ,)"
`queen	Suffix	"N(`queen ,)"
question`naire	Suffix	"N(question`naire ,)"
`quicklime	Suffix	"N(`quicklime ,)"
`quicksand	Suffix	"N(`quicksand ,)"
`quicksilver	Suffix	"N(`quicksilver ,)"
`quickstep	Suffix	"N(`quickstep ,)"
`quid	Suffix	"N(`quid ,)"
qui`escence	Suffix	"N(qui`escent ,deadj)"
`quietude	Suffix	"N(`quietude ,)"
qui`etus	Suffix	"N(qui`etus ,)"
`quill	Suffix	"N(`quill ,)"
`quilting	Suffix	"N(`quilt ,)"
`quince	Suffix	"N(`quince ,)"
`quinine	Suffix	"N(`quinine ,)"
`quint	Suffix	"N(`quint ,)"
quin`tessence	Suffix	"N(quin`tessence ,)"
quin`tet	Suffix	"N(quin`tet ,)"
quin`tuplet	Suffix	"N(quin`tuplet ,)"
`quirk	Suffix	"N(`quirk ,)"
`quirt	Suffix	"N(`quirt ,)"
`quod	Suffix	"N(`quod ,)"
`quonset	Suffix	"N(`quonset ,)"
`quorum	Suffix	"N(`quorum ,)"
`quota	Suffix	"N(`quota ,)"
`quotient	Suffix	"N(`quotient ,)"
`rabbi	Suffix	"N(`rabbi ,)"
`rabbit	Suffix	"N(`rabbit ,)"
`rabble	Suffix	"N(`rabble ,)"
`rabies	Suffix	"N(`rabies ,)"
`racetrack	Suffix	"N(`racetrack ,)"
`raceway	Suffix	"N(`raceway ,)"
`rack	Suffix	"N(`rack ,)"
`racket	Suffix	"N(`racket ,)"
racon`teur	Suffix	"N(racon`teur ,)"
`radar	Suffix	"N(`radar ,)"
`radian	Suffix	"N(`radian ,)"
`radiance	Suffix	"N(`radiate ,deverb+deajr)"
radio`telegraph	Suffix	"N(radio`telegraph ,)"
radio`telephone	Suffix	"N(radio`telephone ,)"
`radish	Suffix	"N(`radish ,)"
`rag	Suffix	"N(`rag ,)"
`ragamuffin	Suffix	"N(`ragamuffin ,)"
ra`gout	Suffix	"N(ra`gout ,)"
`rail	Suffix	"N(`rail ,)"
`railhead	Suffix	"N(`railhead ,)"
`railing	Suffix	"N(`rail ,)"
`raillery	Suffix	"N(`raillery ,)"
`railway	Suffix	"N(`railway ,)"
`raiment	Suffix	"N(`raiment ,)"
`rainbow	Suffix	"N(`rainbow ,)"
`raincoat	Suffix	"N(`raincoat ,)"
`raindrop	Suffix	"N(`raindrop ,)"
`rainfall	Suffix	"N(`rainfall ,)"
`rainstorm	Suffix	"N(`rainstorm ,)"
`raisin	Suffix	"N(`raisin ,)"
`raj	Suffix	"N(`raj ,)"
`rajah	Suffix	"N(`rajah ,)"
`ram	Suffix	"N(`ram ,)"
ramifi`cation	Suffix	"N(`ramify ,deverb)"
`ramp	Suffix	"N(`ramp ,)"
`rampart	Suffix	"N(`rampart ,)"
`ramrod	Suffix	"N(`ramrod ,)"
`rancho	Suffix	"N(`rancho ,)"
`rancor	Suffix	"N(`rancor ,)"
`rancour	Suffix	"N(`rancour - British,)"
`rangeland	Suffix	"N(`rangeland ,)"
`rapier	Suffix	"N(`rapier ,)"
rap`port	Suffix	"N(rap`port ,)"
rapproche`ment	Suffix	"N(rapproche`ment ,)"
rap`scallion	Suffix	"N(rap`scallion ,)"
`raptor	Suffix	"N(`raptor ,)"
`rascal	Suffix	"N(`rascal ,)"
`rash	Suffix	"N(`rash ,)"
`raspberry	Suffix	"N(`raspberry ,)"
`raster	Suffix	"N(`raster ,)"
`rat	Suffix	"N(`rat ,)"
`ratepayer	Suffix	"N(`ratepayer ,)"
ratio`nale	Suffix	"N(ratio`nale ,)"
ra`vine	Suffix	"N(ra`vine ,)"
`rawhide	Suffix	"N(`rawhide ,)"
`ray	Suffix	"N(`ray ,)"
`razor	Suffix	"N(`razor ,)"
`readout	Suffix	"N(`readout ,)"
`realm	Suffix	"N(`realm ,)"
`realtor	Suffix	"N(`realtor ,)"
`realty	Suffix	"N(`realty ,)"
`ream	Suffix	"N(`ream ,)"
`rear	Suffix	"N(`rear ,)"
`rebel	Suffix	"N(`rebel ,ss)"
re`calcitrance	Suffix	"N(re`calcitrant ,deadj)"
re`calcitrancy	Suffix	"N(re`calcitrant ,deadj)"
re`ceptacle	Suffix	"N(re`ceptacle ,)"
re`ception	Suffix	"N(re`ceive ,deverb)"
re`ceptor	Suffix	"N(re`ceive ,deverb)"
`recess	Suffix	"N(`recess ,ss)"
re`cessional	Suffix	"N(re`cess ,deverb)"
re`cidivism	Suffix	"N(re`cidivism ,)"
`recipe	Suffix	"N(`recipe ,)"
re`cipient	Suffix	"N(re`ceive ,deverb)"
reci`procity	Suffix	"N(reci`procity ,)"
recita`tive	Suffix	"N(recita`tive ,)"
recla`mation	Suffix	"N(`claim ,deverb)"
recog`nition	Suffix	"N(`recognize ,deverb)"
re`connaissance	Suffix	"N(re`connaissance ,)"
`record	Suffix	"N(`record ,ss)"
re`covery	Suffix	"N(re`cover ,deverb)"
`rectangle	Suffix	"N(`rectangle ,)"
rectifi`cation	Suffix	"N(rectifi`cation ,)"
`rectitude	Suffix	"N(`rectitude ,)"
`recto	Suffix	"N(`recto ,)"
`rector	Suffix	"N(`rector ,)"
`rectory	Suffix	"N(`rectory ,)"
`recusancy	Suffix	"N(`recusant ,deadj)"
`redcoat	Suffix	"N(`redcoat ,)"
re`demption	Suffix	"N(re`deem ,deverb)"
`redhead	Suffix	"N(`redhead ,)"
`redneck	Suffix	"N(`redneck ,)"
`redskin	Suffix	"N(`redskin ,)"
re`duction	Suffix	"N(re`duce ,deverb)"
re`dundance	Suffix	"N(re`dundant ,deadj)"
re`dundancy	Suffix	"N(re`dundant ,deadj)"
`reed	Suffix	"N(`reed ,)"
`reef	Suffix	"N(`reef ,)"
re`fectory	Suffix	"N(re`fect ,deverb)"
`referent	Suffix	"N(re`fer ,deverb)"
`refill	Suffix	"N(`fill ,deverb)"
re`finery	Suffix	"N(re`fine ,deverb)"
`refit	Suffix	"N(`fit ,deverb)"
`reflex	Suffix	"N(`reflex ,)"
re`formatory	Suffix	"N(re`form ,deverb)"
re`frain	Suffix	"N(re`frain ,)"
re`frigerant	Suffix	"N(re`frigerate ,deverb)"
re`fulgence	Suffix	"N(re`fulgent ,deadj)"
`refund	Suffix	"N(`refund ,ss)"
re`gatta	Suffix	"N(re`gatta ,)"
`regency	Suffix	"N(`regency ,)"
`regent	Suffix	"N(`regent ,)"
re`gime	Suffix	"N(re`gime ,)"
`regimen	Suffix	"N(`regimen ,)"
`region	Suffix	"N(`region ,)"
`registrant	Suffix	"N(`register ,deverb)"
`registrar	Suffix	"N(`register ,deverb)"
regis`tration	Suffix	"N(`register ,deverb)"
`registry	Suffix	"N(`register ,deverb)"
`regress	Suffix	"N(`regress ,ss)"
`reject	Suffix	"N(`reject ,ss)"
re`joinder	Suffix	"N(re`joinder ,)"
`relative	Suffix	"N(re`late ,deverb)"
`relay	Suffix	"N(`relay ,ss)"
`relevance	Suffix	"N(`relevant ,deadj)"
`relevancy	Suffix	"N(`relevant ,deadj)"
`relic	Suffix	"N(`relic ,)"
`relict	Suffix	"N(`relict ,)"
re`lief	Suffix	"N(re`lief ,)"
re`ligion	Suffix	"N(re`ligion ,)"
religi`osity	Suffix	"N(religi`osity ,)"
re`liquary	Suffix	"N(re`liquary ,)"
`relish	Suffix	"N(`relish ,)"
re`luctance	Suffix	"N(re`luctant ,deadj)"
re`luctancy	Suffix	"N(re`luctant ,deadj)"
re`mainder	Suffix	"N(re`mainder ,)"
re`membrance	Suffix	"N(re`member ,deverb)"
`remnant	Suffix	"N(`remnant ,)"
re`monstrance	Suffix	"N(re`monstrate ,deverb)"
re`morse	Suffix	"N(re`morse ,)"
`renaissance	Suffix	"N(`renaissance ,)"
ren`dition	Suffix	"N(`render ,deverb)"
`renegade	Suffix	"N(`renegade ,)"
renunci`ation	Suffix	"N(re`nounce ,deverb)"
`rep	Suffix	"N(`rep - representative,)"
repa`ration	Suffix	"N(re`pair ,deverb)"
repar`tee	Suffix	"N(repar`tee ,)"
`repast	Suffix	"N(`repast ,)"
`repertoire	Suffix	"N(`repertoire ,)"
`repertory	Suffix	"N(`repertory ,)"
repe`tition	Suffix	"N(re`peat ,deverb)"
`replica	Suffix	"N(`replica ,)"
re`pository	Suffix	"N(re`pository ,)"
repre`hension	Suffix	"N(repre`hend ,deverb)"
re`proof	Suffix	"N(re`prove ,deverb)"
`reptile	Suffix	"N(`reptile ,)"
re`public	Suffix	"N(re`public ,)"
re`pugnance	Suffix	"N(re`pugnant ,deadj)"
re`pugnancy	Suffix	"N(re`pugnant ,deadj)"
`requiem	Suffix	"N(`requiem ,)"
re`sale	Suffix	"N(`sale ,)"
re`scission	Suffix	"N(re`scind ,deverb)"
re`serve	Suffix	"N(re`serve ,)"
`reservoir	Suffix	"N(`reservoir ,)"
`residue	Suffix	"N(`residue ,)"
re`sidual	Suffix	"N(`residue ,)"
re`silience	Suffix	"N(re`sile ,deverb+deajr)"
re`siliency	Suffix	"N(re`sile ,deverb+deajr)"
`resin	Suffix	"N(`resin ,)"
reso`lution	Suffix	"N(re`solve ,deverb)"
re`solve	Suffix	"N(re`solve ,)"
`resonance	Suffix	"N(`resonant ,deadj)"
re`sort	Suffix	"N(re`sort ,)"
`resource	Suffix	"N(`resource ,)"
`respirator	Suffix	"N(re`spire ,deverb)"
`respite	Suffix	"N(`respite ,)"
re`splendence	Suffix	"N(re`splendent ,deadj)"
re`spondent	Suffix	"N(re`spond ,deverb)"
re`sponse	Suffix	"N(re`sponse ,)"
responsi`bility	Suffix	"N(re`sponsible ,deadj)"
`restaurant	Suffix	"N(`restaurant ,)"
restauran`teur	Suffix	"N(restauran`teur ,)"
restaura`teur	Suffix	"N(restaura`teur ,)"
re`straint	Suffix	"N(re`straint ,)"
`restroom	Suffix	"N(`restroom ,)"
`resume	Suffix	"N(`resume ,)"
re`sumption	Suffix	"N(re`sume ,deverb)"
re`tention	Suffix	"N(re`tain ,deverb)"
`reticence	Suffix	"N(`reticent ,deadj)"
`retina	Suffix	"N(`retina ,)"
`retinue	Suffix	"N(`retinue ,)"
retri`bution	Suffix	"N(retri`bution ,)"
retro`version	Suffix	"N(retro`version ,)"
re`union	Suffix	"N(`union ,)"
reve`lation	Suffix	"N(re`veal ,deverb)"
`revelry	Suffix	"N(`revel ,deverb)"
re`venge	Suffix	"N(re`venge ,)"
`revenue	Suffix	"N(`revenue ,)"
`revenuer	Suffix	"N(`revenue ,)"
`reverie	Suffix	"N(`reverie ,)"
revoca`bility	Suffix	"N(re`voke ,deverb+deajr)"
revo`cation	Suffix	"N(re`voke ,deverb)"
revo`lution	Suffix	"N(re`volve ,deverb)"
re`vue	Suffix	"N(re`vue ,)"
re`vulsion	Suffix	"N(re`vulsion ,)"
`rhapsody	Suffix	"N(`rhapsody ,)"
`rheostat	Suffix	"N(`rheostat ,)"
`rhesus	Suffix	"N(`rhesus ,)"
`rhetoric	Suffix	"N(`rhetoric ,)"
`rheum	Suffix	"N(`rheum ,)"
`rheumatism	Suffix	"N(`rheumatism ,)"
`rhinestone	Suffix	"N(`rhinestone ,)"
`rhubarb	Suffix	"N(`rhubarb ,)"
`rhythm	Suffix	"N(`rhythm ,)"
`rib	Suffix	"N(`rib ,)"
`ribbon	Suffix	"N(`ribbon ,ajr8)"
`riboflavin	Suffix	"N(`riboflavin ,)"
`rice	Suffix	"N(`rice ,)"
`rick	Suffix	"N(`rick ,)"
`rickets	Suffix	"N(`rickets ,)"
`rickshaw	Suffix	"N(`rickshaw ,)"
`rictus	Suffix	"N(`rictus ,)"
`ridge	Suffix	"N(`ridge ,)"
`ridgepole	Suffix	"N(`ridgepole ,)"
`riffraff	Suffix	"N(`riffraff ,)"
`rifle	Suffix	"N(`rifle ,)"
`rift	Suffix	"N(`rift ,)"
`rigging	Suffix	"N(`rig ,)"
`rigmarole	Suffix	"N(`rigmarole ,)"
`rigor	Suffix	"N(`rigor ,)"
`rigour	Suffix	"N(`rigour - British,)"
`rill	Suffix	"N(`rill ,)"
`rime	Suffix	"N(`rime ,)"
`rind	Suffix	"N(`rind ,)"
`ringleader	Suffix	"N(`ringleader ,)"
`ringmaster	Suffix	"N(`ringmaster ,)"
`ringside	Suffix	"N(`ringside ,)"
`rink	Suffix	"N(`rink ,)"
`ripoff	Suffix	"N(`ripoff ,)"
`rite	Suffix	"N(`rite ,)"
`ritual	Suffix	"N(`ritual ,)"
`rivalry	Suffix	"N(`rival ,)"
`river	Suffix	"N(`river ,)"
`riverbank	Suffix	"N(`riverbank ,)"
`riverbed	Suffix	"N(`riverbed ,)"
`riverfront	Suffix	"N(`riverfront ,)"
`riverside	Suffix	"N(`riverside ,)"
`rivulet	Suffix	"N(`rivulet ,)"
`roach	Suffix	"N(`roach ,)"
`road	Suffix	"N(`road ,)"
`roadbed	Suffix	"N(`roadbed ,)"
`roadblock	Suffix	"N(`roadblock ,)"
`roadhouse	Suffix	"N(`roadhouse ,)"
`roadside	Suffix	"N(`roadside ,)"
`roadway	Suffix	"N(`roadway ,)"
`robbery	Suffix	"N(`rob ,deverb)"
`robot	Suffix	"N(`robot ,)"
`rock	Suffix	"N(`rock ,)"
`rocketry	Suffix	"N(`rocket ,)"
`rod	Suffix	"N(`rod ,)"
`rodeo	Suffix	"N(`rodeo ,)"
`roe	Suffix	"N(`roe ,)"
`rogue	Suffix	"N(`rogue ,)"
`role	Suffix	"N(`role ,)"
`rollback	Suffix	"N(`rollback ,)"
ro`mantic	Suffix	"N(ro`mantic ,)"
`rondo	Suffix	"N(`rondo ,)"
`rood	Suffix	"N(`rood ,)"
`roofing	Suffix	"N(`roof ,)"
`rooftop	Suffix	"N(`rooftop ,)"
`rook	Suffix	"N(`rook ,)"
`rookie	Suffix	"N(`rookie ,)"
`rooky	Suffix	"N(`rooky ,)"
`roomful	Suffix	"N(`room ,)"
`roommate	Suffix	"N(`roommate ,)"
`rosary	Suffix	"N(`rosary ,)"
`rose	Suffix	"N(`rose ,)"
`rosebud	Suffix	"N(`rosebud ,)"
`rosebush	Suffix	"N(`rosebush ,)"
ro`sette	Suffix	"N(ro`sette ,)"
`rosin	Suffix	"N(`rosin ,)"
`roster	Suffix	"N(`roster ,)"
`rotary	Suffix	"N(`rotary ,)"
`rote	Suffix	"N(`rote ,)"
rotogra`vure	Suffix	"N(rotogra`vure ,)"
`rotor	Suffix	"N(`rotor ,)"
ro`tunda	Suffix	"N(ro`tunda ,)"
ro`uge	Suffix	"N(ro`uge ,)"
`roughage	Suffix	"N(`rough ,deadj)"
`roughneck	Suffix	"N(`roughneck ,)"
rou`lette	Suffix	"N(rou`lette ,)"
`round	Suffix	"N(`round ,)"
`roundhouse	Suffix	"N(`roundhouse ,)"
`roundtable	Suffix	"N(`roundtable ,)"
`roundup	Suffix	"N(`roundup ,)"
`roundworm	Suffix	"N(`roundworm ,)"
`roustabout	Suffix	"N(`roustabout ,)"
`route	Suffix	"N(`route ,)"
rou`tine	Suffix	"N(rou`tine ,)"
`row	Suffix	"N(`row ,)"
`rowboat	Suffix	"N(`rowboat ,)"
`royalty	Suffix	"N(`royal ,deadj)"
`rubber	Suffix	"N(`rubber ,)"
`rubbish	Suffix	"N(`rubbish ,)"
`rubble	Suffix	"N(`rubble ,)"
`rubdown	Suffix	"N(`rubdown ,)"
`ruble	Suffix	"N(`ruble ,)"
`rubric	Suffix	"N(`rubric ,)"
`ruby	Suffix	"N(`ruby ,)"
`ruckus	Suffix	"N(`ruckus ,)"
`rudder	Suffix	"N(`rudder ,)"
`rudiment	Suffix	"N(`rudiment ,)"
`ruff	Suffix	"N(`ruff ,)"
`ruffian	Suffix	"N(`ruffian ,)"
`rug	Suffix	"N(`rug ,)"
`rum	Suffix	"N(`rum ,)"
`rumen	Suffix	"N(`rumen ,)"
`ruminant	Suffix	"N(`ruminant ,)"
`rummy	Suffix	"N(`rummy ,)"
`rump	Suffix	"N(`rump ,)"
`rumpus	Suffix	"N(`rumpus ,)"
`runabout	Suffix	"N(`runabout ,)"
`runaway	Suffix	"N(`runaway ,)"
`rundown	Suffix	"N(`rundown ,)"
`rune	Suffix	"N(`rune ,)"
`rung	Suffix	"N(`rung ,)"
`runoff	Suffix	"N(`runoff ,)"
`runt	Suffix	"N(`runt ,)"
`runway	Suffix	"N(`runway ,)"
`rupee	Suffix	"N(`rupee ,)"
`ruse	Suffix	"N(`ruse ,)"
`rutabaga	Suffix	"N(`rutabaga ,)"
`rye	Suffix	"N(`rye ,)"
`sabbath	Suffix	"N(`sabbath ,)"
sab`batical	Suffix	"N(sab`batical ,)"
`sable	Suffix	"N(`sable ,)"
sabo`teur	Suffix	"N(sabo`teur ,)"
`sabra	Suffix	"N(`sabra ,)"
`sac	Suffix	"N(`sac ,)"
`saccharin	Suffix	"N(`saccharin ,)"
sa`chet	Suffix	"N(sa`chet ,)"
`sack	Suffix	"N(`sack ,)"
`sackcloth	Suffix	"N(`sackcloth ,)"
`sackful	Suffix	"N(`sack ,)"
`sacrament	Suffix	"N(`sacrament ,)"
`sacrilege	Suffix	"N(`sacrilege ,)"
`saddlebag	Suffix	"N(`saddlebag ,)"
`sadism	Suffix	"N(`sadism ,)"
`sadist	Suffix	"N(`sadist ,)"
sado`masochism	Suffix	"N(sado`masochism ,)"
sado`masochist	Suffix	"N(sado`masochist ,)"
`safe	Suffix	"N(`safe ,)"
safe`keeping	Suffix	"N(safe`keeping ,)"
`safety	Suffix	"N(`safe ,deadj)"
`saffron	Suffix	"N(`saffron ,)"
`saga	Suffix	"N(`saga ,)"
sa`gacity	Suffix	"N(sa`gacity ,)"
`sage	Suffix	"N(`sage ,)"
`sail	Suffix	"N(`sail ,)"
`sailboat	Suffix	"N(`sailboat ,)"
`sake	Suffix	"N(`sake ,)"
sala`bility	Suffix	"N(`salable ,deadj)"
`salad	Suffix	"N(`salad ,)"
sa`lami	Suffix	"N(sa`lami ,)"
`salary	Suffix	"N(`salary ,ajr8)"
`sale	Suffix	"N(`sale ,)"
`salesgirl	Suffix	"N(`salesgirl ,)"
`saleslady	Suffix	"N(`saleslady ,)"
`salesperson	Suffix	"N(`salesperson ,)"
`salience	Suffix	"N(`salient ,deadj)"
`saliency	Suffix	"N(`salient ,deadj)"
sa`liva	Suffix	"N(sa`liva ,)"
sa`lon	Suffix	"N(sa`lon ,)"
sa`loon	Suffix	"N(sa`loon ,)"
sa`loonkeeper	Suffix	"N(sa`loonkeeper ,)"
sal`vation	Suffix	"N(sal`vation ,)"
`salver	Suffix	"N(`salver ,)"
`samba	Suffix	"N(`samba ,)"
`samovar	Suffix	"N(`samovar ,)"
sanctifi`cation	Suffix	"N(`sanctify ,deverb)"
`sanctimony	Suffix	"N(`sanctimony ,)"
`sanctity	Suffix	"N(`sanctity ,)"
`sanctuary	Suffix	"N(`sanctuary ,)"
`sand	Suffix	"N(`sand ,)"
`sandal	Suffix	"N(`sandal ,)"
`sandman	Suffix	"N(`sandman ,)"
`sandpaper	Suffix	"N(`sandpaper ,)"
`sandpile	Suffix	"N(`sandpile ,)"
`sap	Suffix	"N(`sap ,)"
`sapling	Suffix	"N(`sapling ,)"
`sapphire	Suffix	"N(`sapphire ,)"
`sarcasm	Suffix	"N(`sarcasm ,)"
sar`dine	Suffix	"N(sar`dine ,)"
`sari	Suffix	"N(`sari ,)"
sa`rong	Suffix	"N(sa`rong ,)"
sarsapa`rilla	Suffix	"N(sarsapa`rilla ,)"
`sash	Suffix	"N(`sash ,)"
`sassafras	Suffix	"N(`sassafras ,)"
`satchel	Suffix	"N(`satchel ,)"
`satellite	Suffix	"N(`satellite ,)"
`satiety	Suffix	"N(`satiety ,)"
`satin	Suffix	"N(`satin ,)"
`satire	Suffix	"N(`satire ,)"
satis`faction	Suffix	"N(`satisfy ,deverb)"
`satyr	Suffix	"N(`satyr ,)"
`sauce	Suffix	"N(`sauce ,)"
`saucer	Suffix	"N(`saucer ,)"
`saucepan	Suffix	"N(`saucepan ,)"
`sauerkraut	Suffix	"N(`sauerkraut ,)"
`sauna	Suffix	"N(`sauna ,)"
`sausage	Suffix	"N(`sausage ,)"
sau`terne	Suffix	"N(sau`terne ,)"
`savagery	Suffix	"N(`savage ,deadj)"
sa`vanna	Suffix	"N(sa`vanna ,)"
sa`vant	Suffix	"N(sa`vant ,)"
`savior	Suffix	"N(`savior ,)"
`saviour	Suffix	"N(`saviour - British,)"
sa`voy	Suffix	"N(sa`voy ,)"
`sawdust	Suffix	"N(`sawdust ,)"
`sawmill	Suffix	"N(`sawmill ,)"
`sawyer	Suffix	"N(`saw ,deverb)"
`sax	Suffix	"N(`sax ,)"
`saxophone	Suffix	"N(`saxophone ,)"
`scab	Suffix	"N(`scab ,)"
`scabbard	Suffix	"N(`scabbard ,)"
`scad	Suffix	"N(`scad ,)"
`scaffold	Suffix	"N(`scaffold ,)"
`scaffolding	Suffix	"N(`scaffold ,)"
`scale	Suffix	"N(`scale ,)"
`scallion	Suffix	"N(`scallion ,)"
`scalpel	Suffix	"N(`scalpel ,)"
`scam	Suffix	"N(`scam ,)"
`scamp	Suffix	"N(`scamp ,)"
`scandal	Suffix	"N(`scandal ,)"
`scapegoat	Suffix	"N(`scapegoat ,)"
`scarecrow	Suffix	"N(`scarecrow ,)"
`scat	Suffix	"N(`scat ,)"
`scatterbrain	Suffix	"N(`scatterbrain ,)"
`scattergun	Suffix	"N(`scattergun ,)"
sce`nario	Suffix	"N(sce`nario ,)"
`scene	Suffix	"N(`scene ,)"
`scenery	Suffix	"N(`scene ,)"
`sceptic	Suffix	"N(`sceptic ,)"
sche`matic	Suffix	"N(sche`matic ,)"
`schism	Suffix	"N(`schism ,)"
`schist	Suffix	"N(`schist ,)"
`schizophrenia	Suffix	"N(`schizophrenia ,)"
schizo`phrenic	Suffix	"N(schizo`phrenic ,)"
`schnapps	Suffix	"N(`schnapps ,)"
scho`lastic	Suffix	"N(scho`lastic ,)"
scholar	Suffix	"N(scholar ,)"
`schoolbook	Suffix	"N(`schoolbook ,)"
`schoolboy	Suffix	"N(`schoolboy ,)"
`schoolgirl	Suffix	"N(`schoolgirl ,)"
`schoolhouse	Suffix	"N(`schoolhouse ,)"
`schoolmarm	Suffix	"N(`schoolmarm ,)"
`schoolmaster	Suffix	"N(`schoolmaster ,)"
`schoolmate	Suffix	"N(`schoolmate ,)"
`schoolroom	Suffix	"N(`schoolroom ,)"
`schoolteacher	Suffix	"N(`schoolteacher ,)"
`schoolwork	Suffix	"N(`schoolwork ,)"
`schooner	Suffix	"N(`schooner ,)"
`science	Suffix	"N(`science ,)"
`scientist	Suffix	"N(`scientist ,)"
`scimitar	Suffix	"N(`scimitar ,)"
`scion	Suffix	"N(`scion ,)"
`scoopful	Suffix	"N(`scoop ,)"
`sconce	Suffix	"N(`sconce ,)"
`scone	Suffix	"N(`scone ,)"
`scope	Suffix	"N(`scope ,)"
`scoreboard	Suffix	"N(`scoreboard ,)"
`scorecard	Suffix	"N(`scorecard ,)"
`scotch	Suffix	"N(`scotch ,)"
`scoundrel	Suffix	"N(`scoundrel ,)"
`scrapbook	Suffix	"N(`scrapbook ,)"
`screed	Suffix	"N(`screed ,)"
`screenplay	Suffix	"N(`screenplay ,)"
`screwball	Suffix	"N(`screwball ,)"
`screwdriver	Suffix	"N(`screwdriver ,)"
`scribe	Suffix	"N(`scribe ,)"
`scrim	Suffix	"N(`scrim ,)"
`scripture	Suffix	"N(`scripture ,)"
`scrivener	Suffix	"N(`scrivener ,)"
`scrooge	Suffix	"N(`scrooge ,)"
`scruple	Suffix	"N(`scruple ,)"
`scrupulosity	Suffix	"N(`scruple ,)"
`scrutiny	Suffix	"N(`scrutiny ,)"
`scuba	Suffix	"N(`scuba ,)"
`sculpin	Suffix	"N(`sculpin ,)"
`scum	Suffix	"N(`scum ,)"
`scurvy	Suffix	"N(`scurvy ,)"
`scythe	Suffix	"N(`scythe ,)"
`sea	Suffix	"N(`sea ,)"
`seaboard	Suffix	"N(`seaboard ,)"
`seacoast	Suffix	"N(`seacoast ,)"
`seafarer	Suffix	"N(`seafarer ,)"
`seafood	Suffix	"N(`seafood ,)"
`seamstress	Suffix	"N(`seam ,)"
`seance	Suffix	"N(`seance ,)"
`seaport	Suffix	"N(`seaport ,)"
`seaquake	Suffix	"N(`seaquake ,)"
`searchlight	Suffix	"N(`searchlight ,)"
`seashore	Suffix	"N(`seashore ,)"
`seaside	Suffix	"N(`seaside ,)"
`season	Suffix	"N(`season ,)"
`seawall	Suffix	"N(`seawall ,)"
`seaweed	Suffix	"N(`seaweed ,)"
se`cession	Suffix	"N(se`cede ,deverb)"
se`clusion	Suffix	"N(se`clude ,deverb)"
`second	Suffix	"N(`second ,)"
`secrecy	Suffix	"N(`secret ,)"
secre`tariat	Suffix	"N(secre`tariat ,)"
`secretary	Suffix	"N(`secretary ,)"
`sect	Suffix	"N(`sect ,)"
`sector	Suffix	"N(`sector ,)"
se`dan	Suffix	"N(se`dan ,)"
`sedative	Suffix	"N(se`date ,deverb)"
`seder	Suffix	"N(`seder ,)"
`sedge	Suffix	"N(`sedge ,)"
se`dition	Suffix	"N(se`dition ,)"
se`duction	Suffix	"N(se`duce ,deverb)"
`seedbed	Suffix	"N(`seedbed ,)"
`seepage	Suffix	"N(`seep ,deverb)"
`seersucker	Suffix	"N(`seersucker ,)"
`segment	Suffix	"N(`segment ,ss)"
`segregant	Suffix	"N(`segregant ,)"
`seizure	Suffix	"N(`seize ,deverb)"
`self	Suffix	"N(`self ,)"
`sellout	Suffix	"N(`sellout ,)"
`seltzer	Suffix	"N(`seltzer ,)"
`semaphore	Suffix	"N(`semaphore ,)"
`semblance	Suffix	"N(`semblance ,)"
se`mester	Suffix	"N(se`mester ,)"
`semi	Suffix	"N(`semi ,)"
`seminar	Suffix	"N(`seminar ,)"
`seminary	Suffix	"N(`seminary ,)"
`semite	Suffix	"N(`semite ,)"
`senate	Suffix	"N(`senate ,)"
`senator	Suffix	"N(`senator ,)"
se`nor	Suffix	"N(se`nor ,)"
senor`ita	Suffix	"N(senor`ita ,)"
`sentiment	Suffix	"N(`sentiment ,)"
`sentinel	Suffix	"N(`sentinel ,)"
`sentry	Suffix	"N(`sentry ,)"
separa`bility	Suffix	"N(`separate ,deverb+deajr)"
sep`tet	Suffix	"N(sep`tet ,)"
septuagen`arian	Suffix	"N(septuagen`arian ,)"
`sepulcher	Suffix	"N(`sepulcher ,)"
`sepulchre	Suffix	"N(`sepulchre ,)"
`sequel	Suffix	"N(`sequel ,)"
seques`tration	Suffix	"N(se`quester ,deverb)"
`sequin	Suffix	"N(`sequin ,ajr8)"
se`rape	Suffix	"N(se`rape ,)"
seren`dipity	Suffix	"N(seren`dipity ,)"
`serf	Suffix	"N(`serf ,)"
`serge	Suffix	"N(`serge ,)"
`sergeant	Suffix	"N(`sergeant ,)"
`serif	Suffix	"N(`serif ,)"
`sermon	Suffix	"N(`sermon ,)"
`serpent	Suffix	"N(`serpent ,)"
`servant	Suffix	"N(`servant ,)"
servi`ette	Suffix	"N(servi`ette ,)"
`servitor	Suffix	"N(`servitor ,)"
`servitude	Suffix	"N(`servitude ,)"
`sesame	Suffix	"N(`sesame ,)"
`session	Suffix	"N(`session ,)"
`set	Suffix	"N(`set ,)"
`setback	Suffix	"N(`setback ,)"
`setscrew	Suffix	"N(`setscrew ,)"
`setup	Suffix	"N(`setup ,)"
`sewage	Suffix	"N(`sewage ,)"
`sewer	Suffix	"N(`sewer ,)"
`sewerage	Suffix	"N(`sewer ,)"
sex`tet	Suffix	"N(sex`tet ,)"
`sexton	Suffix	"N(`sexton ,)"
sex`tuple	Suffix	"N(sex`tuple ,)"
sex`tuplet	Suffix	"N(sex`tuplet ,)"
`shack	Suffix	"N(`shack ,)"
`shad	Suffix	"N(`shad ,)"
`shaft	Suffix	"N(`shaft ,)"
`shag	Suffix	"N(`shag ,)"
`shah	Suffix	"N(`shah ,)"
`shake	Suffix	"N(`shake ,)"
`shakedown	Suffix	"N(`shakedown ,)"
`shale	Suffix	"N(`shale ,)"
`shallot	Suffix	"N(`shallot ,)"
`sham	Suffix	"N(`sham ,)"
`shaman	Suffix	"N(`shaman ,)"
`shamrock	Suffix	"N(`shamrock ,)"
`shanty	Suffix	"N(`shanty ,)"
`shard	Suffix	"N(`shard ,)"
`shareholder	Suffix	"N(`shareholder ,)"
`shareware	Suffix	"N(`shareware ,)"
`shark	Suffix	"N(`shark ,)"
`sharecroper	Suffix	"N(`sharecroper ,)"
`sharpshooter	Suffix	"N(`sharpshooter ,)"
`shawl	Suffix	"N(`shawl ,)"
`sheath	Suffix	"N(`sheath ,)"
`shed	Suffix	"N(`shed ,)"
`sheen	Suffix	"N(`sheen ,)"
`sheepfold	Suffix	"N(`sheepfold ,)"
`sheepskin	Suffix	"N(`sheepskin ,)"
`sheet	Suffix	"N(`sheet ,)"
`sheik	Suffix	"N(`sheik ,)"
`sheikh	Suffix	"N(`sheikh ,)"
`shekel	Suffix	"N(`shekel ,)"
`shelfful	Suffix	"N(`shelf ,)"
`shelving	Suffix	"N(`shelf ,)"
she`nanigan	Suffix	"N(she`nanigan ,)"
`sherbet	Suffix	"N(`sherbet ,)"
`sheriff	Suffix	"N(`sheriff ,)"
`sherry	Suffix	"N(`sherry ,)"
`shibboleth	Suffix	"N(`shibboleth ,)"
`shilling	Suffix	"N(`shilling ,)"
`shim	Suffix	"N(`shim ,)"
`shin	Suffix	"N(`shin ,)"
`shinbone	Suffix	"N(`shinbone ,)"
`shipmate	Suffix	"N(`shipmate ,)"
`shipyard	Suffix	"N(`shipyard ,)"
`shire	Suffix	"N(`shire ,)"
`shirt	Suffix	"N(`shirt ,)"
shle`miel	Suffix	"N(shle`miel ,)"
`shoal	Suffix	"N(`shoal ,)"
`shoehorn	Suffix	"N(`shoehorn ,)"
`shoelace	Suffix	"N(`shoelace ,)"
`shoestring	Suffix	"N(`shoestring ,)"
`shoofly	Suffix	"N(`shoofly ,)"
`shootout	Suffix	"N(`shootout ,)"
`shoptalk	Suffix	"N(`shoptalk ,)"
`shore	Suffix	"N(`shore ,)"
`shoreline	Suffix	"N(`shoreline ,)"
`shortage	Suffix	"N(`short ,deadj)"
`shortcoming	Suffix	"N(`shortcoming ,)"
`shortcut	Suffix	"N(`shortcut ,)"
`shortfall	Suffix	"N(`shortfall ,)"
`shorthand	Suffix	"N(`shorthand ,)"
`shortstop	Suffix	"N(`shortstop ,)"
`shot	Suffix	"N(`shot ,)"
`shotgun	Suffix	"N(`shotgun ,)"
`shovelful	Suffix	"N(`shovel ,)"
`show	Suffix	"N(`show ,)"
`showboat	Suffix	"N(`showboat ,)"
`showcase	Suffix	"N(`showcase ,)"
`showdown	Suffix	"N(`showdown ,)"
`showpiece	Suffix	"N(`showpiece ,)"
`showplace	Suffix	"N(`showplace ,)"
`showroom	Suffix	"N(`showroom ,)"
`shrapnel	Suffix	"N(`shrapnel ,)"
`shrift	Suffix	"N(`shrift ,)"
`shrike	Suffix	"N(`shrike ,)"
`shrine	Suffix	"N(`shrine ,)"
`shrub	Suffix	"N(`shrub ,)"
`shrubbery	Suffix	"N(`shrub ,)"
`shuffleboard	Suffix	"N(`shuffleboard ,)"
`shutdown	Suffix	"N(`shutdown ,)"
`shutoff	Suffix	"N(`shutoff ,)"
`shutout	Suffix	"N(`shutout ,)"
`shuttlecock	Suffix	"N(`shuttlecock ,)"
`sib	Suffix	"N(`sib ,)"
`sibling	Suffix	"N(`sibling ,)"
`sibyl	Suffix	"N(`sibyl ,)"
`sickle	Suffix	"N(`sickle ,)"
`sickroom	Suffix	"N(`sickroom ,)"
`sideband	Suffix	"N(`sideband ,)"
`sideboard	Suffix	"N(`sideboard ,)"
`sideburn	Suffix	"N(`sideburn ,)"
`sidecar	Suffix	"N(`sidecar ,)"
`sidelight	Suffix	"N(`sidelight ,)"
`sideline	Suffix	"N(`sideline ,)"
`sidesaddle	Suffix	"N(`sidesaddle ,)"
`sideshow	Suffix	"N(`sideshow ,)"
`sidewalk	Suffix	"N(`sidewalk ,)"
`sidewall	Suffix	"N(`sidewall ,)"
`sidewinder	Suffix	"N(`sidewinder ,)"
`siding	Suffix	"N(`side ,)"
`siege	Suffix	"N(`siege ,)"
si`enna	Suffix	"N(si`enna ,)"
si`erra	Suffix	"N(si`erra ,)"
si`esta	Suffix	"N(si`esta ,)"
`signatory	Suffix	"N(`signatory ,)"
`signature	Suffix	"N(`sign ,deverb)"
`signboard	Suffix	"N(`signboard ,)"
sig`nificance	Suffix	"N(sig`nificant ,deadj)"
`signpost	Suffix	"N(`signpost ,)"
`sikh	Suffix	"N(`sikh ,)"
`silage	Suffix	"N(`silo ,)"
`silica	Suffix	"N(`silica ,)"
`silk	Suffix	"N(`silk ,)"
`sill	Suffix	"N(`sill ,)"
`silo	Suffix	"N(`silo ,)"
`silversmith	Suffix	"N(`silversmith ,)"
`silverware	Suffix	"N(`silverware ,)"
`simile	Suffix	"N(`simile ,)"
si`militude	Suffix	"N(si`militude ,)"
simpleton	Suffix	"N(simpleton ,)"
`simplicity	Suffix	"N(`simplicity ,)"
simultan`eity	Suffix	"N(simultan`eity ,)"
`sine	Suffix	"N(`sine ,)"
`sinecure	Suffix	"N(`sinecure ,)"
`sinew	Suffix	"N(`sinew ,)"
`singlet	Suffix	"N(`singlet ,)"
`singleton	Suffix	"N(`singleton ,)"
`singsong	Suffix	"N(`singsong ,)"
`sinkhole	Suffix	"N(`sinkhole ,)"
`sinus	Suffix	"N(`sinus ,)"
`sir	Suffix	"N(`sir ,)"
`siren	Suffix	"N(`siren ,)"
`sirloin	Suffix	"N(`sirloin ,)"
`sis	Suffix	"N(`sis ,)"
`sisal	Suffix	"N(`sisal ,)"
`sister	Suffix	"N(`sister ,)"
`sitcom	Suffix	"N(`sitcom - situation comedy,)"
`site	Suffix	"N(`site ,)"
`sixgun	Suffix	"N(`sixgun ,)"
`skat	Suffix	"N(`skat ,)"
`skeet	Suffix	"N(`skeet ,)"
`skeleton	Suffix	"N(`skeleton ,)"
`skeptic	Suffix	"N(`skeptic ,)"
`sketchbook	Suffix	"N(`sketchbook ,)"
`sketchpad	Suffix	"N(`sketchpad ,)"
`skiff	Suffix	"N(`skiff ,)"
`skill	Suffix	"N(`skill ,ajr8)"
`skillet	Suffix	"N(`skillet ,)"
`skinhead	Suffix	"N(`skinhead ,)"
`skinful	Suffix	"N(`skin ,)"
`skipjack	Suffix	"N(`skipjack ,)"
`skit	Suffix	"N(`skit ,)"
`skull	Suffix	"N(`skull ,)"
`skullcap	Suffix	"N(`skullcap ,)"
`skullduggery	Suffix	"N(`skullduggery ,)"
`skunk	Suffix	"N(`skunk ,)"
`sky	Suffix	"N(`sky ,)"
`skyhook	Suffix	"N(`skyhook ,)"
`skylark	Suffix	"N(`skylark ,)"
`skylight	Suffix	"N(`skylight ,)"
`skyline	Suffix	"N(`skyline ,)"
`skyscraper	Suffix	"N(`skyscraper ,)"
`skyway	Suffix	"N(`skyway ,)"
`slab	Suffix	"N(`slab ,)"
`slack	Suffix	"N(`slack ,)"
`slag	Suffix	"N(`slag ,)"
`slang	Suffix	"N(`slang ,)"
`slapstick	Suffix	"N(`slapstick ,)"
`slat	Suffix	"N(`slat ,)"
`slate	Suffix	"N(`slate ,)"
`slattern	Suffix	"N(`slattern ,)"
`slaughterhouse	Suffix	"N(`slaughterhouse ,)"
`slavery	Suffix	"N(`slave ,)"
`sleaze	Suffix	"N(`sleaze ,)"
`sled	Suffix	"N(`sled ,)"
`sledge	Suffix	"N(`sledge ,)"
`sledgehammer	Suffix	"N(`sledgehammer ,)"
`sleep	Suffix	"N(`sleep ,)"
`sleeve	Suffix	"N(`sleeve ,)"
`sleigh	Suffix	"N(`sleigh ,)"
`sleight	Suffix	"N(`sleight ,)"
`slew	Suffix	"N(`slew ,)"
`slime	Suffix	"N(`slime ,)"
`sling	Suffix	"N(`sling ,)"
`slingshot	Suffix	"N(`slingshot ,)"
`slit	Suffix	"N(`slit ,)"
`sliver	Suffix	"N(`sliver ,)"
`slob	Suffix	"N(`slob ,)"
`sloe	Suffix	"N(`sloe ,)"
`slogan	Suffix	"N(`slogan ,)"
`sloop	Suffix	"N(`sloop ,)"
`slot	Suffix	"N(`slot ,)"
`sloth	Suffix	"N(`sloth ,)"
`slough	Suffix	"N(`slough ,)"
`sloven	Suffix	"N(`sloven ,)"
`slowdown	Suffix	"N(`slowdown ,)"
`sludge	Suffix	"N(`sludge ,)"
`slug	Suffix	"N(`slug ,)"
`sluggard	Suffix	"N(`sluggard ,)"
`sluice	Suffix	"N(`sluice ,)"
`slum	Suffix	"N(`slum ,)"
`slurry	Suffix	"N(`slurry ,)"
`slush	Suffix	"N(`slush ,)"
`slut	Suffix	"N(`slut ,)"
`smallpox	Suffix	"N(`smallpox ,)"
`smith	Suffix	"N(`smith ,)"
`smithy	Suffix	"N(`smithy ,)"
`smock	Suffix	"N(`smock ,)"
`smog	Suffix	"N(`smog ,)"
`smokehouse	Suffix	"N(`smokehouse ,)"
`smokescreen	Suffix	"N(`smokescreen ,)"
`smokestack	Suffix	"N(`smokestack ,)"
`smut	Suffix	"N(`smut ,)"
`snafu	Suffix	"N(`snafu ,)"
`snail	Suffix	"N(`snail ,)"
`snapshot	Suffix	"N(`snapshot ,)"
`snark	Suffix	"N(`snark ,)"
`snell	Suffix	"N(`snell ,)"
`snifter	Suffix	"N(`snifter ,)"
`snippet	Suffix	"N(`snippet ,)"
`snob	Suffix	"N(`snob ,)"
`snobbery	Suffix	"N(`snob ,)"
`snook	Suffix	"N(`snook ,)"
`snorkel	Suffix	"N(`snorkel ,)"
`snot	Suffix	"N(`snot ,)"
`snout	Suffix	"N(`snout ,)"
`snowball	Suffix	"N(`snowball ,)"
`snowfall	Suffix	"N(`snowfall ,)"
`snowflake	Suffix	"N(`snowflake ,)"
`snowmobile	Suffix	"N(`snowmobile ,)"
`snowshoe	Suffix	"N(`snowshoe ,)"
`snowstorm	Suffix	"N(`snowstorm ,)"
`soapstone	Suffix	"N(`soapstone ,)"
so`briety	Suffix	"N(`sober ,deadj)"
`sobriquet	Suffix	"N(`sobriquet ,)"
`soccer	Suffix	"N(`soccer ,)"
socia`bility	Suffix	"N(`sociable ,deadj)"
`socialite	Suffix	"N(`social ,deadj)"
so`ciety	Suffix	"N(so`ciety ,)"
`sociopath	Suffix	"N(`sociopath ,)"
`sock	Suffix	"N(`sock ,)"
`socket	Suffix	"N(`socket ,)"
`sod	Suffix	"N(`sod ,)"
`soda	Suffix	"N(`soda ,)"
`sodomy	Suffix	"N(`sodomy ,)"
`sofa	Suffix	"N(`sofa ,)"
`soffit	Suffix	"N(`soffit ,)"
`softball	Suffix	"N(`softball ,)"
`software	Suffix	"N(`software ,)"
`softwood	Suffix	"N(`softwood ,)"
soi`ree	Suffix	"N(soi`ree ,)"
`solace	Suffix	"N(`solace ,)"
`soldier	Suffix	"N(`soldier ,)"
`soldiery	Suffix	"N(`soldier ,)"
`solecism	Suffix	"N(`solecism ,)"
so`licitude	Suffix	"N(so`licitude ,)"
soli`darity	Suffix	"N(soli`darity ,)"
`solipsism	Suffix	"N(`solipsism ,)"
`solitaire	Suffix	"N(`solitaire ,)"
`solitude	Suffix	"N(`solitude ,)"
`solstice	Suffix	"N(`solstice ,)"
solu`bility	Suffix	"N(`soluble ,deadj)"
`solute	Suffix	"N(`solute ,)"
so`lution	Suffix	"N(so`lution ,)"
`solvency	Suffix	"N(`solvent ,deadj)"
`solvent	Suffix	"N(`solvent ,)"
`somnolence	Suffix	"N(`somnolent ,deadj)"
`son	Suffix	"N(`son ,)"
`sonar	Suffix	"N(`sonar ,)"
so`nata	Suffix	"N(so`nata ,)"
`song	Suffix	"N(`song ,)"
`songbook	Suffix	"N(`songbook ,)"
`sonnet	Suffix	"N(`sonnet ,)"
`sonny	Suffix	"N(`son ,)"
`sonogram	Suffix	"N(`sonogram ,)"
so`nority	Suffix	"N(so`nority ,)"
`soot	Suffix	"N(`soot ,)"
`sop	Suffix	"N(`sop ,)"
`sophism	Suffix	"N(`sophism ,)"
`sophist	Suffix	"N(`sophist ,)"
`sophistry	Suffix	"N(`sophist ,)"
`sophomore	Suffix	"N(`sophomore ,)"
so`prano	Suffix	"N(so`prano ,)"
`sorcerer	Suffix	"N(`sorcery ,)"
`sorceress	Suffix	"N(`sorcery ,)"
`sorcery	Suffix	"N(`sorcery ,)"
`sorghum	Suffix	"N(`sorghum ,)"
so`rority	Suffix	"N(so`rority ,)"
`sorption	Suffix	"N(`sorb ,deverb)"
`sorrel	Suffix	"N(`sorrel ,)"
`sortie	Suffix	"N(`sortie ,)"
`sou	Suffix	"N(`sou ,)"
souf`fle	Suffix	"N(souf`fle ,)"
`soul	Suffix	"N(`soul ,)"
`soup	Suffix	"N(`soup ,)"
`source	Suffix	"N(`source ,)"
`sour	Suffix	"N(`sour ,)"
`sourdough	Suffix	"N(`sourdough ,)"
`southerner	Suffix	"N(`southerner ,)"
`southland	Suffix	"N(`southland ,)"
`southpaw	Suffix	"N(`southpaw ,)"
south`westerner	Suffix	"N(south`westerner ,)"
souve`nir	Suffix	"N(souve`nir ,)"
sou'`wester	Suffix	"N(sou'`wester ,)"
`sovereignty	Suffix	"N(`sovereign ,deadj)"
`soviet	Suffix	"N(`soviet ,)"
`sow	Suffix	"N(`sow ,)"
`sowbelly	Suffix	"N(`sowbelly ,)"
`soy	Suffix	"N(`soy ,)"
`soya	Suffix	"N(`soya ,)"
`spa	Suffix	"N(`spa ,)"
`spacecraft	Suffix	"N(`spacecraft ,)"
`spacesuit	Suffix	"N(`spacesuit ,)"
`spadeful	Suffix	"N(`spade ,)"
spa`ghetti	Suffix	"N(spa`ghetti ,)"
`spandrel	Suffix	"N(`spandrel ,)"
`spaniel	Suffix	"N(`spaniel ,)"
`spar	Suffix	"N(`spar ,)"
`spare	Suffix	"N(`spare ,)"
`sparrow	Suffix	"N(`sparrow ,)"
`spasm	Suffix	"N(`spasm ,)"
`spat	Suffix	"N(`spat ,)"
`spate	Suffix	"N(`spate ,)"
`spatula	Suffix	"N(`spatula ,)"
`speakeasy	Suffix	"N(`speakeasy ,)"
`spearmint	Suffix	"N(`spearmint ,)"
`specialty	Suffix	"N(`special ,deadj)"
spe`cific	Suffix	"N(spe`cific ,)"
specifi`cation	Suffix	"N(`specify ,deverb)"
`specimen	Suffix	"N(`specimen ,)"
`spectacle	Suffix	"N(`spectacle ,)"
`spectator	Suffix	"N(`spectator ,)"
`specter	Suffix	"N(`specter ,)"
`spectre	Suffix	"N(`spectre ,)"
`speech	Suffix	"N(`speech ,)"
`speedboat	Suffix	"N(`speedboat ,)"
speed`ometer	Suffix	"N(speed`ometer ,)"
`speedup	Suffix	"N(`speedup ,)"
`sperm	Suffix	"N(`sperm ,)"
sperma`ceti	Suffix	"N(sperma`ceti ,)"
`sphere	Suffix	"N(`sphere ,)"
`spherule	Suffix	"N(`spherule ,)"
`sphinx	Suffix	"N(`sphinx ,)"
`spider	Suffix	"N(`spider ,)"
`spiel	Suffix	"N(`spiel ,)"
`spigot	Suffix	"N(`spigot ,)"
`spike	Suffix	"N(`spike ,)"
`spikenard	Suffix	"N(`spikenard ,)"
`spill	Suffix	"N(`spill ,)"
`spinach	Suffix	"N(`spinach ,)"
`spine	Suffix	"N(`spine ,)"
`spinnaker	Suffix	"N(`spinnaker ,)"
`spinneret	Suffix	"N(`spinneret ,)"
`spinoff	Suffix	"N(`spinoff ,)"
`spinster	Suffix	"N(`spinster ,)"
`spire	Suffix	"N(`spire ,)"
`spiritual	Suffix	"N(`spirit ,)"
`spit	Suffix	"N(`spit ,)"
`spite	Suffix	"N(`spite ,)"
`spitfire	Suffix	"N(`spitfire ,)"
`spittle	Suffix	"N(`spittle ,)"
`spitz	Suffix	"N(`spitz ,)"
`splat	Suffix	"N(`splat ,)"
`spleen	Suffix	"N(`spleen ,)"
`splendor	Suffix	"N(`splendor ,)"
`splendour	Suffix	"N(`splendour - British,)"
`spline	Suffix	"N(`spline ,)"
`split	Suffix	"N(`split ,)"
`splotch	Suffix	"N(`splotch ,)"
`spoil	Suffix	"N(`spoil ,)"
`spoke	Suffix	"N(`spoke ,)"
`spokesperson	Suffix	"N(`spokesperson ,)"
sponta`neity	Suffix	"N(sponta`neity ,)"
`spoonful	Suffix	"N(`spoon ,)"
`spoor	Suffix	"N(`spoor ,)"
`spore	Suffix	"N(`spore ,)"
`sport	Suffix	"N(`sport ,)"
`sports	Suffix	"N(`sports ,)"
`sportswear	Suffix	"N(`sportswear ,)"
`spot	Suffix	"N(`spot ,)"
`spouse	Suffix	"N(`spouse ,)"
`spreadsheet	Suffix	"N(`spreadsheet ,)"
`spree	Suffix	"N(`spree ,)"
`sprig	Suffix	"N(`sprig ,)"
`spring	Suffix	"N(`spring ,)"
`springboard	Suffix	"N(`springboard ,)"
`springtime	Suffix	"N(`springtime ,)"
`sprite	Suffix	"N(`sprite ,)"
`sprocket	Suffix	"N(`sprocket ,)"
`spud	Suffix	"N(`spud ,)"
`spume	Suffix	"N(`spume ,)"
spu`moni	Suffix	"N(spu`moni ,)"
`spunk	Suffix	"N(`spunk ,)"
`spurge	Suffix	"N(`spurge ,)"
`sputnik	Suffix	"N(`sputnik ,)"
`spyglass	Suffix	"N(`spyglass ,)"
`squab	Suffix	"N(`squab ,)"
`squad	Suffix	"N(`squad ,)"
`squadron	Suffix	"N(`squadron ,)"
`squall	Suffix	"N(`squall ,)"
`squalor	Suffix	"N(`squalor ,)"
`square	Suffix	"N(`square ,)"
`squash	Suffix	"N(`squash ,)"
`squaw	Suffix	"N(`squaw ,)"
`squire	Suffix	"N(`squire ,)"
`stable	Suffix	"N(`stable ,)"
`stag	Suffix	"N(`stag ,)"
`stagecoach	Suffix	"N(`stagecoach ,)"
`staging	Suffix	"N(`stage ,)"
`stair	Suffix	"N(`stair ,)"
`staircase	Suffix	"N(`staircase ,)"
`stairway	Suffix	"N(`stairway ,)"
`stairwell	Suffix	"N(`stairwell ,)"
sta`lactite	Suffix	"N(sta`lactite ,)"
`stalk	Suffix	"N(`stalk ,)"
`stall	Suffix	"N(`stall ,)"
`stallion	Suffix	"N(`stallion ,)"
`stamina	Suffix	"N(`stamina ,)"
`stance	Suffix	"N(`stance ,)"
`stanchion	Suffix	"N(`stanchion ,)"
`stand	Suffix	"N(`stand - of trees,)"
`standard	Suffix	"N(`standard ,)"
`standby	Suffix	"N(`standby ,)"
`standoff	Suffix	"N(`standoff ,)"
`standpoint	Suffix	"N(`standpoint ,)"
`standstill	Suffix	"N(`standstill ,)"
`stanza	Suffix	"N(`stanza ,)"
`staph	Suffix	"N(`staph - staphylo`coccus,)"
`starboard	Suffix	"N(`starboard ,)"
`starlight	Suffix	"N(`starlight ,)"
`startup	Suffix	"N(`startup ,)"
`state	Suffix	"N(`state ,)"
`stateroom	Suffix	"N(`stateroom ,)"
`static	Suffix	"N(`static ,)"
`stationery	Suffix	"N(`stationery ,)"
`stationmaster	Suffix	"N(`stationmaster ,)"
sta`tistic	Suffix	"N(sta`tistic ,)"
`stator	Suffix	"N(`stator ,)"
`statuary	Suffix	"N(`statuary ,)"
`statue	Suffix	"N(`statue ,)"
`stature	Suffix	"N(`stature ,)"
`status	Suffix	"N(`status ,)"
`statute	Suffix	"N(`statute ,)"
`stead	Suffix	"N(`stead ,)"
`steak	Suffix	"N(`steak ,)"
`steal	Suffix	"N(`steal ,)"
`stealth	Suffix	"N(`stealth ,)"
`steamboat	Suffix	"N(`steamboat ,)"
`steed	Suffix	"N(`steed ,)"
`steeple	Suffix	"N(`steeple ,)"
`stein	Suffix	"N(`stein ,)"
`stem	Suffix	"N(`stem ,)"
`stench	Suffix	"N(`stench ,)"
`steppe	Suffix	"N(`steppe ,)"
`stereo	Suffix	"N(`stereo ,)"
`sterling	Suffix	"N(`sterling ,)"
`stern	Suffix	"N(`stern ,)"
`steroid	Suffix	"N(`steroid ,)"
`stethoscope	Suffix	"N(`stethoscope ,)"
`stevedore	Suffix	"N(`stevedore ,)"
`steward	Suffix	"N(`steward ,)"
`stick	Suffix	"N(`stick ,)"
`stickpin	Suffix	"N(`stickpin ,)"
`stile	Suffix	"N(`stile ,)"
`still	Suffix	"N(`still ,)"
`stillbirth	Suffix	"N(`stillbirth ,)"
`stilt	Suffix	"N(`stilt ,)"
`stimulant	Suffix	"N(`stimulant ,)"
`stint	Suffix	"N(`stint ,)"
`stipend	Suffix	"N(`stipend ,)"
`stirrup	Suffix	"N(`stirrup ,)"
stock`ade	Suffix	"N(stock`ade ,)"
`stockbroker	Suffix	"N(`stockbroker ,)"
`stockholder	Suffix	"N(`stockholder ,)"
`stocking	Suffix	"N(`stocking ,)"
`stockroom	Suffix	"N(`stockroom ,)"
`stoic	Suffix	"N(`stoic ,)"
`stomachs	Clitic	"N(`stomach - exception to Epenthesis,pl irreg)"
`stoneware	Suffix	"N(`stoneware ,)"
`stooge	Suffix	"N(`stooge ,)"
`stool	Suffix	"N(`stool ,)"
`stopgap	Suffix	"N(`stopgap ,)"
`stopover	Suffix	"N(`stopover ,)"
`stopwatch	Suffix	"N(`stopwatch ,)"
`storehouse	Suffix	"N(`storehouse ,)"
`storeroom	Suffix	"N(`storeroom ,)"
`stork	Suffix	"N(`stork ,)"
`story	Suffix	"N(`story ,ajr8)"
`storyboard	Suffix	"N(`storyboard ,)"
`storyteller	Suffix	"N(`storyteller ,)"
`stove	Suffix	"N(`stove ,)"
`stowaway	Suffix	"N(`stowaway ,)"
`strait	Suffix	"N(`strait ,)"
`strand	Suffix	"N(`strand ,)"
`stranger	Suffix	"N(`stranger ,)"
`stranglehold	Suffix	"N(`stranglehold ,)"
`stratagem	Suffix	"N(`stratagem ,)"
`strategist	Suffix	"N(`strategy ,)"
`strategy	Suffix	"N(`strategy ,)"
stratifi`cation	Suffix	"N(`stratify ,deverb)"
`stratosphere	Suffix	"N(`stratosphere ,)"
`straw	Suffix	"N(`straw ,)"
`strawberry	Suffix	"N(`strawberry ,)"
`strawflower	Suffix	"N(`strawflower ,)"
`street	Suffix	"N(`street ,)"
`streetcar	Suffix	"N(`streetcar ,)"
`strength	Suffix	"N(`strength ,)"
`stricture	Suffix	"N(`stricture ,)"
`strife	Suffix	"N(`strife ,)"
`strike	Suffix	"N(`strike ,)"
`string	Suffix	"N(`string ,)"
`striptease	Suffix	"N(`striptease ,)"
`strobe	Suffix	"N(`strobe ,)"
`stronghold	Suffix	"N(`stronghold ,)"
`strongroom	Suffix	"N(`strongroom ,)"
`strop	Suffix	"N(`strop ,)"
`strophe	Suffix	"N(`strophe ,)"
`structuralism	Suffix	"N(`structure ,)"
`strut	Suffix	"N(`strut ,)"
`strychnine	Suffix	"N(`strychnine ,)"
`stub	Suffix	"N(`stub ,)"
`stubble	Suffix	"N(`stubble ,)"
`stud	Suffix	"N(`stud ,)"
`student	Suffix	"N(`student ,)"
`studio	Suffix	"N(`studio ,)"
`study	Suffix	"N(`study ,)"
`stuff	Suffix	"N(`stuff ,)"
stultifi`cation	Suffix	"N(`stultify ,deverb)"
`stump	Suffix	"N(`stump ,)"
`stunt	Suffix	"N(`stunt ,)"
stupe`faction	Suffix	"N(`stupify ,deverb)"
`stupor	Suffix	"N(`stupor ,)"
`stylist	Suffix	"N(`style ,)"
`stylite	Suffix	"N(`style ,)"
`styrene	Suffix	"N(`styrene ,)"
`styrofoam	Suffix	"N(`styrofoam ,)"
`sub	Suffix	"N(`sub - submarine,)"
`submarine	Suffix	"N(`submarine ,)"
`subject	Suffix	"N(`subject ,ss)"
sub`mission	Suffix	"N(sub`mit ,deverb)"
sub`scription	Suffix	"N(sub`scribe ,deverb)"
sub`servience	Suffix	"N(sub`servient ,deadj)"
`subsidy	Suffix	"N(`subsidy ,)"
sub`stituent	Suffix	"N(sub`stituent ,)"
`substrate	Suffix	"N(`substrate ,)"
`subterfuge	Suffix	"N(`subterfuge ,)"
`subtlety	Suffix	"N(`subtle ,deadj)"
sub`tracter	Suffix	"N(sub`tracter ,)"
`subtrahend	Suffix	"N(`subtrahend ,)"
`suburb	Suffix	"N(`suburb ,)"
sub`urbia	Suffix	"N(`suburb ,)"
sub`vention	Suffix	"N(sub`vention ,)"
sub`version	Suffix	"N(sub`vert ,deverb)"
suc`cess	Suffix	"N(suc`cess ,)"
suc`cession	Suffix	"N(suc`ceed ,deverb)"
suc`cessor	Suffix	"N(suc`ceed ,deverb)"
`succulence	Suffix	"N(`succulent ,deadj)"
`suction	Suffix	"N(`suck ,deverb)"
`suet	Suffix	"N(`suet ,)"
suf`ficiency	Suffix	"N(suf`fice ,deverb+deajr)"
`suffrage	Suffix	"N(`suffrage ,)"
`suffragan	Suffix	"N(`suffragan ,)"
`suicide	Suffix	"N(`suicide ,)"
`suit	Suffix	"N(`suit ,)"
`suitcase	Suffix	"N(`suitcase ,)"
`suite	Suffix	"N(`suite ,)"
`suitor	Suffix	"N(`suitor ,)"
`sulfur	Suffix	"N(`sulfur ,)"
`sulphur	Suffix	"N(`sulphur ,)"
`sultan	Suffix	"N(`sultan ,)"
`sultanate	Suffix	"N(`sultanate ,)"
`sumac	Suffix	"N(`sumac ,)"
`summand	Suffix	"N(`summand ,)"
`summary	Suffix	"N(`summary ,)"
`summertime	Suffix	"N(`summertime ,)"
`summit	Suffix	"N(`summit ,)"
`summitry	Suffix	"N(`summit ,)"
`sump	Suffix	"N(`sump ,)"
`sunbeam	Suffix	"N(`sunbeam ,)"
`sunbonnet	Suffix	"N(`sunbonnet ,)"
`sundew	Suffix	"N(`sundew ,)"
`sundial	Suffix	"N(`sundial ,)"
`sundown	Suffix	"N(`sundown ,)"
`sunlight	Suffix	"N(`sunlight ,)"
`sunrise	Suffix	"N(`sunrise ,)"
`sunset	Suffix	"N(`sunset ,)"
`sunshade	Suffix	"N(`sunshade ,)"
`sunshine	Suffix	"N(`sunshine ,)"
`sunspot	Suffix	"N(`sunspot ,)"
`suntan	Suffix	"N(`suntan ,ajr8)"
super`fluity	Suffix	"N(super`fluity ,)"
superin`tendent	Suffix	"N(superin`tend ,deverb)"
super`stition	Suffix	"N(super`stition ,)"
sup`pository	Suffix	"N(sup`pository ,)"
su`premacist	Suffix	"N(su`preme ,deadj)"
su`premacy	Suffix	"N(su`preme ,deadj)"
`surety	Suffix	"N(`sure ,deadj)"
sur`feit	Suffix	"N(sur`feit ,)"
`surgeon	Suffix	"N(`surgeon ,)"
`surgery	Suffix	"N(`surgery ,)"
`surplus	Suffix	"N(`surplus ,)"
`surrey	Suffix	"N(`surrey ,)"
`surrogate	Suffix	"N(`surrogate ,)"
`surtax	Suffix	"N(`tax ,)"
`survey	Suffix	"N(`survey ,ss)"
suscepti`bility	Suffix	"N(sus`ceptible ,deadj)"
`sushi	Suffix	"N(`sushi ,)"
`suspect	Suffix	"N(`suspect ,ss)"
sus`pense	Suffix	"N(sus`pense ,)"
sus`pension	Suffix	"N(sus`pend ,deverb)"
sus`picion	Suffix	"N(sus`pect ,deverb)"
`sustenance	Suffix	"N(sus`tain ,deverb)"
`suzerain	Suffix	"N(`suzerain ,)"
`suzerainty	Suffix	"N(`suzerainty ,)"
`swag	Suffix	"N(`swag ,)"
`swain	Suffix	"N(`swain ,)"
`swallow	Suffix	"N(`swallow ,)"
`swami	Suffix	"N(`swami ,)"
`swan	Suffix	"N(`swan ,)"
`swastika	Suffix	"N(`swastika ,)"
`swatch	Suffix	"N(`swatch ,)"
`swath	Suffix	"N(`swath ,)"
`swathe	Suffix	"N(`swathe ,)"
`sweatband	Suffix	"N(`sweatband ,)"
`sweat	Suffix	"N(`sweat ,)"
`sweater	Suffix	"N(`sweater ,)"
`sweatshirt	Suffix	"N(`sweatshirt ,)"
`sweepstake	Suffix	"N(`sweepstake ,)"
`sweetheart	Suffix	"N(`sweetheart ,)"
`swimsuit	Suffix	"N(`swimsuit ,)"
`swing	Suffix	"N(`swing ,)"
`switchblade	Suffix	"N(`switchblade ,)"
`switchboard	Suffix	"N(`switchboard ,)"
`swizzle	Suffix	"N(`swizzle ,)"
`sword	Suffix	"N(`sword ,)"
`swordplay	Suffix	"N(`swordplay ,)"
`sycophant	Suffix	"N(`sycophant ,)"
syl`labic	Suffix	"N(`syllable ,)"
syllabifi`cation	Suffix	"N(`syllable ,deverb)"
`syllable	Suffix	"N(`syllable ,)"
`syllogism	Suffix	"N(`syllogism ,)"
`syllogist	Suffix	"N(`syllogist ,)"
symbi`osis	Suffix	"N(symbi`osis ,)"
`symbol	Suffix	"N(`symbol ,)"
`symbolism	Suffix	"N(`symbol ,)"
`symmetry	Suffix	"N(`symmetry ,)"
`symphony	Suffix	"N(`symphony ,)"
`symptom	Suffix	"N(`symptom ,)"
`synagogue	Suffix	"N(`synagogue ,)"
`synchronism	Suffix	"N(`synchrony ,)"
`synchrony	Suffix	"N(`synchrony ,)"
`syncope	Suffix	"N(`syncope ,)"
`syndrome	Suffix	"N(`syndrome ,)"
`synergism	Suffix	"N(`synergy ,)"
`synergy	Suffix	"N(`synergy ,)"
`synod	Suffix	"N(`synod ,)"
`synonym	Suffix	"N(`synonym ,)"
syn`onymy	Suffix	"N(syn`onymy ,)"
`syntax	Suffix	"N(`syntax ,)"
`syphon	Suffix	"N(`syphon ,)"
sy`ringe	Suffix	"N(sy`ringe ,)"
`syrup	Suffix	"N(`syrup ,)"
`system	Suffix	"N(`system ,)"
`tab	Suffix	"N(`tab ,)"
`tabernacle	Suffix	"N(`tabernacle ,)"
`tablecloth	Suffix	"N(`tablecloth ,)"
`tableful	Suffix	"N(`table ,)"
`tableland	Suffix	"N(`tableland ,)"
`tablespoon	Suffix	"N(`tablespoon ,)"
`tablespoonful	Suffix	"N(`tablespoon ,)"
`tablet	Suffix	"N(`tablet ,)"
`tabloid	Suffix	"N(`tabloid ,)"
ta`boo	Suffix	"N(ta`boo ,)"
ta`bu	Suffix	"N(ta`bu ,)"
ta`chometer	Suffix	"N(ta`chometer ,)"
`tackle	Suffix	"N(`tackle ,)"
`tact	Suffix	"N(`tact ,)"
`tactic	Suffix	"N(`tactic ,)"
`tad	Suffix	"N(`tad ,)"
`tadpole	Suffix	"N(`tadpole ,)"
`taffeta	Suffix	"N(`taffeta ,)"
`taffy	Suffix	"N(`taffy ,)"
`tail	Suffix	"N(`tail ,)"
`tailwind	Suffix	"N(`tailwind ,)"
`takeoff	Suffix	"N(`takeoff ,)"
`takeover	Suffix	"N(`takeover ,)"
`talc	Suffix	"N(`talc ,)"
`talcum	Suffix	"N(`talcum ,)"
`tale	Suffix	"N(`tale ,)"
`talent	Suffix	"N(`talent ,ajr8)"
`talisman	Suffix	"N(`talisman ,)"
`talkie	Suffix	"N(`talkie ,)"
`tallow	Suffix	"N(`tallow ,)"
tally`ho	Suffix	"N(tally`ho ,)"
`talon	Suffix	"N(`talon ,)"
`tam	Suffix	"N(`tam ,)"
ta`male	Suffix	"N(ta`male ,)"
`tamarack	Suffix	"N(`tamarack ,)"
tambou`rine	Suffix	"N(tambou`rine ,)"
`tampon	Suffix	"N(`tampon ,)"
`tandem	Suffix	"N(`tandem ,)"
`tang	Suffix	"N(`tang ,)"
tange`rine	Suffix	"N(tange`rine ,)"
tangi`bility	Suffix	"N(`tangible ,deadj)"
`tank	Suffix	"N(`tank ,)"
`tanker	Suffix	"N(`tanker ,)"
`tankful	Suffix	"N(`tank ,)"
`tannin	Suffix	"N(`tannin ,)"
`tantrum	Suffix	"N(`tantrum ,)"
`tapa	Suffix	"N(`tapa ,)"
`tapestry	Suffix	"N(`tapestry ,)"
`tappet	Suffix	"N(`tappet ,)"
`tare	Suffix	"N(`tare ,)"
`tariff	Suffix	"N(`tariff ,)"
`tarpaper	Suffix	"N(`tarpaper ,)"
`tarpaulin	Suffix	"N(`tarpaulin ,)"
`tartar	Suffix	"N(`tartar ,)"
`task	Suffix	"N(`task ,)"
`taskmaster	Suffix	"N(`taskmaster ,)"
`tater	Suffix	"N(`tater ,)"
`tattletale	Suffix	"N(`tattletale ,)"
`tavern	Suffix	"N(`tavern ,)"
`taxicab	Suffix	"N(`taxicab ,)"
`taxiway	Suffix	"N(`taxiway ,)"
`taxpayer	Suffix	"N(`taxpayer ,)"
`tea	Suffix	"N(`tea ,)"
`teacart	Suffix	"N(`teacart ,)"
`teacup	Suffix	"N(`teacup ,)"
`teacupful	Suffix	"N(`teacup ,)"
`teahouse	Suffix	"N(`teahouse ,)"
`teakettle	Suffix	"N(`teakettle ,)"
`teakwood	Suffix	"N(`teakwood ,)"
`teapot	Suffix	"N(`teapot ,)"
`teal	Suffix	"N(`teal ,)"
`teammate	Suffix	"N(`teammate ,)"
`teamwork	Suffix	"N(`teamwork ,)"
`teapot	Suffix	"N(`teapot ,)"
`teardrop	Suffix	"N(`teardrop ,)"
`teaspoon	Suffix	"N(`teaspoon ,)"
`teaspoonful	Suffix	"N(`teaspoon ,)"
`teat	Suffix	"N(`teat ,)"
`teatime	Suffix	"N(`teatime ,)"
tech`nician	Suffix	"N(tech`nician ,)"
tech`nique	Suffix	"N(tech`nique ,)"
`technocrat	Suffix	"N(`technocrat ,)"
`tedium	Suffix	"N(`tedium ,)"
`teenager	Suffix	"N(`teenager ,)"
`teetotaler	Suffix	"N(`teetotaler ,)"
`telecast	Suffix	"N(`telecast ,)"
telecommuni`cation	Suffix	"N(telecommuni`cation ,)"
`telegram	Suffix	"N(`telegram ,)"
te`legraphy	Suffix	"N(te`legraphy ,)"
`telethon	Suffix	"N(`telethon ,)"
tele`vangelist	Suffix	"N(tele`vangelist ,)"
`television	Suffix	"N(`television ,)"
`temblor	Suffix	"N(`temblor ,)"
te`merity	Suffix	"N(te`merity ,)"
`temper	Suffix	"N(`temper ,ajr8)"
`tempera	Suffix	"N(`tempera ,)"
`temperament	Suffix	"N(`temperament ,)"
`temperature	Suffix	"N(`temperature ,)"
`tempest	Suffix	"N(`tempest ,)"
`template	Suffix	"N(`template ,)"
`temple	Suffix	"N(`temple ,)"
`temptress	Suffix	"N(`tempt ,deverb)"
tena`bility	Suffix	"N(`tenable ,deadj)"
te`nacity	Suffix	"N(te`nacity ,)"
`tenant	Suffix	"N(`tenant ,)"
`tenancy	Suffix	"N(`tenant ,)"
`tenderfoot	Suffix	"N(`tenderfoot ,)"
`tenderloin	Suffix	"N(`tenderloin ,)"
`tendon	Suffix	"N(`tendon ,)"
`tendril	Suffix	"N(`tendril ,ajr8)"
`tenement	Suffix	"N(`tenement ,)"
`tenet	Suffix	"N(`tenet ,)"
`tennis	Suffix	"N(`tennis ,)"
`tenon	Suffix	"N(`tenon ,)"
`tense	Suffix	"N(`tense ,)"
`tension	Suffix	"N(`tension ,)"
`tensor	Suffix	"N(`tensor ,)"
`tenspot	Suffix	"N(`tenspot ,)"
`tentacle	Suffix	"N(`tentacle ,ajr8)"
`tenterhook	Suffix	"N(`tenterhook ,)"
`tenure	Suffix	"N(`tenure ,ajr8)"
`tepee	Suffix	"N(`tepee ,)"
`terminal	Suffix	"N(`terminal ,)"
`termite	Suffix	"N(`termite ,)"
`tern	Suffix	"N(`tern ,)"
`terrace	Suffix	"N(`terrace ,)"
ter`rain	Suffix	"N(ter`rain ,)"
`terrier	Suffix	"N(`terrier ,)"
`territory	Suffix	"N(`territory ,)"
`terror	Suffix	"N(`terror ,)"
`terry	Suffix	"N(`terry ,)"
`testacy	Suffix	"N(`testate ,deadj)"
`testament	Suffix	"N(`testament ,)"
`testator	Suffix	"N(`testator ,)"
`testatrix	Suffix	"N(`testatrix ,)"
`testbed	Suffix	"N(`testbed ,)"
`testicle	Suffix	"N(`testicle ,)"
testi`monial	Suffix	"N(testi`monial ,)"
`testimony	Suffix	"N(`testimony ,)"
`tetanus	Suffix	"N(`tetanus ,)"
tete-a-tete	Suffix	"N(tete-a-tete ,)"
`tetrarch	Suffix	"N(`tetrarch ,)"
`text	Suffix	"N(`text ,)"
`textbook	Suffix	"N(`textbook ,)"
`textile	Suffix	"N(`textile ,)"
`theater	Suffix	"N(`theater ,)"
`theatre	Suffix	"N(`theatre ,)"
`theft	Suffix	"N(`theft ,)"
`theism	Suffix	"N(`theism ,)"
`theme	Suffix	"N(`theme ,)"
the`ocracy	Suffix	"N(the`ocracy ,)"
`theorem	Suffix	"N(`theorem ,)"
`theorist	Suffix	"N(`theory ,)"
`theory	Suffix	"N(`theory ,)"
`therapy	Suffix	"N(`therapy ,)"
`therapist	Suffix	"N(`therapy ,)"
ther`mometer	Suffix	"N(ther`mometer ,)"
`thermostat	Suffix	"N(`thermostat ,)"
`thicket	Suffix	"N(`thicket ,)"
`thievery	Suffix	"N(`thieve ,deverb)"
`thigh	Suffix	"N(`thigh ,)"
`thimble	Suffix	"N(`thimble ,)"
`thimbleful	Suffix	"N(`thimble ,)"
`thing	Suffix	"N(`thing ,)"
`thistle	Suffix	"N(`thistle ,)"
`thistledown	Suffix	"N(`thistledown ,)"
`thong	Suffix	"N(`thong ,)"
`thorn	Suffix	"N(`thorn ,ajr8)"
`thoroughfare	Suffix	"N(`thoroughfare ,)"
`thought	Suffix	"N(`think ,deverb)"
`thrall	Suffix	"N(`thrall ,)"
`threat	Suffix	"N(`threat ,)"
`threshold	Suffix	"N(`threshold ,)"
`thrift	Suffix	"N(`thrift ,)"
`throat	Suffix	"N(`throat ,)"
`throe	Suffix	"N(`throe ,)"
`throughput	Suffix	"N(`throughput ,)"
`throw	Suffix	"N(`throw ,)"
`throwaway	Suffix	"N(`throwaway ,)"
`throwback	Suffix	"N(`throwback ,)"
`thrust	Suffix	"N(`thrust ,)"
`thug	Suffix	"N(`thug ,)"
`thumbnail	Suffix	"N(`thumbnail ,)"
`thunderbird	Suffix	"N(`thunderbird ,)"
`thunderbolt	Suffix	"N(`thunderbolt ,)"
`thunderclap	Suffix	"N(`thunderclap ,)"
`thundershower	Suffix	"N(`thundershower ,)"
`thunderstorm	Suffix	"N(`thunderstorm ,)"
`thyme	Suffix	"N(`thyme ,)"
`thyroid	Suffix	"N(`thyroid ,)"
`tic	Suffix	"N(`tic ,)"
`tick	Suffix	"N(`tick ,)"
`tidbit	Suffix	"N(`tidbit ,)"
`tide	Suffix	"N(`tide ,)"
`tideland	Suffix	"N(`tideland ,)"
`tidewater	Suffix	"N(`tidewater ,)"
`tiding	Suffix	"N(`tiding ,)"
`tie	Suffix	"N(`tie ,)"
`tier	Suffix	"N(`tier ,)"
`tiff	Suffix	"N(`tiff ,)"
`tightrope	Suffix	"N(`tightrope ,)"
`tilde	Suffix	"N(`tilde ,)"
`till	Suffix	"N(`till ,)"
`timber	Suffix	"N(`timber ,)"
`timberland	Suffix	"N(`timberland ,)"
`timbre	Suffix	"N(`timbre ,)"
`timeshare	Suffix	"N(`timeshare ,)"
`timeout	Suffix	"N(`timeout ,)"
`timepiece	Suffix	"N(`timepiece ,)"
`timetable	Suffix	"N(`timetable ,)"
`timothy	Suffix	"N(`timothy ,)"
`timpanist	Suffix	"N(`timpani ,)"
`tin	Suffix	"N(`tin ,)"
`tinder	Suffix	"N(`tinder ,)"
`tine	Suffix	"N(`tine ,)"
`tinfoil	Suffix	"N(`tinfoil ,)"
`tinful	Suffix	"N(`tin ,)"
`tinker	Suffix	"N(`tinker ,)"
`tinsel	Suffix	"N(`tinsel ,)"
`tintype	Suffix	"N(`tintype ,)"
`tipoff	Suffix	"N(`tipoff ,)"
`tirade	Suffix	"N(`tirade ,)"
`tire	Suffix	"N(`tire ,)"
`tissue	Suffix	"N(`tissue ,)"
`tit	Suffix	"N(`tit ,)"
`titan	Suffix	"N(`titan ,)"
`toastmaster	Suffix	"N(`toastmaster ,)"
to`bacco	Suffix	"N(to`bacco ,)"
toc`cata	Suffix	"N(toc`cata ,)"
to`day	Suffix	"N(to`day ,)"
`toe	Suffix	"N(`toe ,ajr8)"
`toenail	Suffix	"N(`toenail ,)"
`toffee	Suffix	"N(`toffee ,)"
`tofu	Suffix	"N(`tofu ,)"
to`getherness	Suffix	"N(to`getherness ,)"
`toilet	Suffix	"N(`toilet ,)"
`toiletry	Suffix	"N(`toilet ,)"
`token	Suffix	"N(`token ,)"
tolera`bility	Suffix	"N(`tolerate ,deverb+deajr)"
`tolerance	Suffix	"N(`tolerate ,deverb+deajr)"
`toll	Suffix	"N(`toll ,)"
`tollgate	Suffix	"N(`tollgate ,)"
`tollhouse	Suffix	"N(`tollhouse ,)"
`tomahawk	Suffix	"N(`tomahawk ,)"
`tomb	Suffix	"N(`tomb ,)"
`tombstone	Suffix	"N(`tombstone ,)"
`tome	Suffix	"N(`tome ,)"
`tommy	Suffix	"N(`tommy ,)"
`ton	Suffix	"N(`ton ,)"
`tonnage	Suffix	"N(`ton ,)"
`tonic	Suffix	"N(`tonic ,)"
`tonsil	Suffix	"N(`tonsil ,)"
`toolkit	Suffix	"N(`toolkit ,)"
`toolsmith	Suffix	"N(`toolsmith ,)"
`toothache	Suffix	"N(`toothache ,)"
`toothbrush	Suffix	"N(`toothbrush ,)"
`toothpaste	Suffix	"N(`toothpaste ,)"
`toothpick	Suffix	"N(`toothpick ,)"
`topaz	Suffix	"N(`topaz ,)"
`topcoat	Suffix	"N(`topcoat ,)"
`topic	Suffix	"N(`topic ,)"
`topsoil	Suffix	"N(`topsoil ,)"
`torment	Suffix	"N(`torment ,ss)"
`torpor	Suffix	"N(`torpor ,)"
`torque	Suffix	"N(`torque ,)"
`torrent	Suffix	"N(`torrent ,)"
`torsion	Suffix	"N(`torsion ,)"
`tort	Suffix	"N(`tort ,)"
`tortoise	Suffix	"N(`tortoise ,)"
`tory	Suffix	"N(`tory ,)"
`tot	Suffix	"N(`tot ,)"
`totem	Suffix	"N(`totem ,)"
`touchdown	Suffix	"N(`touchdown ,)"
`touchstone	Suffix	"N(`touchstone ,)"
`tournament	Suffix	"N(`tournament ,)"
`towboat	Suffix	"N(`towboat ,)"
`towhead	Suffix	"N(`towhead ,)"
`towhee	Suffix	"N(`towhee ,)"
`town	Suffix	"N(`town ,)"
`townhouse	Suffix	"N(`townhouse ,)"
`toxin	Suffix	"N(`toxin ,)"
`trace	Suffix	"N(`trace ,)"
`tracery	Suffix	"N(`trace ,)"
`tract	Suffix	"N(`tract ,)"
tracta`bility	Suffix	"N(`tractable ,deadj)"
`traction	Suffix	"N(`traction ,)"
`tractor	Suffix	"N(`tractor ,)"
`trademark	Suffix	"N(`trademark ,)"
`tradeoff	Suffix	"N(`tradeoff ,)"
tra`dition	Suffix	"N(tra`dition ,)"
`trafficker	Suffix	"N(`traffic ,deverb)"
`tragedy	Suffix	"N(`tragedy ,)"
`trail	Suffix	"N(`trail ,)"
`trailside	Suffix	"N(`trailside ,)"
`train	Suffix	"N(`train ,)"
`trainful	Suffix	"N(`train ,)"
`trait	Suffix	"N(`trait ,)"
`traitor	Suffix	"N(`traitor ,)"
tra`jectory	Suffix	"N(tra`ject ,deverb)"
`tram	Suffix	"N(`tram ,)"
`tramway	Suffix	"N(`tramway ,)"
trans`ceiver	Suffix	"N(trans`ceiver ,)"
`transcript	Suffix	"N(`transcript ,)"
trans`cription	Suffix	"N(trans`cribe ,deverb)"
trans`duction	Suffix	"N(trans`duce ,deverb)"
`transept	Suffix	"N(`transept ,)"
`transfer	Suffix	"N(`transfer ,ss)"
tranfera`bility	Suffix	"N(trans`fer ,deverb+deajr)"
`transform	Suffix	"N(`transform ,ss)"
`transience	Suffix	"N(`transient ,deadj)"
tran`sistor	Suffix	"N(tran`sistor ,)"
trans`lucence	Suffix	"N(trans`lucent ,deadj)"
trans`mission	Suffix	"N(trans`mit ,deverb)"
transmogrifi`cation	Suffix	"N(trans`mogrify ,deverb)"
`transom	Suffix	"N(`transom ,)"
trans`parence	Suffix	"N(tran`parent ,deadj)"
trans`parency	Suffix	"N(tran`parent ,deadj)"
`transplant	Suffix	"N(`transplant ,ss)"
tran`sponder	Suffix	"N(tran`sponder ,)"
`transport	Suffix	"N(`transport ,ss)"
trans`vestite	Suffix	"N(trans`vestite ,)"
`trapezoid	Suffix	"N(`trapezoid ,)"
`trapping	Suffix	"N(`trapping ,)"
`travelogue	Suffix	"N(`travelogue ,)"
`travertine	Suffix	"N(`travertine ,)"
`travesty	Suffix	"N(`travesty ,)"
`tray	Suffix	"N(`tray ,)"
`trayful	Suffix	"N(`tray ,)"
`treachery	Suffix	"N(`treachery ,)"
`treacle	Suffix	"N(`treacle ,)"
`tread	Suffix	"N(`tread ,)"
`treadmill	Suffix	"N(`treadmill ,)"
`treason	Suffix	"N(`treason ,)"
`treasury	Suffix	"N(`treasury ,)"
`treatise	Suffix	"N(`treatise ,)"
`treaty	Suffix	"N(`treaty ,)"
`treble	Suffix	"N(`treble ,)"
`tree	Suffix	"N(`tree ,)"
`treetop	Suffix	"N(`treetop ,)"
`trefoil	Suffix	"N(`trefoil ,)"
`trekkie	Suffix	"N(`trekkie ,)"
`tremor	Suffix	"N(`tremor ,)"
`tremour	Suffix	"N(`tremour - British,)"
`trench	Suffix	"N(`trench ,)"
`trencher	Suffix	"N(`trencher ,)"
trepi`dation	Suffix	"N(trepi`dation ,)"
`tress	Suffix	"N(`tress ,)"
`trestle	Suffix	"N(`trestle ,)"
`triad	Suffix	"N(`triad ,)"
`trial	Suffix	"N(`trial ,)"
`triangle	Suffix	"N(`triangle ,)"
`tribe	Suffix	"N(`tribe ,)"
tri`bunal	Suffix	"N(tri`bunal ,)"
`tribune	Suffix	"N(`tribune ,)"
`tributary	Suffix	"N(`tributary ,)"
`tribute	Suffix	"N(`tribute ,)"
`trickery	Suffix	"N(`trick ,)"
`tricycle	Suffix	"N(`tricycle ,)"
`trig	Suffix	"N(`trig ,)"
`trigram	Suffix	"N(`trigram ,)"
`trilogy	Suffix	"N(`trilogy ,)"
`trim	Suffix	"N(`trim ,)"
`trimester	Suffix	"N(`trimester ,)"
`trinity	Suffix	"N(`trinity ,)"
`trinket	Suffix	"N(`trinket ,)"
`trio	Suffix	"N(`trio ,)"
`trip	Suffix	"N(`trip ,)"
`tripe	Suffix	"N(`tripe ,)"
`triple	Suffix	"N(`triple ,)"
`triplet	Suffix	"N(`triplet ,)"
`tripod	Suffix	"N(`tripod ,)"
`tripoli	Suffix	"N(`tripoli ,)"
`triptych	Suffix	"N(`triptych ,)"
`triton	Suffix	"N(`triton ,)"
tri`umvir	Suffix	"N(tri`umvir ,)"
tri`umvirate	Suffix	"N(tri`umvir ,)"
`troglodyte	Suffix	"N(`troglodyte ,)"
`troika	Suffix	"N(`troika ,)"
`troll	Suffix	"N(`troll ,)"
`trolley	Suffix	"N(`trolley ,)"
`trollop	Suffix	"N(`trollop ,)"
trom`bone	Suffix	"N(trom`bone ,)"
`trope	Suffix	"N(`trope ,)"
`trophy	Suffix	"N(`trophy ,)"
`tropic	Suffix	"N(`tropic ,)"
`troubador	Suffix	"N(`troubador ,)"
`trough	Suffix	"N(`trough ,)"
`troupe	Suffix	"N(`troupe ,)"
`trowel	Suffix	"N(`trowel ,)"
`truancy	Suffix	"N(`truant ,deadj)"
`truce	Suffix	"N(`truce ,)"
`truckful	Suffix	"N(`truck ,)"
`truculence	Suffix	"N(`truculent ,deadj)"
`trumpery	Suffix	"N(`trumpery ,)"
`trunk	Suffix	"N(`trunk ,)"
`truth	Suffix	"N(`true ,deadj)"
`tryst	Suffix	"N(`tryst ,)"
`tsar	Suffix	"N(`tsar ,)"
tsa`rina	Suffix	"N(tsa`rina ,)"
t-shirt	Suffix	"N(t-shirt ,)"
tsu`nami	Suffix	"N(tsu`nami ,)"
`tub	Suffix	"N(`tub ,)"
`tuba	Suffix	"N(`tuba ,)"
`tube	Suffix	"N(`tube ,)"
`tuber	Suffix	"N(`tuber ,)"
tu`berculin	Suffix	"N(tu`berculin ,)"
tubercu`losis	Suffix	"N(tubercu`losis ,)"
`tubing	Suffix	"N(`tube ,)"
`tubule	Suffix	"N(`tubule ,)"
`tuff	Suffix	"N(`tuff ,)"
tu`ition	Suffix	"N(tu`ition ,)"
`tulip	Suffix	"N(`tulip ,)"
`tulle	Suffix	"N(`tulle ,)"
`tumbrel	Suffix	"N(`tumbrel ,)"
tu`mescence	Suffix	"N(tu`mescent ,deadj)"
`tumor	Suffix	"N(`tumor ,)"
`tumour	Suffix	"N(`tumour - British,)"
`tumult	Suffix	"N(`tumult ,)"
`tun	Suffix	"N(`tun ,)"
`tundra	Suffix	"N(`tundra ,)"
`tune	Suffix	"N(`tune ,)"
`tunic	Suffix	"N(`tunic ,)"
`turban	Suffix	"N(`turban ,ajr8)"
`turbine	Suffix	"N(`turbine ,)"
`turbulence	Suffix	"N(`turbulent ,deadj)"
tu`reen	Suffix	"N(tu`reen ,)"
`turk	Suffix	"N(`turk ,)"
`turkey	Suffix	"N(`turkey ,)"
`turmoil	Suffix	"N(`turmoil ,)"
`turnabout	Suffix	"N(`turnabout ,)"
`turnaround	Suffix	"N(`turnaround ,)"
`turnery	Suffix	"N(`turn ,deverb)"
`turnip	Suffix	"N(`turnip ,)"
`turnkey	Suffix	"N(`turnkey ,)"
`turnoff	Suffix	"N(`turnoff ,)"
`turnout	Suffix	"N(`turnout ,)"
`turnover	Suffix	"N(`turnover ,)"
`turnpike	Suffix	"N(`turnpike ,)"
`turnstile	Suffix	"N(`turnstile ,)"
`turntable	Suffix	"N(`turntable ,)"
`turpentine	Suffix	"N(`turpentine ,)"
`turpitude	Suffix	"N(`turpitude ,)"
`turret	Suffix	"N(`turret ,)"
`turtle	Suffix	"N(`turtle ,)"
`turtleneck	Suffix	"N(`turtleneck ,)"
`tusk	Suffix	"N(`tusk ,ajr8)"
`tutelage	Suffix	"N(`tutelage ,)"
tu`torial	Suffix	"N(`tutor ,)"
`tutu	Suffix	"N(`tutu ,)"
`twaddle	Suffix	"N(`twaddle ,)"
`twain	Suffix	"N(`twain ,)"
`tweed	Suffix	"N(`tweed ,)"
`twig	Suffix	"N(`twig ,)"
`twilight	Suffix	"N(`twilight ,)"
`twill	Suffix	"N(`twill ,)"
`twit	Suffix	"N(`twit ,)"
ty`coon	Suffix	"N(ty`coon ,)"
`type	Suffix	"N(`type ,)"
`typeface	Suffix	"N(`typeface ,)"
`typescript	Suffix	"N(`typescript ,)"
`typhoid	Suffix	"N(`typhoid ,)"
ty`phoon	Suffix	"N(ty`phoon ,)"
`typhus	Suffix	"N(`typhus ,)"
`typist	Suffix	"N(`type ,deverb)"
`typo	Suffix	"N(`typo ,)"
ty`rannicide	Suffix	"N(ty`rannicide ,)"
`tyre	Suffix	"N(`tyre - British,)"
`tyro	Suffix	"N(`tyro ,)"
`tyranny	Suffix	"N(`tyranny ,)"
`tyrant	Suffix	"N(`tyrant ,)"
u`biquity	Suffix	"N(u`biquity ,)"
`udder	Suffix	"N(`udder ,)"
uglifi`cation	Suffix	"N(`ugly ,deverb)"
uke`lele	Suffix	"N(uke`lele ,)"
`ulcer	Suffix	"N(`ulcer ,)"
`ultima	Suffix	"N(`ultima ,)"
`umbrage	Suffix	"N(`umbrage ,)"
um`brella	Suffix	"N(um`brella ,)"
`umlaut	Suffix	"N(`umlaut ,)"
unan`imity	Suffix	"N(unan`imity ,)"
unbe`liever	Suffix	"N(be`lieve ,deverb)"
`uncle	Suffix	"N(`uncle ,)"
`unction	Suffix	"N(`unction ,)"
`underling	Suffix	"N(`underling ,)"
`unguent	Suffix	"N(`unguent ,)"
`unicorn	Suffix	"N(`unicorn ,)"
unifi`cation	Suffix	"N(`unify ,deverb)"
unim`portance	Suffix	"N(im`portant ,deadj)"
`union	Suffix	"N(`union ,)"
`unit	Suffix	"N(`unit ,)"
`unity	Suffix	"N(`unity ,)"
`universe	Suffix	"N(`universe ,)"
uni`versity	Suffix	"N(uni`versity ,)"
un`rest	Suffix	"N(`rest ,)"
`upbringing	Suffix	"N(`upbringing ,)"
`upcountry	Suffix	"N(`upcountry ,)"
`updraft	Suffix	"N(`updraft ,)"
up`holstery	Suffix	"N(up`holstery ,)"
`upkeep	Suffix	"N(`upkeep ,)"
`upland	Suffix	"N(`upland ,)"
`uplift	Suffix	"N(`uplift ,ss)"
`uppercut	Suffix	"N(`uppercut ,)"
`uprising	Suffix	"N(`uprising ,)"
`uproar	Suffix	"N(`uproar ,)"
`upset	Suffix	"N(`upset ,ss)"
`upshot	Suffix	"N(`upshot ,)"
`upside	Suffix	"N(`upside ,)"
`upstart	Suffix	"N(`upstart ,)"
`upstate	Suffix	"N(`upstate ,)"
up`stater	Suffix	"N(up`stater ,)"
`upsurge	Suffix	"N(`upsurge ,)"
`upswing	Suffix	"N(`upswing ,)"
`uptake	Suffix	"N(`uptake ,)"
`uptown	Suffix	"N(`uptown ,)"
`uptrend	Suffix	"N(`uptrend ,)"
`upturn	Suffix	"N(`upturn ,)"
`urbanite	Suffix	"N(`urban ,deadj)"
`urchin	Suffix	"N(`urchin ,)"
`urgency	Suffix	"N(`urge ,deverb+deajr)"
`urinal	Suffix	"N(`urinal ,)"
uri`nalysis	Suffix	"N(uri`nalysis ,)"
`urine	Suffix	"N(`urine ,)"
`urn	Suffix	"N(`urn ,)"
`usurer	Suffix	"N(`usurer ,)"
`usury	Suffix	"N(`usury ,)"
u`tensil	Suffix	"N(u`tensil ,)"
u`topia	Suffix	"N(u`topia ,)"
`vacancy	Suffix	"N(`vacant ,deadj)"
va`cationland	Suffix	"N(va`cationland ,)"
vac`cine	Suffix	"N(vac`cine ,)"
va`cuity	Suffix	"N(va`cuity ,)"
`vagabond	Suffix	"N(`vagabond ,)"
`vagary	Suffix	"N(`vagary ,)"
`vagrancy	Suffix	"N(`vagrant ,)"
`vainglory	Suffix	"N(`vainglory ,)"
`vale	Suffix	"N(`vale ,)"
vale`diction	Suffix	"N(vale`diction ,)"
valedic`torian	Suffix	"N(valedic`torian ,)"
`valence	Suffix	"N(`valence ,)"
`valency	Suffix	"N(`valence ,)"
`valentine	Suffix	"N(`valentine ,)"
`valiance	Suffix	"N(`valiant ,deadj)"
`valiancy	Suffix	"N(`valiant ,deadj)"
`valley	Suffix	"N(`valley ,)"
`valor	Suffix	"N(`valor ,)"
`valour	Suffix	"N(`valour - British,)"
`valve	Suffix	"N(`valve ,ajr8)"
`vampire	Suffix	"N(`vampire ,)"
`van	Suffix	"N(`van ,)"
`vandal	Suffix	"N(`vandal ,)"
`vane	Suffix	"N(`vane ,ajr8)"
`vanful	Suffix	"N(`van ,)"
`vanguard	Suffix	"N(`vanguard ,)"
`vanity	Suffix	"N(`vain ,deadj)"
`vantage	Suffix	"N(`vantage ,)"
`variable	Suffix	"N(`vary ,deverb)"
va`riety	Suffix	"N(va`riety ,)"
va`ristor	Suffix	"N(va`ristor ,)"
`varmint	Suffix	"N(`varmint ,)"
`varsity	Suffix	"N(`varsity ,)"
`vase	Suffix	"N(`vase ,)"
`vassal	Suffix	"N(`vassal ,)"
`vat	Suffix	"N(`vat ,)"
`vatful	Suffix	"N(`vat ,)"
`vaudeville	Suffix	"N(`vaudeville ,)"
`vault	Suffix	"N(`vault ,)"
`veal	Suffix	"N(`veal ,)"
`vee	Suffix	"N(`vee ,)"
`veery	Suffix	"N(`veery ,)"
`vegetable	Suffix	"N(`vegetable ,)"
`vehemence	Suffix	"N(`vehement ,deadj)"
`vehemency	Suffix	"N(`vehement ,deadj)"
`vehicle	Suffix	"N(`vehicle ,)"
`vein	Suffix	"N(`vein ,ajr8)"
`veld	Suffix	"N(`veld ,)"
`veldt	Suffix	"N(`veldt ,)"
`vellum	Suffix	"N(`vellum ,)"
ve`locity	Suffix	"N(ve`locity ,)"
ve`lour	Suffix	"N(ve`lour ,)"
ven`detta	Suffix	"N(ven`detta ,)"
venera`bility	Suffix	"N(`venerate ,deverb+deajr)"
`venison	Suffix	"N(`venison ,)"
`venom	Suffix	"N(`venom ,)"
ven`triloquism	Suffix	"N(ven`triloquism ,)"
ven`triloquist	Suffix	"N(ven`triloquist ,)"
ven`turi	Suffix	"N(ven`turi ,)"
`venue	Suffix	"N(`venue ,)"
ve`racity	Suffix	"N(ve`racity ,)"
ve`randa	Suffix	"N(ve`randa ,)"
ve`randah	Suffix	"N(ve`randah ,)"
`verb	Suffix	"N(`verb ,)"
`verbiage	Suffix	"N(`verbiage ,)"
`verdancy	Suffix	"N(`verdant ,deadj)"
`verdict	Suffix	"N(`verdict ,)"
`verdure	Suffix	"N(`verdure ,ajr8)"
verifi`cation	Suffix	"N(`verify ,deverb)"
verisi`militude	Suffix	"N(verisi`militude ,)"
`verity	Suffix	"N(`verity ,)"
ver`mouth	Suffix	"N(ver`mouth ,)"
`vernier	Suffix	"N(`vernier ,)"
`verse	Suffix	"N(`verse ,)"
`version	Suffix	"N(`version ,)"
`verso	Suffix	"N(`verso ,)"
`vertigo	Suffix	"N(`vertigo ,)"
`verve	Suffix	"N(`verve ,)"
`vesicle	Suffix	"N(`vesicle ,)"
`vessel	Suffix	"N(`vessel ,)"
`vest	Suffix	"N(`vest ,)"
`vestibule	Suffix	"N(`vestibule ,)"
`vestige	Suffix	"N(`vestige ,)"
`vestry	Suffix	"N(`vestry ,)"
`vetch	Suffix	"N(`vetch ,)"
`veteran	Suffix	"N(`veteran ,)"
veteri`narian	Suffix	"N(veteri`narian ,)"
via`bility	Suffix	"N(`viable ,deadj)"
`viaduct	Suffix	"N(`viaduct ,)"
`vial	Suffix	"N(`vial ,)"
`vibe	Suffix	"N(`vibe ,)"
`vibrance	Suffix	"N(`vibrate ,deverb)"
`vibrancy	Suffix	"N(`vibrate ,deverb)"
vi`brato	Suffix	"N(vi`brato ,)"
`vicar	Suffix	"N(`vicar ,)"
`vice	Suffix	"N(`vice ,)"
`viceroy	Suffix	"N(`viceroy ,)"
vichys`soise	Suffix	"N(vichys`soise ,)"
vi`cinity	Suffix	"N(vi`cinity ,)"
vi`cissitude	Suffix	"N(vi`cissitude ,)"
`victim	Suffix	"N(`victim ,)"
`victor	Suffix	"N(`victor ,)"
`victory	Suffix	"N(`victory ,)"
`video	Suffix	"N(`video ,)"
`videocassette	Suffix	"N(`videocassette ,)"
`videodisc	Suffix	"N(`videodisc ,)"
`videotext	Suffix	"N(`videotext ,)"
`viewpoint	Suffix	"N(`viewpoint ,)"
`vigil	Suffix	"N(`vigil ,)"
`vigilance	Suffix	"N(`vigil ,)"
vigi`lante	Suffix	"N(vigi`lante ,)"
`vigor	Suffix	"N(`vigor ,)"
`vigour	Suffix	"N(`vigour - British,)"
`viking	Suffix	"N(`viking ,)"
`villa	Suffix	"N(`villa ,)"
`village	Suffix	"N(`village ,)"
`villager	Suffix	"N(`village ,)"
`villain	Suffix	"N(`villain ,)"
`villein	Suffix	"N(`villein ,)"
`vine	Suffix	"N(`vine ,)"
`vinegar	Suffix	"N(`vinegar ,)"
`vinery	Suffix	"N(`vine ,)"
`vineyard	Suffix	"N(`vineyard ,)"
`vintage	Suffix	"N(`vintage ,)"
`vintner	Suffix	"N(`vintner ,)"
`vinyl	Suffix	"N(`vinyl ,)"
`viol	Suffix	"N(`viol ,)"
vi`ola	Suffix	"N(vi`ola ,)"
viola`bility	Suffix	"N(`violate ,deverb+deajr)"
`violence	Suffix	"N(`violent ,deadj)"
`violet	Suffix	"N(`violet ,)"
vio`lin	Suffix	"N(vio`lin ,)"
vio`linist	Suffix	"N(vio`lin - exception to Gemination,)"
vi`olist	Suffix	"N(vi`ola ,)"
`viper	Suffix	"N(`viper ,)"
`virgule	Suffix	"N(`virgule ,)"
`virtue	Suffix	"N(`virtue ,)"
virtu`osity	Suffix	"N(virtu`oso ,)"
`virulence	Suffix	"N(`virulent ,deadj)"
`virulency	Suffix	"N(`virulent ,deadj)"
`virus	Suffix	"N(`virus ,)"
`visa	Suffix	"N(`visa ,)"
`visage	Suffix	"N(`visage ,ajr8)"
vis`cosity	Suffix	"N(vis`cosity ,)"
`viscount	Suffix	"N(`viscount ,)"
`vise	Suffix	"N(`vise ,)"
visi`bility	Suffix	"N(`visible ,deadj)"
`visigoth	Suffix	"N(`visigoth ,)"
`vision	Suffix	"N(`vision ,)"
`visionary	Suffix	"N(`vision ,)"
`visor	Suffix	"N(`visor ,)"
`vista	Suffix	"N(`vista ,)"
`vitamin	Suffix	"N(`vitamin ,)"
`vitriol	Suffix	"N(`vitriol ,)"
vi`vacity	Suffix	"N(vi`vacity ,)"
`vixen	Suffix	"N(`vixen ,)"
`vocable	Suffix	"N(`vocable ,)"
vo`cabulary	Suffix	"N(vo`cabulary ,)"
vo`cation	Suffix	"N(vo`cation ,)"
`vodka	Suffix	"N(`vodka ,)"
`vogue	Suffix	"N(`vogue ,)"
`volcanism	Suffix	"N(vol`cano ,)"
vo`lition	Suffix	"N(vo`lition ,)"
`volleyball	Suffix	"N(`volleyball ,)"
volu`bility	Suffix	"N(`voluble ,deadj)"
`volume	Suffix	"N(`volume ,)"
`voluntarism	Suffix	"N(`voluntary ,deadj)"
`voodoo	Suffix	"N(`voodoo ,)"
vo`racity	Suffix	"N(vo`racity ,)"
vor`ticity	Suffix	"N(vor`ticity ,)"
`votary	Suffix	"N(`votary ,)"
`vowel	Suffix	"N(`vowel ,)"
voy`eur	Suffix	"N(voy`eur ,)"
`vulture	Suffix	"N(`vulture ,)"
vulnera`bility	Suffix	"N(`vulnerable ,deadj)"
`wadi	Suffix	"N(`wadi ,)"
`wafer	Suffix	"N(`wafer ,)"
`waffle	Suffix	"N(`waffle ,)"
`wag	Suffix	"N(`wag ,)"
`wage	Suffix	"N(`wage ,)"
`waggle	Suffix	"N(`waggle ,)"
`wagon	Suffix	"N(`wagon ,)"
`waif	Suffix	"N(`waif ,)"
`wainwright	Suffix	"N(`wainwright ,)"
`waist	Suffix	"N(`waist ,)"
`waistband	Suffix	"N(`waistband ,)"
`waistcoat	Suffix	"N(`waistcoat ,)"
`waistline	Suffix	"N(`waistline ,)"
`waiter	Suffix	"N(`wait ,deverb)"
`waitress	Suffix	"N(`wait ,deverb)"
`wake	Suffix	"N(`wake ,)"
`wale	Suffix	"N(`wale ,)"
walkie-`talkie	Suffix	"N(walkie-`talkie ,)"
`walkout	Suffix	"N(`walkout ,)"
`walkover	Suffix	"N(`walkover ,)"
`walkway	Suffix	"N(`walkway ,)"
`wallboard	Suffix	"N(`wallboard ,)"
`wallet	Suffix	"N(`wallet ,)"
`walnut	Suffix	"N(`walnut ,)"
`wampum	Suffix	"N(`wampum ,)"
`wand	Suffix	"N(`wand ,)"
`ward	Suffix	"N(`ward ,)"
`warden	Suffix	"N(`warden ,)"
`wardrobe	Suffix	"N(`wardrobe ,)"
`wardroom	Suffix	"N(`wardroom ,)"
`ware	Suffix	"N(`ware ,)"
`warfare	Suffix	"N(`warfare ,)"
`warhead	Suffix	"N(`warhead ,)"
`warhorse	Suffix	"N(`warhorse ,)"
`warlock	Suffix	"N(`warlock ,)"
`warlord	Suffix	"N(`warlord ,)"
`warmonger	Suffix	"N(`warmonger ,)"
`warmth	Suffix	"N(`warm ,deadj)"
`warmup	Suffix	"N(`warmup ,)"
`warpath	Suffix	"N(`warpath ,)"
`warplane	Suffix	"N(`warplane ,)"
`warranty	Suffix	"N(`warranty ,)"
`warren	Suffix	"N(`warren ,)"
`warrior	Suffix	"N(`warrior ,)"
`wart	Suffix	"N(`wart ,)"
`wartime	Suffix	"N(`wartime ,)"
`washbasin	Suffix	"N(`washbasin ,)"
`washboard	Suffix	"N(`washboard ,)"
`washbowl	Suffix	"N(`washbowl ,)"
`washcloth	Suffix	"N(`washcloth ,)"
`washout	Suffix	"N(`washout ,)"
`washroom	Suffix	"N(`washroom ,)"
`washtub	Suffix	"N(`washtub ,)"
`wastebasket	Suffix	"N(`wastebasket ,)"
`wasteland	Suffix	"N(`wasteland ,)"
`wastepaper	Suffix	"N(`wastepaper ,)"
`wastewater	Suffix	"N(`wastewater ,)"
`wastrel	Suffix	"N(`wastrel ,)"
`watch	Suffix	"N(`watch ,)"
`watchband	Suffix	"N(`watchband ,)"
`watchdog	Suffix	"N(`watchdog ,)"
`watchword	Suffix	"N(`watchword ,)"
`watercolor	Suffix	"N(`watercolor ,)"
`watercourse	Suffix	"N(`watercourse ,)"
`waterfall	Suffix	"N(`waterfall ,)"
`waterfront	Suffix	"N(`waterfront ,)"
`waterline	Suffix	"N(`waterline ,)"
`watermelon	Suffix	"N(`watermelon ,)"
`watershed	Suffix	"N(`watershed ,)"
`waterside	Suffix	"N(`waterside ,)"
`waterski	Suffix	"N(`waterski ,)"
`waterspout	Suffix	"N(`waterspout ,)"
`waterway	Suffix	"N(`waterway ,)"
`waxwork	Suffix	"N(`waxwork ,)"
`way	Suffix	"N(`way ,)"
`waybill	Suffix	"N(`waybill ,)"
`wayfarer	Suffix	"N(`wayfarer ,)"
`weakling	Suffix	"N(`weak ,deadj)"
`weal	Suffix	"N(`weal ,)"
`wealth	Suffix	"N(`wealth ,)"
`weapon	Suffix	"N(`weapon ,)"
`weaponry	Suffix	"N(`weapon ,)"
`weasel	Suffix	"N(`weasel ,)"
`webbing	Suffix	"N(`web ,)"
`wedlock	Suffix	"N(`wedlock ,)"
`week	Suffix	"N(`week ,ajr13)"
`weekday	Suffix	"N(`weekday ,)"
`weekend	Suffix	"N(`weekend ,)"
`weevil	Suffix	"N(`weevil ,)"
`weir	Suffix	"N(`weir ,)"
`weirdo	Suffix	"N(`weirdo ,)"
`welfare	Suffix	"N(`welfare ,)"
`well	Suffix	"N(`well - water well,)"
well`being	Suffix	"N(well`being ,)"
`wen	Suffix	"N(`wen ,)"
`wench	Suffix	"N(`wench ,)"
`westerly	Suffix	"N(`westerly ,)"
`westerner	Suffix	"N(`western ,deadj)"
`wetback	Suffix	"N(`wetback ,)"
`wetland	Suffix	"N(`wetland ,)"
`wetsuit	Suffix	"N(`wetsuit ,)"
`whalebone	Suffix	"N(`whalebone ,)"
`whatnot	Suffix	"N(`whatnot ,)"
`wheat	Suffix	"N(`wheat ,)"
`wheelbase	Suffix	"N(`wheelbase ,)"
`wheelbarrow	Suffix	"N(`wheelbarrow ,)"
`wheelchair	Suffix	"N(`wheelchair ,)"
`wheelhouse	Suffix	"N(`wheelhouse ,)"
`wheelwright	Suffix	"N(`wheelwright ,)"
`whetstone	Suffix	"N(`whetstone ,)"
`whey	Suffix	"N(`whey ,)"
`whig	Suffix	"N(`whig ,)"
`while	Suffix	"N(`while ,)"
`whim	Suffix	"N(`whim ,)"
`whimsey	Suffix	"N(`whimsey ,)"
`whimsy	Suffix	"N(`whimsy ,)"
`whiplash	Suffix	"N(`whiplash ,)"
`whippet	Suffix	"N(`whippet ,)"
`whipsaw	Suffix	"N(`whipsaw ,)"
`whirligig	Suffix	"N(`whirligig ,)"
`whirlpool	Suffix	"N(`whirlpool ,)"
`whirlwind	Suffix	"N(`whirlwind ,)"
`whisker	Suffix	"N(`whisker ,ajr8)"
`whiskey	Suffix	"N(`whiskey ,)"
`whit	Suffix	"N(`whit ,)"
`whitecap	Suffix	"N(`whitecap ,)"
`whiteface	Suffix	"N(`whiteface ,)"
`whiting	Suffix	"N(`whiting ,)"
who`dunit	Suffix	"N(who`dunit ,)"
who`dunnit	Suffix	"N(who`dunnit ,)"
`whop	Suffix	"N(`whop ,)"
`whoremonger	Suffix	"N(`whoremonger ,)"
`whorl	Suffix	"N(`whorl ,ajr8)"
`wick	Suffix	"N(`wick ,)"
`wicker	Suffix	"N(`wicker ,)"
`wicket	Suffix	"N(`wicket ,)"
`widget	Suffix	"N(`widget ,)"
`widower	Suffix	"N(`widower ,)"
`width	Suffix	"N(`wide ,deadj)"
`wiener	Suffix	"N(`wiener ,)"
`wig	Suffix	"N(`wig ,)"
`wigwam	Suffix	"N(`wigwam ,)"
`wildcard	Suffix	"N(`wildcard ,)"
`wildcat	Suffix	"N(`wildcat ,)"
`wildcatter	Suffix	"N(`wildcatter ,)"
`wilderness	Suffix	"N(`wilderness ,)"
`wildfire	Suffix	"N(`wildfire ,)"
`wildlife	Suffix	"N(`wildlife ,)"
`wile	Suffix	"N(`wile ,)"
`win	Suffix	"N(`win ,)"
`wind	Suffix	"N(`wind ,)"
`windbag	Suffix	"N(`windbag ,)"
`windbreak	Suffix	"N(`windbreak ,)"
`windfall	Suffix	"N(`windfall ,)"
`windlass	Suffix	"N(`windlass ,)"
`windmill	Suffix	"N(`windmill ,)"
`window	Suffix	"N(`window ,)"
`windowpane	Suffix	"N(`windowpane ,)"
`windowsill	Suffix	"N(`windowsill ,)"
`windpipe	Suffix	"N(`windpipe ,)"
`windshield	Suffix	"N(`windshield ,)"
`windstorm	Suffix	"N(`windstorm ,)"
`windup	Suffix	"N(`windup ,)"
`wine	Suffix	"N(`wine ,)"
`winebibber	Suffix	"N(`winebibber ,)"
`winemaster	Suffix	"N(`winemaster ,)"
`winepress	Suffix	"N(`winepress ,)"
`winery	Suffix	"N(`wine ,)"
`wineskin	Suffix	"N(`wineskin ,)"
`wingspan	Suffix	"N(`wingspan ,)"
`wingtip	Suffix	"N(`wingtip ,)"
`wino	Suffix	"N(`wino ,)"
`wintertime	Suffix	"N(`wintertime ,)"
`wiring	Suffix	"N(`wire ,)"
`wisdom	Suffix	"N(`wise ,deadj)"
`wiseacre	Suffix	"N(`wiseacre ,)"
`wishbone	Suffix	"N(`wishbone ,)"
`wisp	Suffix	"N(`wisp ,)"
`wit	Suffix	"N(`wit ,)"
`witch	Suffix	"N(`witch ,)"
`witchcraft	Suffix	"N(`witchcraft ,)"
`witchery	Suffix	"N(`witch ,)"
`wizard	Suffix	"N(`wizard ,)"
`wizardry	Suffix	"N(`wizard ,)"
`woe	Suffix	"N(`woe ,)"
`wok	Suffix	"N(`wok ,)"
`wold	Suffix	"N(`wold ,)"
`womb	Suffix	"N(`womb ,)"
`wonderland	Suffix	"N(`wonderland ,)"
`wonk	Suffix	"N(`wonk ,)"
`wood	Suffix	"N(`wood ,ajr8)"
`woodcut	Suffix	"N(`woodcut ,)"
`woodgrain	Suffix	"N(`woodgrain ,)"
`woodland	Suffix	"N(`woodland ,)"
`woodlot	Suffix	"N(`woodlot ,)"
`woodshed	Suffix	"N(`woodshed ,)"
`woodwind	Suffix	"N(`woodwind ,)"
`woodwork	Suffix	"N(`woodwork ,)"
`wool	Suffix	"N(`wool ,)"
`wop	Suffix	"N(`wop ,)"
`workbench	Suffix	"N(`workbench ,)"
`workbook	Suffix	"N(`workbook ,)"
`workday	Suffix	"N(`workday ,)"
`workforce	Suffix	"N(`workforce ,)"
`workhorse	Suffix	"N(`workhorse ,)"
`workload	Suffix	"N(`workload ,)"
`workout	Suffix	"N(`workout ,)"
`workplace	Suffix	"N(`workplace ,)"
`worksheet	Suffix	"N(`worksheet ,)"
`workshop	Suffix	"N(`workshop ,)"
`workspace	Suffix	"N(`workspace ,)"
`worktable	Suffix	"N(`worktable ,)"
`world	Suffix	"N(`world ,)"
`wormwood	Suffix	"N(`wormwood ,)"
`worsted	Suffix	"N(`worsted ,)"
`worth	Suffix	"N(`worth ,)"
`wraith	Suffix	"N(`wraith ,)"
`wrapup	Suffix	"N(`wrapup ,)"
`wrath	Suffix	"N(`wrath ,)"
`wreath	Suffix	"N(`wreath ,)"
`wretch	Suffix	"N(`wretch ,)"
`wright	Suffix	"N(`wright ,)"
`wrist	Suffix	"N(`wrist ,)"
`wristband	Suffix	"N(`wristband ,)"
`wristwatch	Suffix	"N(`wristwatch ,)"
`writ	Suffix	"N(`writ ,)"
`writeup	Suffix	"N(`writeup ,)"
xeno`phobia	Suffix	"N(xeno`phobia ,)"
`xylophone	Suffix	"N(`xylophone ,)"
`yahoo	Suffix	"N(`yahoo ,)"
`yang	Suffix	"N(`yang ,)"
`yankee	Suffix	"N(`yankee ,)"
`yard	Suffix	"N(`yard ,)"
`yardage	Suffix	"N(`yard ,)"
`yardstick	Suffix	"N(`yardstick ,)"
`yarmulke	Suffix	"N(`yarmulke ,)"
`yarrow	Suffix	"N(`yarrow ,)"
`year	Suffix	"N(`year , ajr13)"
`yearbook	Suffix	"N(`yearbook ,)"
`yeast	Suffix	"N(`yeast ,)"
`yen	Suffix	"N(`yen ,)"
`yeoman	Suffix	"N(`yeoman ,)"
`yeomanry	Suffix	"N(`yeoman ,)"
`yesterday	Suffix	"N(`yesterday ,)"
`yesteryear	Suffix	"N(`yesteryear ,)"
`yin	Suffix	"N(`yin ,)"
`yo-yo	Suffix	"N(`yo-yo ,)"
`yoyo	Suffix	"N(`yoyo ,)"
`yoga	Suffix	"N(`yoga ,)"
`yoghurt	Suffix	"N(`yoghurt ,)"
`yogi	Suffix	"N(`yogi ,)"
`yogurt	Suffix	"N(`yogurt ,)"
`yokel	Suffix	"N(`yokel ,)"
`yolk	Suffix	"N(`yolk ,ajr8)"
`yore	Suffix	"N(`yore ,)"
`youth	Suffix	"N(`youth ,)"
`yuppie	Suffix	"N(`yuppie ,)"
`yurt	Suffix	"N(`yurt ,)"
`zeal	Suffix	"N(`zeal ,)"
`zealot	Suffix	"N(`zealot ,)"
`zealotry	Suffix	"N(`zealot ,)"
`zeitgeist	Suffix	"N(`zeitgeist ,)"
`zen	Suffix	"N(`zen ,)"
`zenith	Suffix	"N(`zenith ,)"
`zephyr	Suffix	"N(`zephyr ,)"
`zest	Suffix	"N(`zest ,)"
`zilch	Suffix	"N(`zilch ,)"
`zinc	Suffix	"N(`zinc ,)"
`zipper	Suffix	"N(`zipper ,ajr8)"
`zodiac	Suffix	"N(`zodiac ,)"
`zombi	Suffix	"N(`zombi ,)"
`zombie	Suffix	"N(`zombie ,)"
`zoo	Suffix	"N(`zoo ,)"
`zookeeper	Suffix	"N(`zookeeper ,)"
`zwieback	Suffix	"N(`zwieback ,)"
`zygote	Suffix	"N(`zygote ,)"
`zymurgy	Suffix	"N(`zymurgy ,)"
`zymurgy	Suffix	"N(`zymurgy ,)"
`Sunday	PN_Suffix	"N(`Sunday ,proper)"
Sun.	End	"N(`Sunday ,proper)"
`Monday	PN_Suffix	"N(`Monday ,proper)"
Mon.	End	"N(`Monday ,proper)"
`Tuesday	PN_Suffix	"N(`Tuesday ,proper)"
Tues.	End	"N(`Tuesday ,proper)"
`Wednesday	PN_Suffix	"N(`Wednesday ,proper)"
Wed.	End	"N(`Wednesday ,proper)"
`Thursday	PN_Suffix	"N(`Thursday ,proper)"
Thurs.	End	"N(`Thursday ,proper)"
`Friday	PN_Suffix	"N(`Friday ,proper)"
Fri.	End	"N(`Friday ,proper)"
`Saturday	PN_Suffix	"N(`Saturday ,proper)"
Sat.	End	"N(`Saturday ,proper)"
`January	PN_Suffix	"N(`January ,proper)"
Jan.	End	"N(`January ,proper)"
`February	PN_Suffix	"N(`February ,proper)"
Feb.	End	"N(`February ,proper)"
`March	PN_Suffix	"N(`March ,proper)"
Mar.	End	"N(`March ,proper)"
`April	PN_Suffix	"N(`April ,proper)"
Apr.	End	"N(`April ,proper)"
`May	PN_Suffix	"N(`May ,proper)"
`June	PN_Suffix	"N(`June ,proper)"
Jun.	End	"N(`June ,proper)"
Ju`ly	PN_Suffix	"N(Ju`ly ,proper)"
Jul.	End	"N(Ju`ly ,proper)"
`August	PN_Suffix	"N(`August ,proper)"
Aug.	End	"N(`August ,proper)"
Sep`tember	PN_Suffix	"N(Sep`tember ,proper)"
Sept.	End	"N(Sep`tember ,proper)"
Sep.	End	"N(Sep`tember ,proper)"
Oc`tober	PN_Suffix	"N(Oc`tober ,proper)"
Oct.	End	"N(Oc`tober ,proper)"
No`vember	PN_Suffix	"N(No`vember ,proper)"
Nov.	End	"N(No`vember ,proper)"
De`cember	PN_Suffix	"N(De`cember ,proper)"
Dec.	End	"N(De`cember ,proper)"
`Advent	PN_Suffix	"N(`Advent ,proper)"
`Chanukah	PN_Suffix	"N(`Chanukah ,proper)"
`Christmas	PN_Suffix	"N(`Christmas ,proper)"
`Christmastide	PN_Suffix	"N(`Christmastide ,proper)"
`Easter	PN_Suffix	"N(`Easter ,proper)"
E`piphany	PN_Suffix	"N(E`piphany ,proper)"
Hallo`ween	PN_Suffix	"N(Hallo`ween ,proper)"
`Hanukkah	PN_Suffix	"N(`Hanukkah ,proper)"
`Lent	PN_Suffix	"N(`Lent ,proper)"
`Lent	PN_Suffix	"N(`Lent ,proper)"
`Pasch	PN_Suffix	"N(`Pasch ,proper)"
`Passover	PN_Suffix	"N(`Passover ,proper)"
`Pentecost	PN_Suffix	"N(`Pentecost ,proper)"
`Purim	PN_Suffix	"N(`Purim ,proper)"
`Ramadan	PN_Suffix	"N(`Ramadan ,proper)"
Rosh-Hashanah	PN_Suffix	"N(Rosh-Hashanah ,proper)"
`Shavuot	PN_Suffix	"N(`Shavuot ,proper)"
`Thanksgiving	PN_Suffix	"N(`Thanksgiving ,proper)"
`Whitsunday	PN_Suffix	"N(`Whitsunday ,proper)"
`Whitsuntide	PN_Suffix	"N(`Whitsuntide ,proper)"
Xmas	PN_Suffix	"N(Xmas - christmas,proper)"
Yom-Kippur	PN_Suffix	"N(Yom-Kippur ,proper)"
`Yule	PN_Suffix	"N(`Yule ,proper)"
`Yuletide	PN_Suffix	"N(`Yuletide ,proper)"
An`dromeda	PN_Suffix	"N(An`dromeda ,proper)"
`Aries	PN_Suffix	"N(`Aries ,proper)"
Au`rora-Aus`tralis	PN_Suffix	"N(Au`rora-Aus`tralis ,proper)"
Au`rora-Bore`alis	PN_Suffix	"N(Au`rora-Bore`alis ,proper)"
A`quarius	PN_Suffix	"N(A`quarius ,proper)"
`Betelgeuse	PN_Suffix	"N(`Betelgeuse ,proper)"
`Cancer	PN_Suffix	"N(`Cancer ,proper)"
`Capricorn	PN_Suffix	"N(`Capricorn ,proper)"
Cen`taurus	PN_Suffix	"N(Cen`taurus ,proper)"
`Gemini	PN_Suffix	"N(`Gemini ,proper)"
`Jupiter	PN_Suffix	"N(`Jupiter ,proper)"
`Leo	PN_Suffix	"N(`Leo ,proper)"
`Libra	PN_Suffix	"N(`Libra ,proper)"
`Mars	PN_Suffix	"N(`Mars ,proper)"
`Mercury	PN_Suffix	"N(`Mercury ,proper)"
`Neptune	PN_Suffix	"N(`Neptune ,proper)"
O`rion	PN_Suffix	"N(O`rion ,proper)"
`Pisces	PN_Suffix	"N(`Pisces ,proper)"
`Pluto	PN_Suffix	"N(`Pluto ,proper)"
Sagit`tarius	PN_Suffix	"N(Sagit`tarius ,proper)"
`Saturn	PN_Suffix	"N(`Saturn ,proper)"
`Scorpio	PN_Suffix	"N(`Scorpio ,proper)"
`Sirius	PN_Suffix	"N(`Sirius ,proper)"
`Taurus	PN_Suffix	"N(`Taurus ,proper)"
Ursa-Major	PN_Suffix	"N(Ursa-Major ,proper)"
Ursa-Minor	PN_Suffix	"N(Ursa-Minor ,proper)"
U`ranus	PN_Suffix	"N(U`ranus ,proper)"
`Venus	PN_Suffix	"N(`Venus ,proper)"
`Virgo	PN_Suffix	"N(`Virgo ,proper)"
`ALGOL	PN_Suffix	"N(`ALGOL ,proper)"
`BASIC	PN_Suffix	"N(`BASIC ,proper)"
`BITNET	PN_Suffix	"N(`BITNET ,proper)"
`COBOL	PN_Suffix	"N(`COBOL ,proper)"
DEC	PN_Suffix	"N(DEC - digital equipment corp,proper)"
`EMACS	PN_Suffix	"N(`EMACS ,proper)"
`FORTRAN	PN_Suffix	"N(`FORTRAN ,proper)"
IBM	Infl	"N(IBM - int'l business machines,proper)"
`ICON	PN_Suffix	"N(`ICON ,proper)"
`Internet	PN_Suffix	"N(`Internet ,proper)"
`LISP	PN_Suffix	"N(`LISP ,proper)"
`LOGO	PN_Suffix	"N(`LOGO ,proper)"
`Macintosh	PN_Suffix	"N(`Macintosh ,proper)"
Pas`cal	PN_Suffix	"N(Pas`cal ,proper)"
PC-KIMMO	PN_Suffix	"N(PC-KIMMO ,proper)"
`Prolog	PN_Suffix	"N(`Prolog ,proper)"
`Smalltalk	PN_Suffix	"N(`Smalltalk ,proper)"
`SNOBOL	PN_Suffix	"N(`SNOBOL ,proper)"
`UNIX	PN_Suffix	"N(`UNIX ,proper)"
`VAX	PN_Suffix	"N(`VAX ,proper)"
`VAXen	Clitic	"N(`VAX ,proper pl irreg)"
`Ada	PN_Suffix	"N(`Ada ,proper)"
`Alice	PN_Suffix	"N(`Alice ,proper)"
`Dinah	PN_Suffix	"N(`Dinah ,proper)"
`Mabel	PN_Suffix	"N(`Mabel ,proper)"
`William	PN_Suffix	"N(`William ,proper)"
`Edwin	PN_Suffix	"N(`Edwin ,proper)"
`Morcar	PN_Suffix	"N(`Morcar ,proper)"
`Mercia	PN_Suffix	"N(`Mercia ,proper)"
North`umbria	PN_Suffix	"N(North`umbria ,proper)"
`Stigand	PN_Suffix	"N(`Stigand ,proper)"
`Edgar	PN_Suffix	"N(`Edgar ,proper)"
`Atheling	PN_Suffix	"N(`Atheling ,proper)"
`Mary	PN_Suffix	"N(`Mary ,proper)"
Ann	PN_Suffix	"N(Ann ,proper)"
`Cheshire	PN_Suffix	"N(`Cheshire ,proper)"
`Elsie	PN_Suffix	"N(`Elsie ,proper)"
`Lacie	PN_Suffix	"N(`Lacie ,proper)"
`Tillie	PN_Suffix	"N(`Tillie ,proper)"
A`chilles	PN_Suffix	"N(A`chilles ,proper)"
`Allah	PN_Suffix	"N(`Allah ,proper)"
`Aristotle	PN_Suffix	"N(`Aristotle ,proper)"
`Augustine	PN_Suffix	"N(`Augustine ,proper)"
Be`elzebub	PN_Suffix	"N(Be`elzebub ,proper)"
`Bloomfield	PN_Suffix	"N(`Bloomfield ,proper)"
`Brahma	PN_Suffix	"N(`Brahma ,proper)"
`Brahman	PN_Suffix	"N(`Brahman ,proper)"
`Brahmin	PN_Suffix	"N(`Brahmin ,proper)"
`Buddha	PN_Suffix	"N(`Buddha ,proper)"
`Buddhism	Suffix	"N(`Buddha ,proper)"
`Buddhist	Suffix	"N(`Buddha ,proper)"
`Calvin	PN_Suffix	"N(`Calvin ,proper)"
`Christ	PN_Suffix	"N(`Christ ,proper)"
`Christendom	Suffix	"N(`Christendom ,proper)"
Co`lumbus	PN_Suffix	"N(Co`lumbus ,proper)"
Con`fucius	PN_Suffix	"N(Con`fucius ,proper)"
Co`pernicus	PN_Suffix	"N(Co`pernicus ,proper)"
`Darwin	PN_Suffix	"N(`Darwin ,proper)"
Dio`nysus	PN_Suffix	"N(Dio`nysus ,proper)"
`Einstein	PN_Suffix	"N(`Einstein ,proper)"
`Freud	PN_Suffix	"N(`Freud ,proper)"
`God	PN_Suffix	"N(`God ,proper)"
`Hercules	PN_Suffix	"N(`Hercules ,proper)"
Je`hovah	PN_Suffix	"N(Je`hovah ,proper)"
`Jesus	PN_Suffix	"N(`Jesus ,proper)"
`Jesuit	Infl	"N(`Jesuit ,)"
`jesuit	Suffix	"N(`jesuit ,)"
`Jung	PN_Suffix	"N(`Jung ,proper)"
`Krishna	PN_Suffix	"N(`Krishna ,proper)"
`Lenin	PN_Suffix	"N(`Lenin ,proper)"
`Lord	PN_Suffix	"N(`Lord ,proper)"
`Lucifer	PN_Suffix	"N(`Lucifer ,proper)"
`Luther	PN_Suffix	"N(`Luther ,proper)"
`Marx	PN_Suffix	"N(`Marx ,proper)"
Mo`hammed	PN_Suffix	"N(Mo`hammed ,proper)"
M`hammad	PN_Suffix	"N(M`hammad ,proper)"
Na`poleon	PN_Suffix	"N(Na`poleon ,proper)"
`Newton	PN_Suffix	"N(`Newton ,proper)"
`Plato	PN_Suffix	"N(`Plato ,proper)"
`Platonism	Suffix	"N(`Plato ,proper)"
`Platonist	Suffix	"N(`Plato ,proper)"
`Santa-Claus	PN_Suffix	"N(`Santa-Claus ,proper)"
`Satan	PN_Suffix	"N(`Satan ,proper)"
`satan	Suffix	"N(`satan ,proper)"
`Shakespeare	PN_Suffix	"N(`Shakespeare ,proper)"
`Siva	PN_Suffix	"N(`Siva ,proper)"
`Shiva	PN_Suffix	"N(`Shiva ,proper)"
`Socrates	PN_Suffix	"N(`Socrates ,proper)"
`Vishnu	PN_Suffix	"N(`Vishnu ,proper)"
`Hades	Suffix	"N(`Hades ,proper)"
`Hell	Suffix	"N(`Hell ,proper)"
Ko`ran	Suffix	"N(Ko`ran ,proper)"
Qur'an	Suffix	"N(Qur'an ,proper)"
Ku-Klux-Klan	Suffix	"N(Ku-Klux-Klan ,proper)"
`Talmud	Suffix	"N(`Talmud ,proper)"
To`rah	Suffix	"N(To`rah ,proper)"
`Uther	Suffix	"N(`Uther ,proper)"
`Veda	Suffix	"N(`Veda ,proper)"
`Afghan	PN_Suffix	"N(`Afghan ,proper)"
Al`gonquian	PN_Suffix	"N(Al`gonquian ,proper)"
Al`gonquin	PN_Suffix	"N(Al`gonquin ,proper)"
`Anabaptist	PN_Suffix	"N(`Anabaptist ,proper)"
`Anglo	PN_Suffix	"N(`Anglo ,proper)"
`Arab	PN_Suffix	"N(`Arab ,proper)"
Atha`bascan	PN_Suffix	"N(Atha`bascan ,proper)"
`Aztec	PN_Suffix	"N(`Aztec ,proper)"
A`pache	PN_Suffix	"N(A`pache ,proper)"
Ba`ha'i	PN_Suffix	"N(Ba`ha'i ,proper)"
`Baptist	PN_Suffix	"N(`Baptist ,proper)"
`Basque	PN_Suffix	"N(`Basque ,proper)"
`Bedouin	PN_Suffix	"N(`Bedouin ,proper)"
`Beduin	PN_Suffix	"N(`Beduin ,proper)"
`Briton	PN_Suffix	"N(`Briton ,proper)"
`Cajun	PN_Suffix	"N(`Cajun ,proper)"
`Celt	PN_Suffix	"N(`Celt ,proper)"
`Cherokee	PN_Suffix	"N(`Cherokee ,proper)"
Cheyenne	PN_Suffix	"N(Cheyenne ,proper)"
Chi`cano	PN_Suffix	"N(Chi`cano ,proper)"
Choctaw	PN_Suffix	"N(Choctaw ,proper)"
Co`manche	PN_Suffix	"N(Co`manche ,proper)"
`Creole	PN_Suffix	"N(`Creole ,proper)"
`Croat	PN_Suffix	"N(`Croat ,proper)"
`Dane	PN_Suffix	"N(`Dane ,proper)"
`Eskimo	PN_Suffix	"N(`Eskimo ,proper)"
Fili`pina	PN_Suffix	"N(Fili`pina ,proper)"
`Finn	PN_Suffix	"N(`Finn ,proper)"
`Frank	PN_Suffix	"N(`Frank ,proper)"
`Hellene	PN_Suffix	"N(`Hellene ,proper)"
`Hindu	PN_Suffix	"N(`Hindu ,proper)"
`Inca	PN_Suffix	"N(`Inca ,proper)"
`Iroquois	PN_Suffix	"N(`Iroquois ,proper)"
`Islam	PN_Suffix	"N(`Islam ,proper)"
`Jain	PN_Suffix	"N(`Jain ,proper)"
`Jew	PN_Suffix	"N(`Jew ,proper)"
`Jewry	PN_Suffix	"N(`Jew ,proper)"
`Judaism	PN_Suffix	"N(`Judaism ,proper)"
`Kiowa	PN_Suffix	"N(`Kiowa ,proper)"
`Kurd	PN_Suffix	"N(`Kurd ,proper)"
La`tino	PN_Suffix	"N(La`tino ,proper)"
`Maori	PN_Suffix	"N(`Maori ,proper)"
`Maya	PN_Suffix	"N(`Maya ,proper)"
`Mennonite	PN_Suffix	"N(`Mennonite ,proper)"
`Mohawk	PN_Suffix	"N(`Mohawk ,proper)"
`Mongol	PN_Suffix	"N(`Mongol ,proper)"
`Navajo	PN_Suffix	"N(`Navajo ,proper)"
Naza`rene	PN_Suffix	"N(Naza`rene ,proper)"
`Norse	PN_Suffix	"N(`Norse ,proper)"
Pili`pino	PN_Suffix	"N(Pili`pino ,proper)"
`Pole	PN_Suffix	"N(`Pole ,proper)"
`Sanskrit	PN_Suffix	"N(`Sanskrit ,proper)"
`Saxon	PN_Suffix	"N(`Saxon ,proper)"
`Scot	PN_Suffix	"N(`Scot ,proper)"
`Serb	PN_Suffix	"N(`Serb ,proper)"
`Shinto	PN_Suffix	"N(`Shinto ,proper)"
`Sioux	PN_Suffix	"N(`Sioux ,proper)"
`Slav	PN_Suffix	"N(`Slav ,proper)"
`Spaniard	PN_Suffix	"N(`Spaniard ,proper)"
Swa`hili	PN_Suffix	"N(Swa`hili ,proper)"
`Swede	PN_Suffix	"N(`Swede ,proper)"
`Sybarite	PN_Suffix	"N(`Sybarite ,proper)"
Ta`galog	PN_Suffix	"N(Ta`galog ,proper)"
`Tao	PN_Suffix	"N(`Tao ,proper)"
`Teuton	PN_Suffix	"N(`Teuton ,proper)"
Baton-Rouge	PN_Suffix	"N(Baton-Rouge ,proper)"
Corpus-Christi	PN_Suffix	"N(Corpus-Christi - also a holy day,proper)"
Des-Moines	PN_Suffix	"N(Des-Moines ,proper)"
El-Paso	PN_Suffix	"N(El-Paso ,proper)"
El-Salvadore	PN_Suffix	"N(El-Salvadore ,proper)"
San-Salvadore	PN_Suffix	"N(San-Salvadore ,proper)"
Las-Vegas	PN_Suffix	"N(Las-Vegas ,proper)"
Los-Angeles	PN_Suffix	"N(Los-Angeles ,proper)"
Nova-Scotia	PN_Suffix	"N(Nova-Scotia ,proper)"
Puerto-Rico	PN_Suffix	"N(Puerto-Rico ,proper)"
San-Antonio	PN_Suffix	"N(San-Antonio ,proper)"
San-Diego	PN_Suffix	"N(San-Diego ,proper)"
San-Francisco	PN_Suffix	"N(San-Francisco ,proper)"
San-Jose	PN_Suffix	"N(San-Jose ,proper)"
Santa-Ana	PN_Suffix	"N(Santa-Ana ,proper)"
Burkina-Faso	PN_Suffix	"N(Burkina-Faso ,proper)"
Costa-Rica	PN_Suffix	"N(Costa-Rica ,proper)"
Cote-d'Ivoire	PN_Suffix	"N(Cote-d'Ivoire ,proper)"
Sierra-Leone	PN_Suffix	"N(Sierra-Leone ,proper)"
Sri-Lanka	PN_Suffix	"N(Sri-Lanka ,proper)"
Cape-Verde	PN_Suffix	"N(Cape-Verde ,proper)"
`Abidjan	PN_Suffix	"N(`Abidjan ,proper)"
Adi`rondack	PN_Suffix	"N(Adi`rondack ,proper)"
Adri`atic	PN_Suffix	"N(Adri`atic ,proper)"
Ae`gean	PN_Suffix	"N(Ae`gean ,proper)"
Af`ghanistan	PN_Suffix	"N(Af`ghanistan ,proper)"
`Africa	PN_Suffix	"N(`Africa ,proper)"
Ala`bama	PN_Suffix	"N(Ala`bama ,proper)"
A`laska	PN_Suffix	"N(A`laska ,proper)"
Al`bania	PN_Suffix	"N(Al`bania ,proper)"
`Albany	PN_Suffix	"N(`Albany ,proper)"
Al`berta	PN_Suffix	"N(Al`berta ,proper)"
`Albuquerque	PN_Suffix	"N(`Albuquerque ,proper)"
Alex`andria	PN_Suffix	"N(Alex`andria ,proper)"
Al`geria	PN_Suffix	"N(Al`geria ,proper)"
Al`giers	PN_Suffix	"N(Al`giers ,proper)"
`Allegheny	PN_Suffix	"N(`Allegheny ,proper)"
`Alps	PN_Suffix	"N(`Alps ,proper)"
Al`sace	PN_Suffix	"N(Al`sace ,proper)"
`Amazon	PN_Suffix	"N(`Amazon ,proper)"
A`merica	PN_Suffix	"N(A`merica ,proper)"
Ameri`cana	PN_Suffix	"N(A`merica ,proper)"
Am`man	PN_Suffix	"N(Am`man ,proper)"
`Amsterdam	PN_Suffix	"N(`Amsterdam ,proper)"
`Andes	PN_Suffix	"N(`Andes ,proper)"
An`gola	PN_Suffix	"N(An`gola ,proper)"
`Ankara	PN_Suffix	"N(`Ankara ,proper)"
An`napolis	PN_Suffix	"N(An`napolis ,proper)"
Ant`arctica	PN_Suffix	"N(Ant`arctica ,proper)"
An`tietam	PN_Suffix	"N(An`tietam ,proper)"
An`tigua	PN_Suffix	"N(An`tigua ,proper)"
An`tilles	PN_Suffix	"N(An`tilles ,proper)"
Appa`lachia	PN_Suffix	"N(Appa`lachia ,proper)"
A`rabia	PN_Suffix	"N(A`rabia ,proper)"
Argen`tina	PN_Suffix	"N(Argen`tina ,proper)"
Ari`zona	PN_Suffix	"N(Ari`zona ,proper)"
`Arkansas	PN_Suffix	"N(`Arkansas ,proper)"
Arma`geddon	PN_Suffix	"N(Arma`geddon ,proper)"
Ar`menia	PN_Suffix	"N(Ar`menia ,proper)"
`Asia	PN_Suffix	"N(`Asia ,proper)"
As`syria	PN_Suffix	"N(As`syria ,proper)"
`Athens	PN_Suffix	"N(`Athens ,proper)"
At`lanta	PN_Suffix	"N(At`lanta ,proper)"
At`lantis	PN_Suffix	"N(At`lantis ,proper)"
Au`gusta	PN_Suffix	"N(Au`gusta ,proper)"
`Auschwitz	PN_Suffix	"N(`Auschwitz ,proper)"
`Austin	PN_Suffix	"N(`Austin ,proper)"
Aus`tralia	PN_Suffix	"N(Aus`tralia ,proper)"
`Austria	PN_Suffix	"N(`Austria ,proper)"
`Azerbaijan	PN_Suffix	"N(`Azerbaijan ,proper)"
`Azore	PN_Suffix	"N(`Azore ,proper)"
`Babel	PN_Suffix	"N(`Babel ,proper)"
`Babylon	PN_Suffix	"N(`Babylon ,proper)"
`Baghdad	PN_Suffix	"N(`Baghdad ,proper)"
Ba`hamas	PN_Suffix	"N(Ba`hamas ,proper)"
Bah`rain	PN_Suffix	"N(Bah`rain ,proper)"
`Bali	PN_Suffix	"N(`Bali ,proper)"
`Balkan	PN_Suffix	"N(`Balkan ,proper)"
`Baltic	PN_Suffix	"N(`Baltic ,proper)"
`Baltimore	PN_Suffix	"N(`Baltimore ,proper)"
`Bangkok	PN_Suffix	"N(`Bangkok ,proper)"
Bangla`desh	PN_Suffix	"N(Bangla`desh ,proper)"
`Barbados	PN_Suffix	"N(`Barbados ,proper)"
Barce`lona	PN_Suffix	"N(Barce`lona ,proper)"
Ba`varia	PN_Suffix	"N(Ba`varia ,proper)"
Bei`jing	PN_Suffix	"N(Bei`jing ,proper)"
Bei`rut	PN_Suffix	"N(Bei`rut ,proper)"
`Belfast	PN_Suffix	"N(`Belfast ,proper)"
`Belgium	PN_Suffix	"N(`Belgium ,proper)"
`Belgrade	PN_Suffix	"N(`Belgrade ,proper)"
Be`lize	PN_Suffix	"N(Be`lize ,proper)"
`Bengal	PN_Suffix	"N(`Bengal ,proper)"
Be`nin	PN_Suffix	"N(Be`nin ,proper)"
`Berkeley	PN_Suffix	"N(`Berkeley ,proper)"
`Berkshire	PN_Suffix	"N(`Berkshire ,proper)"
Ber`lin	PN_Suffix	"N(Ber`lin ,proper)"
Ber`liner	PN_Suffix	"N(Ber`lin ,proper)"
Ber`muda	PN_Suffix	"N(Ber`muda ,proper)"
`Bern	PN_Suffix	"N(`Bern ,proper)"
Beth`esda	PN_Suffix	"N(Beth`esda ,proper)"
`Bethlehem	PN_Suffix	"N(`Bethlehem ,proper)"
`Birmingham	PN_Suffix	"N(`Birmingham ,proper)"
`Bismarck	PN_Suffix	"N(`Bismarck ,proper)"
Bhu`tan	PN_Suffix	"N(Bhu`tan ,proper)"
Bogo`ta	PN_Suffix	"N(Bogo`ta ,proper)"
Bo`hemia	PN_Suffix	"N(Bo`hemia ,proper)"
`Boise	PN_Suffix	"N(`Boise ,proper)"
Bo`livia	PN_Suffix	"N(Bo`livia ,proper)"
Bo`logna	PN_Suffix	"N(Bo`logna ,proper)"
Bom`bay	PN_Suffix	"N(Bom`bay ,proper)"
`Bonn	PN_Suffix	"N(`Bonn ,proper)"
`Borneo	PN_Suffix	"N(`Borneo ,proper)"
`Boston	PN_Suffix	"N(`Boston ,proper)"
Bots`wana	PN_Suffix	"N(Bots`wana ,proper)"
Bra`silia	PN_Suffix	"N(Bra`silia ,proper)"
Bra`zil	PN_Suffix	"N(Bra`zil ,proper)"
`Brazzaville	PN_Suffix	"N(`Brazzaville ,proper)"
`Brisbane	PN_Suffix	"N(`Brisbane ,proper)"
`Britain	PN_Suffix	"N(`Britain ,proper)"
`Brittany	PN_Suffix	"N(`Brittany ,proper)"
`Broadway	PN_Suffix	"N(`Broadway ,proper)"
`Bronx	PN_Suffix	"N(`Bronx ,proper)"
`Brooklyn	PN_Suffix	"N(`Brooklyn ,proper)"
Bru`nei	PN_Suffix	"N(Bru`nei ,proper)"
`Brunswick	PN_Suffix	"N(`Brunswick ,proper)"
`Brussels	PN_Suffix	"N(`Brussels ,proper)"
`Bucharest	PN_Suffix	"N(`Bucharest ,proper)"
`Budapest	PN_Suffix	"N(`Budapest ,proper)"
Bul`garia	PN_Suffix	"N(Bul`garia ,proper)"
`Burlington	PN_Suffix	"N(`Burlington ,proper)"
`Burma	PN_Suffix	"N(`Burma ,proper)"
Bu`rundi	PN_Suffix	"N(Bu`rundi ,proper)"
Byelo`russia	PN_Suffix	"N(Byelo`russia ,proper)"
By`zantium	PN_Suffix	"N(By`zantium ,proper)"
`Cairo	PN_Suffix	"N(`Cairo ,proper)"
Cal`cutta	PN_Suffix	"N(Cal`cutta ,proper)"
`Calgary	PN_Suffix	"N(`Calgary ,proper)"
Cali`fornia	PN_Suffix	"N(Cali`fornia ,proper)"
`Cameroon	PN_Suffix	"N(`Cameroon ,proper)"
Cam`bodia	PN_Suffix	"N(Cam`bodia ,proper)"
`Cambridge	PN_Suffix	"N(`Cambridge ,proper)"
`Camelot	PN_Suffix	"N(`Camelot ,proper)"
`Canaan	PN_Suffix	"N(`Canaan ,proper)"
`Canada	PN_Suffix	"N(`Canada ,proper)"
`Canberra	PN_Suffix	"N(`Canberra ,proper)"
`Canterbury	PN_Suffix	"N(`Canterbury ,proper)"
`Canton	PN_Suffix	"N(`Canton ,proper)"
`Capetown	PN_Suffix	"N(`Capetown ,proper)"
Capis`trano	PN_Suffix	"N(Capis`trano ,proper)"
Ca`racas	PN_Suffix	"N(Ca`racas ,proper)"
Ca`ribbean	PN_Suffix	"N(Ca`ribbean ,proper)"
Caro`lina	PN_Suffix	"N(Caro`lina ,proper)"
`Carthage	PN_Suffix	"N(`Carthage ,proper)"
`Caspian	PN_Suffix	"N(`Caspian ,proper)"
`Catskill	PN_Suffix	"N(`Catskill ,proper)"
Cey`lon	PN_Suffix	"N(Cey`lon ,proper)"
`Chad	PN_Suffix	"N(`Chad ,proper)"
`Charleston	PN_Suffix	"N(`Charleston ,proper)"
`Charlotte	PN_Suffix	"N(`Charlotte ,proper)"
`Chesapeake	PN_Suffix	"N(`Chesapeake ,proper)"
Chi`cago	PN_Suffix	"N(Chi`cago ,proper)"
`Chile	PN_Suffix	"N(`Chile ,proper)"
`China	PN_Suffix	"N(`China ,proper)"
Cincin`nati	PN_Suffix	"N(Cincin`nati ,proper)"
`Cleveland	PN_Suffix	"N(`Cleveland ,proper)"
Co`lombia	PN_Suffix	"N(Co`lombia ,proper)"
Colo`rado	PN_Suffix	"N(Colo`rado ,proper)"
Co`lumbia	PN_Suffix	"N(Co`lumbia ,proper)"
`Congo	PN_Suffix	"N(`Congo ,proper)"
Con`necticut	PN_Suffix	"N(Con`necticut ,proper)"
Constanti`nople	PN_Suffix	"N(Constanti`nople ,proper)"
`Copenhagen	PN_Suffix	"N(`Copenhagen ,proper)"
`Corinth	PN_Suffix	"N(`Corinth ,proper)"
`Cornwall	PN_Suffix	"N(`Cornwall ,proper)"
`Crete	PN_Suffix	"N(`Crete ,proper)"
Cro`atia	PN_Suffix	"N(Cro`atia ,proper)"
`Cuba	PN_Suffix	"N(`Cuba ,proper)"
`Cypriot	PN_Suffix	"N(`Cypriot ,proper)"
`Cyprus	PN_Suffix	"N(`Cyprus ,proper)"
`Czech	PN_Suffix	"N(`Czech ,proper)"
`Czechs	Clitic	"N(`Czech ,proper pl)"
Czechoslo`vakia	PN_Suffix	"N(Czechoslo`vakia ,proper)"
Da`kota	PN_Suffix	"N(Da`kota ,proper)"
`Dallas	PN_Suffix	"N(`Dallas ,proper)"
Da`mascus	PN_Suffix	"N(Da`mascus ,proper)"
`Danube	PN_Suffix	"N(`Danube ,proper)"
`Delaware	PN_Suffix	"N(`Delaware ,proper)"
`Delhi	PN_Suffix	"N(`Delhi ,proper)"
`Delphi	PN_Suffix	"N(`Delphi ,proper)"
`Denmark	PN_Suffix	"N(`Denmark ,proper)"
`Denver	PN_Suffix	"N(`Denver ,proper)"
De`troit	PN_Suffix	"N(De`troit ,proper)"
`Dixie	PN_Suffix	"N(`Dixie ,proper)"
`Dixieland	PN_Suffix	"N(`Dixieland ,proper)"
Dja`karta	PN_Suffix	"N(Dja`karta ,proper)"
Dji`bouti	PN_Suffix	"N(Dji`bouti ,proper)"
Do`minica	PN_Suffix	"N(Do`minica ,proper)"
`Dover	PN_Suffix	"N(`Dover ,proper)"
`Dublin	PN_Suffix	"N(`Dublin ,proper)"
`Dubliner	PN_Suffix	"N(`Dublin ,proper)"
`Ecuador	PN_Suffix	"N(`Ecuador ,proper)"
`Eden	PN_Suffix	"N(`Eden ,proper)"
`Edinburgh	PN_Suffix	"N(`Edinburgh ,proper)"
`Egypt	PN_Suffix	"N(`Egypt ,proper)"
`England	PN_Suffix	"N(`England ,proper)"
`Ephesus	PN_Suffix	"N(`Ephesus ,proper)"
`Essex	PN_Suffix	"N(`Essex ,proper)"
Es`tonia	PN_Suffix	"N(Es`tonia ,proper)"
Ethi`opia	PN_Suffix	"N(Ethi`opia ,proper)"
Eu`phrates	PN_Suffix	"N(Eu`phrates ,proper)"
Eu`rasia	PN_Suffix	"N(Eu`rasia ,proper)"
`Europe	PN_Suffix	"N(`Europe ,proper)"
`Everglades	PN_Suffix	"N(`Everglades ,proper)"
`Fargo	PN_Suffix	"N(`Fargo ,proper)"
`Fiji	PN_Suffix	"N(`Fiji ,proper)"
`Finland	PN_Suffix	"N(`Finland ,proper)"
`Florence	PN_Suffix	"N(`Florence ,proper)"
`Florida	PN_Suffix	"N(`Florida ,proper)"
For`mosa	PN_Suffix	"N(For`mosa ,proper)"
`France	PN_Suffix	"N(`France ,proper)"
Fran`cisco	PN_Suffix	"N(Fran`cisco ,proper)"
`Frankfurt	PN_Suffix	"N(`Frankfurt ,proper)"
`Fuji	PN_Suffix	"N(`Fuji ,proper)"
Ga`bon	PN_Suffix	"N(Ga`bon ,proper)"
`Gael	PN_Suffix	"N(`Gael ,proper)"
Ga`lapagos	PN_Suffix	"N(Ga`lapagos ,proper)"
`Galilee	PN_Suffix	"N(`Galilee ,proper)"
`Galveston	PN_Suffix	"N(`Galveston ,proper)"
`Gambia	PN_Suffix	"N(`Gambia ,proper)"
`Ganges	PN_Suffix	"N(`Ganges ,proper)"
`Gaza	PN_Suffix	"N(`Gaza ,proper)"
Ge`neva	PN_Suffix	"N(Ge`neva ,proper)"
`Georgia	PN_Suffix	"N(`Georgia ,proper)"
`Germany	PN_Suffix	"N(`Germany ,proper)"
`Gettysburg	PN_Suffix	"N(`Gettysburg ,proper)"
`Ghana	PN_Suffix	"N(`Ghana ,proper)"
Gib`raltar	PN_Suffix	"N(Gib`raltar ,proper)"
`Golan	PN_Suffix	"N(`Golan ,proper)"
Gre`nada	PN_Suffix	"N(Gre`nada ,proper)"
`Greece	PN_Suffix	"N(`Greece ,proper)"
`Greenland	PN_Suffix	"N(`Greenland ,proper)"
`Greenwich	PN_Suffix	"N(`Greenwich ,proper)"
`Guam	PN_Suffix	"N(`Guam ,proper)"
Guade`lupe	PN_Suffix	"N(Guade`lupe ,proper)"
Guan`tanamo	PN_Suffix	"N(Guan`tanamo ,proper)"
Guate`mala	PN_Suffix	"N(Guate`mala ,proper)"
`Guinea	PN_Suffix	"N(`Guinea ,proper)"
Guy`ana	PN_Suffix	"N(Guy`ana ,proper)"
`Hague	PN_Suffix	"N(`Hague ,proper)"
`Haifa	PN_Suffix	"N(`Haifa ,proper)"
`Haiti	PN_Suffix	"N(`Haiti ,proper)"
`Halifax	PN_Suffix	"N(`Halifax ,proper)"
`Hamburg	PN_Suffix	"N(`Hamburg ,proper)"
`Hampshire	PN_Suffix	"N(`Hampshire ,proper)"
Ha`noi	PN_Suffix	"N(Ha`noi ,proper)"
`Harrisburg	PN_Suffix	"N(`Harrisburg ,proper)"
`Hartford	PN_Suffix	"N(`Hartford ,proper)"
`Hatteras	PN_Suffix	"N(`Hatteras ,proper)"
Ha`vana	PN_Suffix	"N(Ha`vana ,proper)"
Ha`waii	PN_Suffix	"N(Ha`waii ,proper)"
He`lena	PN_Suffix	"N(He`lena ,proper)"
`Helsinki	PN_Suffix	"N(`Helsinki ,proper)"
Hima`laya	PN_Suffix	"N(Hima`laya ,proper)"
Hi`roshima	PN_Suffix	"N(Hi`roshima ,proper)"
`Holland	PN_Suffix	"N(`Holland ,proper)"
`Hollywood	PN_Suffix	"N(`Hollywood ,proper)"
Hon`duras	PN_Suffix	"N(Hon`duras ,proper)"
Hono`lulu	PN_Suffix	"N(Hono`lulu ,proper)"
`Houston	PN_Suffix	"N(`Houston ,proper)"
`Hungary	PN_Suffix	"N(`Hungary ,proper)"
I`beria	PN_Suffix	"N(I`beria ,proper)"
`Iceland	PN_Suffix	"N(`Iceland ,proper)"
`Idaho	PN_Suffix	"N(`Idaho ,proper)"
Illi`nois	PN_Suffix	"N(Illi`nois ,proper)"
`India	PN_Suffix	"N(`India ,proper)"
Indi`ana	PN_Suffix	"N(Indi`ana ,proper)"
Indian`apolis	PN_Suffix	"N(Indian`apolis ,proper)"
`Indies	PN_Suffix	"N(`Indies ,proper)"
Indo`china	PN_Suffix	"N(Indo`china ,proper)"
Indo`nesia	PN_Suffix	"N(Indo`nesia ,proper)"
`Iowa	PN_Suffix	"N(`Iowa ,proper)"
I`ran	PN_Suffix	"N(I`ran ,proper)"
I`raq	PN_Suffix	"N(I`raq ,proper)"
`Ireland	PN_Suffix	"N(`Ireland ,proper)"
Is`lamabad	PN_Suffix	"N(Is`lamabad ,proper)"
`Israel	PN_Suffix	"N(`Israel ,proper)"
`Israelite	PN_Suffix	"N(`Israelite ,proper)"
`Istanbul	PN_Suffix	"N(`Istanbul ,proper)"
`Italy	PN_Suffix	"N(`Italy ,proper)"
`Jackson	PN_Suffix	"N(`Jackson ,proper)"
Ja`karta	PN_Suffix	"N(Ja`karta ,proper)"
Ja`maica	PN_Suffix	"N(Ja`maica ,proper)"
Ja`pan	PN_Suffix	"N(Ja`pan ,proper)"
`Java	PN_Suffix	"N(`Java ,proper)"
`Jericho	PN_Suffix	"N(`Jericho ,proper)"
`Jersey	PN_Suffix	"N(`Jersey ,proper)"
Je`rusalem	PN_Suffix	"N(Je`rusalem ,proper)"
Jo`hannesburg	PN_Suffix	"N(Jo`hannesburg ,proper)"
`Jordan	PN_Suffix	"N(`Jordan ,proper)"
Ju`dea	PN_Suffix	"N(Ju`dea ,proper)"
`Juneau	PN_Suffix	"N(`Juneau ,proper)"
`Kabul	PN_Suffix	"N(`Kabul ,proper)"
`Kansas	PN_Suffix	"N(`Kansas ,proper)"
Ka`rachi	PN_Suffix	"N(Ka`rachi ,proper)"
Ken`tucky	PN_Suffix	"N(Ken`tucky ,proper)"
`Kenya	PN_Suffix	"N(`Kenya ,proper)"
Kalama`zoo	PN_Suffix	"N(Kalama`zoo ,proper)"
Kam`pala	PN_Suffix	"N(Kam`pala ,proper)"
Kathman`du	PN_Suffix	"N(Kathman`du ,proper)"
Katman`du	PN_Suffix	"N(Katman`du ,proper)"
Khar`toum	PN_Suffix	"N(Khar`toum ,proper)"
Ki`ev	PN_Suffix	"N(Ki`ev ,proper)"
`Kingston	PN_Suffix	"N(`Kingston ,proper)"
Kin`shasha	PN_Suffix	"N(Kin`shasha ,proper)"
`Kodiak	PN_Suffix	"N(`Kodiak ,proper)"
Ko`rea	PN_Suffix	"N(Ko`rea ,proper)"
Kraka`toa	PN_Suffix	"N(Kraka`toa ,proper)"
`Krakow	PN_Suffix	"N(`Krakow ,proper)"
Ku`wait	PN_Suffix	"N(Ku`wait ,proper)"
`Kyoto	PN_Suffix	"N(`Kyoto ,proper)"
`Labrador	PN_Suffix	"N(`Labrador ,proper)"
`Lagos	PN_Suffix	"N(`Lagos ,proper)"
`Lancaster	PN_Suffix	"N(`Lancaster ,proper)"
`Lansing	PN_Suffix	"N(`Lansing ,proper)"
`Laos	PN_Suffix	"N(`Laos ,proper)"
`Laramie	PN_Suffix	"N(`Laramie ,proper)"
La`redo	PN_Suffix	"N(La`redo ,proper)"
`Latvia	PN_Suffix	"N(`Latvia ,proper)"
`Lauderdale	PN_Suffix	"N(`Lauderdale ,proper)"
Lau`sanne	PN_Suffix	"N(Lau`sanne ,proper)"
`Lebanon	PN_Suffix	"N(`Lebanon ,proper)"
`Leningrad	PN_Suffix	"N(`Leningrad ,proper)"
Le`sotho	PN_Suffix	"N(Le`sotho ,proper)"
Li`beria	PN_Suffix	"N(Li`beria ,proper)"
`Libya	PN_Suffix	"N(`Libya ,proper)"
`Liechtenstein	PN_Suffix	"N(`Liechtenstein ,proper)"
`Lima	PN_Suffix	"N(`Lima ,proper)"
`Lisbon	PN_Suffix	"N(`Lisbon ,proper)"
Lithu`ania	PN_Suffix	"N(Lithu`ania ,proper)"
`Liverpool	PN_Suffix	"N(`Liverpool ,proper)"
`London	PN_Suffix	"N(`London ,proper)"
Louisi`ana	PN_Suffix	"N(Louisi`ana ,proper)"
`Louisville	PN_Suffix	"N(`Louisville ,proper)"
`Lourdes	PN_Suffix	"N(`Lourdes ,proper)"
Lu`cerne	PN_Suffix	"N(Lu`cerne ,proper)"
`Luxembourg	PN_Suffix	"N(`Luxembourg ,proper)"
Lu`zon	PN_Suffix	"N(Lu`zon ,proper)"
Ly`on	PN_Suffix	"N(Ly`on ,proper)"
Ma`cao	PN_Suffix	"N(Ma`cao ,proper)"
Mace`donia	PN_Suffix	"N(Mace`donia ,proper)"
Mada`gascar	PN_Suffix	"N(Mada`gascar ,proper)"
`Madison	PN_Suffix	"N(`Madison ,proper)"
Ma`drid	PN_Suffix	"N(Ma`drid ,proper)"
`Maine	PN_Suffix	"N(`Maine ,proper)"
Ma`lawi	PN_Suffix	"N(Ma`lawi ,proper)"
Ma`laysia	PN_Suffix	"N(Ma`laysia ,proper)"
`Maldives	PN_Suffix	"N(`Maldives ,proper)"
`Mali	PN_Suffix	"N(`Mali ,proper)"
`Malta	PN_Suffix	"N(`Malta ,proper)"
Ma`nagua	PN_Suffix	"N(Ma`nagua ,proper)"
`Manchester	PN_Suffix	"N(`Manchester ,proper)"
Man`hattan	PN_Suffix	"N(Man`hattan ,proper)"
Ma`nila	PN_Suffix	"N(Ma`nila ,proper)"
Mani`toba	PN_Suffix	"N(Mani`toba ,proper)"
Mar`seilles	PN_Suffix	"N(Mar`seilles ,proper)"
`Maryland	PN_Suffix	"N(`Maryland ,proper)"
Massa`chusetts	PN_Suffix	"N(Massa`chusetts ,proper)"
Mauri`tania	PN_Suffix	"N(Mauri`tania ,proper)"
Maur`itius	PN_Suffix	"N(Maur`itius ,proper)"
`Mecca	PN_Suffix	"N(`Mecca ,proper)"
`Mekong	PN_Suffix	"N(`Mekong ,proper)"
Mela`nesia	PN_Suffix	"N(Mela`nesia ,proper)"
`Melbourne	PN_Suffix	"N(`Melbourne ,proper)"
`Memphis	PN_Suffix	"N(`Memphis ,proper)"
Mesopo`tamia	PN_Suffix	"N(Mesopo`tamia ,proper)"
`Mexico	PN_Suffix	"N(`Mexico ,proper)"
Mi`ami	PN_Suffix	"N(Mi`ami ,proper)"
`Michigan	PN_Suffix	"N(`Michigan ,proper)"
Micro`nesia	PN_Suffix	"N(Micro`nesia ,proper)"
Mi`lan	PN_Suffix	"N(Mi`lan ,proper)"
Mil`waukee	PN_Suffix	"N(Mil`waukee ,proper)"
Minda`nao	PN_Suffix	"N(Minda`nao ,proper)"
Minne`apolis	PN_Suffix	"N(Minne`apolis ,proper)"
Minne`sota	PN_Suffix	"N(Minne`sota ,proper)"
Missis`sippi	PN_Suffix	"N(Missis`sippi ,proper)"
Mis`soula	PN_Suffix	"N(Mis`soula ,proper)"
Mis`souri	PN_Suffix	"N(Mis`souri ,proper)"
Mo`luccas	PN_Suffix	"N(Mo`luccas ,proper)"
`Monaco	PN_Suffix	"N(`Monaco ,proper)"
Mon`golia	PN_Suffix	"N(Mon`golia ,proper)"
Mon`rovia	PN_Suffix	"N(Mon`rovia ,proper)"
Mon`tana	PN_Suffix	"N(Mon`tana ,proper)"
Monte`negro	PN_Suffix	"N(Monte`negro ,proper)"
Monti`cello	PN_Suffix	"N(Monti`cello ,proper)"
Mont`pelier	PN_Suffix	"N(Mont`pelier ,proper)"
Montre`al	PN_Suffix	"N(Montre`al ,proper)"
Mo`ravia	PN_Suffix	"N(Mo`ravia ,proper)"
Mo`rocco	PN_Suffix	"N(Mo`rocco ,proper)"
`Moscow	PN_Suffix	"N(`Moscow ,proper)"
Mozam`bique	PN_Suffix	"N(Mozam`bique ,proper)"
`Muscovite	PN_Suffix	"N(`Muscovite ,proper)"
`Munich	PN_Suffix	"N(`Munich ,proper)"
Naga`saki	PN_Suffix	"N(Naga`saki ,proper)"
Nai`robi	PN_Suffix	"N(Nai`robi ,proper)"
Nan`tucket	PN_Suffix	"N(Nan`tucket ,proper)"
`Naples	PN_Suffix	"N(`Naples ,proper)"
Narra`gansett	PN_Suffix	"N(Narra`gansett ,proper)"
`Nashville	PN_Suffix	"N(`Nashville ,proper)"
`Nazareth	PN_Suffix	"N(`Nazareth ,proper)"
Ne`braska	PN_Suffix	"N(Ne`braska ,proper)"
Ne`pal	PN_Suffix	"N(Ne`pal ,proper)"
`Netherlands	PN_Suffix	"N(`Netherlands ,proper)"
Ne`vada	PN_Suffix	"N(Ne`vada ,proper)"
`Newark	PN_Suffix	"N(`Newark ,proper)"
`Newfoundland	PN_Suffix	"N(`Newfoundland ,proper)"
`Newport	PN_Suffix	"N(`Newport ,proper)"
Ni`agara	PN_Suffix	"N(Ni`agara ,proper)"
Nica`ragua	PN_Suffix	"N(Nica`ragua ,proper)"
Nico`sia	PN_Suffix	"N(Nico`sia ,proper)"
`Niger	PN_Suffix	"N(`Niger ,proper)"
Ni`geria	PN_Suffix	"N(Ni`geria ,proper)"
`Nile	PN_Suffix	"N(`Nile ,proper)"
`Norfolk	PN_Suffix	"N(`Norfolk ,proper)"
`Normandy	PN_Suffix	"N(`Normandy ,proper)"
`Norway	PN_Suffix	"N(`Norway ,proper)"
`Oakland	PN_Suffix	"N(`Oakland ,proper)"
Oce`ania	PN_Suffix	"N(Oce`ania ,proper)"
O`hio	PN_Suffix	"N(O`hio ,proper)"
Oki`nawa	PN_Suffix	"N(Oki`nawa ,proper)"
Okla`homa	PN_Suffix	"N(Okla`homa ,proper)"
`Omaha	PN_Suffix	"N(`Omaha ,proper)"
O`man	PN_Suffix	"N(O`man ,proper)"
On`tario	PN_Suffix	"N(On`tario ,proper)"
`Oregon	PN_Suffix	"N(`Oregon ,proper)"
Or`lando	PN_Suffix	"N(Or`lando ,proper)"
`Orleans	PN_Suffix	"N(`Orleans ,proper)"
O`saka	PN_Suffix	"N(O`saka ,proper)"
`Oslo	PN_Suffix	"N(`Oslo ,proper)"
`Ottawa	PN_Suffix	"N(`Ottawa ,proper)"
Ouaga`dougou	PN_Suffix	"N(Ouaga`dougou ,proper)"
`Oxford	PN_Suffix	"N(`Oxford ,proper)"
`Ozark	PN_Suffix	"N(`Ozark ,proper)"
`Pakistan	PN_Suffix	"N(`Pakistan ,proper)"
`Palestine	PN_Suffix	"N(`Palestine ,proper)"
`Panama	PN_Suffix	"N(`Panama ,proper)"
`Papua	PN_Suffix	"N(`Papua ,proper)"
`Paraguay	PN_Suffix	"N(`Paraguay ,proper)"
`Paris	PN_Suffix	"N(`Paris ,proper)"
Pasa`dena	PN_Suffix	"N(Pasa`dena ,proper)"
Pata`gonia	PN_Suffix	"N(Pata`gonia ,proper)"
Paw`tucket	PN_Suffix	"N(Paw`tucket ,proper)"
Pe`king	PN_Suffix	"N(Pe`king ,proper)"
Pennsyl`vania	PN_Suffix	"N(Pennsyl`vania ,proper)"
Pensa`cola	PN_Suffix	"N(Pensa`cola ,proper)"
Pe`oria	PN_Suffix	"N(Pe`oria ,proper)"
`Persia	PN_Suffix	"N(`Persia ,proper)"
`Perth	PN_Suffix	"N(`Perth ,proper)"
Pe`ru	PN_Suffix	"N(Pe`ru ,proper)"
Phila`delphia	PN_Suffix	"N(Phila`delphia ,proper)"
`Philippines	PN_Suffix	"N(`Philippines ,proper)"
Phoe`nicia	PN_Suffix	"N(Phoe`nicia ,proper)"
`Pierre	PN_Suffix	"N(`Pierre ,proper)"
`Pittsburgh	PN_Suffix	"N(`Pittsburgh ,proper)"
`Pocono	PN_Suffix	"N(`Pocono ,proper)"
`Poland	PN_Suffix	"N(`Poland ,proper)"
Poly`nesia	PN_Suffix	"N(Poly`nesia ,proper)"
Pom`peii	PN_Suffix	"N(Pom`peii ,proper)"
Port-au-Prince	PN_Suffix	"N(Port-au-Prince ,proper)"
`Portland	PN_Suffix	"N(`Portland ,proper)"
`Portsmouth	PN_Suffix	"N(`Portsmouth ,proper)"
`Portugal	PN_Suffix	"N(`Portugal ,proper)"
Po`tomac	PN_Suffix	"N(Po`tomac ,proper)"
Pough`keepsie	PN_Suffix	"N(Pough`keepsie ,proper)"
`Prague	PN_Suffix	"N(`Prague ,proper)"
Pre`toria	PN_Suffix	"N(Pre`toria ,proper)"
`Prussia	PN_Suffix	"N(`Prussia ,proper)"
Pyong`yang	PN_Suffix	"N(Pyong`yang ,proper)"
Qa`tar	PN_Suffix	"N(Qa`tar ,proper)"
Que`bec	PN_Suffix	"N(Que`bec ,proper)"
`Quito	PN_Suffix	"N(`Quito ,proper)"
`Raleigh	PN_Suffix	"N(`Raleigh ,proper)"
Ran`goon	PN_Suffix	"N(Ran`goon ,proper)"
`Reykjavik	PN_Suffix	"N(`Reykjavik ,proper)"
`Rhine	PN_Suffix	"N(`Rhine ,proper)"
`Rhode	PN_Suffix	"N(`Rhode ,proper)"
Rho`desia	PN_Suffix	"N(Rho`desia ,proper)"
`Richmond	PN_Suffix	"N(`Richmond ,proper)"
Ri`yadh	PN_Suffix	"N(Ri`yadh ,proper)"
`Rochester	PN_Suffix	"N(`Rochester ,proper)"
`Rome	PN_Suffix	"N(`Rome ,proper)"
Ro`mania	PN_Suffix	"N(Ro`mania ,proper)"
Ru`mania	PN_Suffix	"N(Ru`mania ,proper)"
`Russia	PN_Suffix	"N(`Russia ,proper)"
`Rwanda	PN_Suffix	"N(`Rwanda ,proper)"
Sacra`mento	PN_Suffix	"N(Sacra`mento ,proper)"
Sa`hara	PN_Suffix	"N(Sa`hara ,proper)"
Sai`gon	PN_Suffix	"N(Sai`gon ,proper)"
`Salem	PN_Suffix	"N(`Salem ,proper)"
`Salisbury	PN_Suffix	"N(`Salisbury ,proper)"
`Salvador	PN_Suffix	"N(`Salvador ,proper)"
Sa`moa	PN_Suffix	"N(Sa`moa ,proper)"
Santi`ago	PN_Suffix	"N(Santi`ago ,proper)"
Sas`katchewan	PN_Suffix	"N(Sas`katchewan ,proper)"
Sa`udi	PN_Suffix	"N(Sa`udi ,proper)"
Sa`vannah	PN_Suffix	"N(Sa`vannah ,proper)"
`Saxony	PN_Suffix	"N(`Saxony ,proper)"
Scandi`navia	PN_Suffix	"N(Scandi`navia ,proper)"
`Scarborough	PN_Suffix	"N(`Scarborough ,proper)"
Sche`nectady	PN_Suffix	"N(Sche`nectady ,proper)"
`Scotland	PN_Suffix	"N(`Scotland ,proper)"
`Scranton	PN_Suffix	"N(`Scranton ,proper)"
Se`attle	PN_Suffix	"N(Se`attle ,proper)"
`Seine	PN_Suffix	"N(`Seine ,proper)"
`Selma	PN_Suffix	"N(`Selma ,proper)"
`Senegal	PN_Suffix	"N(`Senegal ,proper)"
`Seoul	PN_Suffix	"N(`Seoul ,proper)"
`Serbia	PN_Suffix	"N(`Serbia ,proper)"
Sey`chelles	PN_Suffix	"N(Sey`chelles ,proper)"
`Shanghai	PN_Suffix	"N(`Shanghai ,proper)"
Shenan`doah	PN_Suffix	"N(Shenan`doah ,proper)"
`Shreveport	PN_Suffix	"N(`Shreveport ,proper)"
Si`am	PN_Suffix	"N(Si`am ,proper)"
Si`beria	PN_Suffix	"N(Si`beria ,proper)"
`Sicily	PN_Suffix	"N(`Sicily ,proper)"
`Sidney	PN_Suffix	"N(`Sidney ,proper)"
`Sinai	PN_Suffix	"N(`Sinai ,proper)"
`Singapore	PN_Suffix	"N(`Singapore ,proper)"
So`fia	PN_Suffix	"N(So`fia ,proper)"
`Solomon	PN_Suffix	"N(`Solomon - islands,proper)"
So`malia	PN_Suffix	"N(So`malia ,proper)"
`Spain	PN_Suffix	"N(`Spain ,proper)"
`Sparta	PN_Suffix	"N(`Sparta ,proper)"
Spo`kane	PN_Suffix	"N(Spo`kane ,proper)"
Stockholm	PN_Suffix	"N(Stockholm ,proper)"
`Stonehenge	PN_Suffix	"N(`Stonehenge ,proper)"
`Stuttgart	PN_Suffix	"N(`Stuttgart ,proper)"
`Styx	PN_Suffix	"N(`Styx ,proper)"
Su`dan	PN_Suffix	"N(Su`dan ,proper)"
Su`ez	PN_Suffix	"N(Su`ez ,proper)"
`Suffolk	PN_Suffix	"N(`Suffolk ,proper)"
Su`matra	PN_Suffix	"N(Su`matra ,proper)"
`Sumer	PN_Suffix	"N(`Sumer ,proper)"
`Suriname	PN_Suffix	"N(`Suriname ,proper)"
`Sussex	PN_Suffix	"N(`Sussex ,proper)"
`Swaziland	PN_Suffix	"N(`Swaziland ,proper)"
`Sweden	PN_Suffix	"N(`Sweden ,proper)"
`Switzerland	PN_Suffix	"N(`Switzerland ,proper)"
`Sydney	PN_Suffix	"N(`Sydney ,proper)"
`Syracuse	PN_Suffix	"N(`Syracuse ,proper)"
`Syria	PN_Suffix	"N(`Syria ,proper)"
Ta`coma	PN_Suffix	"N(Ta`coma ,proper)"
Ta`hiti	PN_Suffix	"N(Ta`hiti ,proper)"
`Tahoe	PN_Suffix	"N(`Tahoe ,proper)"
Tai`pei	PN_Suffix	"N(Tai`pei ,proper)"
Tai`wan	PN_Suffix	"N(Tai`wan ,proper)"
Talla`hassee	PN_Suffix	"N(Talla`hassee ,proper)"
`Tampa	PN_Suffix	"N(`Tampa ,proper)"
Tan`zania	PN_Suffix	"N(Tan`zania ,proper)"
Tas`mania	PN_Suffix	"N(Tas`mania ,proper)"
Teguci`galpa	PN_Suffix	"N(Teguci`galpa ,proper)"
Tehe`ran	PN_Suffix	"N(Tehe`ran ,proper)"
Teh`ran	PN_Suffix	"N(Teh`ran ,proper)"
Tennes`see	PN_Suffix	"N(Tennes`see ,proper)"
`Texas	PN_Suffix	"N(`Texas ,proper)"
`Thai	PN_Suffix	"N(`Thai ,proper)"
`Thailand	PN_Suffix	"N(`Thailand ,proper)"
`Thames	PN_Suffix	"N(`Thames ,proper)"
Ti`bet	PN_Suffix	"N(Ti`bet ,proper)"
`Tigris	PN_Suffix	"N(`Tigris ,proper)"
To`bago	PN_Suffix	"N(To`bago ,proper)"
`Togo	PN_Suffix	"N(`Togo ,proper)"
`Tokyo	PN_Suffix	"N(`Tokyo ,proper)"
To`ledo	PN_Suffix	"N(To`ledo ,proper)"
To`peka	PN_Suffix	"N(To`peka ,proper)"
To`ronto	PN_Suffix	"N(To`ronto ,proper)"
`Trinidad	PN_Suffix	"N(`Trinidad ,proper)"
`Troy	PN_Suffix	"N(`Troy ,proper)"
`Tucson	PN_Suffix	"N(`Tucson ,proper)"
`Tulsa	PN_Suffix	"N(`Tulsa ,proper)"
`Tunis	PN_Suffix	"N(`Tunis ,proper)"
Tu`nisia	PN_Suffix	"N(Tu`nisia ,proper)"
`Turkey	PN_Suffix	"N(`Turkey ,proper)"
`Turkish	PN_Suffix	"N(`Turkish ,proper)"
U`ganda	PN_Suffix	"N(U`ganda ,proper)"
Uk`raine	PN_Suffix	"N(Uk`raine ,proper)"
`Ulster	PN_Suffix	"N(`Ulster ,proper)"
`Uruguay	PN_Suffix	"N(`Uruguay ,proper)"
`Utah	PN_Suffix	"N(`Utah ,proper)"
Van`couver	PN_Suffix	"N(Van`couver ,proper)"
Vanu`atu	PN_Suffix	"N(Vanu`atu ,proper)"
`Vatican	PN_Suffix	"N(`Vatican ,proper)"
Vene`zuela	PN_Suffix	"N(Vene`zuela ,proper)"
`Venice	PN_Suffix	"N(`Venice ,proper)"
Ver`mont	PN_Suffix	"N(Ver`mont ,proper)"
Ver`sailles	PN_Suffix	"N(Ver`sailles ,proper)"
Vi`enna	PN_Suffix	"N(Vi`enna ,proper)"
`Vietnam	PN_Suffix	"N(`Vietnam ,proper)"
Vir`ginia	PN_Suffix	"N(Vir`ginia ,proper)"
`Volga	PN_Suffix	"N(`Volga ,proper)"
`Warsaw	PN_Suffix	"N(`Warsaw ,proper)"
`Washington	PN_Suffix	"N(`Washington ,proper)"
`Westminster	PN_Suffix	"N(`Westminster ,proper)"
`Wichita	PN_Suffix	"N(`Wichita ,proper)"
`Williamsburg	PN_Suffix	"N(`Williamsburg ,proper)"
`Wilmington	PN_Suffix	"N(`Wilmington ,proper)"
`Winnipeg	PN_Suffix	"N(`Winnipeg ,proper)"
Wis`consin	PN_Suffix	"N(Wis`consin ,proper)"
`Worcester	PN_Suffix	"N(`Worcester ,proper)"
Wy`oming	PN_Suffix	"N(Wy`oming ,proper)"
`Yakima	PN_Suffix	"N(`Yakima ,proper)"
`Yarmouth	PN_Suffix	"N(`Yarmouth ,proper)"
`Yemen	PN_Suffix	"N(`Yemen ,proper)"
`York	PN_Suffix	"N(`York ,proper)"
`Yorkshire	PN_Suffix	"N(`Yorkshire ,proper)"
Yo`semite	PN_Suffix	"N(Yo`semite ,proper)"
`Yucatan	PN_Suffix	"N(`Yucatan ,proper)"
`Yugoslav	PN_Suffix	"N(`Yugoslav ,proper)"
Yugo`slavia	PN_Suffix	"N(Yugo`slavia ,proper)"
`Yukon	PN_Suffix	"N(`Yukon ,proper)"
`Zagreb	PN_Suffix	"N(`Zagreb ,proper)"
Za`ire	PN_Suffix	"N(Za`ire ,proper)"
Zam`bezi	PN_Suffix	"N(Zam`bezi ,proper)"
`Zambia	PN_Suffix	"N(`Zambia ,proper)"
`Zanzibar	PN_Suffix	"N(`Zanzibar ,proper)"
`Zealand	PN_Suffix	"N(`Zealand ,proper)"
Zim`babwe	PN_Suffix	"N(Zim`babwe ,proper)"
`Zion	PN_Suffix	"N(`Zion ,proper)"
`Zulu	PN_Suffix	"N(`Zulu ,proper)"
`Zurich	PN_Suffix	"N(`Zurich ,proper)"
`Zurich	PN_Suffix	"N(`Zurich ,proper)"
`Zurich	PN_Suffix	"N(`Zurich ,proper)"
acceler`ometer	Suffix	"N(acceler`ometer ,)"
`acetate	Suffix	"N(`acetate ,)"
a`cetic	Suffix	"N(a`cetic ,)"
`acetone	Suffix	"N(`acetone ,)"
a`cetylene	Suffix	"N(a`cetylene ,)"
`acrylate	Suffix	"N(`acrylate ,)"
`actinide	Suffix	"N(`actinide ,)"
ac`tinium	Suffix	"N(ac`tinium ,)"
acti`nometer	Suffix	"N(acti`nometer ,)"
ade`noma	Suffix	"N(ade`noma ,)"
ad`sorbate	Suffix	"N(ad`sorbate ,)"
ag`glutinin	Suffix	"N(ag`glutinin ,)"
ag`nomen	Suffix	"N(ag`nomen ,)"
ai`lanthus	Suffix	"N(ai`lanthus ,)"
`aldehyde	Suffix	"N(`aldehyde ,)"
`aldrin	Suffix	"N(`aldrin ,)"
a`lizarin	Suffix	"N(a`lizarin ,)"
`alkali	Suffix	"N(`alkali ,)"
`alkaloid	Suffix	"N(`alkaloid ,)"
`alkane	Suffix	"N(`alkane ,)"
`alkene	Suffix	"N(`alkene ,)"
al`lele	Suffix	"N(al`lele ,)"
`allyl	Suffix	"N(`allyl ,)"
`almagest	Suffix	"N(`almagest ,)"
al`timeter	Suffix	"N(al`timeter ,)"
a`lumina	Suffix	"N(a`lumina ,)"
a`luminate	Suffix	"N(a`luminate ,)"
a`mericium	Suffix	"N(a`mericium ,)"
`amide	Suffix	"N(`amide ,)"
`ammeter	Suffix	"N(`ammeter ,)"
am`moniac	Suffix	"N(am`moniac ,)"
am`monium	Suffix	"N(am`monium ,)"
`ampere	Suffix	"N(`ampere ,)"
`amperage	Suffix	"N(`ampere ,)"
`amphibole	Suffix	"N(`amphibole ,)"
a`mygdaloid	Suffix	"N(a`mygdaloid ,)"
ana`stigmat	Suffix	"N(ana`stigmat ,)"
anasto`mosis	Suffix	"N(anasto`mosis ,)"
`andesite	Suffix	"N(`andesite ,)"
an`hydride	Suffix	"N(an`hydride ,)"
an`hydrite	Suffix	"N(an`hydrite ,)"
`aniline	Suffix	"N(`aniline ,)"
`anion	Suffix	"N(`anion ,)"
a`northosite	Suffix	"N(a`northosite ,)"
an`thracnose	Suffix	"N(an`thracnose ,)"
`antigen	Suffix	"N(`antigen ,)"
a`phelion	Suffix	"N(a`phelion ,)"
arc`cosine	Suffix	"N(arc`cosine ,)"
arc`sine	Suffix	"N(arc`sine ,)"
arc`tangent	Suffix	"N(arc`tangent ,)"
`arsenide	Suffix	"N(`arsenide ,)"
ar`sine	Suffix	"N(ar`sine ,)"
ar`teriole	Suffix	"N(ar`teriole ,)"
arterio`sclerosis	Suffix	"N(arterio`sclerosis ,)"
`aryl	Suffix	"N(`aryl ,)"
`astatine	Suffix	"N(`astatine ,)"
astro`physicist	Suffix	"N(`astrophysics ,)"
`astrophysics	Clitic	"N(`astrophysics ,)"
`asymptote	Suffix	"N(`asymptote ,)"
a`synchrony	Suffix	"N(a`synchrony ,)"
atheroscler`osis	Suffix	"N(atheroscler`osis ,)"
`augend	Suffix	"N(`augend ,)"
`autoclave	Suffix	"N(`autoclave ,)"
auto`morphism	Suffix	"N(auto`morphism ,)"
`axon	Suffix	"N(`axon ,)"
bar`biturate	Suffix	"N(bar`biturate ,)"
`barium	Suffix	"N(`barium ,)"
`baud	Suffix	"N(`baud ,)"
`bauxite	Suffix	"N(`bauxite ,)"
`berkelium	Suffix	"N(`berkelium ,)"
be`ryllium	Suffix	"N(be`ryllium ,)"
`betatron	Suffix	"N(`betatron ,)"
bilhar`ziasis	Suffix	"N(bilhar`ziasis ,)"
`bismuth	Suffix	"N(`bismuth ,)"
bi`tumen	Suffix	"N(bi`tumen ,)"
`borate	Suffix	"N(`borate ,)"
`borax	Suffix	"N(`borax ,)"
`boron	Suffix	"N(`boron ,)"
boro`silicate	Suffix	"N(boro`silicate ,)"
`botulin	Suffix	"N(`botulin ,)"
`boule	Suffix	"N(`boule ,)"
`bremsstrahlung	Suffix	"N(`bremsstrahlung ,)"
`bromine	Suffix	"N(`bromine ,)"
brucel`losis	Suffix	"N(brucel`losis ,)"
`bryophyte	Suffix	"N(`bryophyte ,)"
bu`ret	Suffix	"N(bu`ret ,)"
bu`rette	Suffix	"N(bu`rette ,)"
buta`diene	Suffix	"N(buta`diene ,)"
`butyl	Suffix	"N(`butyl ,)"
`butyrate	Suffix	"N(`butyrate ,)"
`byte	Suffix	"N(`byte ,)"
`cadmium	Suffix	"N(`cadmium ,)"
`calamus	Suffix	"N(`calamus ,)"
`calcite	Suffix	"N(`calcite ,)"
cali`fornium	Suffix	"N(cali`fornium ,)"
calo`rimeter	Suffix	"N(calo`rimeter ,)"
`carbide	Suffix	"N(`carbide ,)"
`carbine	Suffix	"N(`carbine ,)"
`carbonate	Suffix	"N(`carbonate ,)"
`carbonyl	Suffix	"N(`carbonyl ,)"
carbo`rundum	Suffix	"N(carbo`rundum ,)"
car`cinogen	Suffix	"N(car`cinogen ,)"
carci`noma	Suffix	"N(carci`noma ,)"
ca`tarrh	Suffix	"N(ca`tarrh ,)"
cata`tonia	Suffix	"N(cata`tonia ,)"
`catheter	Suffix	"N(`catheter ,)"
`cathode	Suffix	"N(`cathode ,)"
`cellulose	Suffix	"N(`cellulose ,)"
`centrifuge	Suffix	"N(`centrifuge ,)"
cere`bellum	Suffix	"N(cere`bellum ,)"
`cerium	Suffix	"N(`cerium ,)"
chemi`sorption	Suffix	"N(chemi`sorption ,)"
`chlorate	Suffix	"N(`chlorate ,)"
`chlordane	Suffix	"N(`chlordane ,)"
`chloride	Suffix	"N(`chloride ,)"
`chlorine	Suffix	"N(`chlorine ,)"
`chloroform	Suffix	"N(`chloroform ,)"
`chlorophyll	Suffix	"N(`chlorophyll ,)"
`chromate	Suffix	"N(`chromate ,)"
chro`matogram	Suffix	"N(chro`matogram ,)"
chro`matograph	Suffix	"N(chro`matograph ,)"
chroma`tography	Suffix	"N(chroma`tography ,)"
`chromium	Suffix	"N(`chromium ,)"
`chromosome	Suffix	"N(`chromosome ,)"
`chromosphere	Suffix	"N(`chromosphere ,)"
`chronograph	Suffix	"N(`chronograph ,)"
chro`nography	Suffix	"N(chro`nography ,)"
chro`nometer	Suffix	"N(chro`nometer ,)"
`ciliate	Suffix	"N(`ciliate ,)"
`citrate	Suffix	"N(`citrate ,)"
coccidi`osis	Suffix	"N(coccidi`osis ,)"
colo`rimeter	Suffix	"N(colo`rimeter ,)"
`colza	Suffix	"N(`colza ,)"
`cordite	Suffix	"N(`cordite ,)"
`corpuscle	Suffix	"N(`corpuscle ,)"
`cosine	Suffix	"N(`cosine ,)"
`coulomb	Suffix	"N(`coulomb ,)"
`cryostat	Suffix	"N(`cryostat ,)"
`crystallite	Suffix	"N(`crystal ,)"
`curie	Suffix	"N(`curie ,)"
`curium	Suffix	"N(`curium ,)"
`cyanate	Suffix	"N(`cyanate ,)"
`cyanide	Suffix	"N(`cyanide ,)"
`cyclotron	Suffix	"N(`cyclotron ,)"
cyto`chemistry	Suffix	"N(cyto`chemistry ,)"
cy`tolysis	Suffix	"N(cy`tolysis ,)"
`cytoplasm	Suffix	"N(`cytoplasm ,)"
`dactyl	Suffix	"N(`dactyl ,)"
`decibel	Suffix	"N(`decibel ,)"
`decile	Suffix	"N(`decile ,)"
`deltoid	Suffix	"N(`deltoid ,)"
`dendrite	Suffix	"N(`dendrite ,)"
densi`tometer	Suffix	"N(densi`tometer ,)"
deu`terium	Suffix	"N(deu`terium ,)"
`deuteron	Suffix	"N(`deuteron ,)"
`dextrose	Suffix	"N(`dextrose ,)"
`dey	Suffix	"N(`dey ,)"
`diabase	Suffix	"N(`diabase ,)"
dicoty`ledon	Suffix	"N(dicoty`ledon ,)"
diethylstil`bestrol	Suffix	"N(diethylstil`bestrol ,)"
diffrac`tometer	Suffix	"N(diffrac`tometer ,)"
di`fluoride	Suffix	"N(di`fluoride ,)"
di`logarithm	Suffix	"N(di`logarithm ,)"
`diluent	Suffix	"N(`diluent ,)"
`diode	Suffix	"N(`diode ,)"
`diopter	Suffix	"N(`diopter ,)"
di`oxide	Suffix	"N(di`oxide ,)"
di`sulfide	Suffix	"N(di`sulfide ,)"
`dolomite	Suffix	"N(`dolomite ,)"
do`simeter	Suffix	"N(do`simeter ,)"
`dovekie	Suffix	"N(`dovekie ,)"
dys`pepsia	Suffix	"N(dys`pepsia ,)"
`dystrophy	Suffix	"N(`dystrophy ,)"
dys`plasia	Suffix	"N(dys`plasia ,)"
dys`prosium	Suffix	"N(dys`prosium ,)"
`eigenfunction	Suffix	"N(`eigenfunction ,)"
`eigenstate	Suffix	"N(`eigenstate ,)"
`eigenvalue	Suffix	"N(`eigenvalue ,)"
`eigenvector	Suffix	"N(`eigenvector ,)"
`einsteinium	Suffix	"N(`einsteinium ,)"
e`lastomer	Suffix	"N(e`lastomer ,)"
electro`cardiogram	Suffix	"N(electro`cardiogram ,)"
electro`cardiograph	Suffix	"N(electro`cardiograph ,)"
e`lectrode	Suffix	"N(e`lectrode ,)"
elec`trolysis	Suffix	"N(elec`trolysis ,)"
e`lectrolyte	Suffix	"N(e`lectrolyte ,)"
e`lectron	Suffix	"N(e`lectron ,)"
electroen`cephalogram	Suffix	"N(electroen`cephalogram ,)"
electroen`cephalograph	Suffix	"N(electroen`cephalograph ,)"
electroencepha`lography	Suffix	"N(electroencepha`lography ,)"
electropho`resis	Suffix	"N(electropho`resis ,)"
elec`trophorus	Suffix	"N(elec`trophorus ,)"
ellip`someter	Suffix	"N(ellip`someter ,)"
`eluate	Suffix	"N(`eluate ,)"
emis`sivity	Suffix	"N(emis`sivity ,)"
encepha`litis	Suffix	"N(encepha`litis ,)"
`enthalpy	Suffix	"N(`enthalpy ,)"
`entropy	Suffix	"N(`entropy ,)"
eo`hippus	Suffix	"N(eo`hippus ,)"
`eosine	Suffix	"N(`eosine ,)"
epi`dermis	Suffix	"N(epi`dermis ,)"
e`piphysis	Suffix	"N(e`piphysis ,)"
`epitaxy	Suffix	"N(`epitaxy ,)"
epi`thelium	Suffix	"N(epi`thelium ,)"
`erbium	Suffix	"N(`erbium ,)"
`erg	Suffix	"N(`erg ,)"
`ester	Suffix	"N(`ester ,)"
`ethane	Suffix	"N(`ethane ,)"
`ethanol	Suffix	"N(`ethanol ,)"
`ether	Suffix	"N(`ether ,)"
`ethyl	Suffix	"N(`ethyl ,)"
`ethylene	Suffix	"N(`ethylene ,)"
eu`phorbia	Suffix	"N(eu`phorbia ,)"
eu`ropium	Suffix	"N(eu`ropium ,)"
`evzone	Suffix	"N(`evzone ,)"
`exciton	Suffix	"N(`exciton ,)"
`exoskeleton	Suffix	"N(`skeleton ,)"
`fantod	Suffix	"N(`fantod ,)"
`farad	Suffix	"N(`farad ,)"
`fermion	Suffix	"N(`fermion ,)"
`fermium	Suffix	"N(`fermium ,)"
`ferrite	Suffix	"N(`ferrite ,)"
`ferromagnet	Suffix	"N(`ferromagnet ,)"
`fibrin	Suffix	"N(`fibrin ,)"
fi`brosis	Suffix	"N(fi`brosis ,)"
`filtrate	Suffix	"N(`filtrate ,)"
`fluorescein	Suffix	"N(`fluorescein ,)"
`fluoride	Suffix	"N(`fluoride ,)"
`fluorine	Suffix	"N(`fluorine ,)"
`fluorite	Suffix	"N(`fluorite ,)"
`fluorocarbon	Suffix	"N(`fluorocarbon ,)"
`fluorspar	Suffix	"N(`fluorspar ,)"
for`maldehyde	Suffix	"N(for`maldehyde ,)"
`formate	Suffix	"N(`formate ,)"
`francium	Suffix	"N(`francium ,)"
`fungicide	Suffix	"N(`fungus ,)"
`gabbro	Suffix	"N(`gabbro ,)"
gado`linium	Suffix	"N(gado`linium ,)"
ga`lena	Suffix	"N(ga`lena ,)"
`gallium	Suffix	"N(`gallium ,)"
`galvanism	Suffix	"N(`galvanism ,)"
galva`nometer	Suffix	"N(galva`nometer ,)"
`gaur	Suffix	"N(`gaur ,)"
`gauss	Suffix	"N(`gauss ,)"
`gelatine	Suffix	"N(`gelatine ,)"
ger`manium	Suffix	"N(ger`manium ,)"
glau`coma	Suffix	"N(glau`coma ,)"
`globulin	Suffix	"N(`globulin ,)"
`glutamate	Suffix	"N(`glutamate ,)"
`glyceride	Suffix	"N(`glyceride ,)"
`glycerin	Suffix	"N(`glycerin ,)"
`glycerine	Suffix	"N(`glycerine ,)"
`glycerol	Suffix	"N(`glycerol ,)"
`glycol	Suffix	"N(`glycol ,)"
`gnomon	Suffix	"N(`gnomon ,)"
goni`ometer	Suffix	"N(goni`ometer ,)"
`graphite	Suffix	"N(`graphite ,)"
`guanidine	Suffix	"N(`guanidine ,)"
`guerdon	Suffix	"N(`guerdon ,)"
`gypsum	Suffix	"N(`gypsum ,)"
`hadron	Suffix	"N(`hadron ,)"
`hafnium	Suffix	"N(`hafnium ,)"
`halide	Suffix	"N(`halide ,)"
`halite	Suffix	"N(`halite ,)"
`halocarbon	Suffix	"N(`halocarbon ,)"
`helium	Suffix	"N(`helium ,)"
`hemoglobin	Suffix	"N(`hemoglobin ,)"
hemo`philia	Suffix	"N(hemo`philia ,)"
`hemorrhoid	Suffix	"N(`hemorrhoid ,)"
hemo`siderin	Suffix	"N(hemo`siderin ,)"
`henequen	Suffix	"N(`henequen ,)"
`henry	Suffix	"N(`henry ,)"
`heptane	Suffix	"N(`heptane ,)"
`herpes	Suffix	"N(`herpes ,)"
`hertz	Suffix	"N(`hertz ,)"
`heterostructure	Suffix	"N(`heterostructure ,)"
`hexane	Suffix	"N(`hexane ,)"
`histamine	Suffix	"N(`histamine ,)"
`histochemistry	Suffix	"N(`histochemistry ,)"
`histogram	Suffix	"N(`histogram ,)"
`holmium	Suffix	"N(`holmium ,)"
ho`lography	Suffix	"N(ho`lography ,)"
`hologram	Suffix	"N(`hologram ,)"
ho`lograph	Suffix	"N(ho`lograph ,)"
homeo`morphism	Suffix	"N(homeo`morphism ,)"
homeo`stasis	Suffix	"N(homeo`stasis ,)"
ho`mogenate	Suffix	"N(ho`mogenate ,)"
`homologue	Suffix	"N(`homologue ,)"
homo`morphism	Suffix	"N(homo`morphism ,)"
`humerus	Suffix	"N(`humerus ,)"
hu`midistat	Suffix	"N(hu`midistat ,)"
`hydrogen	Suffix	"N(`hydrogen ,)"
`hydride	Suffix	"N(`hydride ,)"
`hydrocarbon	Suffix	"N(`hydrocarbon ,)"
hydro`chemistry	Suffix	"N(hydro`chemistry ,)"
hydro`chloride	Suffix	"N(hydro`chloride ,)"
hy`drolysis	Suffix	"N(hy`drolysis ,)"
hy`drometer	Suffix	"N(hy`drometer ,)"
`hydrosphere	Suffix	"N(`hydrosphere ,)"
hy`droxide	Suffix	"N(hy`droxide ,)"
hy`droxyl	Suffix	"N(hy`droxyl ,)"
hy`grometer	Suffix	"N(hy`grometer ,)"
hy`perboloid	Suffix	"N(hy`perboloid ,)"
hypo`cycloid	Suffix	"N(hypo`cycloid ,)"
hy`potenuse	Suffix	"N(hy`potenuse ,)"
hypo`thalamus	Suffix	"N(hypo`thalamus ,)"
hyste`resis	Suffix	"N(hyste`resis ,)"
icosa`hedra	Suffix	"N(icosa`hedra ,)"
icosa`hedron	Suffix	"N(icosa`hedron ,)"
`ileum	Suffix	"N(`ileum ,)"
`indium	Suffix	"N(`indium ,)"
`integrand	Suffix	"N(`integrand ,)"
in`tegument	Suffix	"N(in`tegument ,)"
interfe`rometer	Suffix	"N(interfe`rometer ,)"
`iodate	Suffix	"N(`iodate ,)"
`iodide	Suffix	"N(`iodide ,)"
`iodine	Suffix	"N(`iodine ,)"
`ion	Suffix	"N(`ion ,)"
i`onosphere	Suffix	"N(i`onosphere ,)"
`ipecac	Suffix	"N(`ipecac ,)"
i`ridium	Suffix	"N(i`ridium ,)"
irre`dentism	Suffix	"N(irre`dentism ,)"
irre`dentist	Suffix	"N(irre`dentist ,)"
`isomer	Suffix	"N(`isomer ,)"
`isotope	Suffix	"N(`isotope ,)"
`isomorph	Suffix	"N(`isomorph ,)"
`isopleth	Suffix	"N(`isopleth ,)"
`isotherm	Suffix	"N(`isotherm ,)"
je`junum	Suffix	"N(je`junum ,)"
`joule	Suffix	"N(`joule ,)"
`ketone	Suffix	"N(`ketone ,)"
ke`tosis	Suffix	"N(ke`tosis ,)"
kines`thesia	Suffix	"N(kines`thesia ,)"
`klystron	Suffix	"N(`klystron ,)"
`krypton	Suffix	"N(`krypton ,)"
`lambert	Suffix	"N(`lambert ,)"
`lanthanide	Suffix	"N(`lanthanide ,)"
`lanthanum	Suffix	"N(`lanthanum ,)"
`laterite	Suffix	"N(`laterite ,)"
law`rencium	Suffix	"N(law`rencium ,)"
`leachate	Suffix	"N(`leachate ,)"
li`bration	Suffix	"N(li`bration ,)"
`ligand	Suffix	"N(`ligand ,)"
`lipid	Suffix	"N(`lipid ,)"
`lithosphere	Suffix	"N(`lithosphere ,)"
`logarithm	Suffix	"N(`logarithm ,)"
lu`tetium	Suffix	"N(lu`tetium ,)"
`lux	Suffix	"N(`lux ,)"
lyco`podium	Suffix	"N(lyco`podium ,)"
`lymphocyte	Suffix	"N(`lymphocyte ,)"
`macrophage	Suffix	"N(`macrophage ,)"
mag`nesia	Suffix	"N(mag`nesia ,)"
mag`nesium	Suffix	"N(mag`nesium ,)"
`magnesite	Suffix	"N(`magnesite ,)"
`magnetite	Suffix	"N(`magnetite ,)"
mag`neto	Suffix	"N(mag`neto ,)"
`magnetron	Suffix	"N(`magnetron ,)"
man`damus	Suffix	"N(man`damus ,)"
`manganese	Suffix	"N(`manganese ,)"
ma`nometer	Suffix	"N(ma`nometer ,)"
man`tissa	Suffix	"N(man`tissa ,)"
`martensite	Suffix	"N(`martensite ,)"
`maser	Suffix	"N(`maser ,)"
`mastic	Suffix	"N(`mastic ,)"
`maxwell	Suffix	"N(`maxwell ,)"
`megohm	Suffix	"N(`megohm ,)"
`melamine	Suffix	"N(`melamine ,)"
mende`levium	Suffix	"N(mende`levium ,)"
`mescaline	Suffix	"N(`mescaline ,)"
`meson	Suffix	"N(`meson ,)"
me`tabolite	Suffix	"N(me`tabolite ,)"
`metalloid	Suffix	"N(`metalloid ,)"
me`tastasis	Suffix	"N(me`tastasis ,)"
meth`acrylate	Suffix	"N(meth`acrylate ,)"
`methadone	Suffix	"N(`methadone ,)"
`methane	Suffix	"N(`methane ,)"
`methanol	Suffix	"N(`methanol ,)"
`methylene	Suffix	"N(`methylene ,)"
`mi`croscopy	Suffix	"N(`mi`croscopy ,)"
`milch	Suffix	"N(`milch ,)"
`minuend	Suffix	"N(`minuend ,)"
`moiety	Suffix	"N(`moiety ,)"
moi`re	Suffix	"N(moi`re ,)"
mo`lybdate	Suffix	"N(mo`lybdate ,)"
mo`lybdenite	Suffix	"N(mo`lybdenite ,)"
mo`lybdenum	Suffix	"N(mo`lybdenum ,)"
mono`chromator	Suffix	"N(mono`chromator ,)"
monocoty`ledon	Suffix	"N(monocoty`ledon ,)"
`monomer	Suffix	"N(`monomer ,)"
mon`oxide	Suffix	"N(mon`oxide ,)"
`morphine	Suffix	"N(`morphine ,)"
mu`ezzin	Suffix	"N(mu`ezzin ,)"
`mullein	Suffix	"N(`mullein ,)"
`mullion	Suffix	"N(`mullion ,)"
`multiplet	Suffix	"N(`multiplet ,)"
`myelin	Suffix	"N(`myelin ,)"
myo`cardium	Suffix	"N(myo`cardium ,)"
`myosin	Suffix	"N(`myosin ,)"
na`nometer	Suffix	"N(na`nometer ,)"
`nanosecond	Suffix	"N(`nanosecond ,)"
neo`dymium	Suffix	"N(neo`dymium ,)"
`neoprene	Suffix	"N(`neoprene ,)"
nep`tunium	Suffix	"N(nep`tunium ,)"
`newton	Suffix	"N(`newton ,)"
`nichrome	Suffix	"N(`nichrome ,)"
ni`obium	Suffix	"N(ni`obium ,)"
`nitrate	Suffix	"N(`nitrate ,)"
`nitrogen	Suffix	"N(`nitrogen ,)"
nitro`glycerine	Suffix	"N(nitro`glycerine ,)"
`nitride	Suffix	"N(`nitride ,)"
`nitrite	Suffix	"N(`nitrite ,)"
no`belium	Suffix	"N(no`belium ,)"
`nomograph	Suffix	"N(`nomograph ,)"
`nucleotide	Suffix	"N(`nucleotide ,)"
`nuclide	Suffix	"N(`nuclide ,)"
`octane	Suffix	"N(`octane ,)"
`octant	Suffix	"N(`octant ,)"
`ohm	Suffix	"N(`ohm ,)"
`ohmmeter	Suffix	"N(`ohmmeter ,)"
`olefin	Suffix	"N(`olefin ,)"
ortho`paedist	Suffix	"N(ortho`paedist ,)"
ortho`pedist	Suffix	"N(ortho`pedist ,)"
os`cilloscope	Suffix	"N(os`cilloscope ,)"
`osteopath	Suffix	"N(`osteopath ,)"
`osteopathy	Suffix	"N(`osteopathy ,)"
`panicle	Suffix	"N(`panicle ,)"
parallele`piped	Suffix	"N(parallele`piped ,)"
`paramagnet	Suffix	"N(`paramagnet ,)"
`pentane	Suffix	"N(`pentane ,)"
`peptide	Suffix	"N(`peptide ,)"
per`chlorate	Suffix	"N(per`chlorate ,)"
perito`nitis	Suffix	"N(perito`nitis ,)"
per`oxide	Suffix	"N(per`oxide ,)"
`phagocyte	Suffix	"N(`phagocyte ,)"
pha`langer	Suffix	"N(pha`langer ,)"
pharmaco`peia	Suffix	"N(pharmaco`peia ,)"
pharmaco`poeia	Suffix	"N(pharmaco`poeia ,)"
`phloem	Suffix	"N(`phloem ,)"
`phonon	Suffix	"N(`phonon ,)"
`phosgene	Suffix	"N(`phosgene ,)"
`phosphate	Suffix	"N(`phosphate ,)"
`phosphor	Suffix	"N(`phosphor ,)"
`phosphorus	Suffix	"N(`phosphorus ,)"
`phosphide	Suffix	"N(`phosphide ,)"
`phosphine	Suffix	"N(`phosphine ,)"
pho`tolysis	Suffix	"N(pho`tolysis ,)"
`photon	Suffix	"N(`photon ,)"
`phytoplankton	Suffix	"N(`phytoplankton ,)"
`picofarad	Suffix	"N(`picofarad ,)"
`picojoule	Suffix	"N(`picojoule ,)"
`picosecond	Suffix	"N(`picosecond ,)"
pip`sissewa	Suffix	"N(pip`sissewa ,)"
`plagioclase	Suffix	"N(`plagioclase ,)"
plane`tesimal	Suffix	"N(plane`tesimal ,)"
`planetoid	Suffix	"N(`planetoid ,)"
`plastron	Suffix	"N(`plastron ,)"
`pleurisy	Suffix	"N(`pleurisy ,)"
plu`tonium	Suffix	"N(plu`tonium ,)"
pola`rimeter	Suffix	"N(pola`rimeter ,)"
po`lariscope	Suffix	"N(po`lariscope ,)"
po`larogram	Suffix	"N(po`larogram ,)"
po`larograph	Suffix	"N(po`larograph ,)"
pola`rography	Suffix	"N(pola`rography ,)"
`polaron	Suffix	"N(`polaron ,)"
po`lonium	Suffix	"N(po`lonium ,)"
`polymerase	Suffix	"N(`polymerase ,)"
`polymer	Suffix	"N(`polymer ,)"
`polymorph	Suffix	"N(`polymorph ,)"
poly`nomial	Suffix	"N(poly`nomial ,)"
`polyp	Suffix	"N(`polyp ,)"
`polythene	Suffix	"N(`polythene ,)"
`porphyry	Suffix	"N(`porphyry ,)"
`positron	Suffix	"N(`positron ,)"
`potash	Suffix	"N(`potash ,)"
po`tassium	Suffix	"N(po`tassium ,)"
potenti`ometer	Suffix	"N(potenti`ometer ,)"
praseo`dymium	Suffix	"N(praseo`dymium ,)"
`procaine	Suffix	"N(`procaine ,)"
pro`methium	Suffix	"N(pro`methium ,)"
proprio`ception	Suffix	"N(proprio`ception ,)"
pro`scenium	Suffix	"N(pro`scenium ,)"
prosopo`poeia	Suffix	"N(prosopo`poeia ,)"
protac`tinium	Suffix	"N(protac`tinium ,)"
prote`olysis	Suffix	"N(prote`olysis ,)"
pro`thonotary	Suffix	"N(pro`thonotary ,)"
`proton	Suffix	"N(`proton ,)"
proto`zoan	Suffix	"N(proto`zoan ,)"
`pyridine	Suffix	"N(`pyridine ,)"
`pyrite	Suffix	"N(`pyrite ,)"
py`rolysis	Suffix	"N(py`rolysis ,)"
py`rometer	Suffix	"N(py`rometer ,)"
pyro`phosphate	Suffix	"N(pyro`phosphate ,)"
py`roxene	Suffix	"N(py`roxene ,)"
`quadrature	Suffix	"N(`quadrature ,)"
qua`drivium	Suffix	"N(qua`drivium ,)"
`quadrupole	Suffix	"N(`quadrupole ,)"
radio`carbon	Suffix	"N(radio`carbon ,)"
radio`chemistry	Suffix	"N(radio`chemistry ,)"
`radiogram	Suffix	"N(`radiogram ,)"
radi`ometer	Suffix	"N(radi`ometer ,)"
`radiosonde	Suffix	"N(`radiosonde ,)"
`radium	Suffix	"N(`radium ,)"
`radon	Suffix	"N(`radon ,)"
refrac`tometer	Suffix	"N(refrac`tometer ,)"
re`serpine	Suffix	"N(re`serpine ,)"
re`sorcinol	Suffix	"N(re`sorcinol ,)"
re`ticulum	Suffix	"N(re`ticulum ,)"
`rhenium	Suffix	"N(`rhenium ,)"
`rhodium	Suffix	"N(`rhodium ,)"
ru`bidium	Suffix	"N(ru`bidium ,)"
ru`thenium	Suffix	"N(ru`thenium ,)"
ru`tile	Suffix	"N(ru`tile ,)"
sac`cade	Suffix	"N(sac`cade ,)"
`sachem	Suffix	"N(`sachem ,)"
sa`marium	Suffix	"N(sa`marium ,)"
`sanicle	Suffix	"N(`sanicle ,)"
`saxifrage	Suffix	"N(`saxifrage ,)"
`scandium	Suffix	"N(`scandium ,)"
sci`atica	Suffix	"N(sci`atica ,)"
`sclera	Suffix	"N(`sclera ,)"
scle`rosis	Suffix	"N(scle`rosis ,)"
`secant	Suffix	"N(`secant ,)"
`seismograph	Suffix	"N(`seismograph ,)"
seis`mography	Suffix	"N(seis`mography ,)"
`selenate	Suffix	"N(`selenate ,)"
`selenite	Suffix	"N(`selenite ,)"
se`lenium	Suffix	"N(se`lenium ,)"
`servomechanism	Suffix	"N(`servomechanism ,)"
`servomotor	Suffix	"N(`servomotor ,)"
`silicate	Suffix	"N(`silicate ,)"
`silicide	Suffix	"N(`silicide ,)"
`silicon	Suffix	"N(`silicon ,)"
`silicone	Suffix	"N(`silicone ,)"
`sinusoid	Suffix	"N(`sinusoid ,)"
`situs	Suffix	"N(`situs ,)"
`sodium	Suffix	"N(`sodium ,)"
`solenoid	Suffix	"N(`solenoid ,)"
`solvate	Suffix	"N(`solvate ,)"
somme`lier	Suffix	"N(somme`lier ,)"
`sora	Suffix	"N(`sora ,)"
`sorb	Suffix	"N(`sorb ,)"
`spavin	Suffix	"N(`spavin ,)"
`spectrogram	Suffix	"N(`spectrogram ,)"
`spectrograph	Suffix	"N(`spectrograph ,)"
spec`trography	Suffix	"N(spec`trography ,)"
spec`trometer	Suffix	"N(spec`trometer ,)"
spectropho`tometer	Suffix	"N(spectropho`tometer ,)"
`spectroscope	Suffix	"N(`spectroscope ,)"
spec`troscopy	Suffix	"N(spec`troscopy ,)"
sper`matophyte	Suffix	"N(sper`matophyte ,)"
`strabismus	Suffix	"N(`strabismus ,)"
`strontium	Suffix	"N(`strontium ,)"
`sulfate	Suffix	"N(`sulfate ,)"
`sulfide	Suffix	"N(`sulfide ,)"
`sulfite	Suffix	"N(`sulfite ,)"
sul`fonamide	Suffix	"N(sul`fonamide ,)"
sur`tout	Suffix	"N(sur`tout ,)"
sus`pensor	Suffix	"N(sus`pensor ,)"
`sybarite	Suffix	"N(`sybarite ,)"
`synapse	Suffix	"N(`synapse ,)"
`synchrotron	Suffix	"N(`synchrotron ,)"
`tachinid	Suffix	"N(`tachinid ,)"
ta`chistoscope	Suffix	"N(ta`chistoscope ,)"
`tangent	Suffix	"N(`tangent ,)"
`tantalum	Suffix	"N(`tantalum ,)"
tech`netium	Suffix	"N(tech`netium ,)"
`tektite	Suffix	"N(`tektite ,)"
teleki`nesis	Suffix	"N(teleki`nesis ,)"
`teleost	Suffix	"N(`teleost ,)"
tel`lurium	Suffix	"N(tel`lurium ,)"
`terbium	Suffix	"N(`terbium ,)"
terra`mycin	Suffix	"N(terra`mycin ,)"
tetra`chloride	Suffix	"N(tetra`chloride ,)"
tetra`cycline	Suffix	"N(tetra`cycline ,)"
tetra`fluouride	Suffix	"N(tetra`fluouride ,)"
`thallium	Suffix	"N(`thallium ,)"
`thallophyte	Suffix	"N(`thallophyte ,)"
`thiamin	Suffix	"N(`thiamin ,)"
thio`cyanate	Suffix	"N(thio`cyanate ,)"
thi`ouracil	Suffix	"N(thi`ouracil ,)"
`thorium	Suffix	"N(`thorium ,)"
`thulium	Suffix	"N(`thulium ,)"
`thyratron	Suffix	"N(`thyratron ,)"
thy`roxine	Suffix	"N(thy`roxine ,)"
`tilth	Suffix	"N(`tilth ,)"
`titanate	Suffix	"N(`titanate ,)"
ti`tanium	Suffix	"N(ti`tanium ,)"
`tokamak	Suffix	"N(`tokamak ,)"
`toluene	Suffix	"N(`toluene ,)"
`toroid	Suffix	"N(`toroid ,)"
`torr	Suffix	"N(`torr ,)"
trichloro`ethane	Suffix	"N(trichloro`ethane ,)"
tri`fluouride	Suffix	"N(tri`fluouride ,)"
`triode	Suffix	"N(`triode ,)"
tri`oxide	Suffix	"N(tri`oxide ,)"
`tritium	Suffix	"N(`tritium ,)"
`tropopause	Suffix	"N(`tropopause ,)"
`troposphere	Suffix	"N(`troposphere ,)"
`trypsin	Suffix	"N(`trypsin ,)"
tula`remia	Suffix	"N(tula`remia ,)"
`tung	Suffix	"N(`tung ,)"
`tungstate	Suffix	"N(`tungstate ,)"
`tungsten	Suffix	"N(`tungsten ,)"
`turbofan	Suffix	"N(`turbofan ,)"
`turbojet	Suffix	"N(`turbojet ,)"
`tyrosine	Suffix	"N(`tyrosine ,)"
`uranyl	Suffix	"N(`uranyl ,)"
u`ranium	Suffix	"N(u`ranium ,)"
u`rea	Suffix	"N(u`rea ,)"
u`remia	Suffix	"N(u`remia ,)"
`urethane	Suffix	"N(`urethane ,)"
vacuo`lation	Suffix	"N(vacuo`lation ,)"
`vacuole	Suffix	"N(`vacuole ,)"
va`nadium	Suffix	"N(va`nadium ,)"
`ventricle	Suffix	"N(`ventricle ,)"
ver`miculite	Suffix	"N(ver`miculite ,)"
vis`cometer	Suffix	"N(vis`cometer ,)"
`volt	Suffix	"N(`volt ,)"
`voltage	Suffix	"N(`volt ,)"
`voltmeter	Suffix	"N(`voltmeter ,)"
`watt	Suffix	"N(`watt ,)"
`wattage	Suffix	"N(`watt ,)"
`waveform	Suffix	"N(`waveform ,)"
`wavelength	Suffix	"N(`wavelength ,)"
`weber	Suffix	"N(`weber ,)"
`withe	Suffix	"N(`withe ,)"
`withy	Suffix	"N(`withy ,)"
`xenon	Suffix	"N(`xenon ,)"
`xylem	Suffix	"N(`xylem ,)"
`xylene	Suffix	"N(`xylene ,)"
yt`terbium	Suffix	"N(yt`terbium ,)"
`yttrium	Suffix	"N(`yttrium ,)"
`zircon	Suffix	"N(`zircon ,)"
zir`conium	Suffix	"N(zir`conium ,)"
zir`conium	Suffix	"N(zir`conium ,)"

N-V:
`monkey	Suffix	"N-V(`monkey ,)"
em`bargo	Suffix	"N-V(em`bargo ,)"
las`so	Suffix	"N-V(las`so ,)"
`stucco	Suffix	"N-V(`stucco ,)"
tor`pedo	Suffix	"N-V(tor`pedo ,)"
`veto	Suffix	"N-V(`veto ,)"
`quiz	Suffix	"N-V(`quiz ,irreg)"
`dwarf	Suffix	"N-V(`dwarf ,;irreg)"
`focus	Suffix	"N-V(`focus ,)"
`index	Suffix	"N-V(`index ,)"
`fish	Suffix	"N-V(`fish ,)"
`staff	Suffix	"N-V(`staff ,sg-pl)"
`suds	Suffix	"N-V(`suds ,irreg sg-pl)"
`people	Suffix	"N-V(`people ,pl irreg rev)"
po`lice	Suffix	"N-V(po`lice ,irreg)"
`access	Suffix	"N-V(`access ,)"
`age	Suffix	"N-V(`age ,)"
`air	Suffix	"N-V(`air ,)"
`alloy	Suffix	"N-V(`alloy ,)"
a`mount	Suffix	"N-V(a`mount ,)"
`anchor	Suffix	"N-V(`anchor ,)"
`anger	Suffix	"N-V(`anger ,)"
`angle	Suffix	"N-V(`angle ,)"
`ante	Suffix	"N-V(`ante ,)"
`ape	Suffix	"N-V(`ape ,)"
ap`parel	Suffix	"N-V(ap`parel ,)"
`applique	Suffix	"N-V(`applique ,)"
`arc	Suffix	"N-V(`arc ,)"
`arch	Suffix	"N-V(`arch ,)"
`archive	Suffix	"N-V(`archive ,)"
`arm	Suffix	"N-V(`arm ,rev ~ajr14)"
`armor	Suffix	"N-V(`armor ,)"
`armour	Suffix	"N-V(`armour ,)"
`atrophy	Suffix	"N-V(`atrophy ,)"
at`tire	Suffix	"N-V(at`tire ,)"
`auction	Suffix	"N-V(`auction ,)"
au`dition	Suffix	"N-V(au`dition ,)"
`author	Suffix	"N-V(`author ,)"
`autograph	Suffix	"N-V(`autograph ,)"
`autopsy	Suffix	"N-V(`autopsy ,)"
`average	Suffix	"N-V(`average ,)"
`awe	Suffix	"N-V(`awe ,)"
`ax	Suffix	"N-V(`ax ,)"
`axe	Suffix	"N-V(`axe ,)"
`baby	Suffix	"N-V(`baby ,)"
`back	Suffix	"N-V(`back ,)"
`backhand	Suffix	"N-V(`backhand ,)"
`backlash	Suffix	"N-V(`backlash ,)"
`backlog	Suffix	"N-V(`backlog ,)"
`backpack	Suffix	"N-V(`backpack ,)"
`backspace	Suffix	"N-V(`backspace ,)"
`badger	Suffix	"N-V(`badger ,)"
`bag	Suffix	"N-V(`bag ,)"
`bait	Suffix	"N-V(`bait ,)"
`bale	Suffix	"N-V(`bale ,~nr26)"
`ball	Suffix	"N-V(`ball ,)"
`ballast	Suffix	"N-V(`ballast ,)"
bal`loon	Suffix	"N-V(bal`loon ,)"
`ballot	Suffix	"N-V(`ballot ,)"
`band	Suffix	"N-V(`band ,)"
`bandage	Suffix	"N-V(`bandage ,rev)"
`bank	Suffix	"N-V(`bank ,)"
`banquet	Suffix	"N-V(`banquet ,)"
`bar	Suffix	"N-V(`bar ,rev ~ajr14)"
`barb	Suffix	"N-V(`barb ,)"
`bargain	Suffix	"N-V(`bargain ,)"
`barricade	Suffix	"N-V(`barricade ,)"
`base	Suffix	"N-V(`base ,)"
`bat	Suffix	"N-V(`bat ,)"
`battle	Suffix	"N-V(`battle ,)"
`beach	Suffix	"N-V(`beach ,)"
`bead	Suffix	"N-V(`bead ,)"
`beam	Suffix	"N-V(`beam ,)"
`bed	Suffix	"N-V(`bed ,)"
`belly	Suffix	"N-V(`belly ,ajr8)"
`belt	Suffix	"N-V(`belt ,)"
`bench	Suffix	"N-V(`bench ,)"
`benefit	Suffix	"N-V(`benefit ,)"
`bet	Suffix	"N-V(`bet ,)"
`bias	Suffix	"N-V(`bias ,)"
`bike	Suffix	"N-V(`bike ,)"
`bill	Suffix	"N-V(`bill ,)"
`billet	Suffix	"N-V(`billet ,)"
`billow	Suffix	"N-V(`billow ,)"
`binge	Suffix	"N-V(`binge ,)"
`birth	Suffix	"N-V(`birth ,)"
`bivouac	Suffix	"N-V(`bivouac ,)"
`blacklist	Suffix	"N-V(`blacklist ,)"
`blanket	Suffix	"N-V(`blanket ,)"
`blast	Suffix	"N-V(`blast ,)"
`blaze	Suffix	"N-V(`blaze ,)"
`blazon	Suffix	"N-V(`blazon ,)"
`blemish	Suffix	"N-V(`blemish ,)"
`blight	Suffix	"N-V(`blight ,)"
`blindfold	Suffix	"N-V(`blindfold ,)"
`blister	Suffix	"N-V(`blister ,)"
`blitz	Suffix	"N-V(`blitz ,)"
`block	Suffix	"N-V(`block ,rev)"
`blossom	Suffix	"N-V(`blossom ,)"
`blot	Suffix	"N-V(`blot ,)"
`boat	Suffix	"N-V(`boat ,)"
`bog	Suffix	"N-V(`bog ,)"
`bolt	Suffix	"N-V(`bolt ,rev)"
`bomb	Suffix	"N-V(`bomb ,)"
`bond	Suffix	"N-V(`bond ,)"
`bone	Suffix	"N-V(`bone ,)"
`boo	Suffix	"N-V(`boo ,)"
`book	Suffix	"N-V(`book ,)"
`boomerang	Suffix	"N-V(`boomerang ,)"
`boot	Suffix	"N-V(`boot ,)"
`bootstrap	Suffix	"N-V(`bootstrap ,)"
`booze	Suffix	"N-V(`booze ,)"
`border	Suffix	"N-V(`border ,)"
`boss	Suffix	"N-V(`boss ,)"
`bottle	Suffix	"N-V(`bottle ,)"
`bottom	Suffix	"N-V(`bottom ,)"
`box	Suffix	"N-V(`box ,rev)"
`brace	Suffix	"N-V(`brace ,rev)"
`bracket	Suffix	"N-V(`bracket ,)"
`braille	Suffix	"N-V(`braille ,)"
`brain	Suffix	"N-V(`brain ,ajr8)"
`brake	Suffix	"N-V(`brake ,)"
`branch	Suffix	"N-V(`branch ,)"
`brand	Suffix	"N-V(`brand ,)"
`breach	Suffix	"N-V(`breach ,)"
`breakfast	Suffix	"N-V(`breakfast ,)"
`bribe	Suffix	"N-V(`bribe ,)"
`bridge	Suffix	"N-V(`bridge ,)"
`bridle	Suffix	"N-V(`bridle ,rev)"
`bristle	Suffix	"N-V(`bristle ,)"
bro`cade	Suffix	"N-V(bro`cade ,)"
`broker	Suffix	"N-V(`broker ,)"
`brood	Suffix	"N-V(`brood ,)"
`brush	Suffix	"N-V(`brush ,)"
`bubble	Suffix	"N-V(`bubble ,)"
`buckle	Suffix	"N-V(`buckle ,rev)"
`bud	Suffix	"N-V(`bud ,)"
`budget	Suffix	"N-V(`budget ,)"
`buffer	Suffix	"N-V(`buffer ,)"
`bugle	Suffix	"N-V(`bugle ,)"
`bully	Suffix	"N-V(`bully ,)"
`bump	Suffix	"N-V(`bump ,)"
`bunch	Suffix	"N-V(`bunch ,)"
`bundle	Suffix	"N-V(`bundle ,rev)"
`bunk	Suffix	"N-V(`bunk ,)"
`buoy	Suffix	"N-V(`buoy ,)"
`burden	Suffix	"N-V(`burden ,rev)"
`burrow	Suffix	"N-V(`burrow ,)"
`bus	Suffix	"N-V(`bus ,)"
`butter	Suffix	"N-V(`butter ,)"
`button	Suffix	"N-V(`button ,rev)"
`buttonhole	Suffix	"N-V(`buttonhole ,)"
`buttress	Suffix	"N-V(`buttress ,)"
`cache	Suffix	"N-V(`cache ,)"
`caddy	Suffix	"N-V(`caddy ,)"
`cage	Suffix	"N-V(`cage ,rev)"
`cake	Suffix	"N-V(`cake ,)"
`camouflage	Suffix	"N-V(`camouflage ,)"
`camp	Suffix	"N-V(`camp ,)"
cam`paign	Suffix	"N-V(cam`paign ,)"
`can	Suffix	"N-V(`can ,)"
`candy	Suffix	"N-V(`candy ,)"
ca`noe	Suffix	"N-V(ca`noe ,)"
`cap	Suffix	"N-V(`cap ,rev)"
`captain	Suffix	"N-V(`captain ,)"
`caption	Suffix	"N-V(`caption ,)"
`caricature	Suffix	"N-V(`caricature ,)"
`carol	Suffix	"N-V(`carol ,)"
`carpet	Suffix	"N-V(`carpet ,)"
`cart	Suffix	"N-V(`cart ,)"
cas`cade	Suffix	"N-V(cas`cade ,)"
`cash	Suffix	"N-V(`cash ,)"
`catalogue	Suffix	"N-V(`catalogue ,)"
`catalog	Suffix	"N-V(`catalog ,)"
`caucus	Suffix	"N-V(`caucus ,)"
`caulk	Suffix	"N-V(`caulk ,)"
`caution	Suffix	"N-V(`caution ,)"
`cave	Suffix	"N-V(`cave ,)"
ce`ment	Suffix	"N-V(ce`ment ,)"
`censor	Suffix	"N-V(`censor ,)"
`center	Suffix	"N-V(`center ,)"
`centre	Suffix	"N-V(`centre - British,)"
`chain	Suffix	"N-V(`chain ,rev)"
`chair	Suffix	"N-V(`chair ,)"
`chance	Suffix	"N-V(`chance ,)"
`chaperon	Suffix	"N-V(`chaperon ,)"
`chaperone	Suffix	"N-V(`chaperone ,)"
`charm	Suffix	"N-V(`charm ,)"
`chart	Suffix	"N-V(`chart ,)"
`charter	Suffix	"N-V(`charter ,)"
`cheer	Suffix	"N-V(`cheer ,)"
`chill	Suffix	"N-V(`chill ,)"
`chip	Suffix	"N-V(`chip ,)"
`chisel	Suffix	"N-V(`chisel ,)"
`chronicle	Suffix	"N-V(`chronicle ,)"
`cinch	Suffix	"N-V(`cinch ,)"
`cinder	Suffix	"N-V(`cinder ,)"
`cipher	Suffix	"N-V(`cipher ,)"
`circle	Suffix	"N-V(`circle ,)"
`clamp	Suffix	"N-V(`clamp ,rev)"
`clasp	Suffix	"N-V(`clasp ,rev)"
`class	Suffix	"N-V(`class ,)"
`claw	Suffix	"N-V(`claw ,)"
`climax	Suffix	"N-V(`climax ,)"
`cloak	Suffix	"N-V(`cloak ,rev)"
`clog	Suffix	"N-V(`clog ,rev)"
`cloister	Suffix	"N-V(`cloister ,)"
`clone	Suffix	"N-V(`clone ,)"
`clot	Suffix	"N-V(`clot ,)"
`cloud	Suffix	"N-V(`cloud ,)"
`clown	Suffix	"N-V(`clown ,)"
`club	Suffix	"N-V(`club ,)"
`clump	Suffix	"N-V(`clump ,)"
`cluster	Suffix	"N-V(`cluster ,)"
`clutter	Suffix	"N-V(`clutter ,rev)"
`coat	Suffix	"N-V(`coat ,)"
`code	Suffix	"N-V(`code ,)"
`coffin	Suffix	"N-V(`coffin ,rev)"
`coil	Suffix	"N-V(`coil ,rev)"
`coin	Suffix	"N-V(`coin ,)"
`collar	Suffix	"N-V(`collar ,)"
`color	Suffix	"N-V(`color ,)"
`colour	Suffix	"N-V(`colour - British,)"
`comfort	Suffix	"N-V(`comfort ,)"
`comment	Suffix	"N-V(`comment ,)"
com`mission	Suffix	"N-V(com`mit ,deverb)"
`complement	Suffix	"N-V(`complement ,)"
`compliment	Suffix	"N-V(`compliment ,)"
`compost	Suffix	"N-V(`compost ,)"
con`cern	Suffix	"N-V(con`cern ,)"
`concrete	Suffix	"N-V(`concrete ,)"
con`dition	Suffix	"N-V(con`dition ,)"
con`federate	Suffix	"N-V(con`federate ,)"
`contact	Suffix	"N-V(`contact ,)"
con`venience	Suffix	"N-V(con`venient ,deadj)"
`copyright	Suffix	"N-V(`copyright ,)"
`cordon	Suffix	"N-V(`cordon ,)"
`cork	Suffix	"N-V(`cork ,rev)"
`corner	Suffix	"N-V(`corner ,)"
cor`ral	Suffix	"N-V(cor`ral ,)"
`corset	Suffix	"N-V(`corset ,rev)"
`cost	Suffix	"N-V(`cost ,ajr13)"
`costume	Suffix	"N-V(`costume ,)"
`counsel	Suffix	"N-V(`counsel ,)"
`cradle	Suffix	"N-V(`cradle ,)"
`crank	Suffix	"N-V(`crank ,)"
`crap	Suffix	"N-V(`crap ,)"
`crape	Suffix	"N-V(`crape ,)"
`crate	Suffix	"N-V(`crate ,rev)"
`crater	Suffix	"N-V(`crater ,)"
`cream	Suffix	"N-V(`cream ,)"
`crease	Suffix	"N-V(`crease ,)"
`credit	Suffix	"N-V(`credit ,)"
`crest	Suffix	"N-V(`crest ,)"
`cripple	Suffix	"N-V(`cripple ,)"
cri`tique	Suffix	"N-V(cri`tique ,)"
cro`quet	Suffix	"N-V(cro`quet ,)"
`cross	Suffix	"N-V(`cross ,)"
`crowd	Suffix	"N-V(`crowd ,)"
`crown	Suffix	"N-V(`crown ,rev)"
cru`sade	Suffix	"N-V(cru`sade ,)"
`cube	Suffix	"N-V(`cube ,)"
`cue	Suffix	"N-V(`cue ,)"
`cure	Suffix	"N-V(`cure ,)"
`curtain	Suffix	"N-V(`curtain ,)"
`curtsey	Suffix	"N-V(`curtsey ,)"
`curve	Suffix	"N-V(`curve ,)"
`cushion	Suffix	"N-V(`cushion ,)"
`cycle	Suffix	"N-V(`cycle - see verb.lex for verb forms,)"
`dab	Suffix	"N-V(`dab ,)"
`dam	Suffix	"N-V(`dam ,)"
`dart	Suffix	"N-V(`dart ,)"
`date	Suffix	"N-V(`date ,)"
`dawn	Suffix	"N-V(`dawn ,)"
`daydream	Suffix	"N-V(`daydream ,)"
`decoy	Suffix	"N-V(`decoy ,)"
de`cree	Suffix	"N-V(de`cree ,)"
`deed	Suffix	"N-V(`deed ,)"
de`fault	Suffix	"N-V(de`fault ,)"
`deluge	Suffix	"N-V(`deluge ,)"
de`mise	Suffix	"N-V(de`mise ,)"
`dent	Suffix	"N-V(`dent ,~ajr17 ~nr22)"
`detour	Suffix	"N-V(`detour ,)"
`diagram	Suffix	"N-V(`diagram ,)"
`dial	Suffix	"N-V(`dial ,)"
`dialog	Suffix	"N-V(`dialog ,)"
`dialogue	Suffix	"N-V(`dialogue ,)"
`diaper	Suffix	"N-V(`diaper ,)"
`dibble	Suffix	"N-V(`dibble ,)"
`diet	Suffix	"N-V(`diet ,)"
`dimple	Suffix	"N-V(`dimple ,)"
`ding	Suffix	"N-V(`ding ,)"
dis`ciple	Suffix	"N-V(dis`ciple ,)"
`discipline	Suffix	"N-V(`discipline ,)"
`discord	Suffix	"N-V(`discord ,)"
`discount	Suffix	"N-V(`discount ,ss)"
`discourse	Suffix	"N-V(`discourse ,ss)"
dis`dain	Suffix	"N-V(dis`dain ,)"
`dish	Suffix	"N-V(`dish ,)"
`distance	Suffix	"N-V(`distant ,deadj)"
dis`tress	Suffix	"N-V(dis`tress ,)"
`ditch	Suffix	"N-V(`ditch ,)"
`ditto	Suffix	"N-V(`ditto ,)"
`dock	Suffix	"N-V(`dock - pier,rev)"
`doctor	Suffix	"N-V(`doctor ,)"
`document	Suffix	"N-V(`document ,)"
`dog	Suffix	"N-V(`dog ,)"
`doom	Suffix	"N-V(`doom ,)"
`dope	Suffix	"N-V(`dope - drugs,)"
`dose	Suffix	"N-V(`dose ,)"
`dot	Suffix	"N-V(`dot ,)"
`dovetail	Suffix	"N-V(`dovetail ,)"
dra`goon	Suffix	"N-V(dra`goon ,)"
`drape	Suffix	"N-V(`drape ,rev)"
`drizzle	Suffix	"N-V(`drizzle ,)"
`drug	Suffix	"N-V(`drug ,)"
`drum	Suffix	"N-V(`drum ,)"
`dust	Suffix	"N-V(`dust ,)"
`dye	Suffix	"N-V(`dye ,)"
`dynamite	Suffix	"N-V(`dynamite ,)"
`earmark	Suffix	"N-V(`earmark ,)"
`ease	Suffix	"N-V(`ease ,)"
`eddy	Suffix	"N-V(`eddy ,)"
`edge	Suffix	"N-V(`edge ,)"
`elbow	Suffix	"N-V(`elbow ,)"
`e-mail	Suffix	"N-V(`e-mail ,)"
`email	Suffix	"N-V(`email ,)"
em`cee	Suffix	"N-V(em`cee ,)"
e`namel	Suffix	"N-V(e`namel ,)"
`end	Suffix	"N-V(`end ,)"
es`cheat	Suffix	"N-V(es`cheat ,)"
ex`ample	Suffix	"N-V(ex`ample ,)"
`excerpt	Suffix	"N-V(`excerpt ,)"
`eye	Suffix	"N-V(`eye ,ajr8)"
`face	Suffix	"N-V(`face ,)"
`factor	Suffix	"N-V(`factor ,)"
`farm	Suffix	"N-V(`farm ,)"
`fashion	Suffix	"N-V(`fashion ,)"
`father	Suffix	"N-V(`father ,)"
fa`tigue	Suffix	"N-V(fa`tigue ,)"
`fault	Suffix	"N-V(`fault ,)"
`fax	Suffix	"N-V(`fax ,)"
`feast	Suffix	"N-V(`feast ,)"
`feather	Suffix	"N-V(`feather ,)"
`featherbed	Suffix	"N-V(`featherbed ,)"
`feature	Suffix	"N-V(`feature ,)"
`fence	Suffix	"N-V(`fence ,)"
`ferret	Suffix	"N-V(`ferret ,)"
`ferry	Suffix	"N-V(`ferry ,)"
fes`toon	Suffix	"N-V(fes`toon ,)"
`fetter	Suffix	"N-V(`fetter ,rev)"
`feud	Suffix	"N-V(`feud ,)"
`fever	Suffix	"N-V(`fever ,)"
`fiddle	Suffix	"N-V(`fiddle ,)"
`field	Suffix	"N-V(`field ,)"
`figure	Suffix	"N-V(`figure ,)"
fil`let	Suffix	"N-V(fil`let - also `fillet,)"
`film	Suffix	"N-V(`film ,)"
`finance	Suffix	"N-V(`finance ,)"
`fine	Suffix	"N-V(`fine ,)"
fi`nesse	Suffix	"N-V(fi`nesse ,)"
`finger	Suffix	"N-V(`finger ,)"
`fink	Suffix	"N-V(`fink ,)"
`fire	Suffix	"N-V(`fire ,)"
`flake	Suffix	"N-V(`flake ,)"
`flame	Suffix	"N-V(`flame ,)"
`flank	Suffix	"N-V(`flank ,)"
`flavor	Suffix	"N-V(`flavor ,)"
`flavour	Suffix	"N-V(`flavour - British,)"
`flesh	Suffix	"N-V(`flesh ,)"
`flicker	Suffix	"N-V(`flicker ,)"
`flood	Suffix	"N-V(`flood ,)"
`floss	Suffix	"N-V(`floss ,)"
`flower	Suffix	"N-V(`flower ,)"
`foal	Suffix	"N-V(`foal ,)"
`foam	Suffix	"N-V(`foam ,)"
`fog	Suffix	"N-V(`fog ,)"
`fool	Suffix	"N-V(`fool ,)"
`forest	Suffix	"N-V(`forest ,)"
`forfeit	Suffix	"N-V(`forfeit ,)"
`fork	Suffix	"N-V(`fork ,)"
`form	Suffix	"N-V(`form ,)"
`format	Suffix	"N-V(`format ,)"
`fracture	Suffix	"N-V(`fracture ,)"
`fragment	Suffix	"N-V(`fragment ,)"
`frame	Suffix	"N-V(`frame ,)"
`franchise	Suffix	"N-V(`franchise ,)"
`freckle	Suffix	"N-V(`freckle ,)"
`freight	Suffix	"N-V(`freight ,)"
`frenzy	Suffix	"N-V(`frenzy ,)"
`fringe	Suffix	"N-V(`fringe ,)"
`frizz	Suffix	"N-V(`frizz ,)"
`frock	Suffix	"N-V(`frock ,rev)"
`front	Suffix	"N-V(`front ,)"
`frost	Suffix	"N-V(`frost ,)"
`froth	Suffix	"N-V(`froth ,)"
`fudge	Suffix	"N-V(`fudge ,)"
`fuel	Suffix	"N-V(`fuel ,)"
`function	Suffix	"N-V(`function ,)"
`fund	Suffix	"N-V(`fund ,)"
`funnel	Suffix	"N-V(`funnel ,)"
`fur	Suffix	"N-V(`fur ,)"
`furlough	Suffix	"N-V(`furlough ,)"
`furrow	Suffix	"N-V(`furrow ,)"
`gang	Suffix	"N-V(`gang ,)"
`gap	Suffix	"N-V(`gap ,)"
ga`rage	Suffix	"N-V(ga`rage ,)"
`garb	Suffix	"N-V(`garb ,)"
`garden	Suffix	"N-V(`garden ,)"
`garner	Suffix	"N-V(`garner ,)"
`garnish	Suffix	"N-V(`garnish ,)"
`garrison	Suffix	"N-V(`garrison ,)"
`gas	Suffix	"N-V(`gas ,)"
`gash	Suffix	"N-V(`gash ,)"
`gauge	Suffix	"N-V(`gauge ,)"
`gear	Suffix	"N-V(`gear ,)"
`gel	Suffix	"N-V(`gel ,)"
`gig	Suffix	"N-V(`gig ,)"
`gimbal	Suffix	"N-V(`gimbal ,)"
`girdle	Suffix	"N-V(`girdle ,)"
`glaze	Suffix	"N-V(`glaze ,)"
`glory	Suffix	"N-V(`glory ,)"
`gloss	Suffix	"N-V(`gloss ,)"
`glue	Suffix	"N-V(`glue ,rev)"
`glut	Suffix	"N-V(`glut ,)"
`goad	Suffix	"N-V(`goad ,)"
`golf	Suffix	"N-V(`golf ,)"
`gossip	Suffix	"N-V(`gossip ,)"
`grace	Suffix	"N-V(`grace ,)"
`grease	Suffix	"N-V(`grease ,)"
`gridlock	Suffix	"N-V(`gridlock ,)"
`grill	Suffix	"N-V(`grill ,)"
`grit	Suffix	"N-V(`grit ,)"
`groom	Suffix	"N-V(`groom ,)"
`groove	Suffix	"N-V(`groove ,)"
`ground	Suffix	"N-V(`ground ,)"
`group	Suffix	"N-V(`group ,)"
`grump	Suffix	"N-V(`grump ,)"
guaran`tee	Suffix	"N-V(guaran`tee ,)"
guf`faw	Suffix	"N-V(guf`faw ,)"
`gum	Suffix	"N-V(`gum ,)"
`gun	Suffix	"N-V(`gun ,)"
`gust	Suffix	"N-V(`gust ,)"
`gut	Suffix	"N-V(`gut ,)"
`hail	Suffix	"N-V(`hail ,)"
`hammer	Suffix	"N-V(`hammer ,)"
`handcuff	Suffix	"N-V(`handcuff ,)"
`handicap	Suffix	"N-V(`handicap ,)"
`harbor	Suffix	"N-V(`harbor ,)"
`harbour	Suffix	"N-V(`harbour - British,)"
`harness	Suffix	"N-V(`harness ,rev)"
har`poon	Suffix	"N-V(har`poon ,)"
`hash	Suffix	"N-V(`hash ,)"
`hazard	Suffix	"N-V(`hazard ,)"
`heap	Suffix	"N-V(`heap ,)"
`heat	Suffix	"N-V(`heat ,)"
`hedge	Suffix	"N-V(`hedge ,)"
`hem	Suffix	"N-V(`hem ,)"
`herd	Suffix	"N-V(`herd ,)"
`hiccough	Suffix	"N-V(`hiccough ,)"
`hiccup	Suffix	"N-V(`hiccup ,)"
`highlight	Suffix	"N-V(`highlight ,)"
`hinge	Suffix	"N-V(`hinge ,rev)"
`hint	Suffix	"N-V(`hint ,)"
`hoard	Suffix	"N-V(`hoard ,)"
`hog	Suffix	"N-V(`hog ,)"
`honey	Suffix	"N-V(`honey ,)"
`honeymoon	Suffix	"N-V(`honeymoon ,)"
`honor	Suffix	"N-V(`honor ,)"
`honour	Suffix	"N-V(`honour - British,)"
`hood	Suffix	"N-V(`hood ,rev)"
`hook	Suffix	"N-V(`hook ,rev)"
`host	Suffix	"N-V(`host ,)"
`hound	Suffix	"N-V(`hound ,)"
`house	Suffix	"N-V(`house ,)"
`hulk	Suffix	"N-V(`hulk ,)"
`humor	Suffix	"N-V(`humor ,)"
`humour	Suffix	"N-V(`humour - British,)"
`hunger	Suffix	"N-V(`hunger ,)"
`husband	Suffix	"N-V(`husband ,)"
`husk	Suffix	"N-V(`husk ,)"
`ice	Suffix	"N-V(`ice ,)"
`impact	Suffix	"N-V(`impact ,)"
`inch	Suffix	"N-V(`inch ,)"
`influence	Suffix	"N-V(`influence ,)"
i`nitial	Suffix	"N-V(i`nitial ,)"
`inset	Suffix	"N-V(`inset ,ss)"
`instrument	Suffix	"N-V(`instrument ,)"
`inventory	Suffix	"N-V(`inventory ,)"
`iron	Suffix	"N-V(`iron ,)"
`jail	Suffix	"N-V(`jail ,)"
`jaw	Suffix	"N-V(`jaw ,ajr8)"
`jazz	Suffix	"N-V(`jazz ,)"
`jelly	Suffix	"N-V(`jelly ,)"
`jet	Suffix	"N-V(`jet ,)"
`jig	Suffix	"N-V(`jig ,)"
`jinx	Suffix	"N-V(`jinx ,)"
`jitterbug	Suffix	"N-V(`jitterbug ,)"
`joke	Suffix	"N-V(`joke ,)"
`journey	Suffix	"N-V(`journey ,)"
`junk	Suffix	"N-V(`junk ,)"
`keel	Suffix	"N-V(`keel ,)"
`kennel	Suffix	"N-V(`kennel ,rev)"
`key	Suffix	"N-V(`key ,ajr8)"
`keyboard	Suffix	"N-V(`keyboard ,)"
`kink	Suffix	"N-V(`kink ,rev)"
`kludge	Suffix	"N-V(`kludge ,)"
`knight	Suffix	"N-V(`knight ,)"
`knot	Suffix	"N-V(`knot ,rev)"
`label	Suffix	"N-V(`label ,)"
`lace	Suffix	"N-V(`lace ,rev)"
`lacquer	Suffix	"N-V(`lacquer ,)"
`ladle	Suffix	"N-V(`ladle ,)"
`land	Suffix	"N-V(`land ,)"
`lard	Suffix	"N-V(`lard ,)"
`latch	Suffix	"N-V(`latch ,rev)"
`lathe	Suffix	"N-V(`lathe ,)"
`layer	Suffix	"N-V(`layer ,)"
`leash	Suffix	"N-V(`leash ,rev)"
`leaven	Suffix	"N-V(`leaven ,)"
`lecture	Suffix	"N-V(`lecture ,)"
`letter	Suffix	"N-V(`letter ,)"
`leverage	Suffix	"N-V(`lever ,)"
`libel	Suffix	"N-V(`libel ,)"
`licence	Suffix	"N-V(`licence ,)"
`license	Suffix	"N-V(`license ,)"
`lie	Suffix	"N-V(`lie - falsehood,)"
`light	Suffix	"N-V(`light ,)"
`line	Suffix	"N-V(`line ,)"
`list	Suffix	"N-V(`list ,)"
`litter	Suffix	"N-V(`litter ,)"
`lock	Suffix	"N-V(`lock ,rev)"
`log	Suffix	"N-V(`log ,)"
`loop	Suffix	"N-V(`loop ,)"
`loot	Suffix	"N-V(`loot ,)"
`lord	Suffix	"N-V(`lord ,)"
`lump	Suffix	"N-V(`lump ,)"
`lunch	Suffix	"N-V(`lunch ,)"
`lust	Suffix	"N-V(`lust ,)"
`luster	Suffix	"N-V(`luster ,)"
`lustre	Suffix	"N-V(`lustre ,)"
`malt	Suffix	"N-V(`malt ,)"
`manacle	Suffix	"N-V(`manacle ,)"
`mandate	Suffix	"N-V(`mandate ,)"
`manicure	Suffix	"N-V(`manicure ,)"
`map	Suffix	"N-V(`map ,)"
`mark	Suffix	"N-V(`mark ,)"
`market	Suffix	"N-V(`market ,)"
`martyr	Suffix	"N-V(`martyr ,)"
`mask	Suffix	"N-V(`mask ,rev)"
masque`rade	Suffix	"N-V(masque`rade ,)"
`mass	Suffix	"N-V(`mass ,)"
`mastermind	Suffix	"N-V(`mastermind ,)"
`mat	Suffix	"N-V(`mat ,)"
`mate	Suffix	"N-V(`mate ,)"
`menace	Suffix	"N-V(`menace ,)"
`mess	Suffix	"N-V(`mess ,)"
`mildew	Suffix	"N-V(`mildew ,)"
`milk	Suffix	"N-V(`milk ,)"
`mimeo	Suffix	"N-V(`mimeo ,)"
`mimeograph	Suffix	"N-V(`mimeograph ,)"
`mine	Suffix	"N-V(`mine ,)"
`mire	Suffix	"N-V(`mire ,)"
`mirror	Suffix	"N-V(`mirror ,)"
mis`take	Suffix	"N-V(mis`take ,)"
`mob	Suffix	"N-V(`mob ,)"
`model	Suffix	"N-V(`model ,)"
`mold	Suffix	"N-V(`mold ,)"
`monger	Suffix	"N-V(`monger ,)"
`monogram	Suffix	"N-V(`monogram ,)"
`mop	Suffix	"N-V(`mop ,)"
`morn	Suffix	"N-V(`morn ,)"
`mortgage	Suffix	"N-V(`mortgage ,)"
`mother	Suffix	"N-V(`mother ,)"
`motion	Suffix	"N-V(`motion ,)"
`mottle	Suffix	"N-V(`mottle ,)"
`mould	Suffix	"N-V(`mould - British,)"
`mouth	Suffix	"N-V(`mouth ,ajr8)"
`mulch	Suffix	"N-V(`mulch ,)"
`mushroom	Suffix	"N-V(`mushroom ,)"
`mutiny	Suffix	"N-V(`mutiny ,)"
`nail	Suffix	"N-V(`nail ,rev)"
`name	Suffix	"N-V(`name ,)"
`necropsy	Suffix	"N-V(`necropsy ,)"
`needle	Suffix	"N-V(`needle ,)"
`neighbor	Suffix	"N-V(`neighbor ,)"
`neighbour	Suffix	"N-V(`neighbour - British,)"
`nerve	Suffix	"N-V(`nerve ,rev)"
`nest	Suffix	"N-V(`nest ,)"
`net	Suffix	"N-V(`net ,)"
`nettle	Suffix	"N-V(`nettle ,)"
`network	Suffix	"N-V(`network ,)"
`nick	Suffix	"N-V(`nick ,)"
`nickname	Suffix	"N-V(`nickname ,)"
`notch	Suffix	"N-V(`notch ,)"
`number	Suffix	"N-V(`number ,)"
oc`casion	Suffix	"N-V(oc`casion ,)"
`oil	Suffix	"N-V(`oil ,)"
OK	Suffix	"N-V(OK ,)"
o`kay	Suffix	"N-V(o`kay ,)"
`ooze	Suffix	"N-V(`ooze ,)"
`orb	Suffix	"N-V(`orb ,)"
`orbit	Suffix	"N-V(`orbit ,)"
`orphan	Suffix	"N-V(`orphan ,)"
`outcrop	Suffix	"N-V(`outcrop ,)"
`outlaw	Suffix	"N-V(`outlaw ,)"
`outline	Suffix	"N-V(`outline ,)"
`outrage	Suffix	"N-V(`outrage ,)"
`package	Suffix	"N-V(`package ,)"
`pad	Suffix	"N-V(`pad ,)"
`paddle	Suffix	"N-V(`paddle ,)"
`padlock	Suffix	"N-V(`padlock ,)"
`page	Suffix	"N-V(`page ,)"
`pain	Suffix	"N-V(`pain ,)"
`paint	Suffix	"N-V(`paint ,)"
`pair	Suffix	"N-V(`pair ,)"
pa`laver	Suffix	"N-V(pa`laver ,)"
`palm	Suffix	"N-V(`palm ,)"
`palsy	Suffix	"N-V(`palsy ,)"
`pan	Suffix	"N-V(`pan ,)"
`panel	Suffix	"N-V(`panel ,)"
`panic	Suffix	"N-V(`panic ,)"
`paper	Suffix	"N-V(`paper ,)"
`parachute	Suffix	"N-V(`parachute ,)"
pa`rade	Suffix	"N-V(pa`rade ,)"
`paragraph	Suffix	"N-V(`paragraph ,)"
`parcel	Suffix	"N-V(`parcel ,)"
`parent	Suffix	"N-V(`parent ,)"
`park	Suffix	"N-V(`park ,)"
`parlay	Suffix	"N-V(`parlay ,)"
`parody	Suffix	"N-V(`parody ,)"
pa`role	Suffix	"N-V(pa`role ,)"
`parrot	Suffix	"N-V(`parrot ,)"
`part	Suffix	"N-V(`part ,ajr13)"
par`tition	Suffix	"N-V(par`tition ,)"
`partner	Suffix	"N-V(`partner ,)"
`party	Suffix	"N-V(`party ,)"
`paste	Suffix	"N-V(`paste ,)"
`patch	Suffix	"N-V(`patch ,)"
`patent	Suffix	"N-V(`patent ,)"
`pattern	Suffix	"N-V(`pattern ,)"
pa`vilion	Suffix	"N-V(pa`vilion ,)"
`paw	Suffix	"N-V(`paw ,)"
`peak	Suffix	"N-V(`peak ,)"
`pedal	Suffix	"N-V(`pedal ,)"
`peel	Suffix	"N-V(`peel ,)"
`peg	Suffix	"N-V(`peg ,rev)"
`pen	Suffix	"N-V(`pen ,)"
`pencil	Suffix	"N-V(`pencil ,)"
`pension	Suffix	"N-V(`pension ,)"
`pep	Suffix	"N-V(`pep ,)"
`pepper	Suffix	"N-V(`pepper ,)"
per`fume	Suffix	"N-V(per`fume ,ss)"
`peril	Suffix	"N-V(`peril ,)"
pe`tition	Suffix	"N-V(pe`tition ,)"
`phase	Suffix	"N-V(`phase ,)"
`phone	Suffix	"N-V(`phone ,)"
`photograph	Suffix	"N-V(`photograph ,)"
`phrase	Suffix	"N-V(`phrase ,)"
`picnic	Suffix	"N-V(`picnic ,)"
`picture	Suffix	"N-V(`picture ,)"
`piece	Suffix	"N-V(`piece ,)"
`pigeonhole	Suffix	"N-V(`pigeonhole ,)"
`pigment	Suffix	"N-V(`pigment ,)"
`pile	Suffix	"N-V(`pile ,rev)"
`pillory	Suffix	"N-V(`pillory ,)"
`pilot	Suffix	"N-V(`pilot ,)"
`pimp	Suffix	"N-V(`pimp ,)"
`pin	Suffix	"N-V(`pin ,rev)"
`ping	Suffix	"N-V(`ping ,)"
`pinion	Suffix	"N-V(`pinion ,)"
`pinpoint	Suffix	"N-V(`pinpoint ,)"
`pioneer	Suffix	"N-V(`pioneer ,)"
`pipe	Suffix	"N-V(`pipe ,)"
`pique	Suffix	"N-V(`pique ,)"
`pirate	Suffix	"N-V(`pirate ,)"
pirou`ette	Suffix	"N-V(pirou`ette ,)"
`pit	Suffix	"N-V(`pit ,)"
`pity	Suffix	"N-V(`pity ,)"
`pivot	Suffix	"N-V(`pivot ,)"
`place	Suffix	"N-V(`place ,)"
`plague	Suffix	"N-V(`plague ,)"
`plan	Suffix	"N-V(`plan ,)"
`plane	Suffix	"N-V(`plane ,)"
`plant	Suffix	"N-V(`plant ,)"
`plaster	Suffix	"N-V(`plaster ,)"
`plate	Suffix	"N-V(`plate ,)"
`pleasure	Suffix	"N-V(`please ,deverb)"
`pleat	Suffix	"N-V(`pleat ,)"
`pledge	Suffix	"N-V(`pledge ,)"
`plot	Suffix	"N-V(`plot ,)"
`plough	Suffix	"N-V(`plough ,)"
`plow	Suffix	"N-V(`plow ,)"
`plug	Suffix	"N-V(`plug ,rev)"
`plume	Suffix	"N-V(`plume ,)"
`pocket	Suffix	"N-V(`pocket ,)"
`pockmark	Suffix	"N-V(`pockmark ,)"
`point	Suffix	"N-V(`point ,)"
`poison	Suffix	"N-V(`poison ,)"
`pole	Suffix	"N-V(`pole ,)"
`polka	Suffix	"N-V(`polka ,)"
`poll	Suffix	"N-V(`poll ,)"
`pool	Suffix	"N-V(`pool ,)"
po`sition	Suffix	"N-V(po`sition ,)"
`posture	Suffix	"N-V(`posture ,)"
`pot	Suffix	"N-V(`pot ,)"
`powder	Suffix	"N-V(`powder ,)"
`power	Suffix	"N-V(`power ,)"
`predicate	Suffix	"N-V(`predicate ,)"
`preface	Suffix	"N-V(`preface ,)"
`prejudice	Suffix	"N-V(`prejudice ,)"
pre`miere	Suffix	"N-V(pre`miere ,)"
`premise	Suffix	"N-V(`premise ,)"
`pressure	Suffix	"N-V(`press ,deverb)"
`prey	Suffix	"N-V(`prey ,)"
`price	Suffix	"N-V(`price ,)"
`prickle	Suffix	"N-V(`prickle ,)"
`pride	Suffix	"N-V(`pride ,)"
`privilege	Suffix	"N-V(`privilege ,)"
`prize	Suffix	"N-V(`prize ,)"
`probate	Suffix	"N-V(`probate ,)"
`process	Suffix	"N-V(`process ,)"
`proctor	Suffix	"N-V(`proctor ,)"
`profile	Suffix	"N-V(`profile ,)"
`profit	Suffix	"N-V(`profit ,)"
`program	Suffix	"N-V(`program ,)"
`programme	Suffix	"N-V(`programme - British,)"
`promenade	Suffix	"N-V(`promenade ,)"
`promise	Suffix	"N-V(`promise ,)"
pro`portion	Suffix	"N-V(pro`portion ,)"
`prostitute	Suffix	"N-V(`prostitute ,)"
`protest	Suffix	"N-V(`protest ,ss)"
pro`vision	Suffix	"N-V(pro`vide ,deverb)"
`pun	Suffix	"N-V(`pun ,)"
`purpose	Suffix	"N-V(`purpose ,)"
`putt	Suffix	"N-V(`putt ,)"
`putty	Suffix	"N-V(`putty ,)"
`puzzle	Suffix	"N-V(`puzzle ,)"
`quarantine	Suffix	"N-V(`quarantine ,)"
`quarry	Suffix	"N-V(`quarry ,)"
`quarter	Suffix	"N-V(`quarter ,)"
`query	Suffix	"N-V(`query ,)"
`quest	Suffix	"N-V(`quest ,)"
`question	Suffix	"N-V(`question ,)"
`queue	Suffix	"N-V(`queue - see verb.lex for verb forms,)"
`quilt	Suffix	"N-V(`quilt ,)"
`quip	Suffix	"N-V(`quip ,)"
`race	Suffix	"N-V(`race ,)"
`radio	Suffix	"N-V(`radio ,)"
`raffle	Suffix	"N-V(`raffle ,)"
`raft	Suffix	"N-V(`raft ,)"
`rage	Suffix	"N-V(`rage ,)"
`raid	Suffix	"N-V(`raid ,)"
`railroad	Suffix	"N-V(`railroad ,)"
`rain	Suffix	"N-V(`rain ,)"
`rake	Suffix	"N-V(`rake ,)"
`rampage	Suffix	"N-V(`rampage ,)"
`ranch	Suffix	"N-V(`ranch ,)"
`range	Suffix	"N-V(`range ,)"
`ransom	Suffix	"N-V(`ransom ,)"
`rapture	Suffix	"N-V(`rapture ,)"
`ratchet	Suffix	"N-V(`ratchet ,)"
`ration	Suffix	"N-V(`ration ,)"
`reason	Suffix	"N-V(`reason ,)"
re`ceipt	Suffix	"N-V(re`ceipt ,)"
`reel	Suffix	"N-V(`reel ,rev)"
`reference	Suffix	"N-V(re`fer ,deverb)"
`refuge	Suffix	"N-V(`refuge ,)"
`regiment	Suffix	"N-V(`regiment ,)"
`register	Suffix	"N-V(`register ,)"
`rein	Suffix	"N-V(`rein ,)"
`remedy	Suffix	"N-V(`remedy ,)"
re`nown	Suffix	"N-V(re`nown ,)"
re`port	Suffix	"N-V(re`port ,)"
requi`sition	Suffix	"N-V(requi`sition ,)"
`riddle	Suffix	"N-V(`riddle ,rev)"
`rig	Suffix	"N-V(`rig ,rev)"
`rim	Suffix	"N-V(`rim ,)"
`ring	Suffix	"N-V(`ring ,)"
`riot	Suffix	"N-V(`riot ,)"
`risk	Suffix	"N-V(`risk ,)"
`rival	Suffix	"N-V(`rival ,)"
`rivet	Suffix	"N-V(`rivet ,)"
`robe	Suffix	"N-V(`robe ,)"
`rocket	Suffix	"N-V(`rocket ,)"
`romance	Suffix	"N-V(`romance ,)"
`roof	Suffix	"N-V(`roof ,rev)"
`room	Suffix	"N-V(`room ,)"
`root	Suffix	"N-V(`root ,)"
`rope	Suffix	"N-V(`rope ,)"
`rumor	Suffix	"N-V(`rumor ,)"
`rumour	Suffix	"N-V(`rumour - British,)"
`rust	Suffix	"N-V(`rust ,)"
`rut	Suffix	"N-V(`rut ,)"
`saber	Suffix	"N-V(`saber ,)"
`sabre	Suffix	"N-V(`sabre ,)"
`sabotage	Suffix	"N-V(`sabotage ,)"
`sacrifice	Suffix	"N-V(`sacrifice ,)"
`saddle	Suffix	"N-V(`saddle ,rev)"
sa`fari	Suffix	"N-V(sa`fari ,)"
`safeguard	Suffix	"N-V(`safeguard ,)"
`saint	Suffix	"N-V(`saint ,)"
`sally	Suffix	"N-V(`sally ,)"
`salt	Suffix	"N-V(`salt ,)"
`salve	Suffix	"N-V(`salve ,)"
`sample	Suffix	"N-V(`sample ,)"
`sanction	Suffix	"N-V(`sanction ,)"
`sandbag	Suffix	"N-V(`sandbag ,)"
`sandblast	Suffix	"N-V(`sandblast ,)"
`sandwich	Suffix	"N-V(`sandwich ,)"
`savor	Suffix	"N-V(`savor ,)"
`savour	Suffix	"N-V(`savour ,)"
`saw	Suffix	"N-V(`saw ,)"
`scallop	Suffix	"N-V(`scallop ,)"
`scalp	Suffix	"N-V(`scalp ,)"
`scar	Suffix	"N-V(`scar ,)"
`scent	Suffix	"N-V(`scent ,)"
`scepter	Suffix	"N-V(`scepter ,)"
`sceptre	Suffix	"N-V(`sceptre - British,)"
`schedule	Suffix	"N-V(`schedule ,)"
`scheme	Suffix	"N-V(`scheme ,)"
`school	Suffix	"N-V(`school ,)"
`scoop	Suffix	"N-V(`scoop ,)"
`score	Suffix	"N-V(`score ,)"
`scorn	Suffix	"N-V(`scorn ,)"
`scourge	Suffix	"N-V(`scourge ,)"
`scrap	Suffix	"N-V(`scrap ,)"
`screen	Suffix	"N-V(`screen ,)"
`screw	Suffix	"N-V(`screw ,rev)"
`scrimmage	Suffix	"N-V(`scrimmage ,)"
`script	Suffix	"N-V(`script ,)"
`scroll	Suffix	"N-V(`scroll ,)"
`scull	Suffix	"N-V(`scull ,)"
`sculpture	Suffix	"N-V(`sculpture ,)"
`seam	Suffix	"N-V(`seam ,rev)"
`seat	Suffix	"N-V(`seat ,rev)"
`section	Suffix	"N-V(`section ,)"
`sediment	Suffix	"N-V(`sediment ,)"
`seed	Suffix	"N-V(`seed ,)"
`sense	Suffix	"N-V(`sense ,)"
`sentence	Suffix	"N-V(`sentence ,)"
`sequence	Suffix	"N-V(`sequence ,)"
sere`nade	Suffix	"N-V(sere`nade ,)"
`service	Suffix	"N-V(`service ,)"
`sex	Suffix	"N-V(`sex ,)"
`shackle	Suffix	"N-V(`shackle ,rev)"
`shade	Suffix	"N-V(`shade ,)"
`shadow	Suffix	"N-V(`shadow ,)"
`shame	Suffix	"N-V(`shame ,)"
sham`poo	Suffix	"N-V(sham`poo ,)"
`shank	Suffix	"N-V(`shank ,)"
`shape	Suffix	"N-V(`shape ,)"
`share	Suffix	"N-V(`share ,)"
`shell	Suffix	"N-V(`shell ,)"
shel`lac	Suffix	"N-V(shel`lac - see verb.lex for verb forms,)"
`shelter	Suffix	"N-V(`shelter ,)"
`shepherd	Suffix	"N-V(`shepherd ,)"
`shield	Suffix	"N-V(`shield ,)"
`shingle	Suffix	"N-V(`shingle ,)"
`ship	Suffix	"N-V(`ship ,rev)"
`shipwreck	Suffix	"N-V(`shipwreck ,)"
`shock	Suffix	"N-V(`shock ,)"
`shoe	Suffix	"N-V(`shoe ,)"
`shop	Suffix	"N-V(`shop ,)"
`shoulder	Suffix	"N-V(`shoulder ,)"
`shovel	Suffix	"N-V(`shovel ,)"
`shower	Suffix	"N-V(`shower ,)"
`shroud	Suffix	"N-V(`shroud ,)"
`shutter	Suffix	"N-V(`shutter ,)"
`shuttle	Suffix	"N-V(`shuttle ,)"
`side	Suffix	"N-V(`side ,)"
`sidetrack	Suffix	"N-V(`sidetrack ,)"
`sieve	Suffix	"N-V(`sieve ,)"
`sight	Suffix	"N-V(`sight ,ajr8)"
`sign	Suffix	"N-V(`sign ,)"
`signal	Suffix	"N-V(`signal ,)"
`silence	Suffix	"N-V(`silent ,deadj)"
silhou`ette	Suffix	"N-V(silhou`ette ,)"
`silt	Suffix	"N-V(`silt ,)"
`silver	Suffix	"N-V(`silver ,)"
`sin	Suffix	"N-V(`sin ,)"
`sinter	Suffix	"N-V(`sinter ,)"
`siphon	Suffix	"N-V(`siphon ,)"
`sire	Suffix	"N-V(`sire ,)"
`size	Suffix	"N-V(`size ,)"
`skate	Suffix	"N-V(`skate ,)"
`sketch	Suffix	"N-V(`sketch ,)"
`skewer	Suffix	"N-V(`skewer ,)"
`ski	Suffix	"N-V(`ski ,)"
`skin	Suffix	"N-V(`skin ,)"
`skirmish	Suffix	"N-V(`skirmish ,)"
`skirt	Suffix	"N-V(`skirt ,)"
`skyrocket	Suffix	"N-V(`skyrocket ,)"
`slander	Suffix	"N-V(`slander ,)"
`slant	Suffix	"N-V(`slant ,)"
`slave	Suffix	"N-V(`slave ,)"
`sleet	Suffix	"N-V(`sleet ,)"
`sleuth	Suffix	"N-V(`sleuth ,)"
`slope	Suffix	"N-V(`slope ,)"
`smoke	Suffix	"N-V(`smoke ,)"
`smudge	Suffix	"N-V(`smudge ,)"
`snack	Suffix	"N-V(`snack ,)"
`snag	Suffix	"N-V(`snag ,)"
`snake	Suffix	"N-V(`snake ,)"
`snare	Suffix	"N-V(`snare ,)"
`snow	Suffix	"N-V(`snow ,)"
`soap	Suffix	"N-V(`soap ,)"
`soil	Suffix	"N-V(`soil ,)"
`sojourn	Suffix	"N-V(`sojourn ,)"
`solder	Suffix	"N-V(`solder ,)"
`sole	Suffix	"N-V(`sole ,)"
`solo	Suffix	"N-V(`solo ,)"
`somersault	Suffix	"N-V(`somersault ,)"
`sorrow	Suffix	"N-V(`sorrow ,)"
`sort	Suffix	"N-V(`sort ,)"
`sound	Suffix	"N-V(`sound ,)"
`space	Suffix	"N-V(`space ,)"
`spade	Suffix	"N-V(`spade ,)"
`span	Suffix	"N-V(`span ,)"
`spangle	Suffix	"N-V(`spangle ,)"
`spark	Suffix	"N-V(`spark ,)"
`spear	Suffix	"N-V(`spear ,)"
`speck	Suffix	"N-V(`speck ,)"
`speckle	Suffix	"N-V(`speckle ,)"
`speed	Suffix	"N-V(`speed ,)"
`spell	Suffix	"N-V(`spell ,)"
`spice	Suffix	"N-V(`spice ,)"
`spindle	Suffix	"N-V(`spindle ,)"
`spirit	Suffix	"N-V(`spirit ,ajr8)"
`splint	Suffix	"N-V(`splint ,)"
`splinter	Suffix	"N-V(`splinter ,)"
`splurge	Suffix	"N-V(`splurge ,)"
`sponge	Suffix	"N-V(`sponge ,)"
`sponsor	Suffix	"N-V(`sponsor ,)"
`spook	Suffix	"N-V(`spook ,)"
`spool	Suffix	"N-V(`spool ,)"
`spoon	Suffix	"N-V(`spoon ,)"
`spotlight	Suffix	"N-V(`spotlight ,)"
`spout	Suffix	"N-V(`spout ,)"
`sprain	Suffix	"N-V(`sprain ,)"
`spray	Suffix	"N-V(`spray ,)"
`spur	Suffix	"N-V(`spur ,)"
`squabble	Suffix	"N-V(`squabble ,)"
`squeegee	Suffix	"N-V(`squeegee ,)"
`squirrel	Suffix	"N-V(`squirrel ,)"
`stack	Suffix	"N-V(`stack ,)"
`stage	Suffix	"N-V(`stage ,)"
`stake	Suffix	"N-V(`stake ,)"
`stalemate	Suffix	"N-V(`stalemate ,)"
stam`pede	Suffix	"N-V(stam`pede ,)"
`staple	Suffix	"N-V(`staple ,)"
`star	Suffix	"N-V(`star ,)"
`starch	Suffix	"N-V(`starch ,)"
`station	Suffix	"N-V(`station ,)"
`steam	Suffix	"N-V(`steam ,)"
`steel	Suffix	"N-V(`steel ,)"
`stencil	Suffix	"N-V(`stencil ,)"
`step	Suffix	"N-V(`step ,)"
`stereotype	Suffix	"N-V(`stereotype ,)"
`stew	Suffix	"N-V(`stew ,)"
`stitch	Suffix	"N-V(`stitch ,)"
`stock	Suffix	"N-V(`stock ,)"
`stockpile	Suffix	"N-V(`stockpile ,)"
`stomach	Suffix	"N-V(`stomach ,)"
`stone	Suffix	"N-V(`stone ,)"
`storm	Suffix	"N-V(`storm ,)"
`strain	Suffix	"N-V(`strain ,)"
`strap	Suffix	"N-V(`strap ,rev)"
`streak	Suffix	"N-V(`streak ,)"
`stream	Suffix	"N-V(`stream ,)"
`streamline	Suffix	"N-V(`streamline ,)"
`stress	Suffix	"N-V(`stress ,rev)"
`strip	Suffix	"N-V(`strip ,)"
`stripe	Suffix	"N-V(`stripe ,)"
`stroke	Suffix	"N-V(`stroke ,)"
`structure	Suffix	"N-V(`structure ,)"
`style	Suffix	"N-V(`style - see verb.lex for verb forms,)"
sub`poena	Suffix	"N-V(sub`poena ,)"
`succor	Suffix	"N-V(`succor ,)"
`succour	Suffix	"N-V(`succour - British,)"
`suede	Suffix	"N-V(`suede ,)"
`suffix	Suffix	"N-V(`suffix ,)"
`sugar	Suffix	"N-V(`sugar ,)"
`sum	Suffix	"N-V(`sum ,)"
`sun	Suffix	"N-V(`sun ,)"
`sunburn	Suffix	"N-V(`sunburn ,)"
`supplement	Suffix	"N-V(`supplement ,)"
`surf	Suffix	"N-V(`surf ,)"
`surface	Suffix	"N-V(`surface ,)"
`surname	Suffix	"N-V(`name ,)"
`suture	Suffix	"N-V(`suture ,)"
`swab	Suffix	"N-V(`swab ,)"
`swamp	Suffix	"N-V(`swamp ,)"
`swirl	Suffix	"N-V(`swirl ,)"
`switch	Suffix	"N-V(`switch ,)"
`swivel	Suffix	"N-V(`swivel ,)"
`table	Suffix	"N-V(`table ,)"
`tack	Suffix	"N-V(`tack ,)"
`tag	Suffix	"N-V(`tag ,)"
`tailgate	Suffix	"N-V(`tailgate ,)"
`tailor	Suffix	"N-V(`tailor ,)"
`tally	Suffix	"N-V(`tally ,)"
`tango	Suffix	"N-V(`tango ,)"
`tap	Suffix	"N-V(`tap - spigot,)"
`tape	Suffix	"N-V(`tape ,)"
`tar	Suffix	"N-V(`tar ,)"
`target	Suffix	"N-V(`target ,)"
`tassel	Suffix	"N-V(`tassel ,)"
tat`too	Suffix	"N-V(tat`too ,)"
`taxi	Suffix	"N-V(`taxi ,)"
`team	Suffix	"N-V(`team ,)"
`tear	Suffix	"N-V(`tear - [tir], [tEr],)"
`tee	Suffix	"N-V(`tee ,)"
`telegraph	Suffix	"N-V(`telegraph ,)"
`telephone	Suffix	"N-V(`telephone ,)"
`telescope	Suffix	"N-V(`telescope ,)"
`telex	Suffix	"N-V(`telex ,)"
`tender	Suffix	"N-V(`tender ,)"
`tent	Suffix	"N-V(`tent ,)"
`term	Suffix	"N-V(`term ,)"
`test	Suffix	"N-V(`test ,)"
`tether	Suffix	"N-V(`tether ,rev)"
`texture	Suffix	"N-V(`texture ,)"
`thatch	Suffix	"N-V(`thatch ,)"
`thirst	Suffix	"N-V(`thirst ,)"
`thread	Suffix	"N-V(`thread ,rev)"
`thrill	Suffix	"N-V(`thrill ,)"
`throne	Suffix	"N-V(`throne ,rev)"
`throng	Suffix	"N-V(`throng ,)"
`thrum	Suffix	"N-V(`thrum ,)"
`thumb	Suffix	"N-V(`thumb ,)"
`thunder	Suffix	"N-V(`thunder ,)"
`ticket	Suffix	"N-V(`ticket ,)"
`tile	Suffix	"N-V(`tile ,)"
`time	Suffix	"N-V(`time ,)"
`tincture	Suffix	"N-V(`tincture ,)"
`tint	Suffix	"N-V(`tint ,)"
`tip	Suffix	"N-V(`tip ,)"
`tiptoe	Suffix	"N-V(`tiptoe ,)"
`title	Suffix	"N-V(`title ,)"
`tone	Suffix	"N-V(`tone ,)"
`tongue	Suffix	"N-V(`tongue ,)"
`tool	Suffix	"N-V(`tool ,)"
`torch	Suffix	"N-V(`torch ,)"
`total	Suffix	"N-V(`total ,)"
`tour	Suffix	"N-V(`tour ,)"
`towel	Suffix	"N-V(`towel ,)"
`tower	Suffix	"N-V(`tower ,)"
`toy	Suffix	"N-V(`toy ,)"
`track	Suffix	"N-V(`track ,)"
`traffic	Suffix	"N-V(`traffic ,)"
`trammel	Suffix	"N-V(`trammel ,)"
`trance	Suffix	"N-V(`trance ,)"
`transit	Suffix	"N-V(`transit ,)"
`trap	Suffix	"N-V(`trap ,)"
`trash	Suffix	"N-V(`trash ,)"
tra`vail	Suffix	"N-V(tra`vail ,)"
`treadle	Suffix	"N-V(`treadle ,)"
`treasure	Suffix	"N-V(`treasure ,)"
`trellis	Suffix	"N-V(`trellis ,)"
`trick	Suffix	"N-V(`trick ,)"
`trigger	Suffix	"N-V(`trigger ,)"
`triumph	Suffix	"N-V(`triumph ,)"
`troop	Suffix	"N-V(`troop ,)"
`trouble	Suffix	"N-V(`trouble ,)"
`truck	Suffix	"N-V(`truck ,)"
`trump	Suffix	"N-V(`trump ,)"
`trumpet	Suffix	"N-V(`trumpet ,)"
`trundle	Suffix	"N-V(`trundle ,)"
`trust	Suffix	"N-V(`trust ,)"
`tuck	Suffix	"N-V(`tuck ,)"
`tuft	Suffix	"N-V(`tuft ,)"
`tunnel	Suffix	"N-V(`tunnel ,)"
`tussle	Suffix	"N-V(`tussle ,)"
`tutor	Suffix	"N-V(`tutor ,)"
`twine	Suffix	"N-V(`twine ,rev)"
`umpire	Suffix	"N-V(`umpire ,)"
va`cation	Suffix	"N-V(va`cation ,)"
`vacuum	Suffix	"N-V(`vacuum ,)"
`valet	Suffix	"N-V(`valet ,)"
`value	Suffix	"N-V(`value ,)"
`vamp	Suffix	"N-V(`vamp ,)"
`vapor	Suffix	"N-V(`vapor ,)"
`vapour	Suffix	"N-V(`vapour - British,)"
`varnish	Suffix	"N-V(`varnish ,)"
`vector	Suffix	"N-V(`vector ,)"
`veil	Suffix	"N-V(`veil ,rev)"
ve`neer	Suffix	"N-V(ve`neer ,)"
`vesture	Suffix	"N-V(`vesture ,)"
`vet	Suffix	"N-V(`vet ,)"
`victual	Suffix	"N-V(`victual ,)"
`videotape	Suffix	"N-V(`videotape ,)"
`view	Suffix	"N-V(`view ,)"
vig`nette	Suffix	"N-V(vig`nette ,)"
`voice	Suffix	"N-V(`voice ,rev)"
`volley	Suffix	"N-V(`volley ,)"
volun`teer	Suffix	"N-V(volun`teer ,)"
`vote	Suffix	"N-V(`vote ,)"
`vow	Suffix	"N-V(`vow ,)"
`voyage	Suffix	"N-V(`voyage ,)"
`wad	Suffix	"N-V(`wad ,)"
`wager	Suffix	"N-V(`wager ,)"
`wainscot	Suffix	"N-V(`wainscot ,)"
`wall	Suffix	"N-V(`wall ,)"
`wallpaper	Suffix	"N-V(`wallpaper ,)"
`waltz	Suffix	"N-V(`waltz ,)"
`war	Suffix	"N-V(`war ,)"
`warehouse	Suffix	"N-V(`warehouse ,)"
`warrant	Suffix	"N-V(`warrant ,)"
`wassail	Suffix	"N-V(`wassail ,)"
`water	Suffix	"N-V(`water ,)"
`wattle	Suffix	"N-V(`wattle ,)"
`wax	Suffix	"N-V(`wax ,)"
`weather	Suffix	"N-V(`weather ,)"
`web	Suffix	"N-V(`web ,)"
`wedge	Suffix	"N-V(`wedge ,)"
`weed	Suffix	"N-V(`weed ,)"
`weight	Suffix	"N-V(`weight ,rev)"
`welt	Suffix	"N-V(`welt ,)"
`whale	Suffix	"N-V(`whale ,)"
`wheel	Suffix	"N-V(`wheel ,)"
`whip	Suffix	"N-V(`whip ,)"
`whisk	Suffix	"N-V(`whisk ,)"
`wholesale	Suffix	"N-V(`wholesale ,)"
`whoosh	Suffix	"N-V(`whoosh ,)"
`whore	Suffix	"N-V(`whore ,)"
`widow	Suffix	"N-V(`widow ,)"
`will	Suffix	"N-V(`will ,)"
`winch	Suffix	"N-V(`winch ,)"
`wing	Suffix	"N-V(`wing ,)"
`winter	Suffix	"N-V(`winter ,)"
`wire	Suffix	"N-V(`wire ,)"
`wiretap	Suffix	"N-V(`wiretap ,)"
`wisecrack	Suffix	"N-V(`wisecrack ,)"
`witness	Suffix	"N-V(`witness ,)"
`woof	Suffix	"N-V(`woof ,)"
`word	Suffix	"N-V(`word ,)"
`worm	Suffix	"N-V(`worm ,)"
`worship	Suffix	"N-V(`worship ,)"
`wound	Suffix	"N-V(`wound ,)"
`wrinkle	Suffix	"N-V(`wrinkle ,)"
`x-ray	Suffix	"N-V(`x-ray ,)"
`yacht	Suffix	"N-V(`yacht ,)"
`yarn	Suffix	"N-V(`yarn ,)"
`yawl	Suffix	"N-V(`yawl ,)"
`yelp	Suffix	"N-V(`yelp ,)"
`yoke	Suffix	"N-V(`yoke ,rev)"
`zag	Suffix	"N-V(`zag ,)"
`zig	Suffix	"N-V(`zig ,)"
`zigzag	Suffix	"N-V(`zigzag ,)"
`zone	Suffix	"N-V(`zone ,)"
`flocculate	Suffix	"N-V(`flocculate ,)"
`hydrate	Suffix	"N-V(`hydrate ,)"
`bend	Suffix	"N-V(`bend ,rev)"
`broadcast	Suffix	"N-V(`broadcast ,)"
`burn	Suffix	"N-V(`burn ,)"
`cast	Suffix	"N-V(`cast ,)"
`dare	Suffix	"N-V(`dare ,)"
`deal	Suffix	"N-V(`deal ,irreg)"
`dive	Suffix	"N-V(`dive ,)"
`dream	Suffix	"N-V(`dream ,)"
`fit	Suffix	"N-V(`fit ,)"
`leap	Suffix	"N-V(`leap ,)"
`shave	Suffix	"N-V(`shave ,)"
`shine	Suffix	"N-V(`shine ,)"
`shred	Suffix	"N-V(`shred ,)"
`smell	Suffix	"N-V(`smell ,)"
`spill	Suffix	"N-V(`spill ,)"
`spin	Suffix	"N-V(`spin ,irreg)"
`sting	Suffix	"N-V(`sting ,irreg ~deg2)"
`stink	Suffix	"N-V(`stink ,irreg)"
`weave	Suffix	"N-V(`weave ,rev)"
ac`cord	Suffix	"N-V(ac`cord ,)"
`ache	Suffix	"N-V(`ache ,)"
`act	Suffix	"N-V(`act ,)"
af`filiate	Suffix	"N-V(af`filiate ,)"
af`fright	Suffix	"N-V(af`fright ,)"
af`front	Suffix	"N-V(af`front ,)"
`aid	Suffix	"N-V(`aid ,)"
`aim	Suffix	"N-V(`aim ,)"
a`larm	Suffix	"N-V(a`larm ,)"
`alternate	Suffix	"N-V(`alternate ,)"
`ambush	Suffix	"N-V(`ambush ,)"
`answer	Suffix	"N-V(`answer ,)"
ap`proach	Suffix	"N-V(ap`proach ,)"
ar`ray	Suffix	"N-V(ar`ray ,)"
ar`rest	Suffix	"N-V(ar`rest ,)"
as`sault	Suffix	"N-V(as`sault ,)"
as`sent	Suffix	"N-V(as`sent ,)"
at`tack	Suffix	"N-V(at`tack ,)"
at`tempt	Suffix	"N-V(at`tempt ,)"
`audit	Suffix	"N-V(`audit ,)"
a`ward	Suffix	"N-V(a`ward ,)"
`backup	Suffix	"N-V(`backup ,)"
`balk	Suffix	"N-V(`balk ,)"
`ban	Suffix	"N-V(`ban ,)"
`bang	Suffix	"N-V(`bang ,)"
`banter	Suffix	"N-V(`banter ,)"
`barbecue	Suffix	"N-V(`barbecue ,)"
`bash	Suffix	"N-V(`bash ,)"
`beep	Suffix	"N-V(`beep ,)"
`belch	Suffix	"N-V(`belch ,)"
`bellow	Suffix	"N-V(`bellow ,)"
`blame	Suffix	"N-V(`blame ,)"
`bleach	Suffix	"N-V(`bleach ,)"
`blend	Suffix	"N-V(`blend ,)"
`blink	Suffix	"N-V(`blink ,)"
`bloom	Suffix	"N-V(`bloom ,)"
`bluff	Suffix	"N-V(`bluff ,)"
`blunder	Suffix	"N-V(`blunder ,)"
`blur	Suffix	"N-V(`blur ,)"
`boast	Suffix	"N-V(`boast ,)"
`boil	Suffix	"N-V(`boil ,)"
`boom	Suffix	"N-V(`boom ,)"
`boost	Suffix	"N-V(`boost ,)"
`bore	Suffix	"N-V(`bore ,)"
`bother	Suffix	"N-V(`bother ,)"
`bounce	Suffix	"N-V(`bounce ,)"
`bow	Suffix	"N-V(`bow ,)"
`boycott	Suffix	"N-V(`boycott ,)"
`braid	Suffix	"N-V(`braid ,rev)"
`brawl	Suffix	"N-V(`brawl ,)"
`brew	Suffix	"N-V(`brew ,)"
`bruise	Suffix	"N-V(`bruise ,)"
`bulge	Suffix	"N-V(`bulge ,)"
`burnish	Suffix	"N-V(`burnish ,)"
`burp	Suffix	"N-V(`burp ,)"
`butcher	Suffix	"N-V(`butcher ,)"
`buzz	Suffix	"N-V(`buzz ,)"
`bypass	Suffix	"N-V(`bypass ,)"
`cackle	Suffix	"N-V(`cackle ,)"
`call	Suffix	"N-V(`call ,)"
`caper	Suffix	"N-V(`caper ,)"
`capture	Suffix	"N-V(`capture ,)"
`care	Suffix	"N-V(`care ,~nr10)"
ca`ress	Suffix	"N-V(ca`ress ,)"
`cause	Suffix	"N-V(`cause ,)"
`challenge	Suffix	"N-V(`challenge ,)"
`change	Suffix	"N-V(`change ,)"
`chant	Suffix	"N-V(`chant ,)"
`charge	Suffix	"N-V(`charge ,)"
`chase	Suffix	"N-V(`chase ,)"
`chat	Suffix	"N-V(`chat ,)"
`chatter	Suffix	"N-V(`chatter ,)"
`check	Suffix	"N-V(`check ,)"
`checkmate	Suffix	"N-V(`checkmate ,)"
`chew	Suffix	"N-V(`chew ,)"
`chime	Suffix	"N-V(`chime ,)"
`chirp	Suffix	"N-V(`chirp ,)"
`chop	Suffix	"N-V(`chop ,)"
`chuckle	Suffix	"N-V(`chuckle ,)"
`claim	Suffix	"N-V(`claim ,)"
`clamor	Suffix	"N-V(`clamor ,)"
`clamour	Suffix	"N-V(`clamour ,)"
`clap	Suffix	"N-V(`clap ,)"
`clash	Suffix	"N-V(`clash ,)"
`clatter	Suffix	"N-V(`clatter ,)"
`click	Suffix	"N-V(`click ,)"
`clip	Suffix	"N-V(`clip ,)"
`coach	Suffix	"N-V(`coach ,)"
col`lapse	Suffix	"N-V(col`lapse ,)"
`comb	Suffix	"N-V(`comb ,)"
com`mand	Suffix	"N-V(com`mand ,)"
con`sent	Suffix	"N-V(con`sent ,)"
`coo	Suffix	"N-V(`coo ,)"
`copy	Suffix	"N-V(`copy ,)"
`cough	Suffix	"N-V(`cough ,)"
`count	Suffix	"N-V(`count ,~ajr14)"
`countermand	Suffix	"N-V(`countermand ,)"
`cover	Suffix	"N-V(`cover ,rev)"
`crack	Suffix	"N-V(`crack ,)"
`crackle	Suffix	"N-V(`crackle ,)"
`cramp	Suffix	"N-V(`cramp ,)"
`crash	Suffix	"N-V(`crash ,)"
`creak	Suffix	"N-V(`creak ,)"
`crimp	Suffix	"N-V(`crimp ,)"
`crisscross	Suffix	"N-V(`crisscross ,)"
`criss-cross	Suffix	"N-V(`criss-cross ,)"
`croak	Suffix	"N-V(`croak ,)"
`cruise	Suffix	"N-V(`cruise ,)"
`crunch	Suffix	"N-V(`crunch ,)"
`cry	Suffix	"N-V(`cry ,)"
`cuff	Suffix	"N-V(`cuff ,)"
`culture	Suffix	"N-V(`culture ,)"
`curl	Suffix	"N-V(`curl ,rev)"
`curse	Suffix	"N-V(`curse ,)"
`damage	Suffix	"N-V(`damage ,)"
`dance	Suffix	"N-V(`dance ,)"
`dash	Suffix	"N-V(`dash ,)"
`daub	Suffix	"N-V(`daub ,)"
`daze	Suffix	"N-V(`daze ,)"
de`cay	Suffix	"N-V(de`cay ,)"
de`cline	Suffix	"N-V(de`cline ,)"
de`feat	Suffix	"N-V(de`feat ,)"
de`lay	Suffix	"N-V(de`lay ,)"
de`light	Suffix	"N-V(de`light ,)"
de`mand	Suffix	"N-V(de`mand ,)"
de`posit	Suffix	"N-V(de`posit ,)"
de`sign	Suffix	"N-V(de`sign ,)"
`designate	Suffix	"N-V(`designate ,)"
de`sire	Suffix	"N-V(de`sire ,)"
de`spair	Suffix	"N-V(de`spair ,)"
`dip	Suffix	"N-V(`dip ,)"
dis`may	Suffix	"N-V(dis`may ,)"
dis`play	Suffix	"N-V(dis`play ,)"
dis`sent	Suffix	"N-V(dis`sent ,)"
`dither	Suffix	"N-V(`dither ,)"
di`vorce	Suffix	"N-V(di`vorce ,)"
`doubt	Suffix	"N-V(`doubt ,)"
`downgrade	Suffix	"N-V(`downgrade ,)"
`download	Suffix	"N-V(`download ,)"
`draft	Suffix	"N-V(`draft ,)"
`drain	Suffix	"N-V(`drain ,)"
`drawl	Suffix	"N-V(`drawl ,)"
`dread	Suffix	"N-V(`dread ,)"
`dress	Suffix	"N-V(`dress ,rev)"
`dribble	Suffix	"N-V(`dribble ,)"
`drift	Suffix	"N-V(`drift ,)"
`drill	Suffix	"N-V(`drill ,)"
`drip	Suffix	"N-V(`drip ,)"
`drool	Suffix	"N-V(`drool ,)"
`drop	Suffix	"N-V(`drop ,)"
`duel	Suffix	"N-V(`duel ,)"
`dump	Suffix	"N-V(`dump ,)"
`dunk	Suffix	"N-V(`dunk ,)"
`dupe	Suffix	"N-V(`dupe ,)"
`ebb	Suffix	"N-V(`ebb ,)"
`echo	Suffix	"N-V(`echo ,)"
ec`lipse	Suffix	"N-V(ec`lipse ,)"
ef`fect	Suffix	"N-V(ef`fect ,)"
en`counter	Suffix	"N-V(en`counter ,)"
en`deavor	Suffix	"N-V(en`deavor ,)"
en`deavour	Suffix	"N-V(en`deavour ,)"
`envy	Suffix	"N-V(`envy ,)"
es`cape	Suffix	"N-V(es`cape ,)"
es`teem	Suffix	"N-V(es`teem ,)"
`estimate	Suffix	"N-V(`estimate ,)"
ex`change	Suffix	"N-V(ex`change ,)"
ex`cuse	Suffix	"N-V(ex`cuse ,)"
`exercise	Suffix	"N-V(`exercise ,)"
ex`haust	Suffix	"N-V(ex`haust ,)"
ex`hibit	Suffix	"N-V(ex`hibit ,)"
`exile	Suffix	"N-V(`exile ,)"
`exit	Suffix	"N-V(`exit ,)"
ex`perience	Suffix	"N-V(ex`perience ,)"
ex`periment	Suffix	"N-V(ex`periment ,)"
`fake	Suffix	"N-V(`fake ,)"
`fancy	Suffix	"N-V(`fancy ,)"
`farrow	Suffix	"N-V(`farrow ,)"
`fast	Suffix	"N-V(`fast ,)"
`favor	Suffix	"N-V(`favor ,)"
`favour	Suffix	"N-V(`favour ,)"
`fear	Suffix	"N-V(`fear ,)"
`fib	Suffix	"N-V(`fib ,)"
`file	Suffix	"N-V(`file ,)"
`filibuster	Suffix	"N-V(`filibuster ,)"
`filter	Suffix	"N-V(`filter ,)"
`fix	Suffix	"N-V(`fix ,rev)"
`flare	Suffix	"N-V(`flare ,)"
`flash	Suffix	"N-V(`flash ,)"
`flirt	Suffix	"N-V(`flirt ,)"
`flop	Suffix	"N-V(`flop ,)"
`flow	Suffix	"N-V(`flow ,)"
`fold	Suffix	"N-V(`fold ,rev)"
`force	Suffix	"N-V(`force ,)"
`forge	Suffix	"N-V(`forge ,)"
`frolic	Suffix	"N-V(`frolic ,)"
`frown	Suffix	"N-V(`frown ,)"
`fumble	Suffix	"N-V(`fumble ,)"
`fuss	Suffix	"N-V(`fuss ,)"
`gain	Suffix	"N-V(`gain ,)"
`gallop	Suffix	"N-V(`gallop ,)"
`gamble	Suffix	"N-V(`gamble ,)"
`gasp	Suffix	"N-V(`gasp ,)"
`gesture	Suffix	"N-V(`gesture ,)"
`gibe	Suffix	"N-V(`gibe ,)"
`giggle	Suffix	"N-V(`giggle ,)"
`glance	Suffix	"N-V(`glance ,)"
`glare	Suffix	"N-V(`glare ,)"
`gleam	Suffix	"N-V(`gleam ,)"
`glimpse	Suffix	"N-V(`glimpse ,)"
glis`sade	Suffix	"N-V(glis`sade ,)"
`glow	Suffix	"N-V(`glow ,)"
`goof	Suffix	"N-V(`goof ,)"
`grab	Suffix	"N-V(`grab ,)"
`grade	Suffix	"N-V(`grade ,)"
`graduate	Suffix	"N-V(`graduate ,)"
`graft	Suffix	"N-V(`graft ,)"
`grant	Suffix	"N-V(`grant ,)"
`grasp	Suffix	"N-V(`grasp ,)"
`grimace	Suffix	"N-V(`grimace ,)"
`grin	Suffix	"N-V(`grin ,)"
`grip	Suffix	"N-V(`grip ,)"
`gripe	Suffix	"N-V(`gripe ,)"
`groan	Suffix	"N-V(`groan ,)"
`growl	Suffix	"N-V(`growl ,)"
`grunt	Suffix	"N-V(`grunt ,)"
`guard	Suffix	"N-V(`guard ,rev)"
`guess	Suffix	"N-V(`guess ,)"
`guide	Suffix	"N-V(`guide ,)"
`gulp	Suffix	"N-V(`gulp ,)"
`gurgle	Suffix	"N-V(`gurgle ,)"
`hack	Suffix	"N-V(`hack ,)"
`halt	Suffix	"N-V(`halt ,)"
ha`rangue	Suffix	"N-V(ha`rangue ,)"
`harm	Suffix	"N-V(`harm ,)"
`harvest	Suffix	"N-V(`harvest ,)"
`hassle	Suffix	"N-V(`hassle ,)"
`hate	Suffix	"N-V(`hate ,)"
`haul	Suffix	"N-V(`haul ,)"
`heed	Suffix	"N-V(`heed ,)"
`help	Suffix	"N-V(`help ,)"
`hemorrhage	Suffix	"N-V(`hemorrhage ,)"
`herald	Suffix	"N-V(`herald ,)"
`hex	Suffix	"N-V(`hex ,)"
`hike	Suffix	"N-V(`hike ,)"
`hiss	Suffix	"N-V(`hiss ,)"
`hitch	Suffix	"N-V(`hitch ,rev)"
`hoe	Suffix	"N-V(`hoe ,)"
`hoist	Suffix	"N-V(`hoist ,)"
`holler	Suffix	"N-V(`holler ,)"
`honk	Suffix	"N-V(`honk ,)"
`hoot	Suffix	"N-V(`hoot ,)"
`hop	Suffix	"N-V(`hop ,)"
`hope	Suffix	"N-V(`hope ,)"
`howl	Suffix	"N-V(`howl ,)"
`hug	Suffix	"N-V(`hug ,)"
`hunt	Suffix	"N-V(`hunt ,)"
`hurry	Suffix	"N-V(`hurry ,)"
`hush	Suffix	"N-V(`hush ,)"
`implement	Suffix	"N-V(`implement ,)"
`increment	Suffix	"N-V(`increment ,)"
`input	Suffix	"N-V(`input ,)"
`institute	Suffix	"N-V(`institute ,)"
`interest	Suffix	"N-V(`interest ,)"
`interview	Suffix	"N-V(`interview ,)"
`introvert	Suffix	"N-V(`introvert ,)"
`issue	Suffix	"N-V(`issue ,)"
`itch	Suffix	"N-V(`itch ,)"
`jab	Suffix	"N-V(`jab ,)"
`jam	Suffix	"N-V(`jam ,)"
`jeer	Suffix	"N-V(`jeer ,)"
`jerk	Suffix	"N-V(`jerk ,)"
`jest	Suffix	"N-V(`jest ,)"
`jibe	Suffix	"N-V(`jibe ,)"
`jiggle	Suffix	"N-V(`jiggle ,)"
`jingle	Suffix	"N-V(`jingle ,)"
`jolt	Suffix	"N-V(`jolt ,)"
`jot	Suffix	"N-V(`jot ,)"
`judge	Suffix	"N-V(`judge ,)"
`jumble	Suffix	"N-V(`jumble ,)"
`jump	Suffix	"N-V(`jump ,)"
`jumpstart	Suffix	"N-V(`jumpstart ,)"
`kick	Suffix	"N-V(`kick ,)"
`kiss	Suffix	"N-V(`kiss ,)"
`knock	Suffix	"N-V(`knock ,)"
`labor	Suffix	"N-V(`labor ,)"
`labour	Suffix	"N-V(`labour ,)"
`lack	Suffix	"N-V(`lack ,)"
`lag	Suffix	"N-V(`lag ,)"
`lam	Suffix	"N-V(`lam ,)"
la`ment	Suffix	"N-V(la`ment ,)"
`lance	Suffix	"N-V(`lance ,)"
`lapse	Suffix	"N-V(`lapse ,)"
`lash	Suffix	"N-V(`lash ,rev)"
`lather	Suffix	"N-V(`lather ,)"
`laugh	Suffix	"N-V(`laugh ,)"
`leak	Suffix	"N-V(`leak ,)"
`lease	Suffix	"N-V(`lease ,)"
`lick	Suffix	"N-V(`lick ,)"
`lift	Suffix	"N-V(`lift ,)"
`like	Suffix	"N-V(`like ,)"
`lilt	Suffix	"N-V(`lilt ,)"
`limit	Suffix	"N-V(`limit ,)"
`limp	Suffix	"N-V(`limp ,)"
`link	Suffix	"N-V(`link ,rev)"
`lisp	Suffix	"N-V(`lisp ,)"
`load	Suffix	"N-V(`load ,rev)"
`loan	Suffix	"N-V(`loan ,)"
`lodge	Suffix	"N-V(`lodge ,)"
`look	Suffix	"N-V(`look ,)"
`lounge	Suffix	"N-V(`lounge ,)"
`love	Suffix	"N-V(`love ,ajr13)"
`lunge	Suffix	"N-V(`lunge ,)"
`lurch	Suffix	"N-V(`lurch ,)"
`lure	Suffix	"N-V(`lure ,)"
`mail	Suffix	"N-V(`mail ,)"
ma`neuver	Suffix	"N-V(ma`neuver ,)"
ma`noeuvre	Suffix	"N-V(ma`noeuvre ,)"
`march	Suffix	"N-V(`march ,)"
`marvel	Suffix	"N-V(`marvel ,)"
`massacre	Suffix	"N-V(`massacre ,)"
mas`sage	Suffix	"N-V(mas`sage ,)"
`master	Suffix	"N-V(`master ,)"
`measure	Suffix	"N-V(`measure ,)"
`meld	Suffix	"N-V(`meld ,)"
`mention	Suffix	"N-V(`mention ,)"
`merit	Suffix	"N-V(`merit ,)"
`mill	Suffix	"N-V(`mill ,)"
`minister	Suffix	"N-V(`minister ,)"
`miss	Suffix	"N-V(`miss ,)"
`mix	Suffix	"N-V(`mix ,)"
`moan	Suffix	"N-V(`moan ,)"
`monitor	Suffix	"N-V(`monitor ,)"
`move	Suffix	"N-V(`move ,)"
`muddle	Suffix	"N-V(`muddle ,)"
`murder	Suffix	"N-V(`murder ,)"
`murmur	Suffix	"N-V(`murmur ,)"
`muster	Suffix	"N-V(`muster ,)"
`muzzle	Suffix	"N-V(`muzzle ,rev)"
`nap	Suffix	"N-V(`nap ,)"
`need	Suffix	"N-V(`need ,)"
ne`glect	Suffix	"N-V(ne`glect ,)"
`nip	Suffix	"N-V(`nip ,)"
`nod	Suffix	"N-V(`nod ,)"
`note	Suffix	"N-V(`note ,)"
`notice	Suffix	"N-V(`notice ,)"
`nurse	Suffix	"N-V(`nurse ,)"
`order	Suffix	"N-V(`order ,ajr13)"
`pace	Suffix	"N-V(`pace ,)"
`paraphrase	Suffix	"N-V(`paraphrase ,)"
`pardon	Suffix	"N-V(`pardon ,)"
`parley	Suffix	"N-V(`parley ,)"
`parse	Suffix	"N-V(`parse ,)"
`pass	Suffix	"N-V(`pass ,)"
`pat	Suffix	"N-V(`pat ,)"
`patter	Suffix	"N-V(`patter ,)"
pa`trol	Suffix	"N-V(pa`trol ,)"
`pause	Suffix	"N-V(`pause ,)"
`peal	Suffix	"N-V(`peal ,)"
`peck	Suffix	"N-V(`peck ,)"
`peek	Suffix	"N-V(`peek ,)"
`peep	Suffix	"N-V(`peep ,)"
`photocopy	Suffix	"N-V(`photocopy ,)"
`pickle	Suffix	"N-V(`pickle ,)"
`pinch	Suffix	"N-V(`pinch ,)"
`piss	Suffix	"N-V(`piss ,)"
`pitch	Suffix	"N-V(`pitch ,)"
`plait	Suffix	"N-V(`plait ,)"
`play	Suffix	"N-V(`play ,)"
`plop	Suffix	"N-V(`plop ,)"
`plunge	Suffix	"N-V(`plunge ,)"
`poise	Suffix	"N-V(`poise ,)"
`poke	Suffix	"N-V(`poke ,)"
`polish	Suffix	"N-V(`polish ,)"
`pop	Suffix	"N-V(`pop ,)"
`pose	Suffix	"N-V(`pose ,)"
`pounce	Suffix	"N-V(`pounce ,)"
`pout	Suffix	"N-V(`pout ,)"
`practice	Suffix	"N-V(`practice ,)"
`practise	Suffix	"N-V(`practise ,)"
`praise	Suffix	"N-V(`praise ,)"
pre`cipitate	Suffix	"N-V(pre`cipitate ,)"
`press	Suffix	"N-V(`press ,)"
`prick	Suffix	"N-V(`prick ,)"
`print	Suffix	"N-V(`print ,)"
`probe	Suffix	"N-V(`probe ,)"
`prompt	Suffix	"N-V(`prompt ,)"
`pucker	Suffix	"N-V(`pucker ,)"
`puff	Suffix	"N-V(`puff ,)"
`pull	Suffix	"N-V(`pull ,)"
`pulse	Suffix	"N-V(`pulse ,)"
`pump	Suffix	"N-V(`pump ,)"
`punch	Suffix	"N-V(`punch ,)"
`puncture	Suffix	"N-V(`puncture ,)"
`punt	Suffix	"N-V(`punt ,)"
`purchase	Suffix	"N-V(`purchase ,)"
`purge	Suffix	"N-V(`purge ,)"
`push	Suffix	"N-V(`push ,)"
`quack	Suffix	"N-V(`quack ,)"
`quarrel	Suffix	"N-V(`quarrel ,)"
`quote	Suffix	"N-V(`quote ,)"
`raise	Suffix	"N-V(`raise ,)"
`rally	Suffix	"N-V(`rally ,)"
`rank	Suffix	"N-V(`rank ,)"
`rap	Suffix	"N-V(`rap ,)"
`rape	Suffix	"N-V(`rape ,)"
`rate	Suffix	"N-V(`rate ,)"
`rattle	Suffix	"N-V(`rattle ,)"
`rebate	Suffix	"N-V(`rebate ,)"
re`buff	Suffix	"N-V(re`buff ,)"
re`buke	Suffix	"N-V(re`buke ,)"
re`cess	Suffix	"N-V(re`cess ,)"
`recompence	Suffix	"N-V(`recompence ,)"
`recompense	Suffix	"N-V(`recompense ,)"
re`cruit	Suffix	"N-V(re`cruit ,)"
refer`ee	Suffix	"N-V(refer`ee ,)"
re`gard	Suffix	"N-V(re`gard ,)"
re`gret	Suffix	"N-V(re`gret ,)"
`reign	Suffix	"N-V(`reign ,)"
re`lease	Suffix	"N-V(re`lease ,)"
`rent	Suffix	"N-V(`rent ,)"
re`proach	Suffix	"N-V(re`proach ,)"
re`quest	Suffix	"N-V(re`quest ,)"
re`spect	Suffix	"N-V(re`spect ,)"
`rest	Suffix	"N-V(`rest ,)"
re`sult	Suffix	"N-V(re`sult ,)"
`retail	Suffix	"N-V(`retail ,)"
`rhyme	Suffix	"N-V(`rhyme ,)"
`rinse	Suffix	"N-V(`rinse ,)"
`rip	Suffix	"N-V(`rip ,)"
`ripple	Suffix	"N-V(`ripple ,)"
`roar	Suffix	"N-V(`roar ,)"
`roast	Suffix	"N-V(`roast ,)"
`roll	Suffix	"N-V(`roll ,rev)"
`roost	Suffix	"N-V(`roost ,)"
`rue	Suffix	"N-V(`rue ,)"
ruin	Suffix	"N-V(ruin ,)"
rumble	Suffix	"N-V(rumble ,)"
`rummage	Suffix	"N-V(`rummage ,)"
`rupture	Suffix	"N-V(`rupture ,)"
`rush	Suffix	"N-V(`rush ,)"
`sag	Suffix	"N-V(`sag ,)"
sa`lute	Suffix	"N-V(sa`lute ,)"
`scare	Suffix	"N-V(`scare ,)"
`scout	Suffix	"N-V(`scout ,)"
`scowl	Suffix	"N-V(`scowl ,)"
`scrape	Suffix	"N-V(`scrape ,)"
`scratch	Suffix	"N-V(`scratch ,)"
`scrawl	Suffix	"N-V(`scrawl ,)"
`scream	Suffix	"N-V(`scream ,)"
`screech	Suffix	"N-V(`screech ,)"
`scribble	Suffix	"N-V(`scribble ,)"
`seal	Suffix	"N-V(`seal ,rev)"
`search	Suffix	"N-V(`search ,)"
`shift	Suffix	"N-V(`shift ,rev)"
`shimmer	Suffix	"N-V(`shimmer ,)"
`shimmy	Suffix	"N-V(`shimmy ,)"
`shiver	Suffix	"N-V(`shiver ,)"
`shout	Suffix	"N-V(`shout ,)"
`shove	Suffix	"N-V(`shove ,)"
`shriek	Suffix	"N-V(`shriek ,)"
`shrug	Suffix	"N-V(`shrug ,)"
`shudder	Suffix	"N-V(`shudder ,)"
`shuffle	Suffix	"N-V(`shuffle ,)"
`simper	Suffix	"N-V(`simper ,)"
`simulcast	Suffix	"N-V(`simulcast ,)"
`sip	Suffix	"N-V(`sip ,)"
`skid	Suffix	"N-V(`skid ,)"
`skip	Suffix	"N-V(`skip ,)"
`slam	Suffix	"N-V(`slam ,)"
`slap	Suffix	"N-V(`slap ,)"
`slash	Suffix	"N-V(`slash ,)"
`slaughter	Suffix	"N-V(`slaughter ,)"
`slice	Suffix	"N-V(`slice ,)"
`slight	Suffix	"N-V(`slight ,)"
`slip	Suffix	"N-V(`slip ,)"
`slobber	Suffix	"N-V(`slobber ,)"
`slug	Suffix	"N-V(`slug ,)"
`slumber	Suffix	"N-V(`slumber ,)"
`slump	Suffix	"N-V(`slump ,)"
`slur	Suffix	"N-V(`slur ,)"
`slurp	Suffix	"N-V(`slurp ,)"
`smack	Suffix	"N-V(`smack ,)"
`smash	Suffix	"N-V(`smash ,)"
`smear	Suffix	"N-V(`smear ,)"
`smile	Suffix	"N-V(`smile ,)"
`smirk	Suffix	"N-V(`smirk ,)"
`smolder	Suffix	"N-V(`smolder ,)"
`snap	Suffix	"N-V(`snap ,rev)"
`snarl	Suffix	"N-V(`snarl ,rev)"
`sneak	Suffix	"N-V(`sneak ,)"
`sneer	Suffix	"N-V(`sneer ,)"
`sneeze	Suffix	"N-V(`sneeze ,)"
`sniff	Suffix	"N-V(`sniff ,)"
`sniffle	Suffix	"N-V(`sniffle ,)"
`snigger	Suffix	"N-V(`snigger ,)"
`snip	Suffix	"N-V(`snip ,)"
`snort	Suffix	"N-V(`snort ,)"
`sob	Suffix	"N-V(`sob ,)"
`sock	Suffix	"N-V(`sock ,)"
`sparkle	Suffix	"N-V(`sparkle ,)"
`splash	Suffix	"N-V(`splash ,)"
`splice	Suffix	"N-V(`splice ,)"
`sprinkle	Suffix	"N-V(`sprinkle ,)"
`sprint	Suffix	"N-V(`sprint ,)"
`sprout	Suffix	"N-V(`sprout ,)"
`spurt	Suffix	"N-V(`spurt ,)"
`spy	Suffix	"N-V(`spy ,)"
`squawk	Suffix	"N-V(`squawk ,)"
`squeak	Suffix	"N-V(`squeak ,)"
`squeal	Suffix	"N-V(`squeal ,)"
`squeeze	Suffix	"N-V(`squeeze ,)"
`squirt	Suffix	"N-V(`squirt ,)"
`stab	Suffix	"N-V(`stab ,)"
`stain	Suffix	"N-V(`stain ,)"
`start	Suffix	"N-V(`start ,)"
`stash	Suffix	"N-V(`stash ,)"
`stay	Suffix	"N-V(`stay ,)"
`steer	Suffix	"N-V(`steer ,)"
`stop	Suffix	"N-V(`stop ,rev)"
`store	Suffix	"N-V(`store ,)"
`stray	Suffix	"N-V(`stray ,)"
`stretch	Suffix	"N-V(`stretch ,)"
`stroll	Suffix	"N-V(`stroll ,)"
`struggle	Suffix	"N-V(`struggle ,)"
`study	Suffix	"N-V(`study ,)"
`stutter	Suffix	"N-V(`stutter ,)"
`sub	Suffix	"N-V(`sub ,)"
`substitute	Suffix	"N-V(`substitute ,)"
sup`ply	Suffix	"N-V(sup`ply ,)"
sup`port	Suffix	"N-V(sup`port ,)"
`surcharge	Suffix	"N-V(`charge ,)"
`surge	Suffix	"N-V(`surge ,)"
sur`prise	Suffix	"N-V(sur`prise ,)"
sur`render	Suffix	"N-V(sur`render ,)"
`swap	Suffix	"N-V(`swap ,)"
`swarm	Suffix	"N-V(`swarm ,)"
`swindle	Suffix	"N-V(`swindle ,)"
`syndicate	Suffix	"N-V(`syndicate ,)"
`swallow	Suffix	"N-V(`swallow ,)"
`tackle	Suffix	"N-V(`tackle ,)"
`talk	Suffix	"N-V(`talk ,)"
`tan	Suffix	"N-V(`tan ,)"
`tangle	Suffix	"N-V(`tangle ,rev)"
`tap	Suffix	"N-V(`tap ,)"
`taste	Suffix	"N-V(`taste ,)"
`tax	Suffix	"N-V(`tax ,)"
`thaw	Suffix	"N-V(`thaw ,)"
`thud	Suffix	"N-V(`thud ,)"
`thump	Suffix	"N-V(`thump ,)"
`thwack	Suffix	"N-V(`thwack ,)"
`tick	Suffix	"N-V(`tick ,)"
`tilt	Suffix	"N-V(`tilt ,)"
`tinge	Suffix	"N-V(`tinge ,)"
`tingle	Suffix	"N-V(`tingle ,)"
`tithe	Suffix	"N-V(`tithe ,)"
`toast	Suffix	"N-V(`toast ,)"
`toggle	Suffix	"N-V(`toggle ,)"
`toil	Suffix	"N-V(`toil ,)"
`toot	Suffix	"N-V(`toot ,)"
`topple	Suffix	"N-V(`topple ,)"
`torture	Suffix	"N-V(`torture ,)"
`toss	Suffix	"N-V(`toss ,)"
`touch	Suffix	"N-V(`touch ,)"
`tow	Suffix	"N-V(`tow ,)"
`trade	Suffix	"N-V(`trade ,)"
`tramp	Suffix	"N-V(`tramp ,)"
`travel	Suffix	"N-V(`travel ,)"
`treat	Suffix	"N-V(`treat ,)"
`trek	Suffix	"N-V(`trek ,)"
`trend	Suffix	"N-V(`trend ,)"
`trespass	Suffix	"N-V(`trespass ,)"
`trickle	Suffix	"N-V(`trickle ,)"
`trifle	Suffix	"N-V(`trifle ,)"
`trill	Suffix	"N-V(`trill ,)"
`truss	Suffix	"N-V(`truss ,rev)"
`try	Suffix	"N-V(`try ,)"
`tug	Suffix	"N-V(`tug ,)"
`tumble	Suffix	"N-V(`tumble ,)"
`turn	Suffix	"N-V(`turn ,)"
`tweak	Suffix	"N-V(`tweak ,)"
`twinge	Suffix	"N-V(`twinge ,)"
`twinkle	Suffix	"N-V(`twinkle ,)"
`twirl	Suffix	"N-V(`twirl ,)"
`twist	Suffix	"N-V(`twist ,rev)"
`twitch	Suffix	"N-V(`twitch ,)"
`twitter	Suffix	"N-V(`twitter ,)"
`upgrade	Suffix	"N-V(`upgrade ,)"
`upload	Suffix	"N-V(`upload ,)"
`urge	Suffix	"N-V(`urge ,)"
`use	Suffix	"N-V(`use ,)"
`usher	Suffix	"N-V(`usher ,)"
`vault	Suffix	"N-V(`vault ,)"
`vent	Suffix	"N-V(`vent ,)"
`venture	Suffix	"N-V(`venture ,)"
`verge	Suffix	"N-V(`verge ,)"
`visit	Suffix	"N-V(`visit ,)"
`vomit	Suffix	"N-V(`vomit ,)"
`wail	Suffix	"N-V(`wail ,)"
`wait	Suffix	"N-V(`wait ,)"
`walk	Suffix	"N-V(`walk ,)"
`wallop	Suffix	"N-V(`wallop ,)"
`wash	Suffix	"N-V(`wash ,)"
`waste	Suffix	"N-V(`waste ,)"
`wave	Suffix	"N-V(`wave ,)"
`welcome	Suffix	"N-V(`welcome ,)"
`weld	Suffix	"N-V(`weld ,)"
`welter	Suffix	"N-V(`welter ,)"
`whack	Suffix	"N-V(`whack ,)"
`wham	Suffix	"N-V(`wham ,)"
`wheeze	Suffix	"N-V(`wheeze ,)"
`whiff	Suffix	"N-V(`whiff ,)"
`whimper	Suffix	"N-V(`whimper ,)"
`whine	Suffix	"N-V(`whine ,)"
`whinny	Suffix	"N-V(`whinny ,)"
`whir	Suffix	"N-V(`whir ,)"
`whirl	Suffix	"N-V(`whirl ,)"
`whish	Suffix	"N-V(`whish ,)"
`whisper	Suffix	"N-V(`whisper ,)"
`whistle	Suffix	"N-V(`whistle ,)"
`whiz	Suffix	"N-V(`whiz ,)"
`whoop	Suffix	"N-V(`whoop ,)"
`whop	Suffix	"N-V(`whop ,)"
`whump	Suffix	"N-V(`whump ,)"
`wince	Suffix	"N-V(`wince ,)"
`wink	Suffix	"N-V(`wink ,)"
`wipe	Suffix	"N-V(`wipe ,)"
`wish	Suffix	"N-V(`wish ,)"
`wobble	Suffix	"N-V(`wobble ,)"
`wonder	Suffix	"N-V(`wonder ,)"
`work	Suffix	"N-V(`work ,)"
`worry	Suffix	"N-V(`worry ,)"
`wrangle	Suffix	"N-V(`wrangle ,)"
`wreck	Suffix	"N-V(`wreck ,)"
`wrench	Suffix	"N-V(`wrench ,)"
`yank	Suffix	"N-V(`yank ,)"
`yap	Suffix	"N-V(`yap ,)"
`yawn	Suffix	"N-V(`yawn ,)"
`yell	Suffix	"N-V(`yell ,)"
`yip	Suffix	"N-V(`yip ,)"
`yowl	Suffix	"N-V(`yowl ,)"
`zoom	Suffix	"N-V(`zoom ,)"

N-AJ:
`elder	Suffix	"N-AJ(`elder ,comp)"
`amber	Suffix	"N-AJ(`amber ,)"
`aqua	Suffix	"N-AJ(`aqua ,)"
`auburn	Suffix	"N-AJ(`auburn ,)"
`azure	Suffix	"N-AJ(`azure ,)"
`beige	Suffix	"N-AJ(`beige ,)"
`black	Suffix	"N-AJ(`black ,)"
`blond	Suffix	"N-AJ(`blond ,)"
`blonde	Suffix	"N-AJ(`blonde ,)"
`blue	Suffix	"N-AJ(`blue ,)"
`brown	Suffix	"N-AJ(`brown ,)"
ce`rise	Suffix	"N-AJ(ce`rise ,)"
char`treuse	Suffix	"N-AJ(char`treuse ,)"
`crimson	Suffix	"N-AJ(`crimson ,)"
`fuchia	Suffix	"N-AJ(`fuchia ,)"
`gray	Suffix	"N-AJ(`gray ,)"
`green	Suffix	"N-AJ(`green ,)"
`grey	Suffix	"N-AJ(`grey ,)"
`lavender	Suffix	"N-AJ(`lavender ,)"
ma`genta	Suffix	"N-AJ(ma`genta ,)"
`mauve	Suffix	"N-AJ(`mauve ,)"
`orange	Suffix	"N-AJ(`orange ,)"
`pink	Suffix	"N-AJ(`pink ,)"
`puce	Suffix	"N-AJ(`puce ,)"
`purple	Suffix	"N-AJ(`purple ,)"
`red	Suffix	"N-AJ(`red ,)"
`scarlet	Suffix	"N-AJ(`scarlet ,)"
`sepia	Suffix	"N-AJ(`sepia ,)"
`turquoise	Suffix	"N-AJ(`turquoise ,)"
`umber	Suffix	"N-AJ(`umber ,)"
ver`milion	Suffix	"N-AJ(ver`milion ,)"
`white	Suffix	"N-AJ(`white ,)"
`yellow	Suffix	"N-AJ(`yellow ,)"
`ablative	Suffix	"N-AJ(`ablative ,)"
`acid	Suffix	"N-AJ(`acid ,)"
a`coustic	IC_Suffix	"N-AJ(a`coustic ,)"
a`crylic	Suffix	"N-AJ(a`crylic ,)"
`additive	Suffix	"N-AJ(`add ,deverb)"
ad`hesive	Suffix	"N-AJ(ad`here ,deverb)"
ado`lescent	Suffix	"N-AJ(ado`lescent ,)"
a`dult	Suffix	"N-AJ(a`dult ,)"
`aerial	Suffix	"N-AJ(`aerial ,)"
`aggregate	Suffix	"N-AJ(`aggregate ,)"
alve`olar	Suffix	"N-AJ(alve`olar ,)"
`ancient	Suffix	"N-AJ(`ancient ,)"
`anglican	Suffix	"N-AJ(`anglican ,)"
`annual	Suffix	"N-AJ(`annual ,~ajr14)"
audio`visual	Suffix	"N-AJ(audio`visual ,)"
authori`tarian	Suffix	"N-AJ(au`thority ,denom)"
bar`barian	Suffix	"N-AJ(bar`barian ,)"
`barren	Suffix	"N-AJ(`barren ,)"
`blank	Suffix	"N-AJ(`blank ,)"
`boolean	Suffix	"N-AJ(`Boole ,denom)"
`captive	Suffix	"N-AJ(`captive ,)"
`catholic	IC_Suffix	"N-AJ(`catholic ,)"
cen`tennial	Suffix	"N-AJ(cen`tennial ,)"
`chemical	Suffix	"N-AJ(`chemical ,)"
`chief	Suffix	"N-AJ(`chief ,)"
`circular	Suffix	"N-AJ(`circle ,denom)"
`classic	Suffix	"N-AJ(`classic ,)"
`cold	Suffix	"N-AJ(`cold ,)"
co`mestible	Suffix	"N-AJ(co`mestible ,)"
`commonplace	Suffix	"N-AJ(`commonplace ,)"
com`patible	Suffix	"N-AJ(com`patible ,)"
`consequent	Suffix	"N-AJ(`consequent ,)"
con`servative	Suffix	"N-AJ(con`serve ,deverb)"
con`stabulary	Suffix	"N-AJ(`constable ,denom)"
con`stituent	Suffix	"N-AJ(con`stituent ,)"
con`temporary	Suffix	"N-AJ(con`temporary ,)"
contra`ceptive	Suffix	"N-AJ(contra`ceptive ,)"
`criminal	Suffix	"N-AJ(`crime ,denom)"
`dandy	Suffix	"N-AJ(`dandy ,)"
`darling	Suffix	"N-AJ(`darling ,)"
`dear	Suffix	"N-AJ(`dear ,)"
`decimal	Suffix	"N-AJ(`decimal ,)"
de`linquent	Suffix	"N-AJ(de`linquent ,)"
`derelict	Suffix	"N-AJ(`derelict ,)"
de`rivative	Suffix	"N-AJ(de`rive ,deverb)"
`deviant	Suffix	"N-AJ(`deviate ,deverb)"
di`agonal	Suffix	"N-AJ(di`agonal ,)"
dis`junct	Suffix	"N-AJ(dis`junct ,)"
`double	Suffix	"N-AJ(`double ,)"
`drunk	Suffix	"N-AJ(`drunk ,)"
`due	Suffix	"N-AJ(`due ,)"
`duplex	Suffix	"N-AJ(`duplex ,)"
egali`tarian	Suffix	"N-AJ(egali`tarian ,)"
e`lect	Suffix	"N-AJ(e`lect ,)"
en`cyclical	Suffix	"N-AJ(en`cyclical ,)"
e`quivalent	Suffix	"N-AJ(e`quivalent ,)"
es`sential	Suffix	"N-AJ(es`sential ,)"
`evil	Suffix	"N-AJ(`evil ,)"
ex`plosive	Suffix	"N-AJ(ex`plode ,deverb)"
ex`ternal	Suffix	"N-AJ(ex`ternal ,)"
`extra	Suffix	"N-AJ(`extra ,)"
ex`treme	Suffix	"N-AJ(ex`treme ,)"
`favorite	Suffix	"N-AJ(`favorite ,)"
`favourite	Suffix	"N-AJ(`favourite - British,)"
`feline	Suffix	"N-AJ(`feline ,)"
`female	Suffix	"N-AJ(`female ,)"
`fortunate	Suffix	"N-AJ(`fortune ,denom)"
funda`mental	Suffix	"N-AJ(funda`mental ,)"
`future	Suffix	"N-AJ(`future ,)"
`gay	Suffix	"N-AJ(`gay ,)"
`genital	Suffix	"N-AJ(`genital ,)"
`graduate	Suffix	"N-AJ(`graduate ,)"
`hearty	Suffix	"N-AJ(`hearty ,)"
hetero`sexual	Suffix	"N-AJ(hetero`sexual ,)"
`high	Suffix	"N-AJ(`high ,)"
homo`sexual	Suffix	"N-AJ(homo`sexual ,)"
hypo`chondriac	Suffix	"N-AJ(hypo`chondria ,denom)"
i`deal	Suffix	"N-AJ(i`deal ,)"
`ill	Suffix	"N-AJ(`ill ,)"
in`cumbent	Suffix	"N-AJ(in`cumbent ,)"
`indigo	Suffix	"N-AJ(`indigo ,)"
indi`vidual	Suffix	"N-AJ(indi`vidual ,)"
in`ferior	Suffix	"N-AJ(in`ferior ,)"
`innocent	Suffix	"N-AJ(`innocent ,)"
in`surgent	Suffix	"N-AJ(in`surgent ,)"
`juvenile	Suffix	"N-AJ(`juvenile ,)"
`labial	Suffix	"N-AJ(`labial ,)"
`laxative	Suffix	"N-AJ(`laxative ,)"
`left	Suffix	"N-AJ(`left ,)"
`leftover	Suffix	"N-AJ(`leftover ,)"
`lesbian	Suffix	"N-AJ(`lesbian ,)"
`liberal	Suffix	"N-AJ(`liberal ,)"
`liquid	Suffix	"N-AJ(`liquid ,)"
`local	Suffix	"N-AJ(`local ,)"
`mainline	Suffix	"N-AJ(`mainline ,)"
`major	Suffix	"N-AJ(`major ,)"
`male	Suffix	"N-AJ(`male ,)"
`medial	Suffix	"N-AJ(`medial ,)"
`militant	Suffix	"N-AJ(`militant ,)"
`miniature	Suffix	"N-AJ(`miniature ,)"
`minor	Suffix	"N-AJ(`minor ,)"
`modern	Suffix	"N-AJ(`modern ,)"
`moral	Suffix	"N-AJ(`moral ,)"
`mortal	Suffix	"N-AJ(`mortal ,)"
`multiple	Suffix	"N-AJ(`multiple ,)"
`nasal	Suffix	"N-AJ(`nasal ,)"
`native	Suffix	"N-AJ(`native ,)"
ne`anderthal	Suffix	"N-AJ(ne`anderthal ,)"
new`born	Suffix	"N-AJ(new`born ,)"
`noble	Suffix	"N-AJ(`noble ,)"
`nominal	Suffix	"N-AJ(`nominal ,)"
nondes`cript	Suffix	"N-AJ(nondes`cript ,)"
`null	Suffix	"N-AJ(`null ,)"
`nuptial	Suffix	"N-AJ(`nuptial ,)"
oc`clusive	Suffix	"N-AJ(oc`clude ,deverb)"
oc`cult	Suffix	"N-AJ(oc`cult ,)"
o`lympian	Suffix	"N-AJ(o`lympian ,)"
`opposite	Suffix	"N-AJ(`opposite ,)"
`optative	Suffix	"N-AJ(`optative ,)"
`ordinal	Suffix	"N-AJ(`ordinal ,)"
`oval	Suffix	"N-AJ(`oval ,)"
`paranoid	Suffix	"N-AJ(`paranoid ,)"
`passive	Suffix	"N-AJ(`passive ,)"
`past	Suffix	"N-AJ(`past ,)"
`penitent	Suffix	"N-AJ(`penitent ,)"
pe`rennial	Suffix	"N-AJ(pe`rennial ,)"
pe`ripheral	Suffix	"N-AJ(pe`riphery ,denom)"
perpen`dicular	Suffix	"N-AJ(perpen`dicular ,)"
pharma`ceutical	Suffix	"N-AJ(pharma`ceutical ,)"
`physical	Suffix	"N-AJ(`physical ,)"
plu`perfect	Suffix	"N-AJ(plu`perfect ,)"
`plural	Suffix	"N-AJ(`plural ,)"
`positive	Suffix	"N-AJ(`positive ,)"
post`mortem	Suffix	"N-AJ(post`mortem ,)"
post-`mortem	Suffix	"N-AJ(post-`mortem ,)"
pre`liminary	Suffix	"N-AJ(pre`liminary ,)"
pre`parative	Suffix	"N-AJ(pre`pare ,deverb)"
pre`servative	Suffix	"N-AJ(pre`serve ,deverb)"
`preterit	Suffix	"N-AJ(`preterit ,)"
pre`ventative	Suffix	"N-AJ(pre`vent ,deverb)"
`primary	Suffix	"N-AJ(`primary ,)"
`primitive	Suffix	"N-AJ(`primitive ,)"
`principal	Suffix	"N-AJ(`principal ,)"
`profligate	Suffix	"N-AJ(`profligate ,)"
`public	Suffix	"N-AJ(`public ,)"
`purgative	Suffix	"N-AJ(`purge ,deverb)"
`radial	Suffix	"N-AJ(`radial ,)"
`radical	Suffix	"N-AJ(`radical ,)"
re`actionary	Suffix	"N-AJ(re`actionary ,)"
`recluse	Suffix	"N-AJ(`recluse ,)"
`recusant	Suffix	"N-AJ(`recusant ,)"
re`flexive	Suffix	"N-AJ(re`flexive ,)"
`regular	Suffix	"N-AJ(`regular ,)"
repre`sentative	Suffix	"N-AJ(repre`sent ,deverb)"
`requisite	Suffix	"N-AJ(`requisite ,)"
`resident	Suffix	"N-AJ(`resident ,)"
`resonant	Suffix	"N-AJ(`resonant ,)"
revo`lutionary	Suffix	"N-AJ(revo`lution ,denom)"
`right	Suffix	"N-AJ(`right ,)"
`rowdy	Suffix	"N-AJ(`rowdy ,)"
`savage	Suffix	"N-AJ(`savage ,)"
`schizoid	Suffix	"N-AJ(`schizoid ,)"
se`rial	Suffix	"N-AJ(se`rial ,)"
`sibilant	Suffix	"N-AJ(`sibilant ,)"
`single	Suffix	"N-AJ(`single ,)"
`social	Suffix	"N-AJ(`social ,)"
`solid	Suffix	"N-AJ(`solid ,)"
`sonorant	Suffix	"N-AJ(`sonorant ,)"
`sore	Suffix	"N-AJ(`sore ,)"
`sovereign	Suffix	"N-AJ(`sovereign ,)"
`special	Suffix	"N-AJ(`special ,)"
`spiral	Suffix	"N-AJ(`spiral ,)"
`square	Suffix	"N-AJ(`square ,)"
sub`altern	Suffix	"N-AJ(sub`altern ,)"
sub`junctive	Suffix	"N-AJ(sub`junctive ,)"
sub`sidiary	Suffix	"N-AJ(sub`sidiary ,)"
`substantive	Suffix	"N-AJ(`substantive ,)"
su`perior	Suffix	"N-AJ(su`perior ,)"
su`perlative	Suffix	"N-AJ(su`perlative ,)"
`sweet	Suffix	"N-AJ(`sweet ,)"
`tart	Suffix	"N-AJ(`tart ,)"
ter`restrial	Suffix	"N-AJ(ter`restrial ,)"
`thoroughbred	Suffix	"N-AJ(`thoroughbred ,)"
`trident	Suffix	"N-AJ(`trident ,)"
trini`tarian	Suffix	"N-AJ(`trinity ,denom)"
`truant	Suffix	"N-AJ(`truant ,)"
`turnup	Suffix	"N-AJ(`turnup ,)"
`tutelary	Suffix	"N-AJ(`tutelary ,)"
`twin	Suffix	"N-AJ(`twin ,)"
`uniform	Suffix	"N-AJ(`uniform ,)"
uni`tarian	Suffix	"N-AJ(`unity ,denom)"
uni`versal	Suffix	"N-AJ(uni`versal ,)"
utili`tarian	Suffix	"N-AJ(u`tility ,denom)"
`utmost	Suffix	"N-AJ(`utmost ,)"
`vagrant	Suffix	"N-AJ(`vagrant ,)"
vege`tarian	Suffix	"N-AJ(vege`tarian ,)"
`velar	Suffix	"N-AJ(`velum ,denom)"
`verbal	Suffix	"N-AJ(`verbal ,)"
ver`nacular	Suffix	"N-AJ(ver`nacular ,)"
`vertebrate	Suffix	"N-AJ(`vertebrate ,)"
`vibrant	Suffix	"N-AJ(`vibrate ,deverb)"
`vocal	Suffix	"N-AJ(`vocal ,)"
`vocative	Suffix	"N-AJ(`vocative ,)"
`western	Suffix	"N-AJ(`western ,)"
`whole	Suffix	"N-AJ(`whole ,)"
`wild	Suffix	"N-AJ(`wild ,)"
`woolen	Suffix	"N-AJ(`wool ,denom)"
`woollen	Suffix	"N-AJ(`wool ,denom)"
`wrong	Suffix	"N-AJ(`wrong ,)"
`chordate	Suffix	"N-AJ(`chordate ,)"
virtu`oso	Suffix	"N-AJ(virtu`oso ,)"
`aerospace	Suffix	"N-AJ(`aerospace ,)"
af`fine	Suffix	"N-AJ(af`fine ,)"
`alien	Suffix	"N-AJ(`alien ,)"
`amateur	Suffix	"N-AJ(`amateur ,)"
`analog	Suffix	"N-AJ(`analog ,)"
anti`quarian	Suffix	"N-AJ(anti`quarian ,)"
an`tique	Suffix	"N-AJ(an`tique ,)"
a`postate	Suffix	"N-AJ(a`postate ,)"
ap`pellant	Suffix	"N-AJ(ap`peal ,deverb)"
avant-`garde	Suffix	"N-AJ(avant-`garde ,)"
`background	Suffix	"N-AJ(`background ,)"
`choice	Suffix	"N-AJ(`choice ,)"
ci`vilian	Suffix	"N-AJ(`civil ,deadj)"
`constant	Suffix	"N-AJ(`constant ,)"
`couple	Suffix	"N-AJ(`couple ,)"
`distaff	Suffix	"N-AJ(`distaff ,)"
`downhill	Suffix	"N-AJ(`downhill ,)"
`dozen	Suffix	"N-AJ(`dozen ,)"
`dummy	Suffix	"N-AJ(`dummy ,)"
`east	Suffix	"N-AJ(`east ,)"
`fairytale	Suffix	"N-AJ(`fairytale ,)"
`fat	Suffix	"N-AJ(`fat ,)"
`gold	Suffix	"N-AJ(`gold ,)"
`human	Suffix	"N-AJ(`human ,)"
humani`tarian	Suffix	"N-AJ(hu`manity ,denom)"
`humanoid	Suffix	"N-AJ(`human ,)"
`hybrid	Suffix	"N-AJ(`hybrid ,)"
`instant	Suffix	"N-AJ(`instant ,)"
liber`tarian	Suffix	"N-AJ(`liberty ,)"
`magic	Suffix	"N-AJ(`magic ,)"
`median	Suffix	"N-AJ(`median ,)"
`melancholy	Suffix	"N-AJ(`melancholy ,)"
`metric	Suffix	"N-AJ(`metric ,)"
`middle	Suffix	"N-AJ(`middle ,)"
`millenary	Suffix	"N-AJ(`millenary ,)"
`multitasking	Suffix	"N-AJ(`task ,)"
nar`cotic	Suffix	"N-AJ(nar`cotic ,)"
`navy	Suffix	"N-AJ(`navy ,)"
`north	Suffix	"N-AJ(`north ,)"
north`east	Suffix	"N-AJ(north`east ,)"
north`west	Suffix	"N-AJ(north`west ,)"
`pagan	Suffix	"N-AJ(`pagan ,)"
`pyrrhic	Suffix	"N-AJ(`pyrrhic ,)"
razzle-`dazzle	Suffix	"N-AJ(razzle-`dazzle ,)"
re`cidivist	Suffix	"N-AJ(re`cidivist ,)"
`resident	Suffix	"N-AJ(re`side ,deverb)"
`scapular	Suffix	"N-AJ(`scapular ,)"
`secret	Suffix	"N-AJ(`secret ,)"
`senior	Suffix	"N-AJ(`senior ,)"
`south	Suffix	"N-AJ(`south ,)"
south`east	Suffix	"N-AJ(south`east ,)"
south`west	Suffix	"N-AJ(south`west ,)"
`spheroid	Suffix	"N-AJ(`sphere ,)"
`teen	Suffix	"N-AJ(`teen ,)"
`tenor	Suffix	"N-AJ(`tenor ,)"
`theist	Suffix	"N-AJ(`theist ,)"
`top	Suffix	"N-AJ(`top ,)"
`tortoiseshell	Suffix	"N-AJ(`tortoiseshell ,)"
totali`tarian	Suffix	"N-AJ(to`tality ,)"
un`christian	Suffix	"N-AJ(`Christian ,)"
`unison	Suffix	"N-AJ(`unison ,)"
va`nilla	Suffix	"N-AJ(va`nilla ,)"
`velvet	Suffix	"N-AJ(`velvet ,)"
ver`meil	Suffix	"N-AJ(ver`meil ,)"
`virgin	Suffix	"N-AJ(`virgin ,)"
`wayside	Suffix	"N-AJ(`wayside ,)"
`west	Suffix	"N-AJ(`west ,)"
`Martian	Suffix	"N-AJ(`Mars ,proper denom)"
Aristo`telean	Suffix	"N-AJ(`Aristotle ,proper denom)"
Aristo`telian	Suffix	"N-AJ(`Aristotle ,proper denom)"
Bene`dictine	Suffix	"N-AJ(`Benedict ,proper denom)"
Con`fucian	Suffix	"N-AJ(Con`fucius ,proper denom)"
Dio`nysian	Suffix	"N-AJ(Dio`nysus ,proper denom)"
Ed`wardian	Suffix	"N-AJ(`Edward ,proper denom)"
Eliza`bethan	Suffix	"N-AJ(E`lizabeth ,proper denom)"
Fran`ciscan	Suffix	"N-AJ(`Francis ,proper denom)"
Soc`ratic	Suffix	"N-AJ(`Socrates ,proper denom)"
Vic`torian	Suffix	"N-AJ(Vic`toria ,proper denom)"
Zoro`astrian	Suffix	"N-AJ(`Zoroaster ,proper denom)"
`Aryan	Suffix	"N-AJ(`Aryan ,proper)"
`British	Suffix	"N-AJ(`British ,proper)"
`Dutch	Suffix	"N-AJ(`Dutch ,proper)"
`English	Suffix	"N-AJ(`English ,proper)"
Fili`pino	Suffix	"N-AJ(Fili`pino ,proper)"
Finno-`Ugric	Suffix	"N-AJ(Finno-`Ugric ,proper)"
`French	Suffix	"N-AJ(`French ,proper)"
`German	Suffix	"N-AJ(`German ,proper)"
`Greek	Suffix	"N-AJ(`Greek ,proper)"
`Hebrew	Suffix	"N-AJ(`Hebrew ,proper)"
His`panic	Suffix	"N-AJ(His`panic ,proper)"
Indo-Euro`pean	Suffix	"N-AJ(Indo-Euro`pean ,proper)"
`Irish	Suffix	"N-AJ(`Irish ,proper)"
`Latin	Suffix	"N-AJ(`Latin ,proper)"
Ma`lay	PN_Suffix	"N-AJ(Ma`lay ,proper)"
`Manx	Suffix	"N-AJ(`Manx - isle of man,proper)"
`Mongoloid	Suffix	"N-AJ(`Mongol ,proper denom)"
`Mormon	PN_Suffix	"N-AJ(`Mormon ,proper)"
`Moslem	PN_Suffix	"N-AJ(`Moslem ,proper)"
`Muslim	PN_Suffix	"N-AJ(`Muslim ,proper)"
`Nazi	PN_Suffix	"N-AJ(`Nazi ,proper)"
`Norman	Suffix	"N-AJ(`Norman ,proper)"
`Philistine	Suffix	"N-AJ(`Philistine ,proper)"
`Spanish	Suffix	"N-AJ(`Spanish ,proper)"
`Swiss	Suffix	"N-AJ(`Swiss ,proper)"
`Welsh	Suffix	"N-AJ(`Welsh ,proper)"
`Yiddish	Suffix	"N-AJ(`Yiddish ,proper)"
`African	Suffix	"N-AJ(`Africa ,proper denom)"
Ala`baman	Suffix	"N-AJ(Ala`bama ,proper denom)"
Ala`bamian	Suffix	"N-AJ(Ala`bama ,proper denom)"
A`laskan	Suffix	"N-AJ(A`laska ,proper denom)"
Al`banian	Suffix	"N-AJ(Al`bania ,proper denom)"
Al`gerian	Suffix	"N-AJ(Al`geria ,proper denom)"
Al`satian	Suffix	"N-AJ(Al`sace ,proper denom)"
A`merican	Suffix	"N-AJ(A`merica ,proper denom)"
Appa`lachian	Suffix	"N-AJ(Appa`lachia ,proper denom)"
A`rabian	Suffix	"N-AJ(A`rabia ,proper denom)"
Argen`tinian	Suffix	"N-AJ(Argen`tina ,proper denom)"
Ari`zonan	Suffix	"N-AJ(Ari`zona ,proper denom)"
Ar`kansan	Suffix	"N-AJ(`Arkansas ,proper denom)"
Ar`menian	Suffix	"N-AJ(Ar`menia ,proper denom)"
`Asian	Suffix	"N-AJ(`Asia ,proper denom)"
As`syrian	Suffix	"N-AJ(As`syria ,proper denom)"
A`thenian	Suffix	"N-AJ(`Athens ,proper denom)"
At`lantic	Suffix	"N-AJ(At`lantic ,proper)"
Aus`tralian	Suffix	"N-AJ(Aus`tralia ,proper denom)"
`Austrian	Suffix	"N-AJ(`Austria ,proper denom)"
Ba`hamian	Suffix	"N-AJ(Ba`hamas ,proper denom)"
Bali`nese	Suffix	"N-AJ(`Bali ,proper denom)"
Ba`varian	Suffix	"N-AJ(Ba`varia ,proper denom)"
`Belgian	Suffix	"N-AJ(`Belgium ,proper denom)"
Bo`hemian	Suffix	"N-AJ(Bo`hemia ,proper denom)"
Bo`livian	Suffix	"N-AJ(Bo`livia ,proper denom)"
Bra`zilian	Suffix	"N-AJ(Bra`zil ,proper denom)"
Bul`garian	Suffix	"N-AJ(Bul`garian ,proper denom)"
Bur`mese	Suffix	"N-AJ(`Burma ,proper denom)"
Cali`fornian	Suffix	"N-AJ(Cali`fornia ,proper denom)"
Cam`bodian	Suffix	"N-AJ(Cam`bodia ,proper denom)"
Ca`nadian	Suffix	"N-AJ(`Canada ,proper denom)"
Cartha`ginian	Suffix	"N-AJ(`Carthage ,proper denom)"
Cau`casian	Suffix	"N-AJ(`Caucasus ,proper denom)"
Chi`nese	Suffix	"N-AJ(`China ,proper denom)"
Co`lombian	Suffix	"N-AJ(Co`lombia ,proper denom)"
Congo`lese	Suffix	"N-AJ(`Congo ,proper denom)"
Cro`atian	Suffix	"N-AJ(Cro`atia ,proper denom)"
`Cuban	Suffix	"N-AJ(`Cuba ,proper denom)"
`Cyprian	Suffix	"N-AJ(`Cyprus ,proper denom)"
Czechoslo`vakian	Suffix	"N-AJ(Czechoslo`vakia ,proper denom)"
E`phesian	Suffix	"N-AJ(`Ephesus ,proper denom)"
Es`tonian	Suffix	"N-AJ(Es`tonia ,proper denom)"
Ethi`opian	Suffix	"N-AJ(Ethi`opia ,proper denom)"
Flo`ridian	Suffix	"N-AJ(`Florida ,proper denom)"
For`mosan	Suffix	"N-AJ(For`mosa ,proper denom)"
Gali`laean	Suffix	"N-AJ(`Galilee ,proper denom)"
`Gambian	Suffix	"N-AJ(`Gambia ,proper denom)"
`Georgian	Suffix	"N-AJ(`Georgia ,proper denom)"
`Ghanian	Suffix	"N-AJ(`Ghana ,proper denom)"
`Grecian	Suffix	"N-AJ(`Greece ,proper denom)"
`Haitian	Suffix	"N-AJ(`Haiti ,proper denom)"
I`berian	Suffix	"N-AJ(I`beria ,proper denom)"
`Indian	Suffix	"N-AJ(`India ,proper denom)"
Indochi`nese	Suffix	"N-AJ(Indo`china ,proper denom)"
Indo`nesian	Suffix	"N-AJ(Indo`nesia ,proper denom)"
`Iowan	Suffix	"N-AJ(`Iowa ,proper denom)"
Ja`maican	Suffix	"N-AJ(Ja`maica ,proper denom)"
Japan`ese	Suffix	"N-AJ(Ja`pan ,proper denom)"
`Kenyan	Suffix	"N-AJ(`Kenya ,proper denom)"
Ko`rean	Suffix	"N-AJ(Ko`rea ,proper denom)"
La`otian	Suffix	"N-AJ(`Laos ,proper denom)"
`Latvian	Suffix	"N-AJ(`Latvia ,proper denom)"
Leban`ese	Suffix	"N-AJ(`Lebanon ,proper denom)"
Li`berian	Suffix	"N-AJ(Li`beria ,proper denom)"
`Libyan	Suffix	"N-AJ(`Libyan ,proper denom)"
Lithu`anian	Suffix	"N-AJ(Lithu`ania ,proper denom)"
Ma`laysian	Suffix	"N-AJ(Ma`laysia ,proper denom)"
Mal`tese	Suffix	"N-AJ(`Malta ,proper denom)"
Mediter`ranean	Suffix	"N-AJ(Mediter`ranean ,proper)"
Mesopo`tamian	Suffix	"N-AJ(Mesopo`tamia ,proper denom)"
`Mexican	Suffix	"N-AJ(`Mexico ,proper denom)"
Mon`golian	Suffix	"N-AJ(Mon`golia ,proper denom)"
Mo`ravian	Suffix	"N-AJ(Mo`ravia ,proper denom)"
Mo`roccan	Suffix	"N-AJ(Mo`rocco ,proper denom)"
Ne`braskan	Suffix	"N-AJ(Ne`braska ,proper denom)"
Nica`raguan	Suffix	"N-AJ(Nica`ragua ,proper denom)"
Ni`gerian	Suffix	"N-AJ(Ni`geria ,proper denom)"
Nor`wegian	Suffix	"N-AJ(`Norway ,proper denom)"
Pana`manian	Suffix	"N-AJ(`Panama ,proper denom)"
Pe`kinese	Suffix	"N-AJ(Pe`king ,proper denom)"
Pennsyl`vanian	Suffix	"N-AJ(Pennsyl`vania ,proper denom)"
`Persian	Suffix	"N-AJ(`Persia ,proper denom)"
Pe`ruvian	Suffix	"N-AJ(Pe`ru ,proper denom)"
Phila`delphian	Suffix	"N-AJ(Phila`delphia ,proper denom)"
Poly`nesian	Suffix	"N-AJ(Poly`nesia ,proper denom)"
`Portuguese	Suffix	"N-AJ(`Portugal ,proper denom)"
`Prussian	Suffix	"N-AJ(`Prussia ,proper denom)"
Ro`manian	Suffix	"N-AJ(Ro`mania ,proper denom)"
Ru`manian	Suffix	"N-AJ(Ru`mania ,proper denom)"
`Russian	Suffix	"N-AJ(`Russia ,proper denom)"
Sa`moan	Suffix	"N-AJ(Sa`moa ,proper denom)"
Scandi`navian	Suffix	"N-AJ(Scandi`navia ,proper denom)"
`Serbian	Suffix	"N-AJ(`Serbia ,proper denom)"
`Spartan	Suffix	"N-AJ(`Sparta ,proper denom)"
Sudan`ese	Suffix	"N-AJ(Su`dan ,proper denom)"
`Syrian	Suffix	"N-AJ(`Syria ,proper denom)"
Taiwan`ese	Suffix	"N-AJ(Tai`wan ,proper denom)"
`Texan	Suffix	"N-AJ(`Texas ,proper denom)"
Ti`betan	Suffix	"N-AJ(Ti`bet ,proper denom)"
`Trojan	Suffix	"N-AJ(`Troy ,proper denom)"
U`gandan	Suffix	"N-AJ(U`ganda ,proper denom)"
Ve`netian	Suffix	"N-AJ(`Venice ,proper denom)"
Vene`zuelan	Suffix	"N-AJ(Vene`zuela ,proper denom)"
Ven`etian	Suffix	"N-AJ(`Venice ,proper denom)"
Vien`nese	Suffix	"N-AJ(Vi`enna ,proper denom)"
Vir`ginian	Suffix	"N-AJ(Vir`ginia ,proper denom)"
`Zambian	Suffix	"N-AJ(`Zambia ,proper denom)"
mo`nomial	Suffix	"N-AJ(mo`nomial ,)"
quadri`lateral	Suffix	"N-AJ(quadri`lateral ,)"
super`natant	Suffix	"N-AJ(super`natant ,)"
sur`factant	Suffix	"N-AJ(sur`factant ,)"
`turbinate	Suffix	"N-AJ(`turbinate ,)"

Y_SUFF:
+y	Suffix	"Y_SUFF(+NR48 - ,n/n)"
+ous	Suffix	"Y_SUFF(+AJR21a - ,n/aj)"
+ic	IC_Suffix	"Y_SUFF(+AJR20a - ,n/aj ajr20)"
+er	Suffix	"Y_SUFF(+NR11 - ,n/n)"
+ess	Suffix	"Y_SUFF(+NR12 - ,n/n nr12)"
+ist	Suffix	"Y_SUFF(+NR31 - ,n/n nr31)"
+ize	Suffix	"Y_SUFF(+VR6a - ,n/v)"
+ise	Suffix	"Y_SUFF(+VR6b - British,n/v)"
+ify	Suffix	"Y_SUFF(+VR5 - ,n/v)"
+an	Suffix	"Y_SUFF(+AJR4a - ,n/aj)"
+ian	Suffix	"Y_SUFF(+AJR4b - ,n/aj)"
+ism	Suffix	"Y_SUFF(+NR8 - ,n/n)"

CD:
-	Cd	"CD(- - the hyphen permits 'twenty-one' etc.,)"
`zero	Cd	"CD(`zero ,)"
`one	Cd	"CD(`one ,)"
`two	Cd	"CD(`two ,)"
`three	Cd	"CD(`three ,)"
`four	Cd	"CD(`four ,)"
`five	Cd	"CD(`five ,)"
`six	Cd	"CD(`six ,)"
`seven	Cd	"CD(`seven ,)"
`eight	Cd	"CD(`eight ,)"
`nine	Cd	"CD(`nine ,)"
`ten	Cd	"CD(`ten ,)"
e`leven	Cd	"CD(e`leven ,)"
twelve	Cd	"CD(twelve ,)"
thir`teen	Cd	"CD(thir`teen ,)"
four`teen	Cd	"CD(four`teen ,)"
fif`teen	Cd	"CD(fif`teen ,)"
six`teen	Cd	"CD(six`teen ,)"
seven`teen	Cd	"CD(seven`teen ,)"
eight`een	Cd	"CD(eight`een ,)"
nine`teen	Cd	"CD(nine`teen ,)"
`twenty	Cd	"CD(`twenty ,)"
`thirty	Cd	"CD(`thirty ,)"
`forty	Cd	"CD(`forty ,)"
`fifty	Cd	"CD(`fifty ,)"
`sixty	Cd	"CD(`sixty ,)"
`seventy	Cd	"CD(`seventy ,)"
`eighty	Cd	"CD(`eighty ,)"
`ninety	Cd	"CD(`ninety ,)"
`hundred	Cd	"CD(`hundred ,)"
`thousand	Cd	"CD(`thousand ,)"
`million	Cd	"CD(`million ,)"
`billion	Cd	"CD(`billion ,)"
`trillion	Cd	"CD(`trillion ,)"
qua`drillion	Cd	"CD(qua`drillion ,)"
quin`tillion	Cd	"CD(quin`tillion ,)"
sex`tillion	Cd	"CD(sex`tillion ,)"
sep`tillion	Cd	"CD(sep`tillion ,)"
oc`tillion	Cd	"CD(oc`tillion ,)"
no`nillion	Cd	"CD(no`nillion ,)"
de`cillion	Cd	"CD(de`cillion ,)"
`zillion	Cd	"CD(`zillion ,)"

AUX-V:
be	End	"AUX-V(be ,)"
`being	PT_Suffix	"AUX-V(be ,ing)"
been	End	"AUX-V(be ,en irreg)"
am	End	"AUX-V(be ,-3sg)"
'm	End	"AUX-V(be ,-3sg)"
are	End	"AUX-V(be ,-3sg)"
're	End	"AUX-V(be ,-3sg)"
aren't	End	"AUX-V(be ,neg -3sg)"
is	End	"AUX-V(be ,s)"
's	End	"AUX-V(be ,s)"
isn't	End	"AUX-V(be ,s neg)"
ain't	End	"AUX-V(ain't ,neg)"
aint	End	"AUX-V(ain't ,neg)"
was	End	"AUX-V(be ,ed irreg)"
wasn't	End	"AUX-V(be ,ed irreg neg)"
were	End	"AUX-V(be ,ed -3sg irreg)"
weren't	End	"AUX-V(be ,ed -3sg irreg neg)"
have	End	"AUX-V(have ,-3sg)"
've	End	"AUX-V(have ,-3sg)"
haven't	End	"AUX-V(have ,neg -3sg)"
`having	End	"AUX-V(have ,ing)"
had	End	"AUX-V(have ,ed irreg)"
'd	End	"AUX-V(have ,ed irreg)"
hadn't	End	"AUX-V(have ,ed irreg neg)"
has	End	"AUX-V(have ,s)"
's	End	"AUX-V(have ,s)"
hasn't	End	"AUX-V(have ,s neg)"

AUX:
do	End	"AUX(do ,)"
does	End	"AUX(do ,s)"
`doing	End	"AUX(do ,ing)"
did	End	"AUX(do ,ed irreg)"
done	End	"AUX(do ,en irreg)"
didn't	End	"AUX(do ,ed irreg neg)"
doesn't	End	"AUX(do ,neg)"
don't	End	"AUX(do ,neg)"
can	End	"AUX(can ,modal)"
can`not	End	"AUX(can ,modal neg)"
can't	Contraction	"AUX(can ,modal neg)"
could	End	"AUX(could ,modal)"
`couldn't	Contraction	"AUX(could ,modal neg)"
may	End	"AUX(may ,modal)"
mayn't	Contraction	"AUX(may ,modal neg)"
might	End	"AUX(might ,modal)"
mightn't	Contraction	"AUX(might ,modal neg)"
ought	End	"AUX(ought ,modal)"
oughtn't	Contraction	"AUX(ought ,modal neg)"
shall	End	"AUX(shall ,modal)"
shan't	Contraction	"AUX(shall ,modal neg)"
should	End	"AUX(should ,modal)"
shouldn't	Contraction	"AUX(should ,modal neg)"
will	End	"AUX(will ,modal)"
'll	End	"AUX(will ,modal)"
won't	Contraction	"AUX(will ,modal neg)"
would	End	"AUX(would ,modal)"
'd	End	"AUX(would ,modal)"
wouldn't	Contraction	"AUX(would ,neg)"
must	End	"AUX(must ,modal)"
mustn't	Contraction	"AUX(must ,neg)"
needn't	End	"AUX(need ,neg)"
used	End	"AUX(used ,)"
usedn't	Contraction	"AUX(used ,neg)"
canst	End	"AUX(can ,)"
couldest	End	"AUX(could ,)"
didst	End	"AUX(do ,ed irreg)"
doest	End	"AUX(do ,)"
dost	End	"AUX(do ,)"
doeth	End	"AUX(do ,s)"
doth	End	"AUX(do ,s)"
hadst	End	"AUX(have ,ed irreg)"
hast	End	"AUX(have ,)"
hath	End	"AUX(have ,s)"
mayest	End	"AUX(may ,)"
mightest	End	"AUX(might ,)"
oughtest	End	"AUX(ought ,)"
shalt	End	"AUX(shall ,)"
shouldest	End	"AUX(should ,)"
wast	End	"AUX(be ,ed irreg)"
wert	End	"AUX(be ,ed irreg)"
wilt	End	"AUX(will ,)"
wouldst	End	"AUX(would ,)"
wouldest	End	"AUX(would ,)"
would'st	End	"AUX(would ,)"

PR:
who	Contraction	"PR(who ,wh)"
who`ever	Contraction	"PR(who`ever ,wh)"
`whoso	Contraction	"PR(`whoso ,wh)"
whoso`ever	Contraction	"PR(whoso`ever ,wh)"
whom	End	"PR(whom ,acc wh)"
whom`ever	End	"PR(whom`ever ,acc wh)"
`whomso	Contraction	"PR(`whomso ,acc wh)"
whomso`ever	End	"PR(whomso`ever ,acc wh)"
this	Contraction	"PR(this ,)"
that	Contraction	"PR(that ,)"
these	Contraction	"PR(these ,pl)"
those	Contraction	"PR(those ,pl)"
each	Contraction	"PR(each ,)"
none	Contraction	"PR(none ,)"
some	Contraction	"PR(some ,)"
a`nother	Contraction	"PR(a`nother ,)"
`other	Infl	"PR(`other ,)"
`zero	Contraction	"PR(`zero ,)"
there	Contraction	"PR(there - existential,)"
I	Contraction	"PR(I ,1)"
me	End	"PR(me ,1 acc)"
my	End	"PR(my ,1 gen)"
`mine	Contraction	"PR(`mine ,1 ind)"
we	Contraction	"PR(we ,1 pl)"
us	End	"PR(us ,1 pl acc)"
our	End	"PR(our ,1 pl gen)"
ours	Contraction	"PR(ours ,1 pl ind)"
you	Contraction	"PR(you ,2 sg-pl nom-acc)"
y'all	Contraction	"PR(y'all ,2 pl nom-acc)"
y'alls	Contraction	"PR(y'alls ,2 pl gen-ind)"
your	End	"PR(your ,2 sg-pl gen)"
yer	End	"PR(yer - substandard,2 sg-pl gen)"
yours	Contraction	"PR(yours ,2 sg-pl ind)"
he	Contraction	"PR(he ,)"
him	End	"PR(him ,acc)"
his	End	"PR(his ,gen-ind)"
she	Contraction	"PR(she ,)"
her	End	"PR(her ,acc-gen)"
hers	Contraction	"PR(hers ,ind)"
it	Contraction	"PR(it ,nom-acc)"
its	End	"PR(its ,gen)"
they	Contraction	"PR(they ,pl)"
them	End	"PR(them ,pl acc)"
'em	End	"PR(them ,pl acc)"
their	End	"PR(their ,pl gen)"
theirs	Contraction	"PR(theirs ,pl ind)"
my`self	Contraction	"PR(my`self ,1 rflx)"
one`self	Contraction	"PR(one`self ,rflx)"
your`self	Contraction	"PR(your`self ,2 rflx)"
her`self	Contraction	"PR(her`self ,rflx)"
him`self	Contraction	"PR(him`self ,rflx)"
his`self	Contraction	"PR(his`self - substandard,rflx)"
it`self	Contraction	"PR(it`self ,rflx)"
our`selves	Contraction	"PR(our`selves ,1 pl rflx)"
your`selves	Contraction	"PR(your`selves ,2 pl rflx)"
them`selves	Contraction	"PR(them`selves ,pl rflx)"
'tis	End	"PR(be ,)"
'twas	End	"PR(be ,)"
thou	Contraction	"PR(thou - archaic,2)"
thee	Contraction	"PR(thee ,2 acc)"
thy`self	Contraction	"PR(thy`self ,2 rflx)"
thy	End	"PR(thy ,2 gen)"
thine	Contraction	"PR(thine ,2 ind)"
ye	Contraction	"PR(ye ,2 pl)"
`anybody	Contraction	"PR(`anybody ,)"
`anyone	Contraction	"PR(`anyone ,)"
`anything	Contraction	"PR(`anything ,)"
`everybody	Contraction	"PR(`everybody ,)"
`everyone	Contraction	"PR(`everyone ,)"
`everything	Contraction	"PR(`everything ,)"
`nobody	Contraction	"PR(`nobody ,)"
`nothing	Contraction	"PR(`nothing ,)"
`somebody	Contraction	"PR(`somebody ,)"
`someone	Contraction	"PR(`someone ,)"
`something	Contraction	"PR(`something ,)"

GEN:
+'s	End	"GEN(+GEN - ,)"

CNTR:
+'s	End	"CNTR(+have - ,s)"
+'s	End	"CNTR(+be - ,s)"
+'m	End	"CNTR(+be - ,-3sg)"
+'re	End	"CNTR(+be - ,-3sg)"
+'d	End	"CNTR(+have - ,ed)"
+'d	End	"CNTR(+would - ,modal)"
+'d've	End	"CNTR(+would+have - ,modal -3sg)"
+'ll	End	"CNTR(+will - ,modal ;will)"
+'ll've	End	"CNTR(+will+have - ,modal -3sg)"
+'ve	End	"CNTR(+have - ,-3sg)"

PREFIX:
''	Root	"PREFIX('' ,)"
arch+	Prefix	"PREFIX(DEG1+ - ,n\n)"
co+	Prefix	"PREFIX(DEG2+ - ,deg2)"
hyper+	Prefix	"PREFIX(DEG3+ - ,)"
mini+	Prefix	"PREFIX(DEG4+ - ,n\n)"
maxi+	Prefix	"PREFIX(DEG5+ - ,n\n)"
out+	Prefix	"PREFIX(DEG6+ - ,v\v)"
over+	Prefix	"PREFIX(DEG7+ - ,v-aj\x)"
sub+	Prefix	"PREFIX(DEG8/LOC1+ - ,)"
super+	Prefix	"PREFIX(DEG9/LOC2+ - ,)"
ultra+	Prefix	"PREFIX(DEG11+ - ,)"
under+	Prefix	"PREFIX(DEG12+ - ,)"
micro+	Prefix	"PREFIX(DEG13/NUM22+ - ,n\n)"
macro+	Prefix	"PREFIX(DEG14+ - ,n\n)"
para+	Prefix	"PREFIX(DEG15+ - ,)"
quasi+	Prefix	"PREFIX(DEG16+ - ,aj\aj)"
supra+	Prefix	"PREFIX(DEG17+ - ,aj\aj)"
meta+	Prefix	"PREFIX(DEG18+ - ,)"
omni+	Prefix	"PREFIX(DEG19+ - ,aj\aj)"
anti+	Prefix	"PREFIX(ORI1+ - ,)"
contra+	Prefix	"PREFIX(ORI2+ - ,)"
counter+	Prefix	"PREFIX(ORI3+ - ,)"
pro+	Prefix	"PREFIX(ORI4+ - ,)"
fore+	Prefix	"PREFIX(LOC3/ORD2+ - ,n\n)"
inter+	Prefix	"PREFIX(LOC4+ - ,)"
extra+	Prefix	"PREFIX(LOC6+ - ,aj\aj)"
intra+	Prefix	"PREFIX(LOC7+ - ,aj\aj)"
mid+	Prefix	"PREFIX(LOC9+ - ,)"
circum+	Prefix	"PREFIX(LOC10+ - ,n\n)"
retro+	Prefix	"PREFIX(LOC11+ - ,)"
poly+	Prefix	"PREFIX(NUM3+ - ,)"
multi+	Prefix	"PREFIX(NUM4+ - ,)"
ante+	Prefix	"PREFIX(ORD6+ - ,n\n)"
step+	Prefix	"PREFIX(ORD7+ - ,n\n)"
ex+	Prefix	"PREFIX(ORD1+ - ,n\n)"
post+	Prefix	"PREFIX(ORD3+ - ,)"
pre+	Prefix	"PREFIX(ORD4+ - ,)"
re+	Prefix	"PREFIX(ORD5+ - ,v\v)"
in+	Prefix	"PREFIX(NEG2a+ - ,aj\aj)"
im+	Prefix	"PREFIX(NEG2b+ - ,aj\aj)"
il+	Prefix	"PREFIX(NEG2c+ - ,aj\aj)"
ir+	Prefix	"PREFIX(NEG2d+ - ,aj\aj)"
non+	Prefix	"PREFIX(NEG3+ - ,)"
un+	Prefix	"PREFIX(NEG4+ - ,aj\aj)"
un+	Prefix	"PREFIX(REV1+ - ,v\v rev)"
de+	Prefix	"PREFIX(REV2+ - ,v\v)"
dis+	Prefix	"PREFIX(REV3+ - ,v-aj\x)"
mal+	Prefix	"PREFIX(PEJ1+ - ,v\v)"
mis+	Prefix	"PREFIX(PEJ2+ - ,v\v)"
pseudo+	Prefix	"PREFIX(PEJ3+ - ,)"
bi+	Prefix	"PREFIX(NUM1+ - ,aj\aj)"
di+	Prefix	"PREFIX(NUM2+ - ,)"
semi+	Prefix	"PREFIX(NUM5+ - ,)"
demi+	Prefix	"PREFIX(NUM6+ - ,n\n)"
hemi+	Prefix	"PREFIX(NUM7+ - ,n\n)"
tri+	Prefix	"PREFIX(NUM8+ - ,aj\aj)"
uni+	Prefix	"PREFIX(NUM9+ - ,aj\aj)"
mono+	Prefix	"PREFIX(NUM10+ - ,n\n)"
deka+	Prefix	"PREFIX(NUM11+ - ,n\n)"
hecto+	Prefix	"PREFIX(NUM12+ - ,n\n)"
kilo+	Prefix	"PREFIX(NUM13+ - ,n\n)"
mega+	Prefix	"PREFIX(NUM14+ - ,n\n)"
giga+	Prefix	"PREFIX(NUM15+ - ,n\n)"
tera+	Prefix	"PREFIX(NUM16+ - ,n\n)"
peta+	Prefix	"PREFIX(NUM17+ - ,n\n)"
exa+	Prefix	"PREFIX(NUM18+ - ,n\n)"
deci+	Prefix	"PREFIX(NUM19+ - ,n\n)"
centi+	Prefix	"PREFIX(NUM20+ - ,n\n)"
milli+	Prefix	"PREFIX(NUM21+ - ,n\n)"
nano+	Prefix	"PREFIX(NUM23+ - ,n\n)"
pico+	Prefix	"PREFIX(NUM24+ - ,n\n)"
femto+	Prefix	"PREFIX(NUM25+ - ,n\n)"
atto+	Prefix	"PREFIX(NUM26+ - ,n\n)"
auto+	Prefix	"PREFIX(NEO1+ - ,)"
neo+	Prefix	"PREFIX(NEO2+ - ,)"
paleo+	Prefix	"PREFIX(NEO3+ - ,n\n)"
pan+	Prefix	"PREFIX(NEO4+ - ,)"
proto+	Prefix	"PREFIX(NEO5+ - ,)"
vice+	Prefix	"PREFIX(NEO7+ - ,n\n)"
en+	Prefix	"PREFIX(VR1a+ - ,v\aj-n)"
em+	Prefix	"PREFIX(VR1b+ - ,v\aj-n)"

OD:
`first	Suffix	"OD(`first ,)"
`second	Suffix	"OD(`second ,)"
`third	Suffix	"OD(`third ,)"
`fifth	Suffix	"OD(`fifth ,)"
`eighth	Suffix	"OD(`eighth ,)"
`ninth	Suffix	"OD(`ninth ,)"
`twelfth	Suffix	"OD(`twelfth ,)"
`twelfth	Suffix	"OD(`twelfth ,)"

PN_SUFF:
''	Infl	"PN_SUFF('' ,)"
+er	Clitic	"PN_SUFF(+NR11 - ,n/n)"
+ese	Suffix	"PN_SUFF(+AJR3 - ,n/n-aj)"
+i	Infl	"PN_SUFF(+AJR40 - ,n/n-aj)"
+an	Suffix	"PN_SUFF(+AJR4a - ,n/n-aj)"
+ian	Suffix	"PN_SUFF(+AJR4b - ,n/n-aj)"
+arian	Suffix	"PN_SUFF(+AJR4d - ,n/n-aj)"
+al	Suffix	"PN_SUFF(+AJR17a - ,n/aj ajr17)"
+ial	Suffix	"PN_SUFF(+AJR17b - ,n/aj ajr17)"
+ual	Suffix	"PN_SUFF(+AJR17c - ,n/aj ajr17)"
+ic	IC_Suffix	"PN_SUFF(+AJR20a - ,n/n-aj ajr20)"
+ish	Suffix	"PN_SUFF(+AJR10 - ,n/n-aj)"
+ism	Suffix	"PN_SUFF(+NR8 - ,n/n)"
+ist	Suffix	"PN_SUFF(+NR31 - ,n/n-aj nr31)"
+ite	Suffix	"PN_SUFF(+NR32 - ,n/n-aj)"
+iana	Suffix	"PN_SUFF(+NR36 - ,n/n)"
+man	Suffix	"PN_SUFF(+NR55a - ,n/n)"
+men	Clitic	"PN_SUFF(+NR55b - ,n/n pl)"
+woman	Suffix	"PN_SUFF(+NR56a - ,n/n)"
+women	Clitic	"PN_SUFF(+NR56b - ,n/n pl)"

AJ-AV:
`good	Suffix	"AJ-AV(`good ,)"
`better	Suffix	"AJ-AV(`good ,comp)"
`best	Suffix	"AJ-AV(`good ,super)"
`bad	Suffix	"AJ-AV(`bad ,)"
`worse	Suffix	"AJ-AV(`bad ,comp)"
`worst	Suffix	"AJ-AV(`bad ,super)"
`far	Suffix	"AJ-AV(`far ,)"
`farther	Suffix	"AJ-AV(`far ,comp)"
`farthest	Suffix	"AJ-AV(`far ,super)"
`further	Suffix	"AJ-AV(`far ,comp)"
`furthest	Suffix	"AJ-AV(`far ,super)"
a`go	Suffix	"AJ-AV(a`go ,)"
apro`pos	Suffix	"AJ-AV(apro`pos ,)"
a`skew	Suffix	"AJ-AV(a`skew ,)"
`awful	Suffix	"AJ-AV(`awful ,)"
`awkward	Suffix	"AJ-AV(`awkward ,)"
`big	Suffix	"AJ-AV(`big ,)"
`cheap	Suffix	"AJ-AV(`cheap ,)"
`clear	Suffix	"AJ-AV(`clear ,)"
`crisp	Suffix	"AJ-AV(`crisp ,)"
`daily	Suffix	"AJ-AV(`day ,denom)"
`dexter	Suffix	"AJ-AV(`dexter ,)"
down`stairs	Suffix	"AJ-AV(down`stairs ,)"
down`stream	Suffix	"AJ-AV(down`stream ,)"
`early	Suffix	"AJ-AV(`early ,)"
`easterly	Suffix	"AJ-AV(`easterly ,)"
`easy	Suffix	"AJ-AV(`easy ,)"
`excellent	Suffix	"AJ-AV(`excellent ,)"
`fair	Suffix	"AJ-AV(`fair ,)"
`frank	Suffix	"AJ-AV(`frank ,)"
`funny	Suffix	"AJ-AV(`funny ,)"
`headlong	Suffix	"AJ-AV(`headlong ,)"
`late	Suffix	"AJ-AV(`late ,)"
`loud	Suffix	"AJ-AV(`loud ,)"
`middling	Suffix	"AJ-AV(`middling ,)"
`nice	Suffix	"AJ-AV(`nice ,)"
`nigh	Suffix	"AJ-AV(`nigh ,)"
north`easterly	Suffix	"AJ-AV(north`easterly ,)"
`northerly	Suffix	"AJ-AV(`northerly ,)"
north`westerly	Suffix	"AJ-AV(north`westerly ,)"
OK	Suffix	"AJ-AV(OK ,)"
o`kay	Suffix	"AJ-AV(o`kay ,)"
`only	Suffix	"AJ-AV(`only ,)"
out`doors	Suffix	"AJ-AV(out`doors ,)"
`outright	Suffix	"AJ-AV(`outright ,)"
over`all	Suffix	"AJ-AV(over`all ,)"
`overmuch	Suffix	"AJ-AV(`overmuch ,)"
over`night	Suffix	"AJ-AV(over`night ,)"
over`sea	Suffix	"AJ-AV(over`sea ,)"
over`seas	Suffix	"AJ-AV(over`seas ,)"
`perfect	Suffix	"AJ-AV(`perfect ,)"
`plain	Suffix	"AJ-AV(`plain ,)"
`pleasant	Suffix	"AJ-AV(`pleasant ,)"
`quick	Suffix	"AJ-AV(`quick ,)"
`rapid	Suffix	"AJ-AV(`rapid ,)"
`safe	Suffix	"AJ-AV(`safe ,)"
`severalfold	Suffix	"AJ-AV(`severalfold ,)"
`soft	Suffix	"AJ-AV(`soft ,)"
`southerly	Suffix	"AJ-AV(`southerly ,)"
south`easterly	Suffix	"AJ-AV(south`easterly ,)"
south`westerly	Suffix	"AJ-AV(south`westerly ,)"
`straight	Suffix	"AJ-AV(`straight ,)"
`straightaway	Suffix	"AJ-AV(`straightaway ,)"
`such	Suffix	"AJ-AV(`such ,)"
`sure	Suffix	"AJ-AV(`sure ,)"
up`river	Suffix	"AJ-AV(up`river ,)"
`upscale	Suffix	"AJ-AV(`upscale ,)"
`upstate	Suffix	"AJ-AV(`upstate ,)"
up`stairs	Suffix	"AJ-AV(up`stairs ,)"
up`stream	Suffix	"AJ-AV(up`stream ,)"
`uptown	Suffix	"AJ-AV(`uptown ,)"
up`wind	Suffix	"AJ-AV(up`wind ,)"
ver`batim	Suffix	"AJ-AV(ver`batim ,)"
vi`vace	Suffix	"AJ-AV(vi`vace ,)"
`westerly	Suffix	"AJ-AV(`westerly ,)"
a`beam	End	"AJ-AV(a`beam ,)"
a`borning	End	"AJ-AV(a`borning ,)"
a`boveboard	End	"AJ-AV(a`boveboard ,)"
a`breast	End	"AJ-AV(a`breast ,)"
a`broad	End	"AJ-AV(a`broad ,)"
a`slant	End	"AJ-AV(a`slant ,)"
`counter	End	"AJ-AV(`counter ,)"
`downward	Suffix	"AJ-AV(`downward ,)"
en`route	End	"AJ-AV(en`route ,)"
`forward	Suffix	"AJ-AV(`forward ,)"
`gratis	End	"AJ-AV(`gratis ,)"
`inward	Suffix	"AJ-AV(`inward ,)"
`onward	Suffix	"AJ-AV(`onward ,)"
`outward	Suffix	"AJ-AV(`outward ,)"
pell-`mell	End	"AJ-AV(pell-`mell ,)"
`sideway	End	"AJ-AV(`sideway ,)"
`sideways	End	"AJ-AV(`sideways ,)"
`upward	Suffix	"AJ-AV(`upward ,)"
a-posteriori	End	"AJ-AV(a-posteriori ,)"
a-priori	End	"AJ-AV(a-priori ,)"
ad-hoc	End	"AJ-AV(ad-hoc ,)"
ad-hominem	End	"AJ-AV(ad-hominem ,)"
ad-infinitum	End	"AJ-AV(ad-infinitum ,)"
ad-interim	End	"AJ-AV(ad-interim ,)"
cum-laude	End	"AJ-AV(cum-laude ,)"
de-facto	End	"AJ-AV(de-facto ,)"
de-jure	End	"AJ-AV(de-jure ,)"
ex-officio	End	"AJ-AV(ex-officio ,)"
ex-post-facto	End	"AJ-AV(ex-post-facto ,)"
in-situ	End	"AJ-AV(in-situ ,)"
magna-cum-laude	End	"AJ-AV(magna-cum-laude ,)"
prima-facie	End	"AJ-AV(prima-facie ,)"
summa-cum-laude	End	"AJ-AV(summa-cum-laude ,)"

PT_SUFF:
''	Clitic	"PT_SUFF('' ,)"
+ly	Suffix	"PT_SUFF(+AVR1 - ,aj/av)"
+ness	Suffix	"PT_SUFF(+NR27 - ,aj/n)"
+s	Clitic	"PT_SUFF(+PL - ,n/n pl reg)"

DT-PR:
what	Contraction	"DT-PR(what ,wh)"
what`ever	Contraction	"DT-PR(what`ever ,wh)"
whatso`ever	Contraction	"DT-PR(whatso`ever ,wh)"
which	Contraction	"DT-PR(which ,wh)"
which`ever	Contraction	"DT-PR(which`ever ,wh)"
whichso`ever	Contraction	"DT-PR(whichso`ever ,wh)"
whose	Contraction	"DT-PR(whose ,wh)"
whos`ever	Contraction	"DT-PR(whos`ever ,wh)"
whoseso`ever	Contraction	"DT-PR(whoseso`ever ,wh)"

V:
cal`cine	Suffix	"V(cal`cine ,)"
ca`pacitate	Suffix	"V(ca`pacitate ,)"
cen`trifugate	Suffix	"V(cen`trifugate ,)"
`chemisorb	Suffix	"V(`chemisorb ,)"
`collimate	Suffix	"V(`collimate ,)"
e`lute	Suffix	"V(e`lute ,)"
hy`droxylate	Suffix	"V(hy`droxylate ,)"
`lase	Suffix	"V(`lase ,)"
me`tastasize	Suffix	"V(me`tastasize ,)"
`nutate	Suffix	"V(`nutate ,)"
phospho`resce	Suffix	"V(phospho`resce ,)"
radio`sterilize	Suffix	"V(radio`sterilize ,)"
sa`ponify	Suffix	"V(sa`ponify ,)"
`tessellate	Suffix	"V(`tessellate ,)"
`titrate	Suffix	"V(`titrate ,)"
a`bide	Suffix	"V(a`bide ,)"
a`bode	End	"V(a`bide ,ed irreg)"
a`bode	PT_Suffix	"V(a`bide ,en irreg)"
a`rise	Suffix	"V(a`rise ,irreg)"
a`rose	End	"V(a`rise ,ed irreg)"
a`risen	PT_Suffix	"V(a`rise ,en irreg)"
a`wake	Suffix	"V(a`wake ,)"
a`woke	End	"V(a`wake ,ed irreg)"
a`woken	PT_Suffix	"V(a`wake ,en irreg)"
`babysit	Suffix	"V(`babysit ,irreg)"
`babysat	End	"V(`babysit ,ed irreg)"
`babysat	PT_Suffix	"V(`babysit ,en irreg)"
`bear	Suffix	"V(`bear ,irreg)"
`bore	End	"V(`bear ,ed irreg)"
`borne	PT_Suffix	"V(`bear ,en irreg)"
`beat	Suffix	"V(`beat ,irreg)"
`beat	End	"V(`beat ,ed irreg)"
`beat	PT_Suffix	"V(`beat ,en irreg)"
`beaten	PT_Suffix	"V(`beat ,en irreg)"
be`come	Suffix	"V(be`come ,irreg)"
be`came	End	"V(be`come ,ed irreg)"
be`come	PT_Suffix	"V(be`come ,en irreg)"
be`fall	Suffix	"V(be`fall ,irreg)"
be`fell	End	"V(`fall ,ed irreg)"
be`fallen	PT_Suffix	"V(`fall ,en irreg)"
be`get	Suffix	"V(be`get ,irreg)"
be`got	End	"V(be`get ,ed irreg)"
be`gat	End	"V(be`get ,ed irreg)"
be`gotten	PT_Suffix	"V(be`get ,en irreg)"
be`gin	Suffix	"V(be`gin ,irreg)"
be`gan	End	"V(be`gin ,ed irreg)"
be`gun	PT_Suffix	"V(be`gin ,en irreg)"
be`gird	Suffix	"V(be`gird ,)"
be`girt	End	"V(be`gird - does this ever occur in ed irreg tense?,ed irreg)"
be`girt	PT_Suffix	"V(be`gird ,en irreg)"
be`hold	Suffix	"V(be`hold ,irreg)"
be`held	End	"V(be`hold ,ed irreg)"
be`held	PT_Suffix	"V(be`hold ,en irreg)"
`bent	End	"V(`bend ,ed irreg rev)"
`bent	PT_Suffix	"V(`bend ,en irreg rev)"
be`reave	Suffix	"V(be`reave ,)"
be`reft	End	"V(be`reave ,ed irreg)"
be`reft	PT_Suffix	"V(be`reave ,en irreg)"
be`seech	Suffix	"V(be`seech ,)"
be`sought	End	"V(be`seech ,ed irreg)"
be`sought	PT_Suffix	"V(be`seech ,en irreg)"
be`set	Suffix	"V(be`set ,irreg)"
be`set	End	"V(be`set ,ed irreg)"
be`set	PT_Suffix	"V(be`set ,en irreg)"
be`speak	Suffix	"V(be`speak ,irreg)"
be`spoke	End	"V(`stride ,ed irreg)"
be`spoken	PT_Suffix	"V(`stride ,en irreg)"
be`stride	Suffix	"V(be`stride ,irreg)"
be`strode	End	"V(`stride ,ed irreg)"
be`strode	PT_Suffix	"V(`stride ,en irreg)"
be`stridden	PT_Suffix	"V(`stride ,en irreg)"
be`strid	PT_Suffix	"V(`stride ,en irreg)"
`bet	End	"V(`bet - see noun bet,ed irreg)"
`bet	PT_Suffix	"V(`bet ,en irreg)"
be`take	Suffix	"V(be`take ,irreg)"
be`took	End	"V(`take ,ed irreg)"
be`taken	PT_Suffix	"V(`take ,en irreg)"
be`think	Suffix	"V(be`think ,irreg)"
be`thought	End	"V(`think ,ed irreg)"
be`thought	PT_Suffix	"V(`think ,en irreg)"
`bid	Suffix	"V(`bid ,irreg)"
`bid	End	"V(`bid ,ed irreg)"
`bid	PT_Suffix	"V(`bid ,en irreg)"
`bade	PT_Suffix	"V(`bid ,ed irreg)"
`bad	End	"V(`bid ,ed irreg)"
`bade	PT_Suffix	"V(`bid ,en irreg)"
`bidden	PT_Suffix	"V(`bid ,en irreg)"
`bind	Suffix	"V(`bind ,irreg rev)"
`bound	End	"V(`bind ,ed irreg rev)"
`bound	PT_Suffix	"V(`bind ,en irreg rev)"
`bite	Suffix	"V(`bite ,irreg)"
`bit	End	"V(`bite ,ed irreg)"
`bit	PT_Suffix	"V(`bite ,en irreg)"
`bitten	PT_Suffix	"V(`bite ,en irreg)"
`bleed	Suffix	"V(`bleed ,irreg)"
`bled	End	"V(`bleed ,ed irreg)"
`bled	PT_Suffix	"V(`bleed ,en irreg)"
`blow	Suffix	"V(`blow ,irreg)"
`blew	End	"V(`blow ,ed irreg)"
`blown	PT_Suffix	"V(`blow ,en irreg)"
`break	Suffix	"V(`break ,irreg)"
`broke	End	"V(`break ,ed irreg)"
`broken	PT_Suffix	"V(`break ,en irreg)"
`breed	Suffix	"V(`breed ,irreg)"
`bred	End	"V(`breed ,ed irreg)"
`bred	PT_Suffix	"V(`breed ,en irreg)"
`bring	Suffix	"V(`bring ,irreg)"
`brought	End	"V(`bring ,ed irreg)"
`brought	PT_Suffix	"V(`bring ,en irreg)"
`broadcast	End	"V(`broadcast ,ed irreg)"
`broadcast	PT_Suffix	"V(`broadcast ,en irreg)"
`browbeat	Suffix	"V(`browbeat ,irreg)"
`browbeat	End	"V(`browbeat ,ed irreg)"
`browbeat	PT_Suffix	"V(`browbeat ,en irreg)"
`browbeaten	PT_Suffix	"V(`browbeat ,en irreg)"
`build	Suffix	"V(`build ,irreg rev)"
`built	End	"V(`build ,ed irreg rev)"
`built	PT_Suffix	"V(`build ,en irreg rev)"
`burnt	End	"V(`burn ,ed irreg)"
`burnt	PT_Suffix	"V(`burn ,en irreg)"
`burst	Suffix	"V(`burst ,irreg)"
`burst	End	"V(`burst ,ed irreg)"
`burst	PT_Suffix	"V(`burst ,en irreg)"
`bust	Suffix	"V(`bust ,)"
`bust	End	"V(`bust ,ed irreg)"
`bust	PT_Suffix	"V(`bust ,en irreg)"
`buy	Suffix	"V(`buy ,irreg)"
`bought	End	"V(`buy ,ed irreg)"
`bought	PT_Suffix	"V(`buy ,en irreg)"
`cast	End	"V(`cast ,ed irreg)"
`cast	PT_Suffix	"V(`cast ,en irreg)"
`catch	Suffix	"V(`catch ,irreg)"
`caught	End	"V(`catch ,ed irreg)"
`caught	PT_Suffix	"V(`catch ,en irreg)"
`chide	Suffix	"V(`chide ,)"
`chid	End	"V(`chide ,ed irreg)"
`chid	PT_Suffix	"V(`chide ,en irreg)"
`chidden	PT_Suffix	"V(`chide ,en irreg)"
`choose	Suffix	"V(`choose ,irreg)"
`chose	End	"V(`choose ,ed irreg)"
`chosen	PT_Suffix	"V(`choose ,en irreg)"
`cleave	Suffix	"V(`cleave ,)"
`cleft	End	"V(`cleave ,ed irreg)"
`cleft	PT_Suffix	"V(`cleave ,en irreg)"
`clove	End	"V(`cleave ,ed irreg)"
`cloven	PT_Suffix	"V(`cleave ,en irreg)"
`cling	Suffix	"V(`cling ,irreg)"
`clung	End	"V(`cling ,ed irreg)"
`clung	PT_Suffix	"V(`cling ,en irreg)"
`come	Suffix	"V(`come ,irreg)"
`came	End	"V(`come ,ed irreg)"
`camest	End	"V(`come ,ed irreg)"
`come	PT_Suffix	"V(`come ,en irreg)"
`cost	End	"V(`cost - see noun `cost,ed irreg)"
`cost	PT_Suffix	"V(`cost ,en irreg)"
`creep	Suffix	"V(`creep ,)"
`crept	End	"V(`creep ,ed irreg)"
`crept	PT_Suffix	"V(`creep ,en irreg)"
`cut	Suffix	"V(`cut ,irreg)"
`cut	End	"V(`cut ,ed irreg)"
`cut	PT_Suffix	"V(`cut ,en irreg)"
`durst	PT_Suffix	"V(`dare ,en irreg)"
`dealt	End	"V(`deal ,ed irreg)"
`dealt	PT_Suffix	"V(`deal ,en irreg)"
deep`freeze	Suffix	"V(deep`freeze ,irreg)"
deep`froze	End	"V(deep`freeze ,ed irreg)"
deep`frozen	PT_Suffix	"V(deep`freeze ,en irreg)"
`dig	Suffix	"V(`dig ,irreg)"
`dug	End	"V(`dig ,ed irreg)"
`dug	PT_Suffix	"V(`dig ,en irreg)"
`dove	End	"V(`dive ,ed irreg)"
do	End	"V(do - DO as a full verb can take prefixes,rev)"
does	End	"V(do ,s rev)"
`doing	PT_Suffix	"V(do ,ing rev)"
did	End	"V(do ,ed irreg rev)"
done	PT_Suffix	"V(do ,en irreg rev)"
`draw	Suffix	"V(`draw ,irreg rev)"
`drew	End	"V(`draw ,ed irreg rev)"
`drawn	PT_Suffix	"V(`draw ,en irreg rev)"
`dreamt	End	"V(`dream ,ed irreg)"
`dreamt	PT_Suffix	"V(`dream ,en irreg)"
`drink	Suffix	"V(`drink ,irreg)"
`drank	End	"V(`drink ,ed irreg)"
`drunk	PT_Suffix	"V(`drink ,en irreg)"
`drive	Suffix	"V(`drive ,irreg)"
`drove	End	"V(`drive ,ed irreg)"
`driven	PT_Suffix	"V(`drive ,en irreg)"
`dwell	Suffix	"V(`dwell ,)"
`dwelt	End	"V(`dwell ,ed irreg)"
`dwelt	PT_Suffix	"V(`dwell ,en irreg)"
`eat	Suffix	"V(`eat ,irreg)"
`ate	End	"V(`eat ,ed irreg)"
`eaten	PT_Suffix	"V(`eat ,en irreg)"
`fall	Suffix	"V(`fall ,irreg)"
`fell	End	"V(`fall ,ed irreg)"
`fallen	PT_Suffix	"V(`fall ,en irreg)"
`feed	Suffix	"V(`feed ,irreg)"
`fed	End	"V(`feed ,ed irreg)"
`fed	PT_Suffix	"V(`feed ,en irreg)"
`feel	Suffix	"V(`feel ,irreg)"
`felt	End	"V(`feel ,ed irreg)"
`felt	PT_Suffix	"V(`feel ,en irreg)"
`fight	Suffix	"V(`fight ,irreg)"
`fought	End	"V(`fight ,ed irreg)"
`fought	PT_Suffix	"V(`fight ,en irreg)"
`find	Suffix	"V(`find ,irreg)"
`found	End	"V(`find ,ed irreg)"
`found	PT_Suffix	"V(`find ,en irreg)"
`fit	End	"V(`fit ,ed irreg)"
`fit	PT_Suffix	"V(`fit ,en irreg)"
`flee	Suffix	"V(`flee ,irreg)"
`fled	End	"V(`flee ,ed irreg)"
`fled	PT_Suffix	"V(`flee ,en irreg)"
`fling	Suffix	"V(`fling ,)"
`flung	End	"V(`fling ,ed irreg)"
`flung	PT_Suffix	"V(`fling ,en irreg)"
`fly	Suffix	"V(`fly ,irreg)"
`flew	End	"V(`fly ,ed irreg)"
`flown	PT_Suffix	"V(`fly ,en irreg)"
for`bear	Suffix	"V(for`bear ,irreg)"
for`bore	End	"V(for`bear ,ed irreg)"
for`borne	PT_Suffix	"V(for`bear ,en irreg)"
for`bid	Suffix	"V(for`bid ,irreg)"
for`bade	End	"V(for`bid ,ed irreg)"
for`bad	End	"V(for`bid ,ed irreg)"
for`bidden	PT_Suffix	"V(for`bid ,en irreg)"
for`bid	PT_Suffix	"V(for`bid ,en irreg)"
`forecast	Suffix	"V(`forecast ,)"
`forecast	End	"V(`forecast ,ed irreg)"
`forecast	PT_Suffix	"V(`forecast ,en irreg)"
fore`see	Suffix	"V(fore`see ,irreg)"
fore`saw	End	"V(fore`see ,ed irreg)"
fore`seen	PT_Suffix	"V(fore`see ,en irreg)"
fore`tell	Suffix	"V(fore`tell ,irreg)"
fore`told	End	"V(fore`tell ,ed irreg)"
fore`told	PT_Suffix	"V(fore`tell ,en irreg)"
for`get	Suffix	"V(for`get ,irreg)"
for`got	End	"V(for`get ,ed irreg)"
for`got	PT_Suffix	"V(for`get ,en irreg)"
for`gotten	PT_Suffix	"V(for`get ,en irreg)"
for`give	Suffix	"V(for`give ,irreg)"
for`gave	End	"V(for`give ,ed irreg)"
for`given	PT_Suffix	"V(for`give ,en irreg)"
for`go	Suffix	"V(for`go ,irreg)"
for`went	End	"V(for`go ,ed irreg)"
for`gone	PT_Suffix	"V(for`go ,en irreg)"
for`sake	Suffix	"V(for`sake ,irreg)"
for`sook	End	"V(for`sake ,ed irreg)"
for`saken	PT_Suffix	"V(for`sake ,en irreg)"
for`swear	Suffix	"V(for`swear ,irreg)"
for`swore	End	"V(for`swear ,ed irreg)"
for`sworn	PT_Suffix	"V(for`swear ,en irreg)"
`freeze	Suffix	"V(`freeze ,irreg rev)"
`froze	End	"V(`freeze ,ed irreg rev)"
`frozen	PT_Suffix	"V(`freeze ,en irreg rev)"
`frostbite	Suffix	"V(`frostbite ,irreg)"
`frostbit	End	"V(`frostbite ,ed irreg)"
`frostbitten	PT_Suffix	"V(`frostbite ,en irreg)"
`gainsay	Suffix	"V(`gainsay ,irreg)"
`gainsaid	End	"V(`gainsay ,ed irreg)"
`gainsaid	PT_Suffix	"V(`gainsay ,en irreg)"
`get	Suffix	"V(`get ,irreg)"
`got	End	"V(`get ,ed irreg)"
`got	PT_Suffix	"V(`get ,en irreg)"
`gotten	PT_Suffix	"V(`get ,en irreg)"
`ghostwrite	Suffix	"V(`ghostwrite ,irreg)"
`ghostwrote	End	"V(`ghostwrite ,ed irreg)"
`ghostwritten	PT_Suffix	"V(`ghostwrite ,en irreg)"
`gird	Suffix	"V(`gird ,rev)"
`girt	End	"V(`gird ,ed irreg rev)"
`girt	PT_Suffix	"V(`gird ,en irreg rev)"
`give	Suffix	"V(`give ,irreg)"
`gave	End	"V(`give ,ed irreg)"
`gavest	End	"V(`give ,ed irreg)"
`given	PT_Suffix	"V(`give ,en irreg)"
`go	Suffix	"V(`go ,irreg)"
`went	PT_Suffix	"V(`go ,ed irreg)"
`gone	PT_Suffix	"V(`go ,en irreg)"
`grind	Suffix	"V(`grind ,irreg)"
`ground	End	"V(`grind ,ed irreg)"
`ground	PT_Suffix	"V(`grind ,en irreg)"
`grow	Suffix	"V(`grow ,irreg)"
`grew	PT_Suffix	"V(`grow ,ed irreg)"
`grown	PT_Suffix	"V(`grow ,en irreg)"
`hamstring	Suffix	"V(`hamstring ,irreg)"
`hamstrung	End	"V(`hamstring ,ed irreg)"
`hamstrung	PT_Suffix	"V(`hamstring ,en irreg)"
`handwrite	Suffix	"V(`handwrite ,irreg)"
`handwrote	End	"V(`handwrite ,ed irreg)"
`handwritten	PT_Suffix	"V(`handwrite ,en irreg)"
`hang	Suffix	"V(`hang ,)"
`hung	End	"V(`hang ,ed irreg)"
`hung	PT_Suffix	"V(`hang ,en irreg)"
`hear	Suffix	"V(`hear ,irreg)"
`heard	End	"V(`hear ,ed irreg)"
`heard	PT_Suffix	"V(`hear ,en irreg)"
`heave	Suffix	"V(`heave ,)"
`hove	End	"V(`heave ,ed irreg)"
`hove	PT_Suffix	"V(`heave ,en irreg)"
`hew	Suffix	"V(`hew ,)"
`hewn	PT_Suffix	"V(`hew ,en irreg)"
`hide	Suffix	"V(`hide ,irreg)"
`hid	End	"V(`hide ,ed irreg)"
`hid	PT_Suffix	"V(`hide ,en irreg)"
`hidden	PT_Suffix	"V(`hide ,en irreg)"
`hit	Suffix	"V(`hit ,irreg)"
`hit	End	"V(`hit ,ed irreg)"
`hit	PT_Suffix	"V(`hit ,en irreg)"
`hold	Suffix	"V(`hold ,irreg)"
`held	End	"V(`hold ,ed irreg)"
`held	PT_Suffix	"V(`hold ,en irreg)"
`housebreak	Suffix	"V(`housebreak ,irreg)"
`housebroke	End	"V(`housebreak ,ed irreg)"
`housebroken	PT_Suffix	"V(`housebreak ,en irreg)"
`hurt	Suffix	"V(`hurt ,irreg)"
`hurt	End	"V(`hurt ,ed irreg)"
`hurt	PT_Suffix	"V(`hurt ,en irreg)"
`inbreed	Suffix	"V(`inbreed ,irreg)"
`inbred	End	"V(`inbreed ,ed irreg)"
`inbred	PT_Suffix	"V(`inbreed ,en irreg)"
`inset	Suffix	"V(`inset ,irreg)"
`inset	End	"V(`inset ,ed irreg)"
`inset	PT_Suffix	"V(`inset ,en irreg)"
`keep	Suffix	"V(`keep ,irreg)"
`kept	End	"V(`keep ,ed irreg)"
`kept	PT_Suffix	"V(`keep ,en irreg)"
`kneel	Suffix	"V(`kneel ,)"
`knelt	PT_Suffix	"V(`kneel ,en irreg)"
`knelt	End	"V(`kneel ,ed irreg)"
`knit	Suffix	"V(`knit ,rev)"
`knit	End	"V(`knit ,ed irreg rev)"
`knit	PT_Suffix	"V(`knit ,en irreg rev)"
`know	Suffix	"V(`know ,irreg)"
`knew	End	"V(`know ,ed irreg)"
`known	PT_Suffix	"V(`know ,en irreg)"
`lay	Suffix	"V(`lay ,)"
`laid	End	"V(`lay ,ed irreg)"
`laid	PT_Suffix	"V(`lay ,en irreg)"
`lead	Suffix	"V(`lead ,irreg)"
`led	End	"V(`lead ,ed irreg)"
`led	PT_Suffix	"V(`lead ,en irreg)"
`lean	Suffix	"V(`lean ,)"
`leant	End	"V(`lean ,ed irreg)"
`leant	PT_Suffix	"V(`lean ,en irreg)"
`leapt	End	"V(`leap ,ed irreg)"
`leapt	PT_Suffix	"V(`leap ,en irreg)"
`learn	Suffix	"V(`learn ,rev)"
`learnt	End	"V(`learn ,ed irreg rev)"
`learnt	PT_Suffix	"V(`learn ,en irreg rev)"
`leave	Suffix	"V(`leave ,irreg)"
`left	End	"V(`leave ,ed irreg)"
`left	PT_Suffix	"V(`leave ,en irreg)"
`lend	Suffix	"V(`lend ,irreg)"
`lent	End	"V(`lend ,ed irreg)"
`lent	PT_Suffix	"V(`lend ,en irreg)"
`let	Suffix	"V(`let ,irreg)"
`let	End	"V(`let ,ed irreg)"
`let	PT_Suffix	"V(`let ,en irreg)"
`let's	End	"V(let+us ,)"
`lie	Suffix	"V(`lie ,irreg)"
`lay	End	"V(`lie ,ed irreg)"
`lain	PT_Suffix	"V(`lie ,en irreg)"
`lit	End	"V(`light - see noun `light,ed irreg)"
`lit	PT_Suffix	"V(`light ,en irreg)"
`lipread	Suffix	"V(`lipread ,irreg)"
`lipread	End	"V(`lipread ,ed irreg)"
`lipread	PT_Suffix	"V(`lipread ,en irreg)"
`lose	Suffix	"V(`lose ,irreg)"
`lost	PT_Suffix	"V(`lose ,ed irreg)"
`lost	PT_Suffix	"V(`lose ,en irreg)"
`make	Suffix	"V(`make ,irreg rev)"
`made	End	"V(`make ,ed irreg rev)"
`made	PT_Suffix rev	"V(`make ,en irreg)"
`madest	End	"V(`make ,ed irreg)"
`madest	PT_Suffix	"V(`make ,en irreg)"
`mean	Suffix	"V(`mean ,irreg)"
`meant	End	"V(`mean ,ed irreg)"
`meant	PT_Suffix	"V(`mean ,en irreg)"
`meet	Suffix	"V(`meet ,irreg)"
`met	End	"V(`meet ,ed irreg)"
`met	PT_Suffix	"V(`meet ,en irreg)"
me`think	Suffix	"V(me`think ,irreg)"
me`thought	End	"V(me`think ,ed irreg)"
`mow	Suffix	"V(`mow ,)"
`mown	PT_Suffix	"V(`mow ,en irreg)"
off`set	Suffix	"V(off`set ,irreg)"
off`set	PT_Suffix	"V(off`set ,en irreg)"
off`set	End	"V(off`set ,ed irreg)"
par`take	Suffix	"V(par`take ,irreg)"
par`took	End	"V(par`take ,ed irreg)"
par`taken	PT_Suffix	"V(par`take ,en irreg)"
`pay	Suffix	"V(`pay ,irreg)"
`paid	End	"V(`pay ,ed irreg)"
`paid	PT_Suffix	"V(`pay ,en irreg)"
`plead	Suffix	"V(`plead ,)"
`pled	End	"V(`plead ,ed irreg)"
`pled	PT_Suffix	"V(`plead ,en irreg)"
`proofread	Suffix	"V(`proofread ,irreg)"
`proofread	End	"V(`proofread ,ed irreg)"
`proofread	PT_Suffix	"V(`proofread ,en irreg)"
`prove	Suffix	"V(`prove ,)"
`proven	PT_Suffix	"V(`prove ,en irreg)"
`put	Suffix	"V(`put ,irreg)"
`put	End	"V(`put ,ed irreg)"
`put	PT_Suffix	"V(`put ,en irreg)"
`quit	Suffix	"V(`quit ,)"
`quit	End	"V(`quit ,ed irreg)"
`quit	PT_Suffix	"V(`quit ,en irreg)"
`quoth	End	"V(`quoth ,ed irreg)"
`quoth	PT_Suffix	"V(`quoth ,en irreg)"
`read	Suffix	"V(`read ,irreg)"
`read	End	"V(`read ,ed irreg)"
`read	PT_Suffix	"V(`read ,en irreg)"
`rid	Suffix	"V(`rid ,)"
`rid	End	"V(`rid ,ed irreg)"
`rid	PT_Suffix	"V(`rid ,en irreg)"
`ride	Suffix	"V(`ride ,irreg)"
`rode	End	"V(`ride ,ed irreg)"
`ridden	PT_Suffix	"V(`ride ,en irreg)"
`ring	Suffix	"V(`ring ,irreg)"
`rang	End	"V(`ring ,ed irreg)"
`rung	End	"V(`ring ,ed irreg)"
`rung	PT_Suffix	"V(`ring ,en irreg)"
`rise	Suffix	"V(`rise ,irreg)"
`rose	End	"V(`rise ,ed irreg)"
`risen	PT_Suffix	"V(`rise ,en irreg)"
`rive	Suffix	"V(`rive ,)"
`riven	Suffix	"V(`rive ,en irreg)"
`run	Suffix	"V(`run ,irreg)"
`ran	End	"V(`run ,ed irreg)"
`run	PT_Suffix	"V(`run ,en irreg)"
`sawn	PT_Suffix	"V(`saw - see noun `saw,en irreg)"
`say	Suffix	"V(`say ,irreg rev)"
`said	End	"V(`say ,ed irreg rev)"
`said	PT_Suffix rev	"V(`say ,en irreg)"
`saith	End	"V(`say ,)"
`see	Suffix	"V(`see ,irreg)"
`saw	End	"V(`see ,ed irreg)"
`seen	PT_Suffix	"V(`see ,en irreg)"
`seek	Suffix	"V(`seek ,irreg)"
`sought	End	"V(`seek ,ed irreg)"
`sought	PT_Suffix	"V(`seek ,en irreg)"
`sell	Suffix	"V(`sell ,irreg rev)"
`sold	End	"V(`sell ,ed irreg rev)"
`sold	PT_Suffix rev	"V(`sell ,en irreg)"
`send	Suffix	"V(`send ,irreg)"
`sent	End	"V(`send ,ed irreg)"
`sent	PT_Suffix	"V(`send ,en irreg)"
`set	Suffix	"V(`set ,irreg)"
`set	End	"V(`set ,ed irreg)"
`set	PT_Suffix	"V(`set ,en irreg)"
`sew	Suffix	"V(`sew ,rev)"
`sewn	PT_Suffix	"V(`sew ,en irreg rev)"
`shake	Suffix	"V(`shake ,irreg)"
`shook	End	"V(`shake ,ed irreg)"
`shaken	PT_Suffix	"V(`shake ,en irreg)"
`shaven	PT_Suffix	"V(`shave ,en irreg)"
`shear	Suffix	"V(`shear ,)"
`shorn	PT_Suffix	"V(`shear ,en irreg)"
`shed	Suffix	"V(`shed ,)"
`shed	End	"V(`shed ,ed irreg)"
`shed	PT_Suffix	"V(`shed ,en irreg)"
`shone	End	"V(`shine ,ed irreg)"
`shone	PT_Suffix	"V(`shine ,en irreg)"
`shod	End	"V(`shoe - see noun `shoe,ed irreg)"
`shod	PT_Suffix	"V(`shoe ,en irreg)"
`shoot	Suffix	"V(`shoot ,irreg)"
`shot	End	"V(`shoot ,ed irreg)"
`shot	PT_Suffix	"V(`shoot ,en irreg)"
`show	Suffix	"V(`show ,)"
`shown	PT_Suffix	"V(`show ,en irreg)"
`shew	Suffix	"V(`shew ,)"
`shewn	PT_Suffix	"V(`shew ,en irreg)"
`shred	End	"V(`shred ,ed irreg)"
`shred	PT_Suffix	"V(`shred ,en irreg)"
`shrink	Suffix	"V(`shrink ,irreg)"
`shrank	End	"V(`shrink ,ed irreg)"
`shrunk	End	"V(`shrink ,ed irreg)"
`shrunk	PT_Suffix	"V(`shrink ,en irreg)"
`shrive	Suffix	"V(`shrive ,)"
`shrove	End	"V(`shrive ,ed irreg)"
`shriven	PT_Suffix	"V(`shrive ,en irreg)"
`shut	Suffix	"V(`shut ,irreg)"
`shut	End	"V(`shut ,ed irreg)"
`shut	PT_Suffix	"V(`shut ,en irreg)"
`sing	Suffix	"V(`sing ,irreg)"
`sang	End	"V(`sing ,ed irreg)"
`sung	End	"V(`sing ,ed irreg)"
`sung	PT_Suffix	"V(`sing ,en irreg)"
`sink	Suffix	"V(`sink ,irreg)"
`sank	End	"V(`sink ,ed irreg)"
`sunk	End	"V(`sink ,ed irreg)"
`sunk	PT_Suffix	"V(`sink ,en irreg)"
`sit	Suffix	"V(`sit ,irreg)"
`sat	End	"V(`sit ,ed irreg)"
`sat	PT_Suffix	"V(`sit ,en irreg)"
`slay	Suffix	"V(`slay ,irreg)"
`slew	End	"V(`slay ,ed irreg)"
`slain	PT_Suffix	"V(`slay ,en irreg)"
`sleep	Suffix	"V(`sleep ,irreg)"
`slept	End	"V(`sleep ,ed irreg)"
`slept	PT_Suffix	"V(`sleep ,en irreg)"
`slide	Suffix	"V(`slide ,irreg)"
`slid	End	"V(`slide ,ed irreg)"
`slid	PT_Suffix	"V(`slide ,en irreg)"
`sling	Suffix	"V(`sling ,rev)"
`slung	End	"V(`sling ,ed irreg rev)"
`slung	PT_Suffix	"V(`sling ,en irreg rev)"
`slink	Suffix	"V(`slink ,)"
`slunk	End	"V(`slink ,ed irreg)"
`slunk	PT_Suffix	"V(`slink ,en irreg)"
`slit	Suffix	"V(`slit ,irreg)"
`slit	End	"V(`slit ,ed irreg)"
`slit	PT_Suffix	"V(`slit ,en irreg)"
`smelt	End	"V(`smell ,ed irreg)"
`smelt	PT_Suffix	"V(`smell ,en irreg)"
`smite	Suffix	"V(`smite ,irreg)"
`smote	End	"V(`smite ,ed irreg)"
`smitten	PT_Suffix	"V(`smite ,en irreg)"
`sow	Suffix	"V(`sow ,)"
`sown	PT_Suffix	"V(`sow ,en irreg)"
`speak	Suffix	"V(`speak ,irreg)"
`spoke	End	"V(`speak ,ed irreg)"
`spoken	PT_Suffix	"V(`speak ,en irreg)"
`spake	End	"V(`speak ,ed irreg)"
`sped	End	"V(`speed - see noun `speed,ed irreg)"
`sped	PT_Suffix	"V(`speed ,en irreg)"
`spell	Suffix	"V(`spell ,)"
`spelt	End	"V(`spell ,ed irreg)"
`spelt	PT_Suffix	"V(`spell ,en irreg)"
`spend	Suffix	"V(`spend ,irreg)"
`spent	End	"V(`spend ,ed irreg)"
`spent	PT_Suffix	"V(`spend ,en irreg)"
`spilt	End	"V(`spill ,ed irreg)"
`spilt	PT_Suffix	"V(`spill ,en irreg)"
`span	End	"V(`spin ,ed irreg)"
`spun	End	"V(`spin ,ed irreg)"
`spun	PT_Suffix	"V(`spin ,en irreg)"
`spit	Suffix	"V(`spit ,irreg)"
`spit	End	"V(`spit ,ed irreg)"
`spit	PT_Suffix	"V(`spit ,en irreg)"
`spat	End	"V(`spit ,ed irreg)"
`spat	PT_Suffix	"V(`spit ,en irreg)"
`split	Suffix	"V(`split ,irreg)"
`split	End	"V(`split ,ed irreg)"
`split	PT_Suffix	"V(`split ,en irreg)"
`spoil	Suffix	"V(`spoil ,)"
`spoilt	End	"V(`spoil ,ed irreg)"
`spoilt	PT_Suffix	"V(`spoil ,en irreg)"
`spread	Suffix	"V(`spread ,irreg)"
`spread	End	"V(`spread ,ed irreg)"
`spread	End	"V(`spread ,ed irreg)"
`spread	PT_Suffix	"V(`spread ,en irreg)"
`spring	Suffix	"V(`spring ,irreg)"
`sprang	End	"V(`spring ,ed irreg)"
`sprung	End	"V(`spring ,ed irreg)"
`sprung	PT_Suffix	"V(`spring ,en irreg)"
`stand	Suffix	"V(`stand ,irreg)"
`stood	End	"V(`stand ,ed irreg)"
`stood	PT_Suffix	"V(`stand ,en irreg)"
`steal	Suffix	"V(`steal ,irreg)"
`stole	End	"V(`steal ,ed irreg)"
`stolen	PT_Suffix	"V(`steal ,en irreg)"
`stick	Suffix	"V(`stick ,irreg rev)"
`stuck	End	"V(`stick ,ed irreg rev)"
`stuck	PT_Suffix	"V(`stick ,en irreg rev)"
`stung	End	"V(`sting ,ed irreg)"
`stung	PT_Suffix	"V(`sting ,en irreg)"
`stank	End	"V(`stink ,ed irreg)"
`stunk	End	"V(`stink ,ed irreg)"
`stunk	PT_Suffix	"V(`stink ,en irreg)"
`strew	Suffix	"V(`strew ,)"
`strewn	PT_Suffix	"V(`strew ,en irreg)"
`stride	Suffix	"V(`stride ,)"
`strode	End	"V(`stride ,ed irreg)"
`strode	PT_Suffix	"V(`stride ,en irreg)"
`stridden	PT_Suffix	"V(`stride ,en irreg)"
`strid	PT_Suffix	"V(`stride ,en irreg)"
`strike	Suffix	"V(`strike ,irreg)"
`struck	End	"V(`strike ,ed irreg)"
`struck	PT_Suffix	"V(`strike ,en irreg)"
`stricken	PT_Suffix	"V(`strike ,en irreg)"
`string	Suffix	"V(`string ,irreg rev)"
`strung	End	"V(`string ,ed irreg rev)"
`strung	PT_Suffix	"V(`string ,en irreg rev)"
`strive	Suffix	"V(`strive ,)"
`strove	End	"V(`strive ,ed irreg)"
`striven	PT_Suffix	"V(`strive ,en irreg)"
`swear	Suffix	"V(`swear ,irreg rev)"
`swore	End	"V(`swear ,ed irreg rev)"
`sworn	PT_Suffix	"V(`swear ,en irreg rev)"
`sware	End	"V(`swear ,ed irreg)"
`sweat	Suffix	"V(`sweat ,)"
`sweat	End	"V(`sweat ,ed irreg)"
`sweat	PT_Suffix	"V(`sweat ,en irreg)"
`sweep	Suffix	"V(`sweep ,irreg)"
`swept	End	"V(`sweep ,ed irreg)"
`swept	PT_Suffix	"V(`sweep ,en irreg)"
`swell	Suffix	"V(`swell ,)"
`swollen	PT_Suffix	"V(`swell ,en irreg)"
`swim	Suffix	"V(`swim ,irreg)"
`swam	End	"V(`swim ,ed irreg)"
`swum	End	"V(`swim ,ed irreg)"
`swum	PT_Suffix	"V(`swim ,en irreg)"
`swing	Suffix	"V(`swing ,irreg)"
`swung	End	"V(`swing ,ed irreg)"
`swung	PT_Suffix	"V(`swing ,en irreg)"
`take	Suffix	"V(`take ,irreg)"
`took	End	"V(`take ,ed irreg)"
`taken	PT_Suffix	"V(`take ,en irreg)"
`teach	Suffix	"V(`teach ,irreg rev)"
`taught	End	"V(`teach ,ed irreg rev)"
`taught	PT_Suffix	"V(`teach ,en irreg rev)"
`tear	Suffix	"V(`tear ,irreg)"
`tore	End	"V(`tear ,ed irreg)"
`torn	PT_Suffix	"V(`tear ,en irreg)"
`telecast	Suffix	"V(`telecast ,irreg)"
`telecast	End	"V(`telecast ,ed irreg)"
`telecast	PT_Suffix	"V(`telecast ,en irreg)"
`tell	Suffix	"V(`tell ,irreg)"
`told	End	"V(`tell ,ed irreg)"
`told	PT_Suffix	"V(`tell ,en irreg)"
`think	Suffix	"V(`think ,irreg rev)"
`thought	End	"V(`think ,ed irreg rev)"
`thought	PT_Suffix	"V(`think ,en irreg rev)"
`thrive	Suffix	"V(`thrive ,)"
`throve	End	"V(`thrive ,ed irreg)"
`thriven	PT_Suffix	"V(`thrive ,en irreg)"
`throw	Suffix	"V(`throw ,irreg)"
`threw	End	"V(`throw ,ed irreg)"
`thrown	PT_Suffix	"V(`throw ,en irreg)"
`thrust	Suffix	"V(`thrust ,irreg)"
`thrust	End	"V(`thrust ,ed irreg)"
`thrust	PT_Suffix	"V(`thrust ,en irreg)"
`tread	Suffix	"V(`tread ,irreg)"
`trod	End	"V(`tread ,ed irreg)"
`trod	PT_Suffix	"V(`tread ,en irreg)"
`trodden	PT_Suffix	"V(`tread ,en irreg)"
`typeset	Suffix	"V(`typeset ,irreg)"
`typeset	End	"V(`typeset ,ed irreg)"
`typeset	PT_Suffix	"V(`typeset ,en irreg)"
`typewrite	Suffix	"V(`typewrite ,irreg)"
`typewrote	End	"V(`typewrite ,ed irreg)"
`typewritten	PT_Suffix	"V(`typewrite ,en irreg)"
under`stand	Suffix	"V(under`stand ,irreg)"
under`stood	End	"V(under`stand ,ed irreg)"
under`stood	PT_Suffix	"V(under`stand ,en irreg)"
up`hold	Suffix	"V(up`hold ,irreg)"
up`held	End	"V(up`hold ,ed irreg)"
up`held	PT_Suffix	"V(up`hold ,en irreg)"
up`rise	Suffix	"V(up`rise ,irreg)"
up`rose	End	"V(up`rise ,ed irreg)"
up`risen	PT_Suffix	"V(up`rise ,en irreg)"
up`set	Suffix	"V(up`set ,irreg)"
up`set	End	"V(up`set ,ed irreg)"
up`set	PT_Suffix	"V(up`set ,en irreg)"
`wake	Suffix	"V(`wake ,)"
`woke	End	"V(`wake ,ed irreg)"
`woken	PT_Suffix	"V(`wake ,en irreg)"
`waylay	Suffix	"V(`waylay ,irreg)"
`waylaid	End	"V(`waylay ,ed irreg)"
`waylaid	PT_Suffix	"V(`waylay ,en irreg)"
`wear	Suffix	"V(`wear ,irreg)"
`wore	End	"V(`wear ,ed irreg)"
`worn	PT_Suffix	"V(`wear ,en irreg)"
`wove	End	"V(`weave ,ed irreg rev)"
`woven	PT_Suffix	"V(`weave ,en irreg rev)"
`wed	Suffix	"V(`wed ,)"
`wed	End	"V(`wed ,ed irreg)"
`wed	PT_Suffix	"V(`wed ,en irreg)"
`weep	Suffix	"V(`weep ,)"
`wept	End	"V(`weep ,ed irreg)"
`wept	PT_Suffix	"V(`weep ,en irreg)"
`wet	Suffix	"V(`wet ,)"
`wet	End	"V(`wet ,ed irreg)"
`wet	PT_Suffix	"V(`wet ,en irreg)"
`win	Suffix	"V(`win ,irreg)"
`won	End	"V(`win ,ed irreg)"
`won	PT_Suffix	"V(`win ,en irreg)"
`wind	Suffix	"V(`wind ,irreg rev)"
`wound	End	"V(`wind ,ed irreg rev)"
`wound	PT_Suffix	"V(`wind ,en irreg rev)"
`wit	Suffix	"V(`wit ,irreg)"
`wot	End	"V(`wit ,)"
`wist	End	"V(`wit ,ed irreg)"
`wist	PT_Suffix	"V(`wit ,en irreg)"
with`draw	Suffix	"V(with`draw ,irreg)"
with`drew	End	"V(with`draw ,ed irreg)"
with`drawn	PT_Suffix	"V(with`draw ,en irreg)"
with`hold	Suffix	"V(with`hold ,irreg)"
with`held	End	"V(with`hold ,ed irreg)"
with`held	PT_Suffix	"V(with`hold ,en irreg)"
with`stand	Suffix	"V(with`stand ,irreg)"
with`stood	End	"V(with`stand ,ed irreg)"
with`stood	PT_Suffix	"V(with`stand ,en irreg)"
`wring	Suffix	"V(`wring ,irreg)"
`wrung	End	"V(`wring ,ed irreg)"
`wrung	PT_Suffix	"V(`wring ,en irreg)"
`write	Suffix	"V(`write ,irreg)"
`wrote	End	"V(`write ,ed irreg)"
`written	PT_Suffix	"V(`write ,en irreg)"
a`bandon	Suffix	"V(a`bandon ,)"
a`base	Suffix	"V(a`base ,)"
a`bash	Suffix	"V(a`bash ,)"
a`bate	Suffix	"V(a`bate ,)"
ab`breviate	Suffix	"V(ab`breviate ,)"
`abdicate	Suffix	"V(`abdicate ,)"
ab`duct	Suffix	"V(ab`duct ,)"
`aberrate	Suffix	"V(`aberrate ,)"
a`bet	Suffix	"V(a`bet ,)"
ab`hor	Suffix	"V(ab`hor ,)"
ab`jure	Suffix	"V(ab`jure ,)"
ab`late	Suffix	"V(ab`late ,)"
a`bolish	Suffix	"V(a`bolish ,)"
a`bominate	Suffix	"V(a`bominate ,)"
a`bort	Suffix	"V(a`bort ,)"
a`bound	Suffix	"V(a`bound ,)"
a`brade	Suffix	"V(a`brade ,)"
abre`act	Suffix	"V(abre`act ,)"
a`bridge	Suffix	"V(a`bridge ,)"
`abrogate	Suffix	"V(`abrogate ,)"
ab`scond	Suffix	"V(ab`scond ,)"
ab`solve	Suffix	"V(ab`solve ,)"
ab`sorb	Suffix	"V(ab`sorb ,)"
ab`stain	Suffix	"V(ab`stain ,)"
ab`stract	Suffix	"V(ab`stract ,)"
a`buse	Suffix	"V(a`buse ,)"
a`but	Suffix	"V(a`but ,)"
ac`cede	Suffix	"V(ac`cede ,)"
ac`celerate	Suffix	"V(ac`celerate ,)"
ac`cent	Suffix	"V(ac`cent ,)"
ac`centuate	Suffix	"V(`accent ,denom)"
ac`cept	Suffix	"V(ac`cept ,)"
ac`claim	Suffix	"V(ac`claim ,)"
`acclimate	Suffix	"V(`acclimate ,)"
ac`climatise	Suffix	"V(ac`climatise ,)"
ac`climatize	Suffix	"V(ac`climatize ,)"
ac`commodate	Suffix	"V(ac`commodate ,)"
ac`company	Suffix	"V(ac`company ,)"
ac`complish	Suffix	"V(ac`complish ,)"
ac`cost	Suffix	"V(ac`cost ,)"
ac`count	Suffix	"V(ac`count ,)"
ac`credit	Suffix	"V(ac`credit ,)"
ac`crete	Suffix	"V(ac`crete ,)"
ac`crue	Suffix	"V(ac`crue ,)"
ac`culturate	Suffix	"V(ac`culturate ,)"
ac`cumulate	Suffix	"V(ac`cumulate ,)"
ac`cuse	Suffix	"V(ac`cuse ,)"
ac`custom	Suffix	"V(ac`custom ,)"
a`chieve	Suffix	"V(a`chieve ,)"
ac`knowledge	Suffix	"V(ac`knowledge ,)"
ac`quaint	Suffix	"V(ac`quaint ,)"
acqui`esce	Suffix	"V(acqui`esce ,)"
ac`quire	Suffix	"V(ac`quire ,)"
ac`quit	Suffix	"V(ac`quit ,)"
`activate	Suffix	"V(`active ,deverb)"
`actuate	Suffix	"V(`actuate ,)"
a`dapt	Suffix	"V(a`dapt ,)"
`add	Suffix	"V(`add ,)"
ad`dict	Suffix	"V(ad`dict ,)"
`addle	Suffix	"V(`addle ,)"
ad`dress	Suffix	"V(ad`dress ,)"
ad`duce	Suffix	"V(ad`duce ,)"
ad`here	Suffix	"V(ad`here ,)"
ad`join	Suffix	"V(ad`join ,)"
ad`journ	Suffix	"V(ad`journ ,)"
ad`judicate	Suffix	"V(ad`judicate ,)"
ad`judge	Suffix	"V(ad`judge ,)"
ad`jure	Suffix	"V(ad`jure ,)"
ad`just	Suffix	"V(ad`just ,)"
ad`minister	Suffix	"V(ad`minister ,)"
ad`ministrate	Suffix	"V(ad`minister ,)"
ad`mire	Suffix	"V(ad`mire ,)"
ad`mit	Suffix	"V(ad`mit ,)"
ad`mix	Suffix	"V(ad`mix ,)"
ad`monish	Suffix	"V(ad`monish ,)"
a`dopt	Suffix	"V(a`dopt ,)"
a`dore	Suffix	"V(a`dore ,)"
a`dorn	Suffix	"V(a`dorn ,)"
ad`sorb	Suffix	"V(ad`sorb ,)"
`adulate	Suffix	"V(`adulate ,)"
a`dulterate	Suffix	"V(a`dulterate ,)"
a`dumbrate	Suffix	"V(a`dumbrate ,)"
ad`vance	Suffix	"V(ad`vance ,)"
ad`vert	Suffix	"V(ad`vert ,)"
`advertise	Suffix	"V(`advertise ,)"
ad`vise	Suffix	"V(ad`vise ,)"
`advocate	Suffix	"V(`advocate ,)"
`aerate	Suffix	"V(`aerate ,)"
af`fect	Suffix	"V(af`fect ,)"
af`fiance	Suffix	"V(af`fiance ,)"
af`firm	Suffix	"V(af`firm ,)"
af`fix	Suffix	"V(af`fix ,)"
af`flict	Suffix	"V(af`flict ,)"
af`ford	Suffix	"V(af`ford ,)"
af`forest	Suffix	"V(af`forest ,)"
ag`glomerate	Suffix	"V(ag`glomerate ,)"
ag`glutinate	Suffix	"V(ag`glutinate ,)"
ag`grandise	Suffix	"V(ag`grandise ,)"
ag`grandize	Suffix	"V(ag`grandize ,)"
`aggravate	Suffix	"V(`aggravate ,)"
`aggregate	Suffix	"V(`aggregate ,)"
ag`grieve	Suffix	"V(ag`grieve ,)"
`agitate	Suffix	"V(`agitate ,)"
a`gree	Suffix	"V(a`gree ,)"
`ail	Suffix	"V(`ail ,)"
`airdrop	Suffix	"V(`airdrop ,)"
`airlift	Suffix	"V(`airlift ,)"
`airmail	Suffix	"V(`airmail ,)"
`alienate	Suffix	"V(`alien ,denom)"
a`light	Suffix	"V(a`light ,)"
a`lign	Suffix	"V(a`lign ,)"
al`lay	Suffix	"V(al`lay ,)"
al`lege	Suffix	"V(al`lege ,)"
al`leviate	Suffix	"V(al`leviate ,)"
al`literate	Suffix	"V(al`literate ,)"
`allocate	Suffix	"V(`allocate ,)"
al`lot	Suffix	"V(al`lot ,)"
al`low	Suffix	"V(al`low ,)"
al`lude	Suffix	"V(al`lude ,)"
al`lure	Suffix	"V(al`lure ,)"
al`ly	Suffix	"V(al`ly ,)"
`alter	Suffix	"V(`alter ,)"
`altercate	Suffix	"V(`altercate ,)"
a`malgamate	Suffix	"V(a`malgam ,denom)"
a`mass	Suffix	"V(a`mass ,)"
a`maze	Suffix	"V(a`maze ,)"
`amble	Suffix	"V(`amble ,)"
`ambulate	Suffix	"V(`ambulate ,)"
a`meliorate	Suffix	"V(a`meliorate ,)"
a`mend	Suffix	"V(a`mend ,)"
`amortize	Suffix	"V(`amortize ,)"
`amputate	Suffix	"V(`amputate ,)"
a`muse	Suffix	"V(a`muse ,)"
`analyse	Suffix	"V(`analyse ,)"
`analyze	Suffix	"V(`analyze ,)"
a`nesthetize	Suffix	"V(a`nesthetize ,)"
`anglicise	Suffix	"V(`anglicise ,)"
`anglicize	Suffix	"V(`anglicize ,)"
`angle	Suffix	"V(`angle ,)"
animad`vert	Suffix	"V(animad`vert ,)"
`animate	Suffix	"V(`animate ,)"
an`neal	Suffix	"V(an`neal ,)"
an`nex	Suffix	"V(an`nex ,)"
an`nihilate	Suffix	"V(an`nihilate ,)"
`annotate	Suffix	"V(`annotate ,)"
an`nounce	Suffix	"V(an`nounce ,)"
an`noy	Suffix	"V(an`noy ,)"
an`nul	Suffix	"V(an`nul ,)"
an`nunciate	Suffix	"V(an`nunciate ,)"
a`noint	Suffix	"V(a`noint ,)"
an`tagonize	Suffix	"V(an`tagonize ,)"
an`ticipate	Suffix	"V(an`ticipate ,)"
`antiquate	Suffix	"V(`antiquate ,)"
a`pologise	Suffix	"V(a`pology ,denom)"
a`pologize	Suffix	"V(a`pology ,denom)"
ap`pall	Suffix	"V(ap`pall ,)"
ap`peal	Suffix	"V(ap`peal ,)"
ap`pear	Suffix	"V(ap`pear ,)"
ap`pease	Suffix	"V(ap`pease ,)"
ap`pend	Suffix	"V(ap`pend ,)"
apper`tain	Suffix	"V(apper`tain ,)"
ap`plaud	Suffix	"V(ap`plaud ,)"
ap`ply	Suffix	"V(ap`ply ,)"
ap`point	Suffix	"V(ap`point ,)"
ap`portion	Suffix	"V(ap`portion ,)"
ap`praise	Suffix	"V(ap`praise ,)"
ap`preciate	Suffix	"V(ap`preciate ,)"
appre`hend	Suffix	"V(appre`hend ,)"
ap`prise	Suffix	"V(ap`prise ,)"
`approbate	Suffix	"V(`approbate ,)"
ap`propriate	Suffix	"V(ap`propriate ,)"
ap`prove	Suffix	"V(ap`prove ,)"
`arbitrate	Suffix	"V(`arbitrate ,)"
`argue	Suffix	"V(`argue ,)"
a`rouse	Suffix	"V(a`rouse ,)"
a`rraign	Suffix	"V(a`rraign ,)"
ar`range	Suffix	"V(ar`range ,)"
ar`rive	Suffix	"V(ar`rive ,)"
`arrogate	Suffix	"V(`arrogate ,)"
as`cend	Suffix	"V(as`cend ,)"
ascer`tain	Suffix	"V(ascer`tain ,)"
as`cribe	Suffix	"V(as`cribe ,)"
`ask	Suffix	"V(`ask ,)"
as`phyxiate	Suffix	"V(as`phyxiate ,)"
`aspirate	Suffix	"V(`aspirate ,)"
as`pire	Suffix	"V(as`pire ,)"
as`sail	Suffix	"V(as`sail ,)"
as`sassinate	Suffix	"V(as`sassin ,denom)"
as`say	Suffix	"V(as`say ,)"
as`semble	Suffix	"V(as`semble ,)"
as`sert	Suffix	"V(as`sert ,)"
as`sess	Suffix	"V(as`sess ,)"
as`sign	Suffix	"V(as`sign ,)"
as`similate	Suffix	"V(as`similate ,)"
as`sist	Suffix	"V(as`sist ,)"
as`sociate	Suffix	"V(as`sociate ,)"
as`sort	Suffix	"V(as`sort ,)"
as`suage	Suffix	"V(as`suage ,)"
as`sume	Suffix	"V(as`sume ,)"
as`sure	Suffix	"V(as`sure ,)"
as`tonish	Suffix	"V(as`tonish ,)"
as`tound	Suffix	"V(as`tound ,)"
a`tone	Suffix	"V(a`tone ,)"
`atrophy	Suffix	"V(`atrophy ,)"
at`tach	Suffix	"V(at`tach ,)"
at`tain	Suffix	"V(at`tain ,)"
at`tend	Suffix	"V(at`tend ,)"
at`tenuate	Suffix	"V(at`tenuate ,)"
at`test	Suffix	"V(at`test ,)"
at`tract	Suffix	"V(at`tract ,)"
at`tribute	Suffix	"V(at`tribute ,)"
at`tune	Suffix	"V(at`tune ,)"
aug`ment	Suffix	"V(aug`ment ,)"
`augur	Suffix	"V(`augur ,)"
au`thenticate	Suffix	"V(au`thentic ,deadj)"
`authorise	Suffix	"V(`authorise ,)"
`authorize	Suffix	"V(`authorize ,)"
`automate	Suffix	"V(`automate ,)"
a`vail	Suffix	"V(a`vail ,)"
a`vast	Clitic	"V(a`vast ,)"
a`venge	Suffix	"V(a`venge ,)"
a`ver	Suffix	"V(a`ver ,)"
a`vert	Suffix	"V(a`vert ,)"
`aviate	Suffix	"V(`aviate ,)"
a`void	Suffix	"V(a`void ,)"
a`vow	Suffix	"V(a`vow ,)"
a`wait	Suffix	"V(a`wait ,)"
a`waken	Suffix	"V(a`waken ,)"
`babble	Suffix	"V(`babble ,)"
`backbite	Suffix	"V(`backbite ,)"
`backfill	Suffix	"V(`backfill ,)"
`backorder	Suffix	"V(`backorder ,)"
`backscatter	Suffix	"V(`backscatter ,)"
`backstitch	Suffix	"V(`backstitch ,)"
`backtrack	Suffix	"V(`backtrack ,)"
`baffle	Suffix	"V(`baffle ,)"
`bail	Suffix	"V(`bail ,)"
`bake	Suffix	"V(`bake ,)"
`balance	Suffix	"V(`balance ,rev)"
bam`boozle	Suffix	"V(bam`boozle ,)"
`bandy	Suffix	"V(`bandy ,)"
`banish	Suffix	"V(`banish ,)"
`baptize	Suffix	"V(`baptize ,)"
`bare	Suffix	"V(`bare ,)"
`barge	Suffix	"V(`barge ,)"
`bark	Suffix	"V(`bark ,)"
`barkeep	Suffix	"V(`barkeep ,)"
`bartend	Suffix	"V(`bartend ,boundstem)"
`barnstorm	Suffix	"V(`barnstorm ,)"
`barter	Suffix	"V(`barter ,)"
`bask	Suffix	"V(`bask ,)"
`baste	Suffix	"V(`baste ,)"
`bathe	Suffix	"V(`bathe ,)"
`batten	Suffix	"V(`batten ,)"
`batter	Suffix	"V(`batter ,)"
`bawl	Suffix	"V(`bawl ,)"
`bay	Suffix	"V(`bay ,)"
`beachcomb	Suffix	"V(`beachcomb ,)"
be`atify	Suffix	"V(be`atify ,)"
`beautify	Suffix	"V(`beauty ,denom)"
be`calm	Suffix	"V(`calm ,deadj)"
`beckon	Suffix	"V(`beckon ,)"
be`cloud	Suffix	"V(`cloud ,denom)"
be`dazzle	Suffix	"V(`dazzle ,)"
be`daub	Suffix	"V(`daub ,)"
be`deck	Suffix	"V(`deck ,)"
be`devil	Suffix	"V(`devil ,denom)"
be`dim	Suffix	"V(`dim ,deadj)"
be`draggle	Suffix	"V(be`draggle ,)"
be`fit	Suffix	"V(be`fit ,)"
be`fog	Suffix	"V(`fog ,denom)"
be`fool	Suffix	"V(`fool ,denom)"
be`foul	Suffix	"V(`foul ,deadj)"
be`friend	Suffix	"V(`friend ,denom)"
be`fuddle	Suffix	"V(`fuddle ,)"
`beg	Suffix	"V(`beg ,)"
be`gone	Clitic	"V(be`gone ,)"
be`grime	Suffix	"V(`grime ,denom)"
be`grudge	Suffix	"V(`grudge ,denom)"
be`guile	Suffix	"V(be`guile ,)"
be`have	Suffix	"V(be`have ,)"
be`head	Suffix	"V(`head ,denom)"
be`hoove	Suffix	"V(be`hoove ,)"
be`hove	Suffix	"V(be`hove ,)"
be`labor	Suffix	"V(`labor ,)"
be`labour	Suffix	"V(`labour ,)"
be`lay	Suffix	"V(be`lay ,)"
be`leaguer	Suffix	"V(be`leaguer ,)"
be`lie	Suffix	"V(be`lie ,)"
be`lieve	Suffix	"V(be`lieve ,)"
be`little	Suffix	"V(`little ,deadj)"
be`long	Suffix	"V(be`long ,)"
be`madden	Suffix	"V(`mad ,deadj)"
be`moan	Suffix	"V(`moan ,)"
be`muse	Suffix	"V(be`muse ,)"
be`night	Suffix	"V(`night ,denom)"
be`plaster	Suffix	"V(`plaster ,denom)"
be`queath	Suffix	"V(be`queath ,)"
be`rate	Suffix	"V(be`rate ,)"
be`ribbon	Suffix	"V(`ribbon ,denom)"
be`siege	Suffix	"V(`siege ,denom)"
be`smirch	Suffix	"V(be`smirch ,)"
be`sot	Suffix	"V(be`sot ,)"
be`smear	Suffix	"V(`smear ,)"
be`spatter	Suffix	"V(`spatter ,)"
be`streak	Suffix	"V(`streak ,denom)"
be`stir	Suffix	"V(`stir ,)"
be`stow	Suffix	"V(be`stow ,)"
be`tide	Suffix	"V(be`tide ,)"
be`token	Suffix	"V(be`token ,)"
be`tray	Suffix	"V(be`tray ,)"
be`troth	Suffix	"V(be`troth ,)"
`better	Suffix	"V(`better ,)"
be`wail	Suffix	"V(`wail ,)"
be`ware	Clitic	"V(be`ware ,)"
be`whisker	Suffix	"V(`whisker ,denom)"
be`wilder	Suffix	"V(be`wilder ,)"
be`witch	Suffix	"V(`witch ,denom)"
`bicker	Suffix	"V(`bicker ,)"
`bide	Suffix	"V(`bide ,)"
`bifurcate	Suffix	"V(`bifurcate ,)"
`bilk	Suffix	"V(`bilk ,)"
`birdwatch	Suffix	"V(`birdwatch ,)"
`bisect	Suffix	"V(`bisect ,)"
bi`variate	Suffix	"V(bi`variate ,)"
`blab	Suffix	"V(`blab ,)"
`blackball	Suffix	"V(`blackball ,)"
`blackmail	Suffix	"V(`blackmail ,)"
`blanch	Suffix	"V(`blanch ,)"
`blandish	Suffix	"V(`blandish ,)"
`blare	Suffix	"V(`blare ,)"
`blaspheme	Suffix	"V(`blaspheme ,)"
`blat	Suffix	"V(`blat ,)"
`bleat	Suffix	"V(`bleat ,)"
`bless	Suffix	"V(`bless ,)"
`bloat	Suffix	"V(`bloat ,)"
block`ade	Suffix	"V(block`ade ,)"
`bloody	Suffix	"V(`blood ,denom)"
`blubber	Suffix	"V(`blubber ,)"
`bludgeon	Suffix	"V(`bludgeon ,)"
`blurt	Suffix	"V(`blurt ,)"
`blush	Suffix	"V(`blush ,)"
`bluster	Suffix	"V(`bluster ,)"
`board	Suffix	"V(`board ,)"
`bob	Suffix	"V(`bob ,)"
`bobble	Suffix	"V(`bobble ,)"
`bode	Suffix	"V(`bode ,)"
`bodybuild	Suffix	"V(`bodybuild ,boundstem)"
`boggle	Suffix	"V(`boggle ,)"
`bolster	Suffix	"V(`bolster ,)"
`bolt	Suffix	"V(`bolt ,)"
bom`bard	Suffix	"V(bom`bard ,)"
`bookbind	Suffix	"V(`bookbind ,boundstem)"
`bookkeep	Suffix	"V(`bookkeep ,boundstem)"
`booksell	Suffix	"V(`booksell ,boundstem)"
`bootleg	Suffix	"V(`bootleg ,)"
`borrow	Suffix	"V(`borrow ,)"
`botch	Suffix	"V(`botch ,)"
`bound	Suffix	"V(`bound ,)"
`bowdlerize	Suffix	"V(`bowdlerize ,)"
`bowl	Suffix	"V(`bowl ,)"
`brag	Suffix	"V(`brag ,)"
`brainwash	Suffix	"V(`brainwash ,)"
`brandish	Suffix	"V(`brandish ,)"
`bray	Suffix	"V(`bray ,)"
`breadwin	Suffix	"V(`breadwin ,boundstem)"
`breathe	Suffix	"V(`breathe ,)"
`bricklay	Suffix	"V(`bricklay ,boundstem)"
`brief	Suffix	"V(`brief ,)"
`brim	Suffix	"V(`brim ,)"
`broach	Suffix	"V(`broach ,)"
`broil	Suffix	"V(`broil ,)"
`browbeat	Suffix	"V(`browbeat ,)"
`brown	Suffix	"V(`brown ,)"
`browse	Suffix	"V(`browse ,)"
`buck	Suffix	"V(`buck ,)"
`budge	Suffix	"V(`budge ,)"
`buffet	Suffix	"V(`buffet ,)"
`bug	Suffix	"V(`bug ,)"
`bulldoze	Suffix	"V(`bulldoze ,)"
`bumble	Suffix	"V(`bumble ,)"
`bunt	Suffix	"V(`bunt ,)"
`bungle	Suffix	"V(`bungle ,)"
`burble	Suffix	"V(`burble ,)"
`burgeon	Suffix	"V(`burgeon ,)"
`bury	Suffix	"V(`bury ,)"
`buss	Suffix	"V(`buss ,)"
`bushwhack	Suffix	"V(`bushwhack ,)"
`bustle	Suffix	"V(`bustle ,)"
`butt	Suffix	"V(`butt ,)"
`cabdrive	Suffix	"V(`cabdrive ,boundstem)"
`cabinetmake	Suffix	"V(`cabinetmake ,boundstem)"
ca`jole	Suffix	"V(ca`jole ,)"
`calcify	Suffix	"V(`calcify ,)"
`calculate	Suffix	"V(`calculate ,)"
`calibrate	Suffix	"V(`caliber ,denom)"
ca`lumniate	Suffix	"V(`calumny ,denom)"
`calve	Suffix	"V(`calf ,denom)"
`cancel	Suffix	"V(`cancel ,)"
`canvass	Suffix	"V(`canvass ,)"
ca`pitulate	Suffix	"V(ca`pitulate ,)"
`capsize	Suffix	"V(`capsize ,)"
`captivate	Suffix	"V(`captivate ,)"
`carbonate	Suffix	"V(`carbon ,denom)"
ca`reen	Suffix	"V(ca`reen ,)"
ca`rouse	Suffix	"V(ca`rouse ,)"
`carp	Suffix	"V(`carp ,)"
`carry	Suffix	"V(`carry ,)"
`carve	Suffix	"V(`carve ,)"
`castigate	Suffix	"V(`castigate ,)"
`castrate	Suffix	"V(`castrate ,)"
`catechize	Suffix	"V(`catechize ,)"
`categorize	Suffix	"V(`category ,denom)"
`catenate	Suffix	"V(`catenate ,)"
`cater	Suffix	"V(`cater ,)"
`cavil	Suffix	"V(`cavil ,)"
`cavitate	Suffix	"V(`cavitate ,)"
ca`vort	Suffix	"V(ca`vort ,)"
`caw	Suffix	"V(`caw ,)"
`cease	Suffix	"V(`cease ,)"
`cede	Suffix	"V(`cede ,)"
`celebrate	Suffix	"V(`celebrate ,)"
`cense	Suffix	"V(`cense ,)"
`censure	Suffix	"V(`censure ,)"
`cerebrate	Suffix	"V(`cerebrate ,)"
`certify	Suffix	"V(`certify ,)"
`chafe	Suffix	"V(`chafe ,)"
`chamfer	Suffix	"V(`chamfer ,)"
`champ	Suffix	"V(`champ ,~nr23)"
`chap	Suffix	"V(`chap ,)"
`char	Suffix	"V(`char ,)"
chas`tise	Suffix	"V(chas`tise ,)"
`cheat	Suffix	"V(`cheat ,)"
`checker	Suffix	"V(`checker ,)"
`cheerlead	Suffix	"V(`cheerlead ,boundstem)"
`cherish	Suffix	"V(`cherish ,)"
`chlorinate	Suffix	"V(chlor`ine ,denom)"
`choke	Suffix	"V(`choke ,rev)"
`chomp	Suffix	"V(`chomp ,)"
`choreograph	Suffix	"V(`choreograph ,)"
`chortle	Suffix	"V(`chortle ,)"
`christen	Suffix	"V(`christen ,)"
`chuck	Suffix	"V(`chuck ,)"
`chuff	Suffix	"V(`chuff ,)"
`chug	Suffix	"V(`chug ,)"
`churchgo	Suffix	"V(`churchgo ,boundstem)"
`churn	Suffix	"V(`churn ,)"
`circulate	Suffix	"V(`circulate ,)"
`circumcise	Suffix	"V(`circumcise ,)"
`circumscribe	Suffix	"V(`circumscribe ,)"
`circumvent	Suffix	"V(`circumvent ,)"
`cite	Suffix	"V(`cite ,)"
`citify	Suffix	"V(`city ,denom)"
`clamber	Suffix	"V(`clamber ,)"
`clang	Suffix	"V(`clang ,)"
`clank	Suffix	"V(`clank ,)"
`clarify	Suffix	"V(`clarify ,)"
`cleanse	Suffix	"V(`cleanse ,)"
`clear	Suffix	"V(`clear ,)"
`clench	Suffix	"V(`clench ,rev)"
`climb	Suffix	"V(`climb ,)"
`clinch	Suffix	"V(`clinch ,rev)"
`clink	Suffix	"V(`clink ,)"
`clobber	Suffix	"V(`clobber ,)"
`clockwatch	Suffix	"V(`clockwatch ,boundstem)"
`clomp	Suffix	"V(`clomp ,)"
`close	Suffix	"V(`close ,rev)"
`clothe	Suffix	"V(`clothe ,rev)"
`cloy	Suffix	"V(`cloy ,)"
`cluck	Suffix	"V(`cluck ,)"
`clutch	Suffix	"V(`clutch ,)"
co`agulate	Suffix	"V(co`agulate ,)"
coa`lesce	Suffix	"V(coa`lesce ,)"
`coast	Suffix	"V(`coast ,)"
`coax	Suffix	"V(`coax ,)"
`cobble	Suffix	"V(`cobble ,)"
`cock	Suffix	"V(`cock ,rev)"
`coddle	Suffix	"V(`coddle ,)"
co`erce	Suffix	"V(co`erce ,)"
`cogitate	Suffix	"V(`cogitate ,)"
co`here	Suffix	"V(co`here ,)"
coin`cide	Suffix	"V(coin`cide ,)"
col`laborate	Suffix	"V(col`laborate ,)"
`collate	Suffix	"V(`collate ,)"
col`lect	Suffix	"V(col`lect ,)"
col`lide	Suffix	"V(col`lide ,)"
`collocate	Suffix	"V(`collocate ,)"
col`lude	Suffix	"V(col`lude ,)"
`colorate	Suffix	"V(`color ,denom)"
com`bat	Suffix	"V(com`bat ,)"
com`bine	Suffix	"V(com`bine ,)"
com`bust	Suffix	"V(com`bust ,)"
comman`deer	Suffix	"V(comman`deer ,)"
com`memorate	Suffix	"V(com`memorate ,)"
com`mence	Suffix	"V(com`mence ,)"
com`mend	Suffix	"V(com`mend ,)"
com`merce	Suffix	"V(com`merce - archaic,)"
com`mingle	Suffix	"V(com`mingle ,)"
com`miserate	Suffix	"V(com`miserate ,)"
com`mit	Suffix	"V(com`mit ,)"
com`mune	Suffix	"V(com`mune ,)"
com`municate	Suffix	"V(com`municate ,)"
`commutate	Suffix	"V(`commutate ,)"
com`mute	Suffix	"V(com`mute ,)"
com`pact	Suffix	"V(com`pact ,)"
com`pare	Suffix	"V(com`pare ,)"
`compass	Suffix	"V(`compass ,)"
com`pel	Suffix	"V(com`pel ,)"
`compensate	Suffix	"V(`compensate ,)"
com`pete	Suffix	"V(com`pete ,)"
com`pile	Suffix	"V(com`pile ,)"
com`plain	Suffix	"V(com`plain ,)"
`complicate	Suffix	"V(`complicate ,)"
com`ply	Suffix	"V(com`ply ,)"
com`port	Suffix	"V(com`port ,)"
com`pose	Suffix	"V(com`pose ,)"
com`pound	Suffix	"V(com`pound ,)"
compre`hend	Suffix	"V(compre`hend ,)"
com`press	Suffix	"V(com`press ,)"
com`prise	Suffix	"V(com`prise ,)"
`compromise	Suffix	"V(`compromise ,)"
com`pute	Suffix	"V(com`pute ,)"
con`catenate	Suffix	"V(con`catenate ,)"
con`ceal	Suffix	"V(con`ceal ,)"
con`cede	Suffix	"V(con`cede ,)"
con`ceive	Suffix	"V(con`ceive ,)"
`concentrate	Suffix	"V(`concentrate ,)"
con`cert	Suffix	"V(con`cert ,)"
con`ciliate	Suffix	"V(con`ciliate ,)"
con`clude	Suffix	"V(con`clude ,)"
con`coct	Suffix	"V(con`coct ,)"
con`cord	Suffix	"V(con`cord ,)"
con`cur	Suffix	"V(con`cur ,)"
con`cuss	Suffix	"V(con`cuss ,)"
con`demn	Suffix	"V(con`demn ,)"
`condensate	Suffix	"V(`condensate ,)"
con`dense	Suffix	"V(con`dense ,)"
condes`cend	Suffix	"V(condes`cend ,)"
con`dole	Suffix	"V(con`dole ,)"
con`done	Suffix	"V(con`done ,)"
con`duce	Suffix	"V(con`duce ,)"
con`duct	Suffix	"V(con`duct ,)"
con`fabulate	Suffix	"V(con`fabulate ,)"
con`fect	Suffix	"V(con`fect ,)"
con`fer	Suffix	"V(con`fer ,)"
con`fess	Suffix	"V(con`fess ,)"
con`fide	Suffix	"V(con`fide ,)"
con`figure	Suffix	"V(con`figure ,)"
con`fine	Suffix	"V(con`fine ,)"
con`firm	Suffix	"V(con`firm ,)"
`confiscate	Suffix	"V(`confiscate ,)"
con`flict	Suffix	"V(con`flict ,)"
con`form	Suffix	"V(con`form ,)"
con`found	Suffix	"V(con`found ,)"
con`front	Suffix	"V(con`front ,)"
con`fuse	Suffix	"V(con`fuse ,)"
con`fute	Suffix	"V(con`fute ,)"
con`geal	Suffix	"V(con`geal ,)"
con`gest	Suffix	"V(con`gest ,)"
con`gratulate	Suffix	"V(con`gratulate ,)"
`congregate	Suffix	"V(`congregate ,)"
con`join	Suffix	"V(con`join ,)"
`conjugate	Suffix	"V(`conjugate ,)"
con`jure	Suffix	"V(con`jure ,)"
con`nect	Suffix	"V(con`nect ,)"
con`nive	Suffix	"V(con`nive ,)"
con`note	Suffix	"V(con`note ,)"
`conquer	Suffix	"V(`conquer ,)"
con`script	Suffix	"V(con`script ,)"
`consecrate	Suffix	"V(`consecrate ,)"
con`serve	Suffix	"V(con`serve ,)"
con`sider	Suffix	"V(con`sider ,)"
con`sign	Suffix	"V(con`sign ,)"
con`sist	Suffix	"V(con`sist ,)"
con`sole	Suffix	"V(con`sole ,)"
con`solidate	Suffix	"V(con`solidate ,)"
con`sort	Suffix	"V(con`sort ,)"
con`spire	Suffix	"V(con`spire ,)"
`constellate	Suffix	"V(`constellate ,)"
`consternate	Suffix	"V(`consternate ,)"
`constipate	Suffix	"V(`constipate ,)"
`constitute	Suffix	"V(`constitute ,)"
con`strain	Suffix	"V(con`strain ,)"
con`strict	Suffix	"V(con`strict ,)"
con`struct	Suffix	"V(con`struct ,)"
con`strue	Suffix	"V(con`strue ,)"
con`sult	Suffix	"V(con`sult ,)"
con`sume	Suffix	"V(con`sume ,)"
con`tain	Suffix	"V(con`tain ,)"
con`taminate	Suffix	"V(con`taminate ,)"
`contemplate	Suffix	"V(`contemplate ,)"
con`tend	Suffix	"V(con`tend ,)"
con`tent	Suffix	"V(con`tent ,)"
con`test	Suffix	"V(con`test ,)"
con`tinue	Suffix	"V(con`tinue ,)"
con`tort	Suffix	"V(con`tort ,)"
con`tract	Suffix	"V(con`tract ,)"
contra`dict	Suffix	"V(contra`dict ,)"
con`trast	Suffix	"V(con`trast ,)"
contra`vene	Suffix	"V(contra`vene ,)"
con`tribute	Suffix	"V(con`tribute ,)"
con`trive	Suffix	"V(con`trive ,)"
con`trol	Suffix	"V(con`trol ,)"
`controvert	Suffix	"V(`controvert ,)"
con`tuse	Suffix	"V(con`tuse ,)"
conva`lesce	Suffix	"V(conva`lesce ,)"
con`vect	Suffix	"V(con`vect ,)"
con`vene	Suffix	"V(con`vene ,)"
con`verge	Suffix	"V(con`verge ,)"
con`verse	Suffix	"V(con`verse ,)"
con`vert	Suffix	"V(con`vert ,)"
con`vey	Suffix	"V(con`vey ,)"
con`vict	Suffix	"V(con`vict ,)"
con`vince	Suffix	"V(con`vince ,)"
con`voke	Suffix	"V(con`voke ,)"
`convolute	Suffix	"V(`convolute ,)"
con`volve	Suffix	"V(con`volve ,)"
con`vulse	Suffix	"V(con`vulse ,)"
`cook	Suffix	"V(`cook ,)"
co`operate	Suffix	"V(co`operate ,)"
`cope	Suffix	"V(`cope ,)"
`copulate	Suffix	"V(`copulate ,)"
`correlate	Suffix	"V(`correlate ,)"
corres`pond	Suffix	"V(corres`pond ,)"
cor`roborate	Suffix	"V(cor`roborate ,)"
cor`rode	Suffix	"V(cor`rode ,)"
`corrugate	Suffix	"V(`corrugate ,)"
co`ruscate	Suffix	"V(co`ruscate ,)"
`couch	Suffix	"V(`couch ,)"
`counter	Suffix	"V(`counter ,)"
counter`vail	Suffix	"V(counter`vail ,)"
`countrify	Suffix	"V(`country ,denom)"
`couple	Suffix	"V(`couple ,rev)"
`course	Suffix	"V(`course ,)"
`court	Suffix	"V(`court ,)"
`covet	Suffix	"V(`covet ,)"
`cower	Suffix	"V(`cower ,)"
`cozen	Suffix	"V(`cozen ,)"
`craft	Suffix	"V(`craft ,)"
`cram	Suffix	"V(`cram ,)"
`crave	Suffix	"V(`crave ,)"
`crawl	Suffix	"V(`crawl ,)"
`craze	Suffix	"V(`craze ,)"
cre`ate	Suffix	"V(cre`ate ,)"
`cremate	Suffix	"V(`cremate ,)"
`crimson	Suffix	"V(`crimson ,)"
`cringe	Suffix	"V(`cringe ,)"
`crinkle	Suffix	"V(`crinkle ,)"
cro`chet	Suffix	"V(cro`chet ,)"
`croon	Suffix	"V(`croon ,)"
`crop	Suffix	"V(`crop ,)"
`cross	Suffix	"V(`cross ,rev)"
cross-ex`amine	Suffix	"V(cross-ex`amine ,)"
`crosshatch	Suffix	"V(`crosshatch ,)"
`crouch	Suffix	"V(`crouch ,)"
`crow	Suffix	"V(`crow ,)"
`crucify	Suffix	"V(`crucify ,)"
`crumble	Suffix	"V(`crumble ,)"
`crump	Suffix	"V(`crump ,)"
`crumple	Suffix	"V(`crumple ,rev)"
`crush	Suffix	"V(`crush ,)"
crypt`analyze	Suffix	"V(crypt`analyze ,)"
`cuddle	Suffix	"V(`cuddle ,)"
`cull	Suffix	"V(`cull ,)"
`culminate	Suffix	"V(`culminate ,)"
`cultivate	Suffix	"V(`cultivate ,)"
`cumulate	Suffix	"V(`cumulate ,)"
`curb	Suffix	"V(`curb ,)"
`curdle	Suffix	"V(`curdle ,)"
`curry	Suffix	"V(`curry ,)"
cur`tail	Suffix	"V(cur`tail ,)"
`cuss	Suffix	"V(`cuss ,)"
`cycled	Clitic	"V(`cycle ,ed)"
`cycled	Clitic	"V(`cycle ,en)"
`cycling	PT_Suffix	"V(`cycle ,ing)"
`dabble	Suffix	"V(`dabble ,)"
`dally	Suffix	"V(`dally ,)"
`damn	Suffix	"V(`damn ,)"
`dangle	Suffix	"V(`dangle ,)"
`dapple	Suffix	"V(`dapple ,)"
dare`say	Suffix	"V(dare`say ,)"
`darkle	Suffix	"V(`darkle ,)"
`darn	Suffix	"V(`darn ,)"
`daunt	Suffix	"V(`daunt ,)"
`dazzle	Suffix	"V(`dazzle ,)"
de`base	Suffix	"V(de`base ,)"
de`bate	Suffix	"V(de`bate ,)"
de`bauch	Suffix	"V(de`bauch ,)"
de`bilitate	Suffix	"V(de`bilitate ,)"
de`bunk	Suffix	"V(`bunk ,denom)"
de`buted	Clitic	"V(de`but ,ed)"
de`buted	PT_Suffix	"V(de`but ,en)"
de`buting	PT_Suffix	"V(de`but ,ing)"
de`caffeinate	Suffix	"V(caf`feine ,denom)"
de`cant	Suffix	"V(de`cant ,)"
de`capitate	Suffix	"V(de`capitate ,)"
de`cease	Suffix	"V(de`cease ,)"
de`ceive	Suffix	"V(de`ceive ,rev)"
de`celerate	Suffix	"V(ac`celerate ,)"
de`cide	Suffix	"V(de`cide ,)"
`decimate	Suffix	"V(`decimate ,)"
`deck	Suffix	"V(`deck ,)"
de`claim	Suffix	"V(de`claim ,)"
de`clare	Suffix	"V(de`clare ,)"
de`coct	Suffix	"V(de`coct ,)"
`decorate	Suffix	"V(`decorate ,)"
de`corticate	Suffix	"V(de`corticate ,)"
de`crease	Suffix	"V(de`crease ,)"
`decrement	Suffix	"V(`decrement ,)"
de`cry	Suffix	"V(de`cry ,)"
de`crypt	Suffix	"V(de`crypt ,)"
`dedicate	Suffix	"V(`dedicate ,)"
de`duce	Suffix	"V(de`duce ,)"
de`duct	Suffix	"V(de`duct ,)"
`deem	Suffix	"V(`deem ,)"
de`face	Suffix	"V(de`face ,)"
de`fame	Suffix	"V(de`fame ,)"
de`fang	Suffix	"V(`fang ,denom)"
de`fat	Suffix	"V(`fat ,denom)"
`defecate	Suffix	"V(`defecate ,)"
de`fect	Suffix	"V(de`fect ,)"
de`fend	Suffix	"V(de`fend ,)"
de`fer	Suffix	"V(de`fer ,)"
de`file	Suffix	"V(de`file ,)"
de`fine	Suffix	"V(de`fine ,)"
de`flate	Suffix	"V(de`flate ,)"
de`flect	Suffix	"V(de`flect ,)"
de`foliate	Suffix	"V(de`foliate ,)"
de`form	Suffix	"V(de`form ,)"
de`fraud	Suffix	"V(de`fraud ,)"
de`fray	Suffix	"V(de`fray ,)"
de`fuse	Suffix	"V(de`fuse ,)"
de`fy	Suffix	"V(de`fy ,)"
de`germ	Suffix	"V(`germ ,denom)"
de`grade	Suffix	"V(de`grade ,)"
de`horn	Suffix	"V(`horn ,denom)"
`deify	Suffix	"V(`deify ,)"
`deign	Suffix	"V(`deign ,)"
de`ject	Suffix	"V(de`ject ,)"
`delegate	Suffix	"V(`delegate ,)"
de`lete	Suffix	"V(de`lete ,)"
de`limit	Suffix	"V(de`limit ,)"
de`lineate	Suffix	"V(de`lineate ,)"
deli`quesce	Suffix	"V(deli`quesce ,)"
de`liver	Suffix	"V(de`liver ,)"
de`louse	Suffix	"V(`louse ,denom)"
de`lude	Suffix	"V(de`lude ,)"
`delve	Suffix	"V(`delve ,)"
de`marcate	Suffix	"V(de`marcate ,)"
de`mark	Suffix	"V(de`mark ,)"
de`mean	Suffix	"V(de`mean ,)"
de`mit	Suffix	"V(de`mit ,)"
de`molish	Suffix	"V(de`molish ,)"
`demonstrate	Suffix	"V(`demonstrate ,)"
de`mote	Suffix	"V(de`mote ,)"
de`mur	Suffix	"V(de`mur ,)"
de`nature	Suffix	"V(de`nature ,)"
`denigrate	Suffix	"V(`denigrate ,)"
de`note	Suffix	"V(de`note ,)"
de`nounce	Suffix	"V(de`nounce ,)"
de`nude	Suffix	"V(`nude ,deadj)"
de`ny	Suffix	"V(de`ny ,)"
de`part	Suffix	"V(de`part ,)"
de`pend	Suffix	"V(de`pend ,)"
de`pict	Suffix	"V(de`pict ,)"
de`plane	Suffix	"V(`plane ,denom)"
de`plete	Suffix	"V(de`plete ,)"
de`plore	Suffix	"V(de`plore ,)"
de`ploy	Suffix	"V(de`ploy ,)"
de`port	Suffix	"V(de`port ,)"
de`pose	Suffix	"V(de`pose ,)"
de`prave	Suffix	"V(de`prave ,)"
`deprecate	Suffix	"V(`deprecate ,)"
de`preciate	Suffix	"V(de`preciate ,)"
`depredate	Suffix	"V(`depredate ,)"
de`press	Suffix	"V(de`press ,)"
de`prive	Suffix	"V(de`prive ,)"
de`pute	Suffix	"V(de`pute ,)"
`deputize	Suffix	"V(`deputy ,denom)"
de`rail	Suffix	"V(de`rail ,)"
de`range	Suffix	"V(de`range ,)"
de`rate	Suffix	"V(de`rate ,)"
de`ride	Suffix	"V(de`ride ,)"
de`rive	Suffix	"V(de`rive ,)"
`derogate	Suffix	"V(`derogate ,)"
de`salinate	Suffix	"V(`saline ,denom)"
des`cend	Suffix	"V(des`cend ,)"
des`cribe	Suffix	"V(des`cribe ,)"
de`scry	Suffix	"V(de`scry ,)"
`desecrate	Suffix	"V(`desecrate ,)"
de`sert	Suffix	"V(de`sert ,)"
de`serve	Suffix	"V(de`serve ,)"
`desicate	Suffix	"V(`desicate ,)"
de`sist	Suffix	"V(de`sist ,)"
de`spise	Suffix	"V(de`spise ,)"
de`spoil	Suffix	"V(de`spoil ,)"
de`spond	Suffix	"V(de`spond ,)"
`destine	Suffix	"V(`destine ,)"
de`stroy	Suffix	"V(de`stroy ,)"
de`struct	Suffix	"V(de`struct ,)"
de`tach	Suffix	"V(de`tach ,)"
de`tail	Suffix	"V(de`tail ,)"
de`tain	Suffix	"V(de`tain ,)"
de`tect	Suffix	"V(de`tect ,)"
de`ter	Suffix	"V(de`ter ,)"
de`teriorate	Suffix	"V(de`teriorate ,)"
de`termine	Suffix	"V(de`termine ,)"
de`test	Suffix	"V(de`test ,)"
de`throne	Suffix	"V(`throne ,denom)"
`detonate	Suffix	"V(`detonate ,)"
de`toxify	Suffix	"V(`toxin ,denom)"
de`tract	Suffix	"V(de`tract ,)"
`devastate	Suffix	"V(`devastate ,)"
de`velop	Suffix	"V(de`velop ,)"
de`vein	Suffix	"V(`vein ,denom)"
`deviate	Suffix	"V(`deviate ,)"
de`vise	Suffix	"V(de`vise ,)"
de`volve	Suffix	"V(de`volve ,)"
de`vote	Suffix	"V(de`vote ,)"
de`vour	Suffix	"V(de`vour ,)"
diag`nose	Suffix	"V(diag`nose ,)"
`dictate	Suffix	"V(`dictate ,)"
`diddle	Suffix	"V(`diddle ,)"
`die	Suffix	"V(`die ,)"
`differ	Suffix	"V(`differ ,)"
differ`entiate	Suffix	"V(`different ,deadj)"
dif`fract	Suffix	"V(dif`fract ,)"
dif`fuse	Suffix	"V(dif`fuse ,)"
di`gest	Suffix	"V(di`gest ,)"
`dignify	Suffix	"V(`dignify ,)"
di`gress	Suffix	"V(di`gress ,)"
di`lapidate	Suffix	"V(di`lapidate ,)"
`dilate	Suffix	"V(`dilate ,)"
di`lute	Suffix	"V(di`lute ,)"
di`minish	Suffix	"V(di`minish ,)"
`dine	Suffix	"V(`dine ,)"
di`rect	Suffix	"V(di`rect ,)"
`dirty	Suffix	"V(`dirty ,)"
dis`able	Suffix	"V(`able ,deadj)"
disam`biguate	Suffix	"V(am`biguous ,deadj)"
dis`appoint	Suffix	"V(dis`appoint ,)"
dis`burse	Suffix	"V(dis`burse ,)"
dis`card	Suffix	"V(dis`card ,)"
dis`cern	Suffix	"V(dis`cern ,)"
dis`comfit	Suffix	"V(dis`comfit ,)"
dis`concert	Suffix	"V(dis`concert ,)"
dis`count	Suffix	"V(dis`count ,)"
dis`courage	Suffix	"V(dis`courage ,)"
dis`cover	Suffix	"V(dis`cover ,)"
dis`cuss	Suffix	"V(dis`cuss ,)"
disem`bowel	Suffix	"V(`bowel ,denom)"
dis`guise	Suffix	"V(dis`guise ,)"
dis`gruntle	Suffix	"V(dis`gruntle ,)"
di`shevel	Suffix	"V(di`shevel ,)"
disil`lusion	Suffix	"V(disil`lusion ,)"
dis`joint	Suffix	"V(`joint ,denom)"
dis`mantle	Suffix	"V(dis`mantle ,)"
dis`mast	Suffix	"V(`mast ,denom)"
dis`member	Suffix	"V(`member ,denom)"
dis`miss	Suffix	"V(dis`miss ,)"
dis`parage	Suffix	"V(dis`parage ,)"
dis`pel	Suffix	"V(dis`pel ,)"
dis`pense	Suffix	"V(dis`pense ,)"
dis`perse	Suffix	"V(dis`perse ,)"
dis`pose	Suffix	"V(dis`pose ,)"
dis`pute	Suffix	"V(dis`pute ,)"
dis`rupt	Suffix	"V(dis`rupt ,)"
dis`sect	Suffix	"V(dis`sect ,)"
dis`semble	Suffix	"V(dis`semble ,)"
dis`seminate	Suffix	"V(dis`seminate ,)"
`dissipate	Suffix	"V(`dissipate ,)"
`dissertate	Suffix	"V(`dissertate ,)"
dis`sociate	Suffix	"V(dis`sociate ,)"
dis`solve	Suffix	"V(dis`solve ,)"
dis`suade	Suffix	"V(dis`suade ,)"
dis`till	Suffix	"V(dis`till ,)"
dis`tinguish	Suffix	"V(dis`tinguish ,)"
dis`tort	Suffix	"V(dis`tort ,)"
dis`tract	Suffix	"V(dis`tract ,)"
dis`tribute	Suffix	"V(dis`tribute ,)"
dis`turb	Suffix	"V(dis`turb ,)"
di`verge	Suffix	"V(di`verge ,)"
di`vert	Suffix	"V(di`vert ,)"
di`vest	Suffix	"V(di`vest ,)"
di`vide	Suffix	"V(di`vide ,)"
di`vine	Suffix	"V(di`vine ,)"
di`vulge	Suffix	"V(di`vulge ,)"
`dock	Suffix	"V(`dock ,)"
`dodge	Suffix	"V(`dodge ,)"
`doff	Suffix	"V(`doff ,)"
`dole	Suffix	"V(`dole ,)"
do`mesticate	Suffix	"V(do`mestic ,deadj)"
`dominate	Suffix	"V(`dominate ,)"
domi`neer	Suffix	"V(domi`neer ,)"
`don	Suffix	"V(`don ,)"
`donate	Suffix	"V(`donate ,)"
`doorkeep	Suffix	"V(`doorkeep ,boundstem)"
`dote	Suffix	"V(`dote ,)"
`douse	Suffix	"V(`douse ,)"
`down	Suffix	"V(`down ,)"
`downplay	Suffix	"V(`downplay ,)"
`downsize	Suffix	"V(`downsize ,)"
`doze	Suffix	"V(`doze ,)"
`drag	Suffix	"V(`drag ,)"
`draggle	Suffix	"V(`draggle ,)"
`dramatize	Suffix	"V(`drama ,denom)"
`dredge	Suffix	"V(`dredge ,)"
`drench	Suffix	"V(`drench ,)"
`dressmake	Suffix	"V(`dressmake ,boundstem)"
`drone	Suffix	"V(`drone ,)"
`droop	Suffix	"V(`droop ,)"
`drown	Suffix	"V(`drown ,)"
`drowse	Suffix	"V(`drowse ,)"
`drub	Suffix	"V(`drub ,)"
`dub	Suffix	"V(`dub ,)"
`duck	Suffix	"V(`duck ,)"
`dun	Suffix	"V(`dun ,)"
`dwindle	Suffix	"V(`dwindle ,)"
`earn	Suffix	"V(`earn ,)"
`eavesdrop	Suffix	"V(`eavesdrop ,)"
`edify	Suffix	"V(`edify ,)"
`edit	Suffix	"V(`edit ,)"
`educate	Suffix	"V(`educate ,)"
ef`face	Suffix	"V(ef`face ,)"
ef`fectuate	Suffix	"V(ef`fectuate ,)"
effer`vesce	Suffix	"V(effer`vesce ,)"
efflo`resce	Suffix	"V(efflo`resce ,)"
ef`fuse	Suffix	"V(ef`fuse ,)"
e`jaculate	Suffix	"V(e`jaculate ,)"
e`ject	Suffix	"V(e`ject ,)"
`eke	Suffix	"V(`eke ,)"
e`lapse	Suffix	"V(e`lapse ,)"
e`late	Suffix	"V(e`late ,)"
`elect	Suffix	"V(`elect ,)"
e`lectrify	Suffix	"V(e`lectric ,deadj)"
e`lectrocute	Suffix	"V(e`lectrocute ,)"
`elevate	Suffix	"V(`elevate ,)"
e`licit	Suffix	"V(e`licit ,)"
e`lide	Suffix	"V(e`lide ,)"
e`liminate	Suffix	"V(e`liminate ,)"
e`longate	Suffix	"V(e`longate ,)"
e`lope	Suffix	"V(e`lope ,)"
e`lucidate	Suffix	"V(e`lucidate ,)"
e`lude	Suffix	"V(e`lude ,)"
e`maciate	Suffix	"V(e`maciate ,)"
`emanate	Suffix	"V(`emanate ,)"
e`mancipate	Suffix	"V(e`mancipate ,)"
e`masculate	Suffix	"V(e`masculate ,)"
em`balm	Suffix	"V(em`balm ,)"
em`bark	Suffix	"V(em`bark ,)"
em`barrass	Suffix	"V(em`barrass ,)"
em`bed	Suffix	"V(em`bed ,)"
em`bellish	Suffix	"V(em`bellish ,)"
em`bezzle	Suffix	"V(em`bezzle ,)"
em`bolden	Suffix	"V(`bold ,deadj)"
em`boss	Suffix	"V(em`boss ,)"
em`bower	Suffix	"V(em`bower ,)"
em`brace	Suffix	"V(em`brace ,)"
em`broider	Suffix	"V(em`broider ,)"
em`broil	Suffix	"V(em`broil ,)"
e`mend	Suffix	"V(e`mend ,)"
e`merge	Suffix	"V(e`merge ,)"
`emigrate	Suffix	"V(`emigrate ,)"
e`mit	Suffix	"V(e`mit ,)"
`emphasize	Suffix	"V(`emphasize ,)"
em`ploy	Suffix	"V(em`ploy ,)"
`emulate	Suffix	"V(`emulate ,)"
e`mulsify	Suffix	"V(e`mulsify ,)"
en`act	Suffix	"V(`act ,)"
en`amor	Suffix	"V(en`amor ,)"
en`amour	Suffix	"V(en`amour ,)"
en`capsulate	Suffix	"V(`capsule ,denom)"
en`case	Suffix	"V(`case ,denom)"
en`chant	Suffix	"V(en`chant ,)"
en`close	Suffix	"V(`close ,)"
en`compass	Suffix	"V(en`compass ,)"
en`crypt	Suffix	"V(en`crypt ,)"
en`croach	Suffix	"V(en`croach ,)"
en`cumber	Suffix	"V(en`cumber ,)"
en`dorse	Suffix	"V(en`dorse ,)"
en`dow	Suffix	"V(en`dow ,)"
en`due	Suffix	"V(en`due ,)"
en`dure	Suffix	"V(en`dure ,)"
`energize	Suffix	"V(`energy ,denom)"
`enervate	Suffix	"V(`enervate ,)"
en`fold	Suffix	"V(`fold ,)"
en`force	Suffix	"V(`force ,)"
en`gage	Suffix	"V(en`gage ,)"
en`gender	Suffix	"V(en`gender ,)"
engin`eer	Suffix	"V(`engine ,denom)"
en`graft	Suffix	"V(`graft ,)"
en`grave	Suffix	"V(en`grave ,)"
en`gross	Suffix	"V(en`gross ,)"
en`gulf	Suffix	"V(en`gulf ,)"
en`hance	Suffix	"V(en`hance ,)"
en`join	Suffix	"V(en`join ,)"
en`kindle	Suffix	"V(`kindle ,)"
en`lighten	Suffix	"V(`light ,denom)"
en`liven	Suffix	"V(`live ,deadj)"
en`list	Suffix	"V(en`list ,)"
en`quire	Suffix	"V(en`quire ,)"
en`roll	Suffix	"V(en`roll ,)"
en`sanguine	Suffix	"V(en`sanguine ,)"
en`sconce	Suffix	"V(en`sconce ,)"
en`sue	Suffix	"V(en`sue ,)"
`enter	Suffix	"V(`enter ,)"
enter`tain	Suffix	"V(enter`tain ,)"
en`tail	Suffix	"V(en`tail ,)"
en`tangle	Suffix	"V(`tangle ,rev)"
en`thrall	Suffix	"V(en`thrall ,)"
en`tice	Suffix	"V(en`tice ,)"
en`treat	Suffix	"V(en`treat ,)"
e`numerate	Suffix	"V(e`numerate ,)"
e`nunciate	Suffix	"V(e`nunciate ,)"
en`velop	Suffix	"V(en`velop ,)"
en`visage	Suffix	"V(en`visage ,)"
e`quate	Suffix	"V(e`quate ,)"
e`quilibrate	Suffix	"V(e`quilibrate ,)"
e`quip	Suffix	"V(e`quip ,)"
`equipoise	Suffix	"V(`equipoise ,)"
e`quivocate	Suffix	"V(e`quivocate ,)"
e`radicate	Suffix	"V(e`radicate ,)"
e`rase	Suffix	"V(e`rase ,)"
e`rode	Suffix	"V(e`rode ,)"
`err	Suffix	"V(`err ,)"
e`rupt	Suffix	"V(e`rupt ,)"
`escalate	Suffix	"V(`escalate ,)"
es`chew	Suffix	"V(es`chew ,)"
es`cort	Suffix	"V(es`cort ,)"
es`pouse	Suffix	"V(es`pouse ,)"
es`py	Suffix	"V(es`py ,)"
es`say	Suffix	"V(es`say ,)"
es`tablish	Suffix	"V(es`tablish ,)"
es`top	Suffix	"V(es`top ,)"
es`trange	Suffix	"V(es`trange ,)"
`etch	Suffix	"V(`etch ,)"
`etiolate	Suffix	"V(`etiolate ,)"
`eulogize	Suffix	"V(`eulogy ,denom)"
e`vacuate	Suffix	"V(e`vacuate ,)"
e`vade	Suffix	"V(e`vade ,)"
e`valuate	Suffix	"V(e`valuate ,)"
evan`esce	Suffix	"V(evan`esce ,)"
e`vaporate	Suffix	"V(e`vaporate ,)"
e`ventuate	Suffix	"V(e`ventuate ,)"
e`vict	Suffix	"V(e`vict ,)"
e`vince	Suffix	"V(e`vince ,)"
e`voke	Suffix	"V(e`voke ,)"
e`volve	Suffix	"V(e`volve ,)"
ex`acerbate	Suffix	"V(ex`acerbate ,)"
ex`act	Suffix	"V(ex`act ,)"
ex`aggerate	Suffix	"V(ex`aggerate ,)"
ex`alt	Suffix	"V(ex`alt ,)"
ex`amine	Suffix	"V(ex`amine ,)"
ex`asperate	Suffix	"V(ex`asperate ,)"
`excavate	Suffix	"V(`excavate ,)"
ex`ceed	Suffix	"V(ex`ceed ,)"
ex`cel	Suffix	"V(ex`cel ,)"
ex`cept	Suffix	"V(ex`cept ,)"
ex`cise	Suffix	"V(ex`cise ,)"
ex`cite	Suffix	"V(ex`cite ,)"
ex`claim	Suffix	"V(ex`claim ,)"
ex`clude	Suffix	"V(ex`clude ,)"
excom`municate	Suffix	"V(excom`municate ,)"
ex`coriate	Suffix	"V(ex`coriate ,)"
ex`crete	Suffix	"V(ex`crete ,)"
ex`cruciate	Suffix	"V(ex`cruciate ,)"
ex`culpate	Suffix	"V(ex`culpate ,)"
`execrate	Suffix	"V(`execrate ,)"
`execute	Suffix	"V(`execute ,)"
ex`emplify	Suffix	"V(ex`ample ,denom)"
ex`ert	Suffix	"V(ex`ert ,)"
ex`hale	Suffix	"V(ex`hale ,)"
ex`hilarate	Suffix	"V(ex`hilarate ,)"
ex`hort	Suffix	"V(ex`hort ,)"
ex`hume	Suffix	"V(ex`hume ,)"
ex`ist	Suffix	"V(ex`ist ,)"
ex`onerate	Suffix	"V(ex`onerate ,)"
`exorcise	Suffix	"V(`exorcise ,)"
ex`pand	Suffix	"V(ex`pand ,)"
ex`patiate	Suffix	"V(ex`patiate ,)"
ex`patriate	Suffix	"V(ex`patriate ,)"
ex`pect	Suffix	"V(ex`pect ,)"
ex`pectorate	Suffix	"V(ex`pectorate ,)"
`expedite	Suffix	"V(`expedite ,)"
ex`pel	Suffix	"V(ex`pel ,)"
ex`pend	Suffix	"V(ex`pend ,)"
`expiate	Suffix	"V(`expiate ,)"
ex`pire	Suffix	"V(ex`pire ,)"
ex`plain	Suffix	"V(ex`plain ,)"
`explicate	Suffix	"V(`explicate ,)"
ex`plode	Suffix	"V(ex`plode ,)"
ex`ploit	Suffix	"V(ex`ploit ,)"
ex`plore	Suffix	"V(ex`plore ,)"
expo`nentiate	Suffix	"V(ex`ponent ,denom)"
ex`port	Suffix	"V(ex`port ,)"
ex`pose	Suffix	"V(ex`pose ,)"
ex`posit	Suffix	"V(ex`posit ,)"
ex`pound	Suffix	"V(ex`pound ,)"
ex`press	Suffix	"V(ex`press ,)"
ex`propriate	Suffix	"V(ex`propriate ,)"
ex`punge	Suffix	"V(ex`punge ,)"
`expurgate	Suffix	"V(`expurgate ,)"
ex`sanguinate	Suffix	"V(ex`sanguinate ,)"
ex`tend	Suffix	"V(ex`tend ,)"
ex`tenuate	Suffix	"V(ex`tenuate ,)"
ex`terminate	Suffix	"V(ex`terminate ,)"
ex`tinguish	Suffix	"V(ex`tinguish ,)"
`extirpate	Suffix	"V(`extirpate ,)"
ex`tol	Suffix	"V(ex`tol ,)"
ex`tort	Suffix	"V(ex`tort ,)"
ex`tract	Suffix	"V(ex`tract ,)"
`extradite	Suffix	"V(`extradite ,)"
ex`trapolate	Suffix	"V(ex`trapolate ,)"
`extricate	Suffix	"V(`extricate ,)"
ex`trude	Suffix	"V(ex`trude ,)"
ex`ude	Suffix	"V(ex`ude ,)"
ex`ult	Suffix	"V(ex`ult ,)"
`fabricate	Suffix	"V(`fabricate ,)"
fa`cilitate	Suffix	"V(fa`cilitate ,)"
`fade	Suffix	"V(`fade ,)"
`fag	Suffix	"V(`fag ,)"
`fail	Suffix	"V(`fail ,)"
`faint	Suffix	"V(`faint ,)"
`falter	Suffix	"V(`falter ,)"
`famish	Suffix	"V(`famish ,)"
`fan	Suffix	"V(`fan ,)"
`fantasize	Suffix	"V(`fantasy ,denom)"
`fare	Suffix	"V(`fare ,)"
`fascinate	Suffix	"V(`fascinate ,)"
`fathom	Suffix	"V(`fathom ,)"
`fawn	Suffix	"V(`fawn ,)"
`faze	Suffix	"V(`faze ,)"
`feign	Suffix	"V(`feign ,)"
`feint	Suffix	"V(`feint ,)"
`fell	Suffix	"V(`fell ,)"
`fend	Suffix	"V(`fend ,)"
fer`ment	Suffix	"V(fer`ment ,)"
`fetch	Suffix	"V(`fetch ,)"
`fidget	Suffix	"V(`fidget ,)"
`filch	Suffix	"V(`filch ,)"
`fill	Suffix	"V(`fill ,)"
`fillip	Suffix	"V(`fillip ,)"
`filmmake	Suffix	"V(`filmmake ,boundstem)"
`finish	Suffix	"V(`finish ,)"
`firefight	Suffix	"V(`firefight ,boundstem)"
`fixate	Suffix	"V(`fixate ,)"
`fizz	Suffix	"V(`fizz ,)"
`fizzle	Suffix	"V(`fizzle ,)"
`flabbergast	Suffix	"V(`flabbergast ,)"
`flagellate	Suffix	"V(`flagellate ,)"
`flag	Suffix	"V(`flag ,)"
`flail	Suffix	"V(`flail ,)"
`flap	Suffix	"V(`flap ,)"
`flatter	Suffix	"V(`flatter ,)"
`flaunt	Suffix	"V(`flaunt ,)"
`fledge	Suffix	"V(`fledge ,)"
`fletch	Suffix	"V(`fletch ,)"
`flex	Suffix	"V(`flex ,)"
`flick	Suffix	"V(`flick ,)"
`flinch	Suffix	"V(`flinch ,)"
`flip	Suffix	"V(`flip ,)"
`flipflop	Suffix	"V(`flipflop ,)"
`flit	Suffix	"V(`flit ,)"
`float	Suffix	"V(`float ,)"
`flog	Suffix	"V(`flog ,)"
`flounce	Suffix	"V(`flounce ,)"
`flounder	Suffix	"V(`flounder ,)"
`flourish	Suffix	"V(`flourish ,)"
`flout	Suffix	"V(`flout ,)"
`flub	Suffix	"V(`flub ,)"
`fluctuate	Suffix	"V(`fluctuate ,)"
`flunk	Suffix	"V(`flunk ,)"
fluo`resce	Suffix	"V(fluo`resce ,)"
`fluoridate	Suffix	"V(`fluoride ,denom)"
`flush	Suffix	"V(`flush ,)"
`fluster	Suffix	"V(`fluster ,)"
`flutter	Suffix	"V(`flutter ,)"
`foil	Suffix	"V(`foil ,)"
`foist	Suffix	"V(`foist ,)"
`foliate	Suffix	"V(`foliate ,)"
`follow	Suffix	"V(`follow ,)"
`foment	Suffix	"V(`foment ,)"
`fondle	Suffix	"V(`fondle ,)"
`foot	Suffix	"V(`foot ,)"
`forage	Suffix	"V(`forage ,)"
`ford	Suffix	"V(`ford ,)"
fore`bode	Suffix	"V(fore`bode ,)"
`forfend	Suffix	"V(`forfend ,)"
`formulate	Suffix	"V(`formulate ,)"
`fornicate	Suffix	"V(`fornicate ,)"
`fortify	Suffix	"V(`fortify ,)"
`forward	Suffix	"V(`forward ,)"
`foster	Suffix	"V(`foster ,)"
`found	Suffix	"V(`found ,)"
`founder	Suffix	"V(`founder ,)"
`fractionate	Suffix	"V(`fraction ,denom)"
`fraternize	Suffix	"V(`fraternize ,)"
`fray	Suffix	"V(`fray ,)"
`frazzle	Suffix	"V(`frazzle ,)"
free`wheel	Suffix	"V(free`wheel ,)"
free`think	Suffix	"V(free`think ,boundstem)"
`fret	Suffix	"V(`fret ,)"
`frighten	Suffix	"V(`fright ,denom)"
`frisk	Suffix	"V(`frisk ,)"
`fritter	Suffix	"V(`fritter ,)"
`frizzle	Suffix	"V(`frizzle ,)"
`frolicked	Clitic	"V(`frolic ,ed)"
`frolicked	PT_Suffix	"V(`frolic ,en)"
`frolicking	PT_Suffix	"V(`frolic ,ing)"
`fructify	Suffix	"V(`fructify ,)"
`frustrate	Suffix	"V(`frustrate ,)"
`fry	Suffix	"V(`fry ,)"
`fuddle	Suffix	"V(`fuddle ,)"
ful`fil	Suffix	"V(ful`fil ,)"
ful`fill	Suffix	"V(ful`fill ,)"
`fulminate	Suffix	"V(`fulminate ,)"
`fumigate	Suffix	"V(`fumigate ,)"
`furbish	Suffix	"V(`furbish ,)"
`furl	Suffix	"V(`furl ,rev)"
`furnish	Suffix	"V(`furnish ,)"
`further	Suffix	"V(`further ,)"
`fuse	Suffix	"V(`fuse ,)"
`gab	Suffix	"V(`gab ,)"
`gabble	Suffix	"V(`gabble ,)"
`gad	Suffix	"V(`gad ,)"
`gag	Suffix	"V(`gag ,)"
`gallivant	Suffix	"V(`gallivant ,)"
`galvanize	Suffix	"V(`galvanize ,)"
`gambol	Suffix	"V(`gambol ,)"
`gander	Suffix	"V(`gander ,)"
`gape	Suffix	"V(`gape ,)"
`garble	Suffix	"V(`garble ,)"
`gargle	Suffix	"V(`gargle ,)"
`gasify	Suffix	"V(`gas ,denom)"
`gatekeep	Suffix	"V(`gatekeep ,boundstem)"
`gather	Suffix	"V(`gather ,)"
`gawk	Suffix	"V(`gawk ,)"
`gaze	Suffix	"V(`gaze ,)"
`gee	Suffix	"V(`gee ,)"
`geld	Suffix	"V(`geld ,)"
`generate	Suffix	"V(`generate ,)"
`germinate	Suffix	"V(`germinate ,)"
`gestate	Suffix	"V(`gestate ,)"
ges`ticulate	Suffix	"V(ges`ticulate ,)"
`giddap	Suffix	"V(`giddap ,)"
`gild	Suffix	"V(`gild ,)"
`glaciate	Suffix	"V(`glaciate ,)"
`glean	Suffix	"V(`glean ,)"
`glide	Suffix	"V(`glide ,)"
`glimmer	Suffix	"V(`glimmer ,)"
`glint	Suffix	"V(`glint ,)"
`glisten	Suffix	"V(`glisten ,)"
`glister	Suffix	"V(`glister ,)"
`glitter	Suffix	"V(`glitter ,)"
`gloat	Suffix	"V(`gloat ,)"
`glom	Suffix	"V(`glom ,)"
`glorify	Suffix	"V(`glory ,denom)"
`glower	Suffix	"V(`glower ,)"
`glycerinate	Suffix	"V(`glycerin ,denom)"
`gnarl	Suffix	"V(`gnarl ,)"
`gnash	Suffix	"V(`gnash ,)"
`gnaw	Suffix	"V(`gnaw ,)"
`gobble	Suffix	"V(`gobble ,)"
`goggle	Suffix	"V(`goggle ,)"
`gore	Suffix	"V(`gore ,)"
`gorge	Suffix	"V(`gorge ,)"
`gouge	Suffix	"V(`gouge ,)"
`govern	Suffix	"V(`govern ,)"
`gradate	Suffix	"V(`gradate ,)"
`granulate	Suffix	"V(`granule ,denom)"
`grapple	Suffix	"V(`grapple ,)"
`grate	Suffix	"V(`grate ,)"
`gratify	Suffix	"V(`gratify ,)"
`gravitate	Suffix	"V(`gravitate ,)"
`gray	Suffix	"V(`gray ,)"
`graze	Suffix	"V(`graze ,)"
`greet	Suffix	"V(`greet ,)"
`grey	Suffix	"V(`grey ,)"
`grieve	Suffix	"V(`grieve ,)"
`grizzle	Suffix	"V(`grizzle ,)"
`grope	Suffix	"V(`grope ,)"
`gross	Suffix	"V(`gross ,)"
`grovel	Suffix	"V(`grovel ,)"
`grumble	Suffix	"V(`grumble ,)"
`gunsling	Suffix	"V(`gunsling ,boundstem)"
`gush	Suffix	"V(`gush ,)"
`gutter	Suffix	"V(`gutter ,)"
`guzzle	Suffix	"V(`guzzle ,)"
`gyp	Suffix	"V(`gyp ,)"
`gyrate	Suffix	"V(`gyrate ,)"
ha`bituate	Suffix	"V(`habit ,denom)"
`hackney	Suffix	"V(`hackney ,)"
`haggle	Suffix	"V(`haggle ,)"
`hairdress	Suffix	"V(`hairdress ,boundstem)"
`hallow	Suffix	"V(`hallow ,rev)"
hal`lucinate	Suffix	"V(hal`lucinate ,)"
`halve	Suffix	"V(`halve ,)"
`hamper	Suffix	"V(`hamper ,)"
`hand	Suffix	"V(`hand ,rev)"
`handle	Suffix	"V(`handle ,)"
`hanker	Suffix	"V(`hanker ,)"
`happen	Suffix	"V(`happen ,)"
ha`rass	Suffix	"V(ha`rass ,)"
`hardboil	Suffix	"V(`hardboil ,)"
`hark	Suffix	"V(`hark ,)"
`harken	Suffix	"V(`harken ,)"
`harmonize	Suffix	"V(`harmony ,denom)"
`harp	Suffix	"V(`harp ,)"
`harrass	Suffix	"V(`harrass ,)"
`harrow	Suffix	"V(`harrow ,)"
`harry	Suffix	"V(`harry ,)"
`hasten	Suffix	"V(`haste ,denom)"
`hatch	Suffix	"V(`hatch ,)"
`haunt	Suffix	"V(`haunt ,)"
`hawk	Suffix	"V(`hawk ,)"
`head	Suffix	"V(`head ,)"
`headquarter	Suffix	"V(`headquarter ,)"
`heal	Suffix	"V(`heal ,)"
`hearken	Suffix	"V(`hearken ,)"
`heartbreak	Suffix	"V(`heartbreak ,boundstem)"
`hearten	Suffix	"V(`hearten ,)"
`heckle	Suffix	"V(`heckle ,)"
`hector	Suffix	"V(`hector ,)"
`heel	Suffix	"V(`heel ,)"
`heft	Suffix	"V(`heft ,)"
`heighten	Suffix	"V(`height ,denom)"
`henpeck	Suffix	"V(`henpeck ,)"
`hesitate	Suffix	"V(`hesitate ,)"
`hibernate	Suffix	"V(`hibernate ,)"
`hie	Suffix	"V(`hie ,)"
`hightail	Suffix	"V(`hightail ,)"
`hijack	Suffix	"V(`hijack ,)"
`hinder	Suffix	"V(`hinder ,)"
`hire	Suffix	"V(`hire ,)"
`hitchhike	Suffix	"V(`hitchhike ,)"
`hobble	Suffix	"V(`hobble ,)"
`homebreak	Suffix	"V(`homebreak ,boundstem)"
`homemake	Suffix	"V(`homemake ,boundstem)"
`homeown	Suffix	"V(`homeown ,boundstem)"
ho`mogenize	Suffix	"V(ho`mogenize ,)"
`hone	Suffix	"V(`hone ,)"
`hoodwink	Suffix	"V(`hoodwink ,)"
`horrify	Suffix	"V(`horrify ,)"
`housekeep	Suffix	"V(`housekeep ,boundstem)"
`hove	Suffix	"V(`hove ,)"
`hover	Suffix	"V(`hover ,)"
`huddle	Suffix	"V(`huddle ,)"
`huff	Suffix	"V(`huff ,)"
`hum	Suffix	"V(`hum ,)"
hu`miliate	Suffix	"V(hu`miliate ,)"
`hunch	Suffix	"V(`hunch ,)"
`hunker	Suffix	"V(`hunker ,)"
`hurl	Suffix	"V(`hurl ,)"
`hurtle	Suffix	"V(`hurtle ,)"
`hustle	Suffix	"V(`hustle ,)"
`hybridize	Suffix	"V(`hybrid ,denom)"
`hydrate	Suffix	"V(`hydrate ,)"
`hydrogenate	Suffix	"V(`hydrogen ,denom)"
`hyped	Clitic	"V(`hype ,ed)"
`hyped	PT_Suffix	"V(`hype ,en)"
`hyping	PT_Suffix	"V(`hype ,ing)"
`hyphenate	Suffix	"V(`hyphen ,denom)"
`hypnotize	Suffix	"V(`hypnotize ,)"
hy`pothesize	Suffix	"V(hy`pothesize ,)"
`ideate	Suffix	"V(i`dea ,denom)"
i`dentify	Suffix	"V(i`dentify ,)"
ig`nite	Suffix	"V(ig`nite ,)"
ig`nore	Suffix	"V(ig`nore ,)"
il`luminate	Suffix	"V(il`luminate ,)"
il`lumine	Suffix	"V(il`lumine ,)"
`illustrate	Suffix	"V(`illustrate ,)"
i`magine	Suffix	"V(i`magine ,)"
im`bed	Suffix	"V(im`bed ,)"
im`bibe	Suffix	"V(im`bibe ,)"
im`brue	Suffix	"V(im`brue ,)"
im`bue	Suffix	"V(im`bue ,)"
`imitate	Suffix	"V(`imitate ,)"
im`merse	Suffix	"V(im`merse ,)"
`immigrate	Suffix	"V(`immigrate ,)"
`immolate	Suffix	"V(`immolate ,)"
im`pair	Suffix	"V(im`pair ,)"
im`pale	Suffix	"V(im`pale ,)"
im`part	Suffix	"V(im`part ,)"
im`passion	Suffix	"V(`passion ,denom)"
im`peach	Suffix	"V(im`peach ,)"
im`pede	Suffix	"V(im`pede ,)"
im`pel	Suffix	"V(im`pel ,)"
im`pend	Suffix	"V(im`pend ,)"
im`peril	Suffix	"V(`peril ,denom)"
im`personate	Suffix	"V(`person ,denom)"
im`pinge	Suffix	"V(im`pinge ,)"
im`plant	Suffix	"V(`plant ,denom)"
`implicate	Suffix	"V(`implicate ,)"
im`plode	Suffix	"V(im`plode ,)"
im`plore	Suffix	"V(im`plore ,)"
im`ply	Suffix	"V(im`ply ,)"
im`port	Suffix	"V(im`port ,)"
impor`tune	Suffix	"V(impor`tune ,)"
im`pose	Suffix	"V(im`pose ,)"
im`pound	Suffix	"V(im`pound ,)"
im`poverish	Suffix	"V(im`poverish ,)"
`imprecate	Suffix	"V(`imprecate ,)"
im`pregnate	Suffix	"V(im`pregnate ,)"
im`press	Suffix	"V(im`press ,)"
im`print	Suffix	"V(im`print ,)"
im`prison	Suffix	"V(`prison ,denom)"
im`prove	Suffix	"V(im`prove ,)"
`improvise	Suffix	"V(`improvise ,)"
im`pugn	Suffix	"V(im`pugn ,)"
im`pute	Suffix	"V(im`pute ,)"
i`naugurate	Suffix	"V(i`naugurate ,)"
in`cant	Suffix	"V(in`cant ,)"
inca`pacitate	Suffix	"V(ca`pacity ,denom)"
in`carcerate	Suffix	"V(in`carcerate ,)"
in`cinerate	Suffix	"V(in`cinerate ,)"
in`cise	Suffix	"V(in`cise ,)"
in`cite	Suffix	"V(in`cite ,)"
in`cline	Suffix	"V(in`cline ,)"
in`close	Suffix	"V(in`close ,)"
in`clude	Suffix	"V(in`clude ,)"
in`corporate	Suffix	"V(in`corporate ,)"
in`crease	Suffix	"V(in`crease ,)"
in`criminate	Suffix	"V(in`criminate ,)"
`incubate	Suffix	"V(`incubate ,)"
in`culcate	Suffix	"V(in`culcate ,)"
in`cur	Suffix	"V(in`cur ,)"
in`demnify	Suffix	"V(in`demnify ,)"
in`dent	Suffix	"V(in`dent ,)"
`indicate	Suffix	"V(`indicate ,)"
in`dict	Suffix	"V(in`dict ,)"
indis`pose	Suffix	"V(indis`pose ,)"
indi`viduate	Suffix	"V(indi`vidual ,denom)"
in`doctrinate	Suffix	"V(`doctrine ,denom)"
in`duce	Suffix	"V(in`duce ,)"
in`duct	Suffix	"V(in`duct ,)"
in`dulge	Suffix	"V(in`dulge ,)"
in`dwell	Suffix	"V(in`dwell ,)"
in`ebriate	Suffix	"V(in`ebriate ,)"
in`farct	Suffix	"V(in`farct ,)"
in`fatuate	Suffix	"V(in`fatuate ,)"
in`fect	Suffix	"V(in`fect ,)"
in`fer	Suffix	"V(in`fer ,)"
in`fest	Suffix	"V(in`fest ,)"
`infight	Suffix	"V(`infight ,)"
in`filtrate	Suffix	"V(in`filtrate ,)"
in`flame	Suffix	"V(in`flame ,)"
in`flate	Suffix	"V(in`flate ,)"
in`flect	Suffix	"V(in`flect ,)"
in`flict	Suffix	"V(in`flict ,)"
in`form	Suffix	"V(in`form ,)"
in`fract	Suffix	"V(in`fract ,)"
in`fringe	Suffix	"V(in`fringe ,)"
in`furiate	Suffix	"V(in`furiate ,)"
in`fuse	Suffix	"V(in`fuse ,)"
`ingather	Suffix	"V(`ingather ,)"
in`gest	Suffix	"V(in`gest ,)"
in`gratiate	Suffix	"V(in`gratiate ,)"
in`habit	Suffix	"V(in`habit ,)"
in`hale	Suffix	"V(in`hale ,)"
in`here	Suffix	"V(in`here ,)"
in`herit	Suffix	"V(in`herit ,)"
in`hibit	Suffix	"V(in`hibit ,)"
i`nitiate	Suffix	"V(i`nitiate ,)"
in`ject	Suffix	"V(in`ject ,)"
`injure	Suffix	"V(`injure ,)"
`inlay	Suffix	"V(`inlay ,)"
`innovate	Suffix	"V(`innovate ,)"
i`noculate	Suffix	"V(i`noculate ,)"
in`quire	Suffix	"V(in`quire ,)"
in`scribe	Suffix	"V(in`scribe ,)"
in`seminate	Suffix	"V(in`seminate ,)"
in`sert	Suffix	"V(in`sert ,)"
in`sinuate	Suffix	"V(in`sinuate ,)"
in`sist	Suffix	"V(in`sist ,)"
in`spect	Suffix	"V(in`spect ,)"
in`spire	Suffix	"V(in`spire ,)"
in`stall	Suffix	"V(in`stall ,)"
in`stantiate	Suffix	"V(`instance ,denom)"
in`state	Suffix	"V(in`state ,)"
`instigate	Suffix	"V(`instigate ,)"
in`still	Suffix	"V(in`still ,)"
in`struct	Suffix	"V(in`struct ,)"
`insulate	Suffix	"V(`insulate ,)"
in`sult	Suffix	"V(in`sult ,)"
in`sure	Suffix	"V(in`sure ,)"
`integrate	Suffix	"V(`integrate ,)"
in`tend	Suffix	"V(in`tend ,)"
in`ter	Suffix	"V(in`ter ,)"
inter`calate	Suffix	"V(inter`calate ,)"
inter`cept	Suffix	"V(inter`cept ,)"
inter`dict	Suffix	"V(inter`dict ,)"
inter`fere	Suffix	"V(inter`fere ,)"
inter`ject	Suffix	"V(inter`ject ,)"
inter`mit	Suffix	"V(inter`mit ,)"
in`tern	Suffix	"V(in`tern ,)"
in`terpolate	Suffix	"V(in`terpolate ,)"
in`terpret	Suffix	"V(in`terpret ,)"
in`terrogate	Suffix	"V(in`terrogate ,)"
inter`rupt	Suffix	"V(inter`rupt ,)"
inter`sect	Suffix	"V(inter`sect ,)"
inter`sperse	Suffix	"V(inter`sperse ,)"
in`terstice	Suffix	"V(in`terstice ,)"
inter`twine	Suffix	"V(inter`twine ,)"
inter`vene	Suffix	"V(inter`vene ,)"
`intimate	Suffix	"V(`intimate ,)"
in`timidate	Suffix	"V(in`timidate ,)"
`intonate	Suffix	"V(`intonate ,)"
in`tone	Suffix	"V(in`tone ,)"
in`toxicate	Suffix	"V(in`toxicate ,)"
in`trench	Suffix	"V(in`trench ,)"
in`trigue	Suffix	"V(in`trigue ,)"
intro`duce	Suffix	"V(intro`duce ,)"
intro`ject	Suffix	"V(intro`ject ,)"
intro`spect	Suffix	"V(intro`spect ,)"
in`trude	Suffix	"V(in`trude ,)"
in`tuit	Suffix	"V(in`tuit ,)"
`inundate	Suffix	"V(`inundate ,)"
i`nure	Suffix	"V(i`nure ,)"
in`vade	Suffix	"V(in`vade ,)"
in`validate	Suffix	"V(`valid ,deadj)"
in`veigh	Suffix	"V(in`veigh ,)"
in`veigle	Suffix	"V(in`veigle ,)"
in`vent	Suffix	"V(in`vent ,)"
in`vert	Suffix	"V(in`vert ,)"
in`vest	Suffix	"V(in`vest ,)"
in`vestigate	Suffix	"V(in`vestigate ,)"
in`vigorate	Suffix	"V(in`vigorate ,)"
in`vite	Suffix	"V(in`vite ,)"
`invocate	Suffix	"V(`invocate ,)"
in`voke	Suffix	"V(in`voke ,)"
`involute	Suffix	"V(`involute ,)"
in`volve	Suffix	"V(in`volve ,)"
`irk	Suffix	"V(`irk ,)"
ir`radiate	Suffix	"V(ir`radiate ,)"
`irrigate	Suffix	"V(`irrigate ,)"
`irritate	Suffix	"V(`irritate ,)"
ir`rupt	Suffix	"V(ir`rupt ,)"
`isolate	Suffix	"V(`isolate ,)"
`iterate	Suffix	"V(`iterate ,)"
`jabber	Suffix	"V(`jabber ,)"
`jade	Suffix	"V(`jade ,)"
`jag	Suffix	"V(`jag ,)"
`jangle	Suffix	"V(`jangle ,)"
`jeopardize	Suffix	"V(`jeopardy ,denom)"
`jettison	Suffix	"V(`jettison ,)"
`jilt	Suffix	"V(`jilt ,)"
`jive	Suffix	"V(`jive ,)"
`jog	Suffix	"V(`jog ,)"
`joggle	Suffix	"V(`joggle ,)"
`join	Suffix	"V(`join ,)"
`jostle	Suffix	"V(`jostle ,)"
`jounce	Suffix	"V(`jounce ,)"
`joust	Suffix	"V(`joust ,)"
`jubilate	Suffix	"V(`jubilate ,)"
`juggle	Suffix	"V(`juggle ,)"
`juke	Suffix	"V(`juke ,)"
`jut	Suffix	"V(`jut ,)"
`juxtapose	Suffix	"V(`juxtapose ,)"
`kern	Suffix	"V(`kern ,)"
ki`bitz	Suffix	"V(ki`bitz ,)"
`kid	Suffix	"V(`kid ,)"
`kidnap	Suffix	"V(`kidnap ,)"
`kill	Suffix	"V(`kill ,)"
`kindle	Suffix	"V(`kindle ,)"
`knead	Suffix	"V(`knead ,)"
`kowtow	Suffix	"V(`kowtow ,)"
`lacerate	Suffix	"V(`lacerate ,)"
`lactate	Suffix	"V(`lactate ,)"
`lade	Suffix	"V(`lade ,rev)"
`laden	Suffix	"V(`laden ,)"
`laminate	Suffix	"V(`laminate ,)"
lam`poon	Suffix	"V(lam`poon ,)"
`landhold	Suffix	"V(`landhold ,boundstem)"
`landown	Suffix	"V(`landown ,boundstem)"
`landscape	Suffix	"V(`landscape ,)"
`languish	Suffix	"V(`languish ,)"
`lap	Suffix	"V(`lap ,)"
`last	Suffix	"V(`last ,)"
`laud	Suffix	"V(`laud ,)"
`launch	Suffix	"V(`launch ,)"
`launder	Suffix	"V(`launder ,)"
`lave	Suffix	"V(`lave ,)"
`lawbreak	Suffix	"V(`lawbreak ,boundstem)"
`lawgive	Suffix	"V(`lawgive ,boundstem)"
`lawmake	Suffix	"V(`lawmake ,boundstem)"
`lawnmow	Suffix	"V(`lawnmow ,boundstem)"
`laze	Suffix	"V(`laze ,)"
`leach	Suffix	"V(`leach ,)"
`leapfrog	Suffix	"V(`leapfrog ,)"
`leasehold	Suffix	"V(`leasehold ,boundstem)"
`leer	Suffix	"V(`leer ,)"
le`gate	Suffix	"V(le`gate ,)"
`legislate	Suffix	"V(`legislate ,)"
le`gitimize	Suffix	"V(le`gitimate ,deadj)"
`lengthen	Suffix	"V(`length ,denom)"
`lessen	Suffix	"V(`lessen ,)"
`levitate	Suffix	"V(`levitate ,)"
`levy	Suffix	"V(`levy ,)"
`liberate	Suffix	"V(`liberate ,)"
`liken	Suffix	"V(`liken ,)"
`line	Suffix	"V(`line ,)"
`linger	Suffix	"V(`linger ,)"
`liquefy	Suffix	"V(`liquid ,denom)"
`liquify	Suffix	"V(`liquid ,denom)"
`liquidate	Suffix	"V(`liquid ,denom)"
`list	Suffix	"V(`list ,)"
`listen	Suffix	"V(`listen ,)"
`litigate	Suffix	"V(`litigate ,)"
`live	Suffix	"V(`live ,)"
`loaf	Suffix	"V(`loaf ,)"
`loathe	Suffix	"V(`loathe ,)"
`lob	Suffix	"V(`lob ,)"
`lobby	Suffix	"V(`lobby ,)"
`locate	Suffix	"V(`locate ,)"
`locomote	Suffix	"V(`locomote ,)"
`loft	Suffix	"V(`loft ,)"
`loiter	Suffix	"V(`loiter ,)"
`loll	Suffix	"V(`loll ,)"
`long	Suffix	"V(`long ,)"
`loom	Suffix	"V(`loom ,)"
`lop	Suffix	"V(`lop ,)"
`lope	Suffix	"V(`lope ,)"
`low	Suffix	"V(`low ,)"
`lower	Suffix	"V(`lower ,)"
`lubricate	Suffix	"V(`lubricate ,)"
`lug	Suffix	"V(`lug ,)"
`lull	Suffix	"V(`lull ,)"
`lumber	Suffix	"V(`lumber ,)"
lumi`nesce	Suffix	"V(lumi`nesce ,)"
`lurk	Suffix	"V(`lurk ,)"
lux`uriate	Suffix	"V(`luxury ,denom)"
`lynch	Suffix	"V(`lynch ,)"
`magnify	Suffix	"V(`magnify ,)"
`maim	Suffix	"V(`maim ,)"
main`tain	Suffix	"V(main`tain ,)"
`major	Suffix	"V(`major ,)"
male`dict	Suffix	"V(male`dict ,)"
ma`lign	Suffix	"V(ma`lign ,)"
ma`linger	Suffix	"V(ma`linger ,)"
`man	Suffix	"V(`man ,)"
`manage	Suffix	"V(`manage ,)"
`mangle	Suffix	"V(`mangle ,)"
`manhandle	Suffix	"V(`manhandle ,)"
ma`nipulate	Suffix	"V(ma`nipulate ,)"
manu`mit	Suffix	"V(manu`mit ,)"
manu`facture	Suffix	"V(manu`facture ,)"
`mar	Suffix	"V(`mar ,)"
ma`raud	Suffix	"V(ma`raud ,)"
`marble	Suffix	"V(`marble ,)"
`marinate	Suffix	"V(`marinate ,)"
ma`roon	Suffix	"V(ma`roon ,)"
`marshal	Suffix	"V(`marshal ,)"
`marry	Suffix	"V(`marry ,)"
`mash	Suffix	"V(`mash ,)"
`masticate	Suffix	"V(`masticate ,)"
`masturbate	Suffix	"V(`masturbate ,)"
`match	Suffix	"V(`match ,)"
`matchmake	Suffix	"V(`matchmake ,)"
mat`riculate	Suffix	"V(mat`riculate ,)"
`matter	Suffix	"V(`matter ,)"
`maturate	Suffix	"V(ma`ture ,)"
`maul	Suffix	"V(`maul ,)"
me`ander	Suffix	"V(me`ander ,)"
`mechanize	Suffix	"V(`mechanize ,)"
`meddle	Suffix	"V(`meddle ,)"
`mediate	Suffix	"V(`mediate ,)"
`medicate	Suffix	"V(`medicate ,)"
`meditate	Suffix	"V(`meditate ,)"
`meliorate	Suffix	"V(`meliorate ,)"
`melt	Suffix	"V(`melt ,)"
`memorize	Suffix	"V(`memory ,denom)"
`mend	Suffix	"V(`mend ,)"
`menstruate	Suffix	"V(`menstruate ,)"
`merge	Suffix	"V(`merge ,)"
`merrymake	Suffix	"V(`merrymake ,boundstem)"
me`tabolize	Suffix	"V(me`tabolize ,)"
meta`morphose	Suffix	"V(meta`morphose ,)"
me`tathesize	Suffix	"V(me`tathesize ,)"
`mete	Suffix	"V(`mete ,)"
`mew	Suffix	"V(`mew ,)"
`miff	Suffix	"V(`miff ,)"
`migrate	Suffix	"V(`migrate ,)"
`militarize	Suffix	"V(`military ,denom)"
`militate	Suffix	"V(`militate ,)"
`mimic	Suffix	"V(`mimic ,)"
`mimicked	Clitic	"V(`mimic ,ed)"
`mimicked	PT_Suffix	"V(`mimic ,en)"
`mimicking	PT_Suffix	"V(`mimic ,ing)"
`mince	Suffix	"V(`mince ,)"
`mind	Suffix	"V(`mind ,)"
`mingle	Suffix	"V(`mingle ,)"
`mint	Suffix	"V(`mint ,)"
`mitigate	Suffix	"V(`mitigate ,)"
`mock	Suffix	"V(`mock ,)"
`modify	Suffix	"V(`modify ,)"
`modulate	Suffix	"V(`modulate ,)"
mo`lest	Suffix	"V(mo`lest ,)"
`mollify	Suffix	"V(`mollify ,)"
`mollycoddle	Suffix	"V(`mollycoddle ,)"
`molt	Suffix	"V(`molt ,)"
`monetarize	Suffix	"V(`monetary ,denom)"
mo`nopolize	Suffix	"V(mo`noply ,denom)"
`moo	Suffix	"V(`moo ,)"
`moor	Suffix	"V(`moor ,rev)"
`mope	Suffix	"V(`mope ,)"
`mortify	Suffix	"V(`mortify ,)"
`motivate	Suffix	"V(`motivate ,)"
`mount	Suffix	"V(`mount ,)"
`mourn	Suffix	"V(`mourn ,)"
`moviego	Suffix	"V(`moviego ,boundstem)"
`muddy	Suffix	"V(`mud ,denom)"
`muffle	Suffix	"V(`muffle ,rev)"
`mug	Suffix	"V(`mug ,)"
`mulct	Suffix	"V(`mulct ,)"
`mull	Suffix	"V(`mull ,)"
`multiplex	Suffix	"V(`multiplex ,)"
`multiply	Suffix	"V(`multiply ,)"
`mum	Suffix	"V(`mum ,)"
`mumble	Suffix	"V(`mumble ,)"
`mummify	Suffix	"V(`mummy ,denom)"
`munch	Suffix	"V(`munch ,)"
`muse	Suffix	"V(`muse ,)"
`mutate	Suffix	"V(`mutate ,)"
`mutilate	Suffix	"V(`mutilate ,)"
`mutter	Suffix	"V(`mutter ,)"
`mystify	Suffix	"V(`mystify ,)"
`nab	Suffix	"V(`nab ,)"
`nag	Suffix	"V(`nag ,)"
`narrate	Suffix	"V(`narrate ,)"
`nauseate	Suffix	"V(`nausea ,denom)"
`navigate	Suffix	"V(`navigate ,)"
ne`cessitate	Suffix	"V(ne`cessity ,denom)"
ne`gate	Suffix	"V(ne`gate ,)"
ne`gotiate	Suffix	"V(ne`gotiate ,)"
`nestle	Suffix	"V(`nestle ,)"
`newsmake	Suffix	"V(`newsmake ,boundstem)"
`nibble	Suffix	"V(`nibble ,)"
`niggle	Suffix	"V(`niggle ,)"
`nitpick	Suffix	"V(`nitpick ,)"
`nix	Suffix	"V(`nix ,)"
`nominate	Suffix	"V(`nominate ,)"
`nonplus	Suffix	"V(`nonplus ,)"
`notarize	Suffix	"V(`notary ,denom)"
`notate	Suffix	"V(`note ,denom)"
`nourish	Suffix	"V(`nourish ,)"
`nucleate	Suffix	"V(`nucleus ,denom)"
`nudge	Suffix	"V(`nudge ,)"
`numerate	Suffix	"V(`numerate ,)"
`nurture	Suffix	"V(`nurture ,)"
`nuzzle	Suffix	"V(`nuzzle ,)"
o`bey	Suffix	"V(o`bey ,)"
ob`fuscate	Suffix	"V(ob`fuscate ,)"
ob`ject	Suffix	"V(ob`ject ,)"
`obligate	Suffix	"V(`obligate ,)"
ob`lige	Suffix	"V(ob`lige ,)"
ob`literate	Suffix	"V(ob`literate ,)"
ob`serve	Suffix	"V(ob`serve ,)"
ob`sess	Suffix	"V(ob`sess ,)"
ob`struct	Suffix	"V(ob`struct ,)"
ob`tain	Suffix	"V(ob`tain ,)"
ob`trude	Suffix	"V(ob`trude ,)"
`obviate	Suffix	"V(`obviate ,)"
oc`clude	Suffix	"V(oc`clude ,)"
`occupy	Suffix	"V(`occupy ,)"
oc`cur	Suffix	"V(oc`cur ,)"
of`fend	Suffix	"V(of`fend ,)"
`offer	Suffix	"V(`offer ,)"
of`ficiate	Suffix	"V(of`ficiate ,)"
`offload	Suffix	"V(`offload ,)"
`ogle	Suffix	"V(`ogle ,)"
o`mit	Suffix	"V(o`mit ,)"
`operate	Suffix	"V(`operate ,)"
o`pine	Suffix	"V(o`pine ,)"
op`pose	Suffix	"V(op`pose ,)"
op`press	Suffix	"V(op`press ,)"
`opt	Suffix	"V(`opt ,)"
`optimise	Suffix	"V(`optimal ,deadj)"
`optimize	Suffix	"V(`optimal ,deadj)"
`orate	Suffix	"V(`orate ,)"
`orchestrate	Suffix	"V(`orchestrate ,)"
or`dain	Suffix	"V(or`dain ,)"
`organize	Suffix	"V(`organize ,)"
`orient	Suffix	"V(`orient ,)"
`orientate	Suffix	"V(`orientate ,)"
o`riginate	Suffix	"V(`origin ,denom)"
`oscillate	Suffix	"V(`oscillate ,)"
`ossify	Suffix	"V(`ossify ,)"
`ostracize	Suffix	"V(`ostracize ,)"
`oust	Suffix	"V(`oust ,)"
out`flank	Suffix	"V(`flank ,denom)"
out`fox	Suffix	"V(`fox ,denom)"
out`gun	Suffix	"V(`gun ,denom)"
out`number	Suffix	"V(`number ,denom)"
out`poll	Suffix	"V(`poll ,denom)"
out`strip	Suffix	"V(out`strip ,)"
out`wit	Suffix	"V(`wit ,denom)"
over`awe	Suffix	"V(`awe ,denom)"
over`book	Suffix	"V(`book ,)"
over`joy	Suffix	"V(`joy ,denom)"
`ovulate	Suffix	"V(`ovulate ,)"
`owe	Suffix	"V(`owe ,)"
`own	Suffix	"V(`own ,)"
`oxygenate	Suffix	"V(`oxygen ,denom)"
`pacemake	Suffix	"V(`pacemake ,boundstem)"
`pacify	Suffix	"V(`pacify ,)"
`pack	Suffix	"V(`pack ,rev)"
`paginate	Suffix	"V(`page ,denom)"
`pall	Suffix	"V(`pall ,)"
`palliate	Suffix	"V(`palliate ,)"
`palpitate	Suffix	"V(`palpitate ,)"
`pamper	Suffix	"V(`pamper ,)"
`pander	Suffix	"V(`pander ,)"
`panicked	Clitic	"V(`panic ,ed)"
`panicked	PT_Suffix	"V(`panic ,en)"
`panicking	PT_Suffix	"V(`panic ,ing)"
`pant	Suffix	"V(`pant ,)"
`paralyse	Suffix	"V(`paralyse ,)"
`paralyze	Suffix	"V(`paralyze ,)"
`parboil	Suffix	"V(`parboil ,)"
`parch	Suffix	"V(`parch ,)"
`pare	Suffix	"V(`pare ,)"
pa`renthesize	Suffix	"V(pa`renthesis ,denom)"
`parry	Suffix	"V(`parry ,)"
par`ticipate	Suffix	"V(par`ticipate ,)"
`pasteurize	Suffix	"V(`pasteurize ,)"
`pathfind	Suffix	"V(`pathfind ,boundstem)"
pa`trolled	Clitic	"V(pa`trol ,ed)"
pa`trolled	PT_Suffix	"V(pa`trol ,en)"
pa`trolling	PT_Suffix	"V(pa`trol ,ing)"
`pave	Suffix	"V(`pave ,)"
`pawn	Suffix	"V(`pawn ,)"
`peacekeep	Suffix	"V(`peacekeep ,boundstem)"
`peacemake	Suffix	"V(`peacemake ,boundstem)"
`peculate	Suffix	"V(`peculate ,)"
`peddle	Suffix	"V(`peddle ,)"
`pee	Suffix	"V(`pee ,)"
`peer	Suffix	"V(`peer ,)"
`pelt	Suffix	"V(`pelt ,)"
`pend	Suffix	"V(`pend ,)"
`penetrate	Suffix	"V(`penetrate ,)"
per`ambulate	Suffix	"V(per`ambulate ,)"
per`ceive	Suffix	"V(per`ceive ,)"
`perch	Suffix	"V(`perch ,)"
`percolate	Suffix	"V(`percolate ,)"
per`cuss	Suffix	"V(per`cuss ,)"
per`fect	Suffix	"V(per`fect ,)"
`perforate	Suffix	"V(`perforate ,)"
per`form	Suffix	"V(per`form ,)"
per`fuse	Suffix	"V(per`fuse ,)"
`perish	Suffix	"V(`perish ,)"
`perjure	Suffix	"V(`perjure ,)"
`perk	Suffix	"V(`perk ,)"
`permeate	Suffix	"V(`permeate ,)"
per`mit	Suffix	"V(per`mit ,)"
per`mute	Suffix	"V(per`mute ,)"
`perorate	Suffix	"V(`perorate ,)"
`perpetrate	Suffix	"V(`perpetrate ,)"
per`petuate	Suffix	"V(per`petuate ,)"
per`plex	Suffix	"V(per`plex ,)"
`persecute	Suffix	"V(`persecute ,)"
perse`vere	Suffix	"V(perse`vere ,)"
per`sist	Suffix	"V(per`sist ,)"
per`sonify	Suffix	"V(per`sonify ,)"
per`spire	Suffix	"V(per`spire ,)"
per`suade	Suffix	"V(per`suade ,)"
per`tain	Suffix	"V(per`tain ,)"
per`turb	Suffix	"V(per`turb ,)"
`perturbate	Suffix	"V(`perturbate ,)"
pe`ruse	Suffix	"V(pe`ruse ,)"
per`vade	Suffix	"V(per`vade ,)"
per`vert	Suffix	"V(per`vert ,)"
`pester	Suffix	"V(`pester ,)"
`pet	Suffix	"V(`pet ,)"
`peter	Suffix	"V(`peter ,)"
`petrify	Suffix	"V(`petrify ,)"
phi`lander	Suffix	"V(phi`lander ,)"
`pick	Suffix	"V(`pick ,rev)"
`picket	Suffix	"V(`picket ,)"
`picnicked	Clitic	"V(`picnic ,ed)"
`picnicked	PT_Suffix	"V(`picnic ,en)"
`picnicking	PT_Suffix	"V(`picnic ,ing)"
`piddle	Suffix	"V(`piddle ,)"
`pierce	Suffix	"V(`pierce ,)"
`pilfer	Suffix	"V(`pilfer ,)"
`pillage	Suffix	"V(`pillage ,)"
`pine	Suffix	"V(`pine ,)"
`pith	Suffix	"V(`pith ,)"
`placate	Suffix	"V(`placate ,)"
`plagiarize	Suffix	"V(`plagiarize ,)"
`please	Suffix	"V(`please ,)"
`plod	Suffix	"V(`plod ,)"
`pluck	Suffix	"V(`pluck ,)"
`plumb	Suffix	"V(`plumb ,)"
`plummet	Suffix	"V(`plummet ,)"
`plump	Suffix	"V(`plump ,)"
`plunder	Suffix	"V(`plunder ,)"
`plunk	Suffix	"V(`plunk ,)"
`ply	Suffix	"V(`ply ,)"
`poach	Suffix	"V(`poach ,)"
`politick	Suffix	"V(`politick ,)"
`pollinate	Suffix	"V(`pollen ,denom)"
pol`lute	Suffix	"V(pol`lute ,)"
`ponder	Suffix	"V(`ponder ,)"
pon`tificate	Suffix	"V(pon`tificate ,)"
`populate	Suffix	"V(`populate ,)"
`pore	Suffix	"V(`pore ,)"
`port	Suffix	"V(`port ,)"
por`tend	Suffix	"V(por`tend ,)"
por`tray	Suffix	"V(por`tray ,)"
`posit	Suffix	"V(`posit ,)"
pos`sess	Suffix	"V(pos`sess ,)"
`post	Suffix	"V(`post ,)"
post`pone	Suffix	"V(post`pone ,)"
`postulate	Suffix	"V(`postulate ,)"
`pound	Suffix	"V(`pound ,)"
`pour	Suffix	"V(`pour ,)"
`prance	Suffix	"V(`prance ,)"
`prate	Suffix	"V(`prate ,)"
`prattle	Suffix	"V(`prattle ,)"
`pray	Suffix	"V(`pray ,)"
`preach	Suffix	"V(`preach ,)"
pre`cede	Suffix	"V(pre`cede ,)"
pre`cess	Suffix	"V(pre`cess ,)"
pre`clude	Suffix	"V(pre`clude ,)"
pre`dict	Suffix	"V(pre`dict ,)"
pre`destinate	Suffix	"V(pre`destinate ,)"
predis`pose	Suffix	"V(predis`pose ,)"
pre`dominate	Suffix	"V(pre`dominate ,)"
pre`empt	Suffix	"V(pre`empt ,)"
`preen	Suffix	"V(`preen ,)"
pre`fer	Suffix	"V(pre`fer ,)"
pre`pare	Suffix	"V(pre`pare ,)"
pre`ponderate	Suffix	"V(pre`ponderate ,)"
pre`sage	Suffix	"V(pre`sage ,)"
pre`scribe	Suffix	"V(pre`scribe ,)"
pre`sent	Suffix	"V(pre`sent ,)"
pre`serve	Suffix	"V(pre`serve ,)"
pre`side	Suffix	"V(pre`side ,)"
presti`digitate	Suffix	"V(presti`digitate ,)"
pre`sume	Suffix	"V(pre`sume ,)"
pre`tend	Suffix	"V(pre`tend ,)"
pre`vail	Suffix	"V(pre`vail ,)"
pre`varicate	Suffix	"V(pre`varicate ,)"
pre`vent	Suffix	"V(pre`vent ,)"
`prime	Suffix	"V(`prime ,)"
`primp	Suffix	"V(`primp ,)"
`printmake	Suffix	"V(`printmake ,boundstem)"
`proceed	Suffix	"V(`proceed ,)"
pro`cess	Suffix	"V(pro`cess ,)"
pro`claim	Suffix	"V(pro`claim ,)"
pro`crastinate	Suffix	"V(pro`crastinate ,)"
`procreate	Suffix	"V(`procreate ,)"
pro`cure	Suffix	"V(pro`cure ,)"
`prod	Suffix	"V(`prod ,)"
pro`duce	Suffix	"V(pro`duce ,)"
pro`fess	Suffix	"V(pro`fess ,)"
`proffer	Suffix	"V(`proffer ,)"
prog`nosticate	Suffix	"V(prog`nosticate ,)"
pro`gress	Suffix	"V(pro`gress ,)"
pro`hibit	Suffix	"V(pro`hibit ,)"
pro`ject	Suffix	"V(pro`ject ,)"
pro`liferate	Suffix	"V(pro`liferate ,)"
pro`long	Suffix	"V(pro`long ,)"
pro`longate	Suffix	"V(pro`longate ,)"
pro`mote	Suffix	"V(pro`mote ,)"
`promulgate	Suffix	"V(`promulgate ,)"
pro`nounce	Suffix	"V(pro`nounce ,)"
`prop	Suffix	"V(`prop ,)"
propa`gandize	Suffix	"V(propa`ganda ,denom)"
`propagate	Suffix	"V(`propagate ,)"
pro`pel	Suffix	"V(pro`pel ,)"
`prophesy	Suffix	"V(`prophesy ,)"
pro`pitiate	Suffix	"V(pro`pitiate ,)"
pro`pose	Suffix	"V(pro`pose ,)"
pro`pound	Suffix	"V(pro`pound ,)"
`prorate	Suffix	"V(`prorate ,)"
pro`rogue	Suffix	"V(pro`rogue ,)"
pro`scribe	Suffix	"V(pro`scribe ,)"
`prosecute	Suffix	"V(`prosecute ,)"
`prospect	Suffix	"V(`prospect ,)"
`prosper	Suffix	"V(`prosper ,)"
pro`tect	Suffix	"V(pro`tect ,)"
pro`test	Suffix	"V(pro`test ,)"
pro`tract	Suffix	"V(pro`tract ,)"
pro`trude	Suffix	"V(pro`trude ,)"
pro`vide	Suffix	"V(pro`vide ,)"
pro`voke	Suffix	"V(pro`voke ,)"
`prowl	Suffix	"V(`prowl ,)"
`prune	Suffix	"V(`prune ,)"
`pry	Suffix	"V(`pry ,)"
`psych	Suffix	"V(`psych ,)"
`publish	Suffix	"V(`publish ,)"
`puke	Suffix	"V(`puke ,)"
`pulsate	Suffix	"V(`pulsate ,)"
`pulverize	Suffix	"V(`pulverize ,)"
`pummel	Suffix	"V(`pummel ,)"
`punctuate	Suffix	"V(`punctuate ,)"
`punish	Suffix	"V(`punish ,)"
`pupate	Suffix	"V(`pupate ,)"
`purl	Suffix	"V(`purl ,)"
pur`loin	Suffix	"V(pur`loin ,)"
pur`port	Suffix	"V(pur`port ,)"
`purr	Suffix	"V(`purr ,)"
`purse	Suffix	"V(`purse ,)"
pur`sue	Suffix	"V(pur`sue ,)"
pur`vey	Suffix	"V(pur`vey ,)"
`putter	Suffix	"V(`putter ,)"
`putrefy	Suffix	"V(`putrid ,deadj)"
`quaff	Suffix	"V(`quaff ,)"
`quail	Suffix	"V(`quail ,)"
`quake	Suffix	"V(`quake ,)"
`qualify	Suffix	"V(`qualify ,)"
`quantify	Suffix	"V(`quantify ,)"
`quash	Suffix	"V(`quash ,)"
`quaver	Suffix	"V(`quaver ,)"
`quell	Suffix	"V(`quell ,)"
`quench	Suffix	"V(`quench ,)"
`queued	Clitic	"V(`queue ,ed)"
`queued	PT_Suffix	"V(`queue ,en)"
`queuing	PT_Suffix	"V(`queue ,ing)"
`quibble	Suffix	"V(`quibble ,)"
`quiver	Suffix	"V(`quiver ,)"
`quizzes	Clitic	"V(`quiz ,)"
`quizzed	Clitic	"V(`quiz ,ed)"
`quizzed	PT_Suffix	"V(`quiz ,en)"
`quizzing	PT_Suffix	"V(`quiz ,ing)"
`rack	Suffix	"V(`rack ,)"
racke`teer	Suffix	"V(`racket ,denom)"
`radiate	Suffix	"V(`radiate ,)"
`rag	Suffix	"V(`rag ,)"
`rail	Suffix	"V(`rail ,)"
`ram	Suffix	"V(`ram ,)"
`ramble	Suffix	"V(`ramble ,)"
`ramify	Suffix	"V(`ramify ,)"
`rankle	Suffix	"V(`rankle ,)"
`ransack	Suffix	"V(`ransack ,)"
`rant	Suffix	"V(`rant ,)"
rap`pel	Suffix	"V(rap`pel ,)"
`rarefy	Suffix	"V(`rarefy ,)"
`rasp	Suffix	"V(`rasp ,)"
`ratify	Suffix	"V(`ratify ,)"
rati`ocinate	Suffix	"V(rati`ocinate ,)"
`ravage	Suffix	"V(`ravage ,)"
`rave	Suffix	"V(`rave ,)"
`ravel	Suffix	"V(`ravel ,rev)"
`ravish	Suffix	"V(`ravish ,)"
`raze	Suffix	"V(`raze ,)"
`razz	Suffix	"V(`razz ,)"
`reach	Suffix	"V(`reach ,)"
re`act	Suffix	"V(re`act ,)"
`ream	Suffix	"V(`ream ,)"
`reap	Suffix	"V(`reap ,)"
`rear	Suffix	"V(`rear ,)"
re`bel	Suffix	"V(re`bel ,)"
re`but	Suffix	"V(re`but ,)"
re`cant	Suffix	"V(re`cant ,)"
re`ceive	Suffix	"V(re`ceive ,)"
re`ciprocate	Suffix	"V(re`ciprocate ,)"
`reckon	Suffix	"V(`reckon ,)"
re`cline	Suffix	"V(re`cline ,)"
`recognize	Suffix	"V(`recognize ,)"
`recognise	Suffix	"V(`recognise ,)"
`reconcile	Suffix	"V(`reconcile ,)"
recon`noiter	Suffix	"V(recon`noiter ,)"
recon`noitre	Suffix	"V(recon`noitre ,)"
re`cord	Suffix	"V(re`cord ,)"
re`coup	Suffix	"V(re`coup ,)"
re`cover	Suffix	"V(re`cover ,)"
re`criminate	Suffix	"V(re`criminate ,)"
`rectify	Suffix	"V(`rectify ,)"
re`cuperate	Suffix	"V(re`cuperate ,)"
re`cur	Suffix	"V(re`cur ,)"
re`cuse	Suffix	"V(re`cuse ,)"
re`curse	Suffix	"V(re`curse ,)"
re`dact	Suffix	"V(re`dact ,)"
re`district	Suffix	"V(`district ,denom)"
re`dound	Suffix	"V(re`dound ,)"
re`duce	Suffix	"V(re`duce ,)"
`reek	Suffix	"V(`reek ,)"
re`fect	Suffix	"V(re`fect ,)"
re`fer	Suffix	"V(re`fer ,)"
re`fine	Suffix	"V(re`fine ,)"
re`flect	Suffix	"V(re`flect ,)"
re`fract	Suffix	"V(re`fract ,)"
re`frain	Suffix	"V(re`frain ,)"
re`fresh	Suffix	"V(re`fresh ,)"
re`frigerate	Suffix	"V(re`frigerate ,)"
re`fund	Suffix	"V(re`fund ,)"
re`fuse	Suffix	"V(re`fuse ,)"
re`fute	Suffix	"V(re`fute ,)"
re`gale	Suffix	"V(re`gale ,)"
re`gress	Suffix	"V(re`gress ,)"
`regulate	Suffix	"V(`regulate ,)"
re`gurgitate	Suffix	"V(re`gurgitate ,)"
reha`bilitate	Suffix	"V(reha`bilitate ,)"
re`hearse	Suffix	"V(re`hearse ,)"
reim`burse	Suffix	"V(reim`burse ,)"
rein`force	Suffix	"V(rein`force ,)"
re`ject	Suffix	"V(re`ject ,)"
re`joice	Suffix	"V(re`joice ,)"
re`juvenate	Suffix	"V(re`juvenate ,)"
re`late	Suffix	"V(re`late ,)"
re`lax	Suffix	"V(re`lax ,)"
re`lay	Suffix	"V(re`lay ,)"
re`lent	Suffix	"V(re`lent ,)"
re`lieve	Suffix	"V(re`lieve ,)"
re`linquish	Suffix	"V(re`linquish ,)"
`relish	Suffix	"V(`relish ,)"
re`ly	Suffix	"V(re`ly ,)"
re`main	Suffix	"V(re`main ,)"
re`mand	Suffix	"V(re`mand ,)"
re`mark	Suffix	"V(re`mark ,)"
re`member	Suffix	"V(re`member ,)"
re`mind	Suffix	"V(re`mind ,)"
remi`nisce	Suffix	"V(remi`nisce ,)"
re`mit	Suffix	"V(re`mit ,)"
re`monstrate	Suffix	"V(re`monstrate ,)"
re`move	Suffix	"V(re`move ,)"
re`munerate	Suffix	"V(re`munerate ,)"
`rend	Suffix	"V(`rend ,)"
`render	Suffix	"V(`render ,)"
`rendezvous	Suffix	"V(`rendezvous ,)"
`rendezvouses	Clitic	"V(`rendezvous ,s)"
`rendezvoused	Clitic	"V(`rendezvous ,ed)"
`rendezvoused	PT_Suffix	"V(`rendezvous ,en)"
re`nege	Suffix	"V(re`nege ,)"
re`new	Suffix	"V(`new ,deadj)"
re`nounce	Suffix	"V(re`nounce ,)"
`renovate	Suffix	"V(`renovate ,)"
re`nunciate	Suffix	"V(re`nunciate ,)"
re`pair	Suffix	"V(re`pair ,)"
re`patriate	Suffix	"V(re`patriate ,)"
re`peat	Suffix	"V(re`peat ,)"
re`pel	Suffix	"V(re`pel ,)"
re`pent	Suffix	"V(re`pent ,)"
repre`hend	Suffix	"V(repre`hend ,)"
repre`sent	Suffix	"V(repre`sent ,)"
re`plenish	Suffix	"V(re`plenish ,)"
`replicate	Suffix	"V(`replicate ,)"
re`press	Suffix	"V(re`press ,)"
re`prieve	Suffix	"V(re`prieve ,)"
`reprimand	Suffix	"V(`reprimand ,)"
re`prise	Suffix	"V(re`prise ,)"
re`prove	Suffix	"V(re`prove ,)"
re`pudiate	Suffix	"V(re`pudiate ,)"
re`pulse	Suffix	"V(re`pulse ,)"
re`pute	Suffix	"V(re`pute ,)"
re`quire	Suffix	"V(re`quire ,)"
re`quite	Suffix	"V(re`quite ,)"
re`scind	Suffix	"V(re`scind ,)"
`rescue	Suffix	"V(`rescue ,)"
re`semble	Suffix	"V(re`semble ,)"
re`sent	Suffix	"V(re`sent ,)"
re`serve	Suffix	"V(re`serve ,)"
re`sign	Suffix	"V(re`sign ,)"
re`sile	Suffix	"V(re`sile ,)"
re`sist	Suffix	"V(re`sist ,)"
re`solve	Suffix	"V(re`solve ,)"
`resonate	Suffix	"V(`resonate ,)"
re`sort	Suffix	"V(re`sort ,)"
re`sound	Suffix	"V(re`sound ,)"
`respirate	Suffix	"V(`respirate ,)"
re`spire	Suffix	"V(re`spire ,)"
re`spond	Suffix	"V(re`spond ,)"
`restitute	Suffix	"V(`restitute ,)"
re`store	Suffix	"V(re`store ,)"
re`strain	Suffix	"V(re`strain ,)"
re`strict	Suffix	"V(re`strict ,)"
re`sume	Suffix	"V(re`sume ,)"
re`surge	Suffix	"V(re`surge ,)"
resur`rect	Suffix	"V(resur`rect ,)"
re`suscitate	Suffix	"V(re`suscitate ,)"
re`tain	Suffix	"V(re`tain ,)"
re`taliate	Suffix	"V(re`taliate ,)"
re`tard	Suffix	"V(re`tard ,)"
`retch	Suffix	"V(`retch ,)"
re`ticulate	Suffix	"V(re`ticulate ,)"
re`tire	Suffix	"V(re`tire ,)"
re`tort	Suffix	"V(re`tort ,)"
re`tract	Suffix	"V(re`tract ,)"
re`trench	Suffix	"V(re`trench ,)"
re`trieve	Suffix	"V(re`trieve ,)"
retro`cede	Suffix	"V(retro`cede ,)"
retro`gress	Suffix	"V(retro`gress ,)"
`retrospect	Suffix	"V(`retrospect ,)"
`rev	Suffix	"V(`rev ,)"
`revved	Clitic	"V(`rev ,ed)"
`revved	PT_Suffix	"V(`rev ,en)"
`revving	PT_Suffix	"V(`rev ,ing)"
re`veal	Suffix	"V(re`veal ,)"
`revel	Suffix	"V(`revel ,)"
re`verberate	Suffix	"V(re`verberate ,)"
re`vere	Suffix	"V(re`vere ,)"
`reverence	Suffix	"V(re`vere ,)"
re`verse	Suffix	"V(re`verse ,)"
re`vert	Suffix	"V(re`vert ,)"
re`vile	Suffix	"V(re`vile ,)"
re`vise	Suffix	"V(re`vise ,)"
re`vive	Suffix	"V(re`vive ,)"
re`voke	Suffix	"V(re`voke ,)"
re`volve	Suffix	"V(re`volve ,)"
re`volt	Suffix	"V(re`volt ,)"
`rhapsodize	Suffix	"V(`rhapsody ,denom)"
`rhymed	Clitic	"V(`rhyme ,ed)"
`rhymed	PT_Suffix	"V(`rhyme ,en)"
`rhyming	PT_Suffix	"V(`rhyme ,ing)"
`rib	Suffix	"V(`rib ,)"
`ricochet	Suffix	"V(`ricochet ,)"
`riddle	Suffix	"V(`riddle ,)"
`ridicule	Suffix	"V(`ridicule ,)"
`riffle	Suffix	"V(`riffle ,)"
`rifle	Suffix	"V(`rifle ,)"
`right	Suffix	"V(`right ,)"
`rile	Suffix	"V(`rile ,)"
`roam	Suffix	"V(`roam ,)"
`rob	Suffix	"V(`rob ,)"
`rock	Suffix	"V(`rock ,)"
`roil	Suffix	"V(`roil ,)"
`roister	Suffix	"V(`roister ,)"
`rollick	Suffix	"V(`rollick ,)"
`romp	Suffix	"V(`romp ,)"
`rot	Suffix	"V(`rot ,)"
`rotate	Suffix	"V(`rotate ,)"
`rototill	Suffix	"V(`rototill ,)"
`rouse	Suffix	"V(`rouse ,)"
`roust	Suffix	"V(`roust ,)"
`rout	Suffix	"V(`rout ,)"
`rove	Suffix	"V(`rove ,)"
`row	Suffix	"V(`row ,)"
`rub	Suffix	"V(`rub ,)"
`ruffle	Suffix	"V(`ruffle ,)"
`rule	Suffix	"V(`rule ,)"
`ruminate	Suffix	"V(`ruminate ,)"
`rumple	Suffix	"V(`rumple ,)"
`rustle	Suffix	"V(`rustle ,)"
`sack	Suffix	"V(`sack ,)"
`sail	Suffix	"V(`sail ,)"
`salivate	Suffix	"V(sa`liva ,denom)"
`salvage	Suffix	"V(`salvage ,)"
`sanctify	Suffix	"V(`sanctify ,)"
`sand	Suffix	"V(`sand ,)"
`sanitate	Suffix	"V(`sanitate ,)"
`sanitize	Suffix	"V(`sanitize ,)"
`sap	Suffix	"V(`sap ,)"
sa`shay	Suffix	"V(sa`shay ,)"
`sate	Suffix	"V(`sate ,)"
`satiate	Suffix	"V(`satiate ,)"
`satisfy	Suffix	"V(`satisfy ,)"
`saturate	Suffix	"V(`saturate ,)"
`savage	Suffix	"V(`savage ,)"
`saunter	Suffix	"V(`saunter ,)"
sau`te	Suffix	"V(sau`te ,)"
`save	Suffix	"V(`save ,)"
`scald	Suffix	"V(`scald ,)"
`scale	Suffix	"V(`scale ,)"
`scamper	Suffix	"V(`scamper ,)"
`scan	Suffix	"V(`scan ,)"
`scat	Suffix	"V(`scat ,)"
`scathe	Suffix	"V(`scathe ,)"
`scatter	Suffix	"V(`scatter ,)"
`scavenge	Suffix	"V(`scavenge ,)"
`scintillate	Suffix	"V(`scintillate ,)"
`scissor	Suffix	"V(`scissor ,)"
`scoff	Suffix	"V(`scoff ,)"
`scold	Suffix	"V(`scold ,)"
`scoot	Suffix	"V(`scoot ,)"
`scorch	Suffix	"V(`scorch ,)"
`scour	Suffix	"V(`scour ,)"
`scrabble	Suffix	"V(`scrabble ,)"
`scram	Suffix	"V(`scram ,)"
`scramble	Suffix	"V(`scramble ,rev)"
`scrimp	Suffix	"V(`scrimp ,)"
`scrounge	Suffix	"V(`scrounge ,)"
`scrub	Suffix	"V(`scrub ,)"
`scrutinize	Suffix	"V(`scrutiny ,denom)"
`scud	Suffix	"V(`scud ,)"
`scuff	Suffix	"V(`scuff ,)"
`scuffle	Suffix	"V(`scuffle ,)"
`sculpt	Suffix	"V(`sculpt ,)"
`scurry	Suffix	"V(`scurry ,)"
`scuttle	Suffix	"V(`scuttle ,)"
`sear	Suffix	"V(`sear ,)"
`season	Suffix	"V(`season ,)"
se`cede	Suffix	"V(se`cede ,)"
se`clude	Suffix	"V(se`clude ,)"
`second	Suffix	"V(`second ,)"
se`crete	Suffix	"V(se`crete ,)"
se`duce	Suffix	"V(se`duce ,)"
`seem	Suffix	"V(`seem ,)"
`seep	Suffix	"V(`seep ,)"
`seethe	Suffix	"V(`seethe ,)"
`segregate	Suffix	"V(`segregate ,)"
seg`ment	Suffix	"V(seg`ment ,)"
`seize	Suffix	"V(`seize ,)"
se`lect	Suffix	"V(se`lect ,)"
se`quester	Suffix	"V(se`quester ,)"
`serve	Suffix	"V(`serve ,)"
`settle	Suffix	"V(`settle ,rev)"
`sever	Suffix	"V(`sever ,)"
`shag	Suffix	"V(`shag ,)"
`shamble	Suffix	"V(`shamble ,)"
`shatter	Suffix	"V(`shatter ,)"
`sheathe	Suffix	"V(`sheathe ,rev)"
`sheer	Suffix	"V(`sheer ,)"
shel`lacked	Clitic	"V(shel`lac ,ed)"
shel`lacked	PT_Suffix	"V(shel`lac ,en)"
shel`lacking	PT_Suffix	"V(shel`lac ,ing)"
`shelve	Suffix	"V(`shelve ,)"
`shipbuild	Suffix	"V(`shipbuild ,boundstem)"
`shirk	Suffix	"V(`shirk ,)"
`shirr	Suffix	"V(`shirr ,)"
`shoemake	Suffix	"V(`shoemake ,boundstem)"
`shoo	Suffix	"V(`shoo ,)"
`shopkeep	Suffix	"V(`shopkeep ,boundstem)"
`shoplift	Suffix	"V(`shoplift ,)"
`shore	Suffix	"V(`shore ,)"
short`change	Suffix	"V(short`change ,)"
`shrivel	Suffix	"V(`shrivel ,)"
`shuck	Suffix	"V(`shuck ,)"
`shun	Suffix	"V(`shun ,)"
`shunt	Suffix	"V(`shunt ,)"
`shy	Suffix	"V(`shy ,)"
`sic	Suffix	"V(`sic ,)"
`sidestep	Suffix	"V(`sidestep ,)"
`sidle	Suffix	"V(`sidle ,)"
`sift	Suffix	"V(`sift ,)"
`sigh	Suffix	"V(`sigh ,)"
`sightsee	Suffix	"V(`sightsee ,boundstem)"
`simmer	Suffix	"V(`simmer ,)"
`simulate	Suffix	"V(`simulate ,)"
`singe	Suffix	"V(`singe ,)"
`single	Suffix	"V(`single ,)"
`situate	Suffix	"V(`situate ,)"
`sizzle	Suffix	"V(`sizzle ,)"
`skew	Suffix	"V(`skew ,)"
`skim	Suffix	"V(`skim ,)"
`skimp	Suffix	"V(`skimp ,)"
`skulk	Suffix	"V(`skulk ,)"
`skurry	Suffix	"V(`skurry ,)"
`skydive	Suffix	"V(`skydive ,boundstem)"
`skyjack	Suffix	"V(`skyjack ,)"
`slake	Suffix	"V(`slake ,)"
`slate	Suffix	"V(`slate ,)"
`slaver	Suffix	"V(`slaver ,)"
`sleepwalk	Suffix	"V(`sleepwalk ,)"
`slew	Suffix	"V(`slew ,)"
`slither	Suffix	"V(`slither ,)"
`slog	Suffix	"V(`slog ,)"
`slop	Suffix	"V(`slop ,)"
`slosh	Suffix	"V(`slosh ,)"
`slouch	Suffix	"V(`slouch ,)"
`smart	Suffix	"V(`smart ,)"
`smatter	Suffix	"V(`smatter ,)"
`smelt	Suffix	"V(`smelt ,)"
`smooch	Suffix	"V(`smooch ,)"
`smother	Suffix	"V(`smother ,)"
`smuggle	Suffix	"V(`smuggle ,)"
`snatch	Suffix	"V(`snatch ,)"
`snick	Suffix	"V(`snick ,)"
`snicker	Suffix	"V(`snicker ,)"
`snipe	Suffix	"V(`snipe ,)"
`snivel	Suffix	"V(`snivel ,)"
`snoop	Suffix	"V(`snoop ,)"
`snooze	Suffix	"V(`snooze ,)"
`snore	Suffix	"V(`snore ,)"
`snub	Suffix	"V(`snub ,)"
`snuff	Suffix	"V(`snuff ,)"
`snuffle	Suffix	"V(`snuffle ,)"
`snuggle	Suffix	"V(`snuggle ,)"
`soak	Suffix	"V(`soak ,)"
`soar	Suffix	"V(`soar ,)"
so`licit	Suffix	"V(so`licit ,)"
so`liloquize	Suffix	"V(so`liloquy ,denom)"
`solve	Suffix	"V(`solve ,)"
`soothe	Suffix	"V(`soothe ,)"
`soothsay	Suffix	"V(`soothsay ,)"
so`phisticate	Suffix	"V(so`phisticate ,)"
`souse	Suffix	"V(`souse ,)"
`spank	Suffix	"V(`spank ,)"
`spar	Suffix	"V(`spar ,)"
`spare	Suffix	"V(`spare ,)"
`sparge	Suffix	"V(`sparge ,)"
`spatter	Suffix	"V(`spatter ,)"
`spawn	Suffix	"V(`spawn ,)"
`spay	Suffix	"V(`spay ,)"
`spearhead	Suffix	"V(`spearhead ,)"
`specify	Suffix	"V(`specify ,)"
`speculate	Suffix	"V(`speculate ,)"
`spew	Suffix	"V(`spew ,)"
`spike	Suffix	"V(`spike ,)"
`spiral	Suffix	"V(`spiral ,)"
`splatter	Suffix	"V(`splatter ,)"
`splay	Suffix	"V(`splay ,)"
`splutter	Suffix	"V(`splutter ,)"
`spoof	Suffix	"V(`spoof ,)"
`sport	Suffix	"V(`sport ,)"
`spot	Suffix	"V(`spot ,)"
`sprawl	Suffix	"V(`sprawl ,)"
`spurn	Suffix	"V(`spurn ,)"
`sputter	Suffix	"V(`sputter ,)"
`squall	Suffix	"V(`squall ,)"
`squander	Suffix	"V(`squander ,)"
`square	Suffix	"V(`square ,)"
`squash	Suffix	"V(`squash ,)"
`squat	Suffix	"V(`squat ,)"
`squelch	Suffix	"V(`squelch ,)"
`squint	Suffix	"V(`squint ,)"
`squirm	Suffix	"V(`squirm ,)"
`stabilize	Suffix	"V(`stable ,deadj)"
`stagger	Suffix	"V(`stagger ,)"
`stagnate	Suffix	"V(`stagnate ,)"
`stalk	Suffix	"V(`stalk ,)"
`stall	Suffix	"V(`stall ,)"
`stammer	Suffix	"V(`stammer ,)"
`stamp	Suffix	"V(`stamp ,)"
`stanch	Suffix	"V(`stanch ,)"
`stare	Suffix	"V(`stare ,)"
`stargaze	Suffix	"V(`stargaze ,)"
`startle	Suffix	"V(`startle ,)"
`starve	Suffix	"V(`starve ,)"
`state	Suffix	"V(`state ,)"
`stave	Suffix	"V(`stave ,)"
`steep	Suffix	"V(`steep ,)"
`stem	Suffix	"V(`stem ,)"
`stickle	Suffix	"V(`stickle ,)"
`stifle	Suffix	"V(`stifle ,)"
`stimulate	Suffix	"V(`stimulate ,)"
`stipple	Suffix	"V(`stipple ,)"
`stipulate	Suffix	"V(`stipulate ,)"
`stir	Suffix	"V(`stir ,)"
`stoke	Suffix	"V(`stoke ,)"
`stomp	Suffix	"V(`stomp ,)"
`stonewall	Suffix	"V(`stonewall ,)"
`stoop	Suffix	"V(`stoop ,)"
`storekeep	Suffix	"V(`storekeep ,boundstem)"
`stow	Suffix	"V(`stow ,)"
`straddle	Suffix	"V(`straddle ,)"
`strafe	Suffix	"V(`strafe ,)"
`straggle	Suffix	"V(`straggle ,)"
`straiten	Suffix	"V(`straiten ,)"
`strand	Suffix	"V(`strand ,)"
`strangle	Suffix	"V(`strangle ,)"
`strangulate	Suffix	"V(`strangulate ,)"
`stratify	Suffix	"V(`stratify ,)"
`strengthen	Suffix	"V(`strength ,denom)"
`striate	Suffix	"V(`striate ,)"
`strikebreak	Suffix	"V(`strikebreak ,boundstem)"
`strum	Suffix	"V(`strum ,)"
`strut	Suffix	"V(`strut ,)"
`stub	Suffix	"V(`stub ,)"
`stud	Suffix	"V(`stud ,)"
`stuff	Suffix	"V(`stuff ,)"
`stultify	Suffix	"V(`stultify ,)"
`stumble	Suffix	"V(`stumble ,)"
`stun	Suffix	"V(`stun ,)"
`stump	Suffix	"V(`stump ,)"
`stunt	Suffix	"V(`stunt ,)"
`stupefy	Suffix	"V(`stupefy ,)"
`styled	Clitic	"V(`style ,ed)"
`styled	PT_Suffix	"V(`style ,en)"
`styling	PT_Suffix	"V(`style ,ing)"
`stylize	Suffix	"V(`style ,denom)"
`stymie	Suffix	"V(`stymie ,)"
sub`due	Suffix	"V(sub`due ,)"
sub`ject	Suffix	"V(sub`ject ,)"
`subjugate	Suffix	"V(`subjugate ,)"
`sublimate	Suffix	"V(`sublimate ,)"
sub`merse	Suffix	"V(sub`merse ,)"
sub`mit	Suffix	"V(sub`mit ,)"
`subrogate	Suffix	"V(`subrogate ,)"
sub`scribe	Suffix	"V(sub`scribe ,)"
`subsidize	Suffix	"V(`subsidy ,denom)"
sub`sist	Suffix	"V(sub`sist ,)"
sub`stantiate	Suffix	"V(`substance ,denom)"
sub`sume	Suffix	"V(sub`sume ,)"
sub`tract	Suffix	"V(sub`tract ,)"
sub`vert	Suffix	"V(sub`vert ,)"
suc`ceed	Suffix	"V(suc`ceed ,)"
suc`cumb	Suffix	"V(suc`cumb ,)"
`suck	Suffix	"V(`suck ,)"
`suckle	Suffix	"V(`suckle ,)"
`sue	Suffix	"V(`sue ,)"
`suffer	Suffix	"V(`suffer ,)"
suf`fice	Suffix	"V(suf`fice ,)"
`suffocate	Suffix	"V(`suffocate ,)"
suf`fuse	Suffix	"V(suf`fuse ,)"
sugar`coat	Suffix	"V(sugar`coat ,)"
sug`gest	Suffix	"V(sug`gest ,)"
`suit	Suffix	"V(`suit ,)"
`sulk	Suffix	"V(`sulk ,)"
`sully	Suffix	"V(`sully ,)"
`summarize	Suffix	"V(`summary ,denom)"
`summon	Suffix	"V(`summon ,)"
`sunbathe	Suffix	"V(`sunbathe ,)"
`sunder	Suffix	"V(`sunder ,)"
`sup	Suffix	"V(`sup ,)"
super`annuate	Suffix	"V(super`annuate ,)"
superin`tend	Suffix	"V(superin`tend ,)"
super`pose	Suffix	"V(super`pose ,)"
super`sede	Suffix	"V(super`sede ,)"
super`vene	Suffix	"V(super`vene ,)"
`supervise	Suffix	"V(`supervise ,)"
sup`plant	Suffix	"V(sup`plant ,)"
`supplicate	Suffix	"V(`supplicate ,)"
sup`pose	Suffix	"V(sup`pose ,)"
sup`press	Suffix	"V(sup`press ,)"
sur`cease	Suffix	"V(sur`cease ,)"
sur`mise	Suffix	"V(sur`mise ,)"
sur`mount	Suffix	"V(sur`mount ,)"
sur`pass	Suffix	"V(sur`pass ,)"
sur`round	Suffix	"V(sur`round ,)"
sur`veil	Suffix	"V(sur`veil ,)"
sur`vey	Suffix	"V(sur`vey ,)"
sur`vive	Suffix	"V(sur`vive ,)"
sus`pect	Suffix	"V(sus`pect ,)"
sus`pend	Suffix	"V(sus`pend ,)"
sus`tain	Suffix	"V(sus`tain ,)"
`swaddle	Suffix	"V(`swaddle ,)"
`swagger	Suffix	"V(`swagger ,)"
`swashbuckle	Suffix	"V(`swashbuckle ,)"
`swat	Suffix	"V(`swat ,)"
`swathe	Suffix	"V(`swathe ,rev)"
`sway	Suffix	"V(`sway ,)"
`swelter	Suffix	"V(`swelter ,)"
`swerve	Suffix	"V(`swerve ,)"
`swig	Suffix	"V(`swig ,)"
`swipe	Suffix	"V(`swipe ,)"
`swish	Suffix	"V(`swish ,)"
`swoon	Suffix	"V(`swoon ,)"
`swoop	Suffix	"V(`swoop ,)"
syl`labify	Suffix	"V(`syllable ,denom)"
`syllogize	Suffix	"V(`syllogize ,)"
`symbolise	Suffix	"V(`symbol ,denom)"
`symbolize	Suffix	"V(`symbol ,denom)"
`synchronize	Suffix	"V(`synchrony ,denom)"
`syncopate	Suffix	"V(`syncopate ,)"
`synthesize	Suffix	"V(`synthesize ,)"
`systematize	Suffix	"V(`system ,denom)"
`systemize	Suffix	"V(`system ,denom)"
`tabulate	Suffix	"V(`tabulate ,)"
`tail	Suffix	"V(`tail ,)"
`taint	Suffix	"V(`taint ,)"
`tamp	Suffix	"V(`tamp ,)"
`tamper	Suffix	"V(`tamper ,)"
`tantalize	Suffix	"V(`tantalize ,)"
`taper	Suffix	"V(`taper ,)"
`tarnish	Suffix	"V(`tarnish ,)"
`tarry	Suffix	"V(`tarry ,)"
`tatter	Suffix	"V(`tatter ,)"
`tattle	Suffix	"V(`tattle ,)"
`taunt	Suffix	"V(`taunt ,)"
`tease	Suffix	"V(`tease ,)"
`teem	Suffix	"V(`teem ,)"
`teeter	Suffix	"V(`teeter ,)"
`teethe	Suffix	"V(`teethe ,)"
`televise	Suffix	"V(`televise ,)"
`temper	Suffix	"V(`temper ,)"
`temporize	Suffix	"V(`temporize ,)"
`tempt	Suffix	"V(`tempt ,)"
`tend	Suffix	"V(`tend ,)"
`terminate	Suffix	"V(`terminate ,)"
`terrify	Suffix	"V(`terrify ,)"
`testify	Suffix	"V(`testify ,)"
`thank	Suffix	"V(`thank ,)"
`theorize	Suffix	"V(`theory ,denom)"
`thieve	Suffix	"V(`thieve ,)"
`thrash	Suffix	"V(`thrash ,)"
`threaten	Suffix	"V(`threat ,denom)"
`thresh	Suffix	"V(`thresh ,)"
`throb	Suffix	"V(`throb ,)"
`throttle	Suffix	"V(`throttle ,)"
`thwart	Suffix	"V(`thwart ,)"
`tickle	Suffix	"V(`tickle ,)"
`tide	Suffix	"V(`tide ,)"
`tie	Suffix	"V(`tie ,rev)"
`till	Suffix	"V(`till ,)"
`tinker	Suffix	"V(`tinker ,)"
`tinkle	Suffix	"V(`tinkle ,)"
`tipple	Suffix	"V(`tipple ,)"
`tire	Suffix	"V(`tire ,)"
`titillate	Suffix	"V(`titillate ,)"
`titter	Suffix	"V(`titter ,)"
`toddle	Suffix	"V(`toddle ,)"
`tolerate	Suffix	"V(`tolerate ,)"
`toll	Suffix	"V(`toll ,)"
`tootle	Suffix	"V(`tootle ,)"
`top	Suffix	"V(`top ,)"
tor`ment	Suffix	"V(tor`ment ,)"
`tote	Suffix	"V(`tote ,)"
`totter	Suffix	"V(`totter ,)"
`tousle	Suffix	"V(`tousle ,)"
`tout	Suffix	"V(`tout ,)"
`trace	Suffix	"V(`trace ,)"
`trafficked	Clitic	"V(`traffic ,ed)"
`trafficked	PT_Suffix	"V(`traffic ,en)"
`trafficking	PT_Suffix	"V(`traffic ,ing)"
`trail	Suffix	"V(`trail ,)"
`trailblaze	Suffix	"V(`trailblaze ,boundstem)"
`train	Suffix	"V(`train ,)"
`traipse	Suffix	"V(`traipse ,)"
tra`ject	Suffix	"V(tra`ject ,)"
`trample	Suffix	"V(`trample ,)"
trans`act	Suffix	"V(trans`act ,)"
tran`scend	Suffix	"V(tran`scend ,)"
tran`scribe	Suffix	"V(tran`scribe ,)"
trans`duce	Suffix	"V(trans`duce ,)"
tran`sect	Suffix	"V(tran`sect ,)"
trans`fer	Suffix	"V(trans`fer ,)"
trans`figure	Suffix	"V(trans`figure ,)"
trans`fix	Suffix	"V(trans`fix ,)"
trans`form	Suffix	"V(trans`form ,)"
trans`fuse	Suffix	"V(trans`fuse ,)"
trans`gress	Suffix	"V(trans`gress ,)"
`translate	Suffix	"V(`translate ,)"
trans`literate	Suffix	"V(trans`literate ,)"
trans`mit	Suffix	"V(trans`mit ,)"
trans`mogrify	Suffix	"V(trans`mogrify ,)"
trans`mute	Suffix	"V(trans`mute ,)"
tran`spire	Suffix	"V(tran`spire ,)"
trans`plant	Suffix	"V(trans`plant ,)"
trans`port	Suffix	"V(trans`port ,)"
trans`pose	Suffix	"V(trans`pose ,)"
trans`ship	Suffix	"V(trans`ship ,)"
`traumatise	Suffix	"V(`trauma ,denom)"
`traumatize	Suffix	"V(`trauma ,denom)"
tra`verse	Suffix	"V(tra`verse ,)"
`trawl	Suffix	"V(`trawl ,)"
`trekked	Clitic	"V(`trek ,ed)"
`trekked	PT_Suffix	"V(`trek ,en)"
`trekking	PT_Suffix	"V(`trek ,ing)"
`tremble	Suffix	"V(`tremble ,)"
tri`angulate	Suffix	"V(tri`angulate ,)"
`tribulate	Suffix	"V(`tribulate ,)"
`trim	Suffix	"V(`trim ,)"
`trip	Suffix	"V(`trip ,)"
`trisect	Suffix	"V(`trisect ,)"
`tromp	Suffix	"V(`tromp ,)"
`trot	Suffix	"V(`trot ,)"
`troublemake	Suffix	"V(`troublemake ,boundstem)"
`troubleshoot	Suffix	"V(`troubleshoot ,boundstem)"
`trounce	Suffix	"V(`trounce ,)"
`trudge	Suffix	"V(`trudge ,)"
`truncate	Suffix	"V(`truncate ,)"
`tune	Suffix	"V(`tune ,rev)"
`tweeze	Suffix	"V(`tweeze ,)"
`twiddle	Suffix	"V(`twiddle ,)"
`twig	Suffix	"V(`twig ,)"
`type	Suffix	"V(`type ,)"
`typed	Clitic	"V(`type ,ed)"
`typed	PT_Suffix	"V(`type ,en)"
`typing	PT_Suffix	"V(`type ,ing)"
`typify	Suffix	"V(`type ,denom)"
`tyrannise	Suffix	"V(`tyranny ,denom)"
`tyrannize	Suffix	"V(`tyranny ,denom)"
`uglify	Suffix	"V(`ugly ,deadj)"
`ulcerate	Suffix	"V(`ulcer ,denom)"
`ululate	Suffix	"V(`ululate ,)"
un`bosom	Suffix	"V(`bosom ,denom)"
un`church	Suffix	"V(`church ,denom)"
`underpin	Suffix	"V(`underpin ,)"
`undulate	Suffix	"V(`undulate ,)"
un`earth	Suffix	"V(`earth ,denom)"
un`horse	Suffix	"V(`horse ,denom)"
`unify	Suffix	"V(`unify ,)"
u`nite	Suffix	"V(u`nite ,)"
un`limber	Suffix	"V(`limber ,deadj)"
un`man	Suffix	"V(`man ,denom)"
un`sex	Suffix	"V(`sex ,denom)"
`up	Suffix	"V(`up ,)"
up`braid	Suffix	"V(up`braid ,)"
`upchuck	Suffix	"V(`upchuck ,)"
`update	Suffix	"V(`update ,)"
up`end	Suffix	"V(up`end ,)"
up`holster	Suffix	"V(up`holster ,)"
up`heave	Suffix	"V(up`heave ,)"
up`lift	Suffix	"V(up`lift ,)"
up`raise	Suffix	"V(up`raise ,)"
up`root	Suffix	"V(up`root ,)"
up`stage	Suffix	"V(up`stage ,)"
`urinate	Suffix	"V(`urine ,denom)"
u`surp	Suffix	"V(u`surp ,)"
`utter	Suffix	"V(`utter ,)"
`vacate	Suffix	"V(`vacate ,)"
`vacillate	Suffix	"V(`vacillate ,)"
`vaccinate	Suffix	"V(vac`cine ,denom)"
`validate	Suffix	"V(`valid ,deadj)"
`valuate	Suffix	"V(`value ,denom)"
va`moose	Suffix	"V(va`moose ,)"
`vanish	Suffix	"V(`vanish ,)"
`vanquish	Suffix	"V(`vanquish ,)"
`variate	Suffix	"V(`variate ,)"
`variegate	Suffix	"V(`variegate ,)"
`vary	Suffix	"V(`vary ,)"
`vaunt	Suffix	"V(`vaunt ,)"
`veer	Suffix	"V(`veer ,)"
`vegetate	Suffix	"V(`vegetate ,)"
`vend	Suffix	"V(`vend ,)"
`venerate	Suffix	"V(`venerate ,)"
`venge	Suffix	"V(`venge ,)"
`ventilate	Suffix	"V(`ventilate ,)"
`verify	Suffix	"V(`verify ,)"
`verse	Suffix	"V(`verse ,)"
`vest	Suffix	"V(`vest ,)"
`vex	Suffix	"V(`vex ,)"
`vibrate	Suffix	"V(`vibrate ,)"
`vie	Suffix	"V(`vie ,)"
`vilify	Suffix	"V(`vilify ,)"
`vindicate	Suffix	"V(`vindicate ,)"
`violate	Suffix	"V(`violate ,)"
`vitiate	Suffix	"V(`vitiate ,)"
`vitrify	Suffix	"V(`vitrify ,)"
vi`tuperate	Suffix	"V(vi`tuperate ,)"
`vivify	Suffix	"V(`vivify ,)"
`vivisect	Suffix	"V(`vivisect ,)"
vo`ciferate	Suffix	"V(vo`ciferate ,)"
`vouch	Suffix	"V(`vouch ,)"
vouch`safe	Suffix	"V(vouch`safe ,)"
`waddle	Suffix	"V(`waddle ,)"
`wade	Suffix	"V(`wade ,)"
`waffle	Suffix	"V(`waffle ,)"
`waft	Suffix	"V(`waft ,)"
`wag	Suffix	"V(`wag ,)"
`wage	Suffix	"V(`wage ,)"
`waggle	Suffix	"V(`waggle ,)"
`waive	Suffix	"V(`waive ,)"
`waken	Suffix	"V(`waken ,)"
`wallow	Suffix	"V(`wallow ,)"
`wander	Suffix	"V(`wander ,)"
`wane	Suffix	"V(`wane ,)"
`wangle	Suffix	"V(`wangle ,)"
`want	Suffix	"V(`want ,)"
`warble	Suffix	"V(`warble ,)"
`ward	Suffix	"V(`ward ,)"
`warn	Suffix	"V(`warn ,)"
`warp	Suffix	"V(`warp ,)"
`warrant	Suffix	"V(`warrant ,)"
`watch	Suffix	"V(`watch ,)"
`watchmake	Suffix	"V(`watchmake ,boundstem)"
`waterlog	Suffix	"V(`waterlog ,)"
`waver	Suffix	"V(`waver ,)"
`wean	Suffix	"V(`wean ,)"
`weatherstrip	Suffix	"V(`weatherstrip ,)"
`weigh	Suffix	"V(`weigh ,)"
`well	Suffix	"V(`well ,)"
`welsh	Suffix	"V(`welsh ,)"
`wend	Suffix	"V(`wend ,)"
`wheedle	Suffix	"V(`wheedle ,)"
`whelm	Suffix	"V(`whelm ,)"
`whelp	Suffix	"V(`whelp ,)"
`whet	Suffix	"V(`whet ,)"
`while	Suffix	"V(`while ,)"
`whitewash	Suffix	"V(`whitewash ,)"
`whittle	Suffix	"V(`whittle ,)"
`whizzed	Clitic	"V(`whiz ,ed)"
`whizzed	PT_Suffix	"V(`whiz ,en)"
`whizzing	PT_Suffix	"V(`whiz ,ing)"
`wield	Suffix	"V(`wield ,)"
`wig	Suffix	"V(`wig ,)"
`wiggle	Suffix	"V(`wiggle ,)"
`wilt	Suffix	"V(`wilt ,)"
`winemake	Suffix	"V(`winemake ,boundstem)"
`winnow	Suffix	"V(`winnow ,)"
`wither	Suffix	"V(`wither ,)"
`wizen	Suffix	"V(`wizen ,)"
`woo	Suffix	"V(`woo ,)"
`wot	Suffix	"V(`wot ,)"
`wow	Suffix	"V(`wow ,)"
`wrack	Suffix	"V(`wrack ,)"
`wrap	Suffix	"V(`wrap ,rev)"
`wreak	Suffix	"V(`wreak ,)"
`wreathe	Suffix	"V(`wreathe ,rev)"
`wrest	Suffix	"V(`wrest ,)"
`wrestle	Suffix	"V(`wrestle ,)"
`wriggle	Suffix	"V(`wriggle ,)"
`writhe	Suffix	"V(`writhe ,)"
`wrong	Suffix	"V(`wrong ,)"
`wrongdo	Suffix	"V(`wrongdo ,boundstem)"
`yammer	Suffix	"V(`yammer ,)"
`yaw	Suffix	"V(`yaw ,)"
`yearn	Suffix	"V(`yearn ,)"
`yellow	Suffix	"V(`yellow ,)"
`yield	Suffix	"V(`yield ,)"
`yodel	Suffix	"V(`yodel ,)"
`zap	Suffix	"V(`zap ,)"
`zero	Suffix	"V(`zero ,)"
`zip	Suffix	"V(`zip ,rev)"

; had to adjust this a little.
End:
-	Compound	"End(- ,compound)"
0	#	None

CJ:
a`fore	End	"CJ(a`fore ,)"
al`beit	End	"CJ(al`beit ,)"
al`though	End	"CJ(al`though ,)"
and	End	"CJ(and ,)"
be`cause	End	"CJ(be`cause ,)"
`either	End	"CJ(`either ,)"
`ere	End	"CJ(`ere ,)"
`ergo	End	"CJ(`ergo ,)"
`forasmuch	End	"CJ(`forasmuch ,)"
how	Contraction	"CJ(how ,)"
how`beit	End	"CJ(how`beit - archaic,)"
how`ever	End	"CJ(how`ever ,)"
if	End	"CJ(if ,)"
inas`much	End	"CJ(inas`much ,)"
inso`much	End	"CJ(inso`much ,)"
lest	End	"CJ(lest ,)"
nor	End	"CJ(nor ,)"
once	Contraction	"CJ(once ,)"
`only	End	"CJ(`only ,)"
or	End	"CJ(or ,)"
so	End	"CJ(so ,)"
that	End	"CJ(that ,)"
to	End	"CJ(INF - infinitive marker,infmark)"
`therefore	End	"CJ(`therefore ,)"
though	End	"CJ(though ,)"
un`less	End	"CJ(un`less ,)"
when	End	"CJ(when ,)"
whence	End	"CJ(whence ,)"
when`ever	End	"CJ(when`ever ,)"
whenso`ever	End	"CJ(whenso`ever ,)"
where	End	"CJ(where ,)"
where`as	End	"CJ(where`as ,)"
where`at	End	"CJ(where`at ,)"
where`by	End	"CJ(where`by ,)"
where`from	End	"CJ(where`from ,)"
where`in	End	"CJ(where`in ,)"
where`into	End	"CJ(where`into ,)"
where`of	End	"CJ(where`of ,)"
where`on	End	"CJ(where`on ,)"
whereso`ever	End	"CJ(whereso`ever ,)"
where`through	End	"CJ(where`through ,)"
where`to	End	"CJ(where`to ,)"
where`unto	End	"CJ(where`unto ,)"
`whereupon	End	"CJ(`whereupon ,)"
wher`ever	End	"CJ(wher`ever ,)"
where`with	End	"CJ(where`with ,)"
`wherewithal	End	"CJ(`wherewithal ,)"
`whether	End	"CJ(`whether ,)"
`while	End	"CJ(`while ,)"
whilst	End	"CJ(whilst ,)"
`whither	End	"CJ(`whither ,)"
whitherso`ever	End	"CJ(whitherso`ever ,)"
why	End	"CJ(why ,)"
yet	End	"CJ(yet ,)"

AJ:
`eldest	Suffix	"AJ(`eldest ,super)"
`lesser	Suffix	"AJ(`less ,)"
ab`dominal	Suffix	"AJ(`abdomen ,denom)"
a`bed	Suffix	"AJ(`bed ,denom)"
a`berrant	Suffix	"AJ(a`berrant ,)"
a`beyant	Suffix	"AJ(a`beyant ,)"
`abject	Suffix	"AJ(`abject ,)"
a`blaze	Suffix	"AJ(`blaze ,deverb)"
`able	Suffix	"AJ(`able ,)"
ab`normal	Suffix	"AJ(`norm ,denom)"
a`boil	Suffix	"AJ(`boil ,deverb)"
a`bominable	Suffix	"AJ(a`bominable ,)"
a`boveground	Suffix	"AJ(a`boveground ,)"
a`bovementioned	Suffix	"AJ(`mention ,deverb)"
a`brasive	Suffix	"AJ(a`brade ,deverb)"
a`brupt	Suffix	"AJ(a`brupt ,)"
absent`minded	Suffix	"AJ(`mind ,denom)"
abso`lute	Suffix	"AJ(abso`lute ,)"
ab`stemious	Suffix	"AJ(ab`stemious ,)"
`abstinent	Suffix	"AJ(ab`stain ,deverb)"
ab`stract	Suffix	"AJ(ab`stract ,)"
ab`struse	Suffix	"AJ(ab`struse ,)"
ab`surd	Suffix	"AJ(ab`surd ,)"
a`building	Suffix	"AJ(`build ,deverb)"
a`bundant	Suffix	"AJ(a`bound ,deverb)"
a`bysmal	Suffix	"AJ(a`byss ,denom)"
`accurate	Suffix	"AJ(`accurate ,)"
ac`cursed	Suffix	"AJ(`curse ,denom)"
ac`curst	Suffix	"AJ(ac`curst ,)"
ac`cusative	Suffix	"AJ(ac`cusative ,)"
a`cerbic	IC_Suffix	"AJ(a`cerbic ,)"
a`cidulous	Suffix	"AJ(a`cidulous ,)"
ac`quisitive	Suffix	"AJ(ac`quire ,deverb)"
`acrid	Suffix	"AJ(`acrid ,)"
`actionable	Suffix	"AJ(`action ,denom)"
`actual	Suffix	"AJ(`actual ,)"
a`cute	Suffix	"AJ(a`cute ,)"
a`cyclic	IC_Suffix	"AJ(`cycle ,denom)"
a`dagio	Suffix	"AJ(a`dagio ,)"
`adamant	Suffix	"AJ(`adamant ,)"
a`dept	Suffix	"AJ(a`dept ,)"
`adequate	Suffix	"AJ(`adequate ,)"
ad`jacent	Suffix	"AJ(ad`jacent ,)"
ad`joint	Suffix	"AJ(ad`joint ,)"
ad`ministrable	Suffix	"AJ(ad`ministrate ,deverb)"
ad`missible	Suffix	"AJ(ad`mit ,deverb)"
ad`monitory	Suffix	"AJ(ad`monish ,deverb)"
ad`renal	Suffix	"AJ(ad`renal ,)"
a`drift	Suffix	"AJ(`drift ,deverb)"
a`droit	Suffix	"AJ(a`droit ,)"
a`dulterous	Suffix	"AJ(a`dultery ,denom)"
adven`titious	Suffix	"AJ(adven`titious ,)"
ad`venturesome	Suffix	"AJ(ad`venture ,denom)"
ad`verse	Suffix	"AJ(ad`verse ,)"
ae`olian	Suffix	"AJ(ae`olian ,)"
aer`obic	IC_Suffix	"AJ(aer`obic ,)"
aerody`namic	IC_Suffix	"AJ(aerody`namic ,)"
aero`nautic	IC_Suffix	"AJ(aero`nautic ,)"
`affable	Suffix	"AJ(`affable ,)"
af`fectionate	Suffix	"AJ(af`fection ,denom)"
`afferent	Suffix	"AJ(`afferent ,)"
af`firmative	Suffix	"AJ(af`firm ,deverb)"
`affluent	Suffix	"AJ(`affluent ,)"
a`field	Suffix	"AJ(`field ,denom)"
a`fire	Suffix	"AJ(`fire ,denom)"
a`flame	Suffix	"AJ(`flame ,denom)"
a`float	Suffix	"AJ(`float ,deverb)"
a`foot	Suffix	"AJ(`foot ,denom)"
a`forementioned	Suffix	"AJ(`mention ,deverb)"
a`foresaid	Suffix	"AJ(`say ,deverb)"
a`forethought	Suffix	"AJ(`think ,deverb)"
a`foul	Suffix	"AJ(a`foul ,)"
a`fraid	Suffix	"AJ(a`fraid ,)"
a`fresh	Suffix	"AJ(`fresh ,)"
`aft	Clitic	"AJ(`aft ,)"
ag`gressive	Suffix	"AJ(ag`gressive ,)"
a`ghast	Suffix	"AJ(a`ghast ,)"
`agile	Suffix	"AJ(`agile ,)"
a`gleam	Suffix	"AJ(`gleam ,deverb)"
a`glow	Suffix	"AJ(`glow ,deverb)"
a`gone	Clitic	"AJ(a`gone ,)"
ag`rarian	Suffix	"AJ(ag`rarian ,)"
`airborne	Suffix	"AJ(`airborne ,)"
`airtight	Suffix	"AJ(`airtight ,)"
a`jar	Suffix	"AJ(a`jar ,)"
a`kimbo	Suffix	"AJ(a`kimbo ,)"
a`kin	Suffix	"AJ(a`kin ,)"
a`lert	Suffix	"AJ(a`lert ,)"
al`fresco	Suffix	"AJ(al`fresco ,)"
`algal	Suffix	"AJ(`alga ,denom)"
a`like	Suffix	"AJ(`like ,)"
a`live	Suffix	"AJ(`live ,)"
`alkaline	Suffix	"AJ(`alkali ,denom)"
al`legiant	Suffix	"AJ(al`legiant ,)"
alle`goric	IC_Suffix	"AJ(`allegory ,denom)"
al`legro	Suffix	"AJ(al`legro ,)"
al`lergic	IC_Suffix	"AJ(`allergy ,denom)"
`allocable	Suffix	"AJ(`allocate ,deverb)"
al`luvial	Suffix	"AJ(al`luvial ,)"
al`mighty	Suffix	"AJ(al`mighty ,)"
a`lone	Suffix	"AJ(a`lone ,)"
a`loof	Suffix	"AJ(a`loof ,)"
alpha`meric	Suffix	"AJ(alpha`meric ,)"
alphanu`meric	IC_Suffix	"AJ(alphanu`meric ,)"
`alpine	Suffix	"AJ(`alpine - AJR38?,)"
al`taic	Suffix	"AJ(al`taic ,)"
`amatory	Suffix	"AJ(`amatory ,)"
ambi`dextrous	Suffix	"AJ(ambi`dextrous ,)"
`ambient	Suffix	"AJ(`ambient ,)"
am`biguous	Suffix	"AJ(am`biguous ,)"
am`bitious	Suffix	"AJ(am`bition ,denom)"
am`bivalent	Suffix	"AJ(am`bivalent ,)"
am`brosial	Suffix	"AJ(am`brosial ,)"
`ambulant	Suffix	"AJ(`ambulant ,)"
a`menable	Suffix	"AJ(a`menable ,)"
`amiable	Suffix	"AJ(`amiable ,)"
`amicable	Suffix	"AJ(`amicable ,)"
a`mino	Suffix	"AJ(a`mino ,)"
a`moral	Suffix	"AJ(`moral ,denom)"
`amorous	Suffix	"AJ(`amorous ,)"
a`morphous	Suffix	"AJ(a`morphous ,)"
am`phibious	Suffix	"AJ(am`phibian ,denom)"
`ample	Suffix	"AJ(`ample ,)"
anachro`nistic	IC_Suffix	"AJ(anachro`nistic ,)"
a`nachronous	Suffix	"AJ(a`nachronous ,)"
anaes`thetic	IC_Suffix	"AJ(anaes`thetic ,)"
`anal	Suffix	"AJ(`anus ,denom)"
ana`leptic	IC_Suffix	"AJ(ana`leptic ,)"
anal`gesic	IC_Suffix	"AJ(anal`gesic ,)"
ana`lytic	IC_Suffix	"AJ(a`nalysis ,denom)"
ana`phoric	IC_Suffix	"AJ(a`naphora ,denom)"
an`cestral	Suffix	"AJ(`ancestor ,denom)"
`ancillary	Suffix	"AJ(`ancillary ,)"
anes`thetic	IC_Suffix	"AJ(anes`thetic ,)"
`angry	Suffix	"AJ(`angry ,)"
`angular	Suffix	"AJ(`angle ,denom)"
`animate	Suffix	"AJ(`animate - [-@t],denom)"
`annular	Suffix	"AJ(`annular ,)"
a`nomalous	Suffix	"AJ(a`nomaly ,denom)"
a`nonymous	Suffix	"AJ(a`nonymous ,)"
ante`bellum	Suffix	"AJ(ante`bellum ,)"
an`terior	Suffix	"AJ(an`terior ,)"
anthropo`genic	IC_Suffix	"AJ(anthropo`genic ,)"
anthropo`morphic	IC_Suffix	"AJ(anthropo`morphic ,)"
antibi`otic	IC_Suffix	"AJ(antibi`otic ,)"
antipa`thetic	IC_Suffix	"AJ(an`tipathy ,denom)"
an`tiphonal	Suffix	"AJ(`antiphon ,denom)"
anti`podean	Suffix	"AJ(anti`podean ,)"
anti`thetic	IC_Suffix	"AJ(anti`thetic ,)"
`anxious	Suffix	"AJ(`anxious ,)"
apa`thetic	IC_Suffix	"AJ(`apathy ,denom)"
aperi`odic	IC_Suffix	"AJ(`period ,denom)"
`aphasic	IC_Suffix	"AJ(a`phasia ,denom)"
apoca`lyptic	IC_Suffix	"AJ(a`pocalypse ,denom)"
a`pocryphal	Suffix	"AJ(a`pocrypha ,denom)"
apo`litical	Suffix	"AJ(po`litical ,denom)"
apolo`getic	IC_Suffix	"AJ(a`pology ,denom)"
apop`lectic	IC_Suffix	"AJ(`apoplexy ,denom)"
apos`tolic	IC_Suffix	"AJ(a`postle ,denom)"
ap`parent	Suffix	"AJ(ap`parent ,)"
ap`pellate	Suffix	"AJ(ap`peal ,deverb)"
ap`pellative	Suffix	"AJ(ap`pellative ,)"
`appetizing	Suffix	"AJ(`appetizing ,)"
`applicable	Suffix	"AJ(ap`ply ,deverb)"
`apposite	Suffix	"AJ(`apposite ,)"
ap`preciable	Suffix	"AJ(ap`preciate ,deverb)"
appre`hensive	Suffix	"AJ(appre`hend ,deverb)"
ap`propriable	Suffix	"AJ(ap`propriate ,deverb)"
ap`propriate	Suffix	"AJ(ap`propriate - [-@t],)"
ap`proximable	Suffix	"AJ(ap`proximate ,deverb)"
`apt	Suffix	"AJ(`apt ,)"
a`quatic	IC_Suffix	"AJ(a`quatic ,)"
`aqueous	Suffix	"AJ(`aqueous ,)"
`arable	Suffix	"AJ(`arable ,)"
`arbitrary	Suffix	"AJ(`arbitrary ,)"
ar`boreal	Suffix	"AJ(ar`boreal ,)"
ar`cane	Suffix	"AJ(ar`cane ,)"
ar`chaic	IC_Suffix	"AJ(ar`chaic ,)"
arche`typic	IC_Suffix	"AJ(`archetype ,denom)"
architec`tonic	IC_Suffix	"AJ(architec`tonic ,)"
`arctic	Suffix	"AJ(`arctic ,)"
`ardent	Suffix	"AJ(`ardent ,)"
`arduous	Suffix	"AJ(`arduous ,)"
`areawide	Suffix	"AJ(`areawide ,)"
argu`mentative	Suffix	"AJ(`argue ,deverb)"
`arid	Suffix	"AJ(`arid ,)"
aro`matic	IC_Suffix	"AJ(a`roma ,denom)"
`arrant	Suffix	"AJ(`arrant ,)"
`arrogant	Suffix	"AJ(`arrogant ,)"
as`cetic	IC_Suffix	"AJ(as`cetic ,)"
a`septic	IC_Suffix	"AJ(`septic ,)"
a`stern	Suffix	"AJ(`stern ,denom)"
a`sexual	Suffix	"AJ(`sex ,denom)"
a`shamed	Suffix	"AJ(`shame ,denom)"
`ashen	Suffix	"AJ(`ash ,denom)"
`asinine	Suffix	"AJ(`asinine ,)"
a`sleep	Suffix	"AJ(`sleep ,deverb)"
a`social	Suffix	"AJ(`social ,)"
a`spheric	IC_Suffix	"AJ(`sphere ,denom)"
as`siduous	Suffix	"AJ(as`siduous ,)"
as`similable	Suffix	"AJ(as`similate ,deverb)"
as`sociable	Suffix	"AJ(as`sociate ,deverb)"
`assonant	Suffix	"AJ(`assonant ,)"
a`stir	Suffix	"AJ(`stir ,deverb)"
`astral	Suffix	"AJ(`astral ,)"
as`tringent	Suffix	"AJ(as`tringent ,)"
astro`nomical	Suffix	"AJ(as`tronomy ,denom)"
astro`physical	Suffix	"AJ(`astrophysics ,denom)"
as`tute	Suffix	"AJ(as`tute ,)"
asym`metric	IC_Suffix	"AJ(`symmetry ,denom)"
a`synchronous	Suffix	"AJ(`synchrony ,denom)"
ata`vistic	IC_Suffix	"AJ(ata`vistic ,)"
a`thirst	Suffix	"AJ(a`thirst ,)"
at`lantic	Suffix	"AJ(at`lantic ,)"
a`tonal	Suffix	"AJ(`tone ,denom)"
a`trocious	Suffix	"AJ(a`trocious ,)"
a`trophic	IC_Suffix	"AJ(`atrophy ,denom)"
at`tentive	Suffix	"AJ(at`tend ,deverb)"
atti`tudinal	Suffix	"AJ(`attitude ,denom)"
a`typic	IC_Suffix	"AJ(`type ,denom)"
ava`ricious	Suffix	"AJ(`avarice ,denom)"
a`verse	Suffix	"AJ(a`verse ,)"
`avid	Suffix	"AJ(`avid ,)"
avi`onic	IC_Suffix	"AJ(avi`onic ,)"
au`dacious	Suffix	"AJ(au`dacious ,)"
`audible	Suffix	"AJ(`audible ,)"
`auditory	Suffix	"AJ(`auditory ,)"
au`gust	Suffix	"AJ(au`gust ,)"
`aural	Suffix	"AJ(`aural ,)"
`auric	IC_Suffix	"AJ(`auric ,)"
aus`picious	Suffix	"AJ(aus`picious ,)"
aus`tere	Suffix	"AJ(aus`tere ,)"
au`thentic	IC_Suffix	"AJ(au`thentic ,)"
au`thoritative	Suffix	"AJ(au`thority ,denom)"
au`tistic	IC_Suffix	"AJ(au`tistic ,)"
auto`matic	IC_Suffix	"AJ(auto`matic ,)"
auto`morphic	IC_Suffix	"AJ(auto`morphic ,)"
au`tonomic	IC_Suffix	"AJ(au`tonomic ,)"
au`tonomous	Suffix	"AJ(au`tonomous ,)"
`average	Suffix	"AJ(`average ,)"
a`vuncular	Suffix	"AJ(a`vuncular ,)"
a`ware	Suffix	"AJ(a`ware ,)"
a`wash	Suffix	"AJ(a`wash ,)"
`awesome	Suffix	"AJ(`awe ,denom)"
`awestruck	Suffix	"AJ(`awestruck ,)"
`awestricken	Suffix	"AJ(`awestricken ,)"
a`wry	Suffix	"AJ(a`wry ,)"
`axial	Suffix	"AJ(`axis ,denom)"
axio`matic	IC_Suffix	"AJ(`axiom ,denom)"
bac`terial	Suffix	"AJ(bac`teria ,denom)"
bal`letic	IC_Suffix	"AJ(bal`let - exception to Gemination,denom)"
bal`listic	IC_Suffix	"AJ(bal`listic ,)"
`banal	Suffix	"AJ(`banal ,)"
bar`baric	IC_Suffix	"AJ(bar`baric ,)"
`barbarous	Suffix	"AJ(`barbarous ,)"
`bare	Suffix	"AJ(`bare ,)"
`barefaced	Suffix	"AJ(`face ,denom)"
`barefoot	Suffix	"AJ(`barefoot ,)"
baro`metric	Suffix	"AJ(ba`rometer ,denom)"
ba`roque	Suffix	"AJ(ba`roque ,)"
`basilar	Suffix	"AJ(`basilar ,)"
baso`philic	IC_Suffix	"AJ(baso`philic ,)"
`bawdy	Suffix	"AJ(`bawdy ,)"
bea`tific	IC_Suffix	"AJ(bea`tific ,)"
`beauteous	Suffix	"AJ(`beauty ,denom)"
`bedfast	Suffix	"AJ(`bedfast ,)"
`bedridden	Suffix	"AJ(`bedridden ,)"
be`lated	Suffix	"AJ(be`lated ,)"
`bellicose	Suffix	"AJ(`bellicose ,)"
bel`ligerent	Suffix	"AJ(bel`ligerent ,)"
be`loved	Suffix	"AJ(`love ,deverb)"
be`neficent	Suffix	"AJ(`benefice ,denom)"
be`nevolent	Suffix	"AJ(be`nevolent ,)"
be`nign	Suffix	"AJ(be`nign ,)"
ber`serk	Suffix	"AJ(ber`serk ,)"
be`spectacled	Suffix	"AJ(`spectacles ,denom)"
`bestial	Suffix	"AJ(`beast ,denom)"
best`selling	Suffix	"AJ(best`selling ,)"
bi`cameral	Suffix	"AJ(bi`cameral ,)"
bi`ennial	Suffix	"AJ(bi`ennial ,)"
`bigoted	Suffix	"AJ(`bigot ,denom)"
bi`lingual	Suffix	"AJ(bi`lingual ,)"
`bilious	Suffix	"AJ(`bile ,denom)"
`binary	Suffix	"AJ(`binary ,)"
bi`naural	Suffix	"AJ(bi`naural ,)"
bi`nocular	Suffix	"AJ(bi`nocular ,)"
bi`nomial	Suffix	"AJ(bi`nomial ,)"
bi`partite	Suffix	"AJ(bi`partite ,)"
`bistate	Suffix	"AJ(`bistate ,)"
`bitter	Suffix	"AJ(`bitter ,)"
`bittersweet	Suffix	"AJ(`bittersweet ,)"
bi`tuminous	Suffix	"AJ(bi`tuminous ,)"
bi`zarre	Suffix	"AJ(bi`zarre ,)"
`bland	Suffix	"AJ(`bland ,)"
`blasphemous	Suffix	"AJ(`blasphemy ,denom)"
`blatant	Suffix	"AJ(`blatant ,)"
`bleak	Suffix	"AJ(`bleak ,)"
`bleary	Suffix	"AJ(`bleary ,)"
`blest	Suffix	"AJ(`blest ,)"
`blithe	Suffix	"AJ(`blithe ,)"
`bloodshot	Suffix	"AJ(`bloodshot ,)"
`bloodthirsty	Suffix	"AJ(`bloodthirsty ,)"
`blustery	Suffix	"AJ(`blustery ,)"
`bogus	Suffix	"AJ(`bogus ,)"
`boisterous	Suffix	"AJ(`boisterous ,)"
`bold	Suffix	"AJ(`bold ,)"
`boldface	Suffix	"AJ(`boldface ,)"
`bombproof	Suffix	"AJ(`bombproof ,)"
`bony	Suffix	"AJ(`bone ,denom)"
`borderline	Suffix	"AJ(`borderline ,)"
`boric	Suffix	"AJ(`boric ,)"
`born	Suffix	"AJ(`born ,)"
bo`tanical	Suffix	"AJ(`botany ,denom)"
`bothersome	Suffix	"AJ(`bother ,deverb)"
bouf`fant	Suffix	"AJ(bouf`fant ,)"
`boozy	Suffix	"AJ(`booze ,denom)"
`bouncy	Suffix	"AJ(`bounce ,deverb)"
`bounteous	Suffix	"AJ(`bounty ,denom)"
bour`geois	Suffix	"AJ(bour`geois ,)"
`bovine	Suffix	"AJ(`bovine ,)"
`brackish	Suffix	"AJ(`brackish ,)"
`brash	Suffix	"AJ(`brash ,)"
`breathtaking	Suffix	"AJ(`breathtaking ,)"
`breezy	Suffix	"AJ(`breeze ,denom)"
`brief	Suffix	"AJ(`brief ,)"
`bright	Suffix	"AJ(`bright ,)"
`brighteyed	Suffix	"AJ(`eye ,denom)"
`brilliant	Suffix	"AJ(`brilliant ,)"
`brindled	Suffix	"AJ(`brindled ,)"
`briny	Suffix	"AJ(`brine ,denom)"
`brisk	Suffix	"AJ(`brisk ,)"
`brittle	Suffix	"AJ(`brittle ,)"
`broad	Suffix	"AJ(`broad ,)"
broken`hearted	Suffix	"AJ(broken`hearted ,)"
`bronchial	Suffix	"AJ(`bronchial ,)"
`bronzy	Suffix	"AJ(`bronze ,denom)"
`brusque	Suffix	"AJ(`brusque ,)"
`bubbly	Suffix	"AJ(`bubble ,denom)"
bu`colic	IC_Suffix	"AJ(bu`colic ,)"
`budgetary	Suffix	"AJ(`budget ,denom)"
`bugeyed	Suffix	"AJ(`bugeye ,denom)"
`builtin	Suffix	"AJ(`builtin ,)"
`bumptious	Suffix	"AJ(`bumptious ,)"
`buoyant	Suffix	"AJ(`buoy ,deverb)"
`burdensome	Suffix	"AJ(`burden ,denom)"
`burglarproof	Suffix	"AJ(`burglarproof ,)"
`burly	Suffix	"AJ(`burly ,)"
`buxom	Suffix	"AJ(`buxom ,)"
`bygone	Suffix	"AJ(`bygone ,)"
`cadent	Suffix	"AJ(`cadent ,)"
cae`sarean	Suffix	"AJ(cae`sarean ,)"
cae`sarian	Suffix	"AJ(cae`sarian ,)"
`cagey	Suffix	"AJ(`cagey ,)"
`cagy	Suffix	"AJ(`cagy ,)"
ca`lamitous	Suffix	"AJ(ca`lamity ,denom)"
cal`careous	Suffix	"AJ(cal`careous ,)"
`calculable	Suffix	"AJ(`calculate ,deverb)"
ca`lendric	IC_Suffix	"AJ(`calendar ,denom)"
`callous	Suffix	"AJ(`callous ,)"
ca`loric	IC_Suffix	"AJ(`calorie ,denom)"
can`descent	Suffix	"AJ(can`descent ,)"
`candid	Suffix	"AJ(`candid ,)"
`candlelit	Suffix	"AJ(`candlelit ,)"
`canny	Suffix	"AJ(`canny ,)"
can`tankerous	Suffix	"AJ(can`tankerous ,)"
`capable	Suffix	"AJ(`capable ,)"
ca`pacious	Suffix	"AJ(ca`pacious ,)"
ca`pacitive	Suffix	"AJ(ca`pacitive ,)"
ca`pricious	Suffix	"AJ(ca`price ,denom)"
`captious	Suffix	"AJ(`captious ,)"
`cardiac	Suffix	"AJ(`cardiac ,)"
`cardioid	Suffix	"AJ(`cardioid ,)"
cardio`vascular	Suffix	"AJ(cardio`vascular ,)"
`carefree	Suffix	"AJ(`carefree ,)"
`careworn	Suffix	"AJ(`careworn ,)"
`carnal	Suffix	"AJ(`carnal ,)"
car`tesian	Suffix	"AJ(car`tesian ,)"
carto`graphic	IC_Suffix	"AJ(carto`graphic ,)"
`carven	Suffix	"AJ(`carven ,)"
`casual	Suffix	"AJ(`casual ,)"
cata`bolic	IC_Suffix	"AJ(cata`bolic ,)"
cata`lytic	IC_Suffix	"AJ(cata`lytic ,)"
cata`tonic	IC_Suffix	"AJ(cata`tonic ,)"
cate`goric	IC_Suffix	"AJ(`category ,denom)"
`causative	Suffix	"AJ(`cause ,deverb)"
`caustic	IC_Suffix	"AJ(`caustic ,)"
`cautionary	Suffix	"AJ(`caution ,denom)"
`cautious	Suffix	"AJ(`cautious ,)"
cava`lier	Suffix	"AJ(cava`lier ,)"
`celsius	Suffix	"AJ(`celsius ,)"
ce`lestial	Suffix	"AJ(ce`lestial ,)"
`cellular	Suffix	"AJ(`cell ,denom)"
cen`sorial	Suffix	"AJ(`censor ,deverb)"
cen`sorious	Suffix	"AJ(`censor ,deverb)"
`central	Suffix	"AJ(`center ,denom)"
`centric	IC_Suffix	"AJ(`center ,denom)"
cen`trifugal	Suffix	"AJ(cen`trifugal ,)"
`centum	Suffix	"AJ(`centum ,)"
ce`ramic	IC_Suffix	"AJ(ce`ramic ,)"
ce`rebral	Suffix	"AJ(ce`rebral ,)"
`certain	Suffix	"AJ(`certain ,)"
`cervical	Suffix	"AJ(`cervix ,denom)"
ce`rulean	Suffix	"AJ(ce`rulean ,)"
ce`sarean	Suffix	"AJ(ce`sarean ,)"
ce`sarian	Suffix	"AJ(ce`sarian ,)"
`chancy	Suffix	"AJ(`chance ,denom)"
cha`otic	IC_Suffix	"AJ(`chaos ,denom)"
character`istic	IC_Suffix	"AJ(character`istic ,)"
charis`matic	IC_Suffix	"AJ(cha`risma ,denom)"
`charitable	Suffix	"AJ(`charity ,denom)"
`chaste	Suffix	"AJ(`chaste ,)"
`cheesy	Suffix	"AJ(`cheese ,denom)"
`chelate	Suffix	"AJ(`chelate ,)"
`chic	Suffix	"AJ(`chic ,)"
`chimeric	Suffix	"AJ(`chimeric ,)"
`chivalric	IC_Suffix	"AJ(`chivalry ,denom)"
`chivalrous	Suffix	"AJ(`chivalry ,denom)"
`choosy	Suffix	"AJ(`choose ,deverb)"
`choral	Suffix	"AJ(`choral ,)"
`chronic	IC_Suffix	"AJ(`chronic ,)"
`chubby	Suffix	"AJ(`chubby ,)"
cine`matic	IC_Suffix	"AJ(`cinema ,denom)"
circumfer`ential	Suffix	"AJ(cir`cumference ,denom)"
`circumspect	Suffix	"AJ(`circumspect ,)"
circum`stantial	Suffix	"AJ(`circumstance ,denom)"
`citric	IC_Suffix	"AJ(`citric ,)"
`citywide	Suffix	"AJ(`citywide ,)"
`civic	Suffix	"AJ(`civic ,)"
`civil	Suffix	"AJ(`civil ,)"
`clad	Suffix	"AJ(`clad ,)"
`clandestine	Suffix	"AJ(`clandestine ,)"
`classificatory	Suffix	"AJ(`class ,denom)"
claustro`phobic	IC_Suffix	"AJ(claustro`phobia ,denom)"
clear`headed	Suffix	"AJ(`head ,denom)"
`clement	Suffix	"AJ(`clement ,)"
`clever	Suffix	"AJ(`clever ,)"
cli`mactic	IC_Suffix	"AJ(`climax ,denom)"
`close	Suffix	"AJ(`close ,)"
`clothbound	Suffix	"AJ(`clothbound ,)"
`clumsy	Suffix	"AJ(`clumsy ,)"
co`agulable	Suffix	"AJ(co`agulate ,deverb)"
`coarse	Suffix	"AJ(`coarse ,)"
`cochineal	Suffix	"AJ(`cochineal ,)"
`cockeyed	Suffix	"AJ(`cockeyed ,)"
`cocksure	Suffix	"AJ(`cocksure ,)"
`cocky	Suffix	"AJ(`cocky ,)"
`cogent	Suffix	"AJ(`cogent ,)"
`cognitive	Suffix	"AJ(`cognitive ,)"
`cognizable	Suffix	"AJ(`cognizable ,)"
`cognizant	Suffix	"AJ(`cognizant ,)"
co`hesive	Suffix	"AJ(co`here ,deverb)"
coinci`dental	Suffix	"AJ(co`incidence ,denom)"
`coliform	Suffix	"AJ(`coliform ,)"
`colicky	Suffix	"AJ(`colic ,denom)"
col`legiate	Suffix	"AJ(`college ,denom)"
col`linear	Suffix	"AJ(col`linear ,)"
col`loquial	Suffix	"AJ(col`loquial ,)"
co`lossal	Suffix	"AJ(co`lossal ,)"
`columnar	Suffix	"AJ(`column ,denom)"
`comatose	Suffix	"AJ(`comatose ,)"
`comely	Suffix	"AJ(`comely ,)"
`comfortable	Suffix	"AJ(`comfort ,denom)"
`comic	IC_Suffix	"AJ(`comic ,)"
com`mendatory	Suffix	"AJ(com`mend ,deverb)"
com`mensurable	Suffix	"AJ(com`mensurable ,)"
com`mensurate	Suffix	"AJ(com`mensurate ,)"
com`modious	Suffix	"AJ(com`modious ,)"
`common	Suffix	"AJ(`common ,)"
com`municable	Suffix	"AJ(com`municate ,deverb)"
com`panionable	Suffix	"AJ(com`panion ,denom)"
com`parative	Suffix	"AJ(com`pare ,deverb)"
com`passionate	Suffix	"AJ(com`passion ,denom)"
com`pendious	Suffix	"AJ(com`pendious ,)"
com`pensable	Suffix	"AJ(`compensate ,deverb)"
`competent	Suffix	"AJ(`competent ,)"
com`petitive	Suffix	"AJ(com`pete ,deverb)"
com`placent	Suffix	"AJ(com`placent ,)"
com`plaisant	Suffix	"AJ(com`plaisant ,)"
com`pleat	Suffix	"AJ(com`pleat ,)"
comple`mentary	Suffix	"AJ(`complement ,denom)"
com`plex	Suffix	"AJ(com`plex ,)"
com`pliant	Suffix	"AJ(com`ply ,deverb)"
compli`mentary	Suffix	"AJ(`compliment ,denom)"
com`posite	Suffix	"AJ(com`posite ,)"
com`pound	Suffix	"AJ(com`pound ,)"
com`pulsive	Suffix	"AJ(com`pell ,deverb)"
com`pulsory	Suffix	"AJ(com`pell ,deverb)"
compre`hensible	Suffix	"AJ(compre`hend ,deverb)"
compre`hensive	Suffix	"AJ(compre`hend ,deverb)"
con`cave	Suffix	"AJ(con`cave ,)"
con`centric	IC_Suffix	"AJ(con`centric ,)"
con`cise	Suffix	"AJ(con`cise ,)"
con`clusive	Suffix	"AJ(con`clude ,deverb)"
con`comitant	Suffix	"AJ(con`comitant ,)"
con`cordant	Suffix	"AJ(con`cord ,deverb)"
con`crete	Suffix	"AJ(con`crete ,)"
con`cupiscent	Suffix	"AJ(con`cupiscent ,)"
con`demnatory	Suffix	"AJ(con`demn ,deverb)"
`confident	Suffix	"AJ(`confident ,)"
confi`dential	Suffix	"AJ(con`fide ,deverb)"
con`firmatory	Suffix	"AJ(con`firm ,deverb)"
con`fiscable	Suffix	"AJ(`confiscate ,deverb)"
con`fluent	Suffix	"AJ(con`fluent ,)"
con`focal	Suffix	"AJ(con`focal ,)"
con`genial	Suffix	"AJ(con`genial ,)"
con`genital	Suffix	"AJ(con`genital ,)"
con`gressional	Suffix	"AJ(`congress ,denom)"
con`gruent	Suffix	"AJ(con`gruent ,)"
`congruous	Suffix	"AJ(`congruous ,)"
con`jugal	Suffix	"AJ(con`jugal ,)"
con`nubial	Suffix	"AJ(con`nubial ,)"
con`sanguine	Suffix	"AJ(con`sanguine ,)"
consan`guineous	Suffix	"AJ(con`sanguine ,denom)"
consci`entious	Suffix	"AJ(`conscience ,denom)"
`conscionable	Suffix	"AJ(`conscionable ,)"
`conscious	Suffix	"AJ(`conscious ,)"
con`secutive	Suffix	"AJ(con`secutive ,)"
con`sensual	Suffix	"AJ(con`sent ,deverb)"
con`siderate	Suffix	"AJ(con`sider ,deverb)"
con`spicuous	Suffix	"AJ(con`spicuous ,)"
`consular	Suffix	"AJ(`consular ,)"
con`sumptive	Suffix	"AJ(con`sume ,deverb)"
con`tagious	Suffix	"AJ(con`tagious ,)"
con`temptible	Suffix	"AJ(con`temp ,denom)"
con`temptuous	Suffix	"AJ(con`temp ,denom)"
contempo`raneous	Suffix	"AJ(contempo`raneous ,)"
con`tent	Suffix	"AJ(con`tent ,)"
con`tentious	Suffix	"AJ(con`tend ,deverb)"
con`tiguous	Suffix	"AJ(con`tiguous ,)"
con`tinuous	Suffix	"AJ(con`tinue ,deverb)"
`continent	Suffix	"AJ(`continent ,)"
con`tingent	Suffix	"AJ(con`tingent ,)"
con`tinual	Suffix	"AJ(con`tinue ,deverb)"
`contrary	Suffix	"AJ(`contrary ,)"
`contrite	Suffix	"AJ(`contrite ,)"
con`venient	Suffix	"AJ(con`venient ,)"
con`versant	Suffix	"AJ(con`verse ,deverb)"
con`vex	Suffix	"AJ(con`vex ,)"
con`vivial	Suffix	"AJ(con`vivial ,)"
cool`headed	Suffix	"AJ(`head ,denom)"
`copious	Suffix	"AJ(`copious ,)"
`cordial	Suffix	"AJ(`cordial ,)"
`corporate	Suffix	"AJ(`corporate ,)"
cor`poreal	Suffix	"AJ(cor`poreal ,)"
`corpulent	Suffix	"AJ(`corpulent ,)"
cor`puscular	Suffix	"AJ(`corpuscle ,denom)"
`corrigible	Suffix	"AJ(`corrigible ,)"
cor`rosive	Suffix	"AJ(cor`rode ,deverb)"
`cortical	Suffix	"AJ(`cortical ,)"
cos`metic	IC_Suffix	"AJ(cos`metic ,)"
`cosmic	IC_Suffix	"AJ(`cosmic ,)"
cosmo`politan	Suffix	"AJ(cosmo`politan ,)"
`cosy	Suffix	"AJ(`cosy ,)"
`countrywide	Suffix	"AJ(`countrywide ,)"
`countywide	Suffix	"AJ(`countywide ,)"
`courteous	Suffix	"AJ(`courteous ,)"
`covert	Suffix	"AJ(`covert ,)"
`covetous	Suffix	"AJ(`covet ,deverb)"
`coy	Suffix	"AJ(`coy ,)"
`cozy	Suffix	"AJ(`cozy ,)"
`crafty	Suffix	"AJ(`crafty ,)"
`crass	Suffix	"AJ(`crass ,)"
`craven	Suffix	"AJ(`craven ,)"
`crazy	Suffix	"AJ(`crazy ,)"
`credent	Suffix	"AJ(`credent ,)"
`credible	Suffix	"AJ(`credible ,)"
`credulous	Suffix	"AJ(`credulous ,)"
`crestfallen	Suffix	"AJ(`crestfallen ,)"
cre`taceous	Suffix	"AJ(cre`taceous ,)"
`crooked	Suffix	"AJ(`crooked ,)"
`crucial	Suffix	"AJ(`crucial ,)"
`crude	Suffix	"AJ(`crude ,)"
`cruel	Suffix	"AJ(`cruel ,)"
`crummy	Suffix	"AJ(`crummy ,)"
cryo`genic	IC_Suffix	"AJ(cryo`genic ,)"
`cryptic	IC_Suffix	"AJ(`cryptic ,)"
`crystalline	Suffix	"AJ(`crystal ,denom)"
`cuddly	Suffix	"AJ(`cuddle ,deverb)"
`culinary	Suffix	"AJ(`culinary ,)"
`culpable	Suffix	"AJ(`culpable ,)"
`cultivable	Suffix	"AJ(`cultivate ,deverb)"
`cumbersome	Suffix	"AJ(`cumbersome ,)"
`cumbrous	Suffix	"AJ(`cumbrous ,)"
`cunning	Suffix	"AJ(`cunning ,)"
`cupric	Suffix	"AJ(`cupric ,)"
`cuprous	Suffix	"AJ(`cuprous ,)"
`curious	Suffix	"AJ(`curious ,)"
`current	Suffix	"AJ(`current ,)"
cur`ricular	Suffix	"AJ(cur`ricular ,)"
`cursive	Suffix	"AJ(`cursive ,)"
`cursory	Suffix	"AJ(`cursory ,)"
`curt	Suffix	"AJ(`curt ,)"
`curvy	Suffix	"AJ(`curve ,denom)"
cur`vaceous	Suffix	"AJ(cur`vaceous ,)"
`customary	Suffix	"AJ(`custom ,denom)"
cu`taneous	Suffix	"AJ(cu`taneous ,)"
`cute	Suffix	"AJ(`cute ,)"
`cutesy	Suffix	"AJ(`cutesy ,)"
cyber`netic	IC_Suffix	"AJ(cyber`netic ,)"
`cyclable	Suffix	"AJ(`cycle ,deverb)"
`cyclic	IC_Suffix	"AJ(`cycle ,deverb)"
cyclo`pean	Suffix	"AJ(cyclo`pean ,)"
cy`lindric	IC_Suffix	"AJ(`cylinder ,denom)"
`daffy	Suffix	"AJ(`daffy ,)"
`daft	Suffix	"AJ(`daft ,)"
`dainty	Suffix	"AJ(`dainty ,)"
`damp	Suffix	"AJ(`damp ,)"
`dank	Suffix	"AJ(`dank ,)"
`dapper	Suffix	"AJ(`dapper ,)"
`dark	Suffix	"AJ(`dark ,)"
`dauntless	Suffix	"AJ(`daunt ,deverb)"
`daylong	Suffix	"AJ(`daylong ,)"
`dead	Suffix	"AJ(`dead ,)"
`deadly	Suffix	"AJ(`dead ,)"
`deaf	Suffix	"AJ(`deaf ,)"
debo`nair	Suffix	"AJ(debo`nair ,)"
`decadent	Suffix	"AJ(`decadent ,)"
de`cennial	Suffix	"AJ(de`cennial ,)"
`decent	Suffix	"AJ(`decent ,)"
de`ceptive	Suffix	"AJ(de`ceive ,deverb)"
de`ciduous	Suffix	"AJ(de`ciduous ,)"
de`cisive	Suffix	"AJ(de`cide ,deverb)"
de`clamatory	Suffix	"AJ(de`claim ,deverb)"
de`clarative	Suffix	"AJ(de`clare ,deverb)"
de`claratory	Suffix	"AJ(de`clare ,deverb)"
`decorous	Suffix	"AJ(`decorous ,)"
de`crepit	Suffix	"AJ(de`crepit ,)"
`deep	Suffix	"AJ(`deep ,)"
de`famatory	Suffix	"AJ(de`fame ,deverb)"
de`fault	Suffix	"AJ(de`fault ,)"
de`fensible	Suffix	"AJ(de`fend ,deverb)"
de`fensive	Suffix	"AJ(de`fend ,deverb)"
`deferent	Suffix	"AJ(`deferent - exception to Gemination due to irregular stress,deverb)"
defer`ential	Suffix	"AJ(de`fer ,deverb)"
de`ficient	Suffix	"AJ(de`ficient ,)"
`definite	Suffix	"AJ(`definite ,)"
de`finitive	Suffix	"AJ(de`fine ,deverb)"
de`flationary	Suffix	"AJ(de`flate ,deverb)"
`deft	Suffix	"AJ(`deft ,)"
de`funct	Suffix	"AJ(de`funct ,)"
de`lectable	Suffix	"AJ(de`lectable ,)"
de`lectate	Suffix	"AJ(de`lectate ,)"
`delegable	Suffix	"AJ(`delegate ,deverb)"
dele`terious	Suffix	"AJ(dele`terious ,)"
`delicate	Suffix	"AJ(`delicate ,)"
de`licious	Suffix	"AJ(de`licious ,)"
de`lirious	Suffix	"AJ(de`lirious ,)"
de`lusionary	Suffix	"AJ(de`lude ,deverb)"
de`luxe	Suffix	"AJ(de`luxe ,)"
de`mented	Suffix	"AJ(de`mented ,)"
de`miscible	Suffix	"AJ(de`miscible ,)"
de`monstrable	Suffix	"AJ(`demonstrate ,deverb)"
de`mure	Suffix	"AJ(de`mure ,)"
`dense	Suffix	"AJ(`dense ,)"
`dental	Suffix	"AJ(`dental ,)"
de`numerable	Suffix	"AJ(de`numerate ,deverb)"
de`preciable	Suffix	"AJ(de`preciate ,deverb)"
de`scriptive	Suffix	"AJ(de`scribe ,deverb)"
`desperate	Suffix	"AJ(des`pair ,deverb)"
des`picable	Suffix	"AJ(des`pise ,deverb)"
`destitute	Suffix	"AJ(`destitute ,)"
de`sultory	Suffix	"AJ(de`sultory ,)"
de`terminate	Suffix	"AJ(de`termine ,deverb)"
`detonable	Suffix	"AJ(`detonate ,deverb)"
`devious	Suffix	"AJ(`devious ,)"
de`void	Suffix	"AJ(de`void ,)"
devo`lutionary	Suffix	"AJ(de`volve ,deverb)"
de`vout	Suffix	"AJ(de`vout ,)"
`dexterous	Suffix	"AJ(`dexterous ,)"
`dextrous	Suffix	"AJ(`dextrous ,)"
dia`betic	IC_Suffix	"AJ(dia`betic ,)"
dia`bolic	IC_Suffix	"AJ(dia`bolic ,)"
diag`nostic	IC_Suffix	"AJ(diag`nosis ,denom)"
diagram`matic	IC_Suffix	"AJ(`diagram ,denom)"
dia`magnetic	IC_Suffix	"AJ(dia`magnetic ,)"
dia`metric	IC_Suffix	"AJ(di`ameter ,denom)"
di`aphanous	Suffix	"AJ(di`aphanous ,)"
diato`maceous	Suffix	"AJ(diato`maceous ,)"
dia`tonic	IC_Suffix	"AJ(dia`tonic ,)"
di`dactic	IC_Suffix	"AJ(di`dactic ,)"
`dietary	Suffix	"AJ(`diet ,denom)"
differ`entiable	Suffix	"AJ(`different ,deadj)"
`difficult	Suffix	"AJ(`difficult ,)"
`diffident	Suffix	"AJ(`diffident ,)"
dif`fuse	Suffix	"AJ(dif`fuse ,)"
`digitate	Suffix	"AJ(`digitate ,)"
`dilatory	Suffix	"AJ(`dilatory ,)"
`diligent	Suffix	"AJ(`diligent ,)"
di`luvial	Suffix	"AJ(di`luvial ,)"
di`luvian	Suffix	"AJ(di`luvian ,)"
diminutive	Suffix	"AJ(diminutive ,)"
`dingy	Suffix	"AJ(`dingy ,)"
`dire	Suffix	"AJ(`dire ,)"
`direful	Suffix	"AJ(`dire ,)"
di`rect	Suffix	"AJ(di`rect ,)"
di`sastrous	Suffix	"AJ(di`saster ,denom)"
`disciplinary	Suffix	"AJ(`discipline ,denom)"
`discoid	Suffix	"AJ(`discoid ,)"
disconsolate	Suffix	"AJ(con`sole ,deverb)"
dis`cordant	Suffix	"AJ(`discord ,denom)"
dis`creet	Suffix	"AJ(dis`creet ,)"
dis`crepant	Suffix	"AJ(dis`crepant ,)"
dis`crete	Suffix	"AJ(dis`crete ,)"
dis`cretionary	Suffix	"AJ(dis`cretion ,denom)"
dis`criminable	Suffix	"AJ(dis`criminate ,deverb)"
dis`junctive	Suffix	"AJ(dis`junct ,)"
`dismal	Suffix	"AJ(`dismal ,)"
`disparate	Suffix	"AJ(`disparate ,)"
dispu`tatious	Suffix	"AJ(dis`pute ,deverb)"
dis`sociable	Suffix	"AJ(as`sociate ,deverb)"
dis`soluble	Suffix	"AJ(dis`solve ,deverb)"
`dissolute	Suffix	"AJ(`dissolute ,)"
`dissonant	Suffix	"AJ(`dissonant ,)"
`distal	Suffix	"AJ(`distal ,)"
`distant	Suffix	"AJ(`distant ,)"
dis`tinct	Suffix	"AJ(dis`tinct ,)"
dis`tinctive	Suffix	"AJ(dis`tinct ,)"
dis`traught	Suffix	"AJ(dis`traught ,)"
di`urnal	Suffix	"AJ(di`urnal ,)"
di`valent	Suffix	"AJ(di`valent ,)"
di`verse	Suffix	"AJ(di`verse ,)"
di`versionary	Suffix	"AJ(di`version ,denom)"
di`vine	Suffix	"AJ(di`vine ,)"
di`visible	Suffix	"AJ(di`vide ,deverb)"
di`visive	Suffix	"AJ(di`vide ,deverb)"
`doable	Suffix	"AJ(`do ,deverb)"
`docile	Suffix	"AJ(`docile ,)"
doctri`naire	Suffix	"AJ(doctri`naire ,)"
dog`gone	Suffix	"AJ(dog`gone ,)"
dog`matic	IC_Suffix	"AJ(`dogma ,denom)"
`dolce	Suffix	"AJ(`dolce ,)"
`doleful	Suffix	"AJ(`doleful ,)"
do`mestic	IC_Suffix	"AJ(do`mestic ,)"
`dominant	Suffix	"AJ(`dominate ,deverb)"
`dormant	Suffix	"AJ(`dormant ,)"
`dorsal	Suffix	"AJ(`dorsal ,)"
`douce	Suffix	"AJ(`douce ,)"
`doughty	Suffix	"AJ(`doughty ,)"
`dour	Suffix	"AJ(`dour ,)"
`down	Suffix	"AJ(`down ,)"
`downbeat	Suffix	"AJ(`downbeat ,)"
`downcast	Suffix	"AJ(`downcast ,)"
down`hill	Suffix	"AJ(down`hill ,)"
`downright	Suffix	"AJ(`downright ,)"
down`river	Suffix	"AJ(down`river ,)"
`downtrodden	Suffix	"AJ(`downtrodden ,)"
down`wind	Suffix	"AJ(down`wind ,)"
`drab	Suffix	"AJ(`drab ,)"
dra`matic	IC_Suffix	"AJ(`drama ,denom)"
`drastic	IC_Suffix	"AJ(`drastic ,)"
`drear	Suffix	"AJ(`drear ,)"
`dreary	Suffix	"AJ(`dreary ,)"
`drizzly	Suffix	"AJ(`drizzle ,denom)"
`droll	Suffix	"AJ(`droll ,)"
`droopy	Suffix	"AJ(`droop ,deverb)"
`drowsy	Suffix	"AJ(`drowse ,deverb)"
`drunken	Suffix	"AJ(`drink ,deverb)"
`dubious	Suffix	"AJ(`dubious ,)"
`dubitable	Suffix	"AJ(`dubitable ,)"
`ductile	Suffix	"AJ(`ductile ,)"
`dulcet	Suffix	"AJ(`dulcet ,)"
`duly	Suffix	"AJ(`duly ,)"
`dumb	Suffix	"AJ(`dumb ,)"
`dumpy	Suffix	"AJ(`dumpy ,)"
`duplicable	Suffix	"AJ(`duplicate ,deverb)"
`durable	Suffix	"AJ(`durable ,)"
`durative	Suffix	"AJ(`durative ,)"
`dusky	Suffix	"AJ(`dusky ,)"
`dutiable	Suffix	"AJ(`duty ,denom)"
dy`adic	IC_Suffix	"AJ(dy`adic ,)"
dy`namic	IC_Suffix	"AJ(dy`namic ,)"
dy`nastic	IC_Suffix	"AJ(`dynasty ,denom)"
dys`peptic	IC_Suffix	"AJ(dys`peptic ,)"
`eager	Suffix	"AJ(`eager ,)"
`earnest	Suffix	"AJ(`earnest ,)"
`earthen	Suffix	"AJ(`earth ,denom)"
`earthshaking	Suffix	"AJ(`earthshaking ,)"
`eastbound	Suffix	"AJ(`eastbound ,)"
`eastern	Suffix	"AJ(`eastern ,)"
easy`going	Suffix	"AJ(easy`going ,)"
e`bullient	Suffix	"AJ(e`bullient ,)"
ec`centric	IC_Suffix	"AJ(ec`centric ,)"
ecclesi`astic	IC_Suffix	"AJ(ecclesi`astic ,)"
ec`lectic	IC_Suffix	"AJ(ec`lectic ,)"
ec`liptic	IC_Suffix	"AJ(e`clipse ,denom)"
econo`metric	IC_Suffix	"AJ(econo`metric ,)"
ec`static	IC_Suffix	"AJ(ec`static ,)"
ecu`menic	IC_Suffix	"AJ(ecu`menic ,)"
`edgy	Suffix	"AJ(`edge ,denom)"
`edible	Suffix	"AJ(`eat ,deverb)"
`educable	Suffix	"AJ(`educate ,deverb)"
`eerie	Suffix	"AJ(`eerie ,)"
`eery	Suffix	"AJ(`eery ,)"
`effable	Suffix	"AJ(`effable ,)"
ef`feminate	Suffix	"AJ(ef`feminate ,)"
`efferent	Suffix	"AJ(`efferent ,)"
ef`fete	Suffix	"AJ(ef`fete ,)"
ef`ficient	Suffix	"AJ(ef`ficient ,)"
`effluent	Suffix	"AJ(`effluent ,)"
ef`fulgent	Suffix	"AJ(ef`fulgent ,)"
ego`centric	IC_Suffix	"AJ(ego`centric ,)"
e`gregious	Suffix	"AJ(e`gregious ,)"
e`lastic	IC_Suffix	"AJ(e`lastic ,)"
e`lectric	IC_Suffix	"AJ(e`lectric ,)"
`elegant	Suffix	"AJ(`elegant ,)"
ele`giac	Suffix	"AJ(ele`giac ,)"
ele`mentary	Suffix	"AJ(ele`mentary ,)"
`elephantine	Suffix	"AJ(`elephant ,denom)"
`elfin	Suffix	"AJ(`elfin ,)"
`eligible	Suffix	"AJ(`eligible ,)"
e`lite	Suffix	"AJ(e`lite ,)"
el`liptic	IC_Suffix	"AJ(el`liptic ,)"
`eloquent	Suffix	"AJ(`eloquent ,)"
e`lusive	Suffix	"AJ(e`lusive ,)"
`elvish	Suffix	"AJ(`elf ,denom)"
e`lysian	Suffix	"AJ(e`lysian ,)"
emble`matic	IC_Suffix	"AJ(emble`matic ,)"
embry`onic	IC_Suffix	"AJ(embry`onic ,)"
e`mendable	Suffix	"AJ(e`mendable ,)"
e`meritus	Suffix	"AJ(e`meritus ,)"
`eminent	Suffix	"AJ(`eminent ,)"
em`phatic	IC_Suffix	"AJ(em`phatic ,)"
em`piric	IC_Suffix	"AJ(em`piric ,)"
encyclo`pedic	IC_Suffix	"AJ(encyclo`pedic ,)"
en`demic	IC_Suffix	"AJ(en`demic ,)"
ener`getic	IC_Suffix	"AJ(`energy ,denom)"
enig`matic	IC_Suffix	"AJ(e`nigma ,denom)"
e`normous	Suffix	"AJ(e`normous ,)"
`enterprising	Suffix	"AJ(`enterprising ,)"
en`tire	Suffix	"AJ(en`tire ,)"
en`tropic	IC_Suffix	"AJ(`entropy ,denom)"
e`numerable	Suffix	"AJ(e`numerate ,deverb)"
e`nunciable	Suffix	"AJ(e`nunciate ,deverb)"
enzy`matic	IC_Suffix	"AJ(`enzyme ,denom)"
e`phemeral	Suffix	"AJ(e`phemeral ,)"
`epicene	Suffix	"AJ(`epicene ,)"
epi`dermic	IC_Suffix	"AJ(epi`dermic ,)"
epige`netic	IC_Suffix	"AJ(epige`netic ,)"
epigram`matic	IC_Suffix	"AJ(epigram`matic ,)"
epi`leptic	IC_Suffix	"AJ(epi`leptic ,)"
e`piscopal	Suffix	"AJ(e`piscopal ,)"
e`pistolatory	Suffix	"AJ(e`pistolatory ,)"
`equable	Suffix	"AJ(`equable ,)"
e`questrian	Suffix	"AJ(e`questrian ,)"
equi`distant	Suffix	"AJ(equi`distant ,)"
equi`lateral	Suffix	"AJ(equi`lateral ,)"
`equine	Suffix	"AJ(`equine ,)"
equi`noctial	Suffix	"AJ(`equinox ,denom)"
equi`potent	Suffix	"AJ(equi`potent ,)"
`equitable	Suffix	"AJ(`equitable ,)"
e`quivocal	Suffix	"AJ(e`quivocal ,)"
e`radicable	Suffix	"AJ(e`radicate ,deverb)"
e`rosible	Suffix	"AJ(e`rode ,deverb)"
e`rotic	IC_Suffix	"AJ(e`rotic ,)"
`errant	Suffix	"AJ(`errant ,)"
er`ratic	IC_Suffix	"AJ(er`ratic ,)"
er`roneous	Suffix	"AJ(er`roneous ,)"
er`satz	Suffix	"AJ(er`satz ,)"
e`rudite	Suffix	"AJ(e`rudite ,)"
eso`teric	IC_Suffix	"AJ(eso`teric ,)"
es`pecial	Suffix	"AJ(es`pecial ,)"
`estimable	Suffix	"AJ(`estimate ,deverb)"
`estuarine	Suffix	"AJ(`estuary ,denom)"
e`ternal	Suffix	"AJ(e`ternal ,)"
e`thereal	Suffix	"AJ(e`thereal ,)"
`ethnic	IC_Suffix	"AJ(`ethnic ,)"
ethnolin`guistic	IC_Suffix	"AJ(ethnolin`guistic ,)"
eu`genic	IC_Suffix	"AJ(eu`genic ,)"
euphe`mistic	IC_Suffix	"AJ(euphe`mistic ,)"
eu`phoric	IC_Suffix	"AJ(eu`phoric ,)"
e`valuable	Suffix	"AJ(e`valuate ,deverb)"
eva`nescent	Suffix	"AJ(eva`nescent ,)"
e`vasive	Suffix	"AJ(e`vade ,deverb)"
even`handed	Suffix	"AJ(`hand ,denom)"
e`ventual	Suffix	"AJ(e`ventual ,)"
`evergreen	Suffix	"AJ(`evergreen ,)"
ever`lasting	Suffix	"AJ(ever`lasting ,)"
`everyday	Suffix	"AJ(`everyday ,)"
`evident	Suffix	"AJ(`evident ,)"
evi`dential	Suffix	"AJ(`evidence ,denom)"
`evitable	Suffix	"AJ(`evitable ,)"
e`vocable	Suffix	"AJ(e`voke ,deverb)"
evo`lutionary	Suffix	"AJ(e`volve ,deverb)"
ex`act	Suffix	"AJ(ex`act ,)"
ex`cessive	Suffix	"AJ(`excess ,denom)"
ex`citatory	Suffix	"AJ(ex`cite ,deverb)"
ex`clamatory	Suffix	"AJ(ex`claim ,deverb)"
ex`clusionary	Suffix	"AJ(ex`clude ,deverb)"
ex`clusive	Suffix	"AJ(ex`clude ,deverb)"
ex`crescent	Suffix	"AJ(ex`crescent ,)"
`execrable	Suffix	"AJ(`execrable ,)"
`exigent	Suffix	"AJ(`exigent ,)"
exis`tential	Suffix	"AJ(ex`ist ,deverb)"
ex`orbitant	Suffix	"AJ(ex`orbitant ,)"
ex`otic	IC_Suffix	"AJ(ex`otic ,)"
ex`pansible	Suffix	"AJ(ex`pand ,deverb)"
ex`pansive	Suffix	"AJ(ex`pand ,deverb)"
ex`pedient	Suffix	"AJ(ex`pedient ,)"
expe`ditious	Suffix	"AJ(`expedite ,deverb)"
ex`pensive	Suffix	"AJ(ex`pense ,denom)"
experi`ential	Suffix	"AJ(ex`perience ,deverb)"
`expiable	Suffix	"AJ(`expiable ,)"
ex`planatory	Suffix	"AJ(ex`plain ,deverb)"
`explicable	Suffix	"AJ(`explicate ,deverb)"
ex`plicit	Suffix	"AJ(ex`plicit ,)"
ex`ploratory	Suffix	"AJ(ex`plore ,deverb)"
ex`press	Suffix	"AJ(ex`press ,)"
ex`quisite	Suffix	"AJ(ex`quisite ,)"
`extant	Suffix	"AJ(`extant ,)"
extempo`raneous	Suffix	"AJ(extempo`raneous ,)"
ex`tempore	Suffix	"AJ(ex`tempore ,)"
ex`tensible	Suffix	"AJ(ex`tend ,deverb)"
ex`tensive	Suffix	"AJ(ex`tend ,deverb)"
ex`tinct	Suffix	"AJ(ex`tinct ,)"
extra`mural	Suffix	"AJ(extra`mural ,)"
ex`traneous	Suffix	"AJ(ex`traneous ,)"
ex`travagant	Suffix	"AJ(ex`travagant ,)"
ex`tricable	Suffix	"AJ(`extricate ,deverb)"
ex`trinsic	IC_Suffix	"AJ(ex`trinsic ,)"
ex`uberant	Suffix	"AJ(ex`uberant ,)"
ex`ultant	Suffix	"AJ(ex`ult ,deverb)"
`fabulous	Suffix	"AJ(`fabulous ,)"
fa`cetious	Suffix	"AJ(fa`cetious ,)"
`facile	Suffix	"AJ(`facile ,)"
`factious	Suffix	"AJ(`factious ,)"
`facultative	Suffix	"AJ(`facultative ,)"
`fadeless	Suffix	"AJ(`fade ,deverb)"
`fahrenheit	Suffix	"AJ(`fahrenheit ,)"
`failsafe	Suffix	"AJ(`failsafe ,)"
`failsoft	Suffix	"AJ(`failsoft ,)"
`faint	Suffix	"AJ(`faint ,)"
`fake	Suffix	"AJ(`fake ,)"
`fallible	Suffix	"AJ(`fallible ,)"
`fallow	Suffix	"AJ(`fallow ,)"
`false	Suffix	"AJ(`false ,)"
fa`miliar	Suffix	"AJ(fa`miliar ,)"
`fancy	Suffix	"AJ(`fancy ,)"
`fanfold	Suffix	"AJ(`fanfold ,)"
fan`tastic	IC_Suffix	"AJ(fan`tastic ,)"
far`fetched	Suffix	"AJ(`fetch ,deverb)"
`fashionable	Suffix	"AJ(`fashion ,denom)"
far`sighted	Suffix	"AJ(`sight ,denom)"
`fast	Suffix	"AJ(`fast ,rev)"
fas`tidious	Suffix	"AJ(fas`tidious ,)"
`fatal	Suffix	"AJ(`fatal ,)"
`fatuous	Suffix	"AJ(`fatuous ,)"
`fearsome	Suffix	"AJ(`fear ,deverb)"
`feasible	Suffix	"AJ(`feasible ,)"
`featherbrained	Suffix	"AJ(`featherbrain ,denom)"
`febrile	Suffix	"AJ(`febrile ,)"
`feckless	Suffix	"AJ(`feckless ,)"
`fecund	Suffix	"AJ(`fecund ,)"
`federal	Suffix	"AJ(`federal ,)"
`feeble	Suffix	"AJ(`feeble ,)"
feeble`minded	Suffix	"AJ(`mind ,denom)"
fe`licitous	Suffix	"AJ(fe`licity ,denom)"
`feminine	Suffix	"AJ(`feminine ,)"
`ferric	IC_Suffix	"AJ(`ferric ,)"
`ferrous	Suffix	"AJ(`ferrous ,)"
fe`rocious	Suffix	"AJ(fe`rocious ,)"
`fertile	Suffix	"AJ(`fertile ,)"
`fervent	Suffix	"AJ(`fervent ,)"
`festive	Suffix	"AJ(`festive ,)"
`fetal	Suffix	"AJ(`fetal ,)"
`fetid	Suffix	"AJ(`fetid ,)"
`feudal	Suffix	"AJ(`feudal ,)"
`feudatory	Suffix	"AJ(`feudatory ,)"
`few	Suffix	"AJ(`few ,pl)"
`fibrous	Suffix	"AJ(`fiber ,denom)"
`fickle	Suffix	"AJ(`fickle ,)"
fic`titious	Suffix	"AJ(fic`titious ,)"
fi`ducial	Suffix	"AJ(fi`ducial ,)"
`fierce	Suffix	"AJ(`fierce ,)"
`fiery	Suffix	"AJ(`fire ,denom)"
`figurative	Suffix	"AJ(`figure ,denom)"
fila`mentary	Suffix	"AJ(`filament ,denom)"
`filial	Suffix	"AJ(`filial ,)"
`final	Suffix	"AJ(`final ,)"
`fine	Suffix	"AJ(`fine ,)"
`finicky	Suffix	"AJ(`finicky ,)"
`finite	Suffix	"AJ(`finite ,)"
`fireproof	Suffix	"AJ(`fireproof ,)"
`firstborn	Suffix	"AJ(`firstborn ,)"
`firsthand	Suffix	"AJ(`firsthand ,)"
`fiscal	Suffix	"AJ(`fiscal ,)"
`fit	Suffix	"AJ(`fit ,)"
`flagrant	Suffix	"AJ(`flagrant ,)"
flam`boyant	Suffix	"AJ(flam`boyant ,)"
`flammable	Suffix	"AJ(`flame ,deverb)"
`flappable	Suffix	"AJ(`flappable ,)"
`flat	Suffix	"AJ(`flat ,)"
`flatulent	Suffix	"AJ(`flatus ,denom)"
`flaxen	Suffix	"AJ(`flax ,denom)"
`fleecy	Suffix	"AJ(`fleece ,denom)"
`flimsy	Suffix	"AJ(`flimsy ,)"
`flippant	Suffix	"AJ(`flippant ,)"
flir`tatious	Suffix	"AJ(`flirt ,deverb)"
`floodlit	Suffix	"AJ(`floodlit ,)"
`floral	Suffix	"AJ(`flower ,denom)"
`florid	Suffix	"AJ(`florid ,)"
`fluent	Suffix	"AJ(`fluent ,)"
`fluid	Suffix	"AJ(`fluid ,)"
`fluvial	Suffix	"AJ(`fluvial ,)"
`focal	Suffix	"AJ(`focal ,)"
`foetal	Suffix	"AJ(`foetal - British,)"
`foetid	Suffix	"AJ(`foetid - British,)"
`folksy	Suffix	"AJ(`folk ,denom)"
`fond	Suffix	"AJ(`fond ,)"
`foolhardy	Suffix	"AJ(`foolhardy ,)"
`foolproof	Suffix	"AJ(`foolproof ,)"
`foreign	Suffix	"AJ(`foreign ,)"
`foremost	Suffix	"AJ(`foremost ,)"
fo`rensic	IC_Suffix	"AJ(fo`rensic ,)"
for`ever	Suffix	"AJ(for`ever ,)"
for`getful	Suffix	"AJ(for`get ,deverb)"
for`going	Suffix	"AJ(for`going ,)"
for`lorn	Suffix	"AJ(for`lorn ,)"
`formal	Suffix	"AJ(`formal ,)"
`former	Suffix	"AJ(`former ,)"
for`midable	Suffix	"AJ(for`midable ,)"
`forte	Suffix	"AJ(`forte ,)"
forth`coming	Suffix	"AJ(forth`coming ,)"
`forthright	Suffix	"AJ(`forthright ,)"
for`tuitous	Suffix	"AJ(for`tuitous ,)"
`foulmouthed	Suffix	"AJ(`mouth ,denom)"
`foursquare	Suffix	"AJ(`foursquare ,)"
`fractious	Suffix	"AJ(`fractious ,)"
`fragile	Suffix	"AJ(`fragile ,)"
`fragmentary	Suffix	"AJ(`fragment ,denom)"
`fragrant	Suffix	"AJ(`fragrant ,)"
`frail	Suffix	"AJ(`frail ,)"
`frangible	Suffix	"AJ(`frangible ,)"
`frantic	IC_Suffix	"AJ(`frantic ,)"
fra`ternal	Suffix	"AJ(fra`ternal ,)"
`fraudulent	Suffix	"AJ(`fraud ,denom)"
`fraught	Suffix	"AJ(`fraught ,)"
`freehand	Suffix	"AJ(`freehand ,)"
fre`netic	IC_Suffix	"AJ(fre`netic ,)"
`fresh	Suffix	"AJ(`fresh ,)"
`freshwater	Suffix	"AJ(`freshwater ,)"
`frigid	Suffix	"AJ(`frigid ,)"
`frisky	Suffix	"AJ(`frisky ,)"
`frivolous	Suffix	"AJ(`frivolous ,)"
`frolicky	Suffix	"AJ(`frolic ,deverb)"
`frolicsome	Suffix	"AJ(`frolic ,deverb)"
`froward	Suffix	"AJ(`froward ,)"
`frowzy	Suffix	"AJ(`frowzy ,)"
`frugal	Suffix	"AJ(`frugal ,)"
`fugal	Suffix	"AJ(`fugue ,denom)"
`full	Suffix	"AJ(`full ,)"
`fulsome	Suffix	"AJ(`fulsome ,)"
fu`nereal	Suffix	"AJ(`funeral ,denom)"
`fungal	Suffix	"AJ(`fungus ,denom)"
`fungible	Suffix	"AJ(`fungible ,)"
`fungoid	Suffix	"AJ(`fungoid ,)"
`furtive	Suffix	"AJ(`furtive ,)"
`fusiform	Suffix	"AJ(`fusiform ,)"
`fusty	Suffix	"AJ(`fusty ,)"
`futile	Suffix	"AJ(`futile ,)"
ga`lactic	IC_Suffix	"AJ(`galaxy ,denom)"
`gallant	Suffix	"AJ(`gallant ,)"
ga`lore	Suffix	"AJ(ga`lore ,)"
gal`vanic	IC_Suffix	"AJ(gal`vanic ,)"
`gamesome	Suffix	"AJ(`game ,denom)"
`gamy	Suffix	"AJ(`game ,denom)"
`gangling	Suffix	"AJ(`gangling ,)"
gar`gantuan	Suffix	"AJ(gar`gantuan ,)"
`garish	Suffix	"AJ(`garish ,)"
`garlicked	Suffix	"AJ(`garlic ,denom)"
`garlicky	Suffix	"AJ(`garlic ,denom)"
`garrulous	Suffix	"AJ(`garrulous ,)"
`gaseous	Suffix	"AJ(`gaseous - exception to Gemination,)"
`gauche	Suffix	"AJ(`gauche ,)"
`gaudy	Suffix	"AJ(`gaudy ,)"
`gaunt	Suffix	"AJ(`gaunt ,)"
`gawky	Suffix	"AJ(`gawky ,)"
`gelable	Suffix	"AJ(`gelable - exception to Gemination,)"
`general	Suffix	"AJ(`general ,)"
ge`neric	IC_Suffix	"AJ(ge`neric ,)"
`generous	Suffix	"AJ(`generous ,)"
`genial	Suffix	"AJ(`genial ,)"
`genitive	Suffix	"AJ(`genitive ,)"
gen`teel	Suffix	"AJ(gen`teel ,)"
`gentle	Suffix	"AJ(`gentle ,)"
`genuine	Suffix	"AJ(`genuine ,)"
geo`desic	IC_Suffix	"AJ(geo`desic ,)"
geo`detic	IC_Suffix	"AJ(geo`detic ,)"
geri`atric	IC_Suffix	"AJ(geri`atric ,)"
ger`mane	Suffix	"AJ(ger`mane ,)"
`germinal	Suffix	"AJ(`germ ,denom)"
`ghastly	Suffix	"AJ(`ghastly ,)"
`gibbous	Suffix	"AJ(`gibbous ,)"
`giddy	Suffix	"AJ(`giddy ,)"
gi`gantic	IC_Suffix	"AJ(gi`gantic ,)"
`gilt	Suffix	"AJ(`gilt ,)"
`gimpy	Suffix	"AJ(`gimpy ,)"
`glacial	Suffix	"AJ(`glacier ,denom)"
`glad	Suffix	"AJ(`glad ,)"
`glandular	Suffix	"AJ(`gland ,denom)"
`glaucous	Suffix	"AJ(`glaucous ,)"
`glib	Suffix	"AJ(`glib ,)"
`globular	Suffix	"AJ(`globe ,denom)"
`glottal	Suffix	"AJ(`glottal ,)"
`gluier	Suffix	"AJ(`glue ,comp)"
`gluiest	Suffix	"AJ(`glue ,super)"
`glum	Suffix	"AJ(`glum ,)"
`glutinous	Suffix	"AJ(`glutinous ,)"
`go-go	Suffix	"AJ(`go-go ,)"
`golden	Suffix	"AJ(`gold ,denom)"
good`natured	Suffix	"AJ(`nature ,denom)"
`gorgeous	Suffix	"AJ(`gorgeous ,)"
`gory	Suffix	"AJ(`gory ,)"
`gothic	IC_Suffix	"AJ(`gothic ,)"
`gracious	Suffix	"AJ(`grace ,denom)"
`gradual	Suffix	"AJ(`gradual ,)"
gram`matic	IC_Suffix	"AJ(gram`matic ,)"
`grand	Suffix	"AJ(`grand ,)"
gran`diloquent	Suffix	"AJ(gran`diloquent ,)"
grandi`ose	Suffix	"AJ(grandi`ose ,)"
`granular	Suffix	"AJ(`grain ,denom)"
`graphic	IC_Suffix	"AJ(`graphic ,)"
`grateful	Suffix	"AJ(`grateful ,)"
gra`tuitous	Suffix	"AJ(gra`tuitous ,)"
`grave	Suffix	"AJ(`grave ,)"
`graven	Suffix	"AJ(`graven ,)"
`gravid	Suffix	"AJ(`gravid ,)"
`greasy	Suffix	"AJ(`grease ,denom)"
`great	Suffix	"AJ(`great ,)"
gre`garious	Suffix	"AJ(gre`garious ,)"
`grievous	Suffix	"AJ(`grieve ,deverb)"
`grim	Suffix	"AJ(`grim ,)"
`grimy	Suffix	"AJ(`grime ,denom)"
`grisly	Suffix	"AJ(`grisly ,)"
`grizzly	Suffix	"AJ(`grizzly ,)"
`groggy	Suffix	"AJ(`groggy ,)"
`gross	Suffix	"AJ(`gross ,)"
gro`tesque	Suffix	"AJ(gro`tesque ,)"
`grubby	Suffix	"AJ(`grubby ,)"
`grudging	Suffix	"AJ(`grudging ,)"
`gruesome	Suffix	"AJ(`gruesome ,)"
`gruff	Suffix	"AJ(`gruff ,)"
guberna`torial	Suffix	"AJ(guberna`torial ,)"
`gullible	Suffix	"AJ(`gullible ,)"
`gutsy	Suffix	"AJ(`gutsy ,)"
`guttural	Suffix	"AJ(`guttural ,)"
`habitable	Suffix	"AJ(`habitable ,)"
`haggard	Suffix	"AJ(`haggard ,)"
`halcyon	Suffix	"AJ(`halcyon ,)"
`hale	Suffix	"AJ(`hale ,)"
`half	Suffix	"AJ(`half ,)"
half`hearted	Suffix	"AJ(`heart ,denom)"
half`way	Suffix	"AJ(half`way ,)"
hand`made	Suffix	"AJ(hand`made ,)"
`handsome	Suffix	"AJ(`handsome ,)"
`handy	Suffix	"AJ(`handy ,)"
hap`hazard	Suffix	"AJ(hap`hazard ,)"
`hapless	Suffix	"AJ(`hapless ,)"
`happy	Suffix	"AJ(`happy ,)"
`hard	Suffix	"AJ(`hard ,)"
hard`headed	Suffix	"AJ(`head ,denom)"
hard`hearted	Suffix	"AJ(`heart ,denom)"
hard`working	Suffix	"AJ(hard`working ,)"
`hardy	Suffix	"AJ(`hardy ,)"
har`monic	IC_Suffix	"AJ(`harmony ,denom)"
`harsh	Suffix	"AJ(`harsh ,)"
`hasty	Suffix	"AJ(`haste ,denom)"
`haughty	Suffix	"AJ(`haughty ,)"
`hazy	Suffix	"AJ(`haze ,denom)"
`headstrong	Suffix	"AJ(`headstrong ,)"
`heady	Suffix	"AJ(`heady ,)"
`heartbreaking	Suffix	"AJ(`heartbreaking ,)"
`heartbroken	Suffix	"AJ(`heartbroken ,)"
`heartfelt	Suffix	"AJ(`heartfelt ,)"
`heartwarming	Suffix	"AJ(`heartwarming ,)"
`heavy	Suffix	"AJ(`heavy ,)"
`hectic	IC_Suffix	"AJ(`hectic ,)"
`hefty	Suffix	"AJ(`hefty ,)"
hege`monic	IC_Suffix	"AJ(he`gemony ,denom)"
`heinous	Suffix	"AJ(`heinous ,)"
`helical	Suffix	"AJ(`helical ,)"
helter-`skelter	Suffix	"AJ(helter-`skelter ,)"
he`reditary	Suffix	"AJ(he`redity ,denom)"
`heritable	Suffix	"AJ(`heritable ,)"
herme`neutic	IC_Suffix	"AJ(herme`neutic ,)"
her`metic	IC_Suffix	"AJ(her`metic ,)"
`hesitant	Suffix	"AJ(`hesitate ,deverb)"
`heterodox	Suffix	"AJ(`heterodox ,)"
hetero`geneous	Suffix	"AJ(hetero`geneous ,)"
hetero`genous	Suffix	"AJ(hetero`genous ,)"
hexa`decimal	Suffix	"AJ(hexa`decimal ,)"
`hideous	Suffix	"AJ(`hideous ,)"
hier`atic	IC_Suffix	"AJ(hier`atic ,)"
hiero`glyphic	IC_Suffix	"AJ(hiero`glyphic ,)"
hifa`lutin	Suffix	"AJ(hifa`lutin ,)"
highfa`lutin	Suffix	"AJ(highfa`lutin ,)"
high`handed	Suffix	"AJ(`hand ,denom)"
hi`larious	Suffix	"AJ(hi`larious ,)"
`hind	Suffix	"AJ(`hind ,)"
`hinder	Suffix	"AJ(`hinder ,)"
hir`sute	Suffix	"AJ(hir`sute ,)"
his`toric	IC_Suffix	"AJ(`history ,denom)"
histri`onic	IC_Suffix	"AJ(histri`onic ,)"
`hoarse	Suffix	"AJ(`hoarse ,)"
`hoary	Suffix	"AJ(`hoary ,)"
`holy	Suffix	"AJ(`holy ,)"
`homebound	Suffix	"AJ(`homebound ,)"
home`made	Suffix	"AJ(home`made ,)"
homeo`pathic	IC_Suffix	"AJ(homeo`pathic ,)"
`homesick	Suffix	"AJ(`homesick ,)"
homo`geneous	Suffix	"AJ(homo`geneous ,)"
`homy	Suffix	"AJ(`home ,denom)"
`honest	Suffix	"AJ(`honest ,)"
`honorary	Suffix	"AJ(`honor ,denom)"
hono`rific	IC_Suffix	"AJ(hono`rific ,)"
hori`zontal	Suffix	"AJ(hori`zontal ,)"
hor`rendous	Suffix	"AJ(hor`rendous ,)"
`horrible	Suffix	"AJ(`horrible ,)"
`horrid	Suffix	"AJ(`horrid ,)"
`horsy	Suffix	"AJ(`horse ,denom)"
hos`pitable	Suffix	"AJ(hos`pitable ,)"
`hostile	Suffix	"AJ(`hostile ,)"
`hot	Suffix	"AJ(`hot ,)"
hot`tempered	Suffix	"AJ(`temper ,denom)"
`huffy	Suffix	"AJ(`huffy ,)"
`huge	Suffix	"AJ(`huge ,)"
hu`mane	Suffix	"AJ(hu`mane ,)"
`humid	Suffix	"AJ(`humid ,)"
`hungry	Suffix	"AJ(`hunger ,denom)"
`husky	Suffix	"AJ(`husky ,)"
hy`draulic	IC_Suffix	"AJ(hy`draulic ,)"
`hydro	Suffix	"AJ(`hydro ,)"
hydro`electric	IC_Suffix	"AJ(hydro`electric ,)"
hydro`philic	IC_Suffix	"AJ(hydro`philic ,)"
hydro`phobic	IC_Suffix	"AJ(hydro`phobia ,denom)"
hyper`bolic	IC_Suffix	"AJ(hy`perbole ,denom)"
hyp`notic	IC_Suffix	"AJ(hyp`notic ,)"
hypo`active	Suffix	"AJ(hypo`active ,)"
hypo`dermic	IC_Suffix	"AJ(hypo`dermic ,)"
hypo`thetic	IC_Suffix	"AJ(hypo`thetic ,)"
hys`teric	IC_Suffix	"AJ(hys`teric ,)"
i`ambic	IC_Suffix	"AJ(i`ambic ,)"
`icy	Suffix	"AJ(`ice ,denom)"
i`dentical	Suffix	"AJ(i`dentical ,)"
idio`matic	IC_Suffix	"AJ(idio`matic ,)"
idiosyn`cratic	IC_Suffix	"AJ(idiosyn`cratic ,)"
i`dolatrous	Suffix	"AJ(`idol ,denom)"
`iffy	Suffix	"AJ(`iffy ,)"
`igneous	Suffix	"AJ(`igneous ,)"
ig`noble	Suffix	"AJ(ig`noble ,)"
`ignorant	Suffix	"AJ(`ignorant ,)"
il`licit	Suffix	"AJ(il`licit ,)"
il`lusionary	Suffix	"AJ(il`lusion ,denom)"
il`lusory	Suffix	"AJ(il`lusory ,)"
il`lustrious	Suffix	"AJ(il`lustrious ,)"
i`maginary	Suffix	"AJ(i`magine ,deverb)"
i`maginative	Suffix	"AJ(i`magine ,deverb)"
`imitable	Suffix	"AJ(`imitate ,deverb)"
im`maculate	Suffix	"AJ(im`maculate ,)"
`immanent	Suffix	"AJ(`immanent ,)"
im`mediate	Suffix	"AJ(im`mediate ,)"
imme`morial	Suffix	"AJ(imme`morial ,)"
im`mense	Suffix	"AJ(im`mense ,)"
`imminent	Suffix	"AJ(`imminent ,)"
im`mitigable	Suffix	"AJ(im`mitigable ,)"
im`mune	Suffix	"AJ(im`mune ,)"
im`passable	Suffix	"AJ(im`passable ,)"
im`peccable	Suffix	"AJ(im`peccable ,)"
im`perative	Suffix	"AJ(im`perative ,)"
im`perial	Suffix	"AJ(im`perial ,)"
im`perious	Suffix	"AJ(im`perious ,)"
im`petuous	Suffix	"AJ(im`petuous ,)"
im`plicit	Suffix	"AJ(im`plicit ,)"
im`plosive	Suffix	"AJ(im`plode ,deverb)"
im`portant	Suffix	"AJ(im`portant ,)"
im`portunate	Suffix	"AJ(im`portunate ,)"
im`pressionable	Suffix	"AJ(im`press ,deverb)"
im`promptu	Suffix	"AJ(im`promptu ,)"
`impudent	Suffix	"AJ(`impudent ,)"
in`ane	Suffix	"AJ(in`ane ,)"
in`augural	Suffix	"AJ(in`augural ,)"
`inboard	Suffix	"AJ(`inboard ,)"
`inborn	Suffix	"AJ(`inborn ,)"
in`cendiary	Suffix	"AJ(in`cendiary ,)"
in`cessant	Suffix	"AJ(in`cessant ,)"
in`cestuous	Suffix	"AJ(`incest ,denom)"
in`cipient	Suffix	"AJ(in`cipient ,)"
in`cisive	Suffix	"AJ(in`cisive ,)"
in`clusive	Suffix	"AJ(in`clude ,deverb)"
incommunicado	Suffix	"AJ(incommunicado ,)"
in`corporable	Suffix	"AJ(in`corporate ,deverb)"
in`debted	Suffix	"AJ(`debt ,denom)"
inde`fatigable	Suffix	"AJ(fa`tigue ,denom)"
in`delible	Suffix	"AJ(in`delible ,)"
`indigent	Suffix	"AJ(`indigent ,)"
in`dignant	Suffix	"AJ(in`dignant ,)"
`indolent	Suffix	"AJ(`indolent ,)"
in`domitable	Suffix	"AJ(in`domitable ,)"
in`door	Suffix	"AJ(in`door ,)"
ine`luctable	Suffix	"AJ(ine`luctable ,)"
in`ept	Suffix	"AJ(in`ept ,)"
in`ert	Suffix	"AJ(in`ert ,)"
in`ertial	Suffix	"AJ(in`ertia ,denom)"
in`exorable	Suffix	"AJ(in`exorable ,)"
`infamous	Suffix	"AJ(`infamous ,)"
`infantile	Suffix	"AJ(`infant ,denom)"
in`fectious	Suffix	"AJ(in`fect ,deverb)"
in`ferable	Suffix	"AJ(in`fer ,deverb)"
infe`rential	Suffix	"AJ(in`fer ,deverb)"
in`fernal	Suffix	"AJ(in`fernal ,)"
infini`tesimal	Suffix	"AJ(infini`tesimal ,)"
in`firm	Suffix	"AJ(in`firm ,)"
in`flammable	Suffix	"AJ(in`flame ,deverb)"
in`flammatory	Suffix	"AJ(in`flame ,deverb)"
in`flationary	Suffix	"AJ(in`flate ,deverb)"
influ`ential	Suffix	"AJ(in`fluence ,deverb)"
infra`red	Suffix	"AJ(infra`red ,)"
in`genious	Suffix	"AJ(in`genious ,)"
in`genuous	Suffix	"AJ(in`genuous ,)"
in`grown	Suffix	"AJ(in`grown ,)"
in`holding	Suffix	"AJ(in`holding ,)"
in`junctive	Suffix	"AJ(in`junctive ,)"
i`nimical	Suffix	"AJ(i`nimical ,)"
in`iquitous	Suffix	"AJ(i`niquity ,denom)"
in`itial	Suffix	"AJ(in`itial ,)"
`inlaid	Suffix	"AJ(`inlaid ,)"
`inland	Suffix	"AJ(`inland ,)"
`inmost	Suffix	"AJ(`inmost ,)"
in`nate	Suffix	"AJ(in`nate ,)"
`inner	Suffix	"AJ(`inner ,)"
in`nocuous	Suffix	"AJ(in`nocuous ,)"
in`quisitive	Suffix	"AJ(in`quire ,deverb)"
in`ordinate	Suffix	"AJ(in`ordinate ,)"
in`scrutable	Suffix	"AJ(in`scrutable ,)"
in`shore	Suffix	"AJ(in`shore ,)"
in`side	Suffix	"AJ(in`side ,)"
in`sidious	Suffix	"AJ(in`sidious ,)"
in`sipid	Suffix	"AJ(in`sipid ,)"
`insolent	Suffix	"AJ(`insolent ,)"
in`souciant	Suffix	"AJ(in`souciant ,)"
instan`taneous	Suffix	"AJ(instan`taneous ,)"
in`stinctive	Suffix	"AJ(`instinct ,denom)"
`insular	Suffix	"AJ(`insular ,)"
in`superable	Suffix	"AJ(in`superable ,)"
in`tact	Suffix	"AJ(in`tact ,)"
`integrable	Suffix	"AJ(`integrate ,deverb)"
`integral	Suffix	"AJ(`integral ,)"
in`telligent	Suffix	"AJ(in`telligent ,)"
in`telligible	Suffix	"AJ(in`telligible ,)"
in`tense	Suffix	"AJ(in`tense ,)"
in`tensive	Suffix	"AJ(in`tense ,)"
in`tent	Suffix	"AJ(in`tent ,)"
in`terior	Suffix	"AJ(in`terior ,)"
in`ternal	Suffix	"AJ(in`ternal ,)"
inter`mediate	Suffix	"AJ(inter`mediate ,)"
inter`necine	Suffix	"AJ(inter`necine ,)"
in`terpolatory	Suffix	"AJ(in`terpolatory ,)"
inter`rogatory	Suffix	"AJ(inter`rogatory ,)"
inter`stitial	Suffix	"AJ(`interstice ,denom)"
in`testate	Suffix	"AJ(in`testate ,)"
`intimate	Suffix	"AJ(`intimate ,)"
in`trepid	Suffix	"AJ(in`trepid ,)"
in`transigent	Suffix	"AJ(in`transigent ,)"
`intricate	Suffix	"AJ(`intricate ,)"
in`trinsic	IC_Suffix	"AJ(in`trinsic ,)"
intro`ductory	Suffix	"AJ(intro`duce ,deverb)"
in`trusive	Suffix	"AJ(in`trude ,deverb)"
in`variant	Suffix	"AJ(in`variant ,)"
in`vasive	Suffix	"AJ(in`vade ,deverb)"
in`verse	Suffix	"AJ(in`verse ,)"
in`veterate	Suffix	"AJ(in`veterate ,)"
in`vidious	Suffix	"AJ(in`vidious ,)"
in`violate	Suffix	"AJ(in`violate ,)"
`involute	Suffix	"AJ(`involute ,)"
i`rascible	Suffix	"AJ(i`rascible ,)"
i`rate	Suffix	"AJ(i`rate ,)"
`irksome	Suffix	"AJ(`irk ,deverb)"
i`ronic	Suffix	"AJ(`irony ,denom)"
`irritable	Suffix	"AJ(`irritate ,deverb)"
`issuant	Suffix	"AJ(`issue ,deverb)"
i`talic	IC_Suffix	"AJ(i`talic ,)"
i`tinerant	Suffix	"AJ(i`tinerate ,deverb)"
`jaunty	Suffix	"AJ(`jaunty ,)"
`jealous	Suffix	"AJ(`jealous ,)"
je`june	Suffix	"AJ(je`june ,)"
`jerky	Suffix	"AJ(`jerk ,deverb)"
jo`cose	Suffix	"AJ(jo`cose ,)"
`jocular	Suffix	"AJ(`jocular ,)"
`jocund	Suffix	"AJ(`jocund ,)"
`jolly	Suffix	"AJ(`jolly ,)"
`jovial	Suffix	"AJ(`jovial ,)"
`jubilant	Suffix	"AJ(`jubilant ,)"
judg`matic	IC_Suffix	"AJ(judg`matic ,)"
ju`dicial	Suffix	"AJ(ju`dicial ,)"
ju`dicious	Suffix	"AJ(ju`dicious ,)"
`jugate	Suffix	"AJ(`jugate ,)"
`juicy	Suffix	"AJ(`juice ,denom)"
`jumbo	Suffix	"AJ(`jumbo ,)"
`junior	Suffix	"AJ(`junior ,)"
ju`ridical	Suffix	"AJ(ju`ridical ,)"
jurispru`dential	Suffix	"AJ(juris`prudence ,denom)"
`just	Suffix	"AJ(`just ,)"
jus`ticiable	Suffix	"AJ(jus`ticiable ,)"
`keen	Suffix	"AJ(`keen ,)"
`kind	Suffix	"AJ(`kind ,)"
kind`hearted	Suffix	"AJ(`heart ,denom)"
`kindly	Suffix	"AJ(`kind ,)"
ki`netic	IC_Suffix	"AJ(ki`netic ,)"
`knockdown	Suffix	"AJ(`knockdown ,)"
`knowledgeable	Suffix	"AJ(`knowledge ,denom)"
`kosher	Suffix	"AJ(`kosher ,)"
`labile	Suffix	"AJ(`labile ,)"
la`borious	Suffix	"AJ(`labor ,denom)"
laby`rinthine	Suffix	"AJ(`labyrinth ,denom)"
laby`rinthian	Suffix	"AJ(`labyrinth ,denom)"
lacka`daisic	IC_Suffix	"AJ(lacka`daisic ,)"
`lackluster	Suffix	"AJ(`lackluster ,)"
la`conic	IC_Suffix	"AJ(la`conic ,)"
`laden	Suffix	"AJ(`lade ,deverb)"
`lame	Suffix	"AJ(`lame ,)"
`languid	Suffix	"AJ(`languid ,)"
`lank	Suffix	"AJ(`lank ,)"
`lanky	Suffix	"AJ(`lanky ,)"
`large	Suffix	"AJ(`large ,)"
`larval	Suffix	"AJ(`larva ,denom)"
la`ryngeal	Suffix	"AJ(`larynx ,denom)"
las`civious	Suffix	"AJ(las`civious ,)"
`latent	Suffix	"AJ(`latent ,)"
`lateral	Suffix	"AJ(`lateral ,)"
`latinate	Suffix	"AJ(`latin ,denom)"
latitudinal	Suffix	"AJ(`latitude ,denom)"
lati`tudinary	Suffix	"AJ(`latitude ,denom)"
`latter	Suffix	"AJ(`latter ,)"
`laudatory	Suffix	"AJ(`laud ,deverb)"
`lax	Suffix	"AJ(`lax ,)"
`lazy	Suffix	"AJ(`lazy ,)"
`leaden	Suffix	"AJ(`lead ,denom)"
`lean	Suffix	"AJ(`lean ,)"
`leathern	Suffix	"AJ(`leathern ,)"
`leery	Suffix	"AJ(`leery ,)"
`lefthand	Suffix	"AJ(`lefthand ,)"
`left-hand	Suffix	"AJ(`left-hand ,)"
left`handed	Suffix	"AJ(`hand ,denom)"
`leisurely	Suffix	"AJ(`leisure ,denom)"
`legal	Suffix	"AJ(`legal ,)"
le`gato	Suffix	"AJ(le`gato ,)"
`legendary	Suffix	"AJ(`legend ,denom)"
`legible	Suffix	"AJ(`legible ,)"
le`gitimate	Suffix	"AJ(le`gitimate ,)"
le`guminous	Suffix	"AJ(le`gume ,denom)"
`lenient	Suffix	"AJ(`lenient ,)"
len`ticular	Suffix	"AJ(len`ticular ,)"
`leonine	Suffix	"AJ(`lion ,denom)"
`lethal	Suffix	"AJ(`lethal ,)"
le`thargic	IC_Suffix	"AJ(`lethargy ,denom)"
`lewd	Suffix	"AJ(`lewd ,)"
`lexical	Suffix	"AJ(`lexical ,)"
`liable	Suffix	"AJ(`liable ,)"
li`bidinous	Suffix	"AJ(li`bido ,denom)"
li`centious	Suffix	"AJ(li`centious ,)"
`lifelong	Suffix	"AJ(`lifelong ,)"
`light	Suffix	"AJ(`light - not heavy/dark,)"
light`hearted	Suffix	"AJ(`heart ,denom)"
`lightproof	Suffix	"AJ(`lightproof ,)"
`lightweight	Suffix	"AJ(`lightweight ,)"
`like	Suffix	"AJ(`like ,)"
`likely	Suffix	"AJ(`likely ,)"
`limbic	IC_Suffix	"AJ(`limbic ,)"
`limp	Suffix	"AJ(`limp ,)"
`limpid	Suffix	"AJ(`limpid ,)"
`lineal	Suffix	"AJ(`lineal ,)"
`linear	Suffix	"AJ(`linear ,)"
`lingual	Suffix	"AJ(`lingual ,)"
`lite	Suffix	"AJ(`lite ,)"
`literal	Suffix	"AJ(`literal ,)"
`literary	Suffix	"AJ(`literary ,)"
`literate	Suffix	"AJ(`literate ,)"
`lithe	Suffix	"AJ(`lithe ,)"
`litigious	Suffix	"AJ(`litigious ,)"
`little	Suffix	"AJ(`little ,)"
li`turgic	IC_Suffix	"AJ(li`turgic ,)"
`live	Suffix	"AJ(`live ,)"
`livelong	Suffix	"AJ(`livelong ,)"
`lively	Suffix	"AJ(`live ,)"
`livid	Suffix	"AJ(`livid ,)"
`loath	Suffix	"AJ(`loath ,)"
`loathsome	Suffix	"AJ(`loath ,deverb)"
loco`motive	Suffix	"AJ(loco`motive ,)"
`lofty	Suffix	"AJ(`lofty ,)"
lo`gistic	IC_Suffix	"AJ(lo`gistic ,)"
`lone	Suffix	"AJ(`lone ,)"
`lonely	Suffix	"AJ(`lonely ,)"
`lonesome	Suffix	"AJ(`lonesome ,)"
`long	Suffix	"AJ(`long ,)"
longi`tudinal	Suffix	"AJ(`longitude ,denom)"
long`standing	Suffix	"AJ(long`standing ,)"
long`suffering	Suffix	"AJ(long`suffering ,)"
`longtime	Suffix	"AJ(`longtime ,)"
`loose-leaf	Suffix	"AJ(`loose-leaf ,)"
lop`sided	Suffix	"AJ(`side ,denom)"
lo`quacious	Suffix	"AJ(lo`quacious ,)"
`lousy	Suffix	"AJ(`louse ,denom)"
`lovelorn	Suffix	"AJ(`lovelorn ,)"
`low	Suffix	"AJ(`low ,)"
`lowercase	Suffix	"AJ(`lowercase ,)"
`lowering	Suffix	"AJ(`lowering ,)"
`lowermost	Suffix	"AJ(`low ,)"
`lowly	Suffix	"AJ(`low ,)"
`loyal	Suffix	"AJ(`loyal ,)"
lu`bricious	Suffix	"AJ(lu`bricious ,)"
`lucid	Suffix	"AJ(`lucid ,)"
`lucrative	Suffix	"AJ(`lucrative ,)"
`ludicrous	Suffix	"AJ(`ludicrous ,)"
lu`gubrious	Suffix	"AJ(lu`gubrious ,)"
luke`warm	Suffix	"AJ(luke`warm ,)"
`lumbar	Suffix	"AJ(`lumbar ,)"
lumi`nescent	Suffix	"AJ(lumi`nescent ,)"
`luminous	Suffix	"AJ(`luminous ,)"
`lunar	Suffix	"AJ(`lunar ,)"
`lupine	Suffix	"AJ(`lupine ,)"
`lurid	Suffix	"AJ(`lurid ,)"
`luscious	Suffix	"AJ(`luscious ,)"
`lush	Suffix	"AJ(`lush ,)"
`lustrous	Suffix	"AJ(`luster ,denom)"
lux`uriant	Suffix	"AJ(`luxury ,denom)"
`lyric	IC_Suffix	"AJ(`lyric ,)"
ma`cabre	Suffix	"AJ(ma`cabre ,)"
`macho	Suffix	"AJ(`macho ,)"
`mad	Suffix	"AJ(`mad ,)"
`madcap	Suffix	"AJ(`madcap ,)"
magis`terial	Suffix	"AJ(magis`terial ,)"
mag`nanimous	Suffix	"AJ(mag`nanimous ,)"
mag`nificent	Suffix	"AJ(mag`nificent ,)"
mag`niloquent	Suffix	"AJ(mag`niloquent ,)"
`main	Suffix	"AJ(`main ,)"
ma`jestic	IC_Suffix	"AJ(`majesty ,denom)"
`makeshift	Suffix	"AJ(`makeshift ,)"
mala`daptive	Suffix	"AJ(a`dapt ,deverb)"
mala`droit	Suffix	"AJ(a`droit ,)"
ma`larial	Suffix	"AJ(ma`laria ,denom)"
ma`levolent	Suffix	"AJ(ma`levolent ,)"
mal`formed	Suffix	"AJ(`form ,denom)"
ma`licious	Suffix	"AJ(`malice ,denom)"
ma`lignant	Suffix	"AJ(ma`lignant ,)"
`malleable	Suffix	"AJ(`malleable ,)"
`mammoth	Suffix	"AJ(`mammoth ,)"
`mandatory	Suffix	"AJ(`mandatory ,)"
`mangy	Suffix	"AJ(`mange ,denom)"
`manic	IC_Suffix	"AJ(`manic ,)"
`manifold	Suffix	"AJ(`manifold ,)"
ma`nipulable	Suffix	"AJ(ma`nipulate ,deverb)"
`mantic	IC_Suffix	"AJ(`mantic ,)"
`manual	Suffix	"AJ(`manual ,)"
ma`rine	Suffix	"AJ(ma`rine ,)"
`marital	Suffix	"AJ(`marital ,)"
`maritime	Suffix	"AJ(`maritime ,)"
`marriageable	Suffix	"AJ(`marriage ,denom)"
`martial	Suffix	"AJ(`martial ,)"
`masculine	Suffix	"AJ(`masculine ,)"
`massive	Suffix	"AJ(`massive ,)"
ma`ternal	Suffix	"AJ(ma`ternal ,)"
matri`lineal	Suffix	"AJ(matri`lineal ,)"
mathe`matic	IC_Suffix	"AJ(mathe`matic ,)"
`maudlin	Suffix	"AJ(`maudlin ,)"
`mawkish	Suffix	"AJ(`mawkish ,)"
`maximal	Suffix	"AJ(`maximal ,)"
`meager	Suffix	"AJ(`meager ,)"
`meagre	Suffix	"AJ(`meagre - British,)"
`mealy	Suffix	"AJ(`mealy ,)"
`mean	Suffix	"AJ(`mean ,)"
`meaningful	Suffix	"AJ(`mean ,deverb)"
`measly	Suffix	"AJ(`measly ,)"
`meddlesome	Suffix	"AJ(`meddle ,deverb)"
medi`ocre	Suffix	"AJ(medi`ocre ,)"
`medium	Suffix	"AJ(`medium ,)"
me`diaeval	Suffix	"AJ(me`diaeval ,)"
me`dieval	Suffix	"AJ(me`dieval ,)"
`meek	Suffix	"AJ(`meek ,)"
me`lodic	IC_Suffix	"AJ(`melody ,denom)"
melodra`matic	IC_Suffix	"AJ(melodra`matic ,)"
`memorable	Suffix	"AJ(`memorable ,)"
men`dacious	Suffix	"AJ(men`dacious ,)"
`menial	Suffix	"AJ(`menial ,)"
`mensurable	Suffix	"AJ(`mensurable ,)"
`menstrual	Suffix	"AJ(`menstrual ,)"
`mental	Suffix	"AJ(`mental ,)"
`mercantile	Suffix	"AJ(`mercantile ,)"
mer`curic	IC_Suffix	"AJ(mer`curic ,)"
`mere	Suffix	"AJ(`mere ,)"
mere`tricious	Suffix	"AJ(mere`tricious ,)"
me`ridional	Suffix	"AJ(me`ridional ,)"
meri`torious	Suffix	"AJ(`merit ,deverb)"
`merry	Suffix	"AJ(`merry ,)"
`mesmeric	IC_Suffix	"AJ(`mesmeric ,)"
meta`bolic	IC_Suffix	"AJ(meta`bolic ,)"
meta`morphic	IC_Suffix	"AJ(meta`morphic ,)"
me`ticulous	Suffix	"AJ(me`ticulous ,)"
`metro	Suffix	"AJ(`metro ,)"
metro`politan	Suffix	"AJ(metro`politan ,)"
`mettlesome	Suffix	"AJ(`mettle ,denom)"
`mezzo	Suffix	"AJ(`mezzo ,)"
mi`asmal	Suffix	"AJ(mi`asma ,denom)"
`micro	Suffix	"AJ(`micro ,)"
`mid	Suffix	"AJ(`mid ,)"
`mild	Suffix	"AJ(`mild ,)"
mili`tarily	Suffix	"AJ(`military ,denom)"
mil`lennial	Suffix	"AJ(mil`lennium ,denom)"
mi`metic	IC_Suffix	"AJ(mi`metic ,)"
`minatory	Suffix	"AJ(`minatory ,)"
`mini	Suffix	"AJ(`mini ,)"
`minimal	Suffix	"AJ(`minimal ,)"
`minuscule	Suffix	"AJ(`minuscule ,)"
mi`nute	Suffix	"AJ(mi`nute ,)"
mi`raculous	Suffix	"AJ(`miracle ,denom)"
miscel`laneous	Suffix	"AJ(`miscellany ,denom)"
mis`chievous	Suffix	"AJ(`mischief ,denom)"
`miscible	Suffix	"AJ(`miscible ,)"
`miserable	Suffix	"AJ(`misery ,denom)"
mis`shapen	Suffix	"AJ(`shape ,deverb)"
mne`monic	IC_Suffix	"AJ(mne`monic ,)"
`mobile	Suffix	"AJ(`mobile ,)"
`modest	Suffix	"AJ(`modest ,)"
`modish	Suffix	"AJ(`modish ,)"
`modular	Suffix	"AJ(`module ,denom)"
`moist	Suffix	"AJ(`moist ,)"
`molal	Suffix	"AJ(`molal ,)"
`molar	Suffix	"AJ(`molar ,)"
mo`lecular	Suffix	"AJ(`molecule ,denom)"
`molten	Suffix	"AJ(`melt ,deverb)"
`momentary	Suffix	"AJ(`moment ,denom)"
mo`mentous	Suffix	"AJ(mo`mentous ,)"
mo`nastic	IC_Suffix	"AJ(mo`nastic ,)"
mon`aural	Suffix	"AJ(mon`aural ,)"
mone`tarily	Suffix	"AJ(`monetary ,)"
`monied	Suffix	"AJ(`money ,denom)"
`monitory	Suffix	"AJ(`monitory ,)"
mo`nocular	Suffix	"AJ(mo`nocular ,)"
mo`notonous	Suffix	"AJ(`monotone ,denom)"
`monstrous	Suffix	"AJ(`monster ,denom)"
`moonlit	Suffix	"AJ(`moonlit ,)"
`moot	Suffix	"AJ(`moot ,)"
`morbid	Suffix	"AJ(`morbid ,)"
`moribund	Suffix	"AJ(`moribund ,)"
mo`rose	Suffix	"AJ(mo`rose ,)"
morpho`tactic	IC_Suffix	"AJ(morpho`tactic ,)"
`motley	Suffix	"AJ(`motley ,)"
`mournful	Suffix	"AJ(`mourn ,deverb)"
`mousy	Suffix	"AJ(`mouse ,denom)"
muddle`headed	Suffix	"AJ(`head ,denom)"
`muggy	Suffix	"AJ(`muggy ,)"
multi`farious	Suffix	"AJ(multi`farious ,)"
multi`tudinous	Suffix	"AJ(`multitude ,denom)"
`mum	Suffix	"AJ(`mum ,)"
mun`dane	Suffix	"AJ(mun`dane ,)"
mu`nicipal	Suffix	"AJ(mu`nicipal ,)"
mu`nificent	Suffix	"AJ(mu`nificent ,)"
`muscular	Suffix	"AJ(`muscle ,denom)"
`musty	Suffix	"AJ(`musty ,)"
`mutable	Suffix	"AJ(`mutable ,)"
`mutant	Suffix	"AJ(`mutate ,deverb)"
`mute	Suffix	"AJ(`mute ,)"
`muted	Suffix	"AJ(`muted ,)"
`mutinous	Suffix	"AJ(`mutiny ,denom)"
`mutual	Suffix	"AJ(`mutual ,)"
my`opic	IC_Suffix	"AJ(my`opia ,denom)"
`mystic	IC_Suffix	"AJ(`mystic ,)"
na`ive	Suffix	"AJ(na`ive ,)"
`naked	Suffix	"AJ(`naked ,)"
namby-`pamby	Suffix	"AJ(namby-`pamby ,)"
`nary	Suffix	"AJ(`nary ,)"
`nascent	Suffix	"AJ(`nascent ,)"
`nasty	Suffix	"AJ(`nasty ,)"
`natal	Suffix	"AJ(`natal ,)"
`nationwide	Suffix	"AJ(`nationwide ,)"
`natty	Suffix	"AJ(`natty ,)"
`natural	Suffix	"AJ(`natural ,)"
`naughty	Suffix	"AJ(`naughty ,)"
`nauseous	Suffix	"AJ(`nausea ,denom)"
`nautical	Suffix	"AJ(`nautical ,)"
`naval	Suffix	"AJ(`naval ,)"
`navigable	Suffix	"AJ(`navigate ,deverb)"
`neap	Suffix	"AJ(`neap ,)"
near`by	Suffix	"AJ(near`by ,)"
`nearsighted	Suffix	"AJ(`sight ,denom)"
`neat	Suffix	"AJ(`neat ,)"
`nebular	Suffix	"AJ(`nebula ,denom)"
`nebulous	Suffix	"AJ(`nebulous ,)"
`necessary	Suffix	"AJ(`necessary ,)"
necro`mantic	IC_Suffix	"AJ(necro`mantic ,)"
ne`crotic	IC_Suffix	"AJ(ne`crotic ,)"
`nee	Suffix	"AJ(`nee ,)"
`negligent	Suffix	"AJ(`negligent ,)"
`negligible	Suffix	"AJ(`negligible ,)"
ne`gotiable	Suffix	"AJ(ne`gotiate ,deverb)"
`nervy	Suffix	"AJ(`nerve ,denom)"
`nether	Suffix	"AJ(`nether ,)"
`nettlesome	Suffix	"AJ(`nettle ,denom)"
`neural	Suffix	"AJ(`neural ,)"
neurolin`guistic	IC_Suffix	"AJ(neurolin`guistic ,)"
neu`rotic	IC_Suffix	"AJ(neu`rotic ,)"
`neuter	Suffix	"AJ(`neuter ,)"
`neutral	Suffix	"AJ(`neutral ,)"
`new	Suffix	"AJ(`new ,)"
new`fangled	Suffix	"AJ(new`fangled ,)"
new`found	Suffix	"AJ(new`found ,)"
`nifty	Suffix	"AJ(`nifty ,)"
`nimble	Suffix	"AJ(`nimble ,)"
noc`turnal	Suffix	"AJ(noc`turnal ,)"
`nodular	Suffix	"AJ(`nodule ,denom)"
`noisome	Suffix	"AJ(`noisome ,)"
`noisy	Suffix	"AJ(`noise ,denom)"
noncha`lant	Suffix	"AJ(noncha`lant ,)"
`normative	Suffix	"AJ(`norm ,denom)"
`northbound	Suffix	"AJ(`northbound ,)"
north`eastern	Suffix	"AJ(north`eastern ,)"
`northern	Suffix	"AJ(`northern ,)"
north`western	Suffix	"AJ(north`western ,)"
nos`talgic	IC_Suffix	"AJ(nos`talgia ,denom)"
`nosy	Suffix	"AJ(`nose ,denom)"
no`torious	Suffix	"AJ(no`torious ,)"
nou`veau	Suffix	"AJ(nou`veau ,)"
`novel	Suffix	"AJ(`novel ,)"
`noxious	Suffix	"AJ(`noxious ,)"
`nubile	Suffix	"AJ(`nubile ,)"
`nuclear	Suffix	"AJ(`nuclear ,)"
`nude	Suffix	"AJ(`nude ,)"
`nugatory	Suffix	"AJ(`nugatory ,)"
`numerable	Suffix	"AJ(`numerate ,deverb)"
nu`meric	IC_Suffix	"AJ(`numeral ,denom)"
`numerous	Suffix	"AJ(`numerous ,)"
`numinous	Suffix	"AJ(`numinous ,)"
numis`matic	IC_Suffix	"AJ(numis`matic ,)"
nu`tritious	Suffix	"AJ(nu`tritious ,)"
`oaken	Suffix	"AJ(`oak ,denom)"
`obdurate	Suffix	"AJ(`obdurate ,)"
o`bedient	Suffix	"AJ(o`bey ,deverb)"
o`beisant	Suffix	"AJ(o`beisant ,)"
o`bese	Suffix	"AJ(o`bese ,)"
ob`jective	Suffix	"AJ(ob`jective ,)"
ob`jectionable	Suffix	"AJ(ob`ject ,deverb)"
ob`lique	Suffix	"AJ(ob`lique ,)"
ob`livious	Suffix	"AJ(ob`livious ,)"
`oblong	Suffix	"AJ(`oblong ,)"
ob`noxious	Suffix	"AJ(ob`noxious ,)"
ob`scene	Suffix	"AJ(ob`scene ,)"
ob`sequious	Suffix	"AJ(ob`sequious ,)"
ob`servant	Suffix	"AJ(ob`serve ,deverb)"
obso`lescent	Suffix	"AJ(obso`lescent ,)"
obso`lete	Suffix	"AJ(obso`lete ,)"
ob`stetric	IC_Suffix	"AJ(ob`stetric ,)"
`obstinate	Suffix	"AJ(`obstinate ,)"
ob`streperous	Suffix	"AJ(ob`streperous ,)"
ob`trusive	Suffix	"AJ(ob`trude ,deverb)"
ob`tuse	Suffix	"AJ(ob`tuse ,)"
`obverse	Suffix	"AJ(`obverse ,)"
`obvious	Suffix	"AJ(`obvious ,)"
octa`hedral	Suffix	"AJ(octa`hedron ,denom)"
`octal	Suffix	"AJ(`octal ,)"
oc`tennial	Suffix	"AJ(oc`tennial ,)"
`ocular	Suffix	"AJ(`ocular ,)"
`odd	Suffix	"AJ(`odd ,)"
`odious	Suffix	"AJ(`odious ,)"
odor`iferous	Suffix	"AJ(`odor ,denom)"
off`beat	Suffix	"AJ(off`beat ,)"
of`fensive	Suffix	"AJ(of`fend ,deverb)"
off`hand	Suffix	"AJ(off`hand ,)"
of`ficious	Suffix	"AJ(of`ficious ,)"
off`shore	Suffix	"AJ(off`shore ,)"
off`stage	Suffix	"AJ(off`stage ,)"
`old	Suffix	"AJ(`old ,)"
`olden	Suffix	"AJ(`olden ,)"
ol`factory	Suffix	"AJ(ol`factory ,)"
o`lympic	IC_Suffix	"AJ(o`lympic ,)"
`ominous	Suffix	"AJ(`ominous ,)"
om`nipotent	Suffix	"AJ(om`nipotent ,)"
`omnipresent	Suffix	"AJ(`omnipresent ,)"
om`niscient	Suffix	"AJ(om`niscient ,)"
`oncoming	Suffix	"AJ(`oncoming ,)"
`onerous	Suffix	"AJ(`onerous ,)"
`onetime	Suffix	"AJ(`onetime ,)"
`ongoing	Suffix	"AJ(`ongoing ,)"
onomato`poeic	IC_Suffix	"AJ(onomato`poeia ,denom)"
onomatopo`etic	IC_Suffix	"AJ(onomato`poeia ,denom)"
`onrushing	Suffix	"AJ(`onrushing ,)"
`oozy	Suffix	"AJ(`ooze ,denom)"
opa`lescent	Suffix	"AJ(opa`lescent ,)"
o`paque	Suffix	"AJ(o`paque ,)"
`operable	Suffix	"AJ(`operate ,deverb)"
`operant	Suffix	"AJ(`operant ,)"
oper`atic	IC_Suffix	"AJ(`opera ,denom)"
o`pinionated	Suffix	"AJ(o`pinion ,denom)"
oppor`tune	Suffix	"AJ(oppor`tune ,)"
op`probrious	Suffix	"AJ(op`probrious ,)"
`optic	IC_Suffix	"AJ(`optic ,)"
`optimal	Suffix	"AJ(`optimum ,denom)"
`opulent	Suffix	"AJ(`opulent ,)"
o`racular	Suffix	"AJ(`oracle ,denom)"
`oral	Suffix	"AJ(`oral ,)"
`orangy	Suffix	"AJ(`orange ,denom)"
ora`torical	Suffix	"AJ(`oratory ,denom)"
or`chestral	Suffix	"AJ(`orchestra ,denom)"
`ordinary	Suffix	"AJ(`ordinary ,)"
orgi`astic	IC_Suffix	"AJ(`orgy ,denom)"
or`nate	Suffix	"AJ(or`nate ,)"
`ornery	Suffix	"AJ(`ornery ,)"
ortho`dontic	IC_Suffix	"AJ(ortho`dontic ,)"
`orthodox	Suffix	"AJ(`orthodox ,)"
or`thogonal	Suffix	"AJ(or`thogonal ,)"
ortho`paedic	IC_Suffix	"AJ(ortho`paedic ,)"
ortho`pedic	IC_Suffix	"AJ(ortho`pedic ,)"
os`motic	IC_Suffix	"AJ(os`mosis ,denom)"
`osseous	Suffix	"AJ(`osseous ,)"
os`tensible	Suffix	"AJ(os`tensible ,)"
osten`tatious	Suffix	"AJ(osten`tatious ,)"
`outer	Suffix	"AJ(`outer ,)"
out`door	Suffix	"AJ(out`door ,)"
out`landish	Suffix	"AJ(out`landish ,)"
out`moded	Suffix	"AJ(`mode ,denom)"
`ovate	Suffix	"AJ(`ovate ,)"
o`vert	Suffix	"AJ(o`vert ,)"
pa`cific	IC_Suffix	"AJ(pa`cific ,)"
`painstaking	Suffix	"AJ(`painstaking ,)"
`palatable	Suffix	"AJ(`palate ,denom)"
paleo`lithic	IC_Suffix	"AJ(paleo`lithic ,)"
paleo`zoic	IC_Suffix	"AJ(paleo`zoic ,)"
`pallid	Suffix	"AJ(`pallid ,)"
`palpable	Suffix	"AJ(`palpable ,)"
`paltry	Suffix	"AJ(`paltry ,)"
pancre`atic	IC_Suffix	"AJ(pancre`atic ,)"
pan`demic	IC_Suffix	"AJ(pan`demic ,)"
`panicky	Suffix	"AJ(`panic ,denom)"
pano`ramic	IC_Suffix	"AJ(pano`rama ,denom)"
`paperbound	Suffix	"AJ(`paperbound ,)"
`papillary	Suffix	"AJ(`papillary ,)"
para`bolic	IC_Suffix	"AJ(pa`rabola ,denom)"
paradig`matic	IC_Suffix	"AJ(`paradigm ,denom)"
para`lytic	IC_Suffix	"AJ(para`lytic ,)"
`paramount	Suffix	"AJ(`paramount ,)"
para`noiac	Suffix	"AJ(para`noiac ,)"
para`plegic	IC_Suffix	"AJ(para`plegic ,)"
paren`thetic	IC_Suffix	"AJ(paren`thetic ,)"
parlia`mentary	Suffix	"AJ(`parliament ,denom)"
pa`rochial	Suffix	"AJ(`parish ,denom)"
par`ticular	Suffix	"AJ(par`ticular ,)"
par`ticulate	Suffix	"AJ(par`ticulate ,)"
`partitive	Suffix	"AJ(`partitive ,)"
`passionate	Suffix	"AJ(`passion ,denom)"
pas`se	Suffix	"AJ(pas`se ,)"
`pasty	Suffix	"AJ(`paste ,denom)"
pa`ternal	Suffix	"AJ(pa`ternal ,)"
patri`lineal	Suffix	"AJ(patri`lineal ,)"
pa`thetic	IC_Suffix	"AJ(pa`thetic ,)"
`patient	Suffix	"AJ(`patient ,)"
pa`tristic	IC_Suffix	"AJ(pa`tristic ,)"
`peaceable	Suffix	"AJ(`peace ,denom)"
`pebbly	Suffix	"AJ(`pebble ,denom)"
pec`toral	Suffix	"AJ(pec`toral ,)"
pe`culiar	Suffix	"AJ(pe`culiar ,)"
pe`cuniary	Suffix	"AJ(pe`cuniary ,)"
pedi`atric	IC_Suffix	"AJ(pedi`atric ,)"
pe`jorative	Suffix	"AJ(pe`jorative ,)"
pe`lagic	IC_Suffix	"AJ(pe`lagic ,)"
`pelvic	IC_Suffix	"AJ(`pelvis ,denom)"
`penal	Suffix	"AJ(`penal ,)"
`pendulous	Suffix	"AJ(`pendulous ,)"
`penetrable	Suffix	"AJ(`penetrate ,deverb)"
`penile	Suffix	"AJ(`penis ,denom)"
peni`tential	Suffix	"AJ(`penitent ,denom)"
`pensive	Suffix	"AJ(`pensive ,)"
`pent	Suffix	"AJ(`pent ,)"
pe`nultimate	Suffix	"AJ(pe`nultima ,denom)"
per`ceptible	Suffix	"AJ(per`ceive ,deverb)"
per`ceptive	Suffix	"AJ(per`ceive ,deverb)"
per`cipient	Suffix	"AJ(per`cipient ,)"
pe`remptory	Suffix	"AJ(pe`remptory ,)"
per`functory	Suffix	"AJ(per`functory ,)"
peripa`tetic	IC_Suffix	"AJ(peripa`tetic ,)"
peri`phrastic	IC_Suffix	"AJ(peri`phrasis ,denom)"
`perky	Suffix	"AJ(`perky ,)"
`permanent	Suffix	"AJ(`permanent ,)"
`permeable	Suffix	"AJ(`permeate ,deverb)"
per`missible	Suffix	"AJ(per`mit ,deverb)"
per`missive	Suffix	"AJ(per`mit ,deverb)"
per`nicious	Suffix	"AJ(per`nicious ,)"
per`petual	Suffix	"AJ(per`petual ,)"
`personable	Suffix	"AJ(`person ,denom)"
perspi`cacious	Suffix	"AJ(perspi`cacious ,)"
per`spicuous	Suffix	"AJ(per`spicuous ,)"
per`suasive	Suffix	"AJ(per`suade ,deverb)"
`pert	Suffix	"AJ(`pert ,)"
perti`nacious	Suffix	"AJ(perti`nacious ,)"
`pertinent	Suffix	"AJ(`pertinent ,)"
per`vasive	Suffix	"AJ(per`vade ,deverb)"
per`verse	Suffix	"AJ(per`verse ,)"
`pervious	Suffix	"AJ(`pervious ,)"
`pesky	Suffix	"AJ(`pesky ,)"
`pestilent	Suffix	"AJ(`pestilent ,)"
pes`tiferous	Suffix	"AJ(pes`tiferous ,)"
pesti`lential	Suffix	"AJ(pesti`lential ,)"
pe`tit	Suffix	"AJ(pe`tit ,)"
pe`tite	Suffix	"AJ(pe`tite ,)"
petro`chemical	Suffix	"AJ(petro`chemical ,)"
`petty	Suffix	"AJ(`petty ,)"
`petulant	Suffix	"AJ(`petulant ,)"
`phallic	IC_Suffix	"AJ(`phallic ,)"
phari`saic	IC_Suffix	"AJ(`pharisee ,denom)"
pha`ryngeal	Suffix	"AJ(`pharynx ,denom)"
phe`nomenal	Suffix	"AJ(phe`nomenon ,denom)"
phleg`matic	IC_Suffix	"AJ(phleg`matic ,)"
`phobic	IC_Suffix	"AJ(`phobic ,)"
`phony	Suffix	"AJ(`phony ,)"
photo`genic	IC_Suffix	"AJ(photo`genic ,)"
pian`issimo	Suffix	"AJ(pian`issimo ,)"
pica`yune	Suffix	"AJ(pica`yune ,)"
`picky	Suffix	"AJ(`picky ,)"
pic`torial	Suffix	"AJ(pic`torial ,)"
`piecemeal	Suffix	"AJ(`piecemeal ,)"
`piggyback	Suffix	"AJ(`piggyback ,)"
`pious	Suffix	"AJ(`pious ,)"
`piquant	Suffix	"AJ(`piquant ,)"
`piteous	Suffix	"AJ(`pity ,denom)"
pizzi`cato	Suffix	"AJ(pizzi`cato ,)"
pla`cental	Suffix	"AJ(pla`centa ,denom)"
`placable	Suffix	"AJ(`placate ,deverb)"
`placid	Suffix	"AJ(`placid ,)"
`plaintive	Suffix	"AJ(`plaintive ,)"
`planar	Suffix	"AJ(`plane ,denom)"
`planetary	Suffix	"AJ(`planet ,denom)"
`plastic	IC_Suffix	"AJ(`plastic ,)"
plati`tudinous	Suffix	"AJ(`platitude ,denom)"
`plausible	Suffix	"AJ(`plausible ,)"
`pleasurable	Suffix	"AJ(`pleasure ,denom)"
`plenary	Suffix	"AJ(`plenary ,)"
plenipo`tentiary	Suffix	"AJ(plenipo`tentiary ,)"
`plenteous	Suffix	"AJ(`plenty ,denom)"
`plentiful	Suffix	"AJ(`plentiful ,)"
`pleural	Suffix	"AJ(`pleura ,denom)"
`pliant	Suffix	"AJ(`ply ,deverb)"
`plump	Suffix	"AJ(`plump ,)"
`plus	Suffix	"AJ(`plus ,)"
`plush	Suffix	"AJ(`plush ,)"
`plushy	Suffix	"AJ(`plushy ,)"
pneu`matic	IC_Suffix	"AJ(pneu`matic ,)"
`poignant	Suffix	"AJ(`poignant ,)"
`pokey	Suffix	"AJ(`pokey ,)"
`poky	Suffix	"AJ(`poky ,)"
`polar	Suffix	"AJ(`pole ,denom)"
po`lite	Suffix	"AJ(po`lite ,)"
`politic	IC_Suffix	"AJ(`politic ,)"
poly`technic	IC_Suffix	"AJ(poly`technic ,)"
`ponderous	Suffix	"AJ(`ponderous ,)"
pon`tific	IC_Suffix	"AJ(pon`tific ,)"
`poor	Suffix	"AJ(`poor ,)"
`popular	Suffix	"AJ(`popular ,)"
`populous	Suffix	"AJ(`populous ,)"
`porcine	Suffix	"AJ(`porcine ,)"
`posh	Suffix	"AJ(`posh ,)"
`possible	Suffix	"AJ(`possible ,)"
`postal	Suffix	"AJ(`postal ,)"
`posthumous	Suffix	"AJ(`posthumous ,)"
`potable	Suffix	"AJ(`potable ,)"
`potent	Suffix	"AJ(`potent ,)"
po`tential	Suffix	"AJ(po`tential ,)"
`practicable	Suffix	"AJ(`practicable ,)"
`practical	Suffix	"AJ(`practical ,)"
prag`matic	IC_Suffix	"AJ(prag`matic ,)"
`preachy	Suffix	"AJ(`preach ,deverb)"
pre`carious	Suffix	"AJ(pre`carious ,)"
`precious	Suffix	"AJ(`precious ,)"
pre`cipitable	Suffix	"AJ(pre`cipitate ,deverb)"
pre`cipitant	Suffix	"AJ(pre`cipitant ,)"
pre`cipitate	Suffix	"AJ(pre`cipitate ,)"
pre`cipitous	Suffix	"AJ(pre`cipitous ,)"
pre`cise	Suffix	"AJ(pre`cise ,)"
pre`cocious	Suffix	"AJ(pre`cocious ,)"
`predatory	Suffix	"AJ(`predatory ,)"
pre`dominant	Suffix	"AJ(pre`dominant ,)"
pre`dominate	Suffix	"AJ(pre`dominate ,)"
pre`eminent	Suffix	"AJ(pre`eminent ,)"
pre`fab	Suffix	"AJ(pre`fab ,)"
`prefatory	Suffix	"AJ(`preface ,denom)"
prefer`ential	Suffix	"AJ(pre`fer ,deverb)"
`preferable	Suffix	"AJ(pre`fer ,deverb)"
`pregnable	Suffix	"AJ(`pregnable ,)"
`pregnant	Suffix	"AJ(`pregnant ,)"
pre`hensile	Suffix	"AJ(pre`hensile ,)"
pre`mier	Suffix	"AJ(pre`mier ,)"
pre`miere	Suffix	"AJ(pre`miere ,)"
pre`monitory	Suffix	"AJ(pre`monitory ,)"
`preparatory	Suffix	"AJ(`preparatory ,)"
pre`ponderant	Suffix	"AJ(pre`ponderant ,)"
pre`posterous	Suffix	"AJ(pre`posterous ,)"
`prescient	Suffix	"AJ(`prescient ,)"
`prescript	Suffix	"AJ(`prescript ,)"
pre`scriptive	Suffix	"AJ(pre`scribe ,deverb)"
`present	Suffix	"AJ(`present ,)"
prestigious	Suffix	"AJ(pres`tige ,denom)"
pre`sumptive	Suffix	"AJ(pre`sume ,deverb)"
pre`sumptuous	Suffix	"AJ(pre`sume ,deverb)"
pre`tentious	Suffix	"AJ(pre`tentious ,)"
preter`natural	Suffix	"AJ(preter`natural ,)"
`pretty	Suffix	"AJ(`pretty ,)"
`prevalent	Suffix	"AJ(`prevalent ,)"
`previous	Suffix	"AJ(`previous ,)"
`prickly	Suffix	"AJ(`prickle ,denom)"
`pricy	Suffix	"AJ(`price ,denom)"
`prim	Suffix	"AJ(`prim ,)"
`primal	Suffix	"AJ(`primal ,)"
`prime	Suffix	"AJ(`prime ,)"
pri`meval	Suffix	"AJ(pri`meval ,)"
pri`mordial	Suffix	"AJ(pri`mordial ,)"
`prior	Suffix	"AJ(`prior ,)"
pris`matic	IC_Suffix	"AJ(`prism ,denom)"
`prissy	Suffix	"AJ(`prissy ,)"
pris`tine	Suffix	"AJ(pris`tine ,)"
`private	Suffix	"AJ(`private ,)"
`probable	Suffix	"AJ(`probable ,)"
pro`bationary	Suffix	"AJ(pro`bation ,denom)"
problem`atic	IC_Suffix	"AJ(`problem ,denom)"
pro`crustean	Suffix	"AJ(pro`crustean ,)"
`prodigal	Suffix	"AJ(`prodigal ,)"
pro`ductive	Suffix	"AJ(pro`duce ,deverb)"
pro`ficient	Suffix	"AJ(pro`ficient ,)"
pro`found	Suffix	"AJ(pro`found ,)"
pro`fuse	Suffix	"AJ(pro`fuse ,)"
`prolate	Suffix	"AJ(`prolate ,)"
pro`lific	IC_Suffix	"AJ(pro`lific ,)"
`prolix	Suffix	"AJ(`prolix ,)"
`prominent	Suffix	"AJ(`prominent ,)"
pro`miscuous	Suffix	"AJ(pro`miscuous ,)"
`prompt	Suffix	"AJ(`prompt ,)"
`prone	Suffix	"AJ(`prone ,)"
`proper	Suffix	"AJ(`proper ,)"
prophy`lactic	IC_Suffix	"AJ(prophy`lactic ,)"
pro`pitious	Suffix	"AJ(pro`pitious ,)"
pro`portionate	Suffix	"AJ(pro`portion ,denom)"
pro`prietary	Suffix	"AJ(pro`prietary ,)"
pro`saic	IC_Suffix	"AJ(pro`saic ,)"
pro`scriptive	Suffix	"AJ(pro`scribe ,deverb)"
pro`sodic	IC_Suffix	"AJ(`prosody ,denom)"
pro`spective	Suffix	"AJ(`prospect ,denom)"
`prosperous	Suffix	"AJ(`prosper ,deverb)"
pros`thetic	IC_Suffix	"AJ(pros`thesis ,denom)"
`protean	Suffix	"AJ(`protean ,)"
pro`tuberant	Suffix	"AJ(pro`tuberant ,)"
`proud	Suffix	"AJ(`proud ,)"
`provident	Suffix	"AJ(`provident ,)"
provi`dential	Suffix	"AJ(`providence ,denom)"
pro`vocative	Suffix	"AJ(pro`voke ,deverb)"
`proximal	Suffix	"AJ(`proximal ,)"
`proximate	Suffix	"AJ(`proximate ,)"
`prudent	Suffix	"AJ(`prudent ,)"
pru`dential	Suffix	"AJ(pru`dential ,)"
`prurient	Suffix	"AJ(`prurient ,)"
psychi`atric	IC_Suffix	"AJ(psychi`atric ,)"
`psychic	IC_Suffix	"AJ(`psychic ,)"
psychoana`lytic	IC_Suffix	"AJ(psychoana`lytic ,)"
psycholin`guistic	IC_Suffix	"AJ(psycholin`guistic ,)"
psychoso`matic	IC_Suffix	"AJ(psychoso`matic ,)"
psy`chotic	IC_Suffix	"AJ(psy`chotic ,)"
pu`bescent	Suffix	"AJ(pu`bescent ,)"
`pubic	IC_Suffix	"AJ(`pubic ,)"
`puckish	Suffix	"AJ(`puckish ,)"
`puddly	Suffix	"AJ(`puddle ,denom)"
`pudgy	Suffix	"AJ(`pudgy ,)"
`puerile	Suffix	"AJ(`puerile ,)"
pug`nacious	Suffix	"AJ(pug`nacious ,)"
puis`sant	Suffix	"AJ(puis`sant ,)"
pulchri`tudinous	Suffix	"AJ(`pulchritude ,denom)"
`pulmonary	Suffix	"AJ(`pulmonary ,)"
punc`tilious	Suffix	"AJ(punc`tilious ,)"
`punctual	Suffix	"AJ(`punctual ,)"
`pungent	Suffix	"AJ(`pungent ,)"
`punitive	Suffix	"AJ(`punitive ,)"
`punky	Suffix	"AJ(`punky ,)"
`puny	Suffix	"AJ(`puny ,)"
`pure	Suffix	"AJ(`pure ,)"
`purposive	Suffix	"AJ(`purpose ,denom)"
pur`suant	Suffix	"AJ(pur`sue ,deverb)"
pusil`lanimous	Suffix	"AJ(pusil`lanimous ,)"
`putative	Suffix	"AJ(`putative ,)"
`putrid	Suffix	"AJ(`putrid ,)"
pyro`technic	IC_Suffix	"AJ(pyro`technic ,)"
quad`rangular	Suffix	"AJ(`quadrangle ,denom)"
quad`ratic	IC_Suffix	"AJ(quad`ratic ,)"
quad`rennial	Suffix	"AJ(quad`rennial ,)"
quadri`partite	Suffix	"AJ(quadri`partite ,)"
`quaint	Suffix	"AJ(`quaint ,)"
`qualitative	Suffix	"AJ(`qualitative ,)"
`quantitative	Suffix	"AJ(`quantitative ,)"
`quarrelsome	Suffix	"AJ(`quarrel ,deverb)"
`quasi	Suffix	"AJ(`quasi ,)"
`quaternary	Suffix	"AJ(`quaternary ,)"
`quavery	Suffix	"AJ(`quaver ,deverb)"
`queasy	Suffix	"AJ(`queasy ,)"
`queazy	Suffix	"AJ(`queazy ,)"
`queer	Suffix	"AJ(`queer ,)"
`quenchless	Suffix	"AJ(`quenchless ,)"
`querulous	Suffix	"AJ(`querulous ,)"
qui`escent	Suffix	"AJ(qui`escent ,)"
quintes`sential	Suffix	"AJ(quintes`sential ,)"
quix`otic	IC_Suffix	"AJ(quix`otic ,)"
`quizzic	IC_Suffix	"AJ(`quiz ,denom)"
rab`binic	IC_Suffix	"AJ(`rabbi ,denom)"
`rabid	Suffix	"AJ(`rabid ,)"
`rackety	Suffix	"AJ(`rackety ,)"
`racy	Suffix	"AJ(`racy ,)"
`radiant	Suffix	"AJ(`radiate ,deverb)"
radio`active	Suffix	"AJ(radio`active ,)"
`raffish	Suffix	"AJ(`raffish ,)"
`ragged	Suffix	"AJ(`ragged ,)"
`raggedy	Suffix	"AJ(`rag ,denom)"
`rakish	Suffix	"AJ(`rakish ,)"
ram`bunctious	Suffix	"AJ(ram`bunctious ,)"
`rampant	Suffix	"AJ(`rampant ,)"
`rancid	Suffix	"AJ(`rancid ,)"
`random	Suffix	"AJ(`random ,)"
`randy	Suffix	"AJ(`randy ,)"
`rangy	Suffix	"AJ(`rangy ,)"
`rank	Suffix	"AJ(`rank ,)"
ra`pacious	Suffix	"AJ(ra`pacious ,)"
`rapt	Suffix	"AJ(`rapt ,)"
`rash	Suffix	"AJ(`rash ,)"
`raspy	Suffix	"AJ(`rasp ,deverb)"
`rattly	Suffix	"AJ(`rattle ,deverb)"
`rare	Suffix	"AJ(`rare ,)"
`raucous	Suffix	"AJ(`raucous ,)"
`raunchy	Suffix	"AJ(`raunchy ,)"
`ravenous	Suffix	"AJ(`ravenous ,deverb)"
`raw	Suffix	"AJ(`raw ,)"
raw`boned	Suffix	"AJ(`bone ,denom)"
`real	Suffix	"AJ(`real ,)"
re`barbative	Suffix	"AJ(re`barbative ,)"
re`bellious	Suffix	"AJ(re`bel ,deverb)"
re`born	Suffix	"AJ(`born ,)"
re`calcitrant	Suffix	"AJ(re`calcitrant ,)"
`recent	Suffix	"AJ(`recent ,)"
re`ceptive	Suffix	"AJ(re`ceive ,deverb)"
re`cessionary	Suffix	"AJ(re`cess ,deverb)"
re`cherche	Suffix	"AJ(re`cherche ,)"
re`ciprocal	Suffix	"AJ(re`ciprocal ,)"
`reckless	Suffix	"AJ(`reckless ,)"
re`clad	Suffix	"AJ(`clad ,)"
re`clusive	Suffix	"AJ(re`clusive ,)"
re`combinant	Suffix	"AJ(re`combinant ,)"
`recondite	Suffix	"AJ(`recondite ,)"
rec`tangular	Suffix	"AJ(`rectangle ,denom)"
`rectal	Suffix	"AJ(`rectum ,denom)"
re`cumbent	Suffix	"AJ(re`cumbent ,)"
re`demptive	Suffix	"AJ(re`deem ,deverb)"
re`dundant	Suffix	"AJ(re`dundant ,)"
re`ferable	Suffix	"AJ(re`fer - exception to Gemination,deverb)"
re`fulgent	Suffix	"AJ(re`fulgent ,)"
`regal	Suffix	"AJ(`regal ,)"
re`gardless	Suffix	"AJ(re`gard ,deverb)"
`registrable	Suffix	"AJ(`registrate ,deverb)"
re`lentless	Suffix	"AJ(re`lent ,deverb)"
`relevant	Suffix	"AJ(`relevant ,)"
re`liant	Suffix	"AJ(re`ly ,deverb)"
re`ligious	Suffix	"AJ(re`ligious ,)"
re`luctant	Suffix	"AJ(re`luctant ,)"
re`monstrant	Suffix	"AJ(re`monstrate ,deverb)"
re`mote	Suffix	"AJ(re`mote ,)"
`renal	Suffix	"AJ(`renal ,)"
`reparable	Suffix	"AJ(re`pair ,deverb)"
re`pentant	Suffix	"AJ(re`pent ,deverb)"
repe`titious	Suffix	"AJ(re`peat ,deverb)"
re`petitive	Suffix	"AJ(re`peat ,deverb)"
re`plete	Suffix	"AJ(re`plete ,)"
`replicable	Suffix	"AJ(re`plicate ,deverb)"
repor`torial	Suffix	"AJ(re`port ,deverb)"
repre`hensible	Suffix	"AJ(repre`hend ,deverb)"
re`pugnant	Suffix	"AJ(re`pugnant ,)"
re`semblant	Suffix	"AJ(re`semble ,deverb)"
re`sentful	Suffix	"AJ(re`sent ,deverb)"
re`sidual	Suffix	"AJ(re`sidual ,)"
re`siduary	Suffix	"AJ(`residue ,denom)"
re`silient	Suffix	"AJ(re`sile ,deverb)"
re`sistant	Suffix	"AJ(re`sist ,deverb)"
`resolute	Suffix	"AJ(`resolute ,)"
re`splendent	Suffix	"AJ(re`splendent ,)"
re`sponsible	Suffix	"AJ(re`sponsible ,)"
re`sponsive	Suffix	"AJ(re`spond ,deverb)"
`restive	Suffix	"AJ(`restive ,)"
re`storative	Suffix	"AJ(re`store ,deverb)"
re`sultant	Suffix	"AJ(re`sult ,deverb)"
`retail	Suffix	"AJ(`retail ,)"
re`tentive	Suffix	"AJ(re`tain ,deverb)"
`reticent	Suffix	"AJ(`reticent ,)"
`retinal	Suffix	"AJ(`retina ,denom)"
re`tributive	Suffix	"AJ(re`tributive ,)"
`retrograde	Suffix	"AJ(`retrograde ,)"
`revelatory	Suffix	"AJ(re`veal ,deverb)"
re`verberant	Suffix	"AJ(re`verberate ,deverb)"
`reverend	Suffix	"AJ(`reverend ,)"
rever`ential	Suffix	"AJ(re`vere ,deverb)"
`revocable	Suffix	"AJ(re`voke ,deverb)"
re`wrought	Suffix	"AJ(`wrought ,)"
rhap`sodic	IC_Suffix	"AJ(`rhapsody ,denom)"
rheu`matic	IC_Suffix	"AJ(`rheuma ,denom)"
ri`bald	Suffix	"AJ(ri`bald ,)"
`rich	Suffix	"AJ(`rich ,)"
`rickety	Suffix	"AJ(`rickety ,)"
`rictal	Suffix	"AJ(`rictus ,denom)"
ri`diculous	Suffix	"AJ(`ridicule ,deverb)"
`rife	Suffix	"AJ(`rife ,)"
`righthand	Suffix	"AJ(`righthand ,)"
`right-hand	Suffix	"AJ(`right-hand ,)"
right`handed	Suffix	"AJ(`hand ,denom)"
`righteous	Suffix	"AJ(`righteous ,)"
`rigid	Suffix	"AJ(`rigid ,)"
`rimy	Suffix	"AJ(`rime ,denom)"
`rinky-dink	Suffix	"AJ(`rinky-dink ,)"
ri`parian	Suffix	"AJ(ri`parian ,)"
`ripe	Suffix	"AJ(`ripe ,)"
`ripply	Suffix	"AJ(`ripple ,deverb)"
`risible	Suffix	"AJ(`risible ,)"
ris`que	Suffix	"AJ(ris`que ,)"
`riverine	Suffix	"AJ(`river ,denom)"
ro`bust	Suffix	"AJ(ro`bust ,)"
`rockbound	Suffix	"AJ(`rockbound ,)"
ro`coco	Suffix	"AJ(ro`coco ,)"
roly-`poly	Suffix	"AJ(roly-`poly ,)"
ro`mantic	IC_Suffix	"AJ(`romance ,denom)"
`rosy	Suffix	"AJ(`rose ,denom)"
`rotten	Suffix	"AJ(`rot ,deverb)"
ro`tund	Suffix	"AJ(ro`tund ,)"
`roughshod	Suffix	"AJ(`roughshod ,)"
`roundabout	Suffix	"AJ(`roundabout ,)"
`royal	Suffix	"AJ(`royal ,)"
`rubicund	Suffix	"AJ(`rubicund ,)"
`ruddy	Suffix	"AJ(`ruddy ,)"
`rude	Suffix	"AJ(`rude ,)"
rudi`mentary	Suffix	"AJ(`rudiment ,denom)"
`rufous	Suffix	"AJ(`rufous ,)"
`rugged	Suffix	"AJ(`rugged ,)"
`runny	Suffix	"AJ(`run ,deverb)"
`rural	Suffix	"AJ(`rural ,)"
`rustic	IC_Suffix	"AJ(`rustic ,)"
`rustproof	Suffix	"AJ(`rustproof ,)"
`ruthless	Suffix	"AJ(`ruthless ,)"
`saccharine	Suffix	"AJ(`saccharine ,)"
`sacral	Suffix	"AJ(`sacral ,)"
`sacred	Suffix	"AJ(`sacred ,)"
sacri`legious	Suffix	"AJ(`sacrilege ,denom)"
`sacrosanct	Suffix	"AJ(`sacrosanct ,)"
`sad	Suffix	"AJ(`sad ,)"
sa`gacious	Suffix	"AJ(sa`gacious ,)"
`sage	Suffix	"AJ(`sage ,)"
`salable	Suffix	"AJ(`sale ,denom)"
`saleable	Suffix	"AJ(`sale ,denom)"
sa`lacious	Suffix	"AJ(sa`lacious ,)"
`salient	Suffix	"AJ(`salient ,)"
`saline	Suffix	"AJ(`saline ,)"
`salivary	Suffix	"AJ(sa`liva ,denom)"
`sallow	Suffix	"AJ(`sallow ,)"
`saltwater	Suffix	"AJ(`saltwater ,)"
sa`lubrious	Suffix	"AJ(sa`lubrious ,)"
`salutary	Suffix	"AJ(`salutary ,)"
`same	Suffix	"AJ(`same ,)"
`sane	Suffix	"AJ(`sane ,)"
`sanguinary	Suffix	"AJ(`sanguinary ,)"
`sanguine	Suffix	"AJ(`sanguine ,)"
san`guineous	Suffix	"AJ(san`guineous ,)"
`sanitary	Suffix	"AJ(`sanitary ,)"
`sapiens	Suffix	"AJ(`sapiens ,)"
`sapient	Suffix	"AJ(`sapient ,)"
`sappy	Suffix	"AJ(`sappy ,)"
sar`castic	IC_Suffix	"AJ(sar`castic ,)"
sar`donic	IC_Suffix	"AJ(sar`donic ,)"
`sassy	Suffix	"AJ(`sassy ,)"
`satiable	Suffix	"AJ(`satiable ,)"
satis`factory	Suffix	"AJ(satis`factory ,)"
`saturable	Suffix	"AJ(`saturable ,)"
`saucy	Suffix	"AJ(`saucy ,)"
`savvy	Suffix	"AJ(`savvy ,)"
`sawtooth	Suffix	"AJ(`sawtooth ,)"
`scabious	Suffix	"AJ(`scabious ,)"
`scabrous	Suffix	"AJ(`scabrous ,)"
`scalar	Suffix	"AJ(`scale ,denom)"
`scaly	Suffix	"AJ(`scale ,denom)"
`scant	Suffix	"AJ(`scant ,)"
`scanty	Suffix	"AJ(`scanty ,)"
`scarce	Suffix	"AJ(`scarce ,)"
`scary	Suffix	"AJ(`scare ,deverb)"
scato`logic	IC_Suffix	"AJ(scato`logic ,)"
sche`matic	IC_Suffix	"AJ(`schema ,denom)"
schis`matic	IC_Suffix	"AJ(schis`matic ,)"
schizo`phrenic	IC_Suffix	"AJ(schizo`phrenic ,)"
scho`lastic	IC_Suffix	"AJ(scho`lastic ,)"
scien`tific	IC_Suffix	"AJ(scien`tific ,)"
`scottish	Suffix	"AJ(`scottish ,)"
`scraggly	Suffix	"AJ(`scraggly ,)"
`scraggy	Suffix	"AJ(`scraggy ,)"
`scrawny	Suffix	"AJ(`scrawny ,)"
`scrubby	Suffix	"AJ(`scrubby ,)"
`scruffy	Suffix	"AJ(`scruffy ,)"
`scrumptious	Suffix	"AJ(`scrumptious ,)"
`scrupulous	Suffix	"AJ(`scruple ,denom)"
`scrutable	Suffix	"AJ(`scrutable ,)"
`scrutinise	Suffix	"AJ(`scrutiny - British,denom)"
`scrutinize	Suffix	"AJ(`scrutiny ,denom)"
`scurrilous	Suffix	"AJ(`scurrilous ,)"
`scurvy	Suffix	"AJ(`scurvy ,)"
`seamy	Suffix	"AJ(`seamy ,)"
`seasonable	Suffix	"AJ(`season ,denom)"
`sec	Suffix	"AJ(`sec ,)"
`secondary	Suffix	"AJ(`second ,denom)"
`secondhand	Suffix	"AJ(`secondhand ,)"
`secular	Suffix	"AJ(`secular ,)"
`sedentary	Suffix	"AJ(`sedentary ,)"
sedi`mentary	Suffix	"AJ(`sediment ,denom)"
se`ditious	Suffix	"AJ(se`ditious ,)"
se`ductive	Suffix	"AJ(se`duce ,deverb)"
`sedulous	Suffix	"AJ(`sedulous ,)"
`seemly	Suffix	"AJ(`seemly ,)"
`seismic	IC_Suffix	"AJ(`seismic ,)"
se`lect	Suffix	"AJ(se`lect ,)"
self`conscious	Suffix	"AJ(self`conscious ,)"
self`same	Suffix	"AJ(self`same ,)"
se`mantic	IC_Suffix	"AJ(se`mantic ,)"
`seminal	Suffix	"AJ(`seminal ,)"
semi`otic	IC_Suffix	"AJ(semi`otic ,)"
`senile	Suffix	"AJ(`senile ,)"
`sensate	Suffix	"AJ(`sensate ,)"
`sensible	Suffix	"AJ(`sensible ,)"
`sensitive	Suffix	"AJ(`sense ,denom)"
`sensory	Suffix	"AJ(`sense ,denom)"
`sensuous	Suffix	"AJ(`sense ,denom)"
sen`tential	Suffix	"AJ(`sentence ,denom)"
`sentient	Suffix	"AJ(`sentient ,)"
`separable	Suffix	"AJ(`separate ,deverb)"
`septate	Suffix	"AJ(`septate ,)"
sep`tennial	Suffix	"AJ(sep`tennial ,)"
`septic	IC_Suffix	"AJ(`septic ,)"
`sepulchral	Suffix	"AJ(`sepulcher ,denom)"
`sequent	Suffix	"AJ(`sequent ,)"
se`quential	Suffix	"AJ(`sequence ,denom)"
seren`dipitous	Suffix	"AJ(seren`dipity ,denom)"
se`rene	Suffix	"AJ(se`rene ,)"
`serious	Suffix	"AJ(`serious ,)"
`serpentine	Suffix	"AJ(`serpent ,denom)"
`servile	Suffix	"AJ(`servile ,)"
se`vere	Suffix	"AJ(se`vere ,)"
sfor`zando	Suffix	"AJ(sfor`zando ,)"
`shabby	Suffix	"AJ(`shabby ,)"
`shady	Suffix	"AJ(`shade ,denom)"
`shaky	Suffix	"AJ(`shake ,deverb)"
`shallow	Suffix	"AJ(`shallow ,)"
`shamefaced	Suffix	"AJ(`shamefaced ,)"
`sharp	Suffix	"AJ(`sharp ,)"
`shatterproof	Suffix	"AJ(`shatterproof ,)"
`sheer	Suffix	"AJ(`sheer ,)"
`shifty	Suffix	"AJ(`shifty ,)"
`shiny	Suffix	"AJ(`shine ,denom)"
`shipshape	Suffix	"AJ(`shipshape ,)"
`shoddy	Suffix	"AJ(`shoddy ,)"
`shopworn	Suffix	"AJ(`shopworn ,)"
short`sighted	Suffix	"AJ(`sight ,denom)"
`showy	Suffix	"AJ(`show ,deverb)"
`shrewd	Suffix	"AJ(`shrewd ,)"
`shrill	Suffix	"AJ(`shrill ,)"
`shrunken	Suffix	"AJ(`shrink ,deverb)"
`shy	Suffix	"AJ(`shy ,)"
`sick	Suffix	"AJ(`sick ,)"
`sidearm	Suffix	"AJ(`sidearm ,)"
`sidelong	Suffix	"AJ(`sidelong ,)"
si`dereal	Suffix	"AJ(si`dereal ,)"
sig`nificant	Suffix	"AJ(sig`nificant ,)"
`silent	Suffix	"AJ(`silent ,)"
`silken	Suffix	"AJ(`silken ,)"
`silly	Suffix	"AJ(`silly ,)"
`similar	Suffix	"AJ(`similar ,)"
`simple	Suffix	"AJ(`simple ,)"
simple`minded	Suffix	"AJ(`mind ,denom)"
`simplex	Suffix	"AJ(`simplex ,)"
sim`plistic	IC_Suffix	"AJ(sim`plistic ,)"
simul`taneous	Suffix	"AJ(simul`taneous ,)"
sin`cere	Suffix	"AJ(sin`cere ,)"
single`handed	Suffix	"AJ(`hand ,denom)"
`singular	Suffix	"AJ(`singular ,)"
`sinister	Suffix	"AJ(`sinister ,)"
`sinistral	Suffix	"AJ(`sinistral ,)"
`sinuous	Suffix	"AJ(`sinuous ,)"
`skeletal	Suffix	"AJ(`skeleton ,denom)"
`skilful	Suffix	"AJ(`skill ,denom)"
`skimpy	Suffix	"AJ(`skimp ,deverb)"
`skinny	Suffix	"AJ(`skinny ,)"
`sleazy	Suffix	"AJ(`sleaze ,denom)"
`sleek	Suffix	"AJ(`sleek ,)"
`slender	Suffix	"AJ(`slender ,)"
`slight	Suffix	"AJ(`slight ,)"
`slim	Suffix	"AJ(`slim ,)"
`slimy	Suffix	"AJ(`slime ,denom)"
`slinky	Suffix	"AJ(`slinky ,)"
`slippery	Suffix	"AJ(`slip ,deverb)"
`slithery	Suffix	"AJ(`slither ,deverb)"
`sloppy	Suffix	"AJ(`sloppy ,)"
`sluggish	Suffix	"AJ(`sluggish ,)"
`sly	Suffix	"AJ(`sly ,)"
`small	Suffix	"AJ(`small ,)"
`smalltime	Suffix	"AJ(`smalltime ,)"
`smarmy	Suffix	"AJ(`smarmy ,)"
`smart	Suffix	"AJ(`smart ,)"
`smoky	Suffix	"AJ(`smoke ,denom)"
`smudgy	Suffix	"AJ(`smudge ,denom)"
`smug	Suffix	"AJ(`smug ,)"
`snaky	Suffix	"AJ(`snake ,denom)"
`snappy	Suffix	"AJ(`snappy ,)"
`snazzy	Suffix	"AJ(`snazzy ,)"
`sneaky	Suffix	"AJ(`sneak ,deverb)"
`sneezy	Suffix	"AJ(`sneeze ,deverb)"
`snide	Suffix	"AJ(`snide ,)"
`snippy	Suffix	"AJ(`snippy ,)"
`snoopy	Suffix	"AJ(`snoop ,deverb)"
`snooty	Suffix	"AJ(`snooty ,)"
`snuffly	Suffix	"AJ(`snuffle ,deverb)"
`snug	Suffix	"AJ(`snug ,)"
`snuggly	Suffix	"AJ(`snuggle ,deverb)"
`sociable	Suffix	"AJ(`sociable ,)"
so`cietal	Suffix	"AJ(so`ciety ,denom)"
socioeco`nomic	IC_Suffix	"AJ(socioeco`nomic ,)"
sociolin`guistic	IC_Suffix	"AJ(sociolin`guistic ,)"
`sodden	Suffix	"AJ(`sodden ,)"
soft`hearted	Suffix	"AJ(`heart ,denom)"
`soggy	Suffix	"AJ(`soggy ,)"
soi`gne	Suffix	"AJ(soi`gne ,)"
soi`gnee	Suffix	"AJ(soi`gnee ,)"
`solar	Suffix	"AJ(`solar ,)"
`sole	Suffix	"AJ(`sole ,)"
`solemn	Suffix	"AJ(`solemn ,)"
so`licitous	Suffix	"AJ(so`licitous ,)"
`solitary	Suffix	"AJ(`solitary ,)"
`soluble	Suffix	"AJ(`soluble ,)"
so`matic	IC_Suffix	"AJ(so`matic ,)"
`somber	Suffix	"AJ(`somber ,)"
`sombre	Suffix	"AJ(`sombre ,)"
`somnolent	Suffix	"AJ(`somnolent ,)"
`sonic	IC_Suffix	"AJ(`sonic ,)"
`sonorous	Suffix	"AJ(`sonorous ,)"
sopo`rific	IC_Suffix	"AJ(sopo`rific ,)"
`sordid	Suffix	"AJ(`sordid ,)"
`sorry	Suffix	"AJ(`sorry ,)"
`sound	Suffix	"AJ(`sound ,)"
`soundproof	Suffix	"AJ(`soundproof ,)"
`southbound	Suffix	"AJ(`southbound ,)"
`southern	Suffix	"AJ(`southern ,)"
south`eastern	Suffix	"AJ(south`eastern ,)"
south`western	Suffix	"AJ(south`western ,)"
`spacious	Suffix	"AJ(`space ,denom)"
`spare	Suffix	"AJ(`spare ,)"
`sparse	Suffix	"AJ(`sparse ,)"
spas`modic	IC_Suffix	"AJ(spas`modic ,)"
`spastic	IC_Suffix	"AJ(`spastic ,)"
`spatial	Suffix	"AJ(`space ,denom)"
spe`cific	IC_Suffix	"AJ(spe`cific ,)"
`specious	Suffix	"AJ(`specious ,)"
`spectacled	Suffix	"AJ(`spectacles ,denom)"
spec`tacular	Suffix	"AJ(spec`tacular ,)"
`spectral	Suffix	"AJ(`spectral ,)"
`specular	Suffix	"AJ(`specular ,)"
`spellbound	Suffix	"AJ(`spellbound ,)"
`spicy	Suffix	"AJ(`spice ,denom)"
`spiffy	Suffix	"AJ(`spiffy ,)"
`spiky	Suffix	"AJ(`spike ,denom)"
spiny	Suffix	"AJ(`spine ,denom)"
`splendid	Suffix	"AJ(`splendid ,)"
`splenetic	IC_Suffix	"AJ(`splenetic ,)"
`spongy	Suffix	"AJ(`sponge ,denom)"
`spontaneous	Suffix	"AJ(`spontaneous ,)"
spo`radic	IC_Suffix	"AJ(spo`radic ,)"
`sprightly	Suffix	"AJ(`sprightly ,)"
`spry	Suffix	"AJ(`spry ,)"
`spurious	Suffix	"AJ(`spurious ,)"
`squalid	Suffix	"AJ(`squalid ,)"
`squamous	Suffix	"AJ(`squamous ,)"
`squeamish	Suffix	"AJ(`squeamish ,)"
`squinty	Suffix	"AJ(`squint ,deverb)"
`squirmy	Suffix	"AJ(`squirm ,deverb)"
`squishy	Suffix	"AJ(`squishy ,)"
`stabile	Suffix	"AJ(`stabile ,)"
`stable	Suffix	"AJ(`stable ,)"
stac`cato	Suffix	"AJ(stac`cato ,)"
`stagestruck	Suffix	"AJ(`stagestruck ,)"
`stagnant	Suffix	"AJ(`stagnant ,)"
`staid	Suffix	"AJ(`staid ,)"
`stalwart	Suffix	"AJ(`stalwart ,)"
`stark	Suffix	"AJ(`stark ,)"
`statewide	Suffix	"AJ(`statewide ,)"
`static	IC_Suffix	"AJ(`static ,)"
`stationary	Suffix	"AJ(`stationary ,)"
`statutory	Suffix	"AJ(`statute ,denom)"
`staunch	Suffix	"AJ(`staunch ,)"
`steadfast	Suffix	"AJ(`steadfast ,)"
`stedfast	Suffix	"AJ(`stedfast ,)"
`steep	Suffix	"AJ(`steep ,)"
`stellar	Suffix	"AJ(`stellar ,)"
stereo`phonic	IC_Suffix	"AJ(stereo`phonic ,)"
stereo`typic	IC_Suffix	"AJ(`stereotype ,denom)"
`sterile	Suffix	"AJ(`sterile ,)"
`stern	Suffix	"AJ(`stern ,)"
`sternal	Suffix	"AJ(`sternal ,)"
`stertorous	Suffix	"AJ(`stertorous ,)"
`sticky	Suffix	"AJ(`stick ,deverb)"
`stiff	Suffix	"AJ(`stiff ,)"
`stillborn	Suffix	"AJ(`stillborn ,)"
`stilted	Suffix	"AJ(`stilted ,)"
`stingy	Suffix	"AJ(`stingy ,)"
sto`chastic	IC_Suffix	"AJ(sto`chastic ,)"
`stocky	Suffix	"AJ(`stocky ,)"
`stodgy	Suffix	"AJ(`stodgy ,)"
`stolid	Suffix	"AJ(`stolid ,)"
`stony	Suffix	"AJ(`stone ,denom)"
`stormbound	Suffix	"AJ(`stormbound ,)"
`stout	Suffix	"AJ(`stout ,)"
straight`forward	Suffix	"AJ(straight`forward ,)"
`strange	Suffix	"AJ(`strange ,)"
stra`tegic	IC_Suffix	"AJ(`strategy ,denom)"
`strenuous	Suffix	"AJ(`strenuous ,)"
`striated	Suffix	"AJ(`striated ,)"
`strict	Suffix	"AJ(`strict ,)"
`strident	Suffix	"AJ(`strident ,)"
`stringent	Suffix	"AJ(`stringent ,)"
`stripy	Suffix	"AJ(`stripe ,denom)"
`strong	Suffix	"AJ(`strong ,)"
`stubborn	Suffix	"AJ(`stubborn ,)"
`stuffy	Suffix	"AJ(`stuffy ,)"
stu`pendous	Suffix	"AJ(stu`pendous ,)"
`stupid	Suffix	"AJ(`stupid ,)"
`sturdy	Suffix	"AJ(`sturdy ,)"
`stylish	Suffix	"AJ(`style ,denom)"
`suave	Suffix	"AJ(`suave ,)"
sub`jective	Suffix	"AJ(sub`jective ,)"
sub`lime	Suffix	"AJ(sub`lime ,)"
sub`liminal	Suffix	"AJ(sub`liminal ,)"
sub`missive	Suffix	"AJ(sub`mit ,deverb)"
sub`servient	Suffix	"AJ(sub`servient ,)"
sub`stantial	Suffix	"AJ(`substance ,denom)"
substi`tutionary	Suffix	"AJ(`substitute ,deverb)"
subter`ranean	Suffix	"AJ(subter`ranean ,)"
subter`raneous	Suffix	"AJ(subter`raneous ,)"
`subtle	Suffix	"AJ(`subtle ,)"
sub`versive	Suffix	"AJ(sub`vert ,deverb)"
suc`cessive	Suffix	"AJ(suc`ceed ,deverb)"
suc`cinct	Suffix	"AJ(suc`cinct ,)"
`succulent	Suffix	"AJ(`succulent ,)"
`suchlike	Suffix	"AJ(`suchlike ,)"
`sudden	Suffix	"AJ(`sudden ,)"
suf`ficient	Suffix	"AJ(suf`fice ,deverb)"
`sulfa	Suffix	"AJ(`sulfa ,)"
`sulky	Suffix	"AJ(`sulky ,)"
`sullen	Suffix	"AJ(`sullen ,)"
`sultry	Suffix	"AJ(`sultry ,)"
`sumptuous	Suffix	"AJ(`sumptuous ,)"
`sunburnt	Suffix	"AJ(`sunburnt ,)"
`sundry	Suffix	"AJ(`sundry ,)"
`sunken	Suffix	"AJ(`sink ,deverb)"
`sunlit	Suffix	"AJ(`sunlit ,)"
`sunshiny	Suffix	"AJ(`sunshine ,denom)"
`super	Suffix	"AJ(`super ,)"
su`perb	Suffix	"AJ(su`perb ,)"
super`cilious	Suffix	"AJ(super`cilious ,)"
super`ficial	Suffix	"AJ(super`ficial ,)"
su`perfluous	Suffix	"AJ(su`perfluous ,)"
su`pernal	Suffix	"AJ(su`pernal ,)"
super`stitious	Suffix	"AJ(super`stitious ,)"
`supine	Suffix	"AJ(`supine ,)"
`supple	Suffix	"AJ(`supple ,)"
supple`mentary	Suffix	"AJ(`supplement ,denom)"
su`preme	Suffix	"AJ(su`preme ,)"
sure`footed	Suffix	"AJ(`foot ,denom)"
`surgical	Suffix	"AJ(`surgical ,)"
`surly	Suffix	"AJ(`surly ,)"
sur`real	Suffix	"AJ(`real ,)"
surrep`titious	Suffix	"AJ(surrep`titious ,)"
sus`ceptible	Suffix	"AJ(sus`ceptible ,)"
sus`picious	Suffix	"AJ(sus`picious ,)"
`svelte	Suffix	"AJ(`svelte ,)"
`swank	Suffix	"AJ(`swank ,)"
`swanky	Suffix	"AJ(`swanky ,)"
`swart	Suffix	"AJ(`swart ,)"
`swarthy	Suffix	"AJ(`swarthy ,)"
`swift	Suffix	"AJ(`swift ,)"
`swishy	Suffix	"AJ(`swish ,deverb)"
syl`labic	IC_Suffix	"AJ(`syllable ,denom)"
syllo`gistic	IC_Suffix	"AJ(syllo`gistic ,)"
`sylvan	Suffix	"AJ(`sylvan ,)"
symbi`otic	IC_Suffix	"AJ(symbi`otic ,)"
sym`bolic	IC_Suffix	"AJ(`symbol ,denom)"
sym`metric	IC_Suffix	"AJ(`symmetry ,denom)"
sympa`thetic	IC_Suffix	"AJ(`sympathy ,denom)"
sym`phonic	IC_Suffix	"AJ(`symphony ,denom)"
sympto`matic	IC_Suffix	"AJ(sympto`matic ,)"
syn`aptic	IC_Suffix	"AJ(syn`apsis ,denom)"
syn`chronic	Suffix	"AJ(`synchrony ,denom)"
`synchronous	Suffix	"AJ(`synchrony ,denom)"
syner`gistic	IC_Suffix	"AJ(`synergy ,denom)"
syn`onymous	Suffix	"AJ(sy`nonymy ,denom)"
syn`optic	IC_Suffix	"AJ(syn`optic ,)"
syn`tactic	IC_Suffix	"AJ(`syntax ,denom)"
syn`thetic	IC_Suffix	"AJ(syn`thetic ,)"
`syrupy	Suffix	"AJ(`syrup ,denom)"
system`atic	IC_Suffix	"AJ(system`atic ,)"
sys`temic	IC_Suffix	"AJ(`system ,denom)"
`tabular	Suffix	"AJ(`table ,denom)"
`tacit	Suffix	"AJ(`tacit ,)"
`taciturn	Suffix	"AJ(`taciturn ,)"
`tacky	Suffix	"AJ(`tacky ,)"
`tactile	Suffix	"AJ(`tactile ,)"
`talkative	Suffix	"AJ(`talk ,deverb)"
`tall	Suffix	"AJ(`tall ,)"
`tangible	Suffix	"AJ(`tangible ,)"
`tantamount	Suffix	"AJ(`tantamount ,)"
`tardy	Suffix	"AJ(`tardy ,)"
`tasty	Suffix	"AJ(`taste ,denom)"
`tatty	Suffix	"AJ(`tatty ,)"
`taut	Suffix	"AJ(`taut ,)"
`tawdry	Suffix	"AJ(`tawdry ,)"
`tawny	Suffix	"AJ(`tawny ,)"
`taxpaying	Suffix	"AJ(`taxpaying ,)"
`technical	Suffix	"AJ(`technical ,)"
tec`tonic	IC_Suffix	"AJ(tec`tonic ,)"
`tedious	Suffix	"AJ(`tedious ,)"
`teenage	Suffix	"AJ(`teenage ,)"
`teenaged	Suffix	"AJ(`teenage ,)"
`teensy	Suffix	"AJ(`teensy ,)"
`teetotal	Suffix	"AJ(`teetotal ,)"
`telltale	Suffix	"AJ(`telltale ,)"
tem`pestuous	Suffix	"AJ(`tempest ,denom)"
`temperate	Suffix	"AJ(`temperate ,)"
`temporal	Suffix	"AJ(`temporal ,)"
`temporary	Suffix	"AJ(`temporary ,)"
`tenable	Suffix	"AJ(`tenable ,)"
ten`acious	Suffix	"AJ(ten`acious ,)"
ten`dencious	Suffix	"AJ(ten`dencious ,)"
ten`dentious	Suffix	"AJ(ten`dentious ,)"
`tender	Suffix	"AJ(`tender ,)"
tender`hearted	Suffix	"AJ(`heart ,denom)"
`tenebrous	Suffix	"AJ(`tenebrous ,)"
`tensile	Suffix	"AJ(`tensile ,)"
`tentative	Suffix	"AJ(`tentative ,)"
`tenuous	Suffix	"AJ(`tenuous ,)"
`tepid	Suffix	"AJ(`tepid ,)"
`terminable	Suffix	"AJ(`terminate ,deverb)"
`terminal	Suffix	"AJ(`terminal ,)"
`ternary	Suffix	"AJ(`ternary ,)"
`terrible	Suffix	"AJ(`terrible ,)"
ter`rific	IC_Suffix	"AJ(ter`rific ,)"
`terse	Suffix	"AJ(`terse ,)"
`tertiary	Suffix	"AJ(`tertiary ,)"
testa`mentary	Suffix	"AJ(`testament ,denom)"
`testate	Suffix	"AJ(`testate ,)"
tes`ticular	Suffix	"AJ(`testicle ,denom)"
`testy	Suffix	"AJ(`testy ,)"
`thankful	Suffix	"AJ(`thank ,deverb)"
`thankless	Suffix	"AJ(`thank ,deverb)"
the`atric	IC_Suffix	"AJ(`theater ,denom)"
theo`retic	IC_Suffix	"AJ(`theory ,denom)"
the`matic	IC_Suffix	"AJ(`theme ,denom)"
thera`peutic	IC_Suffix	"AJ(`therapy ,denom)"
`thermal	Suffix	"AJ(`thermal ,)"
`thespian	Suffix	"AJ(`thespian ,)"
`thick	Suffix	"AJ(`thick ,)"
`thieving	Suffix	"AJ(`thieving ,)"
`thorough	Suffix	"AJ(`thorough ,)"
`thoroughgoing	Suffix	"AJ(`thoroughgoing ,)"
`threadbare	Suffix	"AJ(`threadbare ,)"
three`legged	Suffix	"AJ(`leg ,denom)"
`thunderstruck	Suffix	"AJ(`thunderstruck ,)"
`ticklish	Suffix	"AJ(`tickle ,deverb)"
`tight	Suffix	"AJ(`tight ,)"
`timeworn	Suffix	"AJ(`timeworn ,)"
`timid	Suffix	"AJ(`timid ,)"
`tingly	Suffix	"AJ(`tingle ,deverb)"
`tiny	Suffix	"AJ(`tiny ,)"
`tippy	Suffix	"AJ(`tip ,deverb)"
`tipsy	Suffix	"AJ(`tipsy ,)"
`tiresome	Suffix	"AJ(`tire ,deverb)"
`titian	Suffix	"AJ(`titian ,)"
`titular	Suffix	"AJ(`title ,denom)"
`toilsome	Suffix	"AJ(`toil ,deverb)"
`tolerable	Suffix	"AJ(`tolerate ,deverb)"
`tolerant	Suffix	"AJ(`tolerant ,)"
`tony	Suffix	"AJ(`tony ,)"
`toothsome	Suffix	"AJ(`tooth ,denom)"
`topgallant	Suffix	"AJ(`topgallant ,)"
`topnotch	Suffix	"AJ(`topnotch ,)"
`torpid	Suffix	"AJ(`torpid ,)"
`torrid	Suffix	"AJ(`torrid ,)"
`tortuous	Suffix	"AJ(`torture ,denom)"
`total	Suffix	"AJ(`total ,)"
`tough	Suffix	"AJ(`tough ,)"
`toxic	IC_Suffix	"AJ(`toxic ,)"
`tractable	Suffix	"AJ(`tractable ,)"
`tragic	IC_Suffix	"AJ(`tragic ,)"
tragi`comic	IC_Suffix	"AJ(tragi`comic ,)"
`tranquil	Suffix	"AJ(`tranquil ,)"
trans`alpine	Suffix	"AJ(`alpine ,)"
transat`lantic	Suffix	"AJ(at`lantic ,)"
transcen`dental	Suffix	"AJ(tran`scend ,deverb)"
transconti`nental	Suffix	"AJ(`continent ,denom)"
trans`ferable	Suffix	"AJ(trans`fer ,deverb)"
`transient	Suffix	"AJ(`transient ,)"
trans`lucent	Suffix	"AJ(trans`lucent ,)"
trans`missible	Suffix	"AJ(trans`mit ,deverb)"
transoce`anic	IC_Suffix	"AJ(`ocean ,denom)"
transpa`cific	IC_Suffix	"AJ(pa`cific ,)"
trans`parent	Suffix	"AJ(trans`parent ,)"
trans`versal	Suffix	"AJ(trans`versal ,)"
trans`verse	Suffix	"AJ(trans`verse ,)"
trau`matic	IC_Suffix	"AJ(`trauma ,denom)"
`treacherous	Suffix	"AJ(`treachery ,denom)"
`trembly	Suffix	"AJ(`tremble ,deverb)"
tre`mendous	Suffix	"AJ(tre`mendous ,)"
`tremulous	Suffix	"AJ(`tremulous ,)"
`trenchant	Suffix	"AJ(`trenchant ,)"
tri`ennial	Suffix	"AJ(tri`ennial ,)"
`trim	Suffix	"AJ(`trim ,)"
tri`partite	Suffix	"AJ(tri`partite ,)"
`triplex	Suffix	"AJ(`triplex ,)"
`trite	Suffix	"AJ(`trite ,)"
tri`une	Suffix	"AJ(tri`une ,)"
tri`valent	Suffix	"AJ(tri`valent ,)"
`trivial	Suffix	"AJ(`trivial ,)"
`troublesome	Suffix	"AJ(`trouble ,denom)"
`troy	Suffix	"AJ(`troy ,)"
`truculent	Suffix	"AJ(`truculent ,)"
`true	Suffix	"AJ(`true ,)"
`tubular	Suffix	"AJ(`tube ,denom)"
tu`mescent	Suffix	"AJ(tu`mescent ,)"
tu`multuous	Suffix	"AJ(`tumult ,denom)"
`turbid	Suffix	"AJ(`turbid ,)"
`turbulent	Suffix	"AJ(`turbulent ,)"
`turgid	Suffix	"AJ(`turgid ,)"
`typic	IC_Suffix	"AJ(`type ,denom)"
ty`rannic	IC_Suffix	"AJ(`tyranny ,denom)"
`twinkly	Suffix	"AJ(`twinkle ,deverb)"
u`biquitous	Suffix	"AJ(u`biquitous ,)"
`ugly	Suffix	"AJ(`ugly ,)"
ul`terior	Suffix	"AJ(ul`terior ,)"
`ultimate	Suffix	"AJ(`ultimate ,)"
`ultra	Suffix	"AJ(`ultra ,)"
um`bilical	Suffix	"AJ(um`bilical ,)"
u`nanimous	Suffix	"AJ(u`nanimous ,)"
`unary	Suffix	"AJ(`unary ,)"
unbe`known	Suffix	"AJ(`know ,deverb)"
unbe`knownst	Suffix	"AJ(`know ,deverb)"
`unctuous	Suffix	"AJ(`unctuous ,)"
un`couth	Suffix	"AJ(un`couth ,)"
undecomposable	Suffix	"AJ(com`pose ,deverb)"
`undulant	Suffix	"AJ(`undulant ,)"
unfor`seen	Suffix	"AJ(unfor`seen ,)"
u`nique	Suffix	"AJ(u`nique ,)"
`unitary	Suffix	"AJ(`unit ,denom)"
uni`valent	Suffix	"AJ(uni`valent ,)"
uni`variate	Suffix	"AJ(uni`variate ,)"
un`kempt	Suffix	"AJ(un`kempt ,)"
un`ruly	Suffix	"AJ(un`ruly ,)"
un`stinting	Suffix	"AJ(un`stinting ,)"
un`toward	Suffix	"AJ(un`toward ,)"
un`wieldy	Suffix	"AJ(un`wieldy ,)"
un`witting	Suffix	"AJ(un`witting ,)"
`up	Suffix	"AJ(`up ,)"
`upbeat	Suffix	"AJ(`upbeat ,)"
`upcoming	Suffix	"AJ(`upcoming ,)"
up`hill	Suffix	"AJ(up`hill ,)"
`upper	Suffix	"AJ(`upper ,)"
`uppercase	Suffix	"AJ(`uppercase ,)"
up`roarious	Suffix	"AJ(up`roarious ,)"
upside-`down	Suffix	"AJ(upside-`down ,)"
up`standing	Suffix	"AJ(up`standing ,)"
`urban	Suffix	"AJ(`urban ,)"
ur`bane	Suffix	"AJ(ur`bane ,)"
`urinary	Suffix	"AJ(`urine ,denom)"
`usual	Suffix	"AJ(`usual ,)"
`uterine	Suffix	"AJ(`uterine ,)"
`utile	Suffix	"AJ(`utile ,)"
u`topian	Suffix	"AJ(u`topia ,denom)"
`utter	Suffix	"AJ(`utter ,)"
`uvular	Suffix	"AJ(`uvula ,denom)"
ux`orial	Suffix	"AJ(ux`orial ,)"
ux`orious	Suffix	"AJ(ux`orious ,)"
`vacant	Suffix	"AJ(`vacant ,)"
`vacuous	Suffix	"AJ(`vacuous ,)"
`vaginal	Suffix	"AJ(va`gina ,denom)"
`vague	Suffix	"AJ(`vague ,)"
`vain	Suffix	"AJ(`vain ,)"
vale`dictory	Suffix	"AJ(vale`dictory ,)"
`valiant	Suffix	"AJ(`valiant ,)"
`valid	Suffix	"AJ(`valid ,)"
`vapid	Suffix	"AJ(`vapid ,)"
`varicolored	Suffix	"AJ(`varicolored ,)"
`varicose	Suffix	"AJ(`varicose ,)"
`various	Suffix	"AJ(`vary ,deverb)"
`vascular	Suffix	"AJ(`vascular ,)"
`vast	Suffix	"AJ(`vast ,)"
`vehement	Suffix	"AJ(`vehement ,)"
ve`hicular	Suffix	"AJ(`vehicle ,denom)"
`venal	Suffix	"AJ(`venal ,)"
`venerable	Suffix	"AJ(`venerate ,deverb)"
ve`nereal	Suffix	"AJ(ve`nereal ,)"
`vengeful	Suffix	"AJ(`venge ,deverb)"
`venial	Suffix	"AJ(`venial ,)"
`venous	Suffix	"AJ(`venous ,)"
`ventral	Suffix	"AJ(`ventral ,)"
`venturesome	Suffix	"AJ(`venture ,deverb)"
ve`racious	Suffix	"AJ(ve`racious ,)"
ver`bose	Suffix	"AJ(ver`bose ,)"
ver`boten	Suffix	"AJ(ver`boten ,)"
`verdant	Suffix	"AJ(`verdant ,)"
ve`ridical	Suffix	"AJ(ve`ridical ,)"
`veritable	Suffix	"AJ(`veritable ,)"
`vernal	Suffix	"AJ(`vernal ,)"
`versatile	Suffix	"AJ(`versatile ,)"
`vertebral	Suffix	"AJ(`vertebral ,)"
`vertical	Suffix	"AJ(`vertical ,)"
ver`tiginous	Suffix	"AJ(`vertigo ,denom)"
ve`sicular	Suffix	"AJ(`vesicle ,denom)"
`vesper	Suffix	"AJ(`vesper ,)"
`vestal	Suffix	"AJ(`vesta ,denom)"
`veterinary	Suffix	"AJ(`veterinary ,)"
vex`atious	Suffix	"AJ(`vex ,deverb)"
`viable	Suffix	"AJ(`viable ,)"
vi`carious	Suffix	"AJ(vi`carious ,)"
`vicinal	Suffix	"AJ(`vicinal ,)"
`vicious	Suffix	"AJ(`vicious ,)"
`vigilant	Suffix	"AJ(`vigil ,denom)"
`vile	Suffix	"AJ(`vile ,)"
`vincible	Suffix	"AJ(`vincible ,)"
`vindicable	Suffix	"AJ(`vindicate ,deverb)"
vin`dictive	Suffix	"AJ(vin`dictive ,)"
`violable	Suffix	"AJ(`violate ,deverb)"
`violent	Suffix	"AJ(`violent ,)"
`viral	Suffix	"AJ(`virus ,denom)"
`virile	Suffix	"AJ(`virile ,)"
`virtual	Suffix	"AJ(`virtual ,)"
`virulent	Suffix	"AJ(`virulent ,)"
`visceral	Suffix	"AJ(`viscus ,denom)"
`viscous	Suffix	"AJ(`viscous ,)"
`visible	Suffix	"AJ(`visible ,)"
`visionary	Suffix	"AJ(`vision ,denom)"
`vital	Suffix	"AJ(`vital ,)"
`vitreous	Suffix	"AJ(`vitreous ,)"
vi`vacious	Suffix	"AJ(vi`vacious ,)"
`vivid	Suffix	"AJ(`vivid ,)"
vi`viparous	Suffix	"AJ(vi`viparous ,)"
vo`calic	IC_Suffix	"AJ(vo`calic ,)"
vo`ciferous	Suffix	"AJ(vo`ciferous ,)"
`volatile	Suffix	"AJ(`volatile ,)"
vol`canic	IC_Suffix	"AJ(vol`cano ,denom)"
vol`taic	IC_Suffix	"AJ(vol`taic ,)"
`voluble	Suffix	"AJ(`voluble ,)"
vo`luminous	Suffix	"AJ(`volume ,denom)"
`voluntary	Suffix	"AJ(`voluntary ,)"
vo`luptuous	Suffix	"AJ(vo`luptuous ,)"
vo`racious	Suffix	"AJ(vo`racious ,)"
`votive	Suffix	"AJ(`votive ,)"
`vulgar	Suffix	"AJ(`vulgar ,)"
`vulnerable	Suffix	"AJ(`vulnerable ,)"
`vulpine	Suffix	"AJ(`vulpine ,)"
`wacky	Suffix	"AJ(`wacky ,)"
`wakeup	Suffix	"AJ(`wakeup ,)"
`wan	Suffix	"AJ(`wan ,)"
`wanton	Suffix	"AJ(`wanton ,)"
warm`hearted	Suffix	"AJ(`heart ,denom)"
`wary	Suffix	"AJ(`wary ,)"
`waterproof	Suffix	"AJ(`waterproof ,)"
`watertight	Suffix	"AJ(`watertight ,)"
`wavy	Suffix	"AJ(`wave ,denom)"
`waxen	Suffix	"AJ(`wax ,denom)"
`wayfaring	Suffix	"AJ(`wayfaring ,)"
`wayward	Suffix	"AJ(`wayward ,)"
`weak	Suffix	"AJ(`weak ,)"
`wearisome	Suffix	"AJ(`wearisome ,)"
`weatherbeaten	Suffix	"AJ(`weatherbeaten ,)"
`weatherproof	Suffix	"AJ(`weatherproof ,)"
`wee	Suffix	"AJ(`wee ,)"
`weepy	Suffix	"AJ(`weep ,deverb)"
`weird	Suffix	"AJ(`weird ,)"
`well	Suffix	"AJ(`well - healthy,)"
`westbound	Suffix	"AJ(`westbound ,)"
`wet	Suffix	"AJ(`wet ,)"
`wheezy	Suffix	"AJ(`wheeze ,deverb)"
`whimsical	Suffix	"AJ(`whimsy ,denom)"
`whiny	Suffix	"AJ(`whine ,deverb)"
whole`hearted	Suffix	"AJ(`heart ,denom)"
`wholesome	Suffix	"AJ(`whole ,denom)"
`wholly	Suffix	"AJ(`whole ,denom)"
`wicked	Suffix	"AJ(`wicked ,)"
`wide	Suffix	"AJ(`wide ,)"
`widemouthed	Suffix	"AJ(`mouth ,denom)"
wide`spread	Suffix	"AJ(wide`spread ,)"
`wierd	Suffix	"AJ(`wierd ,)"
`wiggly	Suffix	"AJ(`wiggle ,deverb)"
`wilful	Suffix	"AJ(`wilful ,)"
`willing	Suffix	"AJ(`willing ,)"
`wily	Suffix	"AJ(`wile ,denom)"
`windblown	Suffix	"AJ(`windblown ,)"
`windswept	Suffix	"AJ(`windswept ,)"
`winsome	Suffix	"AJ(`win ,deverb)"
`wintry	Suffix	"AJ(`winter ,denom)"
`winy	Suffix	"AJ(`wine ,denom)"
`wiry	Suffix	"AJ(`wire ,denom)"
`wise	Suffix	"AJ(`wise ,)"
`wishy-washy	Suffix	"AJ(`wishy-washy ,)"
`wistful	Suffix	"AJ(`wistful ,)"
`wobbly	Suffix	"AJ(`wobble ,deverb)"
`woebegone	Suffix	"AJ(`woebegone ,)"
`wondrous	Suffix	"AJ(`wonder ,denom)"
`wooden	Suffix	"AJ(`wood ,denom)"
`woodsy	Suffix	"AJ(`wood ,denom)"
`woozy	Suffix	"AJ(`woozy ,)"
`workaday	Suffix	"AJ(`workaday ,)"
world`wide	Suffix	"AJ(world`wide ,)"
`worrisome	Suffix	"AJ(`worry ,deverb)"
worth`while	Suffix	"AJ(worth`while ,)"
`wretched	Suffix	"AJ(`wretched ,)"
`wriggly	Suffix	"AJ(`wriggle ,deverb)"
`wroth	Suffix	"AJ(`wroth ,)"
wrong`headed	Suffix	"AJ(`head ,denom)"
`wrought	Suffix	"AJ(`wrought ,)"
`wry	Suffix	"AJ(`wry ,)"
`yon	Suffix	"AJ(`yon ,)"
`young	Suffix	"AJ(`young ,)"
`yummy	Suffix	"AJ(`yummy ,)"
x-rated	Suffix	"AJ(x-rated ,)"
xeno`phobic	Suffix	"AJ(xeno`phobia ,denom)"
`zany	Suffix	"AJ(`zany ,)"
`zingy	Suffix	"AJ(`zingy ,)"
`zippy	Suffix	"AJ(`zippy ,)"
`zippy	Suffix	"AJ(`zippy ,)"
a-la-grecque	End	"AJ(a-la-grecque ,)"
a-la-king	End	"AJ(a-la-king ,)"
a-la-mode	End	"AJ(a-la-mode ,)"
au-courant	End	"AJ(au-courant ,)"
bona-fide	End	"AJ(bona-fide ,)"
de-rigueur	End	"AJ(de-rigueur ,)"
je-ne-sais-quoi	End	"AJ(je-ne-sais-quoi ,)"
non-compos-mentis	End	"AJ(non-compos-mentis ,)"
pro-forma	End	"AJ(pro-forma ,)"
`Lenten	Suffix	"AJ(`Lent ,proper denom)"
`Saturnine	Suffix	"AJ(`Saturn ,proper denom)"
Au`gustan	Suffix	"AJ(Au`gustus ,proper denom)"
Co`lumbian	Suffix	"AJ(Co`lumbus ,proper denom)"
Co`pernican	Suffix	"AJ(Co`pernicus ,proper denom)"
Eu`clidean	Suffix	"AJ(`Euclid ,proper denom)"
Hercu`lean	Suffix	"AJ(`Hercules ,proper denom)"
`Julian	Suffix	"AJ(`Julias ,proper denom)"
Pla`tonic	IC_Suffix	"AJ(`Plato ,proper denom)"
Pythago`rean	Suffix	"AJ(Py`thagoras ,proper denom)"
`Vedic	Suffix	"AJ(`Veda ,proper denom)"
He`braic	Suffix	"AJ(He`braic ,proper)"
Ju`daic	IC_Suffix	"AJ(Ju`daic ,proper)"
`Latinate	Suffix	"AJ(`Latin ,proper denom)"
`Scots	Suffix	"AJ(`Scots ,proper)"
`Scotch	Suffix	"AJ(`Scotch ,proper)"
`Andean	Suffix	"AJ(`Andes ,proper denom)"
Ant`arctic	Suffix	"AJ(Ant`arctic ,proper)"
Asi`atic	Suffix	"AJ(`Asia ,proper denom)"
Bri`tannic	Suffix	"AJ(`Britain ,proper denom)"
`Byzantine	Suffix	"AJ(By`zantium ,proper denom)"
Czecho`slovak	Suffix	"AJ(Czecho`slovak ,proper)"
`Delphic	IC_Suffix	"AJ(`Delphi ,proper)"
`Flemish	Suffix	"AJ(`Flemish ,proper)"
`Florentine	Suffix	"AJ(`Florence ,proper denom)"
`Philippine	Suffix	"AJ(`Philippine ,proper)"
`Stygian	Suffix	"AJ(`Styx ,proper denom)"
achro`matic	Suffix	"AJ(achro`matic ,)"
ac`tinic	Suffix	"AJ(ac`tinic ,)"
adia`batic	Suffix	"AJ(adia`batic ,)"
ali`phatic	Suffix	"AJ(ali`phatic ,)"
`aliquot	Suffix	"AJ(`aliquot ,)"
allo`tropic	Suffix	"AJ(allo`tropic ,)"
ame`thystine	Suffix	"AJ(ame`thystine ,)"
anae`robic	IC_Suffix	"AJ(anae`robic ,)"
ana`morphic	Suffix	"AJ(ana`morphic ,)"
anasto`motic	Suffix	"AJ(anasto`motic ,)"
anhar`monic	Suffix	"AJ(anhar`monic ,)"
an`hydrous	Suffix	"AJ(an`hydrous ,)"
anisei`konic	Suffix	"AJ(anisei`konic ,)"
aniso`tropic	Suffix	"AJ(aniso`tropic ,)"
a`northic	Suffix	"AJ(a`northic ,)"
are`naceous	Suffix	"AJ(are`naceous ,)"
argil`laceous	Suffix	"AJ(argil`laceous ,)"
bary`centric	Suffix	"AJ(bary`centric ,)"
bire`fringent	Suffix	"AJ(bire`fringent ,)"
carbo`naceous	Suffix	"AJ(carbo`naceous ,)"
col`loidal	Suffix	"AJ(col`loidal ,)"
co`valent	Suffix	"AJ(co`valent ,)"
co`varient	Suffix	"AJ(co`varient ,)"
curvi`linear	Suffix	"AJ(curvi`linear ,)"
cy`anic	Suffix	"AJ(cy`anic ,)"
deoxyribonu`cleic	Suffix	"AJ(deoxyribonu`cleic ,)"
di`hedral	Suffix	"AJ(di`hedral ,)"
di`methyl	Suffix	"AJ(di`methyl ,)"
dodeca`hedral	Suffix	"AJ(dodeca`hedral ,)"
e`dematous	Suffix	"AJ(e`dematous ,)"
emphy`sematous	Suffix	"AJ(emphy`sematous ,)"
en`dogamous	Suffix	"AJ(en`dogamous ,)"
en`dogenous	Suffix	"AJ(en`dogenous ,)"
endo`thelial	Suffix	"AJ(endo`thelial ,)"
endo`thermic	Suffix	"AJ(endo`thermic ,)"
epi`physeal	Suffix	"AJ(epi`physeal ,)"
epi`thelial	Suffix	"AJ(epi`thelial ,)"
er`godic	Suffix	"AJ(er`godic ,)"
eu`tectic	Suffix	"AJ(eu`tectic ,)"
ex`ogamous	Suffix	"AJ(ex`ogamous ,)"
ex`ogenous	Suffix	"AJ(ex`ogenous ,)"
exo`thermic	Suffix	"AJ(exo`thermic ,)"
fal`lopian	Suffix	"AJ(fal`lopian ,)"
fas`cicular	Suffix	"AJ(fas`cicular ,)"
ferroe`lectric	Suffix	"AJ(ferroe`lectric ,)"
fer`ruginous	Suffix	"AJ(fer`ruginous ,)"
`fissile	Suffix	"AJ(`fissile ,)"
fol`licular	Suffix	"AJ(fol`licular ,)"
`formic	Suffix	"AJ(`formic ,)"
fossi`liferous	Suffix	"AJ(fossi`liferous ,)"
`friable	Suffix	"AJ(`friable ,)"
`gastric	IC_Suffix	"AJ(`gastric ,)"
gastroin`testinal	Suffix	"AJ(gastroin`testinal ,)"
glo`merular	Suffix	"AJ(glo`merular ,)"
hebe`phrenic	Suffix	"AJ(hebe`phrenic ,)"
helio`centric	Suffix	"AJ(helio`centric ,)"
`heterodyne	Suffix	"AJ(`heterodyne ,)"
hete`rogamous	Suffix	"AJ(hete`rogamous ,)"
hetero`zygous	Suffix	"AJ(hetero`zygous ,)"
homeo`morphic	Suffix	"AJ(homeo`morphic ,)"
ho`mologous	Suffix	"AJ(ho`mologous ,)"
homo`morphic	Suffix	"AJ(homo`morphic ,)"
homo`zygous	Suffix	"AJ(homo`zygous ,)"
`hyaline	Suffix	"AJ(`hyaline ,)"
hydro`chloric	IC_Suffix	"AJ(hydro`chloric ,)"
hydro`dynamic	IC_Suffix	"AJ(hydro`dynamic ,)"
hydro`fluoric	Suffix	"AJ(hydro`fluoric ,)"
hydro`static	IC_Suffix	"AJ(hydro`static ,)"
hydro`thermal	Suffix	"AJ(hydro`thermal ,)"
`hydrous	Suffix	"AJ(`hydrous ,)"
hy`droxy	Suffix	"AJ(hy`droxy ,)"
hygro`scopic	Suffix	"AJ(hygro`scopic ,)"
hypo`physeal	Suffix	"AJ(hypo`physeal ,)"
hypo`thalamic	Suffix	"AJ(hypo`thalamic ,)"
hypo`thyroid	Suffix	"AJ(hypo`thyroid ,)"
icosa`hedral	Suffix	"AJ(icosa`hedral ,)"
i`dempotent	Suffix	"AJ(i`dempotent ,)"
`iliac	Suffix	"AJ(`iliac ,)"
ipsi`lateral	Suffix	"AJ(ipsi`lateral ,)"
isen`tropic	Suffix	"AJ(isen`tropic ,)"
i`sochronal	Suffix	"AJ(i`sochronal ,)"
i`sochronous	Suffix	"AJ(i`sochronous ,)"
iso`clinal	Suffix	"AJ(iso`clinal ,)"
iso`morphic	Suffix	"AJ(iso`morphic ,)"
iso`tropic	Suffix	"AJ(iso`tropic ,)"
kine`matic	Suffix	"AJ(kine`matic ,)"
ki`nesic	Suffix	"AJ(ki`nesic ,)"
la`custrine	Suffix	"AJ(la`custrine ,)"
la`mellar	Suffix	"AJ(la`mellar ,)"
`laminar	Suffix	"AJ(`laminar ,)"
`lithic	Suffix	"AJ(`lithic ,)"
`littoral	Suffix	"AJ(`littoral ,)"
`lobar	Suffix	"AJ(`lobar ,)"
`lobular	Suffix	"AJ(`lobular ,)"
loco`motor	Suffix	"AJ(loco`motor ,)"
loco`motory	Suffix	"AJ(loco`motory ,)"
`lossy	Suffix	"AJ(`lossy ,)"
`lunate	Suffix	"AJ(`lunate ,)"
ly`sergic	Suffix	"AJ(ly`sergic ,)"
macro`scopic	Suffix	"AJ(macro`scopic ,)"
mesen`teric	Suffix	"AJ(mesen`teric ,)"
metal`liferous	Suffix	"AJ(metal`liferous ,)"
meteo`ritic	Suffix	"AJ(meteo`ritic ,)"
neuro`muscular	Suffix	"AJ(neuro`muscular ,)"
multi`nomial	Suffix	"AJ(multi`nomial ,)"
muri`atic	Suffix	"AJ(muri`atic ,)"
`myeloid	Suffix	"AJ(`myeloid ,)"
myo`cardial	Suffix	"AJ(myo`cardial ,)"
neo`lithic	Suffix	"AJ(neo`lithic ,)"
neuras`thenic	Suffix	"AJ(neuras`thenic ,)"
neuropsychi`atric	Suffix	"AJ(neuropsychi`atric ,)"
`nilpotent	Suffix	"AJ(`nilpotent ,)"
`nitric	Suffix	"AJ(`nitric ,)"
`nitrous	Suffix	"AJ(`nitrous ,)"
nu`cleic	Suffix	"AJ(nu`cleic ,)"
oph`thalmic	Suffix	"AJ(oph`thalmic ,)"
ortho`normal	Suffix	"AJ(ortho`normal ,)"
ortho`rhombic	Suffix	"AJ(ortho`rhombic ,)"
ox`alic	Suffix	"AJ(ox`alic ,)"
`palmate	Suffix	"AJ(`palmate ,)"
phos`phoric	IC_Suffix	"AJ(`phosphorus ,denom)"
physio`chemical	Suffix	"AJ(physio`chemical ,)"
piezoe`lectric	Suffix	"AJ(piezoe`lectric ,)"
`pinnate	Suffix	"AJ(`pinnate ,)"
planocon`cave	Suffix	"AJ(planocon`cave ,)"
planocon`vex	Suffix	"AJ(planocon`vex ,)"
proteo`lytic	Suffix	"AJ(proteo`lytic ,)"
pyroe`lectric	Suffix	"AJ(pyroe`lectric ,)"
`quadric	Suffix	"AJ(`quadric ,)"
`quartic	Suffix	"AJ(`quartic ,)"
`quintic	Suffix	"AJ(`quintic ,)"
recti`linear	Suffix	"AJ(recti`linear ,)"
`rhombic	Suffix	"AJ(`rhombic ,)"
rhombo`hedral	Suffix	"AJ(rhombo`hedral ,)"
ribonu`cleic	Suffix	"AJ(ribonu`cleic ,)"
`sagittal	Suffix	"AJ(`sagittal ,)"
scle`rotic	Suffix	"AJ(scle`rotic ,)"
sensori`motor	Suffix	"AJ(sensori`motor ,)"
si`liceous	Suffix	"AJ(si`liceous ,)"
si`licic	Suffix	"AJ(si`licic ,)"
`staminate	Suffix	"AJ(`staminate ,)"
`stannic	Suffix	"AJ(`stannic ,)"
`stannous	Suffix	"AJ(`stannous ,)"
stra`bismic	Suffix	"AJ(stra`bismic ,)"
strobo`scopic	Suffix	"AJ(strobo`scopic ,)"
super`lunary	Suffix	"AJ(super`lunary ,)"
tech`tonic	Suffix	"AJ(tech`tonic ,)"
terato`genic	Suffix	"AJ(terato`genic ,)"
te`tragonal	Suffix	"AJ(te`tragonal ,)"
tetra`hedral	Suffix	"AJ(tetra`hedral ,)"
tetra`valent	Suffix	"AJ(tetra`valent ,)"
`thalamic	IC_Suffix	"AJ(`thalamus ,denom)"
topo`centric	Suffix	"AJ(topo`centric ,)"
tri`gonal	Suffix	"AJ(tri`gonal ,)"
tri`hedral	Suffix	"AJ(tri`hedral ,)"
`trophic	Suffix	"AJ(`trophic ,)"
viscoe`lastic	Suffix	"AJ(viscoe`lastic ,)"

AJ-V:
`absent	Suffix	"AJ-V(`absent ,)"
ap`proximate	Suffix	"AJ-V(ap`proximate - [-@t],)"
ar`ticulate	Suffix	"AJ-V(ar`ticulate - [-@t],)"
`bald	Suffix	"AJ-V(`bald ,)"
`bankrupt	Suffix	"AJ-V(`bankrupt ,)"
`blind	Suffix	"AJ-V(`blind ,)"
`blunt	Suffix	"AJ-V(`blunt ,)"
`brave	Suffix	"AJ-V(`brave ,)"
`brazen	Suffix	"AJ-V(`brazen ,)"
`busy	Suffix	"AJ-V(`busy ,)"
`calm	Suffix	"AJ-V(`calm ,)"
`clean	Suffix	"AJ-V(`clean ,)"
com`pact	Suffix	"AJ-V(com`pact ,)"
com`plete	Suffix	"AJ-V(com`plete ,)"
`consummate	Suffix	"AJ-V(`consummate ,)"
`cool	Suffix	"AJ-V(`cool ,)"
co`ordinate	Suffix	"AJ-V(co`ordinate ,)"
cor`rect	Suffix	"AJ-V(cor`rect ,)"
cor`rupt	Suffix	"AJ-V(cor`rupt ,)"
`counterfeit	Suffix	"AJ-V(`counterfeit ,)"
de`generate	Suffix	"AJ-V(de`generate ,)"
de`liberate	Suffix	"AJ-V(de`liberate - [-@t],)"
`desolate	Suffix	"AJ-V(`desolate ,)"
`dim	Suffix	"AJ-V(`dim ,)"
`dizzy	Suffix	"AJ-V(`dizzy ,)"
`double	Suffix	"AJ-V(`double ,rev)"
`dry	Suffix	"AJ-V(`dry ,)"
`dull	Suffix	"AJ-V(`dull ,)"
`duplicate	Suffix	"AJ-V(`duplicate - [-@t],)"
e`laborate	Suffix	"AJ-V(e`laborate ,)"
`empty	Suffix	"AJ-V(`empty ,)"
`equal	Suffix	"AJ-V(`equal ,)"
e`rect	Suffix	"AJ-V(e`rect ,)"
`even	Suffix	"AJ-V(`even ,)"
ex`empt	Suffix	"AJ-V(ex`empt ,)"
`federate	Suffix	"AJ-V(`federate ,)"
`firm	Suffix	"AJ-V(`firm ,)"
`fleet	Suffix	"AJ-V(`fleet ,)"
`foul	Suffix	"AJ-V(`foul ,)"
`free	Suffix	"AJ-V(`free ,)"
`freelance	Suffix	"AJ-V(`freelance ,)"
free`standing	Suffix	"AJ-V(free`standing ,)"
`frequent	Suffix	"AJ-V(`frequent ,)"
`geminate	Suffix	"AJ-V(`geminate ,)"
`hollow	Suffix	"AJ-V(`hollow ,)"
`humble	Suffix	"AJ-V(`humble ,)"
`idle	Suffix	"AJ-V(`idle ,)"
in`carnate	Suffix	"AJ-V(in`carnate ,)"
`lavish	Suffix	"AJ-V(`lavish ,)"
`level	Suffix	"AJ-V(`level ,)"
`limber	Suffix	"AJ-V(`limber ,)"
`loose	Suffix	"AJ-V(`loose ,rev)"
`manifest	Suffix	"AJ-V(`manifest ,)"
ma`ture	Suffix	"AJ-V(ma`ture ,)"
`mellow	Suffix	"AJ-V(`mellow ,)"
`moderate	Suffix	"AJ-V(`moderate ,)"
`narrow	Suffix	"AJ-V(`narrow ,)"
`near	Suffix	"AJ-V(`near ,)"
`numb	Suffix	"AJ-V(`numb ,)"
ob`scure	Suffix	"AJ-V(ob`scure ,)"
`open	Suffix	"AJ-V(`open ,)"
`pale	Suffix	"AJ-V(`pale ,)"
`parallel	Suffix	"AJ-V(`parallel ,)"
pro`fane	Suffix	"AJ-V(pro`fane ,)"
`prostrate	Suffix	"AJ-V(`prostrate ,)"
qua`druple	Suffix	"AJ-V(qua`druple ,)"
`quiet	Suffix	"AJ-V(`quiet ,)"
`ready	Suffix	"AJ-V(`ready ,)"
`rough	Suffix	"AJ-V(`rough ,)"
`round	Suffix	"AJ-V(`round ,rev)"
se`cure	Suffix	"AJ-V(se`cure ,)"
se`date	Suffix	"AJ-V(se`date ,)"
`separate	Suffix	"AJ-V(`separate ,)"
`seriate	Suffix	"AJ-V(`seriate ,)"
`short	Suffix	"AJ-V(`short ,)"
`slack	Suffix	"AJ-V(`slack ,)"
`slick	Suffix	"AJ-V(`slick ,)"
`slow	Suffix	"AJ-V(`slow ,)"
`smooth	Suffix	"AJ-V(`smooth ,)"
`sober	Suffix	"AJ-V(`sober ,)"
`sour	Suffix	"AJ-V(`sour ,)"
`spruce	Suffix	"AJ-V(`spruce ,)"
`stale	Suffix	"AJ-V(`stale ,)"
`steady	Suffix	"AJ-V(`steady ,)"
`still	Suffix	"AJ-V(`still ,)"
sub`ordinate	Suffix	"AJ-V(sub`ordinate ,)"
`tame	Suffix	"AJ-V(`tame ,)"
`tense	Suffix	"AJ-V(`tense ,)"
`thin	Suffix	"AJ-V(`thin ,)"
`tidy	Suffix	"AJ-V(`tidy ,)"
`treble	Suffix	"AJ-V(`treble ,)"
`triple	Suffix	"AJ-V(`triple ,)"
`triplicate	Suffix	"AJ-V(`triplicate ,)"
`upright	Suffix	"AJ-V(`upright ,)"
`visual	Suffix	"AJ-V(`visual ,)"
`void	Suffix	"AJ-V(`void ,)"
`warm	Suffix	"AJ-V(`warm ,)"
`weary	Suffix	"AJ-V(`weary ,)"
`wont	Suffix	"AJ-V(`wont ,)"
dis`criminate	Suffix	"AJ-V(dis`criminate ,)"

AV:
etc.	End	"AV(etc. - et cetera,)"
ibid.	End	"AV(ibid. - ibidem,)"
a`back	End	"AV(a`back ,)"
a`baft	End	"AV(a`baft ,)"
`ably	End	"AV(`able ,deadj)"
a`board	End	"AV(a`board ,)"
a`bominably	End	"AV(a`bominable ,deadj)"
a`bout	End	"AV(a`bout ,)"
a`bove	End	"AV(a`bove ,)"
ac`ross	End	"AV(ac`ross ,)"
a`far	End	"AV(a`far ,)"
`affably	End	"AV(`affable ,deadj)"
a`forehand	End	"AV(a`forehand - archaic,)"
`after	End	"AV(`after ,)"
`afterward	End	"AV(`afterward ,)"
`afterwards	End	"AV(`afterwards ,)"
a`gain	End	"AV(a`gain ,)"
a`ground	End	"AV(a`ground ,)"
a`head	End	"AV(a`head ,)"
all	End	"AV(all ,)"
al`most	End	"AV(al`most ,)"
a`loft	End	"AV(a`loft ,)"
a`long	End	"AV(a`long ,)"
along`side	End	"AV(along`side ,)"
al`ready	End	"AV(al`ready ,)"
`also	End	"AV(`also ,)"
alto`gether	End	"AV(alto`gether ,)"
a`loud	End	"AV(`loud ,deadj)"
`alway	End	"AV(`alway - archaic?,)"
`always	End	"AV(`always ,)"
a`main	End	"AV(a`main ,)"
`amiably	End	"AV(`amiable ,deadj)"
`amicably	End	"AV(`amicable ,deadj)"
a`miss	End	"AV(a`miss ,)"
a`mok	End	"AV(a`mok ,)"
`amply	End	"AV(`ample ,deadj)"
a`new	End	"AV(`new ,deadj)"
a`non	End	"AV(a`non ,)"
`anyhow	End	"AV(`anyhow ,)"
any`more	End	"AV(any`more ,)"
`anyplace	End	"AV(`anyplace ,)"
`anytime	End	"AV(`anytime ,)"
`anyway	End	"AV(`anyway ,)"
`anyways	End	"AV(`anyways ,)"
`anywhere	End	"AV(`anywhere ,)"
a`pace	End	"AV(a`pace ,)"
a`part	End	"AV(a`part ,)"
a`piece	End	"AV(a`piece ,)"
a-`piece	End	"AV(a-`piece - British,)"
ap`preciably	End	"AV(ap`preciate ,deverb+deajr)"
a`right	End	"AV(a`right ,)"
a`round	End	"AV(a`round ,)"
a`shore	End	"AV(a`shore ,)"
a`side	End	"AV(a`side ,)"
a`skance	End	"AV(a`skance ,)"
as`sai	End	"AV(as`sai ,)"
a`straddle	End	"AV(a`straddle ,)"
a`stray	End	"AV(a`stray ,)"
a`stride	End	"AV(a`stride ,)"
a`sunder	End	"AV(a`sunder ,)"
ath`wart	End	"AV(ath`wart ,)"
`audibly	End	"AV(`audible ,deadj)"
au`thentically	End	"AV(au`thentic ,deadj)"
a`way	End	"AV(a`way ,)"
a`while	End	"AV(a`while ,)"
ay	End	"AV(ay ,)"
aye	End	"AV(aye ,)"
be`fore	End	"AV(be`fore ,)"
be`forehand	End	"AV(be`forehand ,)"
be`hind	End	"AV(be`hind ,)"
be`low	End	"AV(be`low ,)"
be`neath	End	"AV(be`neath ,)"
be`sides	End	"AV(be`sides ,)"
be`tween	End	"AV(be`tween ,)"
be`yond	End	"AV(be`yond ,)"
by	End	"AV(by ,)"
`calculably	End	"AV(`calculate ,deverb+deajr)"
`capably	End	"AV(`capable ,deadj)"
`charitably	End	"AV(`charity ,denom+deajr)"
`comfortably	End	"AV(`comfort ,denom+deajr)"
com`panionably	End	"AV(com`panion ,denom+deajr)"
com`patibly	End	"AV(com`patible ,deadj)"
compre`hensibly	End	"AV(compre`hend ,deverb+deajr)"
`conscionably	End	"AV(`conscionable ,deadj)"
con`temptibly	End	"AV(con`tempt ,denom+deajr)"
con`trariwise	End	"AV(`contrary ,deadj)"
`corrigibly	End	"AV(`corrigible ,deadj)"
`credibly	End	"AV(`credible ,deadj)"
`culpably	End	"AV(`culpable ,deadj)"
`daily	End	"AV(`day ,denom)"
de`fensibly	End	"AV(de`fend ,deverb+deajr)"
de`monstrably	End	"AV(`demonstrate ,deverb+deajr)"
des`picably	End	"AV(des`pise ,deverb+deajr)"
dis`criminately	End	"AV(dis`criminate ,deverb)"
`doubly	End	"AV(`double ,deadj)"
`down	End	"AV(`down ,)"
`downwards	End	"AV(`downwards ,)"
`dubitably	End	"AV(`dubitable ,deadj)"
`dully	End	"AV(`dull ,deadj)"
`durably	End	"AV(`durable ,deadj)"
`edgeways	End	"AV(`edge ,denom)"
`e'er	End	"AV(`e'er ,)"
`eerily	End	"AV(`eerily ,)"
`either	End	"AV(`either ,)"
`else	End	"AV(`else ,)"
`elsewhere	End	"AV(`elsewhere ,)"
`equitably	End	"AV(`equitable ,deadj)"
`erstwhile	End	"AV(`erstwhile ,)"
`even	End	"AV(`even ,)"
e'en	End	"AV(`even ,)"
`ever	End	"AV(`ever ,)"
e'er	End	"AV(`ever ,)"
ever`more	End	"AV(ever`more ,)"
`everyplace	End	"AV(`everyplace ,)"
`everyway	End	"AV(`everyway ,)"
`everywhere	End	"AV(`everywhere ,)"
`fashionably	End	"AV(`fashion ,denom+deajr)"
`fast	End	"AV(`fast ,)"
`feebly	End	"AV(`feeble ,deadj)"
for`midably	End	"AV(for`midable ,deadj)"
`forth	End	"AV(`forth ,)"
forth`with	End	"AV(forth`with ,)"
`forwards	End	"AV(`forwards ,)"
`fully	End	"AV(`full ,deadj)"
`furthermore	End	"AV(`furthermore ,)"
`fain	End	"AV(`fain ,)"
`fro	End	"AV(`fro - as in to and fro,)"
`gaily	End	"AV(`gay ,deadj)"
`gently	End	"AV(`gentle ,deadj)"
`gullibly	End	"AV(`gullible ,deadj)"
`habitably	End	"AV(`habitable ,deadj)"
`haply	End	"AV(`haply ,)"
`hence	End	"AV(`hence ,)"
`henceforth	End	"AV(`henceforth ,)"
hence`forward	End	"AV(hence`forward ,)"
here	End	"AV(here ,)"
herea`bout	End	"AV(herea`bout ,)"
herea`bouts	End	"AV(herea`bouts ,)"
here`after	End	"AV(here`after ,)"
here`by	End	"AV(here`by ,)"
here`in	End	"AV(here`in ,)"
hereina`bove	End	"AV(hereina`bove ,)"
herein`after	End	"AV(herein`after ,)"
hereinbe`low	End	"AV(hereinbe`low ,)"
here`of	End	"AV(here`of ,)"
here`on	End	"AV(here`on ,)"
here`to	End	"AV(here`to ,)"
`heretofore	End	"AV(`heretofore ,)"
here`under	End	"AV(here`under ,)"
here`unto	End	"AV(here`unto ,)"
`hereupon	End	"AV(`hereupon ,)"
here`with	End	"AV(here`with ,)"
`hither	End	"AV(`hither ,)"
hither`to	End	"AV(hither`to ,)"
`horribly	End	"AV(`horrible ,deadj)"
`horseback	End	"AV(`horseback ,)"
hos`pitably	End	"AV(hos`pitable ,deadj)"
how	Clitic	"AV(how ,)"
how`beit	End	"AV(how`beit - archaic,)"
howso`ever	End	"AV(howso`ever ,)"
`humbly	End	"AV(`humble ,deadj)"
`ibidem	End	"AV(`ibidem ,)"
`idly	End	"AV(`idle ,deadj)"
il`legibly	End	"AV(`legible ,deadj)"
im`mitigably	End	"AV(im`mitigable ,deadj)"
im`plausably	End	"AV(`plausable ,deadj)"
im`pregnably	End	"AV(`pregnable ,deadj)"
in	End	"AV(in ,)"
incompre`hensibly	End	"AV(compre`hend ,deverb+deajr)"
in`deed	End	"AV(in`deed ,)"
in`delibly	End	"AV(in`delible ,deadj)"
in`doors	End	"AV(in`doors ,)"
in`effably	End	"AV(`effable ,deadj)"
in`evitably	End	"AV(`evitable ,deadj)"
in`exorably	End	"AV(in`exorable ,deadj)"
in`side	End	"AV(in`side ,)"
inso`far	End	"AV(inso`far ,)"
in`stead	End	"AV(in`stead ,)"
in`telligibly	End	"AV(in`telligible ,deadj)"
in`variably	End	"AV(`vary ,deverb+deajr)"
`inwards	End	"AV(`inwards ,)"
`irritably	End	"AV(`irritate ,deverb)"
`just	End	"AV(`just ,)"
`knowledgeably	End	"AV(`knowledge ,denom+deajr)"
`legibly	End	"AV(`legible ,deadj)"
`like	End	"AV(`like ,)"
`likewise	End	"AV(`likewise ,)"
`malleably	End	"AV(`malleable ,deadj)"
`maybe	End	"AV(`maybe ,)"
`mayhap	End	"AV(`mayhap ,)"
`meanwhile	End	"AV(`meanwhile ,)"
`miserably	End	"AV(`misery ,denom+deajr)"
more`over	End	"AV(more`over ,)"
`mostly	End	"AV(`mostly ,)"
much	End	"AV(much ,)"
`mutably	End	"AV(`mutable ,deadj)"
`namely	End	"AV(`name ,denom)"
nay	End	"AV(nay ,)"
near	End	"AV(near ,)"
`negligibly	End	"AV(`negligible ,deadj)"
`never	End	"AV(`never ,)"
ne`er	End	"AV(`never ,)"
neverthe`less	End	"AV(neverthe`less ,)"
next	End	"AV(next ,)"
`nimbly	End	"AV(`nimble ,deadj)"
no	End	"AV(no ,)"
`nohow	End	"AV(`nohow ,)"
nonethe`less	End	"AV(nonethe`less ,)"
`noplace	End	"AV(`noplace ,)"
not	End	"AV(not ,)"
n't	End	"AV(n't ,)"
notwith`standing	End	"AV(notwith`standing ,)"
now	End	"AV(now ,)"
`nowadays	End	"AV(`nowadays ,)"
`noway	End	"AV(`noway ,)"
`noways	End	"AV(`noways ,)"
`nowhere	End	"AV(`nowhere ,)"
`nowise	End	"AV(`nowise ,)"
`numerably	End	"AV(`numerate ,deverb+deajr)"
ob`jectionably	End	"AV(ob`ject ,deverb+deajr)"
o'clock	End	"AV(o'clock ,)"
off	End	"AV(off ,)"
on	End	"AV(on ,)"
`opposite	End	"AV(`opposite ,)"
`oft	End	"AV(`oft ,)"
`often	Infl	"AV(`often ,)"
`oftentimes	End	"AV(`oftentimes ,)"
`ofttimes	End	"AV(`ofttimes ,)"
once	Clitic	"AV(once ,)"
`onwards	End	"AV(`onwards ,)"
`operably	End	"AV(`operate ,deverb+deajr)"
os`tensibly	End	"AV(os`tensible ,deadj)"
`otherwise	End	"AV(`otherwise ,)"
out	End	"AV(out ,)"
out`side	End	"AV(out`side ,)"
`over	End	"AV(`over ,)"
`o'er	End	"AV(`o'er ,)"
`outwards	End	"AV(`outwards ,)"
`overhead	End	"AV(`overhead ,)"
`overly	End	"AV(`overly ,)"
`palatably	End	"AV(`palate ,denom+deajr)"
`palpably	End	"AV(`palpable ,deadj)"
`past	End	"AV(`past ,)"
`peaceably	End	"AV(`peace ,denom+deajr)"
`penetrably	End	"AV(`penetrate ,deverb+deajr)"
perad`venture	End	"AV(perad`venture ,)"
per`ceptibly	End	"AV(per`ceive ,deverb+deajr)"
per`chance	End	"AV(per`chance ,)"
per`force	End	"AV(per`force ,)"
per`haps	End	"AV(per`haps ,)"
per`missibly	End	"AV(per`mit ,deverb+deajr)"
`personably	End	"AV(`person ,denom+deajr)"
`placably	End	"AV(`placate ,deverb+deajr)"
`plausibly	End	"AV(`plausible ,deadj)"
`pleasurably	End	"AV(`pleasure ,denom+deajr)"
`plenty	End	"AV(`plenty ,)"
`portably	End	"AV(`port ,deverb+deajr)"
`possibly	End	"AV(`possible ,deadj)"
`practicably	End	"AV(`practicable ,deadj)"
`pronto	End	"AV(`pronto ,)"
`preferably	End	"AV(pre`fer ,deverb+deajr)"
`presto	End	"AV(`presto ,)"
`probably	End	"AV(`probable ,deadj)"
`quite	End	"AV(`quite ,)"
`rather	End	"AV(`rather ,)"
repre`hensibly	End	"AV(repre`hend ,deverb)"
`responsibly	End	"AV(`responsible ,deadj)"
`revocably	End	"AV(re`voke ,deverb+deajr)"
`right	End	"AV(`right ,)"
`round	End	"AV(`round ,)"
`seasonably	End	"AV(`season ,denom+deajr)"
`seldom	End	"AV(`seldom ,)"
`separably	End	"AV(`separate ,deverb+deajr)"
`shrilly	End	"AV(`shrill ,deadj)"
`simply	End	"AV(`simple ,deadj)"
since	End	"AV(since ,)"
`singly	End	"AV(`single ,deadj)"
so	Clitic	"AV(so ,)"
`sociably	End	"AV(`sociable ,deadj)"
`solubly	End	"AV(`soluble ,deadj)"
`soon	End	"AV(`soon ,)"
`sooner	End	"AV(`soon ,)"
`soonest	End	"AV(`soon ,)"
`someday	End	"AV(`someday ,)"
`somehow	End	"AV(`somehow ,)"
`someplace	End	"AV(`someplace ,)"
`sometime	End	"AV(`sometime ,)"
`sometimes	End	"AV(`sometimes ,)"
`somewhat	End	"AV(`somewhat ,)"
`somewhere	End	"AV(`somewhere ,)"
`still	End	"AV(`still ,)"
`straightway	End	"AV(`straightway ,)"
`subtly	End	"AV(`subtle ,deadj)"
`supra	End	"AV(`supra ,)"
sus`ceptibly	End	"AV(sus`ceptible ,deadj)"
`tangibly	End	"AV(`tangible ,deadj)"
`tenably	End	"AV(`tenable ,deadj)"
`terminably	End	"AV(`terminate ,deverb+deajr)"
terribly	End	"AV(`terrible ,deadj)"
thataway	End	"AV(thataway ,)"
then	End	"AV(then ,)"
thence	End	"AV(thence ,)"
thence`forth	End	"AV(thence`forth ,)"
thence`forward	End	"AV(thence`forward ,)"
thence`forwards	End	"AV(thence`forwards ,)"
there	End	"AV(there ,)"
there`about	End	"AV(there`about ,)"
there`abouts	End	"AV(there`abouts ,)"
there`after	End	"AV(there`after ,)"
there`at	End	"AV(there`at ,)"
there`by	End	"AV(there`by ,)"
there`for	End	"AV(there`for ,)"
`therefore	End	"AV(`therefore ,)"
there`from	End	"AV(there`from ,)"
there`in	End	"AV(there`in ,)"
there`into	End	"AV(there`into ,)"
therein`after	End	"AV(therein`after ,)"
there`of	End	"AV(there`of ,)"
there`on	End	"AV(there`on ,)"
there`to	End	"AV(there`to ,)"
`theretofore	End	"AV(`theretofore ,)"
there`under	End	"AV(there`under ,)"
there`unto	End	"AV(there`unto ,)"
`thereupon	End	"AV(`thereupon ,)"
there`with	End	"AV(there`with ,)"
`therewithal	End	"AV(`therewithal ,)"
`thither	End	"AV(`thither ,)"
`thitherto	End	"AV(`thitherto ,)"
`thitherward	End	"AV(`thitherward ,)"
`thitherwards	End	"AV(`thitherwards ,)"
thrice	End	"AV(thrice ,)"
through	End	"AV(through ,)"
through`out	End	"AV(through`out ,)"
thus	End	"AV(thus ,)"
`thusly	End	"AV(thus ,)"
to`day	End	"AV(to`day ,)"
to-`day	End	"AV(to-`day - British,)"
to`gether	End	"AV(to`gether ,)"
`tolerably	End	"AV(`tolerate ,deverb+deajr)"
to`morrow	End	"AV(to`morrow ,)"
to`night	End	"AV(to`night ,)"
to-`night	End	"AV(to-`night - British,)"
too	End	"AV(too ,)"
topsy-`turvy	End	"AV(topsy-`turvy ,)"
`tractably	End	"AV(`tractable ,deadj)"
`trebly	End	"AV(`treble ,deadj)"
`truly	End	"AV(`true ,deadj)"
twice	End	"AV(twice ,)"
una`wares	End	"AV(una`wares ,)"
`under	End	"AV(`under ,)"
under`neath	End	"AV(under`neath ,)"
unob`jectionably	End	"AV(ob`ject ,deverb+deajr)"
`up	End	"AV(`up ,)"
`upwards	End	"AV(`upwards ,)"
`venerably	End	"AV(`venerate ,deverb+deajr)"
`verily	End	"AV(`verily ,)"
`veritably	End	"AV(`veritable ,deadj)"
`very	End	"AV(`very ,)"
`viably	End	"AV(`viable ,deadj)"
`violably	End	"AV(`violate ,deverb+deajr)"
`visibly	End	"AV(`visible ,deadj)"
`volubly	End	"AV(`voluble ,deadj)"
`vulnerably	End	"AV(`vulnerable ,deadj)"
`way	End	"AV(`way ,)"
`well	End	"AV(`well ,)"
when	Clitic	"AV(when ,)"
whence	Clitic	"AV(whence ,)"
where	Clitic	"AV(where ,)"
`whereabout	End	"AV(`whereabout ,)"
`whereabouts	End	"AV(`whereabouts ,)"
`wherefore	End	"AV(`wherefore ,)"
where`in	Clitic	"AV(where`in ,)"
where`to	Clitic	"AV(where`to ,)"
wher`ever	Clitic	"AV(wher`ever ,)"
where`unto	Clitic	"AV(where`unto ,)"
`whither	Clitic	"AV(`whither ,)"
with`al	End	"AV(with`al ,)"
with`in	End	"AV(with`in ,)"
with`out	End	"AV(with`out ,)"
yea	End	"AV(yea ,)"
yes	End	"AV(yes ,)"
`yesterday	End	"AV(`yesterday ,)"
`yesteryear	End	"AV(`yesteryear ,)"
`yonder	End	"AV(`yonder ,)"
`yonder	End	"AV(`yonder ,)"
a-fortiori	End	"AV(a-fortiori ,)"
ad-nauseum	End	"AV(ad-nauseum ,)"
en-masse	End	"AV(en-masse ,)"
et-cetera	End	"AV(et-cetera ,)"
in-absentia	End	"AV(in-absentia ,)"
in-extremis	End	"AV(in-extremis ,)"
in-loco-parentis	End	"AV(in-loco-parentis ,)"
in-medias-res	End	"AV(in-medias-res ,)"
in-toto	End	"AV(in-toto ,)"
inter-alia	End	"AV(inter-alia ,)"
inter-alios	End	"AV(inter-alios ,)"
ipso-facto	End	"AV(ipso-facto ,)"
mutatis-mutandis	End	"AV(mutatis-mutandis ,)"
per-annum	End	"AV(per-annum ,)"
per-diem	End	"AV(per-diem ,)"
vice-versa	End	"AV(vice-versa ,)"
vice-versa	End	"AV(vice-versa ,)"

SUFFIX:
''	Infl	"SUFFIX('' ,)"
+dom	Suffix	"SUFFIX(+NR2 - ,n/n)"
+hood	Suffix	"SUFFIX(+NR6 - ,n/n)"
+ism	Suffix	"SUFFIX(+NR8 - ,n/n)"
+ship	Suffix	"SUFFIX(+NR9 - ,n/n)"
+eer	Suffix	"SUFFIX(+NR10 - ,n/n nr10)"
+ess	Suffix	"SUFFIX(+NR12 - ,n/n nr12)"
+ette	Suffix	"SUFFIX(+NR13 - ,n/n)"
+let	Suffix	"SUFFIX(+NR14 - ,n/n)"
+ling	Suffix	"SUFFIX(+NR15 - ,n/n nr15)"
+ster	Suffix	"SUFFIX(+NR16 - ,n/n)"
+an	Suffix	"SUFFIX(+NR29a - ,n/n)"
+ian	Suffix	"SUFFIX(+NR29b - ,n/n)"
+arian	Suffix	"SUFFIX(+NR29c - ,n/n)"
+ist	Suffix	"SUFFIX(+NR31 - ,n/n nr31)"
+ite	Suffix	"SUFFIX(+NR32 - ,n/n)"
+iana	Suffix	"SUFFIX(+NR36 - ,n/n)"
+scape	Suffix	"SUFFIX(+NR37 - ,n/n)"
+nik	Suffix	"SUFFIX(+NR44 - ,n/n)"
+itis	Suffix	"SUFFIX(+NR50 - ,n/n)"
+ectom	Y_Suffix	"SUFFIX(+NR51 - ,n/n)"
+icide	Suffix	"SUFFIX(+NR54 - ,n/n)"
+man	Suffix	"SUFFIX(+NR55a - ,n/n)"
+men	Clitic	"SUFFIX(+NR55b - ,n/n pl)"
+woman	Suffix	"SUFFIX(+NR56a - ,n/n)"
+women	Clitic	"SUFFIX(+NR56b - ,n/n pl)"
+person	Suffix	"SUFFIX(+NR57 - ,n/n)"
+age	Suffix	"SUFFIX(+NR1 - ,v/n)"
+ant	Suffix	"SUFFIX(+NR17 - ,v/n)"
+ee	Suffix	"SUFFIX(+NR18 - ,v/n)"
+er	Suffix	"SUFFIX(+NR19 - ,v/n nr19)"
+or	Suffix	"SUFFIX(+NR20 - ,v/n)"
+al	Suffix	"SUFFIX(+NR22 - ,v/n nr22)"
+ation	Suffix	"SUFFIX(+NR23a - ,v/n nr23)"
+cation	Suffix	"SUFFIX(+NR23b - +ification,v/n nr23)"
+ition	Suffix	"SUFFIX(+NR23c - ,v/n nr23)"
+tion	Suffix	"SUFFIX(+NR23d - ,v/n nr23)"
+ion	Suffix	"SUFFIX(+NR23e - ,v/n nr23)"
+ment	Suffix	"SUFFIX(+NR25 - ,v/n)"
+ance	Suffix	"SUFFIX(+NR26a - ,v/n nr26)"
+ence	Suffix	"SUFFIX(+NR26b - ,v/aj/n nr26)"
+ency	Suffix	"SUFFIX(+AJR27a+NR40 - ,v/aj/n)"
+ability	Suffix	"SUFFIX(+AJR25a+NR21 - ,v/aj/n)"
+ibility	Suffix	"SUFFIX(+AJR25b+NR21 - ,v/aj/n)"
+ish	Suffix	"SUFFIX(+AJR10 - ,aj/n)"
+ism	Suffix	"SUFFIX(+NR8 - ,aj/n)"
+ster	Suffix	"SUFFIX(+NR16 - ,aj/n)"
+ee	Suffix	"SUFFIX(+NR18 - ,aj/n)"
+ity	Suffix	"SUFFIX(+NR21 - ,aj/n)"
+ness	Suffix	"SUFFIX(+NR27 - ,aj/n)"
+ese	Suffix	"SUFFIX(+NR28 - ,aj/n)"
+ist	Suffix	"SUFFIX(+NR31 - ,aj/n nr31)"
+an	Suffix	"SUFFIX(+AJR4a - ,n/aj)"
+ian	Suffix	"SUFFIX(+AJR4b - ,n/aj)"
+arian	Suffix	"SUFFIX(+AJR4d - ,n/aj)"
+ed	Suffix	"SUFFIX(+AJR8 - not a participle, e.g. bearded,n/aj ajr8)"
+ful	Suffix	"SUFFIX(+AJR9 - ,n/aj)"
+ish	Suffix	"SUFFIX(+AJR10 - ,n/aj)"
+less	Suffix	"SUFFIX(+AJR11 - ,n/aj)"
+like	Suffix	"SUFFIX(+AJR12 - ,n/aj)"
+ly	Suffix	"SUFFIX(+AJR13 - doesn't handle "weekly" as an adverb,n/aj ajr13)"
+y	Suffix	"SUFFIX(+AJR14 - muddy,n/aj ajr14)"
+worthy	Suffix	"SUFFIX(+AJR16 - ,n/aj)"
+ward	Suffix	"SUFFIX(+AVR2a - ,n/av)"
+ward	Suffix	"SUFFIX(+AVR2a - ,n/aj)"
+wards	Suffix	"SUFFIX(+AVR2b - ,n/av)"
+wise	Suffix	"SUFFIX(+AVR4 - ,n/av)"
+wise	Suffix	"SUFFIX(+AVR4 - ,n/aj)"
+wide	Suffix	"SUFFIX(+AVR5 - or compound,n/av)"
+wide	Suffix	"SUFFIX(+AVR5 - ,n/aj)"
+fashion	Suffix	"SUFFIX(+AVR6 - or compound,n/av)"
+style	Suffix	"SUFFIX(+AVR7 - or compound,n/av)"
+al	Suffix	"SUFFIX(+AJR17a - foreign,n/aj ajr17)"
+ial	Suffix	"SUFFIX(+AJR17b - ,n/aj ajr17)"
+ual	Suffix	"SUFFIX(+AJR17c - ,n/aj ajr17)"
+esque	Suffix	"SUFFIX(+AJR19 - ,n/aj)"
+ic	IC_Suffix	"SUFFIX(+AJR20a - ,n/aj ajr20)"
+etic	IC_Suffix	"SUFFIX(+AJR20b - ,n/aj ajr20)"
+ous	Suffix	"SUFFIX(+AJR21a - ,n/aj)"
+able	Suffix	"SUFFIX(+AJR25a - ,v/aj)"
+ible	Suffix	"SUFFIX(+AJR25b - ,v/aj)"
+ably	Suffix	"SUFFIX(+AJR25+AVR1 - ,v/aj/av)"
+ibly	Suffix	"SUFFIX(+AJR25+AVR1 - ,v/aj/av)"
+ive	Suffix	"SUFFIX(+AJR26 - ,v/aj)"
+ent	Suffix	"SUFFIX(+AJR27a - ,v/aj)"
+ory	Suffix	"SUFFIX(+AJR28 - ,v/aj)"
+ly	Suffix	"SUFFIX(+AVR1 - ,aj/av)"
+most	Suffix	"SUFFIX(+AJR33 - ,aj/aj)"
+ify	Suffix	"SUFFIX(+VR5 - ,n/v)"
+ize	Suffix	"SUFFIX(+VR6a - ,n/v)"
+ise	Suffix	"SUFFIX(+VR6b - British,n/v)"
+en	Suffix	"SUFFIX(+VR4 - ,aj/v)"
+ify	Suffix	"SUFFIX(+VR5 - also +fy,aj/v)"
+ize	Suffix	"SUFFIX(+VR6a - ,aj/v)"
+ise	Suffix	"SUFFIX(+VR6b - British,aj/v)"

INFL:
''	Clitic	"INFL('' ,)"
+s	Clitic	"INFL(+PL - noun plural,n/n pl reg)"
+er	Clitic	"INFL(+CMP - adjective comparative,aj/aj comp reg)"
+est	Clitic	"INFL(+SPR - adjective superlative,aj/aj super reg)"
+s	End	"INFL(+3SG - verb 3rd singular,v/v s)"
+ed	End	"INFL(+ED - verb past tense,v/v ed reg)"
+ed	PT_Suffix	"INFL(+EN - verb past participle,v/v en reg)"
+ing	PT_Suffix	"INFL(+ING - ,v/v ing)"
+in'	PT_Suffix	"INFL(+ING - substandard for +ing,v/v ing)"

DT:
a	End	"DT(a ,sg)"
an	End	"DT(an ,sg)"
the	End	"DT(the ,)"
no	End	"DT(no ,)"
some	Contraction	"DT(some ,)"
`any	Contraction	"DT(`any ,)"
e`nough	End	"DT(e`nough ,)"
`every	End	"DT(`every ,sg)"
each	End	"DT(each ,sg)"
`either	End	"DT(`either ,sg)"
`neither	End	"DT(`neither ,sg)"
much	End	"DT(much ,)"
none	End	"DT(none ,)"
all	Contraction	"DT(all ,pl)"
both	Contraction	"DT(both ,pl)"
twice	End	"DT(twice ,)"
not	End	"DT(not ,)"
a`nother	End	"DT(a`nother ,sg)"
`other	End	"DT(`other ,)"
next	Contraction	"DT(next ,)"
`last	Suffix	"DT(`last ,)"
few	Contraction	"DT(few ,pl)"
`several	Contraction	"DT(`several ,pl)"
`many	Contraction	"DT(`many ,pl)"
more	Contraction	"DT(more ,comp)"
most	Contraction	"DT(most ,super)"
`little	Contraction	"DT(`little ,)"
less	Contraction	"DT(less ,comp)"
least	Contraction	"DT(least ,super)"
`lot	Contraction	"DT(`lot ,)"
`lots	Contraction	"DT(`lots ,)"
`plenty	Contraction	"DT(`plenty ,)"

PP:
in-memoriam	End	"PP(in-memoriam ,)"
a`baft	End	"PP(a`baft ,)"
a`board	End	"PP(a`board ,)"
a`bout	End	"PP(a`bout ,)"
a`bove	End	"PP(a`bove ,)"
ac`ross	End	"PP(ac`ross ,)"
a`gainst	End	"PP(a`gainst ,)"
a`long	End	"PP(a`long ,)"
along`side	End	"PP(along`side ,)"
a`mid	End	"PP(a`mid ,)"
a`midst	End	"PP(a`midst ,)"
a`mong	End	"PP(a`mong ,)"
a`mongst	End	"PP(a`mongst ,)"
a`nent	End	"PP(a`nent ,)"
`anti	End	"PP(`anti ,)"
a`round	End	"PP(a`round ,)"
a`slant	End	"PP(a`slant ,)"
a`straddle	End	"PP(a`straddle ,)"
a`stride	End	"PP(a`stride ,)"
at	End	"PP(at ,)"
a`top	End	"PP(a`top ,)"
`bar	End	"PP(`bar ,)"
be`hind	End	"PP(be`hind ,)"
be`low	End	"PP(be`low ,)"
be`neath	End	"PP(be`neath ,)"
be`side	End	"PP(be`side ,)"
be`sides	End	"PP(be`sides ,)"
be`tween	End	"PP(be`tween ,)"
be`twixt	End	"PP(be`twixt ,)"
be`yond	End	"PP(be`yond ,)"
by	End	"PP(by ,)"
`circa	End	"PP(`circa ,)"
`contra	End	"PP(`contra ,)"
de`spite	End	"PP(de`spite ,)"
`down	End	"PP(`down ,)"
`during	End	"PP(`during ,)"
`ere	End	"PP(`ere ,)"
from	End	"PP(from ,)"
in	End	"PP(in ,)"
in`side	End	"PP(in`side ,)"
`into	End	"PP(`into ,)"
less	End	"PP(less ,)"
`minus	End	"PP(`minus ,)"
`modulo	End	"PP(`modulo ,)"
`near	End	"PP(`near ,)"
neath	End	"PP(neath ,)"
next	End	"PP(next ,)"
notwith`standing	End	"PP(notwith`standing ,)"
of	End	"PP(of ,)"
off	End	"PP(off ,)"
on	End	"PP(on ,)"
`onto	End	"PP(`onto ,)"
`opposite	End	"PP(`opposite ,)"
out	End	"PP(out ,)"
out`side	End	"PP(out`side ,)"
`over	End	"PP(`over ,)"
`o'er	End	"PP(`o'er ,)"
`pace	End	"PP(`pace ,)"
`past	End	"PP(`past ,)"
`pending	End	"PP(`pending ,)"
per	End	"PP(per ,)"
`plus	End	"PP(`plus ,)"
pro	End	"PP(pro ,)"
qua	End	"PP(qua ,)"
re	End	"PP(re ,)"
`round	End	"PP(`round ,)"
sans	End	"PP(sans ,)"
`save	End	"PP(`save - archaic,)"
than	End	"PP(than ,)"
through	End	"PP(through ,)"
through`out	End	"PP(through`out ,)"
to	End	"PP(to ,)"
to`ward	End	"PP(to`ward ,)"
to`wards	End	"PP(to`wards ,)"
`under	End	"PP(`under ,)"
under`neath	End	"PP(under`neath ,)"
un`like	End	"PP(un`like ,)"
`unto	End	"PP(`unto ,)"
`up	End	"PP(`up ,)"
u`pon	End	"PP(u`pon ,)"
`versus	End	"PP(`versus ,)"
via	End	"PP(via ,)"
vis-a-`vis	End	"PP(vis-a-`vis ,)"
with	End	"PP(with ,)"
with`in	End	"PP(with`in ,)"
with`out	End	"PP(with`out ,)"
`worth	End	"PP(`worth ,)"

INITIAL:
''	Particle	"INITIAL('' ,)"
''	Prefix	"INITIAL('' ,)"

ORDR:
''	Infl	"ORDR('' ,)"
+st	Suffix	"ORDR(+ORDR1 - ,n/n-aj)"
+nd	Suffix	"ORDR(+ORDR2 - ,n/n-aj)"
+d	Suffix	"ORDR(+ORDR2/3 - ,n/n-aj)"
+rd	Suffix	"ORDR(+ORDR3 - ,n/n-aj)"
+th	Suffix	"ORDR(+ORDR4a - ,n/n-aj)"
+eth	Suffix	"ORDR(+ORDR4b - ,n/n-aj)"
+fold	Clitic	"ORDR(+AJR32 - ,n/aj)"
+score	Clitic	"ORDR(+AJR41 - ,n/aj)"
+some	Clitic	"ORDR(+NR58 - ,n/n)"

PP-CJ:
`after	End	"PP-CJ(`after ,)"
as	End	"PP-CJ(as ,)"
be`fore	End	"PP-CJ(be`fore ,)"
but	End	"PP-CJ(but ,)"
ex`cept	End	"PP-CJ(ex`cept ,)"
for	End	"PP-CJ(for ,)"
`like	End	"PP-CJ(`like ,)"
since	End	"PP-CJ(since ,)"
till	End	"PP-CJ(till ,)"
un`til	End	"PP-CJ(un`til ,)"
