/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.seqno;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.seqno.RetentionLeaseActions;
import org.opensearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.opensearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.opensearch.index.seqno.RetentionLeaseNotFoundException;
import org.opensearch.replication.metadata.store.ReplicationMetadata;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.CoroutinesKt;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.ClusterAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\nJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0017J&\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001eJ&\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010!J&\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003H\u0086@\u00a2\u0006\u0002\u0010(J\u001e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003H\u0082@\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010.\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001aJ&\u0010/\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001aJ&\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper;", "", "followerClusterNameWithUUID", "", "client", "Lorg/opensearch/transport/client/Client;", "<init>", "(Ljava/lang/String;Lorg/opensearch/transport/client/Client;)V", "followerClusterName", "followerClusterUUID", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/transport/client/Client;)V", "getFollowerClusterNameWithUUID", "()Ljava/lang/String;", "setFollowerClusterNameWithUUID", "(Ljava/lang/String;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "retentionLeaseSource", "verifyRetentionLeaseExist", "", "leaderShardId", "Lorg/opensearch/core/index/shard/ShardId;", "followerShardId", "(Lorg/opensearch/core/index/shard/ShardId;Lorg/opensearch/core/index/shard/ShardId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addNewRetentionLeaseIfOldExists", "seqNo", "", "(Lorg/opensearch/core/index/shard/ShardId;Lorg/opensearch/core/index/shard/ShardId;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addNewRetentionLease", "timeout", "(Lorg/opensearch/core/index/shard/ShardId;JLorg/opensearch/core/index/shard/ShardId;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renewRetentionLease", "", "(Lorg/opensearch/core/index/shard/ShardId;JLorg/opensearch/core/index/shard/ShardId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptRemoveRetentionLease", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "replMetadata", "Lorg/opensearch/replication/metadata/store/ReplicationMetadata;", "followerIndexName", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/replication/metadata/store/ReplicationMetadata;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLeaderIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "leaderAlias", "leaderIndex", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptRetentionLeaseRemoval", "addRetentionLease", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRemoteClusterRetentionLeaseHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteClusterRetentionLeaseHelper.kt\norg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,230:1\n216#2,2:231\n*S KotlinDebug\n*F\n+ 1 RemoteClusterRetentionLeaseHelper.kt\norg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper\n*L\n141#1:231,2\n*E\n"})
public final class RemoteClusterRetentionLeaseHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String followerClusterNameWithUUID;
    @NotNull
    private final Client client;
    @NotNull
    private final String retentionLeaseSource;
    @NotNull
    private String followerClusterUUID;
    @NotNull
    private String followerClusterName;
    private static final Logger log = LogManager.getLogger(RemoteClusterRetentionLeaseHelper.class);
    @NotNull
    public static final String RETENTION_LEASE_PREFIX = "replication:";

    public RemoteClusterRetentionLeaseHelper(@NotNull String followerClusterNameWithUUID, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)followerClusterNameWithUUID, (String)"followerClusterNameWithUUID");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.followerClusterNameWithUUID = followerClusterNameWithUUID;
        this.client = client;
        this.retentionLeaseSource = Companion.retentionLeaseSource(this.followerClusterNameWithUUID);
        this.followerClusterUUID = "";
        this.followerClusterName = "";
    }

    @NotNull
    public final String getFollowerClusterNameWithUUID() {
        return this.followerClusterNameWithUUID;
    }

    public final void setFollowerClusterNameWithUUID(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.followerClusterNameWithUUID = string;
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    public RemoteClusterRetentionLeaseHelper(@NotNull String followerClusterName, @NotNull String followerClusterUUID, @NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
        Intrinsics.checkNotNullParameter((Object)followerClusterUUID, (String)"followerClusterUUID");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this(followerClusterName, client);
        this.followerClusterUUID = followerClusterUUID;
        this.followerClusterName = followerClusterName;
        this.followerClusterNameWithUUID = Companion.getFollowerClusterNameWithUUID(followerClusterName, followerClusterUUID);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object verifyRetentionLeaseExist(@NotNull ShardId leaderShardId, @NotNull ShardId followerShardId, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof verifyRetentionLeaseExist.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.verifyRetentionLeaseExist(null, null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
                request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, -1L, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.client;
                v1 = RetentionLeaseActions.Renew.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                $continuation.L$0 = leaderShardId;
                $continuation.L$1 = followerShardId;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)retentionLeaseId);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 1;
                v2 = CoroutinesKt.suspendExecute$default(v0, (ActionType)v1, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v2 != var9_6) goto lbl27
lbl26:
                // 1 sources

                return var9_6;
lbl27:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                request = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl37:
                    // 2 sources

                    (RetentionLeaseActions.Response)v2;
                }
                catch (RetentionLeaseInvalidRetainingSeqNoException e) {
                    return Boxing.boxBoolean((boolean)true);
                }
                catch (RetentionLeaseNotFoundException e) {
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)followerShardId);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)retentionLeaseId);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)e);
                    $continuation.label = 2;
                    v3 = this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, -1L, (Continuation<? super Boolean>)$continuation);
                    if (v3 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl61
                }
            }
            case 2: {
                e = (RetentionLeaseNotFoundException)$continuation.L$4;
                request = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl61:
                // 2 sources

                return v3;
            }
        }
        catch (Exception e) {
            return Boxing.boxBoolean((boolean)false);
        }
        return Boxing.boxBoolean((boolean)true);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object addNewRetentionLeaseIfOldExists(ShardId leaderShardId, ShardId followerShardId, long seqNo, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof addNewRetentionLeaseIfOldExists.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteClusterRetentionLeaseHelper.access$addNewRetentionLeaseIfOldExists(this.this$0, null, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                oldRetentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterName, followerShardId);
                requestForOldId = new RetentionLeaseActions.RenewRequest(leaderShardId, oldRetentionLeaseId, -1L, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.client;
                v1 = RetentionLeaseActions.Renew.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                $continuation.L$0 = leaderShardId;
                $continuation.L$1 = followerShardId;
                $continuation.L$2 = oldRetentionLeaseId;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)requestForOldId);
                $continuation.J$0 = seqNo;
                $continuation.label = 1;
                v2 = CoroutinesKt.suspendExecute$default(v0, (ActionType)v1, (ActionRequest)requestForOldId, false, false, (Continuation)$continuation, 12, null);
                ** if (v2 != var11_7) goto lbl28
lbl27:
                // 1 sources

                return var11_7;
lbl28:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                seqNo = $continuation.J$0;
                requestForOldId = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                oldRetentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl39:
                    // 2 sources

                    (RetentionLeaseActions.Response)v2;
                }
                catch (RetentionLeaseInvalidRetainingSeqNoException ex) {
                    RemoteClusterRetentionLeaseHelper.log.info("Old retention lease Id " + oldRetentionLeaseId + " present with invalid seq number, adding new retention lease with ID:" + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId) + " ");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)followerShardId);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)oldRetentionLeaseId);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)requestForOldId);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)ex);
                    $continuation.J$0 = seqNo;
                    $continuation.label = 2;
                    v3 = this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, 60000L, (Continuation<? super Boolean>)$continuation);
                    if (v3 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl64
                }
            }
            case 2: {
                seqNo = $continuation.J$0;
                ex = (RetentionLeaseInvalidRetainingSeqNoException)$continuation.L$4;
                requestForOldId = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                oldRetentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl64:
                // 2 sources

                return v3;
            }
        }
        catch (Exception ex) {
            RemoteClusterRetentionLeaseHelper.log.info("Encountered Exception while checking for old retention lease: " + ExtensionsKt.stackTraceToString(ex));
            return Boxing.boxBoolean((boolean)false);
        }
        RemoteClusterRetentionLeaseHelper.log.info("Old retention lease Id " + oldRetentionLeaseId + ", adding new retention lease with ID:" + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId) + " ");
        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)followerShardId);
        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)oldRetentionLeaseId);
        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)requestForOldId);
        $continuation.J$0 = seqNo;
        $continuation.label = 3;
        v4 = this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, 60000L, (Continuation<? super Boolean>)$continuation);
        if (v4 == var11_7) {
            return var11_7;
        }
        ** GOTO lbl87
        {
            case 3: {
                seqNo = $continuation.J$0;
                requestForOldId = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                oldRetentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl87:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object addNewRetentionLease(ShardId leaderShardId, long seqNo, ShardId followerShardId, long timeout, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof addNewRetentionLease.1)) ** GOTO lbl-1000
        var12_6 = $completion;
        if ((var12_6.label & -2147483648) != 0) {
            var12_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                long J$1;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteClusterRetentionLeaseHelper.access$addNewRetentionLease(this.this$0, null, 0L, null, 0L, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
                request = new RetentionLeaseActions.AddRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.client;
                v1 = RetentionLeaseActions.Add.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)followerShardId);
                $continuation.L$2 = retentionLeaseId;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.J$0 = seqNo;
                $continuation.J$1 = timeout;
                $continuation.label = 1;
                v2 = CoroutinesKt.suspendExecute$default(v0, (ActionType)v1, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v2 != var13_8) goto lbl29
lbl28:
                // 1 sources

                return var13_8;
lbl29:
                // 1 sources

                ** GOTO lbl41
            }
            case 1: {
                timeout = $continuation.J$1;
                seqNo = $continuation.J$0;
                request = (RetentionLeaseActions.AddRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl41:
                    // 2 sources

                    return Boxing.boxBoolean((boolean)true);
                }
                catch (Exception e) {
                    RemoteClusterRetentionLeaseHelper.log.info("Exception while adding new retention lease with i: " + retentionLeaseId);
                    return Boxing.boxBoolean((boolean)false);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object renewRetentionLease(@NotNull ShardId leaderShardId, long seqNo, @NotNull ShardId followerShardId, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof renewRetentionLease.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.renewRetentionLease(null, 0L, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
                request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
                v0 = (OpenSearchClient)this.client;
                v1 = RetentionLeaseActions.Renew.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                $continuation.L$0 = leaderShardId;
                $continuation.L$1 = followerShardId;
                $continuation.L$2 = retentionLeaseId;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.J$0 = seqNo;
                $continuation.label = 1;
                v2 = CoroutinesKt.suspendExecute$default(v0, (ActionType)v1, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v2 != var11_7) goto lbl28
lbl27:
                // 1 sources

                return var11_7;
lbl28:
                // 1 sources

                ** GOTO lbl65
            }
            case 1: {
                seqNo = $continuation.J$0;
                request = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
                    ** GOTO lbl65
                }
                catch (RetentionLeaseNotFoundException e) {
                    RemoteClusterRetentionLeaseHelper.log.info("Retention lease with ID: " + retentionLeaseId + " not found, checking for old retention lease with ID: " + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterName, followerShardId));
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
                    $continuation.L$1 = followerShardId;
                    $continuation.L$2 = retentionLeaseId;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                    $continuation.L$4 = e;
                    $continuation.J$0 = seqNo;
                    $continuation.label = 2;
                    v3 = this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, seqNo, (Continuation<? super Boolean>)$continuation);
                    if (v3 == var11_7) {
                        return var11_7;
                    }
                    ** GOTO lbl62
                }
            }
            case 2: {
                seqNo = $continuation.J$0;
                e = (RetentionLeaseNotFoundException)$continuation.L$4;
                request = (RetentionLeaseActions.RenewRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl62:
                // 2 sources

                if (!((Boolean)v3).booleanValue()) {
                    RemoteClusterRetentionLeaseHelper.log.info("Both new " + retentionLeaseId + " and old " + RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId) + " retention lease not found.");
                    throw e;
                }
lbl65:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object attemptRemoveRetentionLease(@NotNull ClusterService clusterService, @NotNull ReplicationMetadata replMetadata, @NotNull String followerIndexName, @NotNull Continuation<? super Unit> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getLeaderIndexMetadata(String leaderAlias, String leaderIndex, Continuation<? super IndexMetadata> $completion) {
        if (!($completion instanceof getLeaderIndexMetadata.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RemoteClusterRetentionLeaseHelper.access$getLeaderIndexMetadata(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                leaderClusterClient = this.client.getRemoteClusterClient(leaderAlias);
                var6_9 = new String[]{leaderIndex};
                clusterStateRequest = (ClusterStateRequest)leaderClusterClient.admin().cluster().prepareState().clear().setIndices(var6_9).setMetadata(true).setIndicesOptions(IndicesOptions.strictSingleIndexNoExpandForbidClosed()).request();
                Intrinsics.checkNotNull((Object)leaderClusterClient);
                $continuation.L$0 = leaderAlias;
                $continuation.L$1 = leaderIndex;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)leaderClusterClient);
                $continuation.L$3 = clusterStateRequest;
                $continuation.label = 1;
                v0 = CoroutinesKt.suspending$default(leaderClusterClient, (Function2)new Function2<ClusterStateRequest, ActionListener<ClusterStateResponse>, Unit>((Object)leaderClusterClient.admin().cluster()){

                    public final void invoke(ClusterStateRequest p0, ActionListener<ClusterStateResponse> p1) {
                        ((ClusterAdminClient)this.receiver).state(p0, p1);
                    }
                }, false, false, (Continuation)$continuation, 6, null);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                clusterStateRequest = (ClusterStateRequest)$continuation.L$3;
                leaderClusterClient = (Client)$continuation.L$2;
                leaderIndex = (String)$continuation.L$1;
                leaderAlias = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                $continuation.L$0 = leaderAlias;
                $continuation.L$1 = leaderIndex;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)leaderClusterClient);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)clusterStateRequest);
                $continuation.label = 2;
                v1 = ((Function2)v0).invoke((Object)clusterStateRequest, (Object)$continuation);
                if (v1 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl48
            }
            case 2: {
                clusterStateRequest = (ClusterStateRequest)$continuation.L$3;
                leaderClusterClient = (Client)$continuation.L$2;
                leaderIndex = (String)$continuation.L$1;
                leaderAlias = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                leaderState = ((ClusterStateResponse)v1).getState();
                v2 = leaderState.getMetadata().index(leaderIndex);
                if (v2 == null) {
                    throw new IndexNotFoundException(leaderAlias + ":" + leaderIndex);
                }
                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object attemptRetentionLeaseRemoval(@NotNull ShardId leaderShardId, @NotNull ShardId followerShardId, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof attemptRetentionLeaseRemoval.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteClusterRetentionLeaseHelper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.attemptRetentionLeaseRemoval(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retentionLeaseId = RemoteClusterRetentionLeaseHelper.Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
                request = new RetentionLeaseActions.RemoveRequest(leaderShardId, retentionLeaseId);
                v0 = (OpenSearchClient)this.client;
                v1 = RetentionLeaseActions.Remove.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"INSTANCE");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)leaderShardId);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)followerShardId);
                $continuation.L$2 = retentionLeaseId;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 1;
                v2 = CoroutinesKt.suspendExecute$default(v0, (ActionType)v1, (ActionRequest)request, false, false, (Continuation)$continuation, 12, null);
                ** if (v2 != var9_6) goto lbl27
lbl26:
                // 1 sources

                return var9_6;
lbl27:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                request = (RetentionLeaseActions.RemoveRequest)$continuation.L$3;
                retentionLeaseId = (String)$continuation.L$2;
                followerShardId = (ShardId)$continuation.L$1;
                leaderShardId = (ShardId)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl37:
                    // 2 sources

                    RemoteClusterRetentionLeaseHelper.log.info("Removed retention lease with id - " + retentionLeaseId);
                }
                catch (RetentionLeaseNotFoundException e) {
                    RemoteClusterRetentionLeaseHelper.log.error(ExtensionsKt.stackTraceToString(e));
                }
                catch (Exception e) {
                    RemoteClusterRetentionLeaseHelper.log.error("Exception in removing retention lease", (Throwable)e);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void attemptRetentionLeaseRemoval(@NotNull ShardId leaderShardId, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.RemoveRequest request = new RetentionLeaseActions.RemoveRequest(leaderShardId, retentionLeaseId);
        try {
            this.client.execute((ActionType)RetentionLeaseActions.Remove.INSTANCE, (ActionRequest)request).actionGet(timeout);
            log.info("Removed retention lease with id - " + retentionLeaseId);
        }
        catch (RetentionLeaseNotFoundException e) {
            log.error(ExtensionsKt.stackTraceToString(e));
        }
        catch (Exception e) {
            log.error("Exception in removing retention lease", (Throwable)e);
        }
    }

    public final void addRetentionLease(@NotNull ShardId leaderShardId, long seqNo, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.AddRequest request = new RetentionLeaseActions.AddRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
        boolean canRetry = true;
        while (true) {
            try {
                log.info("Adding retention lease " + retentionLeaseId);
                this.client.execute((ActionType)RetentionLeaseActions.Add.INSTANCE, (ActionRequest)request).actionGet(timeout);
            }
            catch (RetentionLeaseAlreadyExistsException e) {
                log.info("Found a stale retention lease " + retentionLeaseId + " on leader.");
                if (canRetry) {
                    canRetry = false;
                    this.attemptRetentionLeaseRemoval(leaderShardId, followerShardId, timeout);
                    log.info("Cleared stale retention lease " + retentionLeaseId + " on leader. Retrying...");
                    continue;
                }
                log.error(ExtensionsKt.stackTraceToString(e));
                throw e;
            }
            break;
        }
    }

    public final void renewRetentionLease(@NotNull ShardId leaderShardId, long seqNo, @NotNull ShardId followerShardId, long timeout) {
        Intrinsics.checkNotNullParameter((Object)leaderShardId, (String)"leaderShardId");
        Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
        String retentionLeaseId = Companion.retentionLeaseIdForShard(this.followerClusterNameWithUUID, followerShardId);
        RetentionLeaseActions.RenewRequest request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, seqNo, this.retentionLeaseSource);
        this.client.execute((ActionType)RetentionLeaseActions.Renew.INSTANCE, (ActionRequest)request).actionGet(timeout);
    }

    public static final /* synthetic */ Object access$addNewRetentionLeaseIfOldExists(RemoteClusterRetentionLeaseHelper $this, ShardId leaderShardId, ShardId followerShardId, long seqNo, Continuation $completion) {
        return $this.addNewRetentionLeaseIfOldExists(leaderShardId, followerShardId, seqNo, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$addNewRetentionLease(RemoteClusterRetentionLeaseHelper $this, ShardId leaderShardId, long seqNo, ShardId followerShardId, long timeout, Continuation $completion) {
        return $this.addNewRetentionLease(leaderShardId, seqNo, followerShardId, timeout, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$getLeaderIndexMetadata(RemoteClusterRetentionLeaseHelper $this, String leaderAlias, String leaderIndex, Continuation $completion) {
        return $this.getLeaderIndexMetadata(leaderAlias, leaderIndex, (Continuation<? super IndexMetadata>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bJ\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/replication/seqno/RemoteClusterRetentionLeaseHelper$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "RETENTION_LEASE_PREFIX", "", "retentionLeaseSource", "followerClusterName", "retentionLeaseIdForShard", "followerShardId", "Lorg/opensearch/core/index/shard/ShardId;", "getFollowerClusterNameWithUUID", "followerClusterUUID", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String retentionLeaseSource(@NotNull String followerClusterName) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            return RemoteClusterRetentionLeaseHelper.RETENTION_LEASE_PREFIX + followerClusterName;
        }

        @NotNull
        public final String retentionLeaseIdForShard(@NotNull String followerClusterName, @NotNull ShardId followerShardId) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            Intrinsics.checkNotNullParameter((Object)followerShardId, (String)"followerShardId");
            String retentionLeaseSource = this.retentionLeaseSource(followerClusterName);
            return retentionLeaseSource + ":" + followerShardId;
        }

        @NotNull
        public final String getFollowerClusterNameWithUUID(@NotNull String followerClusterName, @NotNull String followerClusterUUID) {
            Intrinsics.checkNotNullParameter((Object)followerClusterName, (String)"followerClusterName");
            Intrinsics.checkNotNullParameter((Object)followerClusterUUID, (String)"followerClusterUUID");
            return followerClusterName + ":" + followerClusterUUID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

