function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import classnames from 'classnames';
import { keysOf } from '../../common';
import { OuiColorPaletteDisplayFixed } from './color_palette_display_fixed';
import { OuiColorPaletteDisplayGradient } from './color_palette_display_gradient';
var sizeToClassNameMap = {
  xs: 'ouiColorPaletteDisplay--sizeExtraSmall',
  s: 'ouiColorPaletteDisplay--sizeSmall',
  m: 'ouiColorPaletteDisplay--sizeMedium'
};
export var SIZES = keysOf(sizeToClassNameMap);
export var OuiColorPaletteDisplay = function OuiColorPaletteDisplay(_ref) {
  var _ref$type = _ref.type,
    type = _ref$type === void 0 ? 'fixed' : _ref$type,
    palette = _ref.palette,
    className = _ref.className,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    rest = _objectWithoutProperties(_ref, ["type", "palette", "className", "size"]);
  var classes = classnames('ouiColorPaletteDisplay', className, sizeToClassNameMap[size]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, type === 'fixed' ? /*#__PURE__*/React.createElement(OuiColorPaletteDisplayFixed, _extends({
    className: classes,
    palette: palette
  }, rest)) : /*#__PURE__*/React.createElement(OuiColorPaletteDisplayGradient, _extends({
    className: classes,
    palette: palette
  }, rest)));
};

/* OUI -> EUI Aliases: Build-Time */
OuiColorPaletteDisplay.propTypes = {
  /**
     * Height of the palette display
     */
  size: PropTypes.oneOf(["xs", "s", "m"]),
  /**
     *   Specify the type of palette.
     *  `gradient`: each color fades into the next.
     */
  /**
     *  `fixed`: individual color blocks.
     */
  type: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["gradient"]).isRequired]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  /**
     * Array of color `strings` or an array of #ColorStop. The stops must be numbers in an ordered range.
     */
  /**
     * Array of color `strings` or an array of #ColorStop. The stops must be numbers in an ordered range.
     */
  palette: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string.isRequired).isRequired, PropTypes.arrayOf(PropTypes.shape({
    stop: PropTypes.number.isRequired,
    color: PropTypes.string.isRequired
  }).isRequired).isRequired]).isRequired
};
/* OUI -> EUI Aliases: Build-Time */export { EuiColorPaletteDisplay } from '../../../eui_components/color_picker/color_palette_display/color_palette_display';