/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.annotation;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.annotation.AnnotationProvider;
import org.protege.editor.owl.model.annotation.AnnotationValueProvider;
import org.protege.editor.owl.model.annotation.DateAnnotationValueProvider;
import org.protege.editor.owl.model.annotation.DefaultDateAnnotationPropertyIriProvider;
import org.protege.editor.owl.model.annotation.DefaultUserNameAnnotationPropertyIriProvider;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataPreferencesManager;
import org.protege.editor.owl.model.annotation.EntityCreationMetadataProvider;
import org.protege.editor.owl.model.annotation.OrcidAnnotationValueProvider;
import org.protege.editor.owl.model.annotation.SimpleEntityCreationMetadataProvider;
import org.protege.editor.owl.model.annotation.UserNameAnnotationValueProvider;
import org.protege.editor.owl.model.git.GitRepositoryManager;
import org.protege.editor.owl.model.user.DefaultUserNameProvider;
import org.protege.editor.owl.model.user.OrcidPreferencesManager;
import org.protege.editor.owl.model.user.UserNamePreferencesManager;

public class PreferencesBasedEntityCreationMetadataProviderFactory {
    @Nonnull
    private final OWLModelManager modelManager;
    @Nonnull
    private final UserNamePreferencesManager userNamePreferencesManager;
    @Nonnull
    private final OrcidPreferencesManager orcidPreferencesManager;
    @Nonnull
    private final EntityCreationMetadataPreferencesManager metadataPreferencesManager;

    public PreferencesBasedEntityCreationMetadataProviderFactory(@Nonnull OWLModelManager manager, @Nonnull UserNamePreferencesManager userNamePreferencesManager, @Nonnull OrcidPreferencesManager orcidPreferencesManager, @Nonnull EntityCreationMetadataPreferencesManager metadataPreferencesManager) {
        this.modelManager = (OWLModelManager)Preconditions.checkNotNull((Object)manager);
        this.userNamePreferencesManager = (UserNamePreferencesManager)Preconditions.checkNotNull((Object)userNamePreferencesManager);
        this.orcidPreferencesManager = (OrcidPreferencesManager)Preconditions.checkNotNull((Object)orcidPreferencesManager);
        this.metadataPreferencesManager = (EntityCreationMetadataPreferencesManager)Preconditions.checkNotNull((Object)metadataPreferencesManager);
    }

    public EntityCreationMetadataProvider getProvider() {
        AnnotationProvider provider;
        ArrayList<AnnotationProvider> fields = new ArrayList<AnnotationProvider>();
        if (this.metadataPreferencesManager.isCreatedByAnnotationEnabled()) {
            provider = this.getCreatedByAnnotationProvider();
            fields.add(provider);
        }
        if (this.metadataPreferencesManager.isCreationDateAnnotationEnabled()) {
            provider = this.getCreationDateAnnotationProvider();
            fields.add(provider);
        }
        return new SimpleEntityCreationMetadataProvider(fields);
    }

    private AnnotationProvider getCreationDateAnnotationProvider() {
        return new AnnotationProvider(new DefaultDateAnnotationPropertyIriProvider(this.metadataPreferencesManager), new DateAnnotationValueProvider(this.metadataPreferencesManager.getDateFormatter()));
    }

    private AnnotationProvider getCreatedByAnnotationProvider() {
        AnnotationValueProvider createdByValueProvider = this.metadataPreferencesManager.isCreatedByValueOrcid() && this.orcidPreferencesManager.getOrcid().isPresent() ? new OrcidAnnotationValueProvider(this.orcidPreferencesManager) : new UserNameAnnotationValueProvider(new DefaultUserNameProvider(GitRepositoryManager.get(this.modelManager), this.userNamePreferencesManager, System.getProperties()));
        return new AnnotationProvider(new DefaultUserNameAnnotationPropertyIriProvider(this.metadataPreferencesManager), createdByValueProvider);
    }
}

