/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.inference;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.model.inference.DisplayedInferencePreferences;
import org.protege.editor.owl.model.inference.PrecomputedInferencePreferences;
import org.protege.editor.owl.model.inference.ReasonerPreferencesListener;
import org.semanticweb.owlapi.reasoner.InferenceType;

public class ReasonerPreferences {
    public static final String PREFERENCES_SET_KEY = "INFERENCE_PREFS_SET";
    public static final String DEFAULT_REASONER_ID = "DEFAULT_REASONER_ID";
    private DisplayedInferencePreferences displayed = new DisplayedInferencePreferences();
    private PrecomputedInferencePreferences precompute = new PrecomputedInferencePreferences();
    private String defaultReasonerId;
    private List<ReasonerPreferencesListener> listeners = new ArrayList<ReasonerPreferencesListener>();

    static Preferences getPreferences() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        return prefMan.getPreferencesForSet(PREFERENCES_SET_KEY, ReasonerPreferences.class);
    }

    public String getDefaultReasonerId() {
        return this.defaultReasonerId;
    }

    public void setDefaultReasonerId(String defaultReasonerId) {
        this.defaultReasonerId = defaultReasonerId;
    }

    public void load() {
        Preferences prefs = ReasonerPreferences.getPreferences();
        this.displayed.load(this);
        this.precompute.load(prefs);
        this.defaultReasonerId = prefs.getString(DEFAULT_REASONER_ID, "org.protege.editor.owl.NoOpReasoner");
    }

    public void save() {
        Preferences prefs = ReasonerPreferences.getPreferences();
        this.displayed.save(this);
        this.precompute.save(prefs);
        prefs.putString(DEFAULT_REASONER_ID, this.defaultReasonerId);
    }

    public void addListener(ReasonerPreferencesListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ReasonerPreferencesListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChanged() {
        for (ReasonerPreferencesListener listener : this.listeners) {
            listener.preferencesChanged();
        }
    }

    public Set<InferenceType> getPrecomputedInferences() {
        return this.precompute.getPrecomputedInferences();
    }

    public void requestPrecomputedInferences(String requestor, Set<InferenceType> types) {
        this.precompute.requestPrecomputedInferences(requestor, types);
        this.fireChanged();
    }

    public Set<String> getRequestors(InferenceType type) {
        return this.precompute.getRequestors(type);
    }

    public Set<InferenceType> getRequired() {
        return this.precompute.getRequired();
    }

    public void setRequired(InferenceType type, boolean isRequired) {
        this.precompute.setRequired(type, isRequired);
        this.fireChanged();
    }

    public Set<InferenceType> getDisallowed() {
        return this.precompute.getDisallowed();
    }

    public void setDisallowed(InferenceType type, boolean isDisallowed) {
        this.precompute.setDisallowed(type, isDisallowed);
        this.fireChanged();
    }

    public boolean isShowInferences() {
        return this.displayed.isShowInferences();
    }

    public void setShowInferences(boolean showInferences) {
        this.displayed.setShowInferences(showInferences);
        this.fireChanged();
    }

    public void startClock(OptionalInferenceTask task) {
        this.displayed.startClock(task);
    }

    public void stopClock(OptionalInferenceTask task) {
        this.displayed.stopClock(task);
    }

    public int getTimeInTask(OptionalInferenceTask task) {
        return this.displayed.getTimeInTask(task);
    }

    public int getAverageTimeInTask(OptionalInferenceTask task) {
        return this.displayed.getAverageTimeInTask(task);
    }

    public boolean isEnabled(OptionalInferenceTask task) {
        return this.displayed.isEnabled(task);
    }

    public void setEnabled(OptionalInferenceTask task, boolean enabled) {
        this.displayed.setEnabled(task, enabled);
        this.fireChanged();
    }

    public void executeTask(OptionalInferenceTask task, Runnable implementation) {
        this.displayed.executeTask(task, implementation);
    }

    public static enum OptionalInferenceTask {
        SHOW_CLASS_UNSATISFIABILITY(true, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERRED_EQUIVALENT_CLASSES(true, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERRED_SUPER_CLASSES(true, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERED_CLASS_MEMBERS(true, InferenceType.CLASS_ASSERTIONS),
        SHOW_INFERRED_DISJOINT_CLASSES(false, InferenceType.CLASS_HIERARCHY),
        SHOW_OBJECT_PROPERTY_UNSATISFIABILITY(true, InferenceType.OBJECT_PROPERTY_HIERARCHY),
        SHOW_INFERRED_OBJECT_PROPERTY_DOMAINS(false, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERRED_OBJECT_PROPERTY_RANGES(false, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERRED_EQUIVALENT_OBJECT_PROPERTIES(true, InferenceType.OBJECT_PROPERTY_HIERARCHY),
        SHOW_INFERRED_SUPER_OBJECT_PROPERTIES(true, InferenceType.OBJECT_PROPERTY_HIERARCHY),
        SHOW_INFERRED_INVERSE_PROPERTIES(true, InferenceType.OBJECT_PROPERTY_HIERARCHY),
        SHOW_INFERRED_DATATYPE_PROPERTY_DOMAINS(false, InferenceType.CLASS_HIERARCHY),
        SHOW_INFERRED_EQUIVALENT_DATATYPE_PROPERTIES(true, InferenceType.DATA_PROPERTY_HIERARCHY),
        SHOW_INFERRED_SUPER_DATATYPE_PROPERTIES(true, InferenceType.DATA_PROPERTY_HIERARCHY),
        SHOW_INFERRED_TYPES(true, InferenceType.CLASS_ASSERTIONS),
        SHOW_INFERRED_OBJECT_PROPERTY_ASSERTIONS(true, InferenceType.OBJECT_PROPERTY_ASSERTIONS),
        SHOW_INFERRED_DATA_PROPERTY_ASSERTIONS(false, InferenceType.DATA_PROPERTY_ASSERTIONS),
        SHOW_INFERRED_SAMEAS_INDIVIDUAL_ASSERTIONS(true, InferenceType.SAME_INDIVIDUAL);

        private boolean enabledByDefault;
        private InferenceType suggestedInferenceType;

        private OptionalInferenceTask(boolean enabledByDefault, InferenceType suggestedInferenceType) {
            this.enabledByDefault = enabledByDefault;
            this.suggestedInferenceType = suggestedInferenceType;
        }

        public String getKey() {
            return this.toString();
        }

        public boolean getEnabledByDefault() {
            return this.enabledByDefault;
        }

        public InferenceType getSuggestedInferenceType() {
            return this.suggestedInferenceType;
        }
    }
}

