/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridFilterAndSortingComponent;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSortingModel;
import com.intellij.database.run.ui.grid.GridFilterPanel;
import com.intellij.database.run.ui.grid.GridSortingPanel;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridFilterAndSortingComponentImpl
extends EditorHeaderComponent
implements GridFilterAndSortingComponent {
    private static final String FILTER_PREFERRED_SIZE_KEY = "GridFilterComponent.FILTER_PREFERRED_SIZE";
    private final GridFilterPanel myFilterPanel;
    private final GridSortingPanel mySortingPanel;
    private final OnePixelSplitter mySplitter;
    private final DataGrid myGrid;

    public GridFilterAndSortingComponentImpl(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            GridFilterAndSortingComponentImpl.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridFilterAndSortingComponentImpl.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.setBorder((Border)JBUI.Borders.empty());
        this.mySplitter = new OnePixelSplitter(1.0E-4f);
        this.mySplitter.setLackOfSpaceStrategy(Splitter.LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE);
        this.mySplitter.setFocusTraversalPolicyProvider(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy(this));
        this.add((Component)this.mySplitter, "Center");
        this.myFilterPanel = new GridFilterPanel(project, this.myGrid);
        this.setupFilterSize();
        this.myFilterPanel.myEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridFilterAndSortingComponentImpl.this.myFilterPanel.myEditor.getScrollPane().doLayout();
                GridFilterAndSortingComponentImpl.this.mySplitter.revalidate();
                GridFilterAndSortingComponentImpl.this.mySplitter.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/run/ui/grid/GridFilterAndSortingComponentImpl$1", "documentChanged"));
            }
        }, (Disposable)this.myGrid);
        this.mySplitter.setFirstComponent((JComponent)this.myFilterPanel);
        GridSortingModel sortingModel = this.myGrid.getDataHookup().getSortingModel();
        Document document = sortingModel == null ? null : sortingModel.getDocument();
        CompoundBorder border = new CompoundBorder((Border)new CustomLineBorder(JBColor.border(), 0, 0, 1, 0), (Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
        this.myFilterPanel.setBorder(border);
        GridSortingPanel gridSortingPanel = this.mySortingPanel = document == null ? null : new GridSortingPanel(project, this.myGrid, (GridSortingModel<GridRow, GridColumn>)sortingModel, document);
        if (this.mySortingPanel != null) {
            this.mySortingPanel.setBorder(border);
            this.mySplitter.setSecondComponent((JComponent)this.mySortingPanel);
        }
    }

    private void setupFilterSize() {
        UiNotifyConnector.Once.installOn((Component)((Object)this), (Activatable)new Activatable(){

            public void showNotify() {
                int width = 300;
                try {
                    String size = PropertiesComponent.getInstance().getValue(GridFilterAndSortingComponentImpl.FILTER_PREFERRED_SIZE_KEY, Integer.toString(300));
                    width = Math.max(300, Integer.parseInt(size));
                }
                catch (NumberFormatException size) {
                    // empty catch block
                }
                float proportion = (float)width / (float)GridFilterAndSortingComponentImpl.this.mySplitter.getWidth();
                GridFilterAndSortingComponentImpl.this.mySplitter.setProportion(Math.max(0.0f, Math.min(1.0f, proportion)));
                GridFilterAndSortingComponentImpl.this.mySplitter.addPropertyChangeListener(e -> {
                    if ("proportion".equals(e.getPropertyName())) {
                        PropertiesComponent.getInstance().setValue(GridFilterAndSortingComponentImpl.FILTER_PREFERRED_SIZE_KEY, Integer.toString(GridFilterAndSortingComponentImpl.this.myFilterPanel.getWidth()));
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public GridFilterPanel getFilterPanel() {
        GridFilterPanel gridFilterPanel = this.myFilterPanel;
        if (gridFilterPanel == null) {
            GridFilterAndSortingComponentImpl.$$$reportNull$$$0(2);
        }
        return gridFilterPanel;
    }

    @Override
    @Nullable
    public GridSortingPanel getSortingPanel() {
        return this.mySortingPanel;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        GridFilterAndSortingComponentImpl gridFilterAndSortingComponentImpl = this;
        if (gridFilterAndSortingComponentImpl == null) {
            GridFilterAndSortingComponentImpl.$$$reportNull$$$0(3);
        }
        return gridFilterAndSortingComponentImpl;
    }

    @Override
    public void toggleSortingPanel(boolean visible) {
        if (this.mySortingPanel == null) {
            return;
        }
        if (visible) {
            this.mySplitter.setSecondComponent((JComponent)this.mySortingPanel);
        } else {
            this.mySplitter.setSecondComponent(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridFilterAndSortingComponentImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridFilterAndSortingComponentImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private final GridFilterAndSortingComponentImpl myComponent;

        MyFocusTraversalPolicy(GridFilterAndSortingComponentImpl component) {
            this.myComponent = component;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            return component == this.myComponent.myFilterPanel.myEditor.getContentComponent() ? this.myComponent.mySortingPanel.myEditor.getContentComponent() : this.myComponent.myGrid.getPreferredFocusedComponent();
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            return component == this.myComponent.mySortingPanel.myEditor.getContentComponent() ? this.myComponent.myFilterPanel.myEditor.getContentComponent() : null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.myComponent.myFilterPanel.myEditor.getContentComponent();
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.myComponent.mySortingPanel.myEditor.getContentComponent();
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.myComponent.myFilterPanel.myEditor.getContentComponent();
        }
    }
}

