\name{RegionalMaximaImageFilter}
\alias{RegionalMaximaImageFilter}
\title{RegionalMaximaImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Produce a binary image where foreground is the regional maxima of the
input image.
RegionalMaximaImageFilter}
\details{
Regional maxima are flat zones surrounded by pixels of lower value.
If the input image is constant, the entire image can be considered as
a maxima or not. The desired behavior can be selected with the SetFlatIsMaxima() method.
Gaetan Lehmann
 This class was contributed to the Insight Journal by author Gaetan
Lehmann. Biologie du Developpement et de la Reproduction, INRA de
Jouy-en-Josas, France. The paper can be found at https://www.insight-journal.org/browse/publication/65
See:
ValuedRegionalMaximaImageFilter
HConvexImageFilter
RegionalMinimaImageFilter
RegionalMaxima for the procedural interface
itk::RegionalMaximaImageFilter for the Doxygen on the original ITK class.
RegionalMaximaImageFilter}
%C++ includes: sitkRegionalMaximaImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FlatIsMaximaOff():}{}
\item{Self FlatIsMaximaOn():}{
Set the value of FlatIsMaxima to true or false respectfully.
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{bool GetFlatIsMaxima() const:}{
Set/Get whether a flat image must be considered as a maxima or not.
Defaults to true.
}
\item{double GetForegroundValue() const:}{
Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ RegionalMaximaImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetFlatIsMaxima(bool FlatIsMaxima):}{
Set/Get whether a flat image must be considered as a maxima or not.
Defaults to true.
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value in the output image to consider as "foreground".
Defaults to maximum value of PixelType.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~RegionalMaximaImageFilter():}{
Destructor
}
}
}
