/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CSocketInputStreamWrapper
extends NetInputStream {
    private static final int MAX_BUFFER_SIZE = 2048;
    private NetInputStream is;
    private T4CSocketOutputStreamWrapper os;
    private boolean eof;
    private byte[] buffer;
    private int bIndex;
    private int bytesAvailable;
    private final SessionAtts session;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    T4CSocketInputStreamWrapper(NetInputStream _is, T4CSocketOutputStreamWrapper _os, SessionAtts session) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$7, null, _is, _os, session);
            }
            this.is = null;
            this.os = null;
            this.eof = false;
            this.buffer = new byte[2048];
            this.bIndex = 0;
            this.is = _is;
            this.os = _os;
            this.session = session;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$7, null);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$7, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final int read() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if (this.eof) {
                int n2 = -1;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, null);
                }
                return -1;
            }
            if (this.bytesAvailable < 1) {
                this.readNextPacket();
                if (this.eof) {
                    int n3 = -1;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, null);
                    }
                    return -1;
                }
            }
            --this.bytesAvailable;
            int n4 = this.buffer[this.bIndex++] & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, n4);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void var6_6;
            block12: {
                void offset;
                void b2;
                void length;
                block10: {
                    int n4;
                    block11: {
                        int n5;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, byArray, n2, n3);
                        }
                        try {
                            if (!this.eof) break block10;
                            n4 = n5 = 0;
                            if (!bl) break block11;
                        }
                        catch (NetException ne) {
                            ne.setNetConnectionId(this.session.getNetConnectionId());
                            NetException netException = ne;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, netException);
                            }
                            throw netException;
                        }
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, null);
                    }
                    return n4;
                }
                if (this.bytesAvailable < length) {
                    int bytes2Copy = this.bytesAvailable;
                    System.arraycopy(this.buffer, this.bIndex, b2, (int)offset, bytes2Copy);
                    this.bIndex += bytes2Copy;
                    this.bytesAvailable -= bytes2Copy;
                    this.is.read((byte[])b2, (int)(offset += bytes2Copy), (int)(length - bytes2Copy));
                } else {
                    System.arraycopy(this.buffer, this.bIndex, b2, (int)offset, (int)length);
                    this.bIndex += length;
                    this.bytesAvailable -= length;
                }
                var6_6 = length;
                if (!bl) break block12;
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, (int)var6_6);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, null);
            }
            return (int)var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    void readNextPacket() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int x2;
            block10: {
                block11: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this, new Object[0]);
                    }
                    try {
                        this.os.flush();
                        x2 = this.is.read();
                        if (x2 != -1) break block10;
                        this.eof = true;
                        if (!bl) break block11;
                    }
                    catch (NetException ne) {
                        ne.setNetConnectionId(this.session.getNetConnectionId());
                        NetException netException = ne;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this, netException);
                        }
                        throw netException;
                    }
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            this.buffer[0] = (byte)x2;
            this.bytesAvailable = this.is.available() + 1;
            int n2 = this.bytesAvailable = this.bytesAvailable > 2048 ? 2048 : this.bytesAvailable;
            if (this.bytesAvailable > 1) {
                this.is.read(this.buffer, 1, this.bytesAvailable - 1);
            }
            this.bIndex = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int readB1() throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$3, this, new Object[0]);
            }
            int n2 = this.read();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long readLongLSB(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block10: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$4, this, n2);
                }
                try {
                    int bufSize;
                    long returnValue = 0L;
                    boolean negative = false;
                    if ((bufSize & 0x80) > 0) {
                        bufSize &= 0x7F;
                        negative = true;
                    }
                    void i2 = bufSize;
                    int j2 = 0;
                    while (i2 > 0) {
                        if (this.bytesAvailable < 1) {
                            this.readNextPacket();
                        }
                        returnValue |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * j2;
                        --this.bytesAvailable;
                        --i2;
                        ++j2;
                    }
                    l2 = (long)(negative ? -1 : 1) * returnValue;
                    if (!bl) break block10;
                }
                catch (NetException ne) {
                    ne.setNetConnectionId(this.session.getNetConnectionId());
                    NetException netException = ne;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$4, this, netException);
                    }
                    throw netException;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$4, this, l2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$4, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long readLongMSB(int n2) throws IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            block10: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$5, this, n2);
                }
                try {
                    int bufSize;
                    long returnValue = 0L;
                    boolean negative = false;
                    if ((bufSize & 0x80) > 0) {
                        bufSize &= 0x7F;
                        negative = true;
                    }
                    for (void i2 = bufSize; i2 > 0; --i2) {
                        if (this.bytesAvailable < 1) {
                            this.readNextPacket();
                        }
                        returnValue |= ((long)this.buffer[this.bIndex++] & 0xFFL) << 8 * (i2 - true);
                        --this.bytesAvailable;
                    }
                    l2 = (long)(negative ? -1 : 1) * returnValue;
                    if (!bl) break block10;
                }
                catch (NetException ne) {
                    ne.setNetConnectionId(this.session.getNetConnectionId());
                    NetException netException = ne;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$5, this, netException);
                    }
                    throw netException;
                }
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$5, this, l2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$5, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException, BreakNetException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$6, this, byArray, n2, nArray);
                }
                try {
                    void bytesRead;
                    void offset;
                    void userBuffer;
                    this.os.flush();
                    bl2 = this.is.readZeroCopyIO((byte[])userBuffer, (int)offset, (int[])bytesRead);
                    if (!bl) break block7;
                }
                catch (NetException ne) {
                    ne.setNetConnectionId(this.session.getNetConnectionId());
                    NetException netException = ne;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$6, this, netException);
                    }
                    throw netException;
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$6, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CSocketInputStreamWrapper.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$7 = T4CSocketInputStreamWrapper.class.getDeclaredConstructor(NetInputStream.class, T4CSocketOutputStreamWrapper.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("readLongMSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("readLongLSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("readB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("readNextPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CSocketInputStreamWrapper.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

