/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyMappingCheckNode;
import com.oracle.graal.python.lib.PyObjectAsciiNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.BytesFormatter;
import com.oracle.graal.python.runtime.formatting.FormatProcessor;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class BytesFormatProcessor
extends FormatProcessor<byte[]> {
    private final byte[] formatBytes;
    private final int bytesLength;

    public BytesFormatProcessor(Python3Core core, byte[] formatBytes, int bytesLength, Node raisingNode) {
        super(core, new FormattingBuffer.BytesFormattingBuffer(), raisingNode);
        this.formatBytes = formatBytes;
        this.bytesLength = bytesLength;
    }

    @Override
    protected String getFormatType() {
        return "bytes";
    }

    @Override
    <F extends InternalFormat.Formatter> F setupFormat(F f) {
        f.setBytes(true);
        return f;
    }

    @Override
    char pop() {
        try {
            return (char)this.formatBytes[this.index++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.ValueError, ErrorMessages.INCOMPLETE_FORMAT);
        }
    }

    @Override
    boolean hasNext() {
        return this.index < this.bytesLength;
    }

    @Override
    int parseNumber(int start, int end) {
        String str = new String(this.formatBytes, start, end - start, StandardCharsets.US_ASCII);
        return Integer.parseInt(str);
    }

    @Override
    Object parseMappingKey(int start, int end) {
        return PFactory.createBytes(PythonLanguage.get(null), Arrays.copyOfRange(this.formatBytes, start, end));
    }

    @Override
    protected boolean isMapping(Object obj) {
        return !(obj instanceof PTuple) && !(obj instanceof PBytesLike) && !(obj instanceof PString) && !(obj instanceof TruffleString) && !TruffleStringMigrationHelpers.isJavaString(obj) && PyMappingCheckNode.executeUncached(obj);
    }

    @Override
    protected double asFloat(Object arg) {
        try {
            return super.asFloat(arg);
        }
        catch (PException ex) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.TypeError, ErrorMessages.FLOAT_ARG_REQUIRED, arg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected InternalFormat.Formatter handleSingleCharacterFormat(InternalFormat.Spec spec) {
        PythonBufferAccessLibrary bufferLib;
        Object arg = this.getArg();
        if (arg instanceof PBytesLike && (bufferLib = (PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().getUncached(arg)).getBufferLength(arg) == 1) {
            BytesFormatter f = new BytesFormatter(this.buffer, spec, this.raisingNode);
            f.format(bufferLib.readByte(arg, 0));
            return f;
        }
        boolean foundByte = false;
        byte value = 0;
        if ((arg = BytesFormatProcessor.asNumber(arg, spec.type)) instanceof Long) {
            long argLong = (Long)arg;
            if ((argLong & 0xFFL) != argLong) throw this.raiseOverflow();
            value = (byte)argLong;
            foundByte = true;
        } else if (arg instanceof PInt) {
            try {
                value = ((PInt)arg).byteValueExact();
                foundByte = true;
            }
            catch (ArithmeticException ex) {
                throw this.raiseOverflow();
            }
        } else if (arg instanceof Integer) {
            int argInt = (Integer)arg;
            if ((argInt & 0xFF) != argInt) throw this.raiseOverflow();
            value = (byte)argInt;
            foundByte = true;
        }
        if (!foundByte) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.TypeError, ErrorMessages.C_REQUIRES_INT_IN_BYTE_RANGE_OR_SINGLE_BYTE);
        }
        BytesFormatter f = new BytesFormatter(this.buffer, spec, this.raisingNode);
        f.format(value);
        return f;
    }

    private PException raiseOverflow() {
        throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.OverflowError, ErrorMessages.C_ARG_NOT_IN_RANGE256_DECIMAL);
    }

    @Override
    protected InternalFormat.Formatter handleRemainingFormats(InternalFormat.Spec spec) {
        switch (spec.type) {
            case 'b': 
            case 's': {
                byte[] bytes = this.asBytes(this.getArg());
                BytesFormatter fb = new BytesFormatter(this.buffer, spec, this.raisingNode);
                fb.format(bytes);
                return fb;
            }
            case 'a': 
            case 'r': {
                String result = PyObjectAsciiNode.executeUncached(this.getArg()).toJavaStringUncached();
                BytesFormatter fb = new BytesFormatter(this.buffer, spec, this.raisingNode);
                fb.formatAsciiString(result);
                return fb;
            }
        }
        return null;
    }

    private byte[] asBytes(Object arg) {
        if (arg instanceof PBytesLike) {
            return BytesFormatProcessor.toBytes((PBytesLike)arg);
        }
        Object attribute = BytesFormatProcessor.lookupAttribute(arg, SpecialMethodNames.T___BYTES__);
        if (attribute != PNone.NO_VALUE) {
            Object bytesResult = BytesFormatProcessor.call(attribute, arg);
            if (!(bytesResult instanceof PBytes)) {
                throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.TypeError, ErrorMessages.RETURNED_NONBYTES, SpecialMethodNames.T___BYTES__, arg);
            }
            return BytesFormatProcessor.toBytes((PBytes)bytesResult);
        }
        byte[] result = BytesFormatProcessor.byteBufferAsBytesOrNull(arg);
        if (result == null) {
            throw PRaiseNode.raiseStatic(this.raisingNode, PythonErrorType.TypeError, ErrorMessages.B_REQUIRES_BYTES_OR_OBJ_THAT_IMPLEMENTS_S_NOT_P, SpecialMethodNames.T___BYTES__, arg);
        }
        return result;
    }

    private static byte[] toBytes(PBytesLike arg) {
        return SequenceStorageNodes.ToByteArrayNode.executeUncached(arg.getSequenceStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] byteBufferAsBytesOrNull(Object obj) {
        PythonBufferAcquireLibrary acquireLib = (PythonBufferAcquireLibrary)PythonBufferAcquireLibrary.getFactory().getUncached(obj);
        if (acquireLib.hasBuffer(obj)) {
            Object buffer = acquireLib.acquire(obj, 8);
            PythonBufferAccessLibrary bufferLib = (PythonBufferAccessLibrary)PythonBufferAccessLibrary.getFactory().getUncached(buffer);
            try {
                byte[] byArray = bufferLib.getCopiedByteArray(buffer);
                return byArray;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
        return null;
    }
}

