/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Locale;
import org.apache.catalina.ssi.SSICommand;
import org.apache.catalina.ssi.SSIMediator;
import org.apache.catalina.util.Strftime;
import org.apache.tomcat.util.res.StringManager;

public final class SSIFlastmod
implements SSICommand {
    private static final StringManager sm = StringManager.getManager(SSIFlastmod.class);

    @Override
    public long process(SSIMediator sSIMediator, String string, String[] stringArray, String[] stringArray2, PrintWriter printWriter) {
        long l = 0L;
        String string2 = sSIMediator.getConfigErrMsg();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String string4 = stringArray2[i];
            String string5 = sSIMediator.substituteVariables(string4);
            try {
                if (string3.equalsIgnoreCase("file") || string3.equalsIgnoreCase("virtual")) {
                    boolean bl = string3.equalsIgnoreCase("virtual");
                    l = sSIMediator.getFileLastModified(string5, bl);
                    Date date = new Date(l);
                    String string6 = sSIMediator.getConfigTimeFmt();
                    printWriter.write(this.formatDate(date, string6));
                    continue;
                }
                sSIMediator.log(sm.getString("ssiCommand.invalidAttribute", new Object[]{string3}));
                printWriter.write(string2);
                continue;
            }
            catch (IOException iOException) {
                sSIMediator.log(sm.getString("ssiFlastmod.noLastModified", new Object[]{string5}), iOException);
                printWriter.write(string2);
            }
        }
        return l;
    }

    protected String formatDate(Date date, String string) {
        Strftime strftime = new Strftime(string, Locale.US);
        return strftime.format(date);
    }
}

