/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface Leashable {
    public static final String LEASH_TAG = "leash";
    public static final double LEASH_TOO_FAR_DIST = 12.0;
    public static final double LEASH_ELASTIC_DIST = 6.0;
    public static final double MAXIMUM_ALLOWED_LEASHED_DIST = 16.0;
    public static final Vec3 AXIS_SPECIFIC_ELASTICITY = new Vec3(0.8, 0.2, 0.8);
    public static final float SPRING_DAMPENING = 0.7f;
    public static final double TORSIONAL_ELASTICITY = 10.0;
    public static final double STIFFNESS = 0.11;
    public static final List<Vec3> ENTITY_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.5));
    public static final List<Vec3> LEASHER_ATTACHMENT_POINT = ImmutableList.of((Object)new Vec3(0.0, 0.5, 0.0));
    public static final List<Vec3> SHARED_QUAD_ATTACHMENT_POINTS = ImmutableList.of((Object)new Vec3(-0.5, 0.5, 0.5), (Object)new Vec3(-0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, -0.5), (Object)new Vec3(0.5, 0.5, 0.5));

    @Nullable
    public LeashData getLeashData();

    public void setLeashData(@Nullable LeashData var1);

    default public boolean isLeashed() {
        return this.getLeashData() != null && this.getLeashData().leashHolder != null;
    }

    default public boolean mayBeLeashed() {
        return this.getLeashData() != null;
    }

    default public boolean canHaveALeashAttachedTo(Entity p_406168_) {
        if (this == p_406168_) {
            return false;
        }
        return this.leashDistanceTo(p_406168_) > this.leashSnapDistance() ? false : this.canBeLeashed();
    }

    default public double leashDistanceTo(Entity p_407569_) {
        return p_407569_.getBoundingBox().getCenter().distanceTo(((Entity)((Object)this)).getBoundingBox().getCenter());
    }

    default public boolean canBeLeashed() {
        return true;
    }

    default public void setDelayedLeashHolderId(int p_345000_) {
        this.setLeashData(new LeashData(p_345000_));
        Leashable.dropLeash((Entity)((Object)this), false, false);
    }

    default public void readLeashData(ValueInput p_407493_) {
        LeashData leashable$leashdata = p_407493_.read(LEASH_TAG, LeashData.CODEC).orElse(null);
        if (this.getLeashData() != null && leashable$leashdata == null) {
            this.removeLeash();
        }
        this.setLeashData(leashable$leashdata);
    }

    default public void writeLeashData(ValueOutput p_409985_, @Nullable LeashData p_345503_) {
        p_409985_.storeNullable(LEASH_TAG, LeashData.CODEC, p_345503_);
    }

    private static <E extends Entity> void restoreLeashFromSave(E p_343564_, LeashData p_344259_) {
        Level level;
        if (p_344259_.delayedLeashInfo != null && (level = p_343564_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Optional optional1 = p_344259_.delayedLeashInfo.left();
            Optional optional = p_344259_.delayedLeashInfo.right();
            if (optional1.isPresent()) {
                Entity entity = serverlevel.getEntity((UUID)optional1.get());
                if (entity != null) {
                    Leashable.setLeashedTo(p_343564_, entity, true);
                    return;
                }
            } else if (optional.isPresent()) {
                Leashable.setLeashedTo(p_343564_, LeashFenceKnotEntity.getOrCreateKnot(serverlevel, (BlockPos)optional.get()), true);
                return;
            }
            if (p_343564_.tickCount > 100) {
                p_343564_.spawnAtLocation(serverlevel, Items.LEAD);
                ((Leashable)((Object)p_343564_)).setLeashData(null);
            }
        }
    }

    default public void dropLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, true);
    }

    default public void removeLeash() {
        Leashable.dropLeash((Entity)((Object)this), true, false);
    }

    default public void onLeashRemoved() {
    }

    private static <E extends Entity> void dropLeash(E p_343459_, boolean p_342580_, boolean p_344786_) {
        LeashData leashable$leashdata = ((Leashable)((Object)p_343459_)).getLeashData();
        if (leashable$leashdata != null && leashable$leashdata.leashHolder != null) {
            ((Leashable)((Object)p_343459_)).setLeashData(null);
            ((Leashable)((Object)p_343459_)).onLeashRemoved();
            Level level = p_343459_.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (p_344786_) {
                    p_343459_.spawnAtLocation(serverlevel, Items.LEAD);
                }
                if (p_342580_) {
                    serverlevel.getChunkSource().broadcast(p_343459_, new ClientboundSetEntityLinkPacket(p_343459_, null));
                }
                leashable$leashdata.leashHolder.notifyLeasheeRemoved((Leashable)((Object)p_343459_));
            }
        }
    }

    public static <E extends Entity> void tickLeash(ServerLevel p_366578_, E p_343570_) {
        LeashData leashable$leashdata = ((Leashable)((Object)p_343570_)).getLeashData();
        if (leashable$leashdata != null && leashable$leashdata.delayedLeashInfo != null) {
            Leashable.restoreLeashFromSave(p_343570_, leashable$leashdata);
        }
        if (leashable$leashdata != null && leashable$leashdata.leashHolder != null) {
            Entity entity;
            if (!p_343570_.isAlive() || !leashable$leashdata.leashHolder.isAlive()) {
                if (p_366578_.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                    ((Leashable)((Object)p_343570_)).dropLeash();
                } else {
                    ((Leashable)((Object)p_343570_)).removeLeash();
                }
            }
            if ((entity = ((Leashable)((Object)p_343570_)).getLeashHolder()) != null && entity.level() == p_343570_.level()) {
                double d0 = ((Leashable)((Object)p_343570_)).leashDistanceTo(entity);
                ((Leashable)((Object)p_343570_)).whenLeashedTo(entity);
                if (d0 > ((Leashable)((Object)p_343570_)).leashSnapDistance()) {
                    p_366578_.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.LEAD_BREAK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    ((Leashable)((Object)p_343570_)).leashTooFarBehaviour();
                } else if (d0 > ((Leashable)((Object)p_343570_)).leashElasticDistance() - (double)entity.getBbWidth() - (double)p_343570_.getBbWidth() && ((Leashable)((Object)p_343570_)).checkElasticInteractions(entity, leashable$leashdata)) {
                    ((Leashable)((Object)p_343570_)).onElasticLeashPull();
                } else {
                    ((Leashable)((Object)p_343570_)).closeRangeLeashBehaviour(entity);
                }
                p_343570_.setYRot((float)((double)p_343570_.getYRot() - leashable$leashdata.angularMomentum));
                leashable$leashdata.angularMomentum *= (double)Leashable.angularFriction(p_343570_);
            }
        }
    }

    default public void onElasticLeashPull() {
        Entity entity = (Entity)((Object)this);
        entity.checkFallDistanceAccumulation();
    }

    default public double leashSnapDistance() {
        return 12.0;
    }

    default public double leashElasticDistance() {
        return 6.0;
    }

    public static <E extends Entity> float angularFriction(E p_408063_) {
        if (p_408063_.onGround()) {
            BlockPos pos = p_408063_.getBlockPosBelowThatAffectsMyMovement();
            return p_408063_.level().getBlockState(pos).getFriction(p_408063_.level(), pos, p_408063_) * 0.91f;
        }
        return p_408063_.isInLiquid() ? 0.8f : 0.91f;
    }

    default public void whenLeashedTo(Entity p_407530_) {
        p_407530_.notifyLeashHolder(this);
    }

    default public void leashTooFarBehaviour() {
        this.dropLeash();
    }

    default public void closeRangeLeashBehaviour(Entity p_344596_) {
    }

    default public boolean checkElasticInteractions(Entity p_406343_, LeashData p_407235_) {
        boolean flag = p_406343_.supportQuadLeashAsHolder() && this.supportQuadLeash();
        List<Wrench> list = Leashable.computeElasticInteraction((Entity)((Object)this), p_406343_, flag ? SHARED_QUAD_ATTACHMENT_POINTS : ENTITY_ATTACHMENT_POINT, flag ? SHARED_QUAD_ATTACHMENT_POINTS : LEASHER_ATTACHMENT_POINT);
        if (list.isEmpty()) {
            return false;
        }
        Wrench leashable$wrench = Wrench.accumulate(list).scale(flag ? 0.25 : 1.0);
        p_407235_.angularMomentum += 10.0 * leashable$wrench.torque();
        Vec3 vec3 = Leashable.getHolderMovement(p_406343_).subtract(((Entity)((Object)this)).getKnownMovement());
        ((Entity)((Object)this)).addDeltaMovement(leashable$wrench.force().multiply(AXIS_SPECIFIC_ELASTICITY).add(vec3.scale(0.11)));
        return true;
    }

    private static Vec3 getHolderMovement(Entity p_407164_) {
        Mob mob;
        return p_407164_ instanceof Mob && (mob = (Mob)p_407164_).isNoAi() ? Vec3.ZERO : p_407164_.getKnownMovement();
    }

    private static <E extends Entity> List<Wrench> computeElasticInteraction(E p_408183_, Entity p_406565_, List<Vec3> p_410674_, List<Vec3> p_409022_) {
        double d0 = ((Leashable)((Object)p_408183_)).leashElasticDistance();
        Vec3 vec3 = Leashable.getHolderMovement(p_408183_);
        float f = p_408183_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec31 = new Vec3(p_408183_.getBbWidth(), p_408183_.getBbHeight(), p_408183_.getBbWidth());
        float f1 = p_406565_.getYRot() * ((float)Math.PI / 180);
        Vec3 vec32 = new Vec3(p_406565_.getBbWidth(), p_406565_.getBbHeight(), p_406565_.getBbWidth());
        ArrayList<Wrench> list = new ArrayList<Wrench>();
        for (int i = 0; i < p_410674_.size(); ++i) {
            Vec3 vec33 = p_410674_.get(i).multiply(vec31).yRot(-f);
            Vec3 vec34 = p_408183_.position().add(vec33);
            Vec3 vec35 = p_409022_.get(i).multiply(vec32).yRot(-f1);
            Vec3 vec36 = p_406565_.position().add(vec35);
            Leashable.computeDampenedSpringInteraction(vec36, vec34, d0, vec3, vec33).ifPresent(list::add);
        }
        return list;
    }

    private static Optional<Wrench> computeDampenedSpringInteraction(Vec3 p_409865_, Vec3 p_405872_, double p_409391_, Vec3 p_410398_, Vec3 p_409272_) {
        boolean flag;
        double d0 = p_405872_.distanceTo(p_409865_);
        if (d0 < p_409391_) {
            return Optional.empty();
        }
        Vec3 vec3 = p_409865_.subtract(p_405872_).normalize().scale(d0 - p_409391_);
        double d1 = Wrench.torqueFromForce(p_409272_, vec3);
        boolean bl = flag = p_410398_.dot(vec3) >= 0.0;
        if (flag) {
            vec3 = vec3.scale(0.3f);
        }
        return Optional.of(new Wrench(vec3, d1));
    }

    default public boolean supportQuadLeash() {
        return false;
    }

    default public Vec3[] getQuadLeashOffsets() {
        return Leashable.createQuadLeashOffsets((Entity)((Object)this), 0.0, 0.5, 0.5, 0.5);
    }

    public static Vec3[] createQuadLeashOffsets(Entity p_408706_, double p_406447_, double p_406490_, double p_407443_, double p_408814_) {
        float f = p_408706_.getBbWidth();
        double d0 = p_406447_ * (double)f;
        double d1 = p_406490_ * (double)f;
        double d2 = p_407443_ * (double)f;
        double d3 = p_408814_ * (double)p_408706_.getBbHeight();
        return new Vec3[]{new Vec3(-d2, d3, d1 + d0), new Vec3(-d2, d3, -d1 + d0), new Vec3(d2, d3, -d1 + d0), new Vec3(d2, d3, d1 + d0)};
    }

    default public Vec3 getLeashOffset(float p_409188_) {
        return this.getLeashOffset();
    }

    default public Vec3 getLeashOffset() {
        Entity entity = (Entity)((Object)this);
        return new Vec3(0.0, entity.getEyeHeight(), entity.getBbWidth() * 0.4f);
    }

    default public void setLeashedTo(Entity p_342408_, boolean p_342255_) {
        if (this != p_342408_) {
            Leashable.setLeashedTo((Entity)((Object)this), p_342408_, p_342255_);
        }
    }

    private static <E extends Entity> void setLeashedTo(E p_342775_, Entity p_342643_, boolean p_343557_) {
        Level level;
        LeashData leashable$leashdata = ((Leashable)((Object)p_342775_)).getLeashData();
        if (leashable$leashdata == null) {
            leashable$leashdata = new LeashData(p_342643_);
            ((Leashable)((Object)p_342775_)).setLeashData(leashable$leashdata);
        } else {
            Entity entity = leashable$leashdata.leashHolder;
            leashable$leashdata.setLeashHolder(p_342643_);
            if (entity != null && entity != p_342643_) {
                entity.notifyLeasheeRemoved((Leashable)((Object)p_342775_));
            }
        }
        if (p_343557_ && (level = p_342775_.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            serverlevel.getChunkSource().broadcast(p_342775_, new ClientboundSetEntityLinkPacket(p_342775_, p_342643_));
        }
        if (p_342775_.isPassenger()) {
            p_342775_.stopRiding();
        }
    }

    @Nullable
    default public Entity getLeashHolder() {
        return Leashable.getLeashHolder((Entity)((Object)this));
    }

    @Nullable
    private static <E extends Entity> Entity getLeashHolder(E p_342282_) {
        Entity entity;
        LeashData leashable$leashdata = ((Leashable)((Object)p_342282_)).getLeashData();
        if (leashable$leashdata == null) {
            return null;
        }
        if (leashable$leashdata.delayedLeashHolderId != 0 && p_342282_.level().isClientSide && (entity = p_342282_.level().getEntity(leashable$leashdata.delayedLeashHolderId)) instanceof Entity) {
            leashable$leashdata.setLeashHolder(entity);
        }
        return leashable$leashdata.leashHolder;
    }

    public static List<Leashable> leashableLeashedTo(Entity p_409040_) {
        return Leashable.leashableInArea(p_409040_, p_409624_ -> p_409624_.getLeashHolder() == p_409040_);
    }

    public static List<Leashable> leashableInArea(Entity p_410041_, Predicate<Leashable> p_410564_) {
        return Leashable.leashableInArea(p_410041_.level(), p_410041_.getBoundingBox().getCenter(), p_410564_);
    }

    public static List<Leashable> leashableInArea(Level p_409830_, Vec3 p_407309_, Predicate<Leashable> p_409916_) {
        double d0 = 32.0;
        AABB aabb = AABB.ofSize(p_407309_, 32.0, 32.0, 32.0);
        return p_409830_.getEntitiesOfClass(Entity.class, aabb, p_410526_ -> {
            Leashable leashable;
            return p_410526_ instanceof Leashable && p_409916_.test(leashable = (Leashable)((Object)p_410526_));
        }).stream().map(Leashable.class::cast).toList();
    }

    public static final class LeashData {
        public static final Codec<LeashData> CODEC = Codec.xor((Codec)UUIDUtil.CODEC.fieldOf("UUID").codec(), BlockPos.CODEC).xmap(LeashData::new, p_394128_ -> {
            Entity patt0$temp = p_394128_.leashHolder;
            if (patt0$temp instanceof LeashFenceKnotEntity) {
                LeashFenceKnotEntity leashfenceknotentity = (LeashFenceKnotEntity)patt0$temp;
                return Either.right((Object)leashfenceknotentity.getPos());
            }
            return p_394128_.leashHolder != null ? Either.left((Object)p_394128_.leashHolder.getUUID()) : Objects.requireNonNull(p_394128_.delayedLeashInfo, "Invalid LeashData had no attachment");
        });
        int delayedLeashHolderId;
        @Nullable
        public Entity leashHolder;
        @Nullable
        public Either<UUID, BlockPos> delayedLeashInfo;
        public double angularMomentum;

        private LeashData(Either<UUID, BlockPos> p_345305_) {
            this.delayedLeashInfo = p_345305_;
        }

        LeashData(Entity p_345447_) {
            this.leashHolder = p_345447_;
        }

        LeashData(int p_345400_) {
            this.delayedLeashHolderId = p_345400_;
        }

        public void setLeashHolder(Entity p_342311_) {
            this.leashHolder = p_342311_;
            this.delayedLeashInfo = null;
            this.delayedLeashHolderId = 0;
        }
    }

    public record Wrench(Vec3 force, double torque) {
        static Wrench ZERO = new Wrench(Vec3.ZERO, 0.0);

        static double torqueFromForce(Vec3 p_410224_, Vec3 p_409711_) {
            return p_410224_.z * p_409711_.x - p_410224_.x * p_409711_.z;
        }

        static Wrench accumulate(List<Wrench> p_405866_) {
            if (p_405866_.isEmpty()) {
                return ZERO;
            }
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (Wrench leashable$wrench : p_405866_) {
                Vec3 vec3 = leashable$wrench.force;
                d0 += vec3.x;
                d1 += vec3.y;
                d2 += vec3.z;
                d3 += leashable$wrench.torque;
            }
            return new Wrench(new Vec3(d0, d1, d2), d3);
        }

        public Wrench scale(double p_409872_) {
            return new Wrench(this.force.scale(p_409872_), this.torque * p_409872_);
        }
    }
}

