/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(Entity $$0, BlockState $$12, Level $$22, BlockPos $$3) {
        if ($$12.getValue(BERRIES).booleanValue()) {
            if ($$22 instanceof ServerLevel) {
                ServerLevel $$4 = (ServerLevel)$$22;
                Block.dropFromBlockInteractLootTable($$4, BuiltInLootTables.HARVEST_CAVE_VINE, $$12, $$22.getBlockEntity($$3), null, $$0, ($$1, $$2) -> Block.popResource((Level)$$1, $$3, $$2));
                float $$5 = Mth.randomBetween($$4.random, 0.8f, 1.2f);
                $$4.playSound(null, $$3, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, $$5);
                BlockState $$6 = (BlockState)$$12.setValue(BERRIES, false);
                $$4.setBlock($$3, $$6, 2);
                $$4.gameEvent(GameEvent.BLOCK_CHANGE, $$3, GameEvent.Context.of($$0, $$6));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState $$0) {
        return $$0.hasProperty(BERRIES) && $$0.getValue(BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int $$0) {
        return $$1 -> $$1.getValue(BlockStateProperties.BERRIES) != false ? $$0 : 0;
    }
}

