/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.FileNameDateFormatter;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.TagValueOutput;
import org.slf4j.Logger;

public class PlayerDataStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final File playerDir;
    protected final DataFixer fixerUpper;
    private static final DateTimeFormatter FORMATTER = FileNameDateFormatter.create();

    public PlayerDataStorage(LevelStorageSource.LevelStorageAccess $$0, DataFixer $$1) {
        this.fixerUpper = $$1;
        this.playerDir = $$0.getLevelPath(LevelResource.PLAYER_DATA_DIR).toFile();
        this.playerDir.mkdirs();
    }

    public void save(Player $$0) {
        try (ProblemReporter.ScopedCollector $$1 = new ProblemReporter.ScopedCollector($$0.problemPath(), LOGGER);){
            TagValueOutput $$2 = TagValueOutput.createWithContext($$1, $$0.registryAccess());
            $$0.saveWithoutId($$2);
            Path $$3 = this.playerDir.toPath();
            Path $$4 = Files.createTempFile($$3, $$0.getStringUUID() + "-", ".dat", new FileAttribute[0]);
            CompoundTag $$5 = $$2.buildResult();
            NbtIo.writeCompressed($$5, $$4);
            Path $$6 = $$3.resolve($$0.getStringUUID() + ".dat");
            Path $$7 = $$3.resolve($$0.getStringUUID() + ".dat_old");
            Util.safeReplaceFile($$6, $$4, $$7);
        }
        catch (Exception $$8) {
            LOGGER.warn("Failed to save player data for {}", (Object)$$0.getPlainTextName());
        }
    }

    private void backup(NameAndId $$0, String $$1) {
        Path $$2 = this.playerDir.toPath();
        String $$3 = $$0.id().toString();
        Path $$4 = $$2.resolve($$3 + $$1);
        Path $$5 = $$2.resolve($$3 + "_corrupted_" + LocalDateTime.now().format(FORMATTER) + $$1);
        if (!Files.isRegularFile($$4, new LinkOption[0])) {
            return;
        }
        try {
            Files.copy($$4, $$5, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (Exception $$6) {
            LOGGER.warn("Failed to copy the player.dat file for {}", (Object)$$0.name(), (Object)$$6);
        }
    }

    private Optional<CompoundTag> load(NameAndId $$0, String $$1) {
        File $$2 = new File(this.playerDir, $$0.id().toString() + $$1);
        if ($$2.exists() && $$2.isFile()) {
            try {
                return Optional.of(NbtIo.readCompressed($$2.toPath(), NbtAccounter.unlimitedHeap()));
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to load player data for {}", (Object)$$0.name());
            }
        }
        return Optional.empty();
    }

    public Optional<CompoundTag> load(NameAndId $$02) {
        Optional<CompoundTag> $$1 = this.load($$02, ".dat");
        if ($$1.isEmpty()) {
            this.backup($$02, ".dat");
        }
        return $$1.or(() -> this.load($$02, ".dat_old")).map($$0 -> {
            int $$1 = NbtUtils.getDataVersion($$0, -1);
            $$0 = DataFixTypes.PLAYER.updateToCurrentVersion(this.fixerUpper, (CompoundTag)$$0, $$1);
            return $$0;
        });
    }
}

