/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack.sctp;

import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpServerChannel;
import gov.nist.core.HostPort;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.sctp.SCTPMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public final class SCTPMessageProcessor
extends MessageProcessor
implements Runnable {
    private SctpServerChannel sctpServerChannel;
    private Selector selector;
    private SelectionKey key;
    private boolean isRunning;
    private boolean doClose;
    private final Set<SCTPMessageChannel> channels = new ConcurrentSkipListSet<SCTPMessageChannel>();

    public SCTPMessageProcessor() {
        super("sctp");
    }

    Selector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectionKey registerChannel(SCTPMessageChannel c, SctpChannel channel) throws ClosedChannelException {
        SCTPMessageProcessor sCTPMessageProcessor = this;
        synchronized (sCTPMessageProcessor) {
            this.selector.wakeup();
            return channel.register(this.selector, 1, c);
        }
    }

    @Override
    public MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        return this.createMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort());
    }

    @Override
    public MessageChannel createMessageChannel(InetAddress targetHost, int port) throws IOException {
        SCTPMessageChannel c = new SCTPMessageChannel(this, new InetSocketAddress(targetHost, port));
        this.channels.add(c);
        return c;
    }

    @Override
    public int getDefaultTargetPort() {
        return 5060;
    }

    @Override
    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    @Override
    public boolean inUse() {
        return this.isRunning;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                Object i;
                int n;
                if ((n = this.selector.select()) > 0) {
                    i = this.selector.selectedKeys().iterator();
                    while (i.hasNext()) {
                        SelectionKey key = (SelectionKey)i.next();
                        i.remove();
                        if (key.isReadable()) {
                            SCTPMessageChannel channel = (SCTPMessageChannel)key.attachment();
                            channel.readMessages();
                            continue;
                        }
                        if (!key.isAcceptable()) continue;
                        SctpChannel ch = this.sctpServerChannel.accept();
                        SCTPMessageChannel c = new SCTPMessageChannel(this, ch);
                        this.channels.add(c);
                    }
                }
                i = this;
                synchronized (i) {
                    if (this.doClose) {
                        this.selector.close();
                        return;
                    }
                }
            } while (this.selector.isOpen());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            try {
                this.selector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.stop();
            }
        }
    }

    @Override
    public void start() throws IOException {
        this.sctpServerChannel = SctpServerChannel.open();
        this.sctpServerChannel.bind(new InetSocketAddress(this.getIpAddress(), this.getPort()));
        this.sctpServerChannel.configureBlocking(false);
        this.selector = Selector.open();
        this.key = this.sctpServerChannel.register(this.selector, 16);
        this.isRunning = true;
        Thread thread = new Thread(this);
        thread.setDaemon(true);
        thread.setName("SCTPMessageProcessorThread");
        thread.setPriority(10);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.isRunning = false;
        this.doClose = true;
        for (SCTPMessageChannel c : this.channels) {
            c.closeNoRemove();
        }
        this.channels.clear();
        try {
            this.key.cancel();
            this.sctpServerChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            SCTPMessageProcessor sCTPMessageProcessor = this;
            synchronized (sCTPMessageProcessor) {
                this.selector.wakeup();
            }
        }
    }

    void removeChannel(SCTPMessageChannel messageChannel) {
        this.channels.remove(messageChannel);
    }
}

