/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtcp;

import java.time.Instant;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.TransportCcEngine;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbRembPacket;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jitsi/nlj/rtcp/RembHandler;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;)V", "getStreamInformationStore", "()Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "logger", "sawSpuriousRemb", "", "bweUpdateListeners", "", "Lorg/jitsi/nlj/rtp/TransportCcEngine$BandwidthListener;", "rtcpPacketReceived", "", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "Ljava/time/Instant;", "addListener", "bweUpdateListener", "onRembPacket", "rembPacket", "Lorg/jitsi/rtp/rtcp/rtcpfb/payload_specific_fb/RtcpFbRembPacket;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nRembHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RembHandler.kt\norg/jitsi/nlj/rtcp/RembHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1869#2,2:74\n*S KotlinDebug\n*F\n+ 1 RembHandler.kt\norg/jitsi/nlj/rtcp/RembHandler\n*L\n64#1:74,2\n*E\n"})
public final class RembHandler
implements RtcpListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformationStore;
    @NotNull
    private final Logger logger;
    private boolean sawSpuriousRemb;
    @NotNull
    private final List<TransportCcEngine.BandwidthListener> bweUpdateListeners;
    @NotNull
    private static final AtomicInteger endpointsWithSpuriousRemb = new AtomicInteger();

    public RembHandler(@NotNull ReadOnlyStreamInformationStore streamInformationStore, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)streamInformationStore, (String)"streamInformationStore");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.streamInformationStore = streamInformationStore;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.bweUpdateListeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final ReadOnlyStreamInformationStore getStreamInformationStore() {
        return this.streamInformationStore;
    }

    @Override
    public void rtcpPacketReceived(@Nullable RtcpPacket packet, @Nullable Instant receivedTime) {
        if (packet instanceof RtcpFbRembPacket) {
            this.logger.debug(RembHandler::rtcpPacketReceived$lambda$0);
            this.onRembPacket((RtcpFbRembPacket)packet);
        }
    }

    public final void addListener(@NotNull TransportCcEngine.BandwidthListener bweUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)bweUpdateListener, (String)"bweUpdateListener");
        this.bweUpdateListeners.add(bweUpdateListener);
    }

    private final void onRembPacket(RtcpFbRembPacket rembPacket) {
        if (this.streamInformationStore.getSupportsTcc()) {
            if (!this.sawSpuriousRemb) {
                this.logger.warn(() -> RembHandler.onRembPacket$lambda$0(rembPacket));
                endpointsWithSpuriousRemb.incrementAndGet();
                this.sawSpuriousRemb = true;
            }
            return;
        }
        this.logger.debug(() -> RembHandler.onRembPacket$lambda$1(rembPacket));
        Iterable $this$forEach$iv = this.bweUpdateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransportCcEngine.BandwidthListener it = (TransportCcEngine.BandwidthListener)element$iv;
            boolean bl = false;
            it.bandwidthEstimationChanged-_2icLw0(BandwidthKt.getBps(rembPacket.getBitrate()));
        }
    }

    private static final String rtcpPacketReceived$lambda$0() {
        return "Received REMB packet";
    }

    private static final String onRembPacket$lambda$0(RtcpFbRembPacket $rembPacket) {
        return "Ignoring unexpected REMB, when using TCC (for " + Bandwidth.toString-impl(BandwidthKt.getBps($rembPacket.getBitrate())) + "). Will suppress future logs for this endpoint.";
    }

    private static final String onRembPacket$lambda$1(RtcpFbRembPacket $rembPacket) {
        return "Updating bandwidth to " + Bandwidth.toString-impl(BandwidthKt.getBps($rembPacket.getBitrate()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0006R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtcp/RembHandler$Companion;", "", "<init>", "()V", "endpointsWithSpuriousRemb", "Ljava/util/concurrent/atomic/AtomicInteger;", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public final int endpointsWithSpuriousRemb() {
            return endpointsWithSpuriousRemb.get();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

