/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;

public final class Files {

    public static class PrepareDownload
    extends AbstractCall<PrepareDownloadResult> {
        public static final String API_TYPE = "Files.PrepareDownload";

        public PrepareDownload(String string) {
            this.addParameter("path", string);
        }

        @Override
        protected PrepareDownloadResult parseOne(JsonNode jsonNode) {
            return new PrepareDownloadResult(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }

        public static class PrepareDownloadResult
        extends AbstractModel {
            public static final String DETAILS = "details";
            public static final String MODE = "mode";
            public static final String PROTOCOL = "protocol";
            public final String details;
            public final String mode;
            public final String protocol;

            public PrepareDownloadResult(String string, String string2, String string3) {
                this.details = string;
                this.mode = string2;
                this.protocol = string3;
            }

            public PrepareDownloadResult(JsonNode jsonNode) {
                this.details = jsonNode.get(DETAILS).asText();
                this.mode = PrepareDownloadResult.parseString(jsonNode, MODE);
                this.protocol = PrepareDownloadResult.parseString(jsonNode, PROTOCOL);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(DETAILS, this.details);
                objectNode.put(MODE, this.mode);
                objectNode.put(PROTOCOL, this.protocol);
                return objectNode;
            }

            static List<PrepareDownloadResult> getFilesPrepareDownloadResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<PrepareDownloadResult> arrayList = new ArrayList<PrepareDownloadResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new PrepareDownloadResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<PrepareDownloadResult>(0);
            }

            public static interface Mode {
                public static final String REDIRECT = "redirect";
                public static final String DIRECT = "direct";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("redirect", "direct"));
            }

            public static interface Protocol {
                public static final String HTTP = "http";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("http"));
            }
        }
    }

    public static class GetSources
    extends AbstractCall<ListModel.SourceItem> {
        public static final String API_TYPE = "Files.GetSources";
        public static final String RESULT = "sources";

        public GetSources(String string, ListModel.Limits limits, ListModel.Sort sort) {
            this.addParameter("media", string);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
        }

        public GetSources(String string) {
            this.addParameter("media", string);
        }

        public GetSources(String string, ListModel.Limits limits) {
            this.addParameter("media", string);
            this.addParameter("limits", (AbstractModel)limits);
        }

        @Override
        protected ArrayList<ListModel.SourceItem> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<ListModel.SourceItem> arrayList = new ArrayList<ListModel.SourceItem>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new ListModel.SourceItem((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<ListModel.SourceItem>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class GetFileDetails
    extends AbstractCall<ListModel.FileItem> {
        public static final String API_TYPE = "Files.GetFileDetails";
        public static final String RESULT = "filedetails";

        public GetFileDetails(String string, String string2, String ... stringArray) {
            this.addParameter("file", string);
            this.addParameter("media", string2);
            this.addParameter("properties", stringArray);
        }

        public GetFileDetails(String string, String ... stringArray) {
            this.addParameter("file", string);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ListModel.FileItem parseOne(JsonNode jsonNode) {
            return new ListModel.FileItem((JsonNode)((ObjectNode)jsonNode.get(RESULT)));
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetDirectory
    extends AbstractCall<ListModel.FileItem> {
        public static final String API_TYPE = "Files.GetDirectory";
        public static final String RESULT = "files";

        public GetDirectory(String string, String string2, ListModel.Sort sort, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("media", string2);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, String string2, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("media", string2);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, ListModel.Sort sort, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, String string2, ListModel.Sort sort, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("media", string2);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        public GetDirectory(String string, ListModel.Sort sort, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("directory", string);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<ListModel.FileItem> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<ListModel.FileItem> arrayList = new ArrayList<ListModel.FileItem>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new ListModel.FileItem((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<ListModel.FileItem>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }
}

