/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.updater;

import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.EnvConfig;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.util.ProgressObserver;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.updater.getdown.TmmGetdownApplication;
import org.tinymediamanager.updater.getdown.TmmGetdownDownloader;

public class UpdaterTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdaterTask.class);
    boolean downloadSuccessful;

    public UpdaterTask() {
        super(TmmResourceBundle.getString("task.updater.prepare"), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
    }

    @Override
    public void doInBackground() {
        this.downloadSuccessful = false;
        try {
            ArrayList notes = new ArrayList();
            String[] args = new String[]{"."};
            EnvConfig envc = EnvConfig.create((String[])args, notes);
            TmmGetdownApplication app = new TmmGetdownApplication(envc);
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            try {
                app.init(true);
            }
            catch (IOException ioe) {
                app.attemptRecovery(e -> {});
                app.init(true);
            }
            ProgressObserver progobs = x$0 -> this.publishState(x$0);
            Path updateFolder = Paths.get("update/", new String[0]);
            Utils.deleteDirectoryRecursive(updateFolder);
            updateFolder.toFile().mkdirs();
            int[] alreadyValid = new int[1];
            HashSet unpacked = new HashSet();
            HashSet<Resource> toDownload = new HashSet<Resource>();
            HashSet<Resource> toInstallResources = new HashSet<Resource>();
            app.verifyMetadata(e -> {});
            app.verifyResources(progobs, alreadyValid, unpacked, toInstallResources, toDownload);
            if (!toDownload.isEmpty()) {
                this.setTaskName(TmmResourceBundle.getString("task.update"));
                toInstallResources.addAll(toDownload);
                LOGGER.info("{} of {} files require update.", (Object)toDownload.size(), (Object)app.getAllActiveResources().size());
                this.downloadSuccessful = this.download(toDownload, app);
                if (this.downloadSuccessful) {
                    for (Resource resource : toInstallResources) {
                        LOGGER.trace("Installing resource {}", (Object)resource);
                        resource.install(true);
                    }
                    if (!GraphicsEnvironment.isHeadless()) {
                        SwingUtilities.invokeLater(() -> {
                            int decision = JOptionPane.showConfirmDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.updater.restart.desc"), TmmResourceBundle.getString("tmm.updater.restart"), 0);
                            if (decision == 0) {
                                MainWindow.getInstance().closeTmmAndStart(TmmOsUtils.getPBforTMMrestart());
                            }
                        });
                    }
                } else {
                    LOGGER.error("Downloading update failed!");
                }
            }
        }
        catch (Exception e2) {
            LOGGER.error("Could not download update - '{}'", (Object)e2.getMessage());
            this.downloadSuccessful = false;
        }
        if (!this.downloadSuccessful) {
            Utils.deleteFileSafely(Paths.get("digest.txt", new String[0]));
            Utils.deleteFileSafely(Paths.get("digest2.txt", new String[0]));
        }
    }

    public boolean isDownloadSuccessful() {
        return this.downloadSuccessful;
    }

    private boolean download(Collection<Resource> resources, Application app) throws IOException {
        TmmGetdownDownloader dl = new TmmGetdownDownloader(){

            @Override
            protected void downloadProgress(int percent, long remaining) {
                super.downloadProgress(percent, remaining);
                UpdaterTask.this.publishState(percent);
            }
        };
        if (dl.download(resources, app.maxConcurrentDownloads())) {
            Files.createFile(Paths.get("update/", ".ready"), new FileAttribute[0]);
            return true;
        }
        return false;
    }
}

