/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import io.jenetics.stat.IntMoments;
import io.jenetics.stat.MomentStatistics;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

public class IntMomentStatistics
extends MomentStatistics
implements IntConsumer {
    private int _min = Integer.MAX_VALUE;
    private int _max = Integer.MIN_VALUE;
    private long _sum = 0L;

    @Override
    public void accept(int value) {
        super.accept(value);
        this._min = Math.min(this._min, value);
        this._max = Math.max(this._max, value);
        this._sum += (long)value;
    }

    public IntMomentStatistics combine(IntMomentStatistics other) {
        super.combine(other);
        this._min = Math.min(this._min, other._min);
        this._max = Math.max(this._max, other._max);
        this._sum += other._sum;
        return this;
    }

    public int getMin() {
        return this._min;
    }

    public int getMax() {
        return this._max;
    }

    public long getSum() {
        return this._sum;
    }

    public boolean sameState(IntMomentStatistics other) {
        return this == other || this._min == other._min && this._max == other._max && this._sum == other._sum && super.sameState(other);
    }

    public IntMoments toIntMoments() {
        return IntMoments.of(this);
    }

    public String toString() {
        return String.format("IntMomentStatistics[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s, s\u00b2=%s, S=%s, K=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean(), this.getVariance(), this.getSkewness(), this.getKurtosis());
    }

    public static <T> Collector<T, ?, IntMomentStatistics> toIntMomentStatistics(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(IntMomentStatistics::new, (r, t) -> r.accept(mapper.applyAsInt(t)), IntMomentStatistics::combine, new Collector.Characteristics[0]);
    }
}

