/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.trafficflow;

import com.ubnt.data.Site;
import com.ubnt.model.api.stats.StatsPeriod;
import com.ubnt.model.api.trafficflow.TrafficFlowDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataDto;
import com.ubnt.model.api.trafficflow.TrafficFlowFilterDataParametersDto;
import com.ubnt.model.api.trafficflow.TrafficFlowListDto;
import com.ubnt.model.api.trafficflow.TrafficFlowParametersDto;
import com.ubnt.model.api.trafficstats.AppTrafficDto;
import com.ubnt.net.E;
import com.ubnt.net.Q;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowReadPrivileges;
import com.ubnt.service.stat.dpi.OoOO;
import com.ubnt.service.trafficflow.intObject;
import com.ubnt.service.trafficflow.ooO0;
import com.ubnt.service.trafficflow.search.oOOO.O0OO;
import com.ubnt.service.trafficflow.stats.A;
import com.ubnt.service.trafficflow.stats.F;
import com.ubnt.service.trafficflow.stats.String;
import com.ubnt.service.trafficflow.stats.dto.TrafficFlowStatisticsDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.beans.ConstructorProperties;
import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import reactor.core.publisher.Flux;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Traffic Flow")
public class TrafficFlowController {
    static final int \u00d400000 = 30;
    static final int \u00d300000 = 100;
    private final intObject \u00f400000;
    private final ooO0 \u00d800000;
    private final F return;
    private final OoOO o00000;
    private final Clock new;
    private final A \u00d500000;

    @AllowReadPrivileges
    @PostMapping(value={"/api/site/{siteName}/traffic-flows"})
    @Operation(summary="List Traffic Flows", description="Since 9.1.64")
    public TrafficFlowListDto listTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        Page<TrafficFlowDto> page = this.\u00f400000.while(site.getId(), this.\u00d800000.\u00d300000(trafficFlowParametersDto));
        return TrafficFlowListDto.of(page);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/{id}"})
    @Operation(summary="Get Traffic Flow by ID", description="Since 9.2.60")
    public TrafficFlowDto getTrafficFlowById(@PathVariable(value="siteName") Site site, @PathVariable(value="id") java.lang.String string) {
        return this.\u00f400000.\u00d500000(string, site.getId()).orElseThrow(O0OO::new);
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/alarm/{alarmId}"})
    @Operation(summary="Get Traffic Flow by IPS alarm ID", description="Since 9.1.98")
    public TrafficFlowDto getTrafficFlowByAlarmId(@PathVariable(value="siteName") Site site, @PathVariable(value="alarmId") java.lang.String string) {
        return this.\u00f400000.\u00d5O0000(site.getId(), string).orElseThrow(O0OO::new);
    }

    @PostMapping(value={"/api/site/{siteName}/traffic-flows/export"}, consumes={"application/json"}, produces={"text/csv"})
    @AllowReadPrivileges
    @Operation(summary="Export Traffic Flows in CSV format", description="Since 9.1.93")
    public ResponseBodyEmitter exportTrafficFlows(@PathVariable(value="siteName") Site site, @RequestBody @Valid TrafficFlowParametersDto trafficFlowParametersDto) {
        E e2 = new E();
        Flux<java.lang.String> flux = this.\u00f400000.OO0000(site.getId(), this.\u00d800000.\u00d300000(trafficFlowParametersDto));
        e2.onTimeout(() -> flux.subscribe().dispose());
        e2.onCompletion(() -> flux.subscribe().dispose());
        flux.subscribe(string -> {
            try {
                e2.send(string, Q.o00000);
            }
            catch (Exception exception) {
                e2.completeWithError(exception);
            }
        }, arg_0 -> ((ResponseBodyEmitter)e2).completeWithError(arg_0), () -> ((ResponseBodyEmitter)e2).complete());
        return e2;
    }

    @AllowReadPrivileges
    @Operation(summary="Get traffic flow stats for the last 1H/1D/1W/1M", description="Since 9.1.82")
    @GetMapping(value={"/api/site/{siteName}/traffic-flow-latest-statistics"})
    public TrafficFlowStatisticsDto getTrafficFlowStats(@PathVariable(value="siteName") Site site, @RequestParam(value="period") StatsPeriod statsPeriod, @RequestParam(value="top", required=false) Integer n3) {
        Instant instant = this.new.instant();
        long l2 = statsPeriod.subtractFrom(instant).toEpochMilli();
        long l3 = instant.toEpochMilli();
        String string = this.return.\u00f5Oo000(site.getId(), l2, l3).get(0);
        List<AppTrafficDto> list = this.o00000.\u00d5oo000(site.getId(), l2, l3);
        return this.\u00d500000.\u00d500000(site, string, list, Optional.ofNullable(n3).map(n2 -> Math.max(Math.min(n2, 100), 1)).orElse(30));
    }

    @GetMapping(value={"/api/site/{siteName}/traffic-flows/filter-data"})
    @Operation(summary="Get Traffic Flows filter data", description="Since 9.1.100")
    public TrafficFlowFilterDataDto getTrafficFlowFilterData(@PathVariable(value="siteName") Site site, @Valid TrafficFlowFilterDataParametersDto trafficFlowFilterDataParametersDto) {
        return this.\u00f400000.\u00d300000(site.getId(), this.\u00d800000.\u00d200000(trafficFlowFilterDataParametersDto));
    }

    @ConstructorProperties(value={"trafficFlowService", "trafficFlowParametersDtoMapper", "summarizedTrafficFlowStatisticsProvider", "summarizedGatewayDpiStatisticsProvider", "clock", "trafficFlowStatisticsDtoMapper"})
    @Generated
    public TrafficFlowController(intObject intObject2, ooO0 ooO02, F f2, OoOO ooOO2, Clock clock, A a2) {
        this.\u00f400000 = intObject2;
        this.\u00d800000 = ooO02;
        this.return = f2;
        this.o00000 = ooOO2;
        this.new = clock;
        this.\u00d500000 = a2;
    }
}

