/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import io.jenetics.internal.util.Hash;
import io.jenetics.util.Seq;
import java.util.Arrays;

final class DefaultHashCodeBuilder
implements Hash {
    private static final int P1 = 47;
    private static final int P2 = 103;
    private static final int P3 = 1231;
    private static final int P4 = 1237;
    protected int _hash = 0;

    DefaultHashCodeBuilder(Class<?> type) {
        this._hash = type.hashCode();
    }

    @Override
    public DefaultHashCodeBuilder and(boolean value) {
        this._hash += value ? 1231 : 1237;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(boolean[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(byte value) {
        this._hash += 47 * value + 103;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(byte[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(char value) {
        this._hash += 47 * value + 103;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(char[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(short value) {
        this._hash += 47 * value + 103;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(short[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(int value) {
        this._hash += 47 * value + 103;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(int[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(long value) {
        this._hash += 47 * Long.hashCode(value);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(long[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(float value) {
        this._hash += 47 * Float.hashCode(value);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(float[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(double value) {
        this._hash += 47 * Double.hashCode(value);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(double[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(Object value) {
        this._hash += 47 * (value == null ? 0 : value.hashCode()) + 103;
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(Object[] values) {
        this._hash += Arrays.hashCode(values);
        return this;
    }

    @Override
    public DefaultHashCodeBuilder and(Seq<?> values) {
        this._hash += Seq.hashCode(values);
        return this;
    }

    @Override
    public int value() {
        return this._hash;
    }
}

