/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.smartsubnet;

import com.ubnt.data.Site;
import com.ubnt.model.api.smartsubnet.PreviousSubnetDto;
import com.ubnt.model.api.smartsubnet.SmartSubnetRequestDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.service.smartsubnet.O0OO;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Validated
@V2RestController
public class SmartSubnetController {
    private final O0OO super;

    public SmartSubnetController(O0OO o0OO2) {
        this.super = o0OO2;
    }

    @GetMapping(value={"/api/site/{siteName}/smart-subnet"})
    @AllowUCoreLocal
    @Operation(summary="Return learned subnet from user's existing network during initial setup", description="Since 7.2.52")
    public PreviousSubnetDto findPreviousSubnet(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d300000().map(PreviousSubnetDto::of).orElseThrow(PreviousSubnetWasNotDetectedException::new);
    }

    @PostMapping(value={"/api/site/{siteName}/smart-subnet"})
    @AllowUCoreLocal
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Set subnet on default LAN network as smart detected", description="Since 7.2.52")
    public void setPreviousSubnet(@PathVariable(value="siteName") Site site, @Valid @RequestBody SmartSubnetRequestDto smartSubnetRequestDto) {
        this.super.\u00d200000(site.getId(), smartSubnetRequestDto.cidr());
    }

    static class PreviousSubnetWasNotDetectedException
    extends ResourceNotFoundException {
        public PreviousSubnetWasNotDetectedException() {
            super("Previous subnet was not detected", "api.err.PreviousSubnetWasNotDetected");
        }
    }
}

