/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesJvmKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0019\u0010\u0007\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\n\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a%\u0010\u000e\u001a\u00020\t*\u00020\u00022\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ljava/nio/ByteBuffer;", "byteBuffer", "Lkotlinx/io/Source;", "ByteReadPacket", "(Ljava/nio/ByteBuffer;)Lkotlinx/io/Source;", "buffer", "", "readAvailable", "(Lkotlinx/io/Source;Ljava/nio/ByteBuffer;)I", "", "readFully", "(Lkotlinx/io/Source;Ljava/nio/ByteBuffer;)V", "Lkotlin/Function1;", "block", "read", "(Lkotlinx/io/Source;Lkotlin/jvm/functions/Function1;)V", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nByteReadPacketExtensions.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ByteReadPacketExtensions.jvm.kt\nio/ktor/utils/io/core/ByteReadPacketExtensions_jvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n99#2:37\n100#2,8:39\n1#3:38\n*S KotlinDebug\n*F\n+ 1 ByteReadPacketExtensions.jvm.kt\nio/ktor/utils/io/core/ByteReadPacketExtensions_jvmKt\n*L\n28#1:37\n28#1:39,8\n28#1:38\n*E\n"})
public final class ByteReadPacketExtensions_jvmKt {
    @NotNull
    public static final Source ByteReadPacket(@NotNull ByteBuffer byteBuffer) {
        Buffer buffer;
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Buffer it = buffer = new Buffer();
        boolean bl = false;
        SinksJvmKt.write((Sink)((Sink)it), (ByteBuffer)byteBuffer);
        return (Source)buffer;
    }

    public static final int readAvailable(@NotNull Source $this$readAvailable, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        int result = buffer.remaining();
        SourcesJvmKt.readAtMostTo((Source)$this$readAvailable, (ByteBuffer)buffer);
        return result - buffer.remaining();
    }

    public static final void readFully(@NotNull Source $this$readFully, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readFully, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        while (!$this$readFully.exhausted() && buffer.hasRemaining()) {
            SourcesJvmKt.readAtMostTo((Source)$this$readFully, (ByteBuffer)buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void read(@NotNull Source $this$read, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int consumed;
        void endExclusive;
        void start;
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = $this$read.getBuffer();
        boolean $i$f$readFromHead = false;
        if (!(!buffer$iv.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = buffer$iv.getHead();
        Intrinsics.checkNotNull((Object)segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] array = head$iv.dataAsByteArray(true);
        boolean bl = false;
        ByteBuffer wrap = ByteBuffer.wrap(array, (int)start, (int)(endExclusive - start));
        Intrinsics.checkNotNull((Object)wrap);
        block.invoke((Object)wrap);
        int bytesRead$iv = consumed = wrap.position() - start;
        if (bytesRead$iv != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer$iv.skip((long)bytesRead$iv);
        }
    }
}

