/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.UnsignedKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthUsage;
import org.jitsi.nlj.rtp.bandwidthestimation2.BweDefinesKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.LinkCapacityTracker;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedBweV2;
import org.jitsi.nlj.rtp.bandwidthestimation2.LossBasedState;
import org.jitsi.nlj.rtp.bandwidthestimation2.RttBasedBackoff;
import org.jitsi.nlj.rtp.bandwidthestimation2.SendSideBandwidthEstimationKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.SentPacket;
import org.jitsi.nlj.rtp.bandwidthestimation2.TransportPacketsFeedback;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 \u0085\u00012\u00020\u0001:\u0004\u0084\u0001\u0085\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010C\u001a\u00020DJ\r\u0010E\u001a\u00020\u0014\u00a2\u0006\u0004\bF\u0010GJ\u0006\u0010A\u001a\u00020BJ\u0006\u0010H\u001a\u00020 J\r\u0010I\u001a\u00020&\u00a2\u0006\u0004\bJ\u0010KJ\u0006\u0010L\u001a\u00020*J\r\u0010M\u001a\u00020\u0014\u00a2\u0006\u0004\bN\u0010GJ\u000e\u0010O\u001a\u00020D2\u0006\u0010P\u001a\u00020\u0013J\u000e\u0010Q\u001a\u00020D2\u0006\u0010R\u001a\u00020SJ\u0016\u0010T\u001a\u00020D2\u0006\u0010P\u001a\u00020\u00132\u0006\u0010U\u001a\u00020*J\u001d\u0010V\u001a\u00020D2\u0006\u0010P\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u0014\u00a2\u0006\u0004\bX\u0010YJ\u001d\u0010Z\u001a\u00020D2\u0006\u0010P\u001a\u00020\u00132\u0006\u0010[\u001a\u00020\u0014\u00a2\u0006\u0004\b\\\u0010YJ\u001e\u0010]\u001a\u00020D2\u0006\u0010^\u001a\u00020\u00162\u0006\u0010_\u001a\u00020\u00162\u0006\u0010P\u001a\u00020\u0013J\u0016\u0010`\u001a\u00020D2\u0006\u0010a\u001a\u00020*2\u0006\u0010P\u001a\u00020\u0013J/\u0010b\u001a\u00020D2\b\u0010c\u001a\u0004\u0018\u00010\u00142\u0006\u0010d\u001a\u00020\u00142\u0006\u0010e\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0013\u00a2\u0006\u0004\bf\u0010gJ\u001d\u0010h\u001a\u00020D2\u0006\u0010[\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0013\u00a2\u0006\u0004\bi\u0010jJ\u001d\u0010k\u001a\u00020D2\u0006\u0010d\u001a\u00020\u00142\u0006\u0010e\u001a\u00020\u0014\u00a2\u0006\u0004\bl\u0010mJ\u0006\u0010n\u001a\u000200J\u001d\u0010o\u001a\u00020D2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00142\u0006\u0010P\u001a\u00020\u0013\u00a2\u0006\u0002\bpJ-\u0010q\u001a\u00020D2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020u2\b\u0010v\u001a\u0004\u0018\u00010\u00142\u0006\u0010w\u001a\u00020 \u00a2\u0006\u0002\bxJ\u0010\u0010y\u001a\u00020 2\u0006\u0010P\u001a\u00020\u0013H\u0002J\u0018\u0010z\u001a\u00020D2\u0006\u0010P\u001a\u00020\u00132\u0006\u0010^\u001a\u000200H\u0002J\u0010\u0010{\u001a\u00020D2\u0006\u0010P\u001a\u00020\u0013H\u0002J\u000f\u0010|\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b}\u0010GJ\u001f\u0010~\u001a\u00020D2\u0006\u0010[\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u007f\u0010jJ\u0011\u0010\u0080\u0001\u001a\u00020D2\u0006\u0010P\u001a\u00020\u0013H\u0002J!\u0010\u0081\u0001\u001a\u00020D2\u0006\u0010[\u001a\u00020\u00142\u0006\u0010P\u001a\u00020\u0013H\u0002\u00a2\u0006\u0005\b\u0082\u0001\u0010jJ\u0011\u0010\u0083\u0001\u001a\u00020D2\u0006\u0010P\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001b\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001c\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010\u001d\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010!\u001a\u00020\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u0010\u0010(\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0010\u0010,\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u0010-\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020 06X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u000209X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u001e\u0010>\u001a\u00020=2\u0006\u0010<\u001a\u00020=@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u000e\u0010A\u001a\u00020BX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/SendSideBandwidthEstimation;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "logger", "rttBackoff", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/RttBasedBackoff;", "linkCapacity", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LinkCapacityTracker;", "minBitrateHistory", "Ljava/util/ArrayDeque;", "Lkotlin/Pair;", "Ljava/time/Instant;", "Lorg/jitsi/nlj/util/Bandwidth;", "lostPacketsSinceLastLossUpdate", "", "expectedPacketsSinceLastLossUpdate", "acknowledgedRate", "currentTarget", "J", "lastLoggedTarget", "minBitrateConfigured", "maxBitrateConfigured", "lastLowBitrateLog", "hasDecreasedSinceLastFractionLoss", "", "lastLossFeedback", "getLastLossFeedback$annotations", "()V", "lastLossPacketReport", "lastFractionLoss", "Lkotlin/UByte;", "B", "lastLoggedFractionLoss", "lastRoundTripTime", "Ljava/time/Duration;", "receiverLimit", "delayBasedLimit", "timeLastDecrease", "firstReportTime", "initiallyLostPackets", "", "bitrateAt2Seconds", "umaUpdateState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SendSideBandwidthEstimation$UmaState;", "umaRttState", "rampupUmaStatsUpdated", "Ljava/util/ArrayList;", "lastRtcEventLog", "lowLossThreshold", "", "highLossThreshold", "bitrateThreshold", "value", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2;", "lossBasedBandwidthEstimatorV2", "getLossBasedBandwidthEstimatorV2", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedBweV2;", "lossBasedState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LossBasedState;", "onRouteChange", "", "targetRate", "targetRate-rlWvAKk", "()J", "isRttAboveLimit", "fractionLoss", "fractionLoss-w2LRezQ", "()B", "roundTripTime", "getEstimatedLinkCapacity", "getEstimatedLinkCapacity-rlWvAKk", "updateEstimate", "atTime", "onSentPacket", "sentPacket", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/SentPacket;", "updatePropagationRtt", "propagationRtt", "updateReceiverEstimate", "bandwidth", "updateReceiverEstimate-ERFH51c", "(Ljava/time/Instant;J)V", "updateDelayBasedEstimate", "bitrate", "updateDelayBasedEstimate-ERFH51c", "updatePacketsLost", "packetsLost", "numberOfPackets", "updateRtt", "rtt", "setBitrates", "sendBitrate", "minBitrate", "maxBitrate", "setBitrates-gCQKabc", "(Lorg/jitsi/nlj/util/Bandwidth;JJLjava/time/Instant;)V", "setSendBitrate", "setSendBitrate-SimD6oM", "(JLjava/time/Instant;)V", "setMinMaxBitrate", "setMinMaxBitrate-YUm52VA", "(JJ)V", "getMinBitrate", "setAcknowledgedRate", "setAcknowledgedRate-DepZXxQ", "updateLossBasedEstimator", "report", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/TransportPacketsFeedback;", "delayDetectorState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BandwidthUsage;", "probeBitrate", "inAlr", "updateLossBasedEstimator-92-q-Mk", "isInStartPhase", "updateUmaStatsPacketsLost", "updateMinHistory", "getUpperLimit", "getUpperLimit-rlWvAKk", "maybeLogLowBitrateWarning", "maybeLogLowBitrateWarning-SimD6oM", "maybeLogLossBasedEvent", "updateTargetBitrate", "updateTargetBitrate-SimD6oM", "applyTargetLimits", "UmaState", "Companion", "jitsi-media-transform"})
public final class SendSideBandwidthEstimation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    private final TimeSeriesLogger timeSeriesLogger;
    private final Logger logger;
    @NotNull
    private final RttBasedBackoff rttBackoff;
    @NotNull
    private final LinkCapacityTracker linkCapacity;
    @NotNull
    private final ArrayDeque<Pair<Instant, Bandwidth>> minBitrateHistory;
    private long lostPacketsSinceLastLossUpdate;
    private long expectedPacketsSinceLastLossUpdate;
    @Nullable
    private Bandwidth acknowledgedRate;
    private long currentTarget;
    private long lastLoggedTarget;
    private long minBitrateConfigured;
    private long maxBitrateConfigured;
    @NotNull
    private Instant lastLowBitrateLog;
    private boolean hasDecreasedSinceLastFractionLoss;
    @NotNull
    private Instant lastLossFeedback;
    @NotNull
    private Instant lastLossPacketReport;
    private byte lastFractionLoss;
    private byte lastLoggedFractionLoss;
    @NotNull
    private Duration lastRoundTripTime;
    private long receiverLimit;
    private long delayBasedLimit;
    @NotNull
    private Instant timeLastDecrease;
    @NotNull
    private Instant firstReportTime;
    private int initiallyLostPackets;
    private long bitrateAt2Seconds;
    @NotNull
    private UmaState umaUpdateState;
    @NotNull
    private UmaState umaRttState;
    @NotNull
    private final ArrayList<Boolean> rampupUmaStatsUpdated;
    @NotNull
    private Instant lastRtcEventLog;
    private final float lowLossThreshold;
    private final float highLossThreshold;
    private final long bitrateThreshold;
    @NotNull
    private LossBasedBweV2 lossBasedBandwidthEstimatorV2;
    @NotNull
    private LossBasedState lossBasedState;
    public static final boolean disableReceiverLimitCapsOnly = false;

    /*
     * WARNING - void declaration
     */
    public SendSideBandwidthEstimation(@NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        void $this$lossBasedBandwidthEstimatorV2_u24lambda_u240;
        LossBasedBweV2 lossBasedBweV2;
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        this.diagnosticContext = diagnosticContext;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.rttBackoff = new RttBasedBackoff();
        this.linkCapacity = new LinkCapacityTracker();
        this.minBitrateHistory = new ArrayDeque();
        this.currentTarget = Bandwidth.Companion.getZERO-rlWvAKk();
        this.lastLoggedTarget = Bandwidth.Companion.getZERO-rlWvAKk();
        this.minBitrateConfigured = BweDefinesKt.getKCongestionControllerMinBitrate();
        this.maxBitrateConfigured = SendSideBandwidthEstimationKt.access$getKDefaultMaxBitrate$p();
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.lastLowBitrateLog = instant;
        Instant instant2 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"MIN");
        this.lastLossFeedback = instant2;
        Instant instant3 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"MIN");
        this.lastLossPacketReport = instant3;
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.lastRoundTripTime = duration;
        this.receiverLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.delayBasedLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
        Instant instant4 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"MIN");
        this.timeLastDecrease = instant4;
        Instant instant5 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"MIN");
        this.firstReportTime = instant5;
        this.bitrateAt2Seconds = Bandwidth.Companion.getZERO-rlWvAKk();
        this.umaUpdateState = UmaState.kNoUpdate;
        this.umaRttState = UmaState.kNoUpdate;
        this.rampupUmaStatsUpdated = new ArrayList(SendSideBandwidthEstimationKt.access$getKUmaRampupMetrics$p().length);
        Instant instant6 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant6, (String)"MIN");
        this.lastRtcEventLog = instant6;
        this.lowLossThreshold = 0.02f;
        this.highLossThreshold = 0.1f;
        this.bitrateThreshold = SendSideBandwidthEstimationKt.access$getKDefaultBitrateThreshold$p();
        LossBasedBweV2 lossBasedBweV22 = lossBasedBweV2 = new LossBasedBweV2(null, 1, null);
        SendSideBandwidthEstimation sendSideBandwidthEstimation = this;
        boolean bl = false;
        $this$lossBasedBandwidthEstimatorV2_u24lambda_u240.setMinMaxBitrate-YUm52VA(this.minBitrateConfigured, this.maxBitrateConfigured);
        sendSideBandwidthEstimation.lossBasedBandwidthEstimatorV2 = lossBasedBweV2;
        this.lossBasedState = LossBasedState.kDelayBasedEstimate;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private static /* synthetic */ void getLastLossFeedback$annotations() {
    }

    @NotNull
    public final LossBasedBweV2 getLossBasedBandwidthEstimatorV2() {
        return this.lossBasedBandwidthEstimatorV2;
    }

    public final void onRouteChange() {
        this.lostPacketsSinceLastLossUpdate = 0L;
        this.expectedPacketsSinceLastLossUpdate = 0L;
        this.currentTarget = Bandwidth.Companion.getZERO-rlWvAKk();
        this.minBitrateConfigured = BweDefinesKt.getKCongestionControllerMinBitrate();
        this.maxBitrateConfigured = SendSideBandwidthEstimationKt.access$getKDefaultMaxBitrate$p();
        Instant instant = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"MIN");
        this.lastLowBitrateLog = instant;
        this.hasDecreasedSinceLastFractionLoss = false;
        Instant instant2 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"MIN");
        this.lastLossFeedback = instant2;
        Instant instant3 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"MIN");
        this.lastLossPacketReport = instant3;
        this.lastFractionLoss = 0;
        this.lastLoggedFractionLoss = 0;
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        this.lastRoundTripTime = duration;
        this.receiverLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.delayBasedLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
        Instant instant4 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"MIN");
        this.timeLastDecrease = instant4;
        Instant instant5 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"MIN");
        this.firstReportTime = instant5;
        this.initiallyLostPackets = 0;
        this.bitrateAt2Seconds = Bandwidth.Companion.getZERO-rlWvAKk();
        this.umaUpdateState = UmaState.kNoUpdate;
        this.umaRttState = UmaState.kNoUpdate;
        Instant instant6 = Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant6, (String)"MIN");
        this.lastRtcEventLog = instant6;
        if (this.lossBasedBandwidthEstimatorV2.useInStartPhase()) {
            this.lossBasedBandwidthEstimatorV2 = new LossBasedBweV2(null, 1, null);
        }
    }

    public final long targetRate-rlWvAKk() {
        long target = this.currentTarget;
        target = BandwidthKt.min-YUm52VA(target, this.receiverLimit);
        return BandwidthKt.max-YUm52VA(this.minBitrateConfigured, target);
    }

    @NotNull
    public final LossBasedState lossBasedState() {
        return this.lossBasedState;
    }

    public final boolean isRttAboveLimit() {
        return this.rttBackoff.isRttAboveLimit();
    }

    public final byte fractionLoss-w2LRezQ() {
        return this.lastFractionLoss;
    }

    @NotNull
    public final Duration roundTripTime() {
        return this.lastRoundTripTime;
    }

    public final long getEstimatedLinkCapacity-rlWvAKk() {
        return this.linkCapacity.estimate-rlWvAKk();
    }

    public final void updateEstimate(@NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        if (this.rttBackoff.isRttAboveLimit()) {
            if (Duration.between(this.timeLastDecrease, atTime).compareTo(this.rttBackoff.getDropInterval()) >= 0 && Bandwidth.compareTo-_2icLw0(this.currentTarget, this.rttBackoff.getBandwidthFloor-rlWvAKk()) > 0) {
                this.timeLastDecrease = atTime;
                long newBitrate = ((Bandwidth)RangesKt.coerceAtLeast((Comparable)Bandwidth.box-impl(Bandwidth.times-WElJv5I(this.currentTarget, this.rttBackoff.getDropFraction())), (Comparable)Bandwidth.box-impl(this.rttBackoff.getBandwidthFloor-rlWvAKk()))).unbox-impl();
                this.linkCapacity.onRttBackoff-SimD6oM(newBitrate, atTime);
                this.updateTargetBitrate-SimD6oM(newBitrate, atTime);
                return;
            }
            this.applyTargetLimits(atTime);
            return;
        }
        if (UInt.constructor-impl((int)(this.lastFractionLoss & 0xFF)) == 0 && this.isInStartPhase(atTime) && !this.lossBasedBandwidthEstimatorV2.readyToUseInStartPhase()) {
            long newBitrate = this.currentTarget;
            if (Bandwidth.isFinite-impl(this.receiverLimit)) {
                newBitrate = BandwidthKt.max-YUm52VA(this.receiverLimit, newBitrate);
            }
            if (Bandwidth.isFinite-impl(this.delayBasedLimit)) {
                newBitrate = BandwidthKt.max-YUm52VA(this.delayBasedLimit, newBitrate);
            }
            if (!Bandwidth.equals-impl0(newBitrate, this.currentTarget)) {
                this.minBitrateHistory.clear();
                this.minBitrateHistory.add((Pair<Instant, Bandwidth>)new Pair((Object)atTime, (Object)Bandwidth.box-impl(this.currentTarget)));
                this.updateTargetBitrate-SimD6oM(newBitrate, atTime);
                return;
            }
        }
        this.updateMinHistory(atTime);
        if (InstantKt.isInfinite((Instant)this.lastLossPacketReport)) {
            this.applyTargetLimits(atTime);
            return;
        }
        if (this.lossBasedBandwidthEstimatorV2.isReady()) {
            LossBasedBweV2.Result result = this.lossBasedBandwidthEstimatorV2.getLossBasedResult();
            this.lossBasedState = result.getState();
            this.updateTargetBitrate-SimD6oM(result.getBandwidthEstimate-rlWvAKk(), atTime);
            return;
        }
        Duration timeSinceLossPacketReport = Duration.between(this.lastLossPacketReport, atTime);
        if (timeSinceLossPacketReport.compareTo(DurationKt.times((double)1.2, (Duration)SendSideBandwidthEstimationKt.access$getKMaxRtcpFeedbackInterval$p())) < 0) {
            float loss = (float)UnsignedKt.uintToDouble((int)(this.lastFractionLoss & 0xFF)) / 256.0f;
            if (Bandwidth.compareTo-_2icLw0(this.currentTarget, this.bitrateThreshold) < 0 || loss <= this.lowLossThreshold) {
                long newBitrate = BandwidthKt.getBps((double)((Bandwidth)((Pair)CollectionsKt.first((Iterable)this.minBitrateHistory)).getSecond()).unbox-impl() * 1.08 + 0.5);
                newBitrate = Bandwidth.plus-GI7mN98(newBitrate, BandwidthKt.getBps(1000));
                this.updateTargetBitrate-SimD6oM(newBitrate, atTime);
                return;
            }
            if (Bandwidth.compareTo-_2icLw0(this.currentTarget, this.bitrateThreshold) > 0 && !(loss <= this.highLossThreshold) && !this.hasDecreasedSinceLastFractionLoss && Duration.between(this.timeLastDecrease, atTime).compareTo(SendSideBandwidthEstimationKt.access$getKBweDecreaseInterval$p().plus(this.lastRoundTripTime)) >= 0) {
                this.timeLastDecrease = atTime;
                long newBitrate = BandwidthKt.getBps((double)this.currentTarget * UnsignedKt.uintToDouble((int)UInt.constructor-impl((int)(512 - UInt.constructor-impl((int)(this.lastFractionLoss & 0xFF))))) / 512.0);
                this.hasDecreasedSinceLastFractionLoss = true;
                this.updateTargetBitrate-SimD6oM(newBitrate, atTime);
                return;
            }
        }
        this.applyTargetLimits(atTime);
    }

    public final void onSentPacket(@NotNull SentPacket sentPacket) {
        Intrinsics.checkNotNullParameter((Object)sentPacket, (String)"sentPacket");
        this.rttBackoff.setLastPacketSent(sentPacket.getSendTime());
    }

    public final void updatePropagationRtt(@NotNull Instant atTime, @NotNull Duration propagationRtt) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        Intrinsics.checkNotNullParameter((Object)propagationRtt, (String)"propagationRtt");
        this.rttBackoff.updatePropagationRtt(atTime, propagationRtt);
    }

    public final void updateReceiverEstimate-ERFH51c(@NotNull Instant atTime, long l) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.receiverLimit = Bandwidth.equals-impl0(l, Bandwidth.Companion.getZERO-rlWvAKk()) ? Bandwidth.Companion.getINFINITY-rlWvAKk() : l;
        this.applyTargetLimits(atTime);
    }

    public final void updateDelayBasedEstimate-ERFH51c(@NotNull Instant atTime, long l) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.linkCapacity.updateDelayBasedEstimate-ERFH51c(atTime, l);
        this.delayBasedLimit = Bandwidth.equals-impl0(l, Bandwidth.Companion.getZERO-rlWvAKk()) ? Bandwidth.Companion.getINFINITY-rlWvAKk() : l;
        this.applyTargetLimits(atTime);
    }

    public final void updatePacketsLost(long packetsLost, long numberOfPackets, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.lastLossFeedback = atTime;
        if (InstantKt.isInfinite((Instant)this.firstReportTime)) {
            this.firstReportTime = atTime;
        }
        if (numberOfPackets > 0L) {
            long expected = this.expectedPacketsSinceLastLossUpdate + numberOfPackets;
            if (expected < 20L) {
                this.expectedPacketsSinceLastLossUpdate = expected;
                this.lostPacketsSinceLastLossUpdate = packetsLost;
                return;
            }
            this.hasDecreasedSinceLastFractionLoss = false;
            long lostQ8 = RangesKt.coerceAtLeast((long)(this.lostPacketsSinceLastLossUpdate + packetsLost), (long)0L) << 8;
            this.lastFractionLoss = UByte.constructor-impl((byte)((byte)RangesKt.coerceAtMost((long)(lostQ8 / expected), (long)255L)));
            this.lostPacketsSinceLastLossUpdate = 0L;
            this.expectedPacketsSinceLastLossUpdate = 0L;
            this.lastLossPacketReport = atTime;
            this.updateEstimate(atTime);
        }
    }

    public final void updateRtt(@NotNull Duration rtt, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)rtt, (String)"rtt");
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        if (rtt.compareTo(Duration.ZERO) > 0) {
            this.lastRoundTripTime = rtt;
        }
        if (!this.isInStartPhase(atTime) && this.umaRttState == UmaState.kNoUpdate) {
            this.umaRttState = UmaState.kDone;
        }
    }

    public final void setBitrates-gCQKabc(@Nullable Bandwidth sendBitrate, long l, long l2, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.setMinMaxBitrate-YUm52VA(l, l2);
        if (sendBitrate != null) {
            this.linkCapacity.onStartingRate-_2icLw0(sendBitrate.unbox-impl());
            this.setSendBitrate-SimD6oM(sendBitrate.unbox-impl(), atTime);
        }
    }

    public final void setSendBitrate-SimD6oM(long l, @NotNull Instant atTime) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        boolean bl2 = bl = Bandwidth.compareTo-_2icLw0(l, Bandwidth.Companion.getZERO-rlWvAKk()) >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.delayBasedLimit = Bandwidth.Companion.getINFINITY-rlWvAKk();
        this.updateTargetBitrate-SimD6oM(l, atTime);
        this.minBitrateHistory.clear();
    }

    public final void setMinMaxBitrate-YUm52VA(long l, long l2) {
        this.minBitrateConfigured = BandwidthKt.max-YUm52VA(l, BweDefinesKt.getKCongestionControllerMinBitrate());
        this.maxBitrateConfigured = Bandwidth.compareTo-_2icLw0(l2, Bandwidth.Companion.getZERO-rlWvAKk()) > 0 && Bandwidth.isFinite-impl(l2) ? BandwidthKt.max-YUm52VA(this.minBitrateConfigured, l2) : SendSideBandwidthEstimationKt.access$getKDefaultMaxBitrate$p();
        this.lossBasedBandwidthEstimatorV2.setMinMaxBitrate-YUm52VA(this.minBitrateConfigured, this.maxBitrateConfigured);
    }

    public final int getMinBitrate() {
        return (int)this.minBitrateConfigured;
    }

    public final void setAcknowledgedRate-DepZXxQ(@Nullable Bandwidth acknowledgedRate, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        this.acknowledgedRate = acknowledgedRate;
        if (acknowledgedRate == null) {
            return;
        }
        this.lossBasedBandwidthEstimatorV2.setAcknowledgedBitrate-_2icLw0(acknowledgedRate.unbox-impl());
    }

    public final void updateLossBasedEstimator-92-q-Mk(@NotNull TransportPacketsFeedback report, @NotNull BandwidthUsage delayDetectorState, @Nullable Bandwidth probeBitrate, boolean inAlr) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)((Object)delayDetectorState), (String)"delayDetectorState");
        this.lossBasedBandwidthEstimatorV2.updateBandwidthEstimate-hO97Cac(report.getPacketFeedbacks(), this.delayBasedLimit, inAlr);
        this.updateEstimate(report.getFeedbackTime());
    }

    private final boolean isInStartPhase(Instant atTime) {
        return InstantKt.isInfinite((Instant)this.firstReportTime) || Duration.between(this.firstReportTime, atTime).compareTo(SendSideBandwidthEstimationKt.access$getKStartPhase$p()) <= 0;
    }

    private final void updateUmaStatsPacketsLost(Instant atTime, int packetsLost) {
        long bitrateKbps = BandwidthKt.getKbps((this.currentTarget + (long)500) / (long)1000);
        int n = SendSideBandwidthEstimationKt.access$getKUmaRampupMetrics$p().length;
        for (int i = 0; i < n; ++i) {
            if (this.rampupUmaStatsUpdated.get(i).booleanValue() || !(Bandwidth.getKbps-impl(bitrateKbps) >= (double)SendSideBandwidthEstimationKt.access$getKUmaRampupMetrics$p()[i].getBitrateKbps())) continue;
            this.rampupUmaStatsUpdated.set(i, true);
        }
        if (this.isInStartPhase(atTime)) {
            this.initiallyLostPackets += packetsLost;
        } else if (this.umaUpdateState == UmaState.kNoUpdate) {
            this.umaUpdateState = UmaState.kFirstDone;
            this.bitrateAt2Seconds = bitrateKbps;
        } else if (this.umaUpdateState == UmaState.kFirstDone && Duration.between(this.firstReportTime, atTime).compareTo(SendSideBandwidthEstimationKt.access$getKBweConverganceTime$p()) >= 0) {
            this.umaUpdateState = UmaState.kDone;
            int n2 = RangesKt.coerceAtLeast((int)((int)Bandwidth.getKbps-impl(this.bitrateAt2Seconds)), (int)0);
        }
    }

    private final void updateMinHistory(Instant atTime) {
        while (!this.minBitrateHistory.isEmpty() && Duration.between((Temporal)((Pair)CollectionsKt.first((Iterable)this.minBitrateHistory)).getFirst(), atTime).plus(DurationKt.getMs((int)1)).compareTo(SendSideBandwidthEstimationKt.access$getKBweIncreaseInterval$p()) > 0) {
            this.minBitrateHistory.removeFirst();
        }
        while (!this.minBitrateHistory.isEmpty() && Bandwidth.compareTo-_2icLw0(this.currentTarget, ((Bandwidth)((Pair)CollectionsKt.last((Iterable)this.minBitrateHistory)).getSecond()).unbox-impl()) <= 0) {
            this.minBitrateHistory.removeLast();
        }
        this.minBitrateHistory.add((Pair<Instant, Bandwidth>)new Pair((Object)atTime, (Object)Bandwidth.box-impl(this.currentTarget)));
    }

    private final long getUpperLimit-rlWvAKk() {
        long upperLimit = this.delayBasedLimit;
        return BandwidthKt.min-YUm52VA(upperLimit, this.maxBitrateConfigured);
    }

    private final void maybeLogLowBitrateWarning-SimD6oM(long l, Instant atTime) {
        if (Duration.between(this.lastLowBitrateLog, atTime).compareTo(SendSideBandwidthEstimationKt.access$getKLowBitrateLogPeriod$p()) > 0) {
            this.logger.warn((Object)("Estimated available bandwidth " + Bandwidth.toString-impl(l) + " is below configured min bitrate " + Bandwidth.toString-impl(this.minBitrateConfigured) + "."));
            this.lastLowBitrateLog = atTime;
        }
    }

    private final void maybeLogLossBasedEvent(Instant atTime) {
        if (!Bandwidth.equals-impl0(this.currentTarget, this.lastLoggedTarget) || this.lastFractionLoss != this.lastLoggedFractionLoss || Duration.between(this.lastRtcEventLog, atTime).compareTo(SendSideBandwidthEstimationKt.access$getKRtcEventLogPeriod$p()) > 0) {
            this.timeSeriesLogger.trace(() -> SendSideBandwidthEstimation.maybeLogLossBasedEvent$lambda$0(this, atTime));
            this.lastLoggedFractionLoss = this.lastFractionLoss;
            this.lastLoggedTarget = this.currentTarget;
            this.lastRtcEventLog = atTime;
        }
    }

    private final void updateTargetBitrate-SimD6oM(long l, Instant atTime) {
        long newBitrate = BandwidthKt.min-YUm52VA(l, this.getUpperLimit-rlWvAKk());
        if (Bandwidth.compareTo-_2icLw0(newBitrate, this.minBitrateConfigured) < 0) {
            this.maybeLogLowBitrateWarning-SimD6oM(newBitrate, atTime);
        }
        this.currentTarget = newBitrate;
        this.maybeLogLossBasedEvent(atTime);
        this.linkCapacity.onRateUpdate-IYc3OHo(this.acknowledgedRate, this.currentTarget, atTime);
    }

    private final void applyTargetLimits(Instant atTime) {
        this.updateTargetBitrate-SimD6oM(this.currentTarget, atTime);
    }

    private static final Map maybeLogLossBasedEvent$lambda$0(SendSideBandwidthEstimation this$0, Instant $atTime) {
        return (Map)this$0.diagnosticContext.makeTimeSeriesPoint("RtcEventBweUpdateLossBased", $atTime).addField("currentTarget", (Object)this$0.currentTarget).addField("lastFractionLoss", (Object)UByte.box-impl((byte)this$0.lastFractionLoss)).addField("expectedPacketsSinceLastLossUpdate", (Object)this$0.expectedPacketsSinceLastLossUpdate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/SendSideBandwidthEstimation$Companion;", "", "<init>", "()V", "disableReceiverLimitCapsOnly", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/SendSideBandwidthEstimation$UmaState;", "", "<init>", "(Ljava/lang/String;I)V", "kNoUpdate", "kFirstDone", "kDone", "jitsi-media-transform"})
    private static final class UmaState
    extends Enum<UmaState> {
        public static final /* enum */ UmaState kNoUpdate = new UmaState();
        public static final /* enum */ UmaState kFirstDone = new UmaState();
        public static final /* enum */ UmaState kDone = new UmaState();
        private static final /* synthetic */ UmaState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UmaState[] values() {
            return (UmaState[])$VALUES.clone();
        }

        public static UmaState valueOf(String value) {
            return Enum.valueOf(UmaState.class, value);
        }

        @NotNull
        public static EnumEntries<UmaState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = umaStateArray = new UmaState[]{UmaState.kNoUpdate, UmaState.kFirstDone, UmaState.kDone};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

