/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor.element;

import com.github.stephenc.javaisotools.loopfs.udf.UDFUtil;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;
import java.nio.charset.StandardCharsets;

public class RegId {
    public int Flags;
    public byte[] Identifier;
    public byte[] IdentifierSuffix;
    public static final int LENGTH = 32;

    public RegId(byte[] byArray) throws InvalidDescriptor {
        this.deserialize(byArray);
    }

    private void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 32) {
            throw new InvalidDescriptor("RegId allocation descriptor too short");
        }
        this.Flags = UDFUtil.getUInt8(byArray, 0);
        this.Identifier = UDFUtil.getBytes(byArray, 1, 23);
        this.IdentifierSuffix = UDFUtil.getBytes(byArray, 24, 31);
    }

    public String getId() {
        return new String(this.Identifier);
    }

    public String toString() {
        return "RegId [Flags=" + this.Flags + ", Identifier=" + new String(this.Identifier, StandardCharsets.UTF_8).trim() + ", IdentifierSuffix=" + new String(this.IdentifierSuffix, StandardCharsets.UTF_8).trim() + "]";
    }
}

