/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.core.tvshow.TvShowSettingsDefaults;
import org.tinymediamanager.thirdparty.trakttv.TvShowClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.JHintCheckBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;

class TvShowSettingsPanel
extends JPanel {
    private static final int COL_COUNT = 7;
    private final TvShowSettings settings = TvShowModuleManager.getInstance().getSettings();
    private JCheckBox chckbxImageCache;
    private JCheckBox chckbxExtractArtworkFromVsmeta;
    private JCheckBox chckbxRuntimeFromMi;
    private JCheckBox chckbxTraktTv;
    private JButton btnClearTraktTvShows;
    private JButton btnPresetKodi;
    private JButton btnPresetXbmc;
    private JButton btnPresetMediaPortal1;
    private JButton btnPresetMediaPortal2;
    private JButton btnPresetPlex;
    private JButton btnPresetJellyfin;
    private JButton btnPresetEmby;
    private JButton btnPresetMediaPig;
    private JCheckBox chckbxRenameAfterScrape;
    private JCheckBox chckbxAutoUpdateOnStart;
    private JCheckBox chckbxMetadataFromMediainfo;
    private JCheckBox chckbxTraktCollection;
    private JCheckBox chckbxTraktWatched;
    private JCheckBox chckbxTraktRating;
    private JCheckBox chckbxSpecialSeason;
    private JCheckBox chckbxCreateMissingSeasonItems;
    private JCheckBox chckbxResetNewFlag;
    private JCheckBox chckbxReadNomedia;

    TvShowSettingsPanel() {
        this.initComponents();
        this.initDataBindings();
        this.btnClearTraktTvShows.addActionListener(e -> {
            Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
            int confirm = JOptionPane.showOptionDialog(this, TmmResourceBundle.getString("Settings.trakt.cleartvshows.hint"), TmmResourceBundle.getString("Settings.trakt.cleartvshows"), 0, 3, null, options, null);
            if (confirm == 0) {
                TvShowClearTraktTvTask task = new TvShowClearTraktTvTask();
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
        });
        this.btnPresetXbmc.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForXbmc();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "XBMC"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetKodi.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForKodi();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "Kodi"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetJellyfin.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForJellyfin();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "Jellyfin"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetEmby.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForEmby();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "Emby"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetPlex.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForPlex();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "Plex"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetMediaPig.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForMediaPig();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "MediaPIG"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetMediaPortal1.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForMediaPortal();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "MediaPortal 1.x"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
        this.btnPresetMediaPortal2.addActionListener(evt -> {
            TvShowSettingsDefaults.setDefaultSettingsForMediaPortal();
            JOptionPane.showMessageDialog(MainWindow.getFrame(), TmmResourceBundle.getString("Settings.preset.message").replace("{}", "MediaPortal 2.x"), TmmResourceBundle.getString("Settings.preset"), 1);
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][15lp!][][15lp!][]"));
        JPanel panelAutomaticTasks = new JPanel();
        panelAutomaticTasks.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][15lp!][]"));
        TmmLabel lblAutomaticTasksT = new TmmLabel(TmmResourceBundle.getString("Settings.automatictasks"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelAutomaticTasks, lblAutomaticTasksT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#automatic-tasks"));
        JPanel panelPresets = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][15lp][120lp:n][15lp!][120lp:n][15lp!][120lp:n][15lp!][120lp:n][grow]", "[]"));
        TmmLabel lblPresets = new TmmLabel(TmmResourceBundle.getString("Settings.preset"), 1.16667);
        CollapsiblePanel collapsiblePanel_1 = new CollapsiblePanel((JComponent)panelPresets, lblPresets, true);
        collapsiblePanel_1.addExtraTitleComponent(new DocsButton("/tvshows/settings#media-center-presets"));
        this.add((Component)collapsiblePanel_1, "cell 0 0,growx,wmin 0");
        JLabel lblPresetHintT = new JLabel(TmmResourceBundle.getString("Settings.preset.desc"));
        panelPresets.add((Component)lblPresetHintT, "cell 1 0 7 1");
        this.btnPresetKodi = new JButton("Kodi v17+");
        panelPresets.add((Component)this.btnPresetKodi, "cell 2 1,growx");
        this.btnPresetXbmc = new JButton("XBMC/Kodi <v17");
        panelPresets.add((Component)this.btnPresetXbmc, "cell 4 1,growx");
        this.btnPresetPlex = new JButton("Plex");
        panelPresets.add((Component)this.btnPresetPlex, "cell 2 2,growx");
        this.btnPresetJellyfin = new JButton("Jellyfin");
        panelPresets.add((Component)this.btnPresetJellyfin, "cell 4 2,growx");
        this.btnPresetEmby = new JButton("Emby");
        panelPresets.add((Component)this.btnPresetEmby, "cell 6 2,growx");
        this.btnPresetMediaPig = new JButton("MediaPIG");
        panelPresets.add((Component)this.btnPresetMediaPig, "cell 8 2,growx");
        this.btnPresetMediaPortal1 = new JButton("MediaPortal 1.x");
        panelPresets.add((Component)this.btnPresetMediaPortal1, "cell 2 3,growx");
        this.btnPresetMediaPortal2 = new JButton("MediaPortal 2.x");
        panelPresets.add((Component)this.btnPresetMediaPortal2, "cell 4 3,growx");
        this.add((Component)collapsiblePanel, "cell 0 2,growx,wmin 0");
        this.chckbxRenameAfterScrape = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticrename"));
        panelAutomaticTasks.add((Component)this.chckbxRenameAfterScrape, "cell 1 0 2 1");
        JLabel lblAutomaticRenameHint = new JLabel(IconManager.HINT);
        lblAutomaticRenameHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticrename.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticRenameHint, "cell 1 0 2 1");
        this.chckbxTraktTv = new JCheckBox(TmmResourceBundle.getString("Settings.trakt"));
        panelAutomaticTasks.add((Component)this.chckbxTraktTv, "cell 1 2 2 1");
        this.btnClearTraktTvShows = new JButton(TmmResourceBundle.getString("Settings.trakt.cleartvshows"));
        panelAutomaticTasks.add((Component)this.btnClearTraktTvShows, "cell 1 2 2 1");
        this.chckbxTraktCollection = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.collection"));
        panelAutomaticTasks.add((Component)this.chckbxTraktCollection, "cell 2 3");
        this.chckbxTraktWatched = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.watched"));
        panelAutomaticTasks.add((Component)this.chckbxTraktWatched, "cell 2 4");
        this.chckbxTraktRating = new JCheckBox(TmmResourceBundle.getString("Settings.trakt.rating"));
        panelAutomaticTasks.add((Component)this.chckbxTraktRating, "cell 2 5");
        this.chckbxAutoUpdateOnStart = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.automaticupdate"));
        panelAutomaticTasks.add((Component)this.chckbxAutoUpdateOnStart, "cell 1 7 2 1");
        JLabel lblAutomaticUpdateHint = new JLabel(IconManager.HINT);
        lblAutomaticUpdateHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.automaticupdate.desc"));
        panelAutomaticTasks.add((Component)lblAutomaticUpdateHint, "cell 1 7 2 1");
        JPanel panelMisc = new JPanel();
        panelMisc.setLayout((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][16lp!][grow]", "[][][][][][][15lp!][][]"));
        TmmLabel lblMiscT = new TmmLabel(TmmResourceBundle.getString("Settings.misc"), 1.16667);
        collapsiblePanel = new CollapsiblePanel((JComponent)panelMisc, lblMiscT, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/tvshows/settings#misc-settings"));
        this.add((Component)collapsiblePanel, "cell 0 4,growx,wmin 0");
        this.chckbxResetNewFlag = new JCheckBox(TmmResourceBundle.getString("Settings.resetnewflag"));
        panelMisc.add((Component)this.chckbxResetNewFlag, "cell 1 0 2 1");
        this.chckbxReadNomedia = new JCheckBox(TmmResourceBundle.getString("Settings.nomedia"));
        panelMisc.add((Component)this.chckbxReadNomedia, "cell 1 1 2 1");
        this.chckbxMetadataFromMediainfo = new JCheckBox(TmmResourceBundle.getString("Settings.usemediainfometadata"));
        panelMisc.add((Component)this.chckbxMetadataFromMediainfo, "cell 1 2 2 1");
        this.chckbxExtractArtworkFromVsmeta = new JCheckBox(TmmResourceBundle.getString("Settings.extractartworkfromvsmeta"));
        panelMisc.add((Component)this.chckbxExtractArtworkFromVsmeta, "cell 1 3 2 1");
        this.chckbxImageCache = new JCheckBox(TmmResourceBundle.getString("Settings.imagecacheimport"));
        panelMisc.add((Component)this.chckbxImageCache, "cell 1 4 2 1");
        JLabel lblBuildImageCacheHint = new JLabel(IconManager.HINT);
        lblBuildImageCacheHint.setToolTipText(TmmResourceBundle.getString("Settings.imagecacheimporthint"));
        panelMisc.add((Component)lblBuildImageCacheHint, "cell 1 4 2 1");
        this.chckbxRuntimeFromMi = new JCheckBox(TmmResourceBundle.getString("Settings.runtimefrommediafile"));
        panelMisc.add((Component)this.chckbxRuntimeFromMi, "cell 1 5 2 1");
        this.chckbxSpecialSeason = new JCheckBox(TmmResourceBundle.getString("tvshow.renamer.specialseason"));
        panelMisc.add((Component)this.chckbxSpecialSeason, "cell 1 7 2 1");
        this.chckbxCreateMissingSeasonItems = new JCheckBox(TmmResourceBundle.getString("Settings.tvshow.writemissingitems"));
        panelMisc.add((Component)this.chckbxCreateMissingSeasonItems, "cell 1 8 2 1");
        JLabel lblCreateMissingSeasonItemsHint = new JLabel(IconManager.HINT);
        lblCreateMissingSeasonItemsHint.setToolTipText(TmmResourceBundle.getString("Settings.tvshow.writemissingitems.hint"));
        panelMisc.add((Component)lblCreateMissingSeasonItemsHint, "cell 1 8 2 1");
    }

    private <E extends ScraperMetadataConfig> void addMetadataCheckbox(JPanel panel, E config, Map<E, JCheckBox> map, GridBagConstraints gbc) {
        JCheckBox checkBox;
        if (StringUtils.isNotBlank((CharSequence)config.getToolTip())) {
            checkBox = new JHintCheckBox(config.getDescription());
            checkBox.setToolTipText(config.getToolTip());
            ((JHintCheckBox)checkBox).setHintIcon(IconManager.HINT);
        } else {
            checkBox = new JCheckBox(config.getDescription());
        }
        map.put(config, checkBox);
        if (gbc.gridx >= 7) {
            gbc.gridx = 1;
            ++gbc.gridy;
        }
        panel.add((Component)checkBox, gbc.clone());
        ++gbc.gridx;
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"syncTrakt");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty tvShowSettingsBeanProperty_5 = BeanProperty.create((String)"renameAfterScrape");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_5, (Object)this.chckbxRenameAfterScrape, (Property)jCheckBoxBeanProperty);
        autoBinding_6.bind();
        BeanProperty tvShowSettingsBeanProperty_8 = BeanProperty.create((String)"extractArtworkFromVsmeta");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_8, (Object)this.chckbxExtractArtworkFromVsmeta, (Property)jCheckBoxBeanProperty);
        autoBinding_10.bind();
        BeanProperty tvShowSettingsBeanProperty_11 = BeanProperty.create((String)"updateOnStart");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_11, (Object)this.chckbxAutoUpdateOnStart, (Property)jCheckBoxBeanProperty);
        autoBinding_11.bind();
        BeanProperty tvShowSettingsBeanProperty_9 = BeanProperty.create((String)"useMediainfoMetadata");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_9, (Object)this.chckbxMetadataFromMediainfo, (Property)jCheckBoxBeanProperty);
        autoBinding_12.bind();
        BeanProperty jCheckBoxBeanProperty_1 = BeanProperty.create((String)"enabled");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktCollection, (Property)jCheckBoxBeanProperty_1);
        autoBinding_13.bind();
        AutoBinding autoBinding_14 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktWatched, (Property)jCheckBoxBeanProperty_1);
        autoBinding_14.bind();
        AutoBinding autoBinding_15 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty, (Object)this.chckbxTraktRating, (Property)jCheckBoxBeanProperty_1);
        autoBinding_15.bind();
        BeanProperty tvShowSettingsBeanProperty_10 = BeanProperty.create((String)"syncTraktCollection");
        AutoBinding autoBinding_16 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_10, (Object)this.chckbxTraktCollection, (Property)jCheckBoxBeanProperty);
        autoBinding_16.bind();
        BeanProperty tvShowSettingsBeanProperty_12 = BeanProperty.create((String)"syncTraktWatched");
        AutoBinding autoBinding_17 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_12, (Object)this.chckbxTraktWatched, (Property)jCheckBoxBeanProperty);
        autoBinding_17.bind();
        BeanProperty tvShowSettingsBeanProperty_13 = BeanProperty.create((String)"syncTraktRating");
        AutoBinding autoBinding_18 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_13, (Object)this.chckbxTraktRating, (Property)jCheckBoxBeanProperty);
        autoBinding_18.bind();
        BeanProperty tvShowSettingsBeanProperty_1 = BeanProperty.create((String)"specialSeason");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_1, (Object)this.chckbxSpecialSeason, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty_2 = BeanProperty.create((String)"createMissingSeasonItems");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_2, (Object)this.chckbxCreateMissingSeasonItems, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty tvShowSettingsBeanProperty_3 = BeanProperty.create((String)"resetNewFlagOnUds");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_3, (Object)this.chckbxResetNewFlag, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
        BeanProperty tvShowSettingsBeanProperty_4 = BeanProperty.create((String)"runtimeFromMediaInfo");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_4, (Object)this.chckbxRuntimeFromMi, (Property)jCheckBoxBeanProperty);
        autoBinding_5.bind();
        BeanProperty tvShowSettingsBeanProperty_6 = BeanProperty.create((String)"skipFoldersWithNomedia");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty_6, (Object)this.chckbxReadNomedia, (Property)jCheckBoxBeanProperty);
        autoBinding_7.bind();
    }
}

