/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class UIUtils {
    private UIUtils() {
        throw new IllegalAccessError();
    }

    public static void fitToScreen(Rectangle r) {
        int yOverdraft;
        Rectangle screen = UIUtils.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    public static Rectangle getScreenRectangle(int x, int y) {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        if (devices.length == 1) {
            return UIUtils.getScreenRectangle(devices[0]);
        }
        Rectangle[] rectangles = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration configuration = devices[i].getDefaultConfiguration();
            Rectangle bounds = configuration.getBounds();
            rectangles[i] = UIUtils.applyInsets(bounds, UIUtils.getScreenInsets(configuration));
            if (!bounds.contains(x, y)) continue;
            return rectangles[i];
        }
        Rectangle bounds = rectangles[0];
        int minimum = UIUtils.distance(bounds, x, y);
        if (bounds.width == 0 || bounds.height == 0) {
            minimum = Integer.MAX_VALUE;
        }
        for (int i = 1; i < rectangles.length; ++i) {
            int distance;
            if (rectangles[i].width == 0 || rectangles[i].height == 0 || minimum <= (distance = UIUtils.distance(rectangles[i], x, y))) continue;
            minimum = distance;
            bounds = rectangles[i];
        }
        if (bounds.width == 0 || bounds.height == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        return bounds;
    }

    private static Rectangle getScreenRectangle(GraphicsDevice device) {
        return UIUtils.getScreenRectangle(device.getDefaultConfiguration());
    }

    public static Rectangle getScreenRectangle(GraphicsConfiguration configuration) {
        return UIUtils.applyInsets(configuration.getBounds(), UIUtils.getScreenInsets(configuration));
    }

    private static Rectangle applyInsets(Rectangle rect, Insets i) {
        rect = new Rectangle(rect);
        if (i != null) {
            rect.width -= i.left + i.right;
            rect.height -= i.top + i.bottom;
        }
        return rect;
    }

    public static Insets getScreenInsets(GraphicsConfiguration gc) {
        return UIUtils.calcInsets(gc);
    }

    private static Insets calcInsets(GraphicsConfiguration gc) {
        return Toolkit.getDefaultToolkit().getScreenInsets(gc);
    }

    private static int distance(Rectangle bounds, int x, int y) {
        x -= UIUtils.normalize(x, bounds.x, bounds.x + bounds.width);
        y -= UIUtils.normalize(y, bounds.y, bounds.y + bounds.height);
        return x * x + y * y;
    }

    private static int normalize(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }
}

