/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.panels.tvshow;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.TmmUILayoutStore;
import org.tinymediamanager.ui.components.label.PersonImageLabel;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.PersonTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;

public class TvShowCastPanel
extends JPanel {
    private final TvShowSelectionModel selectionModel;
    private final EventList<Person> crewEventList;
    private final EventList<Person> actorEventList;
    private PersonImageLabel lblCrewThumb;
    private PersonImageLabel lblActorThumb;
    private TmmTable tableCrew;
    private TmmTable tableActor;

    public TvShowCastPanel(TvShowSelectionModel model) {
        this.selectionModel = model;
        this.crewEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.actorEventList = GlazedLists.threadSafeList((EventList)new ObservableElementList((EventList)new BasicEventList(), GlazedLists.beanConnector(Person.class)));
        this.initComponents();
        this.lblActorThumb.setDesiredAspectRatio(0.6666667f);
        this.lblCrewThumb.setDesiredAspectRatio(0.6666667f);
        this.lblActorThumb.enableLightbox();
        this.lblCrewThumb.enableLightbox();
        this.lblActorThumb.setCacheUrl(true);
        this.lblCrewThumb.setCacheUrl(true);
        PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
            String property = propertyChangeEvent.getPropertyName();
            Object source = propertyChangeEvent.getSource();
            if (source.getClass() != TvShowSelectionModel.class) {
                return;
            }
            if ("selectedTvShow".equals(property)) {
                this.actorEventList.clear();
                this.actorEventList.addAll(this.selectionModel.getSelectedTvShow().getActors());
                if (!this.actorEventList.isEmpty()) {
                    this.tableActor.getSelectionModel().setSelectionInterval(0, 0);
                }
                this.crewEventList.clear();
                this.crewEventList.addAll(this.selectionModel.getSelectedTvShow().getCrew());
                if (!this.crewEventList.isEmpty()) {
                    this.tableCrew.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
        this.tableActor.getSelectionModel().addListSelectionListener(arg0 -> {
            if (!arg0.getValueIsAdjusting()) {
                int selectedRow = this.tableActor.convertRowIndexToModel(this.tableActor.getSelectedRow());
                if (selectedRow >= 0 && selectedRow < this.actorEventList.size()) {
                    Person actor = (Person)this.actorEventList.get(selectedRow);
                    this.lblActorThumb.setPerson(this.selectionModel.getSelectedTvShow(), actor);
                } else {
                    this.lblActorThumb.clearImage();
                }
            }
        });
        this.tableCrew.getSelectionModel().addListSelectionListener(arg0 -> {
            if (!arg0.getValueIsAdjusting()) {
                int selectedRow = this.tableCrew.convertRowIndexToModel(this.tableCrew.getSelectedRow());
                if (selectedRow >= 0 && selectedRow < this.crewEventList.size()) {
                    Person crewMember = (Person)this.crewEventList.get(selectedRow);
                    this.lblCrewThumb.setPerson(this.selectionModel.getSelectedTvShow(), crewMember);
                } else {
                    this.lblCrewThumb.clearImage();
                }
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[][400lp,grow][150lp,grow]", "[150lp:200lp,grow][][150lp:200lp,grow]"));
        TmmLabel lblProducersT = new TmmLabel(TmmResourceBundle.getString("metatag.crew"));
        this.add((Component)lblProducersT, "cell 0 0,aligny top");
        this.tableCrew = new PersonTable(this.crewEventList){

            @Override
            public void onPersonChanged(Person person) {
                super.onPersonChanged(person);
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().saveToDb();
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().writeNFO();
            }
        };
        this.tableCrew.setName(this.getName() + ".producerTable");
        TmmUILayoutStore.getInstance().install(this.tableCrew);
        JScrollPane scrollPanePerson = new JScrollPane();
        this.tableCrew.configureScrollPane(scrollPanePerson);
        this.add((Component)scrollPanePerson, "cell 1 0,grow");
        this.lblCrewThumb = new PersonImageLabel();
        this.add((Component)this.lblCrewThumb, "cell 2 0,growx");
        JSeparator separator = new JSeparator();
        this.add((Component)separator, "cell 0 1 3 1,growx");
        TmmLabel lblActorsT = new TmmLabel(TmmResourceBundle.getString("metatag.actors"));
        this.add((Component)lblActorsT, "cell 0 2,aligny top");
        this.tableActor = new PersonTable(this.actorEventList){

            @Override
            public void onPersonChanged(Person person) {
                super.onPersonChanged(person);
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().saveToDb();
                TvShowCastPanel.this.selectionModel.getSelectedTvShow().writeNFO();
            }
        };
        this.tableActor.setName(this.getName() + ".actorTable");
        TmmUILayoutStore.getInstance().install(this.tableActor);
        JScrollPane scrollPanePersons = new JScrollPane();
        this.tableActor.configureScrollPane(scrollPanePersons);
        this.add((Component)scrollPanePersons, "cell 1 2,grow");
        this.lblActorThumb = new PersonImageLabel();
        this.add((Component)this.lblActorThumb, "cell 2 2,growx");
    }
}

