/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Phenotype;
import io.jenetics.engine.EvolutionDurations;
import io.jenetics.engine.EvolutionResult;
import io.jenetics.stat.DoubleMomentStatistics;
import io.jenetics.stat.IntMomentStatistics;
import io.jenetics.stat.LongMomentStatistics;
import io.jenetics.stat.MinMax;
import java.text.NumberFormat;
import java.time.Duration;
import java.util.function.Consumer;

public abstract class EvolutionStatistics<C extends Comparable<? super C>, FitnessStatistics>
implements Consumer<EvolutionResult<?, C>> {
    private final DoubleMomentStatistics _selectionDuration = new DoubleMomentStatistics();
    private final DoubleMomentStatistics _alterDuration = new DoubleMomentStatistics();
    private final DoubleMomentStatistics _evaluationDuration = new DoubleMomentStatistics();
    private final DoubleMomentStatistics _evolveDuration = new DoubleMomentStatistics();
    private final IntMomentStatistics _killed = new IntMomentStatistics();
    private final IntMomentStatistics _invalids = new IntMomentStatistics();
    private final IntMomentStatistics _altered = new IntMomentStatistics();
    final LongMomentStatistics _age = new LongMomentStatistics();
    FitnessStatistics _fitness = null;
    final String cpattern = "| %22s %-51s|\n";
    final String spattern = "| %27s %-46s|\n";

    EvolutionStatistics() {
    }

    @Override
    public void accept(EvolutionResult<?, C> result) {
        this.accept(result.getDurations());
        this._killed.accept(result.getKillCount());
        this._invalids.accept(result.getInvalidCount());
        this._altered.accept(result.getAlterCount());
        result.getPopulation().forEach(pt -> this.accept((Phenotype<?, C>)pt, result.getGeneration()));
    }

    void accept(Phenotype<?, C> pt, long generation) {
        this._age.accept(pt.getAge(generation));
    }

    @Override
    private void accept(EvolutionDurations durations) {
        double selection = EvolutionStatistics.toSeconds(durations.getOffspringSelectionDuration()) + EvolutionStatistics.toSeconds(durations.getSurvivorsSelectionDuration());
        double alter = EvolutionStatistics.toSeconds(durations.getOffspringAlterDuration()) + EvolutionStatistics.toSeconds(durations.getOffspringFilterDuration());
        this._selectionDuration.accept(selection);
        this._alterDuration.accept(alter);
        this._evaluationDuration.accept(EvolutionStatistics.toSeconds(durations.getEvaluationDuration()));
        this._evolveDuration.accept(EvolutionStatistics.toSeconds(durations.getEvolveDuration()));
    }

    private static double toSeconds(Duration duration) {
        return (double)duration.toNanos() / 1.0E9;
    }

    public DoubleMomentStatistics getSelectionDuration() {
        return this._selectionDuration;
    }

    public DoubleMomentStatistics getAlterDuration() {
        return this._alterDuration;
    }

    public DoubleMomentStatistics getEvaluationDuration() {
        return this._evaluationDuration;
    }

    public DoubleMomentStatistics getEvolveDuration() {
        return this._evolveDuration;
    }

    public IntMomentStatistics getKilled() {
        return this._killed;
    }

    public IntMomentStatistics getInvalids() {
        return this._invalids;
    }

    public IntMomentStatistics getAltered() {
        return this._altered;
    }

    public LongMomentStatistics getPhenotypeAge() {
        return this._age;
    }

    public FitnessStatistics getFitness() {
        return this._fitness;
    }

    public String toString() {
        return "+---------------------------------------------------------------------------+\n|  Time statistics                                                          |\n+---------------------------------------------------------------------------+\n" + String.format("| %22s %-51s|\n", "Selection:", EvolutionStatistics.d(this._selectionDuration)) + String.format("| %22s %-51s|\n", "Altering:", EvolutionStatistics.d(this._alterDuration)) + String.format("| %22s %-51s|\n", "Fitness calculation:", EvolutionStatistics.d(this._evaluationDuration)) + String.format("| %22s %-51s|\n", "Overall execution:", EvolutionStatistics.d(this._evolveDuration)) + "+---------------------------------------------------------------------------+\n|  Evolution statistics                                                     |\n+---------------------------------------------------------------------------+\n" + String.format("| %22s %-51s|\n", "Generations:", EvolutionStatistics.i(this._altered.getCount())) + String.format("| %22s %-51s|\n", "Altered:", EvolutionStatistics.i(this._altered)) + String.format("| %22s %-51s|\n", "Killed:", EvolutionStatistics.i(this._killed)) + String.format("| %22s %-51s|\n", "Invalids:", EvolutionStatistics.i(this._invalids));
    }

    private static String d(DoubleMomentStatistics statistics) {
        return String.format("sum=%3.12f s; mean=%3.12f s", statistics.getSum(), statistics.getMean());
    }

    private static String i(IntMomentStatistics statistics) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        return String.format("sum=%s; mean=%6.9f", nf.format(statistics.getSum()), statistics.getMean());
    }

    private static String i(long value) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        return nf.format(value);
    }

    private static String p(IntMomentStatistics statistics) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        return String.format("max=%s; mean=%6.6f; var=%6.6f", nf.format(statistics.getMax()), statistics.getMean(), statistics.getVariance());
    }

    private static String p(LongMomentStatistics statistics) {
        NumberFormat nf = NumberFormat.getIntegerInstance();
        return String.format("max=%s; mean=%6.6f; var=%6.6f", nf.format(statistics.getMax()), statistics.getMean(), statistics.getVariance());
    }

    public static <C extends Comparable<? super C>> EvolutionStatistics<C, MinMax<C>> ofComparable() {
        return new Comp();
    }

    public static <N extends Number> EvolutionStatistics<N, DoubleMomentStatistics> ofNumber() {
        return new Num();
    }

    private static final class Num<N extends Number>
    extends EvolutionStatistics<N, DoubleMomentStatistics> {
        private Num() {
            this._fitness = new DoubleMomentStatistics();
        }

        @Override
        void accept(Phenotype<?, N> pt, long generation) {
            super.accept(pt, generation);
            ((DoubleMomentStatistics)this._fitness).accept(((Number)pt.getFitness()).doubleValue());
        }

        @Override
        public String toString() {
            return super.toString() + "+---------------------------------------------------------------------------+\n|  Population statistics                                                    |\n+---------------------------------------------------------------------------+\n" + String.format("| %22s %-51s|\n", "Age:", EvolutionStatistics.p(this._age)) + String.format("| %22s %-51s|\n", "Fitness:", "") + String.format("| %27s %-46s|\n", "min  =", Num.d(((DoubleMomentStatistics)this._fitness).getMin())) + String.format("| %27s %-46s|\n", "max  =", Num.d(((DoubleMomentStatistics)this._fitness).getMax())) + String.format("| %27s %-46s|\n", "mean =", Num.d(((DoubleMomentStatistics)this._fitness).getMean())) + String.format("| %27s %-46s|\n", "var  =", Num.d(((DoubleMomentStatistics)this._fitness).getVariance())) + String.format("| %27s %-46s|\n", "std  =", Num.d(Math.sqrt(((DoubleMomentStatistics)this._fitness).getVariance()))) + "+---------------------------------------------------------------------------+";
        }

        private static String d(double value) {
            return String.format("%3.12f", value);
        }
    }

    private static final class Comp<C extends Comparable<? super C>>
    extends EvolutionStatistics<C, MinMax<C>> {
        private Comp() {
            this._fitness = MinMax.of();
        }

        @Override
        public void accept(EvolutionResult<?, C> result) {
            if (((MinMax)this._fitness).getMax() == null) {
                this._fitness = MinMax.of(result.getOptimize().ascending());
            }
            super.accept(result);
        }

        @Override
        void accept(Phenotype<?, C> pt, long generation) {
            super.accept(pt, generation);
            ((MinMax)this._fitness).accept(pt.getFitness());
        }

        @Override
        public String toString() {
            return super.toString() + "+---------------------------------------------------------------------------+\n|  Population statistics                                                    |\n+---------------------------------------------------------------------------+\n" + String.format("| %22s %-51s|\n", "Age:", EvolutionStatistics.p(this._age)) + String.format("| %22s %-51s|\n", "Fitness", "") + String.format("| %27s %-46s|\n", "min =", ((MinMax)this._fitness).getMin()) + String.format("| %27s %-46s|\n", "max =", ((MinMax)this._fitness).getMax()) + "+---------------------------------------------------------------------------+";
        }
    }
}

