/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.client.MongoClient;
import org.bson.Document;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Btree Metrics")
public class BtreeIndexCounters
extends AbstractMonitor {
    public BtreeIndexCounters(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Accesses")
    public int getAccesses() {
        return this.getBtree("accesses");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Hits")
    public int getHits() {
        return this.getBtree("hits");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Misses")
    public int getMisses() {
        return this.getBtree("misses");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Resets")
    public int getResets() {
        return this.getBtree("resets");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Miss Ratio")
    public int getMissRatio() {
        return this.getBtree("missRatio");
    }

    private int getBtree(String key) {
        String message;
        Document indexCounters = (Document)this.getServerStatus().get((Object)"indexCounters");
        if (indexCounters.get((Object)"note") != null && (message = (String)indexCounters.get((Object)"note")).contains("not supported")) {
            return -1;
        }
        Document btree = (Document)indexCounters.get((Object)"btree");
        return (Integer)btree.get((Object)key);
    }
}

