/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
public enum Result {
    ALLOW,
    DEFAULT,
    DENY;


    public boolean isAllowed() {
        return this == ALLOW;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isDenied() {
        return this == DENY;
    }

    @NullMarked
    public static final class Holder {
        private Result value;

        public Holder() {
            this.set(DEFAULT);
        }

        public Holder(Result value) {
            this.set(value);
        }

        public Result get() {
            return this.value;
        }

        public void set(Result value) {
            Objects.requireNonNull(value);
            this.value = value;
        }

        public String toString() {
            return "Result.Holder{value=" + String.valueOf((Object)this.value) + "\"}";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object that) {
            if (this == that) return true;
            if (!(that instanceof Holder)) return false;
            Holder thatHolder = (Holder)that;
            if (this.value != thatHolder.value) return false;
            return true;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

