/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.opengl;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.GpuFence;
import com.mojang.blaze3d.opengl.GlBuffer;
import com.mojang.blaze3d.opengl.GlConst;
import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlFence;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPass;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.opengl.GlTextureView;
import com.mojang.blaze3d.opengl.Uniform;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.PolygonMode;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ARGB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL32;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class GlCommandEncoder
implements CommandEncoder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final GlDevice device;
    private final int readFbo;
    private final int drawFbo;
    @Nullable
    private RenderPipeline lastPipeline;
    private boolean inRenderPass;
    @Nullable
    private GlProgram lastProgram;

    protected GlCommandEncoder(GlDevice p_396674_) {
        this.device = p_396674_;
        this.readFbo = p_396674_.directStateAccess().createFrameBufferObject();
        this.drawFbo = p_396674_.directStateAccess().createFrameBufferObject();
    }

    public RenderPass createRenderPass(Supplier<String> p_407771_, GpuTextureView p_406560_, OptionalInt p_395809_) {
        return this.createRenderPass(p_407771_, p_406560_, p_395809_, null, OptionalDouble.empty());
    }

    public RenderPass createRenderPass(Supplier<String> p_406861_, GpuTextureView p_408235_, OptionalInt p_391728_, @Nullable GpuTextureView p_409576_, OptionalDouble p_395171_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        if (p_395171_.isPresent() && p_409576_ == null) {
            LOGGER.warn("Depth clear value was provided but no depth texture is being used");
        }
        if (p_408235_.isClosed()) {
            throw new IllegalStateException("Color texture is closed");
        }
        if ((p_408235_.texture().usage() & 8) == 0) {
            throw new IllegalStateException("Color texture must have USAGE_RENDER_ATTACHMENT");
        }
        if (p_408235_.texture().getDepthOrLayers() > 1) {
            throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported as an attachment");
        }
        if (p_409576_ != null) {
            if (p_409576_.isClosed()) {
                throw new IllegalStateException("Depth texture is closed");
            }
            if ((p_409576_.texture().usage() & 8) == 0) {
                throw new IllegalStateException("Depth texture must have USAGE_RENDER_ATTACHMENT");
            }
            if (p_409576_.texture().getDepthOrLayers() > 1) {
                throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported as an attachment");
            }
        }
        this.inRenderPass = true;
        this.device.debugLabels().pushDebugGroup(p_406861_);
        int i = ((GlTexture)p_408235_.texture()).getFbo(this.device.directStateAccess(), p_409576_ == null ? null : p_409576_.texture());
        GlStateManager._glBindFramebuffer(36160, i);
        int j = 0;
        if (p_391728_.isPresent()) {
            int k = p_391728_.getAsInt();
            GL11.glClearColor((float)ARGB.redFloat(k), (float)ARGB.greenFloat(k), (float)ARGB.blueFloat(k), (float)ARGB.alphaFloat(k));
            j |= 0x4000;
        }
        if (p_409576_ != null && p_395171_.isPresent()) {
            GL11.glClearDepth((double)p_395171_.getAsDouble());
            j |= 0x100;
        }
        if (j != 0) {
            GlStateManager._disableScissorTest();
            GlStateManager._depthMask(true);
            GlStateManager._colorMask(true, true, true, true);
            GlStateManager._clear(j);
        }
        GlStateManager._viewport(0, 0, p_408235_.getWidth(0), p_408235_.getHeight(0));
        this.lastPipeline = null;
        return new GlRenderPass(this, p_409576_ != null);
    }

    public void clearColorTexture(GpuTexture p_394273_, int p_393834_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        this.verifyColorTexture(p_394273_);
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, ((GlTexture)p_394273_).id, 0, 0, 36160);
        GL11.glClearColor((float)ARGB.redFloat(p_393834_), (float)ARGB.greenFloat(p_393834_), (float)ARGB.blueFloat(p_393834_), (float)ARGB.alphaFloat(p_393834_));
        GlStateManager._disableScissorTest();
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(16384);
        GlStateManager._glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
        if (p_394273_.isStencilEnabled()) {
            GlStateManager._glFramebufferTexture2D(36160, 36128, 3553, 0, 0);
        }
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    public void clearColorAndDepthTextures(GpuTexture p_393527_, int p_391700_, GpuTexture p_391582_, double p_393930_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        this.verifyColorTexture(p_393527_);
        this.verifyDepthTexture(p_391582_);
        int i = ((GlTexture)p_393527_).getFbo(this.device.directStateAccess(), p_391582_);
        GlStateManager._glBindFramebuffer(36160, i);
        GlStateManager._disableScissorTest();
        GL11.glClearDepth((double)p_393930_);
        GL11.glClearColor((float)ARGB.redFloat(p_391700_), (float)ARGB.greenFloat(p_391700_), (float)ARGB.blueFloat(p_391700_), (float)ARGB.alphaFloat(p_391700_));
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(16640);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    public void clearColorAndDepthTextures(GpuTexture p_409650_, int p_409075_, GpuTexture p_409914_, double p_409885_, int p_408011_, int p_410279_, int p_410459_, int p_409150_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        this.verifyColorTexture(p_409650_);
        this.verifyDepthTexture(p_409914_);
        this.verifyRegion(p_409650_, p_408011_, p_410279_, p_410459_, p_409150_);
        int i = ((GlTexture)p_409650_).getFbo(this.device.directStateAccess(), p_409914_);
        GlStateManager._glBindFramebuffer(36160, i);
        GlStateManager._scissorBox(p_408011_, p_410279_, p_410459_, p_409150_);
        GlStateManager._enableScissorTest();
        GL11.glClearDepth((double)p_409885_);
        GL11.glClearColor((float)ARGB.redFloat(p_409075_), (float)ARGB.greenFloat(p_409075_), (float)ARGB.blueFloat(p_409075_), (float)ARGB.alphaFloat(p_409075_));
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        GlStateManager._clear(16640);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    private void verifyRegion(GpuTexture p_407248_, int p_405805_, int p_409035_, int p_406966_, int p_407297_) {
        if (p_405805_ < 0 || p_405805_ >= p_407248_.getWidth(0)) {
            throw new IllegalArgumentException("regionX should not be outside of the texture");
        }
        if (p_409035_ < 0 || p_409035_ >= p_407248_.getHeight(0)) {
            throw new IllegalArgumentException("regionY should not be outside of the texture");
        }
        if (p_406966_ <= 0) {
            throw new IllegalArgumentException("regionWidth should be greater than 0");
        }
        if (p_405805_ + p_406966_ > p_407248_.getWidth(0)) {
            throw new IllegalArgumentException("regionWidth + regionX should be less than the texture width");
        }
        if (p_407297_ <= 0) {
            throw new IllegalArgumentException("regionHeight should be greater than 0");
        }
        if (p_409035_ + p_407297_ > p_407248_.getHeight(0)) {
            throw new IllegalArgumentException("regionWidth + regionX should be less than the texture height");
        }
    }

    public void clearDepthTexture(GpuTexture p_397307_, double p_397388_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before creating a new one!");
        }
        this.verifyDepthTexture(p_397307_);
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, 0, ((GlTexture)p_397307_).id, 0, 36160);
        GL11.glDrawBuffer((int)0);
        GL11.glClearDepth((double)p_397388_);
        GlStateManager._depthMask(true);
        GlStateManager._disableScissorTest();
        GlStateManager._clear(256);
        GL11.glDrawBuffer((int)36064);
        GlStateManager._glFramebufferTexture2D(36160, 36096, 3553, 0, 0);
        GlStateManager._glBindFramebuffer(36160, 0);
    }

    private void verifyColorTexture(GpuTexture p_409818_) {
        if (!p_409818_.getFormat().hasColorAspect()) {
            throw new IllegalStateException("Trying to clear a non-color texture as color");
        }
        if (p_409818_.isClosed()) {
            throw new IllegalStateException("Color texture is closed");
        }
        if ((p_409818_.usage() & 8) == 0) {
            throw new IllegalStateException("Color texture must have USAGE_RENDER_ATTACHMENT");
        }
        if (p_409818_.getDepthOrLayers() > 1) {
            throw new UnsupportedOperationException("Clearing a texture with multiple layers or depths is not yet supported");
        }
    }

    private void verifyDepthTexture(GpuTexture p_407968_) {
        if (!p_407968_.getFormat().hasDepthAspect()) {
            throw new IllegalStateException("Trying to clear a non-depth texture as depth");
        }
        if (p_407968_.isClosed()) {
            throw new IllegalStateException("Depth texture is closed");
        }
        if ((p_407968_.usage() & 8) == 0) {
            throw new IllegalStateException("Depth texture must have USAGE_RENDER_ATTACHMENT");
        }
        if (p_407968_.getDepthOrLayers() > 1) {
            throw new UnsupportedOperationException("Clearing a texture with multiple layers or depths is not yet supported");
        }
    }

    public void writeToBuffer(GpuBufferSlice p_405833_, ByteBuffer p_397249_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        GlBuffer glbuffer = (GlBuffer)p_405833_.buffer();
        if (glbuffer.closed) {
            throw new IllegalStateException("Buffer already closed");
        }
        if ((glbuffer.usage() & 8) == 0) {
            throw new IllegalStateException("Buffer needs USAGE_COPY_DST to be a destination for a copy");
        }
        int i = p_397249_.remaining();
        if (i > p_405833_.length()) {
            throw new IllegalArgumentException("Cannot write more data than the slice allows (attempting to write " + i + " bytes into a slice of length " + p_405833_.length() + ")");
        }
        if (p_405833_.length() + p_405833_.offset() > glbuffer.size()) {
            throw new IllegalArgumentException("Cannot write more data than this buffer can hold (attempting to write " + i + " bytes at offset " + p_405833_.offset() + " to " + glbuffer.size() + " size buffer)");
        }
        this.device.directStateAccess().bufferSubData(glbuffer.handle, p_405833_.offset(), p_397249_, glbuffer.usage());
    }

    public GpuBuffer.MappedView mapBuffer(GpuBuffer p_410372_, boolean p_409631_, boolean p_409789_) {
        return this.mapBuffer(p_410372_.slice(), p_409631_, p_409789_);
    }

    public GpuBuffer.MappedView mapBuffer(GpuBufferSlice p_410020_, boolean p_409612_, boolean p_409669_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        GlBuffer glbuffer = (GlBuffer)p_410020_.buffer();
        if (glbuffer.closed) {
            throw new IllegalStateException("Buffer already closed");
        }
        if (!p_409612_ && !p_409669_) {
            throw new IllegalArgumentException("At least read or write must be true");
        }
        if (p_409612_ && (glbuffer.usage() & 1) == 0) {
            throw new IllegalStateException("Buffer is not readable");
        }
        if (p_409669_ && (glbuffer.usage() & 2) == 0) {
            throw new IllegalStateException("Buffer is not writable");
        }
        if (p_410020_.offset() + p_410020_.length() > glbuffer.size()) {
            throw new IllegalArgumentException("Cannot map more data than this buffer can hold (attempting to map " + p_410020_.length() + " bytes at offset " + p_410020_.offset() + " from " + glbuffer.size() + " size buffer)");
        }
        int i = 0;
        if (p_409612_) {
            i |= 1;
        }
        if (p_409669_) {
            i |= 0x22;
        }
        return this.device.getBufferStorage().mapBuffer(this.device.directStateAccess(), glbuffer, p_410020_.offset(), p_410020_.length(), i);
    }

    public void copyToBuffer(GpuBufferSlice p_410810_, GpuBufferSlice p_410813_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        GlBuffer glbuffer = (GlBuffer)p_410810_.buffer();
        if (glbuffer.closed) {
            throw new IllegalStateException("Source buffer already closed");
        }
        if ((glbuffer.usage() & 0x10) == 0) {
            throw new IllegalStateException("Source buffer needs USAGE_COPY_SRC to be a source for a copy");
        }
        GlBuffer glbuffer1 = (GlBuffer)p_410813_.buffer();
        if (glbuffer1.closed) {
            throw new IllegalStateException("Target buffer already closed");
        }
        if ((glbuffer1.usage() & 8) == 0) {
            throw new IllegalStateException("Target buffer needs USAGE_COPY_DST to be a destination for a copy");
        }
        if (p_410810_.length() != p_410813_.length()) {
            throw new IllegalArgumentException("Cannot copy from slice of size " + p_410810_.length() + " to slice of size " + p_410813_.length() + ", they must be equal");
        }
        if (p_410810_.offset() + p_410810_.length() > glbuffer.size()) {
            throw new IllegalArgumentException("Cannot copy more data than the source buffer holds (attempting to copy " + p_410810_.length() + " bytes at offset " + p_410810_.offset() + " from " + glbuffer.size() + " size buffer)");
        }
        if (p_410813_.offset() + p_410813_.length() > glbuffer1.size()) {
            throw new IllegalArgumentException("Cannot copy more data than the target buffer can hold (attempting to copy " + p_410813_.length() + " bytes at offset " + p_410813_.offset() + " to " + glbuffer1.size() + " size buffer)");
        }
        this.device.directStateAccess().copyBufferSubData(glbuffer.handle, glbuffer1.handle, p_410810_.offset(), p_410813_.offset(), p_410810_.length());
    }

    public void writeToTexture(GpuTexture p_394020_, NativeImage p_396595_) {
        int i = p_394020_.getWidth(0);
        int j = p_394020_.getHeight(0);
        if (p_396595_.getWidth() != i || p_396595_.getHeight() != j) {
            throw new IllegalArgumentException("Cannot replace texture of size " + i + "x" + j + " with image of size " + p_396595_.getWidth() + "x" + p_396595_.getHeight());
        }
        if (p_394020_.isClosed()) {
            throw new IllegalStateException("Destination texture is closed");
        }
        if ((p_394020_.usage() & 1) == 0) {
            throw new IllegalStateException("Color texture must have USAGE_COPY_DST to be a destination for a write");
        }
        this.writeToTexture(p_394020_, p_396595_, 0, 0, 0, 0, i, j, 0, 0);
    }

    public void writeToTexture(GpuTexture p_395107_, NativeImage p_392321_, int p_394222_, int p_396221_, int p_392746_, int p_391501_, int p_397458_, int p_397527_, int p_392683_, int p_409501_) {
        int i;
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_394222_ >= 0 && p_394222_ < p_395107_.getMipLevels()) {
            if (p_392683_ + p_397458_ > p_392321_.getWidth() || p_409501_ + p_397527_ > p_392321_.getHeight()) {
                throw new IllegalArgumentException("Copy source (" + p_392321_.getWidth() + "x" + p_392321_.getHeight() + ") is not large enough to read a rectangle of " + p_397458_ + "x" + p_397527_ + " from " + p_392683_ + "x" + p_409501_);
            }
            if (p_392746_ + p_397458_ > p_395107_.getWidth(p_394222_) || p_391501_ + p_397527_ > p_395107_.getHeight(p_394222_)) {
                throw new IllegalArgumentException("Dest texture (" + p_397458_ + "x" + p_397527_ + ") is not large enough to write a rectangle of " + p_397458_ + "x" + p_397527_ + " at " + p_392746_ + "x" + p_391501_ + " (at mip level " + p_394222_ + ")");
            }
            if (p_395107_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
            if ((p_395107_.usage() & 1) == 0) {
                throw new IllegalStateException("Color texture must have USAGE_COPY_DST to be a destination for a write");
            }
            if (p_396221_ >= p_395107_.getDepthOrLayers()) {
                throw new UnsupportedOperationException("Depth or layer is out of range, must be >= 0 and < " + p_395107_.getDepthOrLayers());
            }
            if ((p_395107_.usage() & 0x10) != 0) {
                i = GlConst.CUBEMAP_TARGETS[p_396221_ % 6];
                GL11.glBindTexture((int)34067, (int)((GlTexture)p_395107_).id);
            } else {
                i = 3553;
                GlStateManager._bindTexture(((GlTexture)p_395107_).id);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_394222_ + ", must be >= 0 and < " + p_395107_.getMipLevels());
        }
        GlStateManager._pixelStore(3314, p_392321_.getWidth());
        GlStateManager._pixelStore(3316, p_392683_);
        GlStateManager._pixelStore(3315, p_409501_);
        GlStateManager._pixelStore(3317, p_392321_.format().components());
        GlStateManager._texSubImage2D(i, p_394222_, p_392746_, p_391501_, p_397458_, p_397527_, GlConst.toGl((NativeImage.Format)p_392321_.format()), 5121, p_392321_.getPointer());
    }

    public void writeToTexture(GpuTexture p_396389_, ByteBuffer p_428720_, NativeImage.Format p_392785_, int p_394994_, int p_395915_, int p_394993_, int p_393355_, int p_396347_, int p_408032_) {
        int i;
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_394994_ >= 0 && p_394994_ < p_396389_.getMipLevels()) {
            if (p_396347_ * p_408032_ * p_392785_.components() > p_428720_.remaining()) {
                throw new IllegalArgumentException("Copy would overrun the source buffer (remaining length of " + p_428720_.remaining() + ", but copy is " + p_396347_ + "x" + p_408032_ + " of format " + String.valueOf(p_392785_) + ")");
            }
            if (p_394993_ + p_396347_ > p_396389_.getWidth(p_394994_) || p_393355_ + p_408032_ > p_396389_.getHeight(p_394994_)) {
                throw new IllegalArgumentException("Dest texture (" + p_396389_.getWidth(p_394994_) + "x" + p_396389_.getHeight(p_394994_) + ") is not large enough to write a rectangle of " + p_396347_ + "x" + p_408032_ + " at " + p_394993_ + "x" + p_393355_);
            }
            if (p_396389_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
            if ((p_396389_.usage() & 1) == 0) {
                throw new IllegalStateException("Color texture must have USAGE_COPY_DST to be a destination for a write");
            }
            if (p_395915_ >= p_396389_.getDepthOrLayers()) {
                throw new UnsupportedOperationException("Depth or layer is out of range, must be >= 0 and < " + p_396389_.getDepthOrLayers());
            }
            if ((p_396389_.usage() & 0x10) != 0) {
                i = GlConst.CUBEMAP_TARGETS[p_395915_ % 6];
                GL11.glBindTexture((int)34067, (int)((GlTexture)p_396389_).id);
            } else {
                i = 3553;
                GlStateManager._bindTexture(((GlTexture)p_396389_).id);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel, must be >= 0 and < " + p_396389_.getMipLevels());
        }
        GlStateManager._pixelStore(3314, p_396347_);
        GlStateManager._pixelStore(3316, 0);
        GlStateManager._pixelStore(3315, 0);
        GlStateManager._pixelStore(3317, p_392785_.components());
        GlStateManager._texSubImage2D(i, p_394994_, p_394993_, p_393355_, p_396347_, p_408032_, GlConst.toGl((NativeImage.Format)p_392785_), 5121, p_428720_);
    }

    public void copyTextureToBuffer(GpuTexture p_397941_, GpuBuffer p_395918_, int p_391975_, Runnable p_397559_, int p_391607_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        this.copyTextureToBuffer(p_397941_, p_395918_, p_391975_, p_397559_, p_391607_, 0, 0, p_397941_.getWidth(p_391607_), p_397941_.getHeight(p_391607_));
    }

    public void copyTextureToBuffer(GpuTexture p_391871_, GpuBuffer p_395502_, int p_395739_, Runnable p_397589_, int p_391264_, int p_393748_, int p_396780_, int p_391271_, int p_395113_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_391264_ >= 0 && p_391264_ < p_391871_.getMipLevels()) {
            if (p_391871_.getWidth(p_391264_) * p_391871_.getHeight(p_391264_) * p_391871_.getFormat().pixelSize() + p_395739_ > p_395502_.size()) {
                throw new IllegalArgumentException("Buffer of size " + p_395502_.size() + " is not large enough to hold " + p_391271_ + "x" + p_395113_ + " pixels (" + p_391871_.getFormat().pixelSize() + " bytes each) starting from offset " + p_395739_);
            }
            if ((p_391871_.usage() & 2) == 0) {
                throw new IllegalArgumentException("Texture needs USAGE_COPY_SRC to be a source for a copy");
            }
            if ((p_395502_.usage() & 8) == 0) {
                throw new IllegalArgumentException("Buffer needs USAGE_COPY_DST to be a destination for a copy");
            }
            if (p_393748_ + p_391271_ > p_391871_.getWidth(p_391264_) || p_396780_ + p_395113_ > p_391871_.getHeight(p_391264_)) {
                throw new IllegalArgumentException("Copy source texture (" + p_391871_.getWidth(p_391264_) + "x" + p_391871_.getHeight(p_391264_) + ") is not large enough to read a rectangle of " + p_391271_ + "x" + p_395113_ + " from " + p_393748_ + "," + p_396780_);
            }
            if (p_391871_.isClosed()) {
                throw new IllegalStateException("Source texture is closed");
            }
            if (p_395502_.isClosed()) {
                throw new IllegalStateException("Destination buffer is closed");
            }
            if (p_391871_.getDepthOrLayers() > 1) {
                throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported for copying");
            }
            GlStateManager.clearGlErrors();
            this.device.directStateAccess().bindFrameBufferTextures(this.readFbo, ((GlTexture)p_391871_).glId(), 0, p_391264_, 36008);
            GlStateManager._glBindBuffer(35051, ((GlBuffer)p_395502_).handle);
            GlStateManager._pixelStore(3330, p_391271_);
            GlStateManager._readPixels(p_393748_, p_396780_, p_391271_, p_395113_, GlConst.toGlExternalId((TextureFormat)p_391871_.getFormat()), GlConst.toGlType((TextureFormat)p_391871_.getFormat()), p_395739_);
            RenderSystem.queueFencedTask((Runnable)p_397589_);
            GlStateManager._glFramebufferTexture2D(36008, 36064, 3553, 0, p_391264_);
            GlStateManager._glBindFramebuffer(36008, 0);
            GlStateManager._glBindBuffer(35051, 0);
            int i = GlStateManager._getError();
            if (i != 0) {
                throw new IllegalStateException("Couldn't perform copyTobuffer for texture " + p_391871_.getLabel() + ": GL error " + i);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_391264_ + ", must be >= 0 and < " + p_391871_.getMipLevels());
        }
    }

    public void copyTextureToTexture(GpuTexture p_394155_, GpuTexture p_394461_, int p_396176_, int p_393684_, int p_394159_, int p_394139_, int p_396698_, int p_394668_, int p_397937_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (p_396176_ >= 0 && p_396176_ < p_394155_.getMipLevels() && p_396176_ < p_394461_.getMipLevels()) {
            if (p_393684_ + p_394668_ > p_394461_.getWidth(p_396176_) || p_394159_ + p_397937_ > p_394461_.getHeight(p_396176_)) {
                throw new IllegalArgumentException("Dest texture (" + p_394461_.getWidth(p_396176_) + "x" + p_394461_.getHeight(p_396176_) + ") is not large enough to write a rectangle of " + p_394668_ + "x" + p_397937_ + " at " + p_393684_ + "x" + p_394159_);
            }
            if (p_394139_ + p_394668_ > p_394155_.getWidth(p_396176_) || p_396698_ + p_397937_ > p_394155_.getHeight(p_396176_)) {
                throw new IllegalArgumentException("Source texture (" + p_394155_.getWidth(p_396176_) + "x" + p_394155_.getHeight(p_396176_) + ") is not large enough to read a rectangle of " + p_394668_ + "x" + p_397937_ + " at " + p_394139_ + "x" + p_396698_);
            }
            if (p_394155_.isClosed()) {
                throw new IllegalStateException("Source texture is closed");
            }
            if (p_394461_.isClosed()) {
                throw new IllegalStateException("Destination texture is closed");
            }
            if ((p_394155_.usage() & 2) == 0) {
                throw new IllegalArgumentException("Texture needs USAGE_COPY_SRC to be a source for a copy");
            }
            if ((p_394461_.usage() & 1) == 0) {
                throw new IllegalArgumentException("Texture needs USAGE_COPY_DST to be a destination for a copy");
            }
            if (p_394155_.getDepthOrLayers() > 1) {
                throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported for copying");
            }
            if (p_394461_.getDepthOrLayers() > 1) {
                throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported for copying");
            }
            GlStateManager.clearGlErrors();
            GlStateManager._disableScissorTest();
            boolean flag = p_394155_.getFormat().hasDepthAspect();
            int i = ((GlTexture)p_394155_).glId();
            int j = ((GlTexture)p_394461_).glId();
            this.device.directStateAccess().bindFrameBufferTextures(this.readFbo, flag ? 0 : i, flag ? i : 0, 0, 0);
            this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, flag ? 0 : j, flag ? j : 0, 0, 0);
            this.device.directStateAccess().blitFrameBuffers(this.readFbo, this.drawFbo, p_394139_, p_396698_, p_394668_, p_397937_, p_393684_, p_394159_, p_394668_, p_397937_, flag ? 256 : 16384, 9728);
            int k = GlStateManager._getError();
            if (k != 0) {
                throw new IllegalStateException("Couldn't perform copyToTexture for texture " + p_394155_.getLabel() + " to " + p_394461_.getLabel() + ": GL error " + k);
            }
        } else {
            throw new IllegalArgumentException("Invalid mipLevel " + p_396176_ + ", must be >= 0 and < " + p_394155_.getMipLevels() + " and < " + p_394461_.getMipLevels());
        }
    }

    public void presentTexture(GpuTextureView p_406941_) {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        if (!p_406941_.texture().getFormat().hasColorAspect()) {
            throw new IllegalStateException("Cannot present a non-color texture!");
        }
        if ((p_406941_.texture().usage() & 8) == 0) {
            throw new IllegalStateException("Color texture must have USAGE_RENDER_ATTACHMENT to presented to the screen");
        }
        if (p_406941_.texture().getDepthOrLayers() > 1) {
            throw new UnsupportedOperationException("Textures with multiple depths or layers are not yet supported for presentation");
        }
        GlStateManager._disableScissorTest();
        GlStateManager._viewport(0, 0, p_406941_.getWidth(0), p_406941_.getHeight(0));
        GlStateManager._depthMask(true);
        GlStateManager._colorMask(true, true, true, true);
        this.device.directStateAccess().bindFrameBufferTextures(this.drawFbo, ((GlTexture)p_406941_.texture()).glId(), 0, 0, 0);
        this.device.directStateAccess().blitFrameBuffers(this.drawFbo, 0, 0, 0, p_406941_.getWidth(0), p_406941_.getHeight(0), 0, 0, p_406941_.getWidth(0), p_406941_.getHeight(0), 16384, 9728);
    }

    public GpuFence createFence() {
        if (this.inRenderPass) {
            throw new IllegalStateException("Close the existing render pass before performing additional commands");
        }
        return new GlFence();
    }

    protected <T> void executeDrawMultiple(GlRenderPass p_396459_, Collection<RenderPass.Draw<T>> p_398042_, @Nullable GpuBuffer p_391308_, @Nullable VertexFormat.IndexType p_395864_, Collection<String> p_407124_, T p_409520_) {
        if (this.trySetup(p_396459_, p_407124_)) {
            if (p_395864_ == null) {
                p_395864_ = VertexFormat.IndexType.SHORT;
            }
            for (RenderPass.Draw<T> draw : p_398042_) {
                BiConsumer biconsumer;
                VertexFormat.IndexType vertexformat$indextype = draw.indexType() == null ? p_395864_ : draw.indexType();
                p_396459_.setIndexBuffer(draw.indexBuffer() == null ? p_391308_ : draw.indexBuffer(), vertexformat$indextype);
                p_396459_.setVertexBuffer(draw.slot(), draw.vertexBuffer());
                if (GlRenderPass.VALIDATION) {
                    if (p_396459_.indexBuffer == null) {
                        throw new IllegalStateException("Missing index buffer");
                    }
                    if (p_396459_.indexBuffer.isClosed()) {
                        throw new IllegalStateException("Index buffer has been closed!");
                    }
                    if (p_396459_.vertexBuffers[0] == null) {
                        throw new IllegalStateException("Missing vertex buffer at slot 0");
                    }
                    if (p_396459_.vertexBuffers[0].isClosed()) {
                        throw new IllegalStateException("Vertex buffer at slot 0 has been closed!");
                    }
                }
                if ((biconsumer = draw.uniformUploaderConsumer()) != null) {
                    biconsumer.accept(p_409520_, (p_404740_, p_404741_) -> {
                        Uniform patt1$temp = p_396459_.pipeline.program().getUniform(p_404740_);
                        if (patt1$temp instanceof Uniform.Ubo) {
                            int i;
                            Uniform.Ubo $b$0 = (Uniform.Ubo)patt1$temp;
                            try {
                                int patt2$temp;
                                i = patt2$temp = $b$0.blockBinding();
                            }
                            catch (Throwable throwable) {
                                throw new MatchException(throwable.toString(), throwable);
                            }
                            GL32.glBindBufferRange((int)35345, (int)i, (int)((GlBuffer)p_404741_.buffer()).handle, (long)p_404741_.offset(), (long)p_404741_.length());
                        }
                    });
                }
                this.drawFromBuffers(p_396459_, 0, draw.firstIndex(), draw.indexCount(), vertexformat$indextype, p_396459_.pipeline, 1);
            }
        }
    }

    protected void executeDraw(GlRenderPass p_391991_, int p_395477_, int p_392599_, int p_409900_, @Nullable VertexFormat.IndexType p_391193_, int p_408977_) {
        if (this.trySetup(p_391991_, Collections.emptyList())) {
            if (GlRenderPass.VALIDATION) {
                if (p_391193_ != null) {
                    if (p_391991_.indexBuffer == null) {
                        throw new IllegalStateException("Missing index buffer");
                    }
                    if (p_391991_.indexBuffer.isClosed()) {
                        throw new IllegalStateException("Index buffer has been closed!");
                    }
                    if ((p_391991_.indexBuffer.usage() & 0x40) == 0) {
                        throw new IllegalStateException("Index buffer must have GpuBuffer.USAGE_INDEX!");
                    }
                }
                GlRenderPipeline glrenderpipeline = p_391991_.pipeline;
                if (p_391991_.vertexBuffers[0] == null && glrenderpipeline != null && !glrenderpipeline.info().getVertexFormat().getElements().isEmpty()) {
                    throw new IllegalStateException("Vertex format contains elements but vertex buffer at slot 0 is null");
                }
                if (p_391991_.vertexBuffers[0] != null && p_391991_.vertexBuffers[0].isClosed()) {
                    throw new IllegalStateException("Vertex buffer at slot 0 has been closed!");
                }
                if (p_391991_.vertexBuffers[0] != null && (p_391991_.vertexBuffers[0].usage() & 0x20) == 0) {
                    throw new IllegalStateException("Vertex buffer must have GpuBuffer.USAGE_VERTEX!");
                }
            }
            this.drawFromBuffers(p_391991_, p_395477_, p_392599_, p_409900_, p_391193_, p_391991_.pipeline, p_408977_);
        }
    }

    private void drawFromBuffers(GlRenderPass p_409055_, int p_407852_, int p_409156_, int p_406701_, @Nullable VertexFormat.IndexType p_407030_, GlRenderPipeline p_410289_, int p_409245_) {
        this.device.vertexArrayCache().bindVertexArray(p_410289_.info().getVertexFormat(), (GlBuffer)p_409055_.vertexBuffers[0]);
        if (p_407030_ != null) {
            GlStateManager._glBindBuffer(34963, ((GlBuffer)p_409055_.indexBuffer).handle);
            if (p_409245_ > 1) {
                if (p_407852_ > 0) {
                    GL32.glDrawElementsInstancedBaseVertex((int)GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), (int)p_406701_, (int)GlConst.toGl((VertexFormat.IndexType)p_407030_), (long)((long)p_409156_ * (long)p_407030_.bytes), (int)p_409245_, (int)p_407852_);
                } else {
                    GL31.glDrawElementsInstanced((int)GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), (int)p_406701_, (int)GlConst.toGl((VertexFormat.IndexType)p_407030_), (long)((long)p_409156_ * (long)p_407030_.bytes), (int)p_409245_);
                }
            } else if (p_407852_ > 0) {
                GL32.glDrawElementsBaseVertex((int)GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), (int)p_406701_, (int)GlConst.toGl((VertexFormat.IndexType)p_407030_), (long)((long)p_409156_ * (long)p_407030_.bytes), (int)p_407852_);
            } else {
                GlStateManager._drawElements(GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), p_406701_, GlConst.toGl((VertexFormat.IndexType)p_407030_), (long)p_409156_ * (long)p_407030_.bytes);
            }
        } else if (p_409245_ > 1) {
            GL31.glDrawArraysInstanced((int)GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), (int)p_407852_, (int)p_406701_, (int)p_409245_);
        } else {
            GlStateManager._drawArrays(GlConst.toGl((VertexFormat.Mode)p_410289_.info().getVertexFormatMode()), p_407852_, p_406701_);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean trySetup(GlRenderPass p_396081_, Collection<String> p_408722_) {
        if (GlRenderPass.VALIDATION) {
            if (p_396081_.pipeline == null) {
                throw new IllegalStateException("Can't draw without a render pipeline");
            }
            if (p_396081_.pipeline.program() == GlProgram.INVALID_PROGRAM) {
                throw new IllegalStateException("Pipeline contains invalid shader program");
            }
            for (RenderPipeline.UniformDescription renderpipeline$uniformdescription : p_396081_.pipeline.info().getUniforms()) {
                gpubufferslice = (GpuBufferSlice)p_396081_.uniforms.get(renderpipeline$uniformdescription.name());
                if (p_408722_.contains(renderpipeline$uniformdescription.name())) continue;
                if (gpubufferslice == null) {
                    throw new IllegalStateException("Missing uniform " + renderpipeline$uniformdescription.name() + " (should be " + String.valueOf(renderpipeline$uniformdescription.type()) + ")");
                }
                if (renderpipeline$uniformdescription.type() == UniformType.UNIFORM_BUFFER) {
                    if (gpubufferslice.buffer().isClosed()) {
                        throw new IllegalStateException("Uniform buffer " + renderpipeline$uniformdescription.name() + " is already closed");
                    }
                    if ((gpubufferslice.buffer().usage() & 128) == 0) {
                        throw new IllegalStateException("Uniform buffer " + renderpipeline$uniformdescription.name() + " must have GpuBuffer.USAGE_UNIFORM");
                    }
                }
                if (renderpipeline$uniformdescription.type() != UniformType.TEXEL_BUFFER) continue;
                if (gpubufferslice.offset() != 0 || gpubufferslice.length() != gpubufferslice.buffer().size()) {
                    throw new IllegalStateException("Uniform texel buffers do not support a slice of a buffer, must be entire buffer");
                }
                if (renderpipeline$uniformdescription.textureFormat() != null) continue;
                throw new IllegalStateException("Invalid uniform texel buffer " + renderpipeline$uniformdescription.name() + " (missing a texture format)");
            }
            for (Map.Entry entry1 : p_396081_.pipeline.program().getUniforms().entrySet()) {
                if (!(entry1.getValue() instanceof Uniform.Sampler)) continue;
                s1 = (String)entry1.getKey();
                gltextureview = (GlTextureView)p_396081_.samplers.get(s1);
                if (gltextureview == null) {
                    throw new IllegalStateException("Missing sampler " + s1);
                }
                if (gltextureview.isClosed()) {
                    throw new IllegalStateException("Sampler " + s1 + " (" + gltextureview.texture().getLabel() + ") has been closed!");
                }
                if ((gltextureview.texture().usage() & 4) != 0) continue;
                throw new IllegalStateException("Sampler " + s1 + " (" + gltextureview.texture().getLabel() + ") must have USAGE_TEXTURE_BINDING!");
            }
            if (p_396081_.pipeline.info().wantsDepthTexture() && !p_396081_.hasDepthTexture()) {
                GlCommandEncoder.LOGGER.warn("Render pipeline {} wants a depth texture but none was provided - this is probably a bug", (Object)p_396081_.pipeline.info().getLocation());
            }
        } else if (p_396081_.pipeline == null || p_396081_.pipeline.program() == GlProgram.INVALID_PROGRAM) {
            return false;
        }
        renderpipeline = p_396081_.pipeline.info();
        glprogram = p_396081_.pipeline.program();
        this.applyPipelineState(renderpipeline);
        v0 = flag1 = this.lastProgram != glprogram;
        if (flag1) {
            GlStateManager._glUseProgram(glprogram.getProgramId());
            this.lastProgram = glprogram;
        }
        block15: for (Map.Entry<K, V> entry : glprogram.getUniforms().entrySet()) {
            s = (String)entry.getKey();
            flag = p_396081_.dirtyUniforms.contains(s);
            Objects.requireNonNull((Uniform)entry.getValue());
            var11_13 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Uniform.Ubo.class, Uniform.Utb.class, Uniform.Sampler.class}, (Object)var10_12, var11_13)) {
                case 0: {
                    var12_14 = (Uniform.Ubo)var10_12;
                    k = j2 = (var14_16 = var12_14.blockBinding());
                    if (!flag) continue block15;
                    gpubufferslice1 = (GpuBufferSlice)p_396081_.uniforms.get(s);
                    GL32.glBindBufferRange((int)35345, (int)k, (int)((GlBuffer)gpubufferslice1.buffer()).handle, (long)gpubufferslice1.offset(), (long)gpubufferslice1.length());
                    break;
                }
                case 1: {
                    var15_17 = (Uniform.Utb)var10_12;
                    l = var20_22 = var15_17.location();
                    i1 = var20_22 = var15_17.samplerIndex();
                    textureformat = var20_23 = var15_17.format();
                    j1 = i2 = (var20_22 = var15_17.texture());
                    if (!flag1 && !flag) ** GOTO lbl70
                    GlStateManager._glUniform1i(l, i1);
lbl70:
                    // 2 sources

                    GlStateManager._activeTexture(33984 + i1);
                    GL11C.glBindTexture((int)35882, (int)j1);
                    if (!flag) continue block15;
                    gpubufferslice2 = (GpuBufferSlice)p_396081_.uniforms.get(s);
                    GL31.glTexBuffer((int)35882, (int)GlConst.toGlInternalId((TextureFormat)textureformat), (int)((GlBuffer)gpubufferslice2.buffer()).handle);
                    break;
                }
                case 2: {
                    var21_24 = (Uniform.Sampler)var10_12;
                    $$22 = var24_27 = var21_24.location();
                    k1 = l1 = (var24_27 = var21_24.samplerIndex());
                    gltextureview1 = (GlTextureView)p_396081_.samplers.get(s);
                    if (gltextureview1 == null) break;
                    if (flag1 || flag) {
                        GlStateManager._glUniform1i($$22, k1);
                    }
                    GlStateManager._activeTexture(33984 + k1);
                    gltexture = gltextureview1.texture();
                    if ((gltexture.usage() & 16) != 0) {
                        j = 34067;
                        GL11.glBindTexture((int)34067, (int)gltexture.id);
                    } else {
                        j = 3553;
                        GlStateManager._bindTexture(gltexture.id);
                    }
                    GlStateManager._texParameter(j, 33084, gltextureview1.baseMipLevel());
                    GlStateManager._texParameter(j, 33085, gltextureview1.baseMipLevel() + gltextureview1.mipLevels() - 1);
                    gltexture.flushModeChanges(j);
                    break;
                }
                default: {
                    throw new MatchException(null, null);
                }
            }
        }
        p_396081_.dirtyUniforms.clear();
        if (p_396081_.isScissorEnabled()) {
            GlStateManager._enableScissorTest();
            GlStateManager._scissorBox(p_396081_.getScissorX(), p_396081_.getScissorY(), p_396081_.getScissorWidth(), p_396081_.getScissorHeight());
        } else {
            GlStateManager._disableScissorTest();
        }
        return true;
        catch (Throwable var6_8) {
            throw new MatchException(var6_8.toString(), var6_8);
        }
    }

    private void applyPipelineState(RenderPipeline p_394271_) {
        if (this.lastPipeline != p_394271_) {
            this.lastPipeline = p_394271_;
            if (p_394271_.getDepthTestFunction() != DepthTestFunction.NO_DEPTH_TEST) {
                GlStateManager._enableDepthTest();
                GlStateManager._depthFunc(GlConst.toGl((DepthTestFunction)p_394271_.getDepthTestFunction()));
            } else {
                GlStateManager._disableDepthTest();
            }
            if (p_394271_.isCull()) {
                GlStateManager._enableCull();
            } else {
                GlStateManager._disableCull();
            }
            if (p_394271_.getBlendFunction().isPresent()) {
                GlStateManager._enableBlend();
                BlendFunction blendfunction = (BlendFunction)p_394271_.getBlendFunction().get();
                GlStateManager._blendFuncSeparate(GlConst.toGl((SourceFactor)blendfunction.sourceColor()), GlConst.toGl((DestFactor)blendfunction.destColor()), GlConst.toGl((SourceFactor)blendfunction.sourceAlpha()), GlConst.toGl((DestFactor)blendfunction.destAlpha()));
            } else {
                GlStateManager._disableBlend();
            }
            GlStateManager._polygonMode(1032, GlConst.toGl((PolygonMode)p_394271_.getPolygonMode()));
            GlStateManager._depthMask(p_394271_.isWriteDepth());
            GlStateManager._colorMask(p_394271_.isWriteColor(), p_394271_.isWriteColor(), p_394271_.isWriteColor(), p_394271_.isWriteAlpha());
            if (p_394271_.getDepthBiasConstant() == 0.0f && p_394271_.getDepthBiasScaleFactor() == 0.0f) {
                GlStateManager._disablePolygonOffset();
            } else {
                GlStateManager._polygonOffset(p_394271_.getDepthBiasScaleFactor(), p_394271_.getDepthBiasConstant());
                GlStateManager._enablePolygonOffset();
            }
            switch (p_394271_.getColorLogic()) {
                case NONE: {
                    GlStateManager._disableColorLogicOp();
                    break;
                }
                case OR_REVERSE: {
                    GlStateManager._enableColorLogicOp();
                    GlStateManager._logicOp(5387);
                }
            }
        }
    }

    public void finishRenderPass() {
        this.inRenderPass = false;
        GlStateManager._glBindFramebuffer(36160, 0);
        this.device.debugLabels().popDebugGroup();
    }

    protected GlDevice getDevice() {
        return this.device;
    }
}

