/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.unsafe;

import net.minecraftforge.unsafe.UnsafeHacks;

public class UnsafeFieldAccess<Owner, Type> {
    protected final long index;

    UnsafeFieldAccess(long index) {
        this.index = index;
    }

    public <I extends Owner> Type get(I instance) {
        return (Type)UnsafeHacks.theUnsafe().getObject(instance, this.index);
    }

    public <I extends Owner> void set(I instance, Type value) {
        UnsafeHacks.theUnsafe().putObject(instance, this.index, value);
    }

    public static class Bool<Owner>
    extends UnsafeFieldAccess<Owner, Boolean> {
        Bool(long index) {
            super(index);
        }

        @Override
        public <I extends Owner> Boolean get(I instance) {
            return this.getBoolean(instance);
        }

        public <I extends Owner> boolean getBoolean(I instance) {
            return UnsafeHacks.theUnsafe().getBoolean(instance, this.index);
        }

        @Override
        public <I extends Owner> void set(I instance, Boolean value) {
            this.setBoolean(instance, value);
        }

        public <I extends Owner> void setBoolean(I instance, boolean value) {
            UnsafeHacks.theUnsafe().putBoolean(instance, this.index, value);
        }
    }

    public static class Int<Owner>
    extends UnsafeFieldAccess<Owner, Integer> {
        Int(long index) {
            super(index);
        }

        @Override
        public <I extends Owner> Integer get(I instance) {
            return this.getInt(instance);
        }

        public <I extends Owner> int getInt(I instance) {
            return UnsafeHacks.theUnsafe().getInt(instance, this.index);
        }

        @Override
        public <I extends Owner> void set(I instance, Integer value) {
            this.setInt(instance, value);
        }

        public <I extends Owner> void setInt(I instance, int value) {
            UnsafeHacks.theUnsafe().putInt(instance, this.index, value);
        }
    }
}

