/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri2;

import javax.xml.namespace.QName;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.xmpp.extensions.colibri2.AbstractConferenceEntity;
import org.jitsi.xmpp.extensions.colibri2.Endpoints;

public class Colibri2Relay
extends AbstractConferenceEntity {
    public static final String ELEMENT = "relay";
    public static final QName QNAME = new QName("jitsi:colibri2", "relay");
    public static final String MESH_ID_ATTR_NAME = "mesh-id";

    public Colibri2Relay() {
        super(ELEMENT);
    }

    private Colibri2Relay(Builder b) {
        super(b, ELEMENT);
        if (b.meshId != null) {
            this.setAttribute(MESH_ID_ATTR_NAME, b.meshId);
        }
        if (b.endpoints != null) {
            this.addChildExtension(b.endpoints);
        }
    }

    @Nullable
    public String getMeshId() {
        return this.getAttributeAsString(MESH_ID_ATTR_NAME);
    }

    @Nullable
    public Endpoints getEndpoints() {
        return this.getChildExtension(Endpoints.class);
    }

    @Contract(value=" -> new")
    @NotNull
    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Provider
    extends AbstractConferenceEntity.Provider<Colibri2Relay> {
        public Provider() {
            super(Colibri2Relay.class);
        }
    }

    public static class Builder
    extends AbstractConferenceEntity.Builder {
        private String meshId;
        private Endpoints endpoints = null;

        public Builder setMeshId(String id) {
            this.meshId = id;
            return this;
        }

        public Builder setEndpoints(Endpoints e) {
            this.endpoints = e;
            return this;
        }

        private Builder() {
        }

        @Override
        @Contract(value=" -> new")
        @NotNull
        public Colibri2Relay build() {
            return new Colibri2Relay(this);
        }
    }
}

