/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.bus;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.tinymediamanager.core.bus.Event;
import org.tinymediamanager.core.bus.IEventListener;

public class EventBus {
    public static String TOPIC_MOVIES = "movies";
    public static String TOPIC_MOVIE_SETS = "movieSets";
    public static String TOPIC_TV_SHOWS = "tvShows";
    private static final EventBus INSTANCE = new EventBus();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, Set<IEventListener>> listeners = new HashMap<String, Set<IEventListener>>();
    private final Map<String, Set<Event>> events = new HashMap<String, Set<Event>>();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "event-bus"));

    private EventBus() {
    }

    public static void registerListener(String topic, IEventListener listener) {
        try {
            EventBus.INSTANCE.readWriteLock.writeLock().lock();
            Set listeners = EventBus.INSTANCE.listeners.computeIfAbsent(topic, k -> new HashSet());
            listeners.add(listener);
        }
        finally {
            EventBus.INSTANCE.readWriteLock.writeLock().unlock();
        }
    }

    public static synchronized void removeListener(String topic, IEventListener listener) {
        try {
            EventBus.INSTANCE.readWriteLock.writeLock().lock();
            Set<IEventListener> listeners = EventBus.INSTANCE.listeners.get(topic);
            if (listeners != null) {
                listeners.remove(listener);
            }
        }
        finally {
            EventBus.INSTANCE.readWriteLock.writeLock().unlock();
        }
    }

    public static void publishEvent(String topic, Event event) {
        try {
            EventBus.INSTANCE.readWriteLock.writeLock().lock();
            EventBus.INSTANCE.events.computeIfAbsent(topic, k -> new LinkedHashSet()).add(event);
            Runnable runnable = () -> {
                LinkedHashSet events = new LinkedHashSet();
                HashSet listeners = new HashSet();
                try {
                    EventBus.INSTANCE.readWriteLock.writeLock().lock();
                    Set eventsForTopic = Objects.requireNonNullElse(EventBus.INSTANCE.events.get(topic), Collections.emptySet());
                    if (!eventsForTopic.isEmpty()) {
                        events.addAll(eventsForTopic);
                        eventsForTopic.clear();
                    }
                    listeners.addAll(Objects.requireNonNullElse(EventBus.INSTANCE.listeners.get(topic), Collections.emptySet()));
                }
                finally {
                    EventBus.INSTANCE.readWriteLock.writeLock().unlock();
                }
                for (Event e : events) {
                    for (IEventListener listener : listeners) {
                        listener.processEvent(e);
                    }
                }
            };
            EventBus.INSTANCE.executor.schedule(runnable, 250L, TimeUnit.MILLISECONDS);
        }
        finally {
            EventBus.INSTANCE.readWriteLock.writeLock().unlock();
        }
    }
}

