/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowReadEpisodeNfoAction
extends TmmAction {
    public TvShowReadEpisodeNfoAction() {
        this.putValue("Name", TmmResourceBundle.getString("tvshowepisode.readnfo"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.readnfo.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        final List<TvShowEpisode> selectedEpisodes = TvShowUIModule.getInstance().getSelectionModel().getSelectedEpisodes();
        if (selectedEpisodes.isEmpty()) {
            return;
        }
        TmmTaskManager.getInstance().addUnnamedTask(new TmmTask(TmmResourceBundle.getString("tvshowepisode.readnfo"), selectedEpisodes.size(), TmmTaskHandle.TaskType.BACKGROUND_TASK){

            @Override
            protected void doInBackground() {
                int i = 0;
                for (TvShowEpisode episode : selectedEpisodes) {
                    TvShowEpisode tempEpisode;
                    block15: {
                        tempEpisode = null;
                        block5: for (MediaFile mf : episode.getMediaFiles(MediaFileType.NFO)) {
                            try {
                                List<TvShowEpisode> episodesFromNfo = TvShowEpisodeNfoParser.parseNfo(mf.getFileAsPath()).toTvShowEpisodes();
                                if (tempEpisode == null) {
                                    if (episodesFromNfo.size() == 1) {
                                        tempEpisode = episodesFromNfo.get(0);
                                        continue;
                                    }
                                    for (TvShowEpisode ep : episodesFromNfo) {
                                        if (episode.getSeason() != ep.getSeason() || episode.getEpisode() != ep.getEpisode()) continue;
                                        tempEpisode = ep;
                                        continue block5;
                                    }
                                    continue;
                                }
                                if (tempEpisode == null || episodesFromNfo.size() <= 1) continue;
                                for (TvShowEpisode ep : episodesFromNfo) {
                                    if (episode.getEpisode() <= 0 || episode.getSeason() != ep.getSeason() || episode.getEpisode() != ep.getEpisode()) continue;
                                    tempEpisode.merge(ep);
                                }
                            }
                            catch (Exception episodesFromNfo) {}
                        }
                        if (tempEpisode == null) {
                            MediaFile vid = episode.getMainVideoFile();
                            Object name = vid.getFilenameWithoutStacking();
                            name = FilenameUtils.getBaseName((String)name) + ".nfo";
                            Path nfo = vid.getFileAsPath().getParent().resolve((String)name);
                            if (Files.exists(nfo, new LinkOption[0])) {
                                try {
                                    episode.addToMediaFiles(new MediaFile(nfo));
                                    List<TvShowEpisode> episodesFromNfo = TvShowEpisodeNfoParser.parseNfo(nfo).toTvShowEpisodes();
                                    if (episodesFromNfo.size() == 1) {
                                        tempEpisode = episodesFromNfo.get(0);
                                        break block15;
                                    }
                                    for (TvShowEpisode ep : episodesFromNfo) {
                                        if (episode.getSeason() != ep.getSeason() || episode.getEpisode() != ep.getEpisode()) continue;
                                        tempEpisode = ep;
                                        break;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    if (tempEpisode != null) {
                        episode.forceMerge(tempEpisode);
                        episode.saveToDb();
                    }
                    this.publishState(++i);
                    if (!this.cancel) continue;
                    break;
                }
            }
        });
    }
}

