/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractBoundedChromosome;
import io.jenetics.IntegerGene;
import io.jenetics.NumericChromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.reflect;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IntegerChromosome
extends AbstractBoundedChromosome<Integer, IntegerGene>
implements NumericChromosome<Integer, IntegerGene>,
Serializable {
    private static final long serialVersionUID = 2L;

    protected IntegerChromosome(ISeq<IntegerGene> genes, IntRange lengthRange) {
        super(genes, lengthRange);
    }

    public IntegerChromosome(Integer min, Integer max, IntRange lengthRange) {
        this(IntegerGene.seq(min, max, lengthRange), lengthRange);
        this._valid = true;
    }

    public IntegerChromosome(Integer min, Integer max, int length) {
        this(min, max, IntRange.of(length));
    }

    public IntegerChromosome(Integer min, Integer max) {
        this(min, max, 1);
    }

    public int[] toArray(int[] array2) {
        int[] a = array2.length >= this.length() ? array2 : new int[this.length()];
        int i = this.length();
        while (--i >= 0) {
            a[i] = this.intValue(i);
        }
        return a;
    }

    public int[] toArray() {
        return this.toArray(new int[this.length()]);
    }

    public static IntegerChromosome of(IntegerGene ... genes) {
        return new IntegerChromosome(ISeq.of(genes), IntRange.of(genes.length));
    }

    public static IntegerChromosome of(int min, int max, IntRange lengthRange) {
        return new IntegerChromosome((Integer)min, (Integer)max, lengthRange);
    }

    public static IntegerChromosome of(int min, int max, int length) {
        return new IntegerChromosome((Integer)min, (Integer)max, length);
    }

    public static IntegerChromosome of(IntRange range, IntRange lengthRange) {
        return new IntegerChromosome((Integer)range.getMin(), (Integer)range.getMax(), lengthRange);
    }

    public static IntegerChromosome of(IntRange range, int length) {
        return new IntegerChromosome((Integer)range.getMin(), (Integer)range.getMax(), length);
    }

    public static IntegerChromosome of(int min, int max) {
        return new IntegerChromosome(min, max);
    }

    public static IntegerChromosome of(IntRange range) {
        return new IntegerChromosome(range.getMin(), range.getMax());
    }

    public IntegerChromosome newInstance(ISeq<IntegerGene> genes) {
        return new IntegerChromosome(genes, this.lengthRange());
    }

    @Override
    public IntegerChromosome newInstance() {
        return new IntegerChromosome((Integer)this._min, (Integer)this._max, this.lengthRange());
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this.lengthRange());
        out.writeInt((Integer)this._min);
        out.writeInt((Integer)this._max);
        for (IntegerGene gene : this._genes) {
            out.writeInt((Integer)gene.getAllele());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        MSeq<IntegerGene> genes = MSeq.ofLength(in.readInt());
        reflect.setField(this, "_lengthRange", in.readObject());
        reflect.setField(this, "_min", in.readInt());
        reflect.setField(this, "_max", in.readInt());
        for (int i = 0; i < genes.length(); ++i) {
            genes.set(i, new IntegerGene(in.readInt(), (Integer)this._min, (Integer)this._max));
        }
        reflect.setField(this, "_genes", genes.toISeq());
    }
}

