/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractAlterer;
import io.jenetics.AltererResult;
import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.MutatorResult;
import io.jenetics.Phenotype;
import io.jenetics.internal.math.probability;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Random;

public class Mutator<G extends Gene<?, G>, C extends Comparable<? super C>>
extends AbstractAlterer<G, C> {
    public Mutator(double probability2) {
        super(probability2);
    }

    public Mutator() {
        this(0.01);
    }

    @Override
    public AltererResult<G, C> alter(Seq<Phenotype<G, C>> population, long generation) {
        assert (population != null) : "Not null is guaranteed from base class.";
        Random random2 = RandomRegistry.getRandom();
        double p = Math.pow(this._probability, 0.3333333333333333);
        int P = probability.toInt(p);
        Seq<MutatorResult> result = population.map(pt -> random2.nextInt() < P ? this.mutate((Phenotype<G, C>)pt, generation, p, random2) : MutatorResult.of(pt));
        return AltererResult.of(result.map(MutatorResult::getResult).asISeq(), result.stream().mapToInt(MutatorResult::getMutations).sum());
    }

    protected MutatorResult<Phenotype<G, C>> mutate(Phenotype<G, C> phenotype, long generation, double p, Random random2) {
        return this.mutate(phenotype.getGenotype(), p, random2).map(gt -> phenotype.newInstance((Genotype)gt, generation));
    }

    protected MutatorResult<Genotype<G>> mutate(Genotype<G> genotype, double p, Random random2) {
        int P = probability.toInt(p);
        Seq result = genotype.toSeq().map(gt -> random2.nextInt() < P ? this.mutate((Chromosome<G>)gt, p, random2) : MutatorResult.of(gt));
        return MutatorResult.of(Genotype.of(result.map(MutatorResult::getResult)), result.stream().mapToInt(MutatorResult::getMutations).sum());
    }

    protected MutatorResult<Chromosome<G>> mutate(Chromosome<G> chromosome, double p, Random random2) {
        int P = probability.toInt(p);
        Seq result = chromosome.toSeq().map(gene -> random2.nextInt() < P ? MutatorResult.of(this.mutate(gene, random2), 1) : MutatorResult.of(gene));
        return MutatorResult.of(chromosome.newInstance((ISeq<G>)result.map(MutatorResult::getResult)), result.stream().mapToInt(MutatorResult::getMutations).sum());
    }

    protected G mutate(G gene, Random random2) {
        return (G)gene.newInstance();
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

